/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.client.AbstractInvBalanceConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InvBalanceConditionUI
extends AbstractInvBalanceConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(InvBalanceConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.cal.CalCommonResource";
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private CompanyOrgUnitInfo curCompany = null;
    private boolean isSetCustomCondition = false;
    private boolean firstLoad = true;

    public InvBalanceConditionUI() throws Exception {
        this.setFilterElements();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.addListener();
        this.ckGroupBy.setSelected(false);
        this.ckCompareBil.setEnabled(true);
        this.ckCompareBil.setSelected(false);
        this.ckCompareBil.setEnabled(false);
        this.ckOnlyShowErrorRow.setSelected(false);
        this.ckOnlyShowErrorRow.setEnabled(false);
        this.bizCompanyOrg.setEnabledMultiSelection(false);
        this.bizWarehouseFrom.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.bizWarehouseTo.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.bizWarehouseFrom.setEnabledMultiSelection(true);
        CalculateClientUtil.addListenerForMultiF7(this.bizWarehouseFrom, this.bizWarehouseTo);
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    private void setFilterElements() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        this.bizCompanyOrg.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
        SingleFilterElement mainOrgElement = new SingleFilterElement("bizCompanyOrg", (Component)this.bizCompanyOrg);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("spAccPeriodYear", (Component)this.spAccPeriodYear));
        elements.add((FilterElement)new SingleFilterElement("spAccPeriodMonth", (Component)this.spAccPeriodMonth));
        elements.add((FilterElement)new SingleFilterElement("spAccPeriodYearTo", (Component)this.spAccPeriodYearTo));
        elements.add((FilterElement)new SingleFilterElement("spAccPeriodMonthTo", (Component)this.spAccPeriodMonthTo));
        elements.add((FilterElement)new MultiF7FilterElement("bizMaterialFrom", this.bizMaterialFrom, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("bizMaterialTo", (Component)this.bizMaterialTo));
        elements.add((FilterElement)new MultiF7FilterElement("bizWarehouseFrom", this.bizWarehouseFrom, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("bizWarehouseTo", (Component)this.bizWarehouseTo));
        elements.add((FilterElement)new SingleFilterElement("bizAssPropFrom", (Component)this.bizAssPropFrom));
        elements.add((FilterElement)new SingleFilterElement("bizAssPropFrom", (Component)this.bizAssPropFrom));
        elements.add((FilterElement)new SingleFilterElement("bizAssPropTo", (Component)this.bizAssPropTo));
        elements.add((FilterElement)new SingleFilterElement("bizLocationFrom", (Component)this.bizLocationFrom));
        elements.add((FilterElement)new SingleFilterElement("bizLocationTo", (Component)this.bizLocationTo));
        elements.add((FilterElement)new SingleFilterElement("txtLotFrom", (Component)this.txtLotFrom));
        elements.add((FilterElement)new SingleFilterElement("txtLotTo", (Component)this.txtLotTo));
        elements.add((FilterElement)new SingleFilterElement("ckShowNoCalculate", (Component)this.ckShowNoCalculate));
        elements.add((FilterElement)new SingleFilterElement("ckGroupBy", (Component)this.ckGroupBy));
        elements.add((FilterElement)new SingleFilterElement("ckShowAllCol", (Component)this.ckShowAllCol));
        elements.add((FilterElement)new SingleFilterElement("ckCompareBil", (Component)this.ckCompareBil));
        elements.add((FilterElement)new SingleFilterElement("ckOnlyShowErrorRow", (Component)this.ckOnlyShowErrorRow));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "company.id");
    }

    private void setF7Filter() throws Exception {
        this.bizMaterialFrom.setCommitParser(null);
        this.bizMaterialTo.setCommitParser(null);
        this.setBizMaterialF7(this.bizMaterialFrom, true, null);
        this.setBizMaterialF7(this.bizMaterialTo, false, null);
        CalculateClientUtil.addListenerForMultiF7(this.bizMaterialFrom, this.bizMaterialTo);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialFrom, this.bizMaterialTo});
    }

    protected String getPropertyOfMainBizOrg() {
        return "companyOrgUnit.id";
    }

    private void addListener() {
        this.ckGroupBy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InvBalanceConditionUI.this.ckGroupBy_stateChanged(e);
                }
                catch (Exception exc) {
                    InvBalanceConditionUI.this.handUIException(exc);
                }
            }
        });
        this.ckCompareBil.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InvBalanceConditionUI.this.ckCompareBil_stateChanged(e);
                }
                catch (Exception exc) {
                    InvBalanceConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckGroupBy_stateChanged(ChangeEvent e) {
        if (this.ckGroupBy.isSelected()) {
            this.ckCompareBil.setEnabled(true);
        } else {
            this.ckCompareBil.setSelected(false);
            this.ckCompareBil.setEnabled(false);
        }
    }

    protected void ckCompareBil_stateChanged(ChangeEvent e) {
        if (this.ckCompareBil.isSelected()) {
            this.ckOnlyShowErrorRow.setEnabled(true);
        } else {
            this.ckOnlyShowErrorRow.setSelected(false);
            this.ckOnlyShowErrorRow.setEnabled(false);
        }
    }

    public void afterMainOrgChanged(String ids) {
        if (!this.isSetCustomCondition) {
            super.afterMainOrgChanged(ids);
            try {
                CalculateUtil.loadAccountPeriod(this.bizCompanyOrg, this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo);
            }
            catch (EASBizException e) {
                if (this.firstLoad) {
                    this.firstLoad = false;
                } else {
                    this.handUIException(e);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.bizWarehouseFrom.setValue(null);
            this.bizWarehouseTo.setValue(null);
        }
        try {
            CalculateClientUtil.setWareHouseEntity(this.bizCompanyOrg, null, this.bizWarehouseFrom, true);
            CalculateClientUtil.setWareHouseEntity(this.bizCompanyOrg, null, this.bizWarehouseTo, true);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizCompanyOrg;
    }

    protected String getViewPermission() {
        return "invbalanceui_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.bizCompanyOrg.getText() == null || this.bizCompanyOrg.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spAccPeriodYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spAccPeriodMonth.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spAccPeriodYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spAccPeriodMonthTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.isSetCustomCondition = true;
        super.loadData(entityViewInfo);
        this.isSetCustomCondition = false;
    }

    protected void setDefaultValue() {
        this.ckShowNoCalculate.setSelected(false);
        this.ckGroupBy.setSelected(false);
        this.ckShowAllCol.setSelected(false);
        this.ckCompareBil.setSelected(false);
        this.ckOnlyShowErrorRow.setSelected(false);
    }
}

