/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.scm.cal.InvCKAccountBCCDetailFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractInvCkAccountBCCDetailUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InvCkAccountBCCDetailUI
extends AbstractInvCkAccountBCCDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(InvCkAccountBCCDetailUI.class);
    private int currRow = -1;
    private int currCol = -1;
    private final int BILL = 0;
    private final int TEMPVOUCHER = 1;
    private final int PURINVOUCHER = 2;
    private final int DISCHAGVOUCHER = 3;
    private int amtPrecision = 2;
    private KDTable table = null;
    private String dischargeType = "1";

    public InvCkAccountBCCDetailUI() throws Exception {
        this.tblPur.setEditable(false);
        this.tblDischg.setEditable(false);
        this.tblMain.setEditable(false);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblDischg.checkParsed();
        this.tblPur.checkParsed();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("BillNumber").getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("VoucherNumber").getStyleAttributes().setWrapText(true);
        this.tblDischg.getColumn("BillNumber").getStyleAttributes().setWrapText(true);
        this.tblDischg.getColumn("VoucherNumber").getStyleAttributes().setWrapText(true);
        this.tblPur.getColumn("BillNumber").getStyleAttributes().setWrapText(true);
        this.tblPur.getColumn("VoucherNumber").getStyleAttributes().setWrapText(true);
        this.initFootManager(this.tblMain);
        this.initFootManager(this.tblDischg);
        this.initFootManager(this.tblPur);
        this.table = this.tblMain;
    }

    protected void init() throws Exception {
        super.init();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        if (companyOrgUnitInfo.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
            this.amtPrecision = baseCurrInfo.getPrecision();
        }
        this.initUIMainOrgContext(companyOrgUnitInfo.getId().toString());
        this.dischargeType = this.params.getString("dischargeType");
        if ("1".equals(this.dischargeType)) {
            String[] fields = new String[]{"billPeriod", "BillTypeName", "BillNumber", "tempAmount", "VoucherNumber", "DiffAmount"};
            this.setColumnVisible(fields, true);
        }
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int i;
        int from = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        BigDecimal diffAmount = null;
        for (i = from; i <= last; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null || (diffAmount = (BigDecimal)row.getCell("TempDiffAmount").getValue()) == null || BigDecimal.ZERO.compareTo(diffAmount) == 0) continue;
            row.getCell("TempDiffAmount").getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
        for (i = 0; i <= this.tblPur.getRowCount3(); ++i) {
            row = this.tblPur.getRow(i);
            if (row == null || (diffAmount = (BigDecimal)row.getCell("PurDiffAmount").getValue()) == null || BigDecimal.ZERO.compareTo(diffAmount) == 0) continue;
            row.getCell("PurDiffAmount").getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
        for (i = 0; i <= this.tblDischg.getRowCount3(); ++i) {
            row = this.tblDischg.getRow(i);
            if (row == null || (diffAmount = (BigDecimal)row.getCell("DischgDiffAmount").getValue()) == null || BigDecimal.ZERO.compareTo(diffAmount) == 0) continue;
            row.getCell("DischgDiffAmount").getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
    }

    private void initFootManager(KDTable tbl) {
        IRow footRow = null;
        KDTFootManager footRowManager = tbl.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(tbl);
            footRowManager.addFootView();
            tbl.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            tbl.getIndexColumn().setWidthAdjustMode((short)1);
            tbl.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        }
    }

    protected void appendFootRow(BigDecimal totalTempAmt, BigDecimal totalVoucherAmt, BigDecimal totalDiffAmt, KDTable tbl) {
        IRow footRow = null;
        KDTFootManager footRowManager = tbl.getFootManager();
        if (footRowManager == null) {
            return;
        }
        footRow = footRowManager.getFootRow(0);
        String fmtStr = SCMClientUtils.getFormatPattern((int)this.amtPrecision);
        this.addFootCell(footRow, "tempAmount", totalTempAmt, fmtStr);
        this.addFootCell(footRow, "VoucherAmount", totalVoucherAmt, fmtStr);
        this.addFootCell(footRow, "DiffAmount", totalDiffAmt, fmtStr);
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    private void addFootCell(IRow footRow, String fieldName, BigDecimal value, String fmtStr) {
        ICell cell = footRow.getCell(fieldName);
        cell.getStyleAttributes().setNumberFormat(fmtStr);
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
        cell.getStyleAttributes().setFontColor(Color.BLACK);
        cell.setValue((Object)value);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                InvCkAccountBCCDetailUI.this.currRow = e.getRowIndex();
                InvCkAccountBCCDetailUI.this.currCol = e.getColIndex();
                if (e.getClickCount() == 2) {
                    InvCkAccountBCCDetailUI.this.tbl_tableClicked(e);
                }
            }
        });
        this.tblDischg.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                InvCkAccountBCCDetailUI.this.currRow = e.getRowIndex();
                InvCkAccountBCCDetailUI.this.currCol = e.getColIndex();
                if (e.getClickCount() == 2) {
                    InvCkAccountBCCDetailUI.this.tbl_tableClicked(e);
                }
            }
        });
        this.tblPur.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                InvCkAccountBCCDetailUI.this.currRow = e.getRowIndex();
                InvCkAccountBCCDetailUI.this.currCol = e.getColIndex();
                if (e.getClickCount() == 2) {
                    InvCkAccountBCCDetailUI.this.tbl_tableClicked(e);
                }
            }
        });
        this.tabPanelVoucher.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InvCkAccountBCCDetailUI.this.table = (KDTable)InvCkAccountBCCDetailUI.this.tabPanelVoucher.getSelectedComponent();
                KDTSelectBlock kdtSelectBlock = InvCkAccountBCCDetailUI.this.table.getSelectManager().get();
                if (kdtSelectBlock == null) {
                    InvCkAccountBCCDetailUI.this.currRow = -1;
                    InvCkAccountBCCDetailUI.this.currCol = -1;
                } else {
                    InvCkAccountBCCDetailUI.this.currRow = kdtSelectBlock.getBeginRow();
                    InvCkAccountBCCDetailUI.this.currCol = kdtSelectBlock.getBeginCol();
                }
            }
        });
    }

    protected void tbl_tableClicked(KDTMouseEvent e) {
        ActionEvent evt = new ActionEvent(this.btnBillView, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    private void setMergeColumn(String[] mergeColumnKeys, KDTable tbl) {
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            int i;
            for (i = 0; i < mergeColumnKeys.length; ++i) {
                tbl.getColumn(mergeColumnKeys[i]).setGroup(true);
                tbl.getColumn(mergeColumnKeys[i]).setMergeable(true);
                tbl.getColumn(mergeColumnKeys[i]).getKDTColumn().getGroupBlockList().clear();
            }
            tbl.getGroupManager().group();
            for (i = 0; i < mergeColumnKeys.length; ++i) {
                tbl.getColumn(mergeColumnKeys[i]).setGroup(false);
                tbl.getColumn(mergeColumnKeys[i]).setMergeable(false);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setGroup();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        int year = this.params.getInt("Year");
        int period = this.params.getInt("Period");
        String actNumber = this.params.getString("ActNumber");
        String actName = this.params.getString("ActName");
        this.txtCompany.setText(companyOrgUnitInfo.getNumber());
        this.txtCompName.setText(companyOrgUnitInfo.getName());
        this.txtAccount.setText(actNumber);
        this.txtAcctName.setText(actName);
        this.txtPeriod.setText(year + "." + period);
    }

    private void setGroup() {
        this.tblMain.getGroupManager().removeGroup();
        this.tblDischg.getGroupManager().removeGroup();
        this.tblPur.getGroupManager().removeGroup();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        this.tblDischg.removeRows();
        this.tblPur.removeRows();
        RptParams result = null;
        try {
            this.params.setString("tempTable", this.getTempTable());
            result = this.getRemoteInstance().createTempTable(this.params);
            BigDecimal disAmt = result.getBigDecimal("disAmt");
            this.setTempTable(result.getString("tempTable"));
            logger.error((Object)("==========\u672c\u6b21\u67e5\u8be2\u7684\u4e34\u65f6\u8868\uff1a" + result.getString("tempTable")));
            this.params.setString("tempTable", result.getString("tempTable"));
            this.params.setString("billDisTable", result.getString("billDisTable"));
            this.params.setString("billPurTable", result.getString("billPurTable"));
            result = this.getRemoteInstance().query(this.params);
            RptRowSet rs = (RptRowSet)result.getObject("rowset");
            Map<Set<String>, Set<String>> billVoucherMap = this.getBillVoucherNumberSetMap(rs);
            this.tblMain.setRowCount(billVoucherMap.size());
            List<BillVoucherInfo> billVoucherList = this.calculateBillVoucherAmt(rs, billVoucherMap);
            this.insertRows(billVoucherList, this.tblMain);
            if ("1".equals(this.dischargeType)) {
                if (disAmt == null) {
                    disAmt = BigDecimal.ZERO;
                }
                IRow row = this.tblDischg.addRow();
                row.getCell("VoucherAmount").setValue((Object)disAmt);
            } else {
                rs = (RptRowSet)result.getObject("disRowSet");
                billVoucherMap = this.getBillVoucherNumberSetMap(rs);
                this.tblDischg.setRowCount(billVoucherMap.size());
                billVoucherList = this.calculateBillVoucherAmt(rs, billVoucherMap);
                this.insertRows(billVoucherList, this.tblDischg);
            }
            rs = (RptRowSet)result.getObject("purRowSet");
            billVoucherMap = this.getBillVoucherNumberSetMap(rs);
            this.tblPur.setRowCount(billVoucherMap.size());
            billVoucherList = this.calculateBillVoucherAmt(rs, billVoucherMap);
            this.insertRows(billVoucherList, this.tblPur);
            if ("1".equals(this.dischargeType)) {
                this.setMergeColumn(new String[]{"VoucherAmount"}, this.tblDischg);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void insertRows(List<BillVoucherInfo> billVoucherList, KDTable tbl) {
        BillVoucherInfo bVoucherInfo = null;
        IRow row = null;
        Boolean isShowException = this.params.getBoolean("isShowException");
        BigDecimal totalTempAmt = BigDecimal.ZERO;
        BigDecimal totalVoucherAmt = BigDecimal.ZERO;
        BigDecimal totalDifAmt = BigDecimal.ZERO;
        for (int i = 0; i < billVoucherList.size(); ++i) {
            bVoucherInfo = billVoucherList.get(i);
            if (isShowException.booleanValue() && (bVoucherInfo.getFDifAmt() == null || bVoucherInfo.getFDifAmt().compareTo(BigDecimal.ZERO) == 0)) continue;
            row = tbl.addRow();
            if (bVoucherInfo.getRowHeigth() > 0) {
                row.setHeight(bVoucherInfo.getRowHeigth());
            }
            row.getCell("billPeriod").setValue((Object)bVoucherInfo.getFBillPeriod());
            row.getCell("BillTypeID").setValue((Object)bVoucherInfo.getFBillTypeID());
            row.getCell("BillTypeName").setValue((Object)bVoucherInfo.getFBillTypeName());
            row.getCell("BillID").setValue((Object)bVoucherInfo.getFBillID());
            row.getCell("BillNumber").setValue((Object)bVoucherInfo.getFBillNumber());
            row.getCell("tempAmount").setValue((Object)bVoucherInfo.getFTempAmount());
            row.getCell("VoucherID").setValue((Object)bVoucherInfo.getFVoucherID());
            row.getCell("VoucherNumber").setValue((Object)bVoucherInfo.getFVoucherNumber());
            row.getCell("VoucherAmount").setValue((Object)bVoucherInfo.getFVoucherAmt());
            row.getCell("DiffAmount").setValue((Object)bVoucherInfo.getFDifAmt());
            if (bVoucherInfo.getFDifAmt() != null && bVoucherInfo.getFDifAmt().compareTo(BigDecimal.ZERO) != 0) {
                row.getCell("DiffAmount").getStyleAttributes().setBackground(new Color(255, 255, 153));
            }
            totalTempAmt = totalTempAmt.add(bVoucherInfo.getFTempAmount());
            totalVoucherAmt = totalVoucherAmt.add(bVoucherInfo.getFVoucherAmt());
            totalDifAmt = totalDifAmt.add(bVoucherInfo.getFDifAmt());
        }
        this.appendFootRow(totalTempAmt, totalVoucherAmt, totalDifAmt, tbl);
    }

    private List<BillVoucherInfo> calculateBillVoucherAmt(RptRowSet rs, Map<Set<String>, Set<String>> billVoucherMap) {
        ArrayList<BillVoucherInfo> billVoucherList = new ArrayList<BillVoucherInfo>();
        HashMap<String, BigDecimal> voucherAmountMap = new HashMap<String, BigDecimal>();
        ArrayList<BillVoucherInfo> voucherList = new ArrayList<BillVoucherInfo>();
        Map<String, BillVoucherInfo> billVoucherInfoMap = this.getBillVoucherInfoMap(rs, voucherAmountMap, voucherList);
        Set<Map.Entry<Set<String>, Set<String>>> billVoucherSetEntrys = billVoucherMap.entrySet();
        Set<String> billNumberSet = null;
        Set<String> voucherNumberSet = null;
        BillVoucherInfo bVoucherInfo = null;
        BigDecimal billAmt = BigDecimal.ZERO;
        BigDecimal voucherAmt = BigDecimal.ZERO;
        StringBuffer billNumber = null;
        StringBuffer voucherNumber = null;
        int rowHeigth = this.tblMain.getDefaultRowHeight();
        int bNumberTimes = 0;
        int vNumberTimes = 0;
        int times = 0;
        for (Map.Entry<Set<String>, Set<String>> billVoucherSetEntry : billVoucherSetEntrys) {
            bNumberTimes = 0;
            vNumberTimes = 0;
            times = 0;
            bVoucherInfo = null;
            billAmt = BigDecimal.ZERO;
            voucherAmt = BigDecimal.ZERO;
            billNumber = new StringBuffer();
            voucherNumber = new StringBuffer();
            billNumberSet = billVoucherSetEntry.getKey();
            voucherNumberSet = billVoucherSetEntry.getValue();
            for (String bNumber : billNumberSet) {
                bVoucherInfo = billVoucherInfoMap.get(bNumber);
                if (billNumber.length() > 0) {
                    ++bNumberTimes;
                    billNumber.append("\n");
                }
                billNumber.append(bNumber);
                billAmt = billAmt.add(bVoucherInfo.getFTempAmount());
            }
            for (String vNumber : voucherNumberSet) {
                if (voucherNumber.length() > 0) {
                    ++vNumberTimes;
                    voucherNumber.append("\n");
                }
                voucherNumber.append(vNumber);
                voucherAmt = voucherAmt.add((BigDecimal)voucherAmountMap.get(vNumber));
            }
            if (bVoucherInfo == null) continue;
            bVoucherInfo.setFTempAmount(billAmt);
            bVoucherInfo.setFVoucherAmt(voucherAmt);
            bVoucherInfo.setFDifAmt(billAmt.subtract(voucherAmt));
            bVoucherInfo.setFBillNumber(billNumber.toString());
            bVoucherInfo.setFVoucherNumber(voucherNumber.toString());
            int n = times = bNumberTimes > vNumberTimes ? bNumberTimes : vNumberTimes;
            if (times > 0) {
                bVoucherInfo.setRowHeigth((times + 1) * rowHeigth);
            }
            billVoucherList.add(bVoucherInfo);
        }
        if (voucherList.size() > 0) {
            billVoucherList.addAll(voucherList);
        }
        return billVoucherList;
    }

    private Map<Set<String>, Set<String>> getBillVoucherNumberSetMap(RptRowSet rs) {
        HashMap<String, Set<String>> billVoucherNumberMap = new HashMap<String, Set<String>>();
        Map<String, Set<String>> voucherBillNumberMap = this.getBillVoucherNumberMap(rs, billVoucherNumberMap);
        Set billVoucherEntrys = billVoucherNumberMap.entrySet();
        Set<Map.Entry<String, Set<String>>> voucherBillEntry = voucherBillNumberMap.entrySet();
        Set billVoucherSet = null;
        HashMap<Set<String>, Set<String>> billVoucherMap = new HashMap<Set<String>, Set<String>>();
        String bKey = null;
        String vKey = null;
        Set voucherNumberSet = null;
        Set billNumberSet = null;
        TreeSet<String> bNumberSet = null;
        Boolean isContains = false;
        for (Map.Entry bEntry : billVoucherEntrys) {
            isContains = false;
            bKey = (String)bEntry.getKey();
            voucherNumberSet = (Set)bEntry.getValue();
            billVoucherSet = billVoucherMap.entrySet();
            for (Map.Entry entry : billVoucherSet) {
                if (!((Set)entry.getKey()).contains(bKey)) continue;
                ((Set)entry.getValue()).addAll(voucherNumberSet);
                isContains = true;
                break;
            }
            if (isContains.booleanValue()) continue;
            bNumberSet = new TreeSet<String>();
            bNumberSet.add(bKey);
            for (Map.Entry<Object, Object> entry : voucherBillEntry) {
                vKey = (String)entry.getKey();
                if (!voucherNumberSet.contains(vKey)) continue;
                billNumberSet = (Set)entry.getValue();
                bNumberSet.addAll(billNumberSet);
            }
            billVoucherMap.put(bNumberSet, voucherNumberSet);
        }
        return billVoucherMap;
    }

    private Map<String, BillVoucherInfo> getBillVoucherInfoMap(RptRowSet rs, Map<String, BigDecimal> voucherAmount, List<BillVoucherInfo> voucherList) {
        HashMap<String, BillVoucherInfo> billVoucherInfoMap = new HashMap<String, BillVoucherInfo>();
        rs.reset();
        while (rs.next()) {
            BillVoucherInfo bVoucherInfo;
            if (rs.getString("FVoucherNumber") != null) {
                voucherAmount.put(rs.getString("FVoucherNumber"), rs.getBigDecimal("FVoucherAmt"));
            }
            if ((bVoucherInfo = (BillVoucherInfo)billVoucherInfoMap.get(rs.getString("FBillNumber"))) != null) continue;
            bVoucherInfo = new BillVoucherInfo();
            bVoucherInfo.setFBillID(rs.getString("FBillID"));
            bVoucherInfo.setFBillPeriod(rs.getBigDecimal("FBillPeriod"));
            bVoucherInfo.setFBillTypeID(rs.getString("FBillTypeID"));
            bVoucherInfo.setFBillTypeName(rs.getString("FBillTypeName"));
            bVoucherInfo.setFTempAmount(rs.getBigDecimal("FTempAmount"));
            bVoucherInfo.setFVoucherID(rs.getString("FVoucherID"));
            bVoucherInfo.setFVoucherNumber(rs.getString("FVoucherNumber"));
            bVoucherInfo.setFVoucherAmt(rs.getBigDecimal("FVoucherAmt"));
            if (StringUtils.isEmpty((String)rs.getString("FBillNumber"))) {
                bVoucherInfo.setFDifAmt(rs.getBigDecimal("FVoucherAmt"));
                voucherList.add(bVoucherInfo);
                continue;
            }
            billVoucherInfoMap.put(rs.getString("FBillNumber"), bVoucherInfo);
        }
        return billVoucherInfoMap;
    }

    private Map<String, Set<String>> getBillVoucherNumberMap(RptRowSet rs, Map<String, Set<String>> billVoucherNumberMap) {
        HashMap<String, Set<String>> voucherBillNumberMap = new HashMap<String, Set<String>>();
        Set<String> vourcherNumberSet = null;
        TreeSet<String> billNumberSet = null;
        String key = null;
        while (rs.next()) {
            key = rs.getString("FBillNumber");
            if (!StringUtil.isEmpty((String)key)) {
                vourcherNumberSet = billVoucherNumberMap.get(key);
                if (vourcherNumberSet == null) {
                    vourcherNumberSet = new TreeSet<String>();
                    billVoucherNumberMap.put(key, vourcherNumberSet);
                }
                if (rs.getString("FVoucherNumber") != null) {
                    vourcherNumberSet.add(rs.getString("FVoucherNumber"));
                }
            }
            if ((key = rs.getString("FVoucherNumber")) == null) continue;
            billNumberSet = (TreeSet<String>)voucherBillNumberMap.get(key);
            if (billNumberSet == null) {
                billNumberSet = new TreeSet<String>();
                voucherBillNumberMap.put(key, billNumberSet);
            }
            if (rs.getString("FBillNumber") == null) continue;
            billNumberSet.add(rs.getString("FBillNumber"));
        }
        return voucherBillNumberMap;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InvCKAccountBCCDetailFacadeFactory.getRemoteInstance();
    }

    protected void query() {
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    protected KDTable getTableForPrintSetting() {
        return this.table;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    @Override
    public void actionBillView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int type = this.getSelectType(this.currCol);
        if (type == -1) {
            return;
        }
        String id = null;
        String billType = null;
        Boolean isMultiBill = false;
        if (type == 0) {
            id = (String)this.table.getRow(this.currRow).getCell("BillID").getValue();
            billType = "BILL";
            String billNumber = (String)this.table.getRow(this.currRow).getCell("BillNumber").getValue();
            if (!StringUtil.isEmpty((String)billNumber) && billNumber.contains("\n")) {
                isMultiBill = true;
            }
        } else if (type == 1) {
            id = (String)this.table.getRow(this.currRow).getCell("VoucherID").getValue();
            billType = "VOUCHER";
            String voucherNumber = (String)this.table.getRow(this.currRow).getCell("VoucherNumber").getValue();
            if (!StringUtil.isEmpty((String)voucherNumber) && voucherNumber.contains("\n")) {
                isMultiBill = true;
            }
        }
        if (id == null) {
            return;
        }
        if (isMultiBill.booleanValue()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"MultiBillCannotView"));
            SysUtil.abort();
        }
        uiContext.put((Object)"ID", (Object)id);
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        uiContext.put((Object)"companyId", (Object)companyOrgUnitInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(billType, id), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private int getSelectType(int colIndex) {
        int result = -1;
        if (this.currCol == -1) {
            return -1;
        }
        if (this.table.getColumnIndex("BillNumber") == colIndex || this.table.getColumnIndex("BillTypeName") == colIndex || this.table.getColumnIndex("TempAmount") == colIndex) {
            result = 0;
        } else if (this.table.getColumnIndex("VoucherNumber") == colIndex || this.table.getColumnIndex("VoucherAmount") == colIndex) {
            result = 1;
        }
        return result;
    }

    private String getEditUIName(String billTypeID, String billID) {
        String editUIName = "";
        editUIName = "BILL".equalsIgnoreCase(billTypeID) ? (BOSUuid.read((String)billID).getType().toString().equals("8FA62986") ? "com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI" : "com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI") : "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        return editUIName;
    }

    private void setColumnVisible(String[] fields, Boolean isVisible) {
        for (int i = 0; i < fields.length; ++i) {
            this.tblDischg.getColumn(fields[i]).getStyleAttributes().setHided(isVisible.booleanValue());
        }
    }

    protected class BillVoucherInfo
    implements Serializable {
        private BigDecimal FBillPeriod;
        private String FBillTypeID;
        private String FBillTypeName;
        private String FBillID;
        private String FBillNumber;
        private BigDecimal FTempAmount = BigDecimal.ZERO;
        private String FVoucherID;
        private String FVoucherNumber;
        private BigDecimal FVoucherAmt = BigDecimal.ZERO;
        private BigDecimal FDifAmt = BigDecimal.ZERO;
        private int rowHeigth = 0;

        protected BillVoucherInfo() {
        }

        public BigDecimal getFBillPeriod() {
            return this.FBillPeriod;
        }

        public void setFBillPeriod(BigDecimal fBillPeriod) {
            this.FBillPeriod = fBillPeriod;
        }

        public String getFBillTypeID() {
            return this.FBillTypeID;
        }

        public void setFBillTypeID(String fBillTypeID) {
            this.FBillTypeID = fBillTypeID;
        }

        public String getFBillTypeName() {
            return this.FBillTypeName;
        }

        public void setFBillTypeName(String fBillTypeName) {
            this.FBillTypeName = fBillTypeName;
        }

        public String getFBillID() {
            return this.FBillID;
        }

        public void setFBillID(String fBillID) {
            this.FBillID = fBillID;
        }

        public String getFBillNumber() {
            return this.FBillNumber;
        }

        public void setFBillNumber(String fBillNumber) {
            this.FBillNumber = fBillNumber;
        }

        public BigDecimal getFTempAmount() {
            return this.FTempAmount;
        }

        public void setFTempAmount(BigDecimal fTempAmount) {
            if (fTempAmount == null) {
                fTempAmount = BigDecimal.ZERO;
            }
            this.FTempAmount = fTempAmount;
        }

        public String getFVoucherID() {
            return this.FVoucherID;
        }

        public void setFVoucherID(String fVoucherID) {
            this.FVoucherID = fVoucherID;
        }

        public BigDecimal getFVoucherAmt() {
            return this.FVoucherAmt;
        }

        public void setFVoucherAmt(BigDecimal fVoucherAmt) {
            if (fVoucherAmt == null) {
                fVoucherAmt = BigDecimal.ZERO;
            }
            this.FVoucherAmt = fVoucherAmt;
        }

        public void setFVoucherNumber(String fVoucherNumber) {
            this.FVoucherNumber = fVoucherNumber;
        }

        public String getFVoucherNumber() {
            return this.FVoucherNumber;
        }

        public BigDecimal getFDifAmt() {
            return this.FDifAmt;
        }

        public void setFDifAmt(BigDecimal fDifAmt) {
            if (fDifAmt == null) {
                fDifAmt = BigDecimal.ZERO;
            }
            this.FDifAmt = fDifAmt;
        }

        public int getRowHeigth() {
            return this.rowHeigth;
        }

        public void setRowHeigth(int rowHeigth) {
            this.rowHeigth = rowHeigth;
        }
    }
}

