/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.InvCKAccountBPCDetailFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractInvCkAccountBPCDetailUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvCkAccountBPCDetailUI
extends AbstractInvCkAccountBPCDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(InvCkAccountBPCDetailUI.class);
    private int currRow = -1;
    private int currCol = -1;
    private final int BILL = 0;
    private final int TEMPVOUCHER = 1;
    private final int PURINVOUCHER = 2;
    private int amtPrecision = 2;

    public InvCkAccountBPCDetailUI() throws Exception {
        this.tblMain.setEditable(false);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                InvCkAccountBPCDetailUI.this.tbl_afterDataFill(e);
            }
        });
        this.initFootManager();
    }

    protected void init() throws Exception {
        super.init();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        if (companyOrgUnitInfo.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
            this.amtPrecision = baseCurrInfo.getPrecision();
        }
        this.initUIMainOrgContext(companyOrgUnitInfo.getId().toString());
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        BigDecimal diffAmount = null;
        for (int i = from; i <= last; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) {
                return;
            }
            diffAmount = (BigDecimal)row.getCell("TempDiffAmount").getValue();
            if (diffAmount != null && BigDecimal.ZERO.compareTo(diffAmount) != 0) {
                row.getCell("TempDiffAmount").getStyleAttributes().setBackground(new Color(255, 255, 153));
            }
            if ((diffAmount = (BigDecimal)row.getCell("PurDiffAmount").getValue()) == null || BigDecimal.ZERO.compareTo(diffAmount) == 0) continue;
            row.getCell("PurDiffAmount").getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
    }

    private void initFootManager() {
        IRow footRow = null;
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        }
    }

    protected void appendFootRow(RptParams rptParam) {
        IRow footRow = null;
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            return;
        }
        footRow = footRowManager.getFootRow(0);
        String fmtStr = SCMClientUtils.getFormatPattern((int)this.amtPrecision);
        this.AddFootCell(footRow, "TempAmount", rptParam.getBigDecimal("totalTempAmt"), fmtStr);
        this.AddFootCell(footRow, "PurAmount", rptParam.getBigDecimal("totalPurinAmt"), fmtStr);
        this.AddFootCell(footRow, "TempVoucherAmount", rptParam.getBigDecimal("totalTempVoucherAmt"), fmtStr);
        this.AddFootCell(footRow, "TempDiffAmount", rptParam.getBigDecimal("totalTempDiff"), fmtStr);
        this.AddFootCell(footRow, "DischgVoucherAmount", rptParam.getBigDecimal("totalDischgAmt"), fmtStr);
        this.AddFootCell(footRow, "PurVoucherAmount", rptParam.getBigDecimal("totalPurVoucherAmt"), fmtStr);
        this.AddFootCell(footRow, "PurDiffAmount", rptParam.getBigDecimal("totalPurDiff"), fmtStr);
        Calendar instance = Calendar.getInstance();
        Date time = instance.getTime();
        instance.add(5, 30);
        instance.getTime();
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    private void AddFootCell(IRow footRow, String fieldName, BigDecimal value, String fmtStr) {
        ICell cell = footRow.getCell(fieldName);
        cell.getStyleAttributes().setNumberFormat(fmtStr);
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
        cell.getStyleAttributes().setFontColor(Color.BLACK);
        cell.setValue((Object)value);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                InvCkAccountBPCDetailUI.this.currRow = e.getRowIndex();
                InvCkAccountBPCDetailUI.this.currCol = e.getColIndex();
                if (e.getClickCount() == 2) {
                    InvCkAccountBPCDetailUI.this.tbl_tableClicked(e);
                }
            }
        });
    }

    protected void tbl_tableClicked(KDTMouseEvent e) {
        ActionEvent evt = new ActionEvent(this.btnBillView, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    private void setMergeColumn(String[] mergeColumnKeys) {
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            int i;
            for (i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
            this.tblMain.getGroupManager().group();
            for (i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(false);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(false);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        int year = this.params.getInt("Year");
        int period = this.params.getInt("Period");
        String actNumber = this.params.getString("ActNumber");
        String actName = this.params.getString("ActName");
        this.txtCompany.setText(companyOrgUnitInfo.getNumber());
        this.txtCompName.setText(companyOrgUnitInfo.getName());
        this.txtAccount.setText(actNumber);
        this.txtAcctName.setText(actName);
        this.txtPeriod.setText(year + "." + period);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        RptParams result = null;
        RptParams rptParam = new RptParams();
        try {
            this.params.setString("tempTable", this.getTempTable());
            result = this.getRemoteInstance().createTempTable(this.params);
            this.setTempTable(result.getString("tempTable"));
            logger.error((Object)("==========\u672c\u6b21\u67e5\u8be2\u7684\u4e34\u65f6\u8868\uff1a" + result.getString("tempTable")));
            this.tblMain.setRowCount(result.getInt("recordCount"));
            this.appendFootRow(result);
            rptParam.clear();
            rptParam.setString("tempTable", this.getTempTable());
            rptParam.setBoolean("isShowException", this.params.getBoolean("isShowException"));
            result = this.getRemoteInstance().query(rptParam);
            RptRowSet rs = (RptRowSet)result.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
            this.setMergeColumn(new String[]{"TempVoucherID", "TempVoucherNumber", "TempVoucherAmount", "TempDiffAmount"});
            this.setMergeColumn(new String[]{"DischgVoucherAmount"});
            this.setMergeColumn(new String[]{"PurVoucherID", "PurVoucherNumber", "PurVoucherAmount", "PurDiffAmount"});
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InvCKAccountBPCDetailFacadeFactory.getRemoteInstance();
    }

    protected void query() {
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    protected KDTable getTableForPrintSetting() {
        return this.getDetailTable();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    @Override
    public void actionBillView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int type = this.getSelectType(this.currCol);
        if (type == -1) {
            return;
        }
        String id = null;
        String billType = null;
        if (type == 0) {
            id = (String)this.tblMain.getRow(this.currRow).getCell("BillID").getValue();
            billType = "BILL";
        } else if (type == 1) {
            id = (String)this.tblMain.getRow(this.currRow).getCell("TempVoucherID").getValue();
            billType = "VOUCHER";
        } else {
            id = (String)this.tblMain.getRow(this.currRow).getCell("PurVoucherID").getValue();
            billType = "VOUCHER";
        }
        if (id == null) {
            return;
        }
        uiContext.put((Object)"ID", (Object)id);
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        uiContext.put((Object)"companyId", (Object)companyOrgUnitInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(billType, id), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private int getSelectType(int colIndex) {
        int result = -1;
        if (this.currCol == -1) {
            return -1;
        }
        if (this.tblMain.getColumnIndex("BillNumber") == colIndex || this.tblMain.getColumnIndex("BillTypeName") == colIndex || this.tblMain.getColumnIndex("TempAmount") == colIndex || this.tblMain.getColumnIndex("PurAmount") == colIndex) {
            result = 0;
        } else if (this.tblMain.getColumnIndex("TempVoucherNumber") == colIndex || this.tblMain.getColumnIndex("TempVoucherAmount") == colIndex) {
            result = 1;
        } else if (this.tblMain.getColumnIndex("PurVoucherNumber") == colIndex || this.tblMain.getColumnIndex("PurVoucherAmount") == colIndex) {
            result = 2;
        }
        return result;
    }

    private String getEditUIName(String billTypeID, String billID) {
        String editUIName = "";
        editUIName = "BILL".equalsIgnoreCase(billTypeID) ? (BOSUuid.read((String)billID).getType().toString().equals("8FA62986") ? "com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI" : "com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI") : "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        return editUIName;
    }
}

