/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.LotAccountContrastEnum;
import com.kingdee.eas.scm.cal.LotAccountContrastFactory;
import com.kingdee.eas.scm.cal.LotAccountContrastInfo;
import com.kingdee.eas.scm.cal.client.AbstractLotAccountContrastEditUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class LotAccountContrastEditUI
extends AbstractLotAccountContrastEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LotAccountContrastEditUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.LotAccountContrastResource";
    private DataChangeListener billTypeDataChangeListener = null;
    private DataChangeListener bizTypeDataChangeListener = null;
    private DataChangeListener transactionTypeDataChangeListener = null;
    private DataChangeListener updateTypeDataChangeListener = null;
    private DataChangeListener issueTypeDataChangeListener = null;
    private DataChangeListener wareTypeDataChangeListener = null;
    private DataChangeListener companyDataChangeListener = null;

    @Override
    public void storeFields() {
        UseStatusEnum status = this.editData.getStatus();
        super.storeFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.verify()) {
            if (this.editData.getStatus() == null) {
                this.editData.setStatus(UseStatusEnum.SAVED);
            }
            super.actionSubmit_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        LotAccountContrastInfo bill = LotAccountContrastFactory.getRemoteInstance().getLotAccountContrastInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (UseStatusEnum.ACTIVE.equals((Object)bill.getStatus())) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"ActiveData_Cannt_Modify");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        this.removeListeners();
        this.initListeners();
        super.actionEdit_actionPerformed(e);
        this.setKDBizPromptBoxEnable();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setNumber(this.editData.getNumber() + "Copy");
        this.editData.setStatus(UseStatusEnum.SAVED);
        this.loadFields();
        this.setKDBizPromptBoxEnable();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        LotAccountContrastInfo bill = LotAccountContrastFactory.getRemoteInstance().getLotAccountContrastInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (!UseStatusEnum.SAVED.equals((Object)bill.getStatus())) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"UnSaveData_Cannt_Remove");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.removeListeners();
        this.prmtIssueAccountView.setEnabled(false);
        this.prmtWareAccountView.setEnabled(false);
        super.actionPre_actionPerformed(e);
        this.setKDBizPromptBoxEnable();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.removeListeners();
        this.prmtIssueAccountView.setEnabled(false);
        this.prmtWareAccountView.setEnabled(false);
        super.actionNext_actionPerformed(e);
        this.setKDBizPromptBoxEnable();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.removeListeners();
        this.prmtIssueAccountView.setEnabled(false);
        this.prmtWareAccountView.setEnabled(false);
        super.actionFirst_actionPerformed(e);
        this.setKDBizPromptBoxEnable();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.removeListeners();
        this.prmtIssueAccountView.setEnabled(false);
        this.prmtWareAccountView.setEnabled(false);
        super.actionLast_actionPerformed(e);
        this.setKDBizPromptBoxEnable();
    }

    protected IObjectValue createNewData() {
        LotAccountContrastInfo editData = new LotAccountContrastInfo();
        editData.setStatus(UseStatusEnum.SAVED);
        return editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LotAccountContrastFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        String pageState = this.getOprtState();
        if (pageState == null) {
            this.setOprtState("ADDNEW");
            pageState = "ADDNEW";
        }
        super.onLoad();
        if (pageState.equals("ADDNEW")) {
            this.menuSubmitOption.setVisible(false);
            this.chkMenuItemSubmitAndAddNew.setSelected(false);
            this.chkMenuItemSubmitAndAddNew.setVisible(false);
            this.combIsPriority.setSelectedItem((Object)LotAccountContrastEnum.yes);
        }
        this.setKDBizPromptBoxEnable();
        this.prmtBizType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7BizTypeHasBillTypeQuery");
        this.initFilterInfo();
        this.initListeners();
    }

    private String getViewPermission() {
        return "accountContrast_new";
    }

    private void initFilterInfo() throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK pk = new ObjectUuidPK(userInfo.getId().toString());
        FullOrgUnitCollection coll = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (String)this.getViewPermission());
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            FullOrgUnitInfo company = coll.get(i);
            entryIdSet.add(company.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtCompanyOrgUnit.setEntityViewInfo(viewInfo);
        EntityViewInfo view = this.getBillTypeEntityView();
        this.prmtBillType.setEntityViewInfo(view);
        if (this.prmtCompanyOrgUnit.getValue() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            this.filterAccountView(company);
        }
        if (this.prmtBillType.getValue() != null) {
            this.setBizTypeF7();
        }
        if (this.prmtBizType.getValue() != null) {
            this.setTranscationFilter();
        }
        if (this.prmtTransactionType.getValue() != null) {
            TransactionTypeInfo transactionType = (TransactionTypeInfo)this.prmtTransactionType.getValue();
            ObjectUuidPK transactionTypePK = new ObjectUuidPK(transactionType.getId().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("transactionInvUpdateType.invUpdateType.id"));
            sic.add(new SelectorItemInfo("transactionInvUpdateType.invUpdateType.number"));
            sic.add(new SelectorItemInfo("transactionInvUpdateType.invUpdateType.name"));
            transactionType = TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)transactionTypePK, sic);
            this.filterUpdateType(transactionType);
        }
        if (this.prmtUpdateType.getValue() != null) {
            InvUpdateTypeInfo updateType = (InvUpdateTypeInfo)this.prmtUpdateType.getValue();
            this.filterStoreType(updateType);
        }
    }

    private void initListeners() throws Exception {
        if (this.billTypeDataChangeListener == null) {
            this.billTypeDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    LotAccountContrastEditUI.this.prmtBizType.setValue(null);
                    LotAccountContrastEditUI.this.setBizTypeF7();
                }
            };
        }
        this.prmtBillType.addDataChangeListener(this.billTypeDataChangeListener);
        if (this.bizTypeDataChangeListener == null) {
            this.bizTypeDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    LotAccountContrastEditUI.this.prmtTransactionType.setValue(null);
                    LotAccountContrastEditUI.this.setTranscationFilter();
                }
            };
        }
        this.prmtBizType.addDataChangeListener(this.bizTypeDataChangeListener);
        if (this.transactionTypeDataChangeListener == null) {
            this.transactionTypeDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    LotAccountContrastEditUI.this.prmtUpdateType.setValue(null);
                    if (eventObj.getNewValue() != null) {
                        TransactionTypeInfo transactionType = (TransactionTypeInfo)eventObj.getNewValue();
                        LotAccountContrastEditUI.this.filterUpdateType(transactionType);
                        LotAccountContrastEditUI.this.prmtUpdateType.setEnabled(true);
                    } else {
                        LotAccountContrastEditUI.this.prmtUpdateType.setEnabled(false);
                    }
                }
            };
        }
        this.prmtTransactionType.addDataChangeListener(this.transactionTypeDataChangeListener);
        if (this.updateTypeDataChangeListener == null) {
            this.updateTypeDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    LotAccountContrastEditUI.this.prmtWareStoreType.setValue(null);
                    LotAccountContrastEditUI.this.prmtIssueStoreType.setValue(null);
                    LotAccountContrastEditUI.this.prmtWareAccountView.setValue(null);
                    LotAccountContrastEditUI.this.prmtIssueAccountView.setValue(null);
                    if (eventObj.getNewValue() != null) {
                        InvUpdateTypeInfo updateType = (InvUpdateTypeInfo)eventObj.getNewValue();
                        LotAccountContrastEditUI.this.filterStoreType(updateType);
                    }
                }
            };
        }
        this.prmtUpdateType.addDataChangeListener(this.updateTypeDataChangeListener);
        if (this.companyDataChangeListener == null) {
            this.companyDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    LotAccountContrastEditUI.this.prmtWareAccountView.setValue(null);
                    LotAccountContrastEditUI.this.prmtIssueAccountView.setValue(null);
                    if (eventObj.getNewValue() != null) {
                        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)eventObj.getNewValue();
                        LotAccountContrastEditUI.this.filterAccountView(company);
                    } else {
                        LotAccountContrastEditUI.this.prmtWareAccountView.setEnabled(false);
                        LotAccountContrastEditUI.this.prmtIssueAccountView.setEnabled(false);
                    }
                }
            };
        }
        this.prmtCompanyOrgUnit.addDataChangeListener(this.companyDataChangeListener);
        if (this.issueTypeDataChangeListener == null) {
            this.issueTypeDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    if (eventObj.getNewValue() != null) {
                        if (LotAccountContrastEditUI.this.prmtCompanyOrgUnit.getValue() == null) {
                            LotAccountContrastEditUI.this.prmtIssueAccountView.setEnabled(false);
                        } else {
                            LotAccountContrastEditUI.this.prmtIssueAccountView.setEnabled(true);
                        }
                    } else {
                        LotAccountContrastEditUI.this.prmtIssueAccountView.setEnabled(false);
                    }
                }
            };
        }
        this.prmtIssueStoreType.addDataChangeListener(this.issueTypeDataChangeListener);
        if (this.wareTypeDataChangeListener == null) {
            this.wareTypeDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                        return;
                    }
                    if (eventObj.getNewValue() != null) {
                        if (LotAccountContrastEditUI.this.prmtCompanyOrgUnit.getValue() == null) {
                            LotAccountContrastEditUI.this.prmtWareAccountView.setEnabled(false);
                        } else {
                            LotAccountContrastEditUI.this.prmtWareAccountView.setEnabled(true);
                        }
                    } else {
                        LotAccountContrastEditUI.this.prmtWareAccountView.setEnabled(false);
                    }
                }
            };
        }
        this.prmtWareStoreType.addDataChangeListener(this.wareTypeDataChangeListener);
    }

    private void removeListeners() {
        if (this.billTypeDataChangeListener != null) {
            this.prmtBillType.removeDataChangeListener(this.billTypeDataChangeListener);
            this.billTypeDataChangeListener = null;
        }
        if (this.transactionTypeDataChangeListener != null) {
            this.prmtTransactionType.removeDataChangeListener(this.transactionTypeDataChangeListener);
            this.transactionTypeDataChangeListener = null;
        }
        if (this.updateTypeDataChangeListener != null) {
            this.prmtUpdateType.removeDataChangeListener(this.updateTypeDataChangeListener);
            this.updateTypeDataChangeListener = null;
        }
        if (this.issueTypeDataChangeListener != null) {
            this.prmtIssueStoreType.removeDataChangeListener(this.issueTypeDataChangeListener);
            this.issueTypeDataChangeListener = null;
        }
        if (this.wareTypeDataChangeListener != null) {
            this.prmtWareStoreType.removeDataChangeListener(this.wareTypeDataChangeListener);
            this.wareTypeDataChangeListener = null;
        }
        if (this.companyDataChangeListener != null) {
            this.prmtCompanyOrgUnit.removeDataChangeListener(this.companyDataChangeListener);
            this.companyDataChangeListener = null;
        }
        if (this.bizTypeDataChangeListener != null) {
            this.prmtBizType.removeDataChangeListener(this.bizTypeDataChangeListener);
            this.bizTypeDataChangeListener = null;
        }
    }

    private boolean verify() {
        if (this.txtNumber.getText().trim() == null || "".equals(this.txtNumber.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"NUM_NOT_NULL"));
            SysUtil.abort();
            return false;
        }
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"COMPANY_NOT_NULL"));
            SysUtil.abort();
            return false;
        }
        if (this.prmtBillType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"BILLTYPE_NOT_NULL"));
            SysUtil.abort();
            return false;
        }
        if (this.prmtBizType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"BIZTYPE_NOT_NULL"));
            SysUtil.abort();
            return false;
        }
        if (this.prmtTransactionType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"TRANSACTIONTYPE_NOT_NULL"));
            SysUtil.abort();
            return false;
        }
        if (this.prmtUpdateType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"UpdateType_Cannt_Null"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    private EntityViewInfo getBillTypeEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> billTypeNum = new HashSet<String>();
        billTypeNum.add("102");
        billTypeNum.add("103");
        billTypeNum.add("104");
        billTypeNum.add("105");
        billTypeNum.add("106");
        billTypeNum.add("107");
        billTypeNum.add("108");
        billTypeNum.add("109");
        filter.getFilterItems().add(new FilterItemInfo("number", billTypeNum, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    private EntityViewInfo getAccountViewInfo(Object tableId, Object companyId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", tableId));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", companyId));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)1));
        return view;
    }

    private void filterAccountView(CompanyOrgUnitInfo company) {
        AccountTableInfo tableInfo;
        if (company != null && company.getAccountTable() != null && (tableInfo = company.getAccountTable()) != null) {
            EntityViewInfo view = this.getAccountViewInfo(tableInfo.getId(), company.getId());
            this.prmtWareAccountView.setEntityViewInfo(view);
            this.prmtIssueAccountView.setEntityViewInfo(view);
        }
    }

    private void filterUpdateType(TransactionTypeInfo transactionType) {
        TransactionInvUpdateTypeCollection coll = transactionType.getTransactionInvUpdateType();
        HashSet<String> entryIdSet = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                TransactionInvUpdateTypeInfo transactionInvUpdateType = coll.get(i);
                InvUpdateTypeInfo updateType = transactionInvUpdateType.getInvUpdateType();
                entryIdSet.add(updateType.getId().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            viewInfo.setFilter(filterInfo);
            this.prmtUpdateType.setEntityViewInfo(viewInfo);
        }
    }

    private void filterStoreType(InvUpdateTypeInfo updateType) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(updateType.getId().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("storeType.id"));
            sic.add(new SelectorItemInfo("storeType.name"));
            sic.add(new SelectorItemInfo("storeType.number"));
            sic.add(new SelectorItemInfo("storeTypePre.id"));
            sic.add(new SelectorItemInfo("storeTypePre.name"));
            sic.add(new SelectorItemInfo("storeTypePre.number"));
            updateType = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeInfo((IObjectPK)pk, sic);
            StoreTypeInfo ware = updateType.getStoreType();
            StoreTypeInfo issue = updateType.getStoreTypePre();
            if (updateType != null) {
                this.prmtWareStoreType.setValue((Object)ware);
                this.prmtIssueStoreType.setValue((Object)issue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setKDBizPromptBoxEnable() {
        if (this.prmtBillType.getValue() != null) {
            this.prmtBizType.setEnabled(true);
        } else {
            this.prmtBizType.setEnabled(false);
        }
        if (this.prmtBizType.getValue() != null) {
            this.prmtTransactionType.setEnabled(true);
        } else {
            this.prmtTransactionType.setEnabled(false);
        }
        if (this.prmtTransactionType.getValue() != null) {
            this.prmtUpdateType.setEnabled(true);
        } else {
            this.prmtUpdateType.setEnabled(false);
        }
        if (this.prmtWareStoreType.getValue() != null) {
            this.prmtWareAccountView.setEnabled(true);
        } else {
            this.prmtWareAccountView.setEnabled(false);
        }
        if (this.prmtIssueStoreType.getValue() != null) {
            this.prmtIssueAccountView.setEnabled(true);
        } else {
            this.prmtIssueAccountView.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    private void setBizTypeF7() {
        BillTypeInfo billTypeInfo = (BillTypeInfo)this.prmtBillType.getValue();
        if (billTypeInfo == null) {
            this.prmtBizType.setEnabled(false);
            return;
        }
        this.prmtBizType.setEnabled(true);
        EntityViewInfo view = this.getBizTypeFilterInfo(billTypeInfo.getId().toString());
        this.prmtBizType.setEntityViewInfo(view);
    }

    private EntityViewInfo getBizTypeFilterInfo(String billTypeId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf("1"), CompareType.EQUALS));
        if (!StringUtil.isEmpty((String)billTypeId)) {
            filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeId, CompareType.EQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private void setTranscationFilter() {
        BillTypeInfo billTypeInfo = (BillTypeInfo)this.prmtBillType.getValue();
        BizTypeInfo bizTypeInfo = (BizTypeInfo)this.prmtBizType.getValue();
        String bllTypeId = billTypeInfo == null ? null : billTypeInfo.getId().toString();
        String bizTypeId = bizTypeInfo == null ? null : bizTypeInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)bllTypeId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isManuCheckAccount", (Object)true, CompareType.EQUALS));
        view.setFilter(filterInfo);
        this.prmtTransactionType.setEntityViewInfo(view);
        this.prmtTransactionType.setEnabled(true);
    }
}

