/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobInstExtCollection;
import com.kingdee.eas.basedata.common.perf.JobInstExtInfo;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.AdjustmentOrderType;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostCalChkFacadeFactory;
import com.kingdee.eas.scm.cal.CostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostUpdateMutexFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.ICostCalculateFacade;
import com.kingdee.eas.scm.cal.MaterialCalculateCostPlatformFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractMaterialCalculateCostPlatformUI;
import com.kingdee.eas.scm.cal.client.timertask.ITimerTaskProcessor;
import com.kingdee.eas.scm.cal.client.timertask.PageTimerTask;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.common.EnumDictionaryCollection;
import com.kingdee.eas.scm.common.EnumDictionaryFactory;
import com.kingdee.eas.scm.common.EnumDictionaryInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialCalculateCostPlatformUI
extends AbstractMaterialCalculateCostPlatformUI
implements ITimerTaskProcessor {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCalculateCostPlatformUI.class);
    private static final String materialCalculateCostPlatformEASResource = "com.kingdee.eas.scm.cal.materialCalculateCostPlatform";
    private static final long serialVersionUID = -1083656942797330872L;
    private static final String CAL_RANGE_FINACIAL = EASResource.getString((String)"com.kingdee.eas.scm.cal.materialCalculateCostPlatform", (String)"calRangeFinacial");
    private static final String CAL_RANGE_STORAGE = EASResource.getString((String)"com.kingdee.eas.scm.cal.materialCalculateCostPlatform", (String)"calRangeStorage");
    private static final String CAL_RANGE_WAREHOUSE = EASResource.getString((String)"com.kingdee.eas.scm.cal.materialCalculateCostPlatform", (String)"calRangeWarehouse");
    public static final String TB_COSTADJUSTBILLTYPE = "issueType";
    public static final String TB_PERIOD = "period";
    public static final String TB_ACCOUNTTYPE = "accountType";
    public static final String TB_ISSUEBILL = "issueBill";
    private KDTEditAdapter kdtEditAdapter;
    private KDTMouseListener KdtMouseListener;
    private static final Color GREEN = new Color(0, 129, 3);
    KDBizPromptBox materialBox = new KDBizPromptBox();
    KDBizPromptBox materialBoxTo = new KDBizPromptBox();
    KDTDefaultCellEditor materialEditor;
    KDTDefaultCellEditor materialEditorTo;
    KDBizPromptBox accountTypeBox = new KDBizPromptBox();
    KDTDefaultCellEditor accountTypeEditor;
    KDBizPromptBox storageOrgUnitBox = new KDBizPromptBox();
    KDTDefaultCellEditor storageOrgUnitEditor;
    KDBizPromptBox warehouseBox = new KDBizPromptBox();
    KDTDefaultCellEditor warehouseEditor;
    private final int rowHeight;
    private int checkResultHeight = this.rowHeight = this.tbl == null ? 20 : this.tbl.getDefaultRowHeight();
    private int calculateResultHeight = this.rowHeight;
    private Map<String, Object> jobMap = new HashMap<String, Object>();
    private Map<Integer, List<Map<String, Object>>> localMap = new HashMap<Integer, List<Map<String, Object>>>();
    private boolean taskState = false;
    private TimerTask materialCalculateCostTimerTask;

    public MaterialCalculateCostPlatformUI() throws Exception {
        this.selectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.unSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(0);
        this.tbl.getSelectManager().setSelectMode(15);
        this.tbl.checkParsed();
        this.tbl.getHeadStyleAttributes().setWrapText(true);
        this.addListeners();
    }

    private void addListeners() {
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                String fieldName;
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "periodId").getValue() == null) {
                    MsgBox.showInfo((String)CalculateClientUtil.getCalResource("PERIOD_IS_NULL"));
                    e.setCancel(true);
                }
                if ("materialFrom".equals(fieldName = MaterialCalculateCostPlatformUI.this.tbl.getColumnKey(colIndex)) || "materialTo".equals(fieldName)) {
                    MaterialCalculateCostPlatformUI.this.setMaterialFilter(rowIndex);
                } else if ("storageOrgName".equals(fieldName)) {
                    try {
                        MaterialCalculateCostPlatformUI.this.setStorageOrgFilter(rowIndex);
                    }
                    catch (Exception ex) {
                        logger.error((Object)e);
                    }
                } else if ("warehouse".equals(fieldName)) {
                    MaterialCalculateCostPlatformUI.this.setWarehouseFilter(rowIndex);
                }
            }

            public void editStopped(KDTEditEvent e) {
                Object oldValue = e.getOldValue();
                Object value = e.getValue();
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                String fieldName = MaterialCalculateCostPlatformUI.this.tbl.getColumnKey(colIndex);
                if ("storageOrgName".equals(fieldName)) {
                    if (value == null) {
                        MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "warehouse").getStyleAttributes().setLocked(true);
                        MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "warehouse").setValue(null);
                    } else {
                        MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "warehouse").getStyleAttributes().setLocked(false);
                        if (null != oldValue) {
                            Object[] olds = (Object[])oldValue;
                            Object[] news = (Object[])value;
                            HashSet<String> newIds = new HashSet<String>();
                            for (Object o : news) {
                                newIds.add(((StorageOrgUnitInfo)o).getId().toString());
                            }
                            HashSet<String> oldIds = new HashSet<String>();
                            for (Object o : olds) {
                                oldIds.add(((StorageOrgUnitInfo)o).getId().toString());
                            }
                            if (!newIds.containsAll(oldIds)) {
                                MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "warehouse").setValue(null);
                            }
                        }
                    }
                }
                if (value == null && oldValue == null || value != null && value.equals(oldValue)) {
                    return;
                }
                if ("materialFrom".equals(fieldName) || "materialTo".equals(fieldName)) {
                    MaterialInfo material;
                    String materialFromNumber = null;
                    String materialToNumber = null;
                    String materialInNumber = null;
                    Object[] materials = (Object[])MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "materialFrom").getValue();
                    if (materials == null || materials.length == 1) {
                        MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "materialTo").getStyleAttributes().setLocked(false);
                        if (materials != null) {
                            materialFromNumber = ((MaterialInfo)materials[0]).getNumber();
                        }
                    } else {
                        MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "materialTo").getStyleAttributes().setLocked(true);
                        MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "materialTo").setValue(null);
                        StringBuffer materialNumber = new StringBuffer();
                        for (int i = 0; i < materials.length; ++i) {
                            if (i != 0) {
                                materialNumber.append("','");
                            }
                            materialNumber.append(((MaterialInfo)materials[i]).getNumber());
                        }
                        materialInNumber = materialNumber.toString();
                    }
                    if ((material = (MaterialInfo)MaterialCalculateCostPlatformUI.this.tbl.getCell(rowIndex, "materialTo").getValue()) != null) {
                        materialToNumber = material.getNumber();
                    }
                    MaterialCalculateCostPlatformUI.this.getAccountType(materialFromNumber, materialToNumber, materialInNumber, rowIndex);
                }
            }
        });
        this.selectAll.addMouseListener((MouseListener)new MouseListener4Plat(){});
        this.unSelectAll.addMouseListener((MouseListener)new MouseListener4Plat(){});
        if (this.KdtMouseListener == null) {
            this.KdtMouseListener = new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    boolean flag;
                    int colIndex = e.getColIndex();
                    String fieldName = MaterialCalculateCostPlatformUI.this.tbl.getColumnKey(colIndex);
                    if (fieldName.equals(MaterialCalculateCostPlatformUI.TB_ISSUEBILL) && (flag = MaterialCalculateCostPlatformUI.this.costAdjust(e))) {
                        MsgBox.showInfo((String)EASResource.getString((String)MaterialCalculateCostPlatformUI.materialCalculateCostPlatformEASResource, (String)"ADJUSTMENTSUCCESSFULLY"));
                    }
                    if (fieldName.equals("exceptionBillQuery")) {
                        MaterialCalculateCostPlatformUI.this.showExceptionBill(e);
                    }
                    if (fieldName.equals("adjustZero") && (flag = MaterialCalculateCostPlatformUI.this.exceptionAdjust(e))) {
                        MsgBox.showInfo((String)EASResource.getString((String)MaterialCalculateCostPlatformUI.materialCalculateCostPlatformEASResource, (String)"AbnormalDataIsResetSuccessfullyProcedure"));
                    }
                    if (fieldName.equals("computeReport")) {
                        try {
                            MaterialCalculateCostPlatformUI.this.showSumReport(e);
                        }
                        catch (BOSException e1) {
                            MaterialCalculateCostPlatformUI.this.handleException((Exception)((Object)e1));
                        }
                    }
                }
            };
        }
        this.tbl.addKDTMouseListener(this.KdtMouseListener);
        this.radioMat.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MaterialCalculateCostPlatformUI.this.clearMaterialAndAccountType();
            }
        });
        this.radioPrd.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MaterialCalculateCostPlatformUI.this.clearMaterialAndAccountType();
            }
        });
    }

    private String getOprtStateType() {
        String oprtState = null;
        if (this.radioMat.isSelected()) {
            oprtState = "rawMaterailCostCal";
        } else if (this.radioPrd.isSelected()) {
            oprtState = "fishedGoodsCostCal";
        }
        return oprtState;
    }

    private void clearMaterialAndAccountType() {
        int count = this.tbl.getRowCount();
        int materialFromIndex = this.tbl.getColumn("materialFrom").getColumnIndex();
        int materialToIndex = this.tbl.getColumn("materialTo").getColumnIndex();
        int accountTypeIndex = this.tbl.getColumn(TB_ACCOUNTTYPE).getColumnIndex();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tbl.getRow(i);
            row.getCell(materialFromIndex).setValue(null);
            row.getCell(materialToIndex).setValue(null);
            row.getCell(accountTypeIndex).setValue(null);
        }
    }

    private void getAccountType(String materialFromNumber, String materialToNumber, String materialInNumber, int rowIndex) {
        try {
            String companyId = (String)this.tbl.getCell(rowIndex, "id").getValue();
            ICostCalculateFacade iCostCalculateFacade = CostCalculateFacadeFactory.getRemoteInstance();
            IRowSet rs = iCostCalculateFacade.getMaterialAccountType(materialFromNumber, materialToNumber, materialInNumber, companyId);
            StringBuilder ids = new StringBuilder();
            while (rs.next()) {
                ids.append("'").append(rs.getString("FACCOUNTTYPE")).append("',");
            }
            if (ids.length() > 0) {
                ids.setLength(ids.length() - 1);
                String oql = "SELECT ID,NAME,KEY,ALIAS WHERE KEY IN (" + ids + ")";
                EnumDictionaryCollection list = EnumDictionaryFactory.getRemoteInstance().getCollection(oql);
                this.tbl.getCell(rowIndex, TB_ACCOUNTTYPE).setValue((Object)list.toArray());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setMaterialFilter(int rowIndex) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyId = String.valueOf(this.tbl.getCell(rowIndex, "id").getValue());
        filter.getFilterItems().add(new FilterItemInfo("ORGUNIT.id", (Object)companyId));
        if (this.radioMat.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("FiInfo.calculateType", (Object)0));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("FiInfo.calculateType", (Object)0, CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filter);
        this.materialBox.setEntityViewInfo(viewInfo);
        this.materialBoxTo.setEntityViewInfo(viewInfo);
    }

    private void setStorageOrgFilter(int rowIndex) throws ParserException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        String companyId = String.valueOf(this.tbl.getCell(rowIndex, "id").getValue());
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        CalculateClientUtil.setStorageOrgF7(cou, this.storageOrgUnitBox, null);
    }

    private void setWarehouseFilter(int rowIndex) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String range = String.valueOf(this.tbl.getCell(rowIndex, "range").getValue());
        if ("2".equals(range)) {
            Object[] sou = (Object[])this.tbl.getCell(rowIndex, "storageOrgName").getValue();
            HashSet<String> souIds = new HashSet<String>();
            if (sou != null && sou.length > 0) {
                for (Object o : sou) {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)o;
                    souIds.add(storageOrgUnitInfo.getId().toString());
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("SOWH.storageOrg", souIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("SOWH.isStarted", (Object)1));
        }
        viewInfo.setFilter(filter);
        this.warehouseBox.setEntityViewInfo(viewInfo);
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
        this.initUserConfig();
        this.btnCostCalculate.setEnabled(true);
        this.btnCalculateCheck.setEnabled(true);
        this.doStop();
    }

    public void onLoad() throws Exception {
        this.initTableEditor();
        this.setShowDialogOnLoad(false);
        super.onLoad();
    }

    private void initTableEditor() {
        this.materialBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
        this.materialBox.setHasCUDefaultFilter(false);
        this.materialBox.setDisplayFormat("$name$");
        this.materialBox.setEditFormat("$number$");
        this.materialBox.setCommitFormat("$number$");
        this.materialBox.setEnabledMultiSelection(true);
        this.materialEditor = new KDTDefaultCellEditor((IKDEditor)this.materialBox);
        this.materialBoxTo.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
        this.materialBoxTo.setHasCUDefaultFilter(false);
        this.materialBoxTo.setDisplayFormat("$name$");
        this.materialBoxTo.setEditFormat("$number$");
        this.materialBoxTo.setCommitFormat("$number$");
        this.materialEditorTo = new KDTDefaultCellEditor((IKDEditor)this.materialBoxTo);
        this.accountTypeBox.setQueryInfo("com.kingdee.eas.scm.cal.app.MaterialAccountTypeEnumQuery");
        this.accountTypeBox.setEnabledMultiSelection(true);
        this.accountTypeBox.setCommitFormat("$alias$");
        this.accountTypeBox.setEditFormat("$alias$");
        this.accountTypeBox.setDisplayFormat("$alias$");
        this.accountTypeBox.setMyCommonUseEnabled(false);
        this.accountTypeEditor = new KDTDefaultCellEditor((IKDEditor)this.accountTypeBox);
        this.storageOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.storageOrgUnitBox.setEnabledMultiSelection(true);
        this.storageOrgUnitBox.setCommitFormat("$name$");
        this.storageOrgUnitBox.setEditFormat("$name$");
        this.storageOrgUnitBox.setDisplayFormat("$name$");
        this.storageOrgUnitEditor = new KDTDefaultCellEditor((IKDEditor)this.storageOrgUnitBox);
        this.warehouseBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.warehouseBox.setEnabledMultiSelection(true);
        this.warehouseBox.setCommitFormat("$name$");
        this.warehouseBox.setEditFormat("$name$");
        this.warehouseBox.setDisplayFormat("$name$");
        this.warehouseEditor = new KDTDefaultCellEditor((IKDEditor)this.warehouseBox);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return MaterialCalculateCostPlatformFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return null;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            if (from == 0) {
                this.buildCompanyListQuery(para);
                rpt = this.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                this.tbl.getStyleAttributes().setLocked(true);
            }
            para.setString("tempTable", this.getTempTable());
            rpt = this.getRemoteInstance().query(para, from, len);
            if (from == 0) {
                this.tbl.setRowCount(rpt.getInt("totalCount"));
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
            this.SetTableFormat(e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void buildCompanyListQuery(RptParams para) throws BOSException {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "materialCalculateCostPlatform");
        iProducer.getModel().setNeedAddSealUp(false);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("NUMBER"));
        sic.add(new SelectorItemInfo("NAME"));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(iProducer.getFilterInfo());
        queryExec.setObjectView(viewInfo);
        String orgQuerySql = queryExec.getSQL();
        para.setString("orgQuerySql", orgQuerySql);
    }

    private void SetTableFormat(KDTDataRequestEvent e) {
        this.tbl.getColumn("selected").getStyleAttributes().setLocked(false);
        this.tbl.getColumn("storageOrgName").setEditor((ICellEditor)this.storageOrgUnitEditor);
        ObjectValueRender nameRender = new ObjectValueRender();
        nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tbl.getColumn("storageOrgName").setRenderer((IBasicRender)nameRender);
        this.tbl.getColumn("warehouse").setEditor((ICellEditor)this.warehouseEditor);
        this.tbl.getColumn("warehouse").setRenderer((IBasicRender)nameRender);
        this.tbl.getColumn("warehouse").getStyleAttributes().setLocked(true);
        this.tbl.getColumn("materialFrom").setEditor((ICellEditor)this.materialEditor);
        nameRender = new ObjectValueRender();
        nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tbl.getColumn("materialFrom").setRenderer((IBasicRender)nameRender);
        this.tbl.getColumn("materialTo").setEditor((ICellEditor)this.materialEditorTo);
        this.tbl.getColumn("materialFrom").getStyleAttributes().setLocked(false);
        this.tbl.getColumn("materialTo").getStyleAttributes().setLocked(false);
        this.tbl.getColumn(TB_ACCOUNTTYPE).getStyleAttributes().setLocked(false);
        this.tbl.getColumn(TB_ACCOUNTTYPE).setEditor((ICellEditor)this.accountTypeEditor);
        ObjectValueRender avrForName = new ObjectValueRender();
        avrForName.setFormat((IDataFormat)new BizDataFormat("$alias$"));
        this.tbl.getColumn(TB_ACCOUNTTYPE).setRenderer((IBasicRender)avrForName);
        this.tbl.getColumn("checkResult").getStyleAttributes().setWrapText(true);
        this.tbl.getColumn("checkResult").setWidth(180);
        this.tbl.getColumn("calculateResult").getStyleAttributes().setWrapText(true);
        this.tbl.getColumn("calculateResult").setWidth(200);
        this.tbl.getColumn(TB_COSTADJUSTBILLTYPE).getStyleAttributes().setLocked(false);
        this.initCostAdjustBillType();
        this.tbl.getColumn(TB_ISSUEBILL).getStyleAttributes().setLocked(false);
        this.tbl.getColumn("computeReport").getStyleAttributes().setLocked(false);
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            IRow row = this.tbl.getRow(i);
            if (row == null) {
                return;
            }
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell(TB_ISSUEBILL).setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"generate"));
            row.getCell(TB_ISSUEBILL).getStyleAttributes().setFontColor(Color.BLUE);
            row.getCell(TB_ISSUEBILL).getStyleAttributes().setUnderline(true);
            row.getCell("exceptionBillQuery").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"QueryOfAbnormalDocuments"));
            row.getCell("exceptionBillQuery").getStyleAttributes().setFontColor(Color.BLUE);
            row.getCell("exceptionBillQuery").getStyleAttributes().setUnderline(true);
            row.getCell("adjustZero").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"zero"));
            row.getCell("adjustZero").getStyleAttributes().setFontColor(Color.BLUE);
            row.getCell("adjustZero").getStyleAttributes().setUnderline(true);
            row.getCell("computeReport").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"Report"));
            row.getCell("computeReport").getStyleAttributes().setFontColor(Color.BLUE);
            row.getCell("computeReport").getStyleAttributes().setUnderline(true);
            String range = String.valueOf(row.getCell("range").getValue());
            if ("0".equals(range)) {
                row.getCell("rangeName").setValue((Object)CAL_RANGE_FINACIAL);
                continue;
            }
            if ("1".equals(range)) {
                row.getCell("rangeName").setValue((Object)CAL_RANGE_STORAGE);
                row.getCell("storageOrgName").getStyleAttributes().setLocked(false);
                continue;
            }
            if (!"2".equals(range)) continue;
            row.getCell("rangeName").setValue((Object)CAL_RANGE_WAREHOUSE);
            row.getCell("storageOrgName").getStyleAttributes().setLocked(false);
        }
    }

    @Override
    public void actionCalculateCheck_actionPerformed(ActionEvent e) throws Exception {
        List<Integer> selectList = this.getSelectedRowNumList();
        this.checkSelected(selectList);
        String oprtState = this.getOprtStateType();
        for (Integer rowNum : selectList) {
            IRow row = this.tbl.getRow(rowNum.intValue());
            Object period = row.getCell(TB_PERIOD).getValue();
            if (null == period || StringUtil.isEmpty((String)period.toString())) {
                row.getCell("checkResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"periodIsNull"));
                continue;
            }
            CalculateParams params = new CalculateParams();
            try {
                this.buildParams(row, params, oprtState);
            }
            catch (Exception ex) {
                logger.error((Object)"\u6784\u9020\u68c0\u67e5\u9879\u53c2\u6570\u51fa\u9519", (Throwable)ex);
                row.getCell("checkResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateError"));
                row.getCell("checkResult").getStyleAttributes().setFontColor(Color.RED);
                continue;
            }
            this.doDealCheck(params, row, rowNum);
        }
    }

    private void doDealCheck(CalculateParams params, IRow row, int rowNum) {
        boolean checkUnAuditBill = this.chk_UnAuditBill.isSelected();
        boolean checkZeroPrice = this.chk_PriceIsZero.isSelected();
        boolean isExistUnAuditBill = true;
        boolean isExistInBillPriceIsZero = true;
        int checkNum = 0;
        int checkPass = 0;
        StringBuffer checkResultSb = new StringBuffer();
        if (checkUnAuditBill) {
            ++checkNum;
            try {
                isExistUnAuditBill = CostCalChkFacadeFactory.getRemoteInstance().isExistUnAuditBill(params);
            }
            catch (CalculateException calEx) {
                isExistUnAuditBill = true;
            }
            catch (Exception ex) {
                logger.error((Object)"\u68c0\u67e5\u662f\u5426\u5b58\u5728\u672a\u5ba1\u6838\u5355\u636e\u51fa\u9519", (Throwable)ex);
                row.getCell("checkResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateError"));
                row.getCell("checkResult").getStyleAttributes().setFontColor(Color.RED);
                return;
            }
            if (isExistUnAuditBill) {
                checkResultSb.append(EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"checkUnAuditBill") + ":" + EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"unPass") + "\n");
            } else {
                ++checkPass;
                checkResultSb.append(EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"checkUnAuditBill") + ":" + EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"pass") + "\n");
            }
        }
        if (checkZeroPrice) {
            ++checkNum;
            try {
                isExistInBillPriceIsZero = CostCalChkFacadeFactory.getRemoteInstance().isExistInBillPriceIsZero(params);
            }
            catch (CalculateException calEx) {
                isExistInBillPriceIsZero = true;
            }
            catch (Exception ex) {
                logger.error((Object)"\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5165\u5e93\u4ef7\u683c\u4e3a0\u51fa\u9519", (Throwable)ex);
                row.getCell("checkResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateError"));
                row.getCell("checkResult").getStyleAttributes().setFontColor(Color.RED);
                return;
            }
            if (isExistInBillPriceIsZero) {
                checkResultSb.append(EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"checkInPriceZero") + ":" + EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"unPass") + "\n");
            } else {
                ++checkPass;
                checkResultSb.append(EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"checkInPriceZero") + ":" + EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"pass") + "\n");
            }
        }
        if (checkResultSb.length() > 0) {
            row.getCell("checkResult").setValue((Object)checkResultSb.substring(0, checkResultSb.length() - 1));
            if (checkNum == checkPass) {
                row.getCell("checkResult").getStyleAttributes().setFontColor(GREEN);
            } else {
                row.getCell("checkResult").getStyleAttributes().setFontColor(Color.RED);
            }
        }
        int height = this.tbl.getRow(rowNum).getHeight();
        this.checkResultHeight = (checkNum == 0 ? 1 : checkNum) * this.rowHeight;
        if (this.checkResultHeight > height) {
            this.tbl.getRow(rowNum).setHeight(this.checkResultHeight);
        }
    }

    private void buildParams(IRow row, CalculateParams params, String oprtState) throws EASBizException, BOSException {
        Object[] infos = (Object[])row.getCell(TB_ACCOUNTTYPE).getValue();
        String[] allAccountTypes = new String[]{};
        if (null != infos && infos.length > 0) {
            allAccountTypes = new String[infos.length];
            ArrayList<String> temp = new ArrayList<String>();
            for (Object info : infos) {
                temp.add(String.valueOf(((EnumDictionaryInfo)info).getKey()));
            }
            temp.toArray(allAccountTypes);
        }
        params.setString("OprtState", oprtState);
        params.setString("CALCULATEMATERIALRANGE", oprtState);
        params.setString("CALTYPE", this.getString(row, "range"));
        params.setString("COMPANY_ID", this.getString(row, "id"));
        params.setString("COMPANY_NAME", this.getString(row, "name"));
        params.setString("COMPANY_NUMBER", this.getString(row, "number"));
        Object[] sou = (Object[])row.getCell("storageOrgName").getValue();
        HashSet<String> souNumber = new HashSet<String>();
        HashSet<String> souId = new HashSet<String>();
        if (sou != null && sou.length > 0) {
            for (Object o : sou) {
                Object[] storageOrgUnitInfo = (Object[])o;
                souNumber.add(storageOrgUnitInfo.getNumber());
                souId.add(storageOrgUnitInfo.getId().toString());
            }
        }
        Set sous = this.getOrgUnit(souId);
        Object[] warehouse = (Object[])row.getCell("warehouse").getValue();
        HashSet<String> warehouseNumber = new HashSet<String>();
        HashSet<String> warehouseId = new HashSet<String>();
        if (warehouse != null && warehouse.length > 0) {
            for (Object o : warehouse) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)o;
                warehouseNumber.add(warehouseInfo.getNumber());
                warehouseId.add(warehouseInfo.getId().toString());
            }
        }
        Set warehouses = this.getWarehouse(warehouseId);
        Object[] materialFrom = (Object[])row.getCell("materialFrom").getValue();
        String materialFromNumber = null;
        String materialInNumber = null;
        if (materialFrom != null) {
            if (materialFrom.length == 1) {
                materialFromNumber = ((MaterialInfo)materialFrom[0]).getNumber();
            } else {
                StringBuffer materialNumber = new StringBuffer();
                for (int i = 0; i < materialFrom.length; ++i) {
                    if (i != 0) {
                        materialNumber.append("','");
                    }
                    materialNumber.append(((MaterialInfo)materialFrom[i]).getNumber());
                }
                materialInNumber = materialNumber.toString();
            }
        }
        MaterialInfo materialTo = (MaterialInfo)row.getCell("materialTo").getValue();
        String materialToNumber = null;
        if (materialTo != null) {
            materialToNumber = materialTo.getNumber();
        }
        if (souNumber.size() > 0) {
            params.setObject("STORAGEORGUNIT_NUMBER", (Object)souNumber.toArray(new String[souNumber.size()]));
        }
        if (warehouseNumber.size() > 0) {
            params.setObject("STORAGEORGUNIT_NUMBER", (Object)warehouseNumber.toArray(new String[warehouseNumber.size()]));
        }
        params.setObject("STORAGEORGUNITID", (Object)sous);
        params.setObject("WAREHOUSEID", (Object)warehouses);
        params.setString("MATERIAL_FROM", materialFromNumber);
        params.setString("MATERIAL_TO", materialToNumber);
        params.setString("MATERIAL_IN", materialInNumber);
        params.setInt("CALCULATE_CREATE_ITEM", 0);
        String periodId = this.getString(row, "periodId");
        PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        params.setObject("PERIOD_OBJ", (Object)periodInfo);
        Object issueType = row.getCell(TB_COSTADJUSTBILLTYPE).getValue();
        if (null != issueType) {
            params.setInt("COST_ADJUST_ISSUE_TYPE", ((AdjustmentOrderType)((Object)issueType)).getValue());
        }
        params.setString("taskID", String.valueOf(System.currentTimeMillis()));
        params.setString("t_cl_progressTableName", "t_cl_progress");
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", this.chk_WriteAllCostCalRpt.isSelected());
        params.setBoolean("ISWRITEDEXPCOSTRPT", this.chk_WriteExpRpt.isSelected());
        params.setBoolean("isWriteCostComputePriceSource", this.chk_WriteCostComputePriceSourceRpt.isSelected());
        params.setObject("allAccountTypes", (Object)allAccountTypes);
        params.setObject("isPerf", (Object)Boolean.TRUE);
    }

    private Set getOrgUnit(Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.setSelector(selector);
        view.setFilter(filter);
        CoreBaseCollection collection = StorageOrgUnitFactory.getRemoteInstance().getCollection(view);
        HashSet<CoreBaseInfo> orgSet = new HashSet<CoreBaseInfo>();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                orgSet.add(collection.get(i));
            }
        }
        return orgSet;
    }

    private Set getWarehouse(Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.setSelector(selector);
        view.setFilter(filter);
        CoreBaseCollection collection = WarehouseFactory.getRemoteInstance().getCollection(view);
        HashSet<CoreBaseInfo> orgSet = new HashSet<CoreBaseInfo>();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                orgSet.add(collection.get(i));
            }
        }
        return orgSet;
    }

    protected List<Integer> getSelectedRowNumList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = this.tbl.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tbl.getRow(i);
            if (!row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
            list.add(i);
        }
        return list;
    }

    private void checkSelected(List<Integer> selectList) {
        if (selectList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private String getString(IRow row, String key) {
        if (null != row.getCell(key)) {
            return (String)row.getCell(key).getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCostCalculate_actionPerformed(ActionEvent e) throws Exception {
        List<Integer> selectList = this.getSelectedRowNumList();
        this.checkSelected(selectList);
        String oprtState = this.getOprtStateType();
        for (Integer rowNum : selectList) {
            IRow row = this.tbl.getRow(rowNum.intValue());
            Object period = row.getCell(TB_PERIOD).getValue();
            if (null == period || StringUtil.isEmpty((String)period.toString())) {
                row.getCell("calculateResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"periodIsNull"));
                row.getCell("calculateResult").getStyleAttributes().setFontColor(Color.RED);
                continue;
            }
            Object[] accountType = (Object[])row.getCell(TB_ACCOUNTTYPE).getValue();
            if (null == accountType || accountType.length == 0) {
                String couId = this.getString(row, "id");
                Object[] materialFrom = (Object[])row.getCell("materialFrom").getValue();
                String materialFromNumber = null;
                String materialInNumber = null;
                if (materialFrom != null) {
                    if (materialFrom.length == 1) {
                        materialFromNumber = ((MaterialInfo)materialFrom[0]).getNumber();
                    } else {
                        StringBuffer materialnumber = new StringBuffer();
                        for (int i = 0; i < materialFrom.length; ++i) {
                            if (i != 0) {
                                materialnumber.append("','");
                            }
                            materialnumber.append(((MaterialInfo)materialFrom[i]).getNumber());
                        }
                        materialInNumber = materialnumber.toString();
                    }
                }
                MaterialInfo materialTo = (MaterialInfo)row.getCell("materialTo").getValue();
                String materialToNumber = null;
                if (materialTo != null) {
                    materialToNumber = materialTo.getNumber();
                }
                IRowSet rs = CostCalculateFacadeFactory.getRemoteInstance().getMaterialAccountType(materialFromNumber, materialToNumber, materialInNumber, couId);
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString("FACCOUNTTYPE"));
                }
                if (list.size() > 0) {
                    EntityViewInfo entity = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("enum", (Object)"com.kingdee.eas.basedata.master.material.AccountTypeEnum"));
                    entity.setFilter(filter);
                    EnumDictionaryCollection collection = EnumDictionaryFactory.getRemoteInstance().getCollection(entity);
                    ArrayList<EnumDictionaryInfo> dictionaryInfos = new ArrayList<EnumDictionaryInfo>();
                    if (null != collection && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            EnumDictionaryInfo dictionaryInfo = collection.get(i);
                            if (!list.contains(String.valueOf(dictionaryInfo.getKey()))) continue;
                            dictionaryInfos.add(dictionaryInfo);
                        }
                    }
                    accountType = new EnumDictionaryInfo[dictionaryInfos.size()];
                    row.getCell(TB_ACCOUNTTYPE).setValue((Object)dictionaryInfos.toArray(accountType));
                }
            }
            if (accountType == null || accountType.length == 0) {
                row.getCell("calculateResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"ACCOUNT_TYPE_NULL"));
                break;
            }
            CalculateParams params = new CalculateParams();
            try {
                this.buildParams(row, params, oprtState);
            }
            catch (Exception ex) {
                logger.error((Object)"\u6784\u9020\u68c0\u67e5\u9879\u53c2\u6570\u51fa\u9519", (Throwable)ex);
                row.getCell("calculateResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateError"));
                row.getCell("calculateResult").getStyleAttributes().setFontColor(Color.RED);
                continue;
            }
            ConcurrentHashMap<String, Object> resultMap = new ConcurrentHashMap<String, Object>();
            this.dealByAccountTypes(params, resultMap);
            Map<String, Object> map = this.jobMap;
            synchronized (map) {
                Map<Integer, List<Map<String, Object>>> map2 = this.localMap;
                synchronized (map2) {
                    this.dealResultAddToJob(rowNum, resultMap);
                }
            }
        }
        if (!this.taskState) {
            this.taskState = true;
            this.materialCalculateCostTimerTask = new PageTimerTask(this);
            Timer timer = new Timer();
            timer.schedule(this.materialCalculateCostTimerTask, 1000L, 5000L);
        }
    }

    private void dealResultAddToJob(int rowNum, Map<String, Object> resultMap) {
        StringBuffer info = new StringBuffer();
        ArrayList jobs = new ArrayList();
        int successNum = 0;
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            String key = entry.getKey();
            String accountTypeName = this.getAccountTypeName(Integer.valueOf(key), "");
            Map value = (Map)entry.getValue();
            info.append(accountTypeName + ":");
            Map<String, String> calcResult = new HashMap<String, String>();
            if (null != value.get("warning")) {
                info.append(value.get("warning") + "\n");
                calcResult.put("rowNum", String.valueOf(rowNum));
                calcResult.put(TB_ACCOUNTTYPE, key);
                calcResult.put("msg", value.get("warning") + "\n");
            } else if (null != value.get("error")) {
                info.append(value.get("error") + "\n");
                calcResult.put("rowNum", String.valueOf(rowNum));
                calcResult.put(TB_ACCOUNTTYPE, key);
                calcResult.put("msg", value.get("error") + "\n");
            } else if (null != value.get("calcResult")) {
                calcResult = (Map)value.get("calcResult");
                if (null != calcResult.get("jobInstExtId")) {
                    info.append(EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"bgJobCreate") + "\n");
                    String jobInstExtId = calcResult.get("jobInstExtId").toString();
                    calcResult.put("rowNum", String.valueOf(rowNum));
                    calcResult.put(TB_ACCOUNTTYPE, key);
                    this.jobMap.put(jobInstExtId, calcResult);
                } else {
                    info.append(EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateSuccess") + "\n");
                    ++successNum;
                }
            }
            jobs.add(calcResult);
        }
        int height = this.tbl.getRow(rowNum).getHeight();
        this.calculateResultHeight = this.rowHeight * (resultMap.size() == 0 ? 1 : resultMap.size());
        if (this.calculateResultHeight > height) {
            this.tbl.getRow(rowNum).setHeight(this.calculateResultHeight);
        }
        ICell cell = this.tbl.getCell(rowNum, "calculateResult");
        if (info.length() > 0) {
            cell.setValue((Object)info.substring(0, info.length() - 1));
            if (successNum > 0) {
                if (successNum == resultMap.size()) {
                    cell.getStyleAttributes().setFontColor(GREEN);
                } else {
                    cell.getStyleAttributes().setFontColor(Color.RED);
                }
            } else {
                cell.getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
        this.localMap.put(rowNum, jobs);
    }

    private void dealByAccountTypes(CalculateParams params, Map<String, Object> resultMap) {
        SysContext ctx = SysContext.getSysContext();
        params.setObject("CURRENT_USER", (Object)ctx.getCurrentUserInfo());
        params.setObject("CURRENT_COMPANY", (Object)ctx.getCurrentFIUnit());
        params.setObject("CURRENT_CU", (Object)ctx.getCurrentCtrlUnit());
        params.setObject("languageLocale", (Object)ctx.getOriginLocale());
        params.setBoolean("ISMOVEAVGRECALCUALTEBILLCOST", true);
        String[] accountTypes = (String[])params.getObject("allAccountTypes");
        for (int j = 0; j < accountTypes.length; ++j) {
            HashMap<String, Object> accountRs = new HashMap<String, Object>();
            String currAccountType = accountTypes[j].trim();
            try {
                params.setInt("ACCOUNT_TYPE", Integer.parseInt(currAccountType));
                String title = null;
                JobConfig jobCfg = this.createJobCfg(ctx, params, params.getInt("ACCOUNT_TYPE"));
                title = params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal") ? this.getRes("RowMaterial_Msg", ctx) + this.getAccountTypeName(params.getInt("ACCOUNT_TYPE"), "-") : this.getRes("FinshGoods_Msg", ctx) + this.getAccountTypeName(params.getInt("ACCOUNT_TYPE"), "-");
                params.setString("title", title);
                HashMap<String, String> con = new HashMap<String, String>();
                String notCalculate = params.getString("COMPANY_NUMBER") + "SCM_CAL_0002";
                con.put("CloseMutexCalculate", notCalculate);
                con.put("CALCULATE_ROWMATEIAL_WAITE", jobCfg.getTaskType());
                Map rs = CostCalculateFacadeFactory.getRemoteInstance().fetchData(con);
                if (((Boolean)rs.get("CloseMutexCalculate")).booleanValue()) {
                    accountRs.put("warning", this.getRes("CloseMutexCalculate_Msg", ctx));
                    resultMap.put(currAccountType, accountRs);
                    break;
                }
                if (((Boolean)rs.get("CALCULATE_ROWMATEIAL_WAITE")).booleanValue()) {
                    if (params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) {
                        accountRs.put("warning", this.getRes("CALCULATE_ROWMATEIAL_WAITE_MSG", ctx));
                    } else {
                        accountRs.put("warning", this.getRes("CALCULATE_FINSHGOOD_WAITE_MSG", ctx));
                    }
                    resultMap.put(currAccountType, accountRs);
                    continue;
                }
                String calType = "prdOutCal";
                if ("rawMaterailCostCal".equals(params.getString("CALCULATEMATERIALRANGE"))) {
                    calType = "matOutCal";
                }
                try {
                    CostUpdateMutexFacadeFactory.getRemoteInstance().checkCostUpdateMutex(params.getString("COMPANY_ID"), calType);
                }
                catch (EASBizException e) {
                    accountRs.put("warning", e.getMessage());
                    resultMap.put(currAccountType, accountRs);
                    continue;
                }
                Map result = CreateJobFacadeFactory.getRemoteInstance().executeJob(new JobParam((Object)params), jobCfg);
                accountRs.put("calcResult", result);
            }
            catch (EASBizException EASEx) {
                accountRs.put("error", true);
                logger.error((Object)"\u51fa\u5e93\u6838\u7b97\u51fa\u9519", (Throwable)EASEx);
            }
            catch (BOSException BOSEx) {
                accountRs.put("error", true);
                logger.error((Object)"\u51fa\u5e93\u6838\u7b97\u51fa\u9519", (Throwable)BOSEx);
            }
            resultMap.put(currAccountType, accountRs);
        }
    }

    private JobConfig createJobCfg(SysContext ctx, CalculateParams params, int accountType) {
        JobConfig jobCfg = new JobConfig();
        String title = "\u3010" + params.getString("COMPANY_NAME") + "(" + params.getString("COMPANY_NUMBER") + ")\u3011";
        if (params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) {
            jobCfg.setNumber("SCM_CAL_0001");
            jobCfg.setTaskType(params.getString("COMPANY_NUMBER") + "SCM_CAL_0001");
            title = title + this.getRes("RowMaterial_Msg", ctx) + this.getAccountTypeName(params.getInt("ACCOUNT_TYPE"), "-");
        } else {
            jobCfg.setNumber("SCM_CAL_0003");
            jobCfg.setTaskType(params.getString("COMPANY_NUMBER") + "SCM_CAL_0003");
            title = title + this.getRes("FinshGoods_Msg", ctx) + this.getAccountTypeName(params.getInt("ACCOUNT_TYPE"), "-");
        }
        jobCfg.setTaskType(jobCfg.getTaskType() + "ACCOUNT_TYPE_" + accountType);
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        return jobCfg;
    }

    private String getRes(String strKey, SysContext ctx) {
        return SCMUtils.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)strKey, (Locale)ctx.getLocale());
    }

    private String getAccountTypeName(int accountType, String res) {
        String resFile = "com.kingdee.eas.scm.common.SCMResource";
        if (null == res) {
            res = "-";
        }
        res = accountType == 3 ? res + EASResource.getString((String)resFile, (String)"ADD_AVERAGE_VALUE") : (accountType == 6 ? res + EASResource.getString((String)resFile, (String)"MOVE_WEIGHTED_AVERAGE_VALUE") : (accountType == 1 ? res + EASResource.getString((String)resFile, (String)"MOVE_ADD_AVERAGE_VALUE") : (accountType == 2 ? res + EASResource.getString((String)resFile, (String)"STANDARDCOST_VALUE") : (accountType == 4 ? res + EASResource.getString((String)resFile, (String)"FIN_FOUT_VALUE") : (accountType == 5 ? res + EASResource.getString((String)resFile, (String)"SPECIAL_ACCT_VALUE") : null)))));
        return res;
    }

    @Override
    public void doTimerTask() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        if (null == this.jobMap || this.jobMap.size() == 0) {
            logger.info((Object)"\u6ca1\u6709\u8981\u5904\u7406\u7684\u6570\u636e\u4efb\u52a1\u7ed3\u675f------");
            return;
        }
        logger.info((Object)"\u6838\u7b97\u7ed3\u679c\u5b9a\u65f6\u67e5\u8be2\u4efb\u52a1\u5f00\u59cb------");
        logger.info((Object)("\u6838\u7b97\u7ed3\u679c\u5b9a\u65f6\u67e5\u8be2\u4efb\u52a1\u5f00\u59cb\u672c\u6b21\u4efb\u52a1\u6570------" + this.jobMap.size()));
        this.preDealData(ids);
        if (ids.size() == 0) {
            logger.info((Object)"\u6ca1\u6709\u8981\u5904\u7406\u7684\u72b6\u6001\u6570\u636e\uff0c\u4efb\u52a1\u7ed3\u675f------");
            return;
        }
        String[] jobIds = new String[ids.size()];
        ids.toArray(jobIds);
        JobInstExtCollection jobInstCol = JobInstStatusFacadeFactory.getRemoteInstance().queryJobInstStatus(jobIds);
        if (null != jobInstCol && jobInstCol.size() > 0) {
            this.doDealResult(jobInstCol);
            this.showToPage();
        }
        logger.info((Object)"\u6838\u7b97\u7ed3\u679c\u5b9a\u65f6\u67e5\u8be2\u4efb\u52a1\u7ed3\u675f------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preDealData(List<String> ids) {
        Map<String, Object> map = this.jobMap;
        synchronized (map) {
            for (Map.Entry<String, Object> jobEntry : this.jobMap.entrySet()) {
                if (null == jobEntry.getValue()) continue;
                Map jobInfo = (Map)jobEntry.getValue();
                String jobInstExtId = jobEntry.getKey();
                if (null != jobInfo.get("progress") && "100".equals(jobInfo.get("progress").toString())) continue;
                ids.add(jobInstExtId);
            }
        }
    }

    private void doDealResult(JobInstExtCollection jobInstCol) {
        int size = jobInstCol.size();
        for (int i = 0; i < size; ++i) {
            JobInstExtInfo jobInfo = jobInstCol.get(i);
            Map map = (Map)this.jobMap.get(jobInfo.getId().toString());
            String accountType = (String)map.get(TB_ACCOUNTTYPE);
            map.put("progress", jobInfo.getProgress());
            map.put("state", jobInfo.getState());
            map.put("msg", this.getAccountTypeName(Integer.valueOf(accountType), "") + ":" + jobInfo.getState() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showToPage() {
        Map<Integer, List<Map<String, Object>>> map = this.localMap;
        synchronized (map) {
            for (Map.Entry<Integer, List<Map<String, Object>>> row : this.localMap.entrySet()) {
                Integer rowIndex = row.getKey();
                List<Map<String, Object>> jobInfos = row.getValue();
                int size = jobInfos.size();
                if (null == jobInfos || size == 0) continue;
                int completeNum = 0;
                boolean flag = true;
                StringBuffer msg = new StringBuffer();
                for (Map<String, Object> job : jobInfos) {
                    if (flag && (null == job.get("progress") || !"100".equals(job.get("progress").toString()))) {
                        flag = false;
                    }
                    if (JobStateEnum.COMPLETE.equals(job.get("state"))) {
                        ++completeNum;
                    }
                    msg.append(job.get("msg"));
                }
                int height = this.tbl.getRow(rowIndex.intValue()).getHeight();
                this.calculateResultHeight = this.rowHeight * (size == 0 ? 1 : size);
                if (this.calculateResultHeight > height) {
                    this.tbl.getRow(rowIndex.intValue()).setHeight(this.calculateResultHeight);
                }
                ICell cell = this.tbl.getCell(rowIndex.intValue(), "calculateResult");
                if (msg.length() <= 0) continue;
                String newMsg = msg.substring(0, msg.length() - 1);
                if (flag) {
                    if (completeNum == size) {
                        cell.setValue((Object)newMsg);
                        cell.getStyleAttributes().setFontColor(GREEN);
                        continue;
                    }
                    cell.setValue((Object)newMsg);
                    cell.getStyleAttributes().setFontColor(Color.RED);
                    continue;
                }
                cell.setValue((Object)newMsg);
                cell.getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        Map<Object, Object> map = this.jobMap;
        synchronized (map) {
            this.jobMap.clear();
        }
        map = this.localMap;
        synchronized (map) {
            this.localMap.clear();
        }
        this.taskState = false;
        if (null != this.materialCalculateCostTimerTask) {
            this.materialCalculateCostTimerTask.cancel();
        }
    }

    @Override
    public boolean taskState() {
        return this.taskState;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.doStop();
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        this.doStop();
        return super.checkBeforeWindowClosing();
    }

    private boolean costAdjust(KDTMouseEvent e) {
        int selectedrow = this.tbl.getSelectManager().getActiveRowIndex();
        String period = (String)this.tbl.getRow(selectedrow).getCell(TB_PERIOD).getValue();
        if (period == null || period == "") {
            MsgBox.showWarning((String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"PERIODCANTBENULL"));
            return false;
        }
        Object[] accountType = (Object[])this.tbl.getRow(selectedrow).getCell(TB_ACCOUNTTYPE).getValue();
        if (accountType == null) {
            MsgBox.showWarning((String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"FifoIsNotSelected"));
            return false;
        }
        HashSet<Integer> key = new HashSet<Integer>();
        for (int i = 0; i < accountType.length; ++i) {
            EnumDictionaryInfo info = (EnumDictionaryInfo)accountType[i];
            key.add(info.getKey());
        }
        if (!key.contains(4)) {
            MsgBox.showWarning((String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"FifoIsNotSelected"));
            return false;
        }
        Object costAdjustBillType = this.tbl.getRow(selectedrow).getCell(TB_COSTADJUSTBILLTYPE).getValue();
        if (costAdjustBillType == null) {
            MsgBox.showWarning((String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"NoOutboundTypeIsSelected"));
            return false;
        }
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"ConfirmWhetherTheCostAdjustmentSheetIsGenerated"));
        if (0 == result) {
            this.checkSelected();
            String oprtState = this.getOprtStateType();
            CalculateParams params = new CalculateParams();
            IRow row = this.tbl.getRow(selectedrow);
            try {
                this.buildParams(row, params, oprtState);
            }
            catch (Exception ex) {
                logger.error((Object)"\u6784\u9020\u68c0\u67e5\u9879\u53c2\u6570\u51fa\u9519", (Throwable)ex);
                row.getCell("checkResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateError"));
                return false;
            }
            try {
                ICalculateFacade ida = CalculateFacadeFactory.getRemoteInstance();
                CalculateParams cps = ida.outInvAdjust(params);
                return cps.getBoolean("boolean");
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        } else {
            return false;
        }
        return false;
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void initCostAdjustBillType() {
        KDComboBox comChangeType = new KDComboBox();
        comChangeType.setName("comChangeType");
        comChangeType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.scm.cal.AdjustmentOrderType").toArray());
        this.tbl.getColumn(TB_COSTADJUSTBILLTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comChangeType));
    }

    private void showExceptionBill(KDTMouseEvent e) {
        int selectedrow = this.tbl.getSelectManager().getActiveRowIndex();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String oprtState = this.getOprtStateType();
        map.put("OPRTSTATE", oprtState);
        String period = (String)this.tbl.getRow(selectedrow).getCell(TB_PERIOD).getValue();
        if (period == null || period == "") {
            MsgBox.showWarning((String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"PERIODCANTBENULL"));
            return;
        }
        int year = Integer.parseInt(period.substring(0, 4));
        int periodInt = 0;
        int length = period.length();
        periodInt = length == 7 ? Integer.parseInt(period.substring(5, 6)) : Integer.parseInt(period.substring(5, 7));
        map.put("YEAR_FROM", year);
        map.put("PERIOD_FROM", periodInt);
        String couId = (String)this.tbl.getRow(selectedrow).getCell("id").getValue();
        map.put("FCompanyOrgUnitID", couId);
        Object[] sou = (Object[])this.tbl.getRow(selectedrow).getCell("storageOrgName").getValue();
        String souId = "";
        if (sou != null && sou.length > 0) {
            for (int i = 0; i < sou.length - 1; ++i) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)sou[i];
                souId = souId + " '" + storageOrgUnitInfo.getId().toString() + "' ,";
            }
            StorageOrgUnitInfo OrgUnitInfo2 = (StorageOrgUnitInfo)sou[sou.length - 1];
            souId = souId + " '" + OrgUnitInfo2.getId().toString() + "' ";
        }
        map.put("Fstorageorgunitid", souId);
        Object[] o = (Object[])this.tbl.getRow(selectedrow).getCell("warehouse").getValue();
        if (o != null && o.length > 0) {
            WarehouseInfo[] warehouse = new WarehouseInfo[o.length];
            for (int i = 0; i < warehouse.length; ++i) {
                WarehouseInfo warehouseInfo;
                warehouse[i] = warehouseInfo = (WarehouseInfo)o[i];
            }
            map.put("Fwarehouseid", warehouse);
        } else {
            map.put("Fwarehouseid", null);
        }
        Object[] materialFrom = (Object[])this.tbl.getRow(selectedrow).getCell("materialFrom").getValue();
        MaterialInfo materialTo = (MaterialInfo)this.tbl.getRow(selectedrow).getCell("materialTo").getValue();
        map.put("MATERIAL_ID_FROM", materialFrom);
        map.put("MATERIAL_ID_TO", materialTo);
        this.showExceptionBillQueryUI(e, map);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.doStop();
        super.actionRefresh_actionPerformed(e);
    }

    private boolean exceptionAdjust(KDTMouseEvent e) {
        int selectedrow = this.tbl.getSelectManager().getActiveRowIndex();
        String period = (String)this.tbl.getRow(selectedrow).getCell(TB_PERIOD).getValue();
        if (period == null || period == "") {
            MsgBox.showWarning((String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"PERIODCANTBENULL"));
            return false;
        }
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"checkWhetherAbnormalDataResetIsPerformed"));
        if (0 == result) {
            String oprtState = this.getOprtStateType();
            CalculateParams params = new CalculateParams();
            IRow row = this.tbl.getRow(selectedrow);
            try {
                this.buildParams(row, params, oprtState);
            }
            catch (Exception ex) {
                logger.error((Object)"\u6784\u9020\u68c0\u67e5\u9879\u53c2\u6570\u51fa\u9519", (Throwable)ex);
                row.getCell("checkResult").setValue((Object)EASResource.getString((String)materialCalculateCostPlatformEASResource, (String)"operateError"));
                return false;
            }
            try {
                ICalculateFacade ida = CalculateFacadeFactory.getRemoteInstance();
                CalculateParams cps = ida.expDataAdjZero(params);
                return cps.getBoolean("boolean");
            }
            catch (CalculateException ce) {
                logger.error((Object)"\u5f02\u5e38\u6570\u636e\u8c030\u62a5\u9519");
                this.handleException((Exception)((Object)ce));
            }
            catch (Exception e1) {
                logger.error((Object)"\u5f02\u5e38\u6570\u636e\u8c030\u62a5\u9519");
                this.handleException(e1);
            }
        } else {
            return false;
        }
        return false;
    }

    private void showExceptionBillQueryUI(KDTMouseEvent e, HashMap map) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"FCompanyOrgUnitID", map.get("FCompanyOrgUnitID"));
        uiContext.put((Object)"Fstorageorgunitid", map.get("Fstorageorgunitid"));
        uiContext.put((Object)"Fwarehouseid", map.get("Fwarehouseid"));
        uiContext.put((Object)"MATERIAL_FROM", map.get("MATERIAL_FROM"));
        uiContext.put((Object)"MATERIAL_TO", map.get("MATERIAL_TO"));
        uiContext.put((Object)"PERIOD_FROM", map.get("PERIOD_FROM"));
        uiContext.put((Object)"YEAR_FROM", map.get("YEAR_FROM"));
        uiContext.put((Object)"MATERIAL_ID_FROM", map.get("MATERIAL_ID_FROM"));
        uiContext.put((Object)"MATERIAL_ID_TO", map.get("MATERIAL_ID_TO"));
        uiContext.put((Object)"CALCULATEMATERIALRANGE", (Object)this.params.getString("CALCULATEMATERIALRANGE"));
        String UIName = "com.kingdee.eas.scm.cal.client.ExceptionBillQueryUI";
        IUIWindow uiWindow = null;
        Window parentWin = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (parentWin != null && parentWin instanceof JDialog) {
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(UIName, (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                this.handleException((Exception)((Object)e1));
            }
        } else {
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(UIName, (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
        if (parentWin != null && parentWin instanceof JDialog) {
            parentWin.dispose();
        }
        uiWindow.show();
    }

    private void showSumReport(KDTMouseEvent e) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String oprtState = this.getOprtStateType();
        map.put("OPRTSTATE", oprtState);
        int selectedrow = this.tbl.getSelectManager().getActiveRowIndex();
        String period = (String)this.tbl.getRow(selectedrow).getCell(TB_PERIOD).getValue();
        if (period == null || period == "") {
            return;
        }
        int year = Integer.parseInt(period.substring(0, 4));
        int periodInt = 0;
        int length = period.length();
        periodInt = length == 7 ? Integer.parseInt(period.substring(5, 6)) : Integer.parseInt(period.substring(5, 7));
        map.put("YEAR_FROM", year);
        map.put("PERIOD_FROM", periodInt);
        String couId = (String)this.tbl.getRow(selectedrow).getCell("id").getValue();
        map.put("FCompanyOrgUnitID", couId);
        Object[] sou = (Object[])this.tbl.getRow(selectedrow).getCell("storageOrgName").getValue();
        HashSet<String> souNumber = new HashSet<String>();
        HashSet<String> souIdSet = new HashSet<String>();
        if (sou != null && sou.length > 0) {
            for (Object object : sou) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)object;
                souNumber.add(storageOrgUnitInfo.getNumber());
                souIdSet.add(storageOrgUnitInfo.getId().toString());
            }
        }
        Object[] warehouse = (Object[])this.tbl.getRow(selectedrow).getCell("warehouse").getValue();
        HashSet<String> warehouseNumber = new HashSet<String>();
        HashSet<String> warehousIdSet = new HashSet<String>();
        if (warehouse != null && warehouse.length > 0) {
            for (Object o : warehouse) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)o;
                warehouseNumber.add(warehouseInfo.getNumber());
                warehousIdSet.add(warehouseInfo.getId().toString());
            }
        }
        if (souIdSet.size() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo sowhFilter = new FilterInfo();
            FilterItemCollection filterItems = sowhFilter.getFilterItems();
            filterItems.add(new FilterItemInfo("STORAGEORG", souIdSet, CompareType.INCLUDE));
            if (warehousIdSet.size() > 0) {
                filterItems.add(new FilterItemInfo("WAREHOUSE", warehousIdSet, CompareType.INCLUDE));
            }
            filterItems.add(new FilterItemInfo("ISSTARTED", (Object)1));
            entityViewInfo.setFilter(sowhFilter);
            SelectorItemCollection sowhSic = new SelectorItemCollection();
            sowhSic.add(new SelectorItemInfo("warehouse"));
            sowhSic.add(new SelectorItemInfo("storageOrg"));
            entityViewInfo.setSelector(sowhSic);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.getSorter().add(new SorterItemInfo("storageOrg"));
            sorter.getSorter().add(new SorterItemInfo("warehouse"));
            entityViewInfo.setSorter(sorter);
            SOAccreditWHCollection sowhColl = SOAccreditWHFactory.getRemoteInstance().getSOAccreditWHCollection(entityViewInfo);
            if (sowhColl != null && sowhColl.size() > 0) {
                HashSet<String> sowhSet = new HashSet<String>();
                for (int i = 0; i < sowhColl.size(); ++i) {
                    if (!souIdSet.contains(sowhColl.get(i).getStorageOrg())) continue;
                    if (warehousIdSet.size() > 0) {
                        if (!warehousIdSet.contains(sowhColl.get(i).getWarehouse())) continue;
                        sowhSet.add(sowhColl.get(i).getStorageOrg() + ";" + sowhColl.get(i).getWarehouse());
                        continue;
                    }
                    sowhSet.add(sowhColl.get(i).getStorageOrg());
                }
                map.put("sowhSet", sowhSet);
            }
        }
        map.put("Fstorageorgunitid", souNumber);
        map.put("Fwarehouseid", warehouseNumber);
        Object[] objectArray = (Object[])this.tbl.getRow(selectedrow).getCell("materialFrom").getValue();
        MaterialInfo materialTo = (MaterialInfo)this.tbl.getRow(selectedrow).getCell("materialTo").getValue();
        String materialToNumber = null;
        if (materialTo != null) {
            materialToNumber = materialTo.getNumber();
        }
        map.put("MATERIAL_FROM", objectArray);
        map.put("MATERIAL_TO", materialToNumber);
        try {
            this.showCostComputeSumReportUI(e, map);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void showCostComputeSumReportUI(KDTMouseEvent e, HashMap map) throws ReportException, EASBizException, BOSException, SQLException, Exception {
        RptParams rptParams = new RptParams();
        IReport report = ReportFactory.createReport((String)"bAEjbmeGI8XgQKjAYj1IztBgBtA=", null);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)((String)map.get("FCompanyOrgUnitID")), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
        String companyNumber = null;
        if (companyColl != null && companyColl.size() > 0) {
            companyNumber = companyColl.get(0).getNumber();
        }
        Set souNumber = (Set)map.get("Fstorageorgunitid");
        Set warehouseNumber = (Set)map.get("Fwarehouseid");
        Set sowhSet = (Set)map.get("sowhSet");
        if (sowhSet != null && sowhSet.size() != 0) {
            StorageOrgUnitCollection stoColl;
            FilterInfo stroageFilterInfo;
            EntityViewInfo stroageViewInfo;
            String temp = (String)sowhSet.toArray()[0];
            String[] Ids = temp.split(";");
            if (Ids.length == 2) {
                stroageViewInfo = new EntityViewInfo();
                stroageFilterInfo = new FilterInfo();
                stroageFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)Ids[0], CompareType.EQUALS));
                stroageViewInfo.setFilter(stroageFilterInfo);
                stoColl = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(stroageViewInfo);
                if (stoColl != null && stoColl.size() > 0) {
                    rptParams.setString("stroageNumber", stoColl.get(0).getNumber());
                }
                EntityViewInfo warehouseViewInfo = new EntityViewInfo();
                FilterInfo warehouseFilterInfo = new FilterInfo();
                warehouseFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)Ids[1], CompareType.EQUALS));
                warehouseViewInfo.setFilter(warehouseFilterInfo);
                WarehouseCollection wareColl = WarehouseFactory.getRemoteInstance().getWarehouseCollection(warehouseViewInfo);
                if (wareColl != null && wareColl.size() > 0) {
                    rptParams.setString("warehouseNumber", wareColl.get(0).getNumber());
                }
            } else {
                stroageViewInfo = new EntityViewInfo();
                stroageFilterInfo = new FilterInfo();
                stroageFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)Ids[0], CompareType.EQUALS));
                stroageViewInfo.setFilter(stroageFilterInfo);
                stoColl = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(stroageViewInfo);
                if (stoColl != null && stoColl.size() > 0) {
                    rptParams.setString("stroageNumber", stoColl.get(0).getNumber());
                }
            }
        }
        rptParams.setObject("sowhSet", (Object)sowhSet);
        rptParams.setString("companyNumber", companyNumber);
        rptParams.setObject("materialnumberfrom", map.get("MATERIAL_FROM"));
        rptParams.setString("materialnumberto", (String)map.get("MATERIAL_TO"));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"stroageNumber", (Object)souNumber);
        uiContext.put((Object)"warehouseNumber", (Object)warehouseNumber);
        uiContext.put((Object)"sowhSet", map.get("sowhSet"));
        uiContext.put((Object)"rptparams", (Object)rptParams);
        uiContext.put((Object)"report", (Object)report);
        uiContext.put((Object)"CALCULATEMATERIALRANGE", (Object)this.params.getString("CALCULATEMATERIALRANGE"));
        String UIName = "com.kingdee.eas.base.report.client.ReportViewerUI";
        IUIWindow uiWindow = null;
        Window parentWin = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (parentWin != null && parentWin instanceof JDialog) {
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(UIName, (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                this.handleException((Exception)((Object)e1));
            }
        } else {
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(UIName, (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
        if (parentWin != null && parentWin instanceof JDialog) {
            parentWin.dispose();
        }
        uiWindow.show();
    }

    class MouseListener4Plat
    implements MouseListener {
        MouseListener4Plat() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                IRow row;
                int i;
                int rowCount;
                if ("selectAll".equals(((KDWorkButton)e.getSource()).getName())) {
                    rowCount = MaterialCalculateCostPlatformUI.this.tbl.getRowCount();
                    for (i = 0; i < rowCount; ++i) {
                        row = MaterialCalculateCostPlatformUI.this.tbl.getRow(i);
                        if (row.getCell("periodId").getValue() == null) continue;
                        row.getCell("selected").setValue((Object)Boolean.TRUE);
                    }
                }
                if ("unSelectAll".equals(((KDWorkButton)e.getSource()).getName())) {
                    rowCount = MaterialCalculateCostPlatformUI.this.tbl.getRowCount();
                    for (i = 0; i < rowCount; ++i) {
                        row = MaterialCalculateCostPlatformUI.this.tbl.getRow(i);
                        row.getCell("selected").setValue((Object)Boolean.FALSE);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

