/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CostDiffGatherGistEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginForCostDiffGather
extends ReportListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.client.PluginForCostDiffGather");

    public void fireBeforePrint(boolean isPreview) throws Exception {
        this.checkViewPermission(this.getPrintPermission());
    }

    private String getPrintPermission() {
        return "costdiffgatherreport_print";
    }

    private String getDetailReportViewPermission() {
        return "costdiffdetailreport_view";
    }

    public void fireTableDbClick(CellEvent event) throws Exception {
        if (event.getCellValue() != null) {
            this.openCostComputeDetailRpt();
        }
    }

    private void openCostComputeDetailRpt() throws Exception {
        this.checkSelected();
        this.checkViewPermission(this.getDetailReportViewPermission());
        if (this.getEffectiveKeyValue() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        try {
            uiContext.put((Object)"rptParams", (Object)this.getDetailRptFilterEntity());
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.scm.cal.client.CostDiffDetailReportUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void checkViewPermission(String permission) throws Exception {
        ObjectUuidPK orgPK = null;
        RptParams params = this.reportApplication.getFilter();
        if (params != null) {
            OrgUnitInfo company = (OrgUnitInfo)params.getObject("company");
            orgPK = company == null ? null : new ObjectUuidPK(company.getId());
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, (String)permission);
    }

    private RptParams getDetailRptFilterEntity() throws Exception {
        HashMap selectMap;
        ArrayList selList;
        RptParams rptParams = this.getReportApplication().getFilter();
        if (rptParams != null && (selList = this.reportApplication.getSelectRows()) != null && selList.size() > 0 && (selectMap = (HashMap)selList.get(0)) != null) {
            String ids;
            String[] id;
            if (selectMap.get("FMATERIALID") != null && (id = (ids = selectMap.get("FMATERIALID").toString()).split(",")) != null && id.length > 0) {
                rptParams.setString("FMATERIALID", id[id.length - 1]);
            }
            if (selectMap.get("FMATNUMBER") != null) {
                rptParams.setString("materialFrom", selectMap.get("FMATNUMBER").toString());
                rptParams.setString("materialTo", selectMap.get("FMATNUMBER").toString());
            }
            if (selectMap.get("FYEAR") != null) {
                rptParams.setString("accPeriodYearFrom", selectMap.get("FYEAR").toString());
                rptParams.setString("accPeriodYearTo", selectMap.get("FYEAR").toString());
            }
            if (selectMap.get("FPERIODNUMBER") != null) {
                rptParams.setString("accPeriodMonthFrom", selectMap.get("FPERIODNUMBER").toString());
                rptParams.setString("accPeriodMonthTo", selectMap.get("FPERIODNUMBER").toString());
            }
            if (rptParams.getObject("sumType") != null) {
                String[] obj = null;
                CostDiffGatherGistEnum gatherGist = (CostDiffGatherGistEnum)((Object)rptParams.getObject("sumType"));
                if (CostDiffGatherGistEnum.STOCKORGUNIT.equals((Object)gatherGist)) {
                    rptParams.setString("FStorageOrgUnitID", (String)selectMap.get("FSUMTYPEID"));
                }
                if (CostDiffGatherGistEnum.STORAGE.equals((Object)gatherGist)) {
                    rptParams.setString("FWarehouseID", (String)selectMap.get("FSUMTYPEID"));
                }
                if (CostDiffGatherGistEnum.STOCKANDKACLASS.equals((Object)gatherGist) && selectMap.get("FSUMTYPEID") != null && (obj = ((String)selectMap.get("FSUMTYPEID")).split("--")) != null && obj.length > 0) {
                    rptParams.setString("FStorageOrgUnitID", obj[0]);
                }
                if (CostDiffGatherGistEnum.KACLASSANDSTOCK.equals((Object)gatherGist) && selectMap.get("FSUMTYPEID") != null && (obj = ((String)selectMap.get("FSUMTYPEID")).split("--")) != null && obj.length > 1) {
                    rptParams.setString("FStorageOrgUnitID", obj[1]);
                }
            }
        }
        if (rptParams.getObject("company") instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)rptParams.getObject("company");
            CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
            rptParams.setObject("company", (Object)curCompany);
        }
        return rptParams;
    }

    private void checkSelected() throws UIException {
        try {
            if (this.reportApplication.getSelectRows() == null || this.reportApplication.getSelectRows().size() == 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
    }

    protected String getSelectedKeyValue() {
        String keyValue;
        block6: {
            keyValue = null;
            try {
                RptParams rptParams = this.getReportApplication().getFilter();
                ArrayList selList = this.reportApplication.getSelectRows();
                if (selList == null || selList.size() <= 0) break block6;
                StringBuffer buffer = new StringBuffer();
                HashMap selectMap = (HashMap)selList.get(0);
                if (selectMap != null) {
                    if (selectMap.get("FMATNUMBER") != null && ((String)selectMap.get("FMATNUMBER")).trim() != null && ((String)selectMap.get("FMATNUMBER")).trim().length() > 0) {
                        buffer.append(selectMap.get("FMATNUMBER"));
                    }
                    if (selectMap.get("FYEAR") != null) {
                        buffer.append(selectMap.get("FYEAR"));
                    }
                    if (selectMap.get("FPERIODNUMBER") != null) {
                        buffer.append(selectMap.get("FPERIODNUMBER"));
                    }
                    buffer.append(selectMap.get("FSUMTYPEID"));
                    keyValue = buffer.toString();
                    break block6;
                }
                return null;
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return keyValue;
    }

    private String getEffectiveKeyValue() {
        String keyValue;
        block3: {
            keyValue = null;
            try {
                ArrayList selList = this.reportApplication.getSelectRows();
                if (selList == null || selList.size() <= 0) break block3;
                StringBuffer buffer = new StringBuffer();
                HashMap selectMap = (HashMap)selList.get(0);
                if (selectMap != null && selectMap.get("FMATNUMBER") != null && ((String)selectMap.get("FMATNUMBER")).trim() != null && ((String)selectMap.get("FMATNUMBER")).trim().length() > 0) {
                    buffer.append(selectMap.get("FMATNUMBER"));
                    keyValue = buffer.toString();
                    break block3;
                }
                return null;
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return keyValue;
    }
}

