/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.ExpenseApportionFacadeFactory;
import com.kingdee.eas.scm.cal.ExpenseApportionInfo;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffBillTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.client.AbstractSaleExpenseApportionReportFilterUI;
import com.kingdee.eas.scm.cal.client.SaleExpenseApportionReportUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SaleExpenseApportionReportFilterUI
extends AbstractSaleExpenseApportionReportFilterUI {
    private static final long serialVersionUID = 1L;
    private CompanyOrgUnitInfo oldCompanyInfo = null;
    SaleExpenseApportionReportUI ui = null;
    boolean isFireState = true;
    Map rs = new HashMap();
    Map<String, Map<String, PeriodInfo>> companyPeriodMap = new HashMap<String, Map<String, PeriodInfo>>();
    Map<String, Map<String, Integer>> companyMonthMap = new HashMap<String, Map<String, Integer>>();
    Map<String, Map<String, Integer>> companyYearMap = new HashMap<String, Map<String, Integer>>();

    public SaleExpenseApportionReportFilterUI(SaleExpenseApportionReportUI reportUI) throws Exception {
        this.setSize(400, 320);
        this.ui = reportUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtFinanceOrgUnit.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.prmtFinanceOrgUnit, (OrgType)OrgType.Company, (String)this.getViewPermission());
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtFinanceOrgUnit);
        this.prmtFinanceOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SaleExpenseApportionReportFilterUI.this.prmtCompanyOrgUnit(e);
            }
        });
        this.spinPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (((KDSpinner)arg0.getSource()).equals(SaleExpenseApportionReportFilterUI.this.spinPeriodYear) && SaleExpenseApportionReportFilterUI.this.isFireState) {
                    SaleExpenseApportionReportFilterUI.this.setPeriod(SaleExpenseApportionReportFilterUI.this.spinPeriodYear);
                }
            }
        });
        this.spinPeriodYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (((KDSpinner)arg0.getSource()).equals(SaleExpenseApportionReportFilterUI.this.spinPeriodYearTo) && SaleExpenseApportionReportFilterUI.this.isFireState) {
                    SaleExpenseApportionReportFilterUI.this.setPeriod(SaleExpenseApportionReportFilterUI.this.spinPeriodYearTo);
                }
            }
        });
        this.bizWriteOffMan.setEditable(true);
        this.bizWriteOffMan.setDisplayFormat("$name$");
        this.bizWriteOffMan.setEditFormat("$number$");
        this.bizWriteOffMan.setCommitFormat("$number$");
        this.onInitFilter();
        new SCMClientHelper((CoreUIObject)this).registerFilterUIDateCompare(this.pkWriteOffDate, this.pkWriteOffDateTo);
    }

    private String getViewPermission() {
        return "SaleExpenseApportionReportUI";
    }

    private int prmtCompanyOrgUnit(ChangeEvent e) {
        try {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
            if (aCompanyOrgUnitInfo != null) {
                this.rs = ExpenseApportionFacadeFactory.getRemoteInstance().fetchDatabyCou(aCompanyOrgUnitInfo.getId().toString());
                if (!this.isPeriodNotNull(aCompanyOrgUnitInfo)) {
                    return 0;
                }
                this.loadAccountPeriod(aCompanyOrgUnitInfo);
                this.setOtherBillNumberF7(this.otherBillNo, aCompanyOrgUnitInfo.getId().toString());
                CalculateUtil.setInvBillNoFilterF7(this.saleIssueBillNo, true, BillBaseStatusEnum.AUDITED);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    private boolean isPeriodNotNull(CompanyOrgUnitInfo companyOrgUnitInfo) {
        PeriodInfo curPeriodInfo = null;
        curPeriodInfo = (PeriodInfo)this.rs.get("CurrentPeriod");
        if (curPeriodInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            return false;
        }
        return true;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtFinanceOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.prmtFinanceOrgUnit_stateChanged(e);
    }

    public void onInit(RptParams arg0) throws Exception {
        this.onInitFilter();
    }

    private void onInitFilter() {
        this.pkWriteOffDate.setValue((Object)new Date());
        this.pkWriteOffDateTo.setValue((Object)new Date());
        try {
            CalculateClientUtil.InitCompanyF7(this.prmtFinanceOrgUnit, this.getViewPermission());
            if (this.prmtFinanceOrgUnit.getValue() != null) {
                this.oldCompanyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
                this.loadAccountPeriod(this.oldCompanyInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.oldCompanyInfo != null) {
            this.setOtherBillNumberF7(this.otherBillNo, this.oldCompanyInfo.getId().toString());
        } else {
            this.setOtherBillNumberF7(this.otherBillNo, null);
        }
        CalculateUtil.setInvBillNoFilterF7(this.saleIssueBillNo, true, BillBaseStatusEnum.AUDITED);
        this.saleIssueBillNo.setValue(null);
        this.otherBillNo.setValue(null);
    }

    private void setPeriod(KDSpinner periodYear) {
        try {
            if (periodYear.getValue() != null) {
                KDSpinner kdspinner = this.spinPeriodMonth;
                if (periodYear.equals(this.spinPeriodYearTo)) {
                    kdspinner = this.spinPeriodMonthTo;
                }
                int year = (Integer)periodYear.getValue();
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
                PeriodInfo curPeriodInfo = null;
                PeriodInfo startPeriodInfo = null;
                int minMonth = 1;
                int maxMonth = 12;
                if (companyInfo != null) {
                    Map<String, PeriodInfo> periodMap;
                    String companyID = companyInfo.getId().toString();
                    Map rs = ExpenseApportionFacadeFactory.getRemoteInstance().getPeriodNumber(year, companyInfo);
                    if (this.companyPeriodMap.containsKey(companyID)) {
                        periodMap = this.companyPeriodMap.get(companyID);
                        curPeriodInfo = periodMap.get("currentPeriod");
                        startPeriodInfo = periodMap.get("startPeriod");
                    } else {
                        curPeriodInfo = (PeriodInfo)rs.get("CurrentPeriod");
                        startPeriodInfo = (PeriodInfo)rs.get("StartPeriod");
                        periodMap = new HashMap<String, PeriodInfo>();
                        periodMap.put("currentPeriod", curPeriodInfo);
                        periodMap.put("startPeriod", startPeriodInfo);
                        this.companyPeriodMap.put(companyID, periodMap);
                    }
                    String key = companyID + year;
                    if (this.companyMonthMap.containsKey(key)) {
                        Map<String, Integer> monthMap = this.companyMonthMap.get(key);
                        minMonth = monthMap.get("MIN");
                        maxMonth = monthMap.get("MAX");
                    } else {
                        minMonth = (Integer)rs.get("MinPeriodNumber");
                        if (minMonth == 0) {
                            minMonth = 1;
                        }
                        if ((maxMonth = ((Integer)rs.get("MaxPeriodNumber")).intValue()) == 0) {
                            maxMonth = 12;
                        }
                        HashMap<String, Integer> monthMap = new HashMap<String, Integer>();
                        monthMap.put("MIN", minMonth);
                        monthMap.put("MAX", maxMonth);
                        this.companyMonthMap.put(key, monthMap);
                    }
                }
                if (startPeriodInfo != null && year == startPeriodInfo.getPeriodYear()) {
                    minMonth = startPeriodInfo.getPeriodNumber();
                }
                this.SetSpinnerMaxMin((JSpinner)kdspinner, minMonth, maxMonth);
                if (curPeriodInfo != null) {
                    kdspinner.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
                }
                if (kdspinner.getIntegerVlaue() < minMonth) {
                    kdspinner.setValue((Object)new Integer(minMonth));
                }
                if (kdspinner.getIntegerVlaue() > maxMonth) {
                    kdspinner.setValue((Object)new Integer(maxMonth));
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo startPeriodInfo = null;
        PeriodInfo curPeriodInfo = null;
        int minYear = 0;
        int maxYear = 0;
        if (companyInfo != null) {
            Map<String, Integer> yearMap;
            Map<String, PeriodInfo> periodMap;
            String companyID = companyInfo.getId().toString();
            if (this.companyPeriodMap.containsKey(companyID)) {
                periodMap = this.companyPeriodMap.get(companyID);
                curPeriodInfo = periodMap.get("currentPeriod");
                startPeriodInfo = periodMap.get("startPeriod");
            } else {
                curPeriodInfo = (PeriodInfo)this.rs.get("CurrentPeriod");
                startPeriodInfo = (PeriodInfo)this.rs.get("StartPeriod");
                periodMap = new HashMap<String, PeriodInfo>();
                periodMap.put("currentPeriod", curPeriodInfo);
                periodMap.put("startPeriod", startPeriodInfo);
                this.companyPeriodMap.put(companyID, periodMap);
            }
            if (this.companyYearMap.containsKey(companyID)) {
                yearMap = this.companyYearMap.get(companyID);
                minYear = yearMap.get("MIN");
                maxYear = yearMap.get("MAX");
            } else {
                minYear = (Integer)this.rs.get("MinPeriodYear");
                maxYear = (Integer)this.rs.get("MaxPeriodYear");
                yearMap = new HashMap<String, Integer>();
                yearMap.put("MIN", minYear);
                yearMap.put("MAX", maxYear);
                this.companyYearMap.put(companyID, yearMap);
            }
        }
        this.SetSpinnerMaxMin((JSpinner)this.spinPeriodYear, minYear, maxYear);
        this.SetSpinnerMaxMin((JSpinner)this.spinPeriodYearTo, minYear, maxYear);
        if (curPeriodInfo != null) {
            this.spinPeriodYear.setValue((Object)curPeriodInfo.getPeriodYear());
            this.spinPeriodYearTo.setValue((Object)curPeriodInfo.getPeriodYear());
            this.spinPeriodMonth.setValue((Object)curPeriodInfo.getPeriodNumber());
            this.spinPeriodMonthTo.setValue((Object)curPeriodInfo.getPeriodNumber());
        }
    }

    public FilterInfo getFilterInfo() {
        String numbert;
        String numberf;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        HashMap<String, Comparable<StringBuffer>> hm = new HashMap<String, Comparable<StringBuffer>>();
        hm.put("String", new StringBuffer());
        hm.put("Int", new Integer(0));
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
        if (cou == null || cou.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        this.setFilter(cou.getId().toString(), "companyOrgUnit.id", CompareType.EQUALS, items, hm);
        this.setFilter(this.bizWriteOffMan.getText(), "creator.name", CompareType.EQUALS, items, hm);
        this.setFilter(SCMUtils.getDayStartTime((Date)((Date)this.pkWriteOffDate.getValue())), "apportionDate", CompareType.GREATER_EQUALS, items, hm);
        this.setFilter(SCMUtils.getDayEndTime((Date)((Date)this.pkWriteOffDateTo.getValue())), "apportionDate", CompareType.LESS_EQUALS, items, hm);
        StringBuffer sbFormula = (StringBuffer)hm.get("String");
        Integer i = (Integer)hm.get("Int");
        Integer yearf = (Integer)this.spinPeriodYear.getValue();
        Integer periodf = (Integer)this.spinPeriodMonth.getValue();
        if (yearf != null && periodf != null) {
            items.add(new FilterItemInfo("year", (Object)yearf, CompareType.GREATER));
            sbFormula.append(" and (#" + i.toString());
            i = new Integer(i + 1);
            items.add(new FilterItemInfo("year", (Object)yearf, CompareType.EQUALS));
            sbFormula.append(" or (#" + i.toString());
            i = new Integer(i + 1);
            items.add(new FilterItemInfo("period", (Object)periodf, CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + i.toString()).append("))");
            i = new Integer(i + 1);
        }
        Integer yeart = (Integer)this.spinPeriodYearTo.getValue();
        Integer periodt = (Integer)this.spinPeriodMonthTo.getValue();
        if (yeart != null && periodt != null) {
            items.add(new FilterItemInfo("year", (Object)yeart, CompareType.LESS));
            sbFormula.append(" and (#" + i.toString());
            i = new Integer(i + 1);
            items.add(new FilterItemInfo("year", (Object)yeart, CompareType.EQUALS));
            sbFormula.append(" or (#" + i.toString());
            i = new Integer(i + 1);
            items.add(new FilterItemInfo("period", (Object)periodt, CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + i.toString()).append("))");
            i = new Integer(i + 1);
        }
        if (null != (numberf = this.txtWriteOffNumber.getText()) && !"".equals(numberf)) {
            items.add(new FilterItemInfo("number", (Object)numberf, CompareType.GREATER_EQUALS));
            sbFormula.append(" and (#" + i.toString() + ")");
            i = new Integer(i + 1);
        }
        if (null != (numbert = this.txtWriteOffNumberTo.getText()) && !"".equals(numbert)) {
            items.add(new FilterItemInfo("number", (Object)numbert, CompareType.LESS_EQUALS));
            sbFormula.append(" and (#" + i.toString() + ")");
            i = new Integer(i + 1);
        }
        hm.put("String", sbFormula);
        hm.put("Int", i);
        if (((StringBuffer)hm.get("String")).toString().length() != 0) {
            filter.setMaskString(((StringBuffer)hm.get("String")).toString());
        }
        this.ui.setTableAmountPrecision(cou);
        this.ui.setMainBizOrgInfo(cou);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo entry = new FilterInfo(EntryFilterType.ENTRYANYWHERE);
        entry.setEntryName("entry");
        StringBuffer maskBuffer = new StringBuffer();
        int maskCount = 0;
        if (this.otherBillNo.getValue() != null && this.otherBillNo.getValue() instanceof CoreBillBaseInfo) {
            this.setFilter(entry, ((CoreBillBaseInfo)this.otherBillNo.getValue()).getNumber(), "SOURCENUMBER", CompareType.EQUALS);
            maskBuffer.append("#" + maskCount);
            ++maskCount;
        }
        if (this.saleIssueBillNo.getValue() != null && this.saleIssueBillNo.getValue() instanceof SaleIssueBillInfo) {
            this.setFilter(entry, ((SaleIssueBillInfo)this.saleIssueBillNo.getValue()).getNumber(), "SOURCENUMBER", CompareType.EQUALS);
            if (maskCount > 0) {
                maskBuffer.append(" OR #" + maskCount);
            } else {
                maskBuffer.append(" #" + maskCount);
            }
        }
        entityViewInfo.getEntryFilters().add(entry);
        if (maskBuffer.length() > 0) {
            entry.setMaskString(maskBuffer.toString());
        }
        try {
            IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
            entityViewInfo = iw.processEntryFilter(new ExpenseApportionInfo().getBOSType(), entityViewInfo);
            FilterInfo filterEntryInfo = entityViewInfo.getFilter();
            filter.mergeFilter(filterEntryInfo, "AND");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filter;
    }

    private void setFilter(Object obj, String key, CompareType comparetype, FilterItemCollection items, HashMap hm) {
        boolean bln;
        StringBuffer sbFormula = (StringBuffer)hm.get("String");
        Integer i = (Integer)hm.get("Int");
        boolean bl = bln = i == 0;
        if (obj != null && (!(obj instanceof String) || obj instanceof String && ((String)obj).trim().length() > 0)) {
            FilterItemInfo templateFilterItemInfo = new FilterItemInfo(key, obj, comparetype);
            items.add(templateFilterItemInfo);
            sbFormula.append(bln ? "#" : " and #").append(i.toString());
            i = new Integer(i + 1);
        }
        hm.put("String", sbFormula);
        hm.put("Int", i);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            if (entityViewInfo == null || entityViewInfo.getFilter() == null) {
                return;
            }
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            this.pkWriteOffDate.setValue(null);
            this.pkWriteOffDateTo.setValue(null);
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                String obj;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("companyOrgUnit.id") && filterItemInfo.getCompareType().getName().equals(CompareType.EQUALS.getName())) {
                    obj = filterItemInfo.getCompareValue().toString();
                    this.rs = ExpenseApportionFacadeFactory.getRemoteInstance().fetchDatabyCou(obj);
                    CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)this.rs.get("CompanyOrgUnit");
                    if (c != null) {
                        this.prmtFinanceOrgUnit.setValue((Object)c);
                        this.prmtFinanceOrgUnit.setText(c.getNumber());
                        this.prmtFinanceOrgUnit.setLabelText(c.getName());
                    }
                }
                this.getFilter("creator.name", CompareType.EQUALS, this.bizWriteOffMan, filterItemInfo);
                this.getFilter("apportionDate", CompareType.GREATER_EQUALS, this.pkWriteOffDate, filterItemInfo);
                this.getFilter("apportionDate", CompareType.LESS_EQUALS, this.pkWriteOffDateTo, filterItemInfo);
                this.getFilter("number", CompareType.GREATER_EQUALS, this.txtWriteOffNumber, filterItemInfo);
                this.getFilter("number", CompareType.LESS_EQUALS, this.txtWriteOffNumberTo, filterItemInfo);
                this.getFilter("year", CompareType.GREATER, this.spinPeriodYear, filterItemInfo);
                this.getFilter("year", CompareType.LESS, this.spinPeriodYearTo, filterItemInfo);
                this.getFilter("period", CompareType.GREATER_EQUALS, this.spinPeriodMonth, filterItemInfo);
                this.getFilter("period", CompareType.LESS_EQUALS, this.spinPeriodMonthTo, filterItemInfo);
                if (!filterItemInfo.getPropertyName().equals("id") || !filterItemInfo.getCompareType().getName().equals(CompareType.INNER.getName())) continue;
                obj = filterItemInfo.getCompareValue().toString();
                if ((obj = obj.substring(obj.indexOf("WHERE ") + 6, obj.length())).startsWith("(")) {
                    obj = obj.substring(1, obj.length() - 1);
                }
                obj = obj.replace("\"T0\".", "");
                obj = obj.replace("\"FSOURCENUMBER\"", "number");
                String oql = "select number where " + obj.toString();
                SaleIssueBillCollection coll = SaleIssueBillFactory.getRemoteInstance().getSaleIssueBillCollection(oql);
                if (coll != null && coll.size() > 0) {
                    this.saleIssueBillNo.setValue((Object)coll.get(0));
                } else {
                    this.saleIssueBillNo.setValue(null);
                }
                OtherBillCollection otherColl = OtherBillFactory.getRemoteInstance().getOtherBillCollection(oql);
                if (otherColl != null && otherColl.size() > 0) {
                    this.otherBillNo.setValue((Object)otherColl.get(0));
                    continue;
                }
                this.otherBillNo.setValue(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void getFilter(String key, CompareType comparetype, KDSpinner box, FilterItemInfo filterItemInfo) {
        if (filterItemInfo.getPropertyName().equals(key) && filterItemInfo.getCompareType().getName().equals(comparetype.getName())) {
            Object obj = filterItemInfo.getCompareValue();
            box.setValue(obj);
        }
    }

    private void getFilter(String key, CompareType comparetype, KDTextField box, FilterItemInfo filterItemInfo) {
        if (filterItemInfo.getPropertyName().equals(key) && filterItemInfo.getCompareType().getName().equals(comparetype.getName())) {
            Object obj = filterItemInfo.getCompareValue();
            box.setText(obj.toString());
        }
    }

    private void getFilter(String key, CompareType comparetype, KDDatePicker box, FilterItemInfo filterItemInfo) {
        if (filterItemInfo.getPropertyName().equals(key) && filterItemInfo.getCompareType().getName().equals(comparetype.getName())) {
            Object obj = filterItemInfo.getCompareValue();
            box.setValue(obj);
        }
    }

    private void getFilter(String key, CompareType comparetype, KDBizPromptBox box, FilterItemInfo filterItemInfo) {
        if (filterItemInfo.getPropertyName().equals(key) && filterItemInfo.getCompareType().getName().equals(comparetype.getName())) {
            Object obj = filterItemInfo.getCompareValue();
            box.setValue(obj);
        }
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        String CompanyOrgUnitID = "";
        String companyname = "";
        String creatorid = "";
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            companyname = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getName();
            if (((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId() != null) {
                CompanyOrgUnitID = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        if (this.bizWriteOffMan.getValue() != null) {
            UserInfo m = null;
            if (this.bizWriteOffMan.getValue() instanceof UserInfo[]) {
                m = ((UserInfo[])this.bizWriteOffMan.getValue())[0];
            } else if (this.bizWriteOffMan.getValue() instanceof UserInfo) {
                m = (UserInfo)this.bizWriteOffMan.getValue();
            }
            if (m != null && m.getId() != null) {
                creatorid = m.getId().toString();
            }
        }
        para.setString("COMPANY_ID", CompanyOrgUnitID);
        para.setString("COMPANY_NAME", companyname);
        para.setString("creator.name", creatorid);
        para.setString("numberFrom", this.txtWriteOffNumber.getText());
        para.setString("numberTo", this.txtWriteOffNumberTo.getText());
        para.setString("writeOffDateFrom", this.pkWriteOffDate.getText());
        para.setString("writeOffDateTo", this.pkWriteOffDateTo.getText());
        para.setInt("YEAR_FROM", this.spinPeriodYear.getIntegerVlaue().intValue());
        para.setInt("PERIOD_FROM", this.spinPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("YEAR_TO", this.spinPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("PERIOD_TO", this.spinPeriodMonthTo.getIntegerVlaue().intValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        try {
            if (params.getString("COMPANY_ID") != null && params.getString("COMPANY_ID").length() != 0) {
                CompanyOrgUnitInfo cinfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(params.getString("COMPANY_ID")));
                this.prmtFinanceOrgUnit.setValue((Object)cinfo);
            }
            if (params.getString("creator.name") != null && params.getString("creator.name").length() != 0) {
                UserInfo mtoinfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(params.getString("creator.name")));
                this.bizWriteOffMan.setValue((Object)mtoinfo);
            }
            this.txtWriteOffNumber.setText(params.getString("numberFrom"));
            this.txtWriteOffNumberTo.setText(params.getString("numberTo"));
            this.pkWriteOffDate.setValue((Object)params.getString("apportionDateFrom"));
            this.pkWriteOffDateTo.setValue((Object)params.getString("apportionDateTo"));
            this.spinPeriodYear.setValue((Object)new Integer(params.getInt("YEAR_FROM")));
            this.spinPeriodMonth.setValue((Object)new Integer(params.getInt("PERIOD_FROM")));
            this.spinPeriodYearTo.setValue((Object)new Integer(params.getInt("YEAR_TO")));
            this.spinPeriodMonthTo.setValue((Object)new Integer(params.getInt("PERIOD_TO")));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void dataChanged(DataChangeEvent e) {
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        this.isFireState = false;
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
        this.isFireState = true;
    }

    public void stateChanged(ChangeEvent e) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        KDSpinner aSpinner = (KDSpinner)e.getSource();
        PeriodInfo periodInfo = null;
        try {
            periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if (periodInfo != null) {
                int startYear = periodInfo.getPeriodYear();
                int startMonth = periodInfo.getPeriodNumber();
                int minPeriod = PeriodUtils.getMinPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
                int maxPeriod = PeriodUtils.getMaxPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
                if (aSpinner.getName().toString().equals("spinPeriodYear")) {
                    if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                        minPeriod = startMonth;
                    }
                    this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonth, minPeriod, maxPeriod);
                    int curPeriod = Integer.parseInt(this.spinPeriodMonth.getValue().toString());
                    if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                        this.spinPeriodMonth.setValue((Object)new Integer(maxPeriod));
                    }
                } else {
                    if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                        minPeriod = startMonth;
                    }
                    this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonthTo, minPeriod, maxPeriod);
                    int curPeriod = Integer.parseInt(this.spinPeriodMonth.getValue().toString());
                    if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                        this.spinPeriodMonthTo.setValue((Object)new Integer(maxPeriod));
                    }
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void clear() {
        super.clear();
        this.pkWriteOffDate.setValue(null);
        this.pkWriteOffDateTo.setValue(null);
        this.bizWriteOffMan.setText(null);
        this.txtWriteOffNumber.setText(null);
        this.txtWriteOffNumberTo.setText(null);
        this.prmtFinanceOrgUnit.setText(null);
        try {
            this.onInitFilter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        if (cou == null || cou.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        PeriodInfo periodInfo = (PeriodInfo)this.rs.get("StartPeriod");
        if (periodInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            return false;
        }
        return true;
    }

    protected void setOtherBillNumberF7(KDBizPromptBox kDBizBillNum, String companyId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("BillStatus", (Object)new Integer(3), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(203), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        kDBizBillNum.setEntityViewInfo(viewInfo);
        kDBizBillNum.setVisible(true);
        kDBizBillNum.setEnabledMultiSelection(false);
        kDBizBillNum.setEditFormat("$number$");
        kDBizBillNum.setDisplayFormat("$number$");
        kDBizBillNum.setCommitFormat("$number$");
        kDBizBillNum.setQueryInfo("com.kingdee.eas.fi.ap.app.F7OtherBillQuery");
    }

    private void setFilter(FilterInfo entry, Object obj, String fieldName, CompareType comparetype) {
        WriteOffBillTypeEnum billType;
        if (null == obj) {
            return;
        }
        if (obj instanceof String && !StringUtil.isEmpty((String)((String)obj))) {
            entry.getFilterItems().add(new FilterItemInfo(fieldName, obj, comparetype));
        } else if (obj instanceof BigDecimal) {
            BigDecimal temp = (BigDecimal)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)temp, comparetype));
        } else if (obj instanceof Date) {
            entry.getFilterItems().add(new FilterItemInfo(fieldName, obj, comparetype));
        } else if (obj instanceof MaterialInfo) {
            MaterialInfo material = (MaterialInfo)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)material.getNumber(), comparetype));
        } else if (obj instanceof SupplierInfo) {
            SupplierInfo supplier = (SupplierInfo)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)supplier.getNumber(), comparetype));
        } else if (obj instanceof WriteOffBillTypeEnum && !"-1".equals((billType = (WriteOffBillTypeEnum)((Object)obj)).getValue())) {
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)billType.getValue(), comparetype));
        }
    }
}

