/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CloseAccountFacadeFactory;
import com.kingdee.eas.scm.cal.CostUpdateMutexFacadeFactory;
import com.kingdee.eas.scm.cal.ICloseAccountFacade;
import com.kingdee.eas.scm.cal.ICostUpdateMutexFacade;
import com.kingdee.eas.scm.cal.client.AbstractShutAccountClientUI;
import com.kingdee.eas.scm.cal.client.ShutAccountMsgUI;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ShutAccountClientUI
extends AbstractShutAccountClientUI
implements KDTMouseListener,
ChangeListener,
ActionListener,
Runnable {
    private static final long serialVersionUID = -4330856422922424602L;
    private static final Logger logger = CoreUIObject.getLogger(ShutAccountClientUI.class);
    private boolean isProcessing;
    private static String isClosing;
    boolean isShuted = false;
    boolean isActionShut = true;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitCollection authorizedMainOrgs = null;
    private static String unShutAccount;
    private static String shutAccount;
    private static String shuted;
    private static String unshuted;
    private static String success;
    private static String fail;
    private Map operateErrMap = new HashMap();
    private Map operateNotesMap = new HashMap();

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ShutAccount");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
        this.fillEntryData(null);
        this.isProcessing = false;
    }

    private void initControl() throws BOSException, EASBizException {
        this.prmtFilter.setDisplayFormat("$name$");
        this.prmtFilter.setEditFormat("$number$");
        this.prmtFilter.setCommitFormat("$number$;$name$");
        this.prmtFilter.setEnabledMultiSelection(true);
        this.prmtFilter.addChangeListener((ChangeListener)this);
        this.setOrgFilter();
        this.kdtDesc.setLineWrap(true);
        this.kdtDesc.setWrapStyleWord(true);
        this.kdtDesc.setText(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ShutAccountDesc"));
        isClosing = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ShutAccounting");
        this.checkSubmit.setSelected(true);
        this.checkSubmit.setEnabled(false);
        this.btnHelp.addActionListener((ActionListener)this);
        this.btnHelp.setVisible(false);
        this.initTableControl();
    }

    private void setOrgFilter() throws BOSException, EASBizException {
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        Map result = CloseAccountFacadeFactory.getRemoteInstance().getCompanyShutInfo(currUser.getId().toString(), null);
        if (result == null) {
            return;
        }
        RptRowSet rs = (RptRowSet)result.get("result");
        HashSet<String> companySet = new HashSet<String>();
        String companyID = null;
        while (rs.next()) {
            companyID = rs.getString("companyID");
            companySet.add(companyID);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtFilter.setEntityViewInfo(view);
    }

    private void initTableControl() throws BOSException, EASBizException {
        this.kdtEntry.checkParsed();
        this.setCheckBoxColumn();
    }

    private void setCheckBoxColumn() {
        final KDCheckBox cb = new KDCheckBox();
        this.kdtEntry.getHeadRow(0).getCell(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)cb));
        this.kdtEntry.getHeadRow(0).getCell(0).setValue((Object)false);
        this.kdtEntry.getHeadRow(0).getCell(0).getStyleAttributes().setLocked(false);
        cb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                for (int i = 0; i < ShutAccountClientUI.this.kdtEntry.getRowCount(); ++i) {
                    ShutAccountClientUI.this.kdtEntry.getRow(i).getCell(0).setValue((Object)cb.isSelected());
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String companyID = this.getOrgFilterIDs();
        try {
            if (!StringUtils.isEmpty((String)companyID)) {
                this.fillEntryData(companyID);
            } else {
                this.fillEntryData(null);
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (BOSException ee) {
            this.handleException((Exception)((Object)ee));
        }
    }

    private String getOrgFilterIDs() {
        String companyID = "";
        ArrayList<String> companyList = new ArrayList<String>();
        Object[] cou = (Object[])this.prmtFilter.getValue();
        if (cou != null && cou.length != 0 && cou[0] != null) {
            int len = cou.length;
            for (int i = 0; i < len; ++i) {
                companyList.add(String.valueOf(((CompanyOrgUnitInfo)cou[i]).getId()));
            }
            companyID = CollectionUtil.convertList2String(companyList, (String)",", (boolean)true);
        }
        return companyID;
    }

    private void fillEntryData(String companyID) throws BOSException, EASBizException {
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        Map result = CloseAccountFacadeFactory.getRemoteInstance().getCompanyShutInfo(currUser.getId().toString(), companyID);
        if (result == null) {
            return;
        }
        this.kdtEntry.removeKDTMouseListener((KDTMouseListener)this);
        this.kdtEntry.removeRows();
        RptRowSet rs = (RptRowSet)result.get("result");
        int size = (Integer)result.get("size");
        if (rs != null) {
            this.kdtEntry.setRowCount(size);
            KDTableUtil.insertRows((RptRowSet)rs, (int)0, (KDTable)this.kdtEntry, (KDTableInsertHandler)new KDTableInsertHandler(){

                public void setTableRowData(IRow row, Object[] rowData) {
                    int n = rowData.length;
                    for (int i = 0; i < n; ++i) {
                        String commanyID = (String)rowData[5];
                        row.getCell(0).setValue((Object)new Boolean(false));
                        if (i == 3) {
                            String value = new BigDecimal(rowData[i].toString()).compareTo(BigDecimal.ZERO) == 0 ? unshuted : shuted;
                            row.getCell(i + 1).setValue((Object)value);
                        } else if (i == 4) {
                            String notes = (String)ShutAccountClientUI.this.operateNotesMap.get(commanyID);
                            if (notes != null) {
                                row.getCell(i + 1).setValue((Object)notes);
                                if (!notes.equals(success)) {
                                    row.getCell(i + 1).getStyleAttributes().setFontColor(Color.red);
                                    row.getCell(i + 1).getStyleAttributes().setUnderline(true);
                                } else {
                                    row.getCell(i + 1).getStyleAttributes().setFontColor(Color.black);
                                    row.getCell(i + 1).getStyleAttributes().setUnderline(false);
                                }
                            } else {
                                row.getCell(i + 1).setValue(rowData[i]);
                            }
                        } else {
                            row.getCell(i + 1).setValue(rowData[i]);
                        }
                        row.getCell(i + 1).getStyleAttributes().setLocked(true);
                    }
                }
            });
        }
        this.kdtEntry.addKDTMouseListener((KDTMouseListener)this);
    }

    public boolean destroyWindow() {
        if (this.isProcessing) {
            MsgBox.showInfo((String)isClosing);
            return false;
        }
        return super.destroyWindow();
    }

    @Override
    public void run() {
        if (this.isActionShut) {
            this.shutAccount();
        } else {
            this.unShutAccount();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unShutAccount() {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("checkSubmit", this.checkSubmit.isSelected());
        param.put("checkSave", this.checkSave.isSelected());
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        if (!this.isSelected()) {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.btnExit.setEnabled(true);
            return;
        }
        this.btnExit.setEnabled(false);
        this.btnShutAccount.setEnabled(false);
        this.btnDisShut.setEnabled(false);
        HashSet<String> companySet = new HashSet<String>();
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (!this.kdtEntry.getRow(i).getCell("select").getValue().equals(true)) continue;
            String companyID = this.kdtEntry.getRow(i).getCell("companyID").getValue().toString();
            companySet.add(companyID);
            this.kdtEntry.getRow(i).getCell("notes").setValue(null);
            this.operateNotesMap.put(companyID, null);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
            CompanyOrgUnitCollection companyInfoColl = icompany.getCompanyOrgUnitCollection(view);
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
            ICloseAccountFacade ica = CloseAccountFacadeFactory.getRemoteInstance();
            for (int i = 0; i < companyInfoColl.size(); ++i) {
                companyMap.put(companyInfoColl.get(i).getId().toString(), companyInfoColl.get(i));
            }
            Object complete = null;
            boolean isShutAccount = false;
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            IObjectPK pkOut = null;
            StringBuffer err = new StringBuffer();
            String companyId = "";
            ICostUpdateMutexFacade iCostUpdateMutex = CostUpdateMutexFacadeFactory.getRemoteInstance();
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                boolean bl = isShutAccount = this.kdtEntry.getRow(i).getCell("status").getValue().equals(shuted);
                if (!this.kdtEntry.getRow(i).getCell("select").getValue().equals(true) || !isShutAccount) continue;
                companyInfo = (CompanyOrgUnitInfo)companyMap.get(this.kdtEntry.getRow(i).getCell("companyID").getValue().toString());
                companyId = companyInfo.getId().toString();
                try {
                    pkOut = LogUtil.beginLog(null, (String)"closeAccount", (BOSObjectType)ica.getType(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)companyInfo.getName(), (String)"unShutAccount", (String)companyInfo.getId().toString(), (String)unShutAccount);
                    iCostUpdateMutex.checkCostUpdateMutex(companyId, "unShutAccount");
                    iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, companyInfo, false);
                    LogUtil.afterLog(null, (IObjectPK)pkOut);
                    this.kdtEntry.getRow(i).getCell("notes").setValue((Object)success);
                    this.kdtEntry.getRow(i).getCell("status").setValue((Object)unshuted);
                    this.operateNotesMap.put(companyInfo.getId().toString(), success);
                    continue;
                }
                catch (Exception ex) {
                    this.kdtEntry.getRow(i).getCell("notes").setValue((Object)fail);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setFontColor(Color.red);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setUnderline(true);
                    this.operateNotesMap.put(companyInfo.getId().toString(), fail);
                    this.operateErrMap.put(companyInfo.getId().toString(), ex.getMessage());
                    err.append(companyInfo.getNumber()).append(companyInfo.getName()).append(ex.getMessage()).append("\n");
                }
            }
            if (!StringUtils.isEmpty((String)err.toString())) {
                MsgBox.showWarning((String)err.toString());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        finally {
            this.btnExit.setEnabled(true);
            this.btnDisShut.setEnabled(true);
            this.btnShutAccount.setEnabled(true);
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutAccount() {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("checkSubmit", this.checkSubmit.isSelected());
        param.put("checkSave", this.checkSave.isSelected());
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        if (!this.isSelected()) {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.btnExit.setEnabled(true);
            return;
        }
        this.btnExit.setEnabled(false);
        this.btnShutAccount.setEnabled(false);
        this.btnDisShut.setEnabled(false);
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (!this.kdtEntry.getRow(i).getCell("select").getValue().equals(true)) continue;
            String companyID = this.kdtEntry.getRow(i).getCell("companyID").getValue().toString();
            companySet.add(companyID);
            this.kdtEntry.getRow(i).getCell("notes").setValue(null);
            this.operateNotesMap.put(companyID, null);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        try {
            CompanyOrgUnitCollection companyInfoColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            for (int i = 0; i < companyInfoColl.size(); ++i) {
                companyMap.put(companyInfoColl.get(i).getId().toString(), companyInfoColl.get(i));
            }
            Object complete = null;
            boolean isShutAccount = false;
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            IObjectPK pkOut = null;
            StringBuffer err = new StringBuffer();
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
            ICloseAccountFacade ica = CloseAccountFacadeFactory.getRemoteInstance();
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                boolean bl = isShutAccount = this.kdtEntry.getRow(i).getCell("status").getValue().equals(shuted);
                if (!this.kdtEntry.getRow(i).getCell("select").getValue().equals(true) || isShutAccount) continue;
                companyInfo = (CompanyOrgUnitInfo)companyMap.get(this.kdtEntry.getRow(i).getCell("companyID").getValue().toString());
                try {
                    pkOut = LogUtil.beginLog(null, (String)"closeAccount", (BOSObjectType)ica.getType(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)companyInfo.getName(), (String)"shutAccount", (String)companyInfo.getId().toString(), (String)shutAccount);
                    ica.checkShutAccount(companyInfo, param);
                    iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, companyInfo, true);
                    LogUtil.afterLog(null, (IObjectPK)pkOut);
                    this.kdtEntry.getRow(i).getCell("notes").setValue((Object)success);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setFontColor(Color.black);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setUnderline(false);
                    this.kdtEntry.getRow(i).getCell("status").setValue((Object)shuted);
                    this.operateNotesMap.put(companyInfo.getId().toString(), success);
                    continue;
                }
                catch (Exception ex) {
                    this.kdtEntry.getRow(i).getCell("notes").setValue((Object)fail);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setFontColor(Color.red);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setUnderline(true);
                    this.operateErrMap.put(companyInfo.getId().toString(), ex.getMessage());
                    err.append(companyInfo.getNumber()).append(companyInfo.getName()).append(ex.getMessage()).append("\n");
                    this.operateNotesMap.put(companyInfo.getId().toString(), fail);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        finally {
            this.btnExit.setEnabled(true);
            this.btnDisShut.setEnabled(true);
            this.btnShutAccount.setEnabled(true);
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    private boolean isSelected() {
        boolean flag = false;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (!this.kdtEntry.getRow(i).getCell(0).getValue().equals(true)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public void actionShutAccount_actionPerformed(ActionEvent e) throws Exception {
        this.isActionShut = true;
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void actionDisShutAccount_actionPerformed(ActionEvent e) throws Exception {
        this.isActionShut = false;
        Thread t = new Thread(this);
        t.start();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                if (this.authorizedMainOrgs == null) {
                    this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermission());
                } else {
                    int size = this.authorizedMainOrgs.size();
                    this.mainOrgs = new OrgUnitInfo[size];
                    if (size > 0) {
                        Object[] objects = this.authorizedMainOrgs.toArray();
                        System.arraycopy(objects, 0, this.mainOrgs, 0, size);
                    }
                }
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected String getViewPermission() {
        return "shutaccount";
    }

    public void tableClicked(KDTMouseEvent e) {
        int col = e.getColIndex();
        int row = e.getRowIndex();
        String companyID = null;
        String errStr = null;
        String companyNumber = null;
        String action = null;
        String title = null;
        if (this.kdtEntry.getRow(row).getCell(col).getValue().equals(fail) && !StringUtils.isEmpty((String)(companyID = (String)this.kdtEntry.getRow(row).getCell("companyID").getValue()))) {
            String companyName = (String)this.kdtEntry.getRow(row).getCell("companyOrgUnitName").getValue();
            companyNumber = (String)this.kdtEntry.getRow(row).getCell("companyOrgUnitNumber").getValue();
            action = this.kdtEntry.getRow(row).getCell("status").getValue().equals(shuted) ? unShutAccount : shutAccount;
            title = "\u3010" + companyNumber + "," + companyName + "\u3011" + action + fail;
            errStr = (String)this.operateErrMap.get(companyID);
            this.showErrorMsg(title, errStr);
        }
    }

    private void showErrorMsg(String errorTitle, String errorMsg) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("errorTitle", errorTitle);
        uiContext.put("errorMsg", errorMsg);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ShutAccountMsgUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        ShutAccountMsgUI ui = (ShutAccountMsgUI)uiWindow.getUIObject();
        uiWindow.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    static {
        unShutAccount = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"UnShutAccount");
        shutAccount = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ShutAccount");
        shuted = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"shuted");
        unshuted = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"unshuted");
        success = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"success");
        fail = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"fail");
    }
}

