/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.client.AbstractStandCostDiffApportionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class StandCostDiffApportionUI
extends AbstractStandCostDiffApportionUI
implements Runnable,
ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(StandCostDiffApportionUI.class);
    IParamControl iParamControl = null;
    String caltitle = "";
    String periodTitle = "";
    private String companyID;
    private CalculateParams params;
    String calType = null;
    private String permissionkey = "deffapportion";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnApportion_actionPerformed(ActionEvent e) throws Exception {
        this.params = this.getFilterParam();
        if (this.params != null) {
            Thread t = new Thread(this);
            t.setName("Thread for StandCostDiffApportionUI");
            t.start();
        }
    }

    public void onLoad() {
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        try {
            super.onLoad();
            this.caltitle = this.lblCalKind.getText();
            this.periodTitle = this.labPeriod.getText();
            this.iParamControl = ParamControlFactory.getRemoteInstance();
            CalculateClientUtil.setCompanyOrgF7(this.pmtCompanyOrg, this.permissionkey, true);
            SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.pmtCompanyOrg);
            SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.pmtStorageOrgBeg);
            CalculateClientUtil.setF7FilterUIProperties(this.pmtCompanyOrg, true);
            CalculateClientUtil.setF7FilterUIProperties(this.pmtStorageOrgBeg, false);
            CalculateClientUtil.setF7FilterUIProperties(this.pmtWareHouseBeg, false);
            this.pmtCompanyOrg.addChangeListener((ChangeListener)this);
            this.pmtStorageOrgBeg.addChangeListener((ChangeListener)this);
            this.pmtStorageOrgBeg.addChangeListener((ChangeListener)this);
            CalculateClientUtil.InitCompanyF7(this.pmtCompanyOrg, this.permissionkey);
            if (this.pmtCompanyOrg.getValue() != null) {
                this.companyID = ((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()).getId().toString();
                CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue(), this.pmtStorageOrgBeg, null);
                this.pmtCompanyOrg.setValue((Object)((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()));
            } else {
                this.clearWareHouse(false);
                this.clearStorageOrg(false);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        finally {
            this.btnCancel.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        String complete = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"STANDCOST_DIFF_APPORTION_COMPLETE");
        try {
            this.btnApportion.setEnabled(false);
            String closing = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"STANDCOST_DIFF_APPORTIOIN_ING");
            this.progressBar.setStringPainted(true);
            this.progressBar.setString(closing);
            this.progressBar.setIndeterminate(true);
            ICalculateFacade ida = CalculateFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            if (!ida.apportionDiff(this.params)) {
                complete = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"STANDCOST_DIFF_APPORTION_DEFEAT");
            }
        }
        catch (Exception exception) {
            complete = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"STANDCOST_DIFF_APPORTION_DEFEAT");
            this.progressBar.setIndeterminate(false);
            this.handUIException(exception);
        }
        finally {
            this.btnApportion.setEnabled(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setString(complete);
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    private CalculateParams getFilterParam() {
        String warehouseid;
        String warehouseBegID;
        String storageorgunitid;
        String storageOrgBegID;
        CalculateParams params = new CalculateParams();
        if ((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return null;
        }
        String companyOrgID = ((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()).getId().toString();
        if ((StorageOrgUnitInfo)this.pmtStorageOrgBeg.getValue() != null) {
            storageOrgBegID = ((StorageOrgUnitInfo)this.pmtStorageOrgBeg.getValue()).getNumber().toString();
            storageorgunitid = ((StorageOrgUnitInfo)this.pmtStorageOrgBeg.getValue()).getId().toString();
        } else {
            storageOrgBegID = "";
            storageorgunitid = "";
        }
        String storageOrgEndID = "";
        if ((WarehouseInfo)this.pmtWareHouseBeg.getValue() != null) {
            warehouseBegID = ((WarehouseInfo)this.pmtWareHouseBeg.getValue()).getNumber().toString();
            warehouseid = ((WarehouseInfo)this.pmtWareHouseBeg.getValue()).getId().toString();
        } else {
            warehouseBegID = "";
            warehouseid = "";
        }
        String warehouseEndID = "";
        params.setString("CALTYPE", this.calType);
        params.setString("COMPANY_ID", companyOrgID);
        params.setString("STORAGEORGUNIT_NUMBER", storageOrgBegID);
        params.setString("WAREHOUSE_NUMBER", warehouseBegID);
        params.setString("STORAGEORGUNITID", storageorgunitid);
        params.setString("WAREHOUSEID", warehouseid);
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", this.chkWriteCostComputeReport.isSelected());
        this.initUIMainOrgContext(params.getString("COMPANY_ID"));
        return params;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        block19: {
            if (((KDBizPromptBox)e.getSource()).equals(this.pmtCompanyOrg)) {
                if (this.pmtCompanyOrg.getValue() != null) {
                    try {
                        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()));
                        if (curPeriodInfo != null) {
                            this.labPeriod.setText(this.periodTitle + curPeriodInfo.getPeriodYear() + "." + curPeriodInfo.getPeriodNumber());
                        }
                        this.calType = this.iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()).getId().toString()), "SCM_CAL_002");
                        this.runCheck();
                    }
                    catch (BOSException e1) {
                        this.handUIException(e1);
                    }
                    catch (EASBizException e1) {
                        this.handUIException(e1);
                    }
                    if ("0".equals(this.calType)) {
                        this.clearStorageOrg(false);
                        this.lblCalKind.setText(this.caltitle + MaterialCalTypeEnum.CAL_TYPE_PARTITION_FINANCE.toString());
                    } else {
                        this.clearStorageOrg(true);
                        CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue(), this.pmtStorageOrgBeg, null);
                    }
                    if ("1".equals(this.calType)) {
                        this.lblCalKind.setText(this.caltitle + MaterialCalTypeEnum.CAL_TYPE_PARTITION_STORAGE.toString());
                    }
                    if ("2".equals(this.calType)) {
                        this.lblCalKind.setText(this.caltitle + MaterialCalTypeEnum.CAL_TYPE_PARTITION_WAREHOUSE.toString());
                    }
                    this.clearWareHouse(false);
                } else {
                    this.clearWareHouse(false);
                    this.clearStorageOrg(false);
                    this.lblCalKind.setText(this.caltitle);
                }
            } else if (((KDBizPromptBox)e.getSource()).equals(this.pmtStorageOrgBeg)) {
                if (this.pmtStorageOrgBeg.getValue() != null) {
                    try {
                        if ("1".equals(this.calType)) {
                            this.pmtWareHouseBeg.setEnabled(false);
                            break block19;
                        }
                        this.pmtWareHouseBeg.setEnabled(true);
                        this.pmtWareHouseBeg.setValue(null);
                        this.pmtWareHouseBeg.setEntityViewInfo(InvClientUtils.getWarehouseFilter((StorageOrgUnitInfo)((StorageOrgUnitInfo)this.pmtStorageOrgBeg.getValue()), (int)1));
                    }
                    catch (EASBizException e1) {
                        this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        this.handUIException(e1);
                    }
                } else {
                    this.clearWareHouse(false);
                }
            }
        }
    }

    private void runCheck() throws EASBizException, BOSException {
        if (this.pmtCompanyOrg.getValue() == null || ((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()).getId() == null) {
            return;
        }
        this.btnApportion.setEnabled(true);
    }

    private void clearWareHouse(boolean bln) {
        this.pmtWareHouseBeg.setValue(null);
        this.pmtWareHouseBeg.setEnabled(bln);
    }

    private void clearStorageOrg(boolean bln) {
        this.pmtStorageOrgBeg.setValue(null);
        this.pmtStorageOrgBeg.setEnabled(bln);
    }
}

