/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.StandardCostAdjBillAgent;
import com.kingdee.eas.scm.cal.StandardCostAdjBillCollection;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryAgent;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryCollection;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryInfo;
import com.kingdee.eas.scm.cal.StandardCostAdjBillFactory;
import com.kingdee.eas.scm.cal.StandardCostAdjBillInfo;
import com.kingdee.eas.scm.cal.client.AbstractStandardCostAdjBillEditUI;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.InvoicePrintDataSource;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventoryBalance;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StandardCostAdjBillEditUI
extends AbstractStandardCostAdjBillEditUI
implements KDTEditListener,
ChangeListener,
PreChangeListener {
    private static final long serialVersionUID = -5062051511322166426L;
    protected CompanyOrgUnitInfo cou = null;
    private PeriodInfo currentPeriodInfo = null;
    private KDBizPromptBox kDBizPromptBoxMaterial = null;
    protected BigDecimal ZERO = new BigDecimal("0.00");
    private static final String[] TOTALCOL = new String[]{"diffAmount"};
    private int amtPrecision = 2;

    public StandardCostAdjBillEditUI() throws Exception {
        SCMClientHelper.registerTotalColumns((String[])TOTALCOL);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.cou = this.editData.getCompanyOrgUnit();
        try {
            this.SetTableFormat();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setDefaultMainOrgUnit();
    }

    protected void setDefaultMainOrgUnit() {
        if (this.editData.getId() == null && OprtState.ADDNEW.equals(this.getOprtState()) && this.getMainOrgUnit() != null && this.getDefaultMainBizOrg() != null && !this.isCoay) {
            PreChangeEvent pce = new PreChangeEvent((Object)this.getMainOrgUnit());
            this.changeMainOrgUnit(pce);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        BillBaseStatusEnum billStatus = (BillBaseStatusEnum)this.comboBaseStatus.getSelectedItem();
        if (billStatus == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SETTING_BILL_STATUS"));
            return;
        }
        if (billStatus != null && billStatus.getValue() == 3) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"CANCELBILLNOTSAVE"));
            return;
        }
        if (this.verify()) {
            super.actionAudit_actionPerformed(e);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BillBaseStatusEnum billStatus = (BillBaseStatusEnum)this.comboBaseStatus.getSelectedItem();
        if (billStatus == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SETTING_BILL_STATUS"));
            return;
        }
        if (billStatus != null && billStatus.getValue() == 3) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"CANCELBILLNOTSAVE"));
            return;
        }
        if (null == this.prmtCompanyOrgUnit.getValue()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return;
        }
        boolean isCanSubmit = this.verify();
        if (isCanSubmit) {
            this.reGetQtyAndStandCost4Submit();
            super.actionSubmit_actionPerformed(e);
        }
    }

    private void reGetQtyAndStandCost4Submit() throws EASBizException, BOSException {
        KDTable kdTable = this.kdtEntry;
        int maxRow = kdTable.getRowCount();
        int colMaterialNum = kdTable.getColumnIndex("materialNumber");
        int colNewPrice = kdTable.getColumnIndex("newStandardPrice");
        int qtyPrecision = 4;
        BigDecimal qty = this.ZERO;
        int pricePrecision = 2;
        Object valNewPrice = null;
        Object oldStandardPrice = null;
        MaterialInfo aMaterialInfo = null;
        MaterialCompanyInfoInfo aMaterialCompanyInfo = null;
        IInventoryBalance ii = InventoryBalanceFactory.getRemoteInstance();
        IMaterial iMaterial = MaterialFactory.getRemoteInstance();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.editData.getCompanyOrgUnit();
        CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()));
        this.amtPrecision = baseCurrInfo.getPrecision();
        for (int i = 0; i < maxRow; ++i) {
            BigDecimal diffAmount;
            aMaterialInfo = (MaterialInfo)kdTable.getCell(i, colMaterialNum).getValue();
            qty = ii.getPeriodBeginQty(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString(), null, null, this.currentPeriodInfo);
            IMultiMeasureUnit imm = MultiMeasureUnitFactory.getRemoteInstance();
            qtyPrecision = imm.getQtyPrecision(aMaterialInfo.getId().toString(), aMaterialInfo.getBaseUnit().getId().toString());
            kdTable.getRow(i).getCell("baseQty").setValue((Object)qty);
            pricePrecision = aMaterialInfo.getPricePrecision();
            aMaterialCompanyInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
            if (aMaterialCompanyInfo != null) {
                BigDecimal costPrice = aMaterialCompanyInfo.getStandardCost();
                if (costPrice == null) {
                    costPrice = new BigDecimal(String.valueOf("0"));
                }
                costPrice = costPrice.setScale(pricePrecision, 4);
                kdTable.getRow(i).getCell("oldStandardPrice").setValue((Object)costPrice);
                BigDecimal variable = this.ZERO;
                BigDecimal diffPrice = variable.subtract(costPrice);
                kdTable.getRow(i).getCell("diffPrice").setValue((Object)diffPrice);
                BigDecimal amt = costPrice.multiply(qty);
                kdTable.getRow(i).getCell("oldStandardAmount").setValue((Object)amt);
                diffAmount = variable.subtract(amt);
                kdTable.getRow(i).getCell("diffAmount").setValue((Object)diffAmount);
            }
            if ((valNewPrice = kdTable.getRow(i).getCell(colNewPrice).getValue()) != null) {
                BigDecimal newPrice = new BigDecimal(valNewPrice.toString());
                BigDecimal newAmount = qty.multiply(newPrice);
                newAmount = newAmount.setScale(this.amtPrecision, 4);
                kdTable.getRow(i).getCell("newStandardAmount").setValue((Object)newAmount);
                BigDecimal oldPrice = new BigDecimal(String.valueOf("0"));
                try {
                    oldStandardPrice = kdTable.getRow(i).getCell("oldStandardPrice").getValue();
                    if (null != oldStandardPrice) {
                        oldPrice = new BigDecimal(oldStandardPrice.toString());
                    }
                }
                catch (Exception amt) {
                    // empty catch block
                }
                BigDecimal diffPrice = newPrice.subtract(oldPrice);
                kdTable.getRow(i).getCell("diffPrice").setValue((Object)diffPrice);
                diffAmount = qty.multiply(diffPrice).setScale(this.amtPrecision, 4);
                kdTable.getRow(i).getCell("diffAmount").setValue((Object)diffAmount);
            }
            SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)kdTable, (String[])new String[]{"baseQty"}, (int)i);
            SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)kdTable, (String[])new String[]{"oldStandardPrice", "newStandardPrice", "diffPrice"}, (int)i);
            SCMClientUtils.changeTableColPrecision((int)this.amtPrecision, (KDTable)kdTable, (String[])new String[]{"oldStandardAmount", "newStandardAmount", "diffAmount"}, (int)i);
        }
    }

    private boolean verify() throws BOSException, EASBizException {
        boolean isRight = true;
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Date)((Date)this.pkBizDate.getValue()), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue()));
        if (billPeriodInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            this.pkBizDate.requestFocus();
            isRight = false;
        }
        int maxRow = this.kdtEntry.getRowCount();
        int colMaterialNum = this.kdtEntry.getColumnIndex("materialNumber");
        for (int i = 0; i < maxRow; ++i) {
            BigDecimal newStandardPrice;
            MaterialInfo aMaterialInfo = (MaterialInfo)this.kdtEntry.getRow(i).getCell(colMaterialNum).getValue();
            if (aMaterialInfo == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"MUSTINPUTMATERIEL"));
                this.kdtEntry.getEditManager().editCellAt(i, colMaterialNum);
                isRight = false;
                break;
            }
            BigDecimal oldPrice = (BigDecimal)this.kdtEntry.getRow(i).getCell("oldStandardPrice").getValue();
            if (oldPrice == null) {
                oldPrice = BigDecimal.valueOf(0L);
            }
            if (null == (newStandardPrice = (BigDecimal)this.kdtEntry.getRow(i).getCell("newStandardPrice").getValue()) || this.ZERO.compareTo(newStandardPrice) == 0) {
                isRight = false;
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"MUSTINPUTNEWPRICE"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex("newStandardPrice"));
                break;
            }
            BigDecimal newPrice = (BigDecimal)this.kdtEntry.getRow(i).getCell("newStandardPrice").getValue();
            if (oldPrice.compareTo(newPrice) != 0) continue;
            isRight = false;
            MsgBox.showError((Component)((Object)this), (String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"Fail_NewPrice=OldPrice", (String[])new String[]{String.valueOf(i + 1)}));
            break;
        }
        return isRight;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initContrl();
        this.initTable();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.initContrl();
        this.initTable();
        this.changeCopyBtnStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.initContrl();
        this.initTable();
        this.changeCopyBtnStatus();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.initContrl();
        this.initTable();
        this.changeCopyBtnStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.initContrl();
        this.initTable();
        this.changeCopyBtnStatus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initContrl();
        this.initTable();
        this.changeCopyBtnStatus();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BillBaseStatusEnum billStatus = (BillBaseStatusEnum)this.comboBaseStatus.getSelectedItem();
        if (billStatus.getValue() == 3) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"CANCELBILLNOTDEL"));
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        try {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
            if (aCompanyOrgUnitInfo != null) {
                super.actionAddLine_actionPerformed(e);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SELECTCOMPANY"));
            }
        }
        catch (Exception err) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SELECTCOMPANY"));
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        try {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
            if (aCompanyOrgUnitInfo != null) {
                super.actionInsertLine_actionPerformed(e);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SELECTCOMPANY"));
            }
        }
        catch (Exception err) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SELECTCOMPANY"));
        }
    }

    protected void menuItemCopy2_actionPerformed(ActionEvent e) throws Exception {
        this.execCopy();
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemCreateFrom.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemQueryByMaterial.setVisible(false);
        this.menuItemQueryGeneralInventory.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnQueryByMaterial.setVisible(false);
        this.btnQueryGeneralInventory.setVisible(false);
    }

    protected void initTable() throws EASBizException, BOSException {
        this.kdtEntry.getColumn("materialNumber").setWidth(100);
        this.kdtEntry.getColumn("materialName").setWidth(150);
        this.kdtEntry.getColumn("materialModel").setWidth(100);
        this.kdtEntry.getColumn("baseUnit").setWidth(100);
        this.kdtEntry.getColumn("baseQty").setWidth(100);
        this.kdtEntry.getColumn("oldStandardPrice").setWidth(100);
        this.kdtEntry.getColumn("oldStandardAmount").setWidth(100);
        this.kdtEntry.getColumn("newStandardPrice").setWidth(100);
        this.kdtEntry.getColumn("newStandardAmount").setWidth(100);
        this.kdtEntry.getColumn("diffPrice").setWidth(100);
        this.kdtEntry.getColumn("diffAmount").setWidth(100);
        this.kdtEntry.getColumn("remark").setWidth(200);
        this.kdtEntry.addKDTEditListener((KDTEditListener)this);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn("materialNumber").setRenderer((IBasicRender)avr);
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntry, (String[])new String[]{"materialNumber", "newStandardPrice"});
        this.kdtEntry.getColumn("materialNumber").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("materialModel").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("materialName").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("baseUnit").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("baseQty").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("baseQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn("oldStandardPrice").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("oldStandardPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn("oldStandardAmount").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("oldStandardAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn("newStandardAmount").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("newStandardAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn("diffPrice").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("diffPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn("diffAmount").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("diffAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtField = new KDFormattedTextField(1);
        txtField.setHorizontalAlignment(4);
        this.kdtEntry.getColumn("newStandardPrice").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn("remark").getStyleAttributes().setLocked(true);
        if (this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW")) {
            if (this.getKDBizPromptBoxMaterial() != null) {
                this.getKDBizPromptBoxMaterial().setValue(null);
                EntityViewInfo view = this.getKDBizPromptBoxMaterial().getEntityViewInfo();
                if (null != view) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(2), CompareType.EQUALS));
                    view.getFilter().mergeFilter(filter, "and");
                } else {
                    view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(2), CompareType.EQUALS));
                    view.getFilter().mergeFilter(filter, "and");
                }
                this.getKDBizPromptBoxMaterial().setEntityViewInfo(view);
            }
            if (this.cou != null) {
                this.kdtEntry.getColumn("materialNumber").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("remark").getStyleAttributes().setLocked(false);
            }
        }
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{"remark"}, (int)255);
    }

    @Override
    protected IObjectValue createNewData() {
        StandardCostAdjBillAgent aStandardCostAdjBillInfo = null;
        try {
            aStandardCostAdjBillInfo = StandardCostAdjBillAgent.create();
            aStandardCostAdjBillInfo.setBaseStatus(BillBaseStatusEnum.ADD);
            aStandardCostAdjBillInfo.setHasEffected(false);
            Timestamp serverDate = SCMClientUtils.getServerDate();
            Date bdate = new Date(serverDate.getYear(), serverDate.getMonth(), serverDate.getDate());
            aStandardCostAdjBillInfo.setBizDate(bdate);
            aStandardCostAdjBillInfo.setCreateTime(new Timestamp(((Date)serverDate).getTime()));
            aStandardCostAdjBillInfo.setAuditTime(null);
            aStandardCostAdjBillInfo.setLastUpdateTime(null);
            aStandardCostAdjBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01c3c0a812e6463ED552"));
            aStandardCostAdjBillInfo.setBillType(aBillTypeInfo);
            this.cou = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            aStandardCostAdjBillInfo.setCompanyOrgUnit(this.cou);
            StandardCostAdjBillEntryInfo aStandardCostAdjBillEntryInfo = (StandardCostAdjBillEntryInfo)this.createNewDetailData(this.kdtEntry);
            aStandardCostAdjBillInfo.getEntry().add(aStandardCostAdjBillEntryInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return aStandardCostAdjBillInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        StandardCostAdjBillEntryAgent aStandardCostAdjBillEntryInfo = null;
        try {
            aStandardCostAdjBillEntryInfo = StandardCostAdjBillEntryAgent.create();
            aStandardCostAdjBillEntryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return aStandardCostAdjBillEntryInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StandardCostAdjBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEditable()) {
            this.txtNumber.requestFocus();
        } else {
            this.pkBizDate.requestFocus();
        }
        this.menuItemCopy.setVisible(true);
        this.menuItemCopy.setEnabled(true);
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.initContrl();
        this.initTable();
        this.btnMultiapprove.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
        this.actionUnAudit.setVisible(true);
        this.actionCopyLine.setVisible(false);
        this.kDSeparator4.setVisible(false);
        this.separatorEdit1.setVisible(false);
        this.separator1.setVisible(false);
        this.separator2.setVisible(false);
    }

    private void initContrl() throws Exception {
        this.prmtCompanyOrgUnit.addPreChangeListener((PreChangeListener)this);
        this.txtNumber.setRequired(true);
        this.pkBizDate.setRequired(true);
        this.prmtCompanyOrgUnit.setRequired(true);
        this.contBaseStatus.setEnabled(false);
        this.contAuditor.setEnabled(false);
        this.contAuditTime.setEnabled(false);
        this.contCreateTime.setEnabled(false);
        this.contCreator.setEnabled(false);
        this.contLastUpdateUser.setEnabled(false);
        this.contLastUpdateTime.setEnabled(false);
        this.setCostCenterFilter();
    }

    public void preChange(PreChangeEvent e) {
        if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            return;
        }
        CompanyOrgUnitInfo newComy = (CompanyOrgUnitInfo)e.getData();
        if (newComy != null && e.getOldData() != null) {
            CompanyOrgUnitInfo oldComy = (CompanyOrgUnitInfo)e.getOldData();
            if (newComy.getId() != null && oldComy.getId() != null && newComy.getId().toString().equals(oldComy.getId().toString())) {
                return;
            }
        }
        e.setResult(this.prmtCompanyOrgUnit(e));
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    private void tableValueChanged(int rowIndex, int colIndex) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        KDTable kdTable = this.kdtEntry;
        int selectRow = rowIndex;
        int selectCol = colIndex;
        int maxRow = kdTable.getRowCount();
        int colMaterialNum = kdTable.getColumnIndex("materialNumber");
        int colNewPrice = kdTable.getColumnIndex("newStandardPrice");
        if (this.currentPeriodInfo == null) {
            this.currentPeriodInfo = PeriodUtils.getPeriodInfo((Date)this.editData.getBizDate(), (CompanyOrgUnitInfo)this.editData.getCompanyOrgUnit());
        }
        if ((aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue()) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return;
        }
        CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()));
        this.amtPrecision = baseCurrInfo.getPrecision();
        Object temp = kdTable.getCell(selectRow, colMaterialNum).getValue();
        if (temp instanceof MaterialInfo) {
            Object valNewPrice;
            MaterialInfo aMaterialInfo = (MaterialInfo)temp;
            if (selectCol == colMaterialNum) {
                for (int i = 0; i < maxRow; ++i) {
                    MaterialInfo otherMaterialInfo;
                    if (i == selectRow || (otherMaterialInfo = (MaterialInfo)kdTable.getRow(i).getCell(colMaterialNum).getValue()) == null || !otherMaterialInfo.getNumber().toString().equals(aMaterialInfo.getNumber().toString())) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SAME_MATERIEL"));
                    kdTable.getRow(selectRow).getCell(colMaterialNum).setValue(null);
                    return;
                }
                kdTable.getRow(selectRow).getCell("materialName").setValue((Object)aMaterialInfo.getName());
                kdTable.getRow(selectRow).getCell("materialModel").setValue((Object)aMaterialInfo.getModel());
                IMeasureUnit munit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo info = munit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aMaterialInfo.getBaseUnit().getId()));
                int qtyPrecision = 4;
                if (info != null) {
                    kdTable.getRow(selectRow).getCell("baseUnit").setValue((Object)info);
                    IMultiMeasureUnit imm = MultiMeasureUnitFactory.getRemoteInstance();
                    qtyPrecision = imm.getQtyPrecision(aMaterialInfo.getId().toString(), info.getId().toString());
                } else {
                    kdTable.getRow(selectRow).getCell("baseUnit").setValue(null);
                }
                IInventoryBalance ii = InventoryBalanceFactory.getRemoteInstance();
                Map result = ii.getPeriodBeginQtyAndAmount(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString(), null, null, this.currentPeriodInfo);
                BigDecimal qty = (BigDecimal)result.get("beginQty");
                kdTable.getRow(selectRow).getCell("baseQty").setValue((Object)qty);
                int pricePrecision = aMaterialInfo.getPricePrecision();
                IMaterial iMaterial = MaterialFactory.getRemoteInstance();
                MaterialCompanyInfoInfo aMaterialCompanyInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
                if (aMaterialCompanyInfo != null) {
                    BigDecimal costPrice = aMaterialCompanyInfo.getStandardCost();
                    if (costPrice == null) {
                        costPrice = new BigDecimal(String.valueOf("0"));
                    }
                    costPrice = costPrice.setScale(pricePrecision, 4);
                    BigDecimal amount = qty.multiply(costPrice).setScale(this.amtPrecision, 4);
                    kdTable.getRow(selectRow).getCell("oldStandardPrice").setValue((Object)costPrice);
                    BigDecimal variable = new BigDecimal("0.0");
                    BigDecimal diffPrice = variable.subtract(costPrice);
                    kdTable.getRow(selectRow).getCell("diffPrice").setValue((Object)diffPrice);
                    kdTable.getRow(selectRow).getCell("oldStandardAmount").setValue((Object)amount);
                    BigDecimal diffAmount = variable.subtract(amount);
                    kdTable.getRow(selectRow).getCell("diffAmount").setValue((Object)diffAmount);
                }
                SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)kdTable, (String[])new String[]{"baseQty"}, (int)rowIndex);
                SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)kdTable, (String[])new String[]{"oldStandardPrice", "newStandardPrice", "diffPrice"}, (int)rowIndex);
                SCMClientUtils.changeTableColPrecision((int)this.amtPrecision, (KDTable)kdTable, (String[])new String[]{"oldStandardAmount", "newStandardAmount", "diffAmount"}, (int)rowIndex);
            } else if (selectCol == colNewPrice && (valNewPrice = kdTable.getRow(selectRow).getCell(colNewPrice).getValue()) != null) {
                BigDecimal newPrice = new BigDecimal(valNewPrice.toString());
                BigDecimal qty = new BigDecimal(kdTable.getRow(selectRow).getCell("baseQty").getValue().toString());
                BigDecimal newAmount = qty.multiply(newPrice);
                newAmount = newAmount.setScale(this.amtPrecision, 4);
                kdTable.getRow(selectRow).getCell("newStandardAmount").setValue((Object)newAmount);
                BigDecimal oldPrice = new BigDecimal(String.valueOf("0"));
                try {
                    Object oldStandardPrice = kdTable.getRow(selectRow).getCell("oldStandardPrice").getValue();
                    if (null != oldStandardPrice) {
                        oldPrice = new BigDecimal(oldStandardPrice.toString());
                    }
                }
                catch (Exception oldStandardPrice) {
                    // empty catch block
                }
                BigDecimal diffPrice = newPrice.subtract(oldPrice);
                kdTable.getRow(selectRow).getCell("diffPrice").setValue((Object)diffPrice);
                BigDecimal diffAmount = qty.multiply(diffPrice).setScale(this.amtPrecision, 4);
                kdTable.getRow(selectRow).getCell("diffAmount").setValue((Object)diffAmount);
            }
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void dataChanged(DataChangeEvent e) {
    }

    private int prmtCompanyOrgUnit(PreChangeEvent e) {
        try {
            Object obj = e.getData();
            if (obj instanceof CompanyOrgUnitInfo) {
                this.cou = (CompanyOrgUnitInfo)e.getData();
            }
            if (this.cou != null && !this.cou.equals(e.getOldData())) {
                if (!this.checkEntryIsBlank(this.kdtEntry)) {
                    String strTemp = InvClientUtils.getResource((String)"CLEAR_ENTRY_AFTER_ORGCHANGED");
                    int ret = MsgBox.showConfirm2((String)strTemp);
                    if (ret == 2) {
                        this.prmtCompanyOrgUnit.setData(e.getOldData());
                        return 0;
                    }
                    this.cleanEntry();
                    this.addLine(this.kdtEntry);
                }
                this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.cou);
                if (this.currentPeriodInfo == null) {
                    String name = this.cou.getName(SysContext.getSysContext().getLocale());
                    MsgBox.showInfo((String)(name + EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL")));
                    return 0;
                }
                CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
                int amtPrecision = baseCurrInfo.getPrecision();
                String amtFormat = CalculateUtil.fmtTableString(amtPrecision).toString();
                this.kdtEntry.getColumn("oldStandardAmount").getStyleAttributes().setNumberFormat(amtFormat);
                this.kdtEntry.getColumn("newStandardAmount").getStyleAttributes().setNumberFormat(amtFormat);
                this.kdtEntry.getColumn("diffAmount").getStyleAttributes().setNumberFormat(amtFormat);
                SCMClientUtils.changeTableColPrecision((int)amtPrecision, (KDTable)this.kdtEntry, (String[])new String[]{"oldStandardPrice", "newStandardPrice", "diffPrice"});
                this.kdtEntry.getColumn("materialNumber").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("remark").getStyleAttributes().setLocked(false);
            } else if (this.cou == null) {
                if (!this.checkEntryIsBlank(this.kdtEntry)) {
                    String strTemp = InvClientUtils.getResource((String)"CLEAR_ENTRY_AFTER_ORGCHANGED");
                    int ret = MsgBox.showConfirm2((String)strTemp);
                    if (ret == 2) {
                        this.prmtCompanyOrgUnit.setData(e.getOldData());
                        return 0;
                    }
                    this.cleanEntry();
                    this.addLine(this.kdtEntry);
                }
                this.getNumTextField().setText(null);
                this.getNumTextField().setEditable(false);
                this.editData.setNumber(null);
                this.initOldData((IObjectValue)this.editData);
                this.kdtEntry.getColumn("materialNumber").getStyleAttributes().setLocked(true);
                this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().setLocked(true);
                return 1;
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    private boolean checkEntryIsBlank(KDTable table) {
        int rows = table.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (this.kdtEntry.getRow(i).getCell(table.getColumnIndex("materialNumber")).getValue() == null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private void SetTableFormat() throws EASBizException, BOSException {
        int maxRow = this.kdtEntry.getRowCount();
        if (this.prmtCompanyOrgUnit.getValue() != null) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()), SCMSelectorFactory.getCurrencySelector());
            int amtPrecision = baseCurrInfo.getPrecision();
            String amtFormat = CalculateUtil.fmtTableString(amtPrecision).toString();
            this.kdtEntry.getColumn("oldStandardAmount").getStyleAttributes().setNumberFormat(amtFormat);
            this.kdtEntry.getColumn("newStandardAmount").getStyleAttributes().setNumberFormat(amtFormat);
            this.kdtEntry.getColumn("diffAmount").getStyleAttributes().setNumberFormat(amtFormat);
            for (int i = 0; i < maxRow; ++i) {
                MaterialInfo aMaterialInfo = (MaterialInfo)this.kdtEntry.getRow(i).getCell("materialNumber").getValue();
                if (aMaterialInfo == null) continue;
                IMeasureUnit munit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo aMeasureUnitInfo = munit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aMaterialInfo.getBaseUnit().getId()));
                IMultiMeasureUnit imm = MultiMeasureUnitFactory.getRemoteInstance();
                int qtyPrecision = imm.getQtyPrecision(aMaterialInfo.getId().toString(), aMeasureUnitInfo.getId().toString());
                String c = CalculateUtil.fmtTableString(qtyPrecision).toString();
                this.kdtEntry.getRow(i).getCell("baseQty").getStyleAttributes().setNumberFormat(c);
                int pricePrecision = aMaterialInfo.getPricePrecision();
                c = CalculateUtil.fmtTableString(pricePrecision).toString();
                SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.kdtEntry, (String[])new String[]{"oldStandardPrice", "newStandardPrice", "diffPrice"}, (int)i);
            }
        }
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompanyOrgUnit;
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkBizDate_dataChanged(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int length;
        Object o = this.kDBizPromptBoxMaterial.getValue();
        KDTSelectBlock ksb = this.kdtEntry.getSelectManager().get();
        if (ksb == null) {
            return;
        }
        int beginRow = ksb.getBeginRow();
        if (o == null) {
            InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, null, (int)beginRow, (boolean)true);
        }
        if (!(o instanceof MaterialInfo[]) && !(o instanceof Object[])) {
            return;
        }
        MaterialInfo[] materialInfos = null;
        if (o instanceof MaterialInfo[]) {
            materialInfos = (MaterialInfo[])o;
        } else if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            if (objects.length == 0) {
                return;
            }
            materialInfos = new MaterialInfo[objects.length];
            System.arraycopy(objects, 0, materialInfos, 0, objects.length);
        }
        int n = length = materialInfos == null ? 0 : materialInfos.length;
        if (length > 0) {
            this.getKDBizPromptBoxMaterial().removeChangeListener((ChangeListener)this);
            int curCol = this.kdtEntry.getColumnIndex("materialNumber");
            for (int i = 0; i < length; ++i) {
                if (materialInfos[i] == null) {
                    return;
                }
                IRow curRow2 = this.kdtEntry.getRow(beginRow + i);
                curRow2.getCell(curCol).setValue(null);
                InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, null, (int)(beginRow + i), (boolean)true);
                curRow2.getCell(curCol).setValue((Object)materialInfos[i]);
                try {
                    this.tableValueChanged(i + beginRow, curCol);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
                if (i >= length - 1) continue;
                this.insertLine(beginRow + i + 1);
            }
            this.getKDBizPromptBoxMaterial().addChangeListener((ChangeListener)this);
        }
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntry);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell("materialNumber");
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
            cell = row.getCell("lot");
            if (cell != null) {
                String lot = (String)cell.getValue();
                hm.put("BATCH", lot);
            }
        }
        return hm;
    }

    protected String getEntryMaterialFieldName() {
        return "materialNumber";
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            int rowCount = this.kdtEntry.getRowCount();
            String[] checkCols = new String[]{"materialNumber"};
            for (int i = 0; i < rowCount; ++i) {
                if (!InvClientUtils.isRowBlankOnTable((KDTable)this.kdtEntry, (int)i, (String[])checkCols)) continue;
                this.removeLine(this.kdtEntry, i);
                --i;
                --rowCount;
            }
            rowCount = this.kdtEntry.getRowCount();
            if (rowCount == 0) {
                this.addLine(this.kdtEntry);
            }
            if (sb.toString().length() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
                SysUtil.abort();
            }
            return;
        }
        String strTemp = "";
        String strNo = InvClientUtils.getResource((String)"No");
        String strRow = InvClientUtils.getResource((String)"Row");
        int rowCount = this.kdtEntry.getRowCount();
        String[] checkCols = new String[]{"materialNumber"};
        for (int i = 0; i < rowCount - 1; ++i) {
            if (InvClientUtils.isRowBlankOnTable((KDTable)this.kdtEntry, (int)i, (String[])checkCols)) {
                this.removeLine(this.kdtEntry, i);
                --i;
                --rowCount;
                continue;
            }
            BigDecimal price = (BigDecimal)this.kdtEntry.getRow(i).getCell("newStandardPrice").getValue();
            if (price != null && price.compareTo(this.ZERO) != 0) continue;
            strTemp = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"MUSTINPUTNEWPRICE");
            if (sb.toString().length() == 0) {
                sb.append(strNo + (i + 1) + strRow + strTemp);
                continue;
            }
            sb.append(";");
            sb.append(strNo + (i + 1) + strRow + strTemp);
        }
        rowCount = this.kdtEntry.getRowCount();
        if (rowCount == 0) {
            strTemp = InvClientUtils.getResource((String)"EntryIsNull");
            if (sb.toString().length() == 0) {
                sb.append(strTemp);
                this.txtNumber.requestFocus();
            } else {
                sb.append(";");
                sb.append(strTemp);
            }
            this.addLine(this.kdtEntry);
        }
        this.showError(sb.toString());
    }

    private void showError(String error) {
        if (error.length() > 0) {
            MsgBox.showInfo((String)error);
            SysUtil.abort();
        }
    }

    public void editStarting(KDTEditEvent arg0) {
    }

    public void editStarted(KDTEditEvent arg0) {
    }

    public void editValueChanged(KDTEditEvent arg0) {
    }

    public void editStopping(KDTEditEvent arg0) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
                return;
            }
            int row = e.getRowIndex();
            int col = e.getColIndex();
            this.tableValueChanged(row, col);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(e, false);
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) throws Exception {
        StandardCostAdjBillCollection billCol = new StandardCostAdjBillCollection();
        billCol.add(this.editData);
        InvoicePrintDataSource rsprv = new InvoicePrintDataSource(billCol){

            public InvoicePrintDataSource.ColDesc[] getColDesc() {
                return new InvoicePrintDataSource.ColDesc[]{new InvoicePrintDataSource.ColDesc("number", "number"), new InvoicePrintDataSource.ColDesc("bizeDate", "bizDate", 2), new InvoicePrintDataSource.ColDesc("companyOrgUnit", "companyOrgUnit.name"), new InvoicePrintDataSource.ColDesc("billType", "baseStatus", 3, BillBaseStatusEnum.class), new InvoicePrintDataSource.ColDesc("creator", "creator.name"), new InvoicePrintDataSource.ColDesc("creatTime", "createTime", 2), new InvoicePrintDataSource.ColDesc("auditor", "auditor.name"), new InvoicePrintDataSource.ColDesc("auditTime", "auditTime", 2), new InvoicePrintDataSource.ColDesc("lastUpdator", "modifier.name"), new InvoicePrintDataSource.ColDesc("lastUpdatTime", "modificationTime", 2), new InvoicePrintDataSource.ColDesc("entryID", "entry.seq"), new InvoicePrintDataSource.ColDesc("materialNumber", "entry.material.number"), new InvoicePrintDataSource.ColDesc("materialName", "entry.material.name"), new InvoicePrintDataSource.ColDesc("materialModel", "entry.material.model"), new InvoicePrintDataSource.ColDesc("unit", "entry.baseUnit.name"), new InvoicePrintDataSource.ColDesc("qty", "entry.baseQty", 1), new InvoicePrintDataSource.ColDesc("oldStandardPrice", "entry.oldStandardPrice", 1), new InvoicePrintDataSource.ColDesc("oldStandardAmount", "entry.oldStandardAmount", 1), new InvoicePrintDataSource.ColDesc("newStandardPrice", "entry.newStandardPrice", 1), new InvoicePrintDataSource.ColDesc("newStandardAmount", "entry.newStandardAmount", 1), new InvoicePrintDataSource.ColDesc("diffPrice", "entry.diffPrice", 1), new InvoicePrintDataSource.ColDesc("diffAmount", "entry.diffAmount", 1), new InvoicePrintDataSource.ColDesc("description", "entry.remark")};
            }
        };
        rsprv.setEntryTag("entry");
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        data.put("MainQuery", (BOSQueryDelegate)rsprv);
        ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
        idList.add(this.editData.getId());
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(this.editData.getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)this.editData.getBOSType(), idList, (String)"/FI/CAL/StandardCostAdjBilll", (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)true);
        if (noPreview) {
            appHlp.print("/FI/CAL/StandardCostAdjBilll", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/FI/CAL/StandardCostAdjBilll", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompanyOrgUnit;
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "standardcost_new";
        }
        return null;
    }

    protected void initNeedMainOrgF7s() {
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.getKDBizPromptBoxMaterial()});
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
        try {
            this.setCostCenterFilter();
            this.prmtCostCenter.setValue(null);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void changeMainOrgUnit(PreChangeEvent pce) {
        this.preChange(pce);
    }

    public KDBizPromptBox getKDBizPromptBoxMaterial() {
        if (this.kDBizPromptBoxMaterial == null) {
            this.kDBizPromptBoxMaterial = this.getBizMaterialF7(this.kdtEntry.getColumn("materialNumber"), null);
            this.getKDBizPromptBoxMaterial().addChangeListener((ChangeListener)this);
        }
        return this.kDBizPromptBoxMaterial;
    }

    protected void initEditData(IObjectValue objectValue) {
        this.editData = (StandardCostAdjBillInfo)objectValue;
    }

    protected void materialChanged(String materialFieldname, DataChangeEvent e) {
    }

    public void actionCustomerView_actionPerformed(ActionEvent e) throws Exception {
        super.actionCustomerView_actionPerformed(e);
        this.changeCopyBtnStatus();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.execCopy();
    }

    private void changeCopyBtnStatus() {
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            this.btnCopy.setVisible(true);
            this.btnCopy.setEnabled(true);
        }
    }

    private void execCopy() {
        this.editData.setBizDate(new Date());
        this.editData.setBaseStatus(BillBaseStatusEnum.ADD);
        this.editData.setAuditor(null);
        this.editData.setModifier(null);
        this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        this.setStandardPriceMatierlF7();
        StandardCostAdjBillEntryCollection entries = this.editData.getEntry();
        if (entries != null) {
            StandardCostAdjBillEntryInfo billEntry = null;
            Object remark = null;
            for (int i = 0; i < entries.size(); ++i) {
                billEntry = entries.get(i);
                int curCol = this.kdtEntry.getColumnIndex("materialNumber");
                remark = this.kdtEntry.getRow(i).getCell("remark").getValue();
                MaterialInfo mi = billEntry.getMaterial();
                IRow curRow2 = this.kdtEntry.getRow(i);
                curRow2.getCell(curCol).setValue(null);
                InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, null, (int)i, (boolean)true);
                if (remark != null) {
                    this.kdtEntry.getRow(i).getCell("remark").setValue(remark);
                }
                curRow2.getCell(curCol).setValue((Object)mi);
                try {
                    this.tableValueChanged(i, curCol);
                    continue;
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            }
            if (this.kdtEntry.getColumn("materialNumber").getStyleAttributes().isLocked()) {
                this.kdtEntry.getColumn("materialNumber").getStyleAttributes().setLocked(false);
            }
            if (this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().isLocked()) {
                this.kdtEntry.getColumn("newStandardPrice").getStyleAttributes().setLocked(false);
            }
            if (this.kdtEntry.getColumn("remark").getStyleAttributes().isLocked()) {
                this.kdtEntry.getColumn("remark").getStyleAttributes().setLocked(false);
            }
        }
    }

    protected boolean isBillTotalRow() {
        return false;
    }

    private void setStandardPriceMatierlF7() {
        if (this.getKDBizPromptBoxMaterial() != null) {
            this.getKDBizPromptBoxMaterial().setValue(null);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(2), CompareType.EQUALS));
            view.setFilter(filter);
            this.getKDBizPromptBoxMaterial().setEntityViewInfo(view);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVENTORYACCOUNTING;
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        return new String[]{"baseQty", "oldStandardAmount", "newStandardAmount", "diffAmount"};
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entry.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        return sic;
    }

    public void setCostCenterFilter() throws EASBizException, BOSException {
        Set costCentersID = null;
        costCentersID = this.cou != null ? SCMUtils.getCostCenterByCompanyOrgInfo(null, (String)this.cou.getId().toString()) : new HashSet();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", costCentersID, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        viewInfo.setFilter(filterInfo);
        this.prmtCostCenter.setEntityViewInfo(viewInfo);
    }
}

