/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractStockDetailReportConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;

public class StockDetailReportConditionUI
extends AbstractStockDetailReportConditionUI {
    private static final long serialVersionUID = 1742165418378227144L;
    private static final String resClassName = "com.kingdee.eas.scm.cal.CalCommonResource";
    private CompanyOrgUnitInfo curCompany = null;
    private boolean isSetCustomCondition = false;
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
    private static final String objectTypeID = "7ac99937-00fb-1000-e000-0002c0a81345B999CA39";

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.bizOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
            this.loadCalculateTypeEnum((JComboBox)this.cmbCalType);
            this.loadStatusEnum((JComboBox)this.cmbStatus);
            this.cmbStatus.setSelectedIndex(2);
            this.cmbMaxCount.setSelectedIndex(0);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameFrom.setEditable(false);
        this.txtMShortNameTo.setText(null);
        this.txtMShortNameTo.setEditable(false);
        this.prmtKAClass.setEnabledMultiSelection(true);
        this.bizMaterialID.setCommitParser(null);
        this.bizMaterialIDTo.setCommitParser(null);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialID, null, null, null, true);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialIDTo, null, null, null, false);
        CalculateClientUtil.addListenerForMultiF7(this.bizMaterialID, this.bizMaterialIDTo);
        this.bizWarehouseFrom.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.bizWarehouseTo.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.bizWarehouseFrom.setEnabledMultiSelection(true);
        CalculateClientUtil.addListenerForMultiF7(this.bizWarehouseFrom, this.bizWarehouseTo);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialID, this.bizMaterialIDTo});
        this.registerStoreTypeFilter(this.bizStoreType);
        this.bizStoreType.setEnabledMultiSelection(true);
    }

    private void registerStoreTypeFilter(KDBizPromptBox box) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isForwardAmt", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        ev.setFilter(filter);
        box.setEntityViewInfo(ev);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.bizOrgUnit.getValue());
        para.setObject("materialFrom", this.bizMaterialID.getValue());
        para.setObject("materialTo", this.bizMaterialIDTo.getValue());
        para.setObject("calType", this.cmbCalType.getSelectedItem());
        para.setInt("accPeriodYearFrom", this.spAccPeriodYear.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthFrom", this.spAccPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("accPeriodYearTo", this.spAccPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthTo", this.spAccPeriodMonthTo.getIntegerVlaue().intValue());
        para.setInt("MaxCount", Integer.parseInt(this.cmbMaxCount.getSelectedItem().toString()));
        para.setString("txtMShortNameFrom", this.txtMShortNameFrom.getText().trim());
        para.setString("txtMShortNameTo", this.txtMShortNameTo.getText().trim());
        para.setObject("warehouseFrom", this.bizWarehouseFrom.getValue());
        para.setObject("warehouseTo", this.bizWarehouseTo.getValue());
        para.setObject("voucher", this.cmbVoucher.getSelectedItem());
        para.setObject("prmtKAClass", this.prmtKAClass.getValue());
        para.setBoolean("ckShowNoCalculate", this.ckShowNoCalculate.isSelected());
        para.setBoolean("noSelectNoneInOut", this.noSelectNoneInOut.isSelected());
        para.setBoolean("ckBxMShortName", this.ckBxMShortName.isSelected());
        para.setBoolean("noSelectStorageMoveBill", this.noSelectStorageMoveBill.isSelected());
        para.setBoolean("noSelectWarehouseMoveBill", this.noSelectWarehouseMoveBill.isSelected());
        para.setObject("status", this.cmbStatus.getSelectedItem());
        para.setObject("bizType", this.prmtBizType.getValue());
        para.setObject("transactionType", this.prmtTransaction.getValue());
        para.setObject("storeType", this.bizStoreType.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            return;
        }
        this.isSetCustomCondition = true;
        this.bizOrgUnit.setValue(params.getObject("company"));
        this.bizMaterialID.setValue(params.getObject("materialFrom"));
        this.bizMaterialIDTo.setValue(params.getObject("materialTo"));
        this.cmbCalType.setSelectedItem(params.getObject("calType"));
        this.cmbStatus.setSelectedItem(params.getObject("status"));
        this.spAccPeriodYear.setValue((Object)new Integer(params.getInt("accPeriodYearFrom")));
        this.spAccPeriodMonth.setValue((Object)new Integer(params.getInt("accPeriodMonthFrom")));
        this.spAccPeriodYearTo.setValue((Object)new Integer(params.getInt("accPeriodYearTo")));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(params.getInt("accPeriodMonthTo")));
        if (params.getObject("MaxCount") != null) {
            this.cmbMaxCount.setSelectedItem((Object)params.getObject("MaxCount").toString());
        }
        this.bizWarehouseFrom.setValue(params.getObject("warehouseFrom"));
        this.bizWarehouseTo.setValue(params.getObject("warehouseTo"));
        this.cmbVoucher.setSelectedItem(params.getObject("voucher"));
        this.prmtKAClass.setValue(params.getObject("prmtKAClass"));
        this.ckShowNoCalculate.setSelected(params.getBoolean("ckShowNoCalculate"));
        if (params.getObject("ckBxMShortName") != null) {
            this.ckBxMShortName.setSelected(params.getBoolean("ckBxMShortName"));
            if (this.ckBxMShortName.isSelected()) {
                this.txtMShortNameFrom.setEditable(true);
                this.txtMShortNameFrom.setText(params.getString("txtMShortNameFrom"));
                this.txtMShortNameTo.setEditable(true);
                this.txtMShortNameTo.setText(params.getString("txtMShortNameTo"));
            }
        } else {
            this.ckBxMShortName.setSelected(false);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setEditable(false);
            this.txtMShortNameTo.setText(null);
        }
        this.noSelectNoneInOut.setSelected(params.getBoolean("noSelectNoneInOut"));
        this.cmbStatus.setSelectedItem(params.getObject("status"));
        this.noSelectStorageMoveBill.setSelected(params.getBoolean("noSelectStorageMoveBill"));
        this.noSelectWarehouseMoveBill.setSelected(params.getBoolean("noSelectWarehouseMoveBill"));
        this.isSetCustomCondition = false;
        this.bizStoreType.setValue(params.getObject("storeType"));
        this.prmtBizType.setValue(params.getObject("bizType"));
        this.prmtTransaction.setValue(params.getObject("transactionType"));
    }

    private void loadCalculateTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<CalculateTypeEnum> model = new DefaultComboBoxModel<CalculateTypeEnum>();
        Iterator i = CalculateTypeEnum.iterator();
        while (i.hasNext()) {
            CalculateTypeEnum e = (CalculateTypeEnum)i.next();
            model.addElement(e);
        }
        cb.setModel(model);
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    private void setTransactionF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.NOTEQUALS));
        view.setFilter(filter);
        this.prmtTransaction.setEntityViewInfo(view);
    }

    private void setKAClassF7Filter(CompanyOrgUnitInfo companyOrg) {
        if (companyOrg != null) {
            String companyID = companyOrg.getId().toString();
            if (companyOrg.getAccountTable() == null) {
                return;
            }
            String accountTableID = companyOrg.getAccountTable().getId().toString();
            this.prmtKAClass.setValue(null);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("objectType.id", (Object)objectTypeID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)accountTableID, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
            viewInfo.setFilter(filterInfo);
            this.prmtKAClass.setEntityViewInfo(viewInfo);
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    @Override
    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        if (!this.isSetCustomCondition) {
            this.curCompany = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            if (this.bizOrgUnit.getData() != null) {
                this.loadAccountPeriod((CompanyOrgUnitInfo)this.bizOrgUnit.getData());
            }
            this.curCompany = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            if (this.curCompany != null) {
                this.bizMaterialID.setEnabled(true);
                this.bizMaterialIDTo.setEnabled(true);
            } else {
                this.bizMaterialID.setEnabled(false);
                this.bizMaterialIDTo.setEnabled(false);
            }
            this.bizWarehouseFrom.setValue(null);
            this.bizWarehouseTo.setValue(null);
        }
        if (this.curCompany != null) {
            this.setKAClassF7Filter(this.curCompany);
            this.f7Manger.changeF7Context(this.curCompany.getId().toString());
        }
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, null, this.bizWarehouseFrom, true);
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, null, this.bizWarehouseTo, true);
    }

    @Override
    protected void cmbStatus_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbStatus_itemStateChanged(e);
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.bizOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spAccPeriodYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spAccPeriodMonth.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spAccPeriodYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spAccPeriodMonthTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public void clear() {
        this.prmtBizType.setValue(null);
        this.prmtTransaction.setValue(null);
        this.bizOrgUnit.setValue(null);
        this.spAccPeriodYear.setValue((Object)new Integer(0));
        this.spAccPeriodMonth.setValue((Object)new Integer(0));
        this.spAccPeriodYearTo.setValue((Object)new Integer(0));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(0));
        this.bizMaterialID.setValue(null);
        this.bizMaterialIDTo.setValue(null);
        this.cmbMaxCount.setSelectedIndex(0);
        this.bizWarehouseFrom.setValue(null);
        this.bizWarehouseTo.setValue(null);
        this.cmbCalType.setSelectedItem((Object)CalculateTypeEnum.NULL);
        this.cmbVoucher.setSelectedItem((Object)VoucheredEnum.Null);
        this.prmtKAClass.setValue(null);
        this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.ckShowNoCalculate.setSelected(false);
        this.noSelectNoneInOut.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.ckBxMShortName.setSelected(false);
        this.noSelectStorageMoveBill.setSelected(false);
        this.noSelectWarehouseMoveBill.setSelected(false);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.bizOrgUnit.setData((Object)this.curCompany);
            } else {
                this.bizOrgUnit.setData(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    protected void addKAClassListener() {
        this.prmtKAClass.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (StockDetailReportConditionUI.this.bizOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)StockDetailReportConditionUI.resClassName, (String)"COMPANY_NOTNULL"));
                    SysUtil.abort();
                } else {
                    StockDetailReportConditionUI.this.setKAClassF7Filter((CompanyOrgUnitInfo)StockDetailReportConditionUI.this.bizOrgUnit.getValue());
                }
                StockDetailReportConditionUI.this.prmtKAClass.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizOrgUnit;
    }

    protected String getViewPermission() {
        return "stockdetailreport_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(true);
            this.txtMShortNameTo.setEditable(true);
        } else {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setEditable(false);
        }
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (StockDetailReportConditionUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = StockDetailReportConditionUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                        StockDetailReportConditionUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }
}

