/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffBillTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WrittenOffFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractWriteOffReportFilterUI;
import com.kingdee.eas.scm.cal.client.ExceptionBalanceReportFilterUI;
import com.kingdee.eas.scm.cal.client.WriteOffReportUI;
import com.kingdee.eas.scm.cal.info.WriteOffPeriodInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class WriteOffReportFilterUI
extends AbstractWriteOffReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ExceptionBalanceReportFilterUI.class);
    private CompanyOrgUnitInfo oldCompanyInfo = null;
    WriteOffReportUI ui = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private String writeOffType;
    private boolean isDevolve;
    private String companyOrgUnitID = null;
    private Map periodMap = new HashMap();
    protected F7ContextManager f7Manager = null;

    public WriteOffReportFilterUI(WriteOffReportUI reportUI) throws Exception {
        this.ui = reportUI;
        this.writeOffType = reportUI.writeOffType;
        if (this.writeOffType == null) {
            this.writeOffType = "PUR_WRITEOFF";
            this.ui.writeOffType = "PUR_WRITEOFF";
        }
        this.isDevolve = reportUI.isDevolve;
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.writeOffType.equals("INCOME_WRITEOFF") || this.writeOffType.equals("SALE_WRITEOFF")) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameTo.setEditable(false);
            this.comBillTypeNumber.removeItem((Object)WriteOffBillTypeEnum.PURINWAREHS);
            this.comBillTypeNumber.removeItem((Object)WriteOffBillTypeEnum.APOTHERBILL);
            this.comBillTypeNumber.removeItem((Object)WriteOffBillTypeEnum.COSTADJUST);
        } else {
            this.comBillTypeNumber.removeItem((Object)WriteOffBillTypeEnum.AROTHERBILL);
            this.comBillTypeNumber.removeItem((Object)WriteOffBillTypeEnum.SALEISSUE);
        }
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.prmtFinanceOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
        if (null != company && !this.periodMap.containsKey(company.getId().toString())) {
            Map map = WrittenOffFacadeFactory.getRemoteInstance().loadFinanceData(company.getId().toString());
            WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(company.getId().toString());
            this.periodMap.put(company.getId().toString(), info);
        }
        this.prmtFinanceOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData().equals(e.getOldData())) {
                    return;
                }
                e.setResult(WriteOffReportFilterUI.this.prmtCompanyOrgUnit(e));
            }
        });
        this.bizWriteOffMan.setEditable(true);
        this.bizWriteOffMan.setDisplayFormat("$name$");
        this.bizWriteOffMan.setEditFormat("$number$");
        this.bizWriteOffMan.setCommitFormat("$number$");
        if (!this.ui.writeOffType.equals("PUR_WRITEOFF")) {
            this.f7Manager.registerBizCustomerF7(this.prmtSupplier, null, null, (OrgUnitInfo)company, OrgType.Company, true);
            this.f7Manager.registerBizCustomerF7(this.prmtSupplierTo, null, null, (OrgUnitInfo)company, OrgType.Company, true);
            this.labSupplier.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"customer"));
        } else {
            this.f7Manager.registerBizSupplierF7(this.prmtSupplier, null, null, (OrgUnitInfo)company, OrgType.Company, true);
            this.f7Manager.registerBizSupplierF7(this.prmtSupplierTo, null, null, (OrgUnitInfo)company, OrgType.Company, true);
            this.labSupplier.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"supplier"));
        }
        this.prmtSupplier.setDisplayFormat("$name$");
        this.prmtSupplier.setEditFormat("$number$");
        this.prmtSupplier.setCommitFormat("$number$;$name$");
        this.prmtSupplierTo.setDisplayFormat("$name$");
        this.prmtSupplierTo.setEditFormat("$number$");
        this.prmtSupplierTo.setCommitFormat("$number$;$name$");
        this.setBizMaterialF7(this.prmtMaterial, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        new SCMClientHelper((CoreUIObject)this).registerFilterUIDateCompare(this.pkWriteOffDate, this.pkWriteOffDateTo);
    }

    private int prmtCompanyOrgUnit(PreChangeEvent e) {
        try {
            Object obj = e.getData();
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            if (obj instanceof CompanyOrgUnitInfo) {
                aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)e.getData();
                this.companyOrgUnitID = aCompanyOrgUnitInfo.getId().toString();
                if (!this.periodMap.containsKey(this.companyOrgUnitID)) {
                    IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
                    Map map = iw.loadFinanceData(aCompanyOrgUnitInfo);
                    WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(this.companyOrgUnitID);
                    this.periodMap.put(this.companyOrgUnitID, info);
                }
            }
            if (aCompanyOrgUnitInfo != null && !aCompanyOrgUnitInfo.equals(e.getOldData())) {
                this.prmtFinanceOrgUnit.setData((Object)aCompanyOrgUnitInfo);
                if (!this.isPeriodNotNull(aCompanyOrgUnitInfo)) {
                    return 0;
                }
                this.loadAccountPeriod(aCompanyOrgUnitInfo);
                this.prmtSupplier.setCurrentMainBizOrgUnit((OrgUnitInfo)aCompanyOrgUnitInfo, this.getMainBizOrgType());
                this.prmtSupplierTo.setCurrentMainBizOrgUnit((OrgUnitInfo)aCompanyOrgUnitInfo, this.getMainBizOrgType());
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    private boolean isPeriodNotNull(CompanyOrgUnitInfo companyOrgUnitInfo) {
        PeriodInfo curPeriodInfo = null;
        try {
            if (this.periodMap.containsKey(companyOrgUnitInfo.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyOrgUnitInfo.getId().toString());
                curPeriodInfo = info.getCurPeriodInfo();
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (curPeriodInfo == null) {
            this.prmtFinanceOrgUnit.setValue(null);
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            return false;
        }
        return true;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtFinanceOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.prmtFinanceOrgUnit_stateChanged(e);
    }

    public void onInit(RptParams arg0) throws Exception {
        this.onInitFilter();
    }

    private void onInitFilter() {
        this.pkWriteOffDate.setValue((Object)new Date());
        this.pkWriteOffDateTo.setValue((Object)new Date());
        try {
            this.prmtFinanceOrgUnit.setData((Object)((CompanyOrgUnitInfo)this.getDefaultMainBizOrg()));
            if (this.prmtFinanceOrgUnit.getValue() != null) {
                this.oldCompanyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
                this.prmtFinanceOrgUnit.setValue((Object)this.oldCompanyInfo);
                this.prmtFinanceOrgUnit.setText(this.oldCompanyInfo.getNumber());
                this.prmtFinanceOrgUnit.setLabelText(this.oldCompanyInfo.getName());
                this.companyOrgUnitID = this.oldCompanyInfo.getId().toString();
                this.loadAccountPeriod(this.oldCompanyInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.pkBillDate.setValue(null);
        this.pkBillDateTo.setValue(null);
        this.txtCurrWrittenOffQty.setSupportedEmpty(true);
        this.txtCurrWrittenOffQty.setValue(null);
        this.txtCurrWrittenOffQtyTo.setSupportedEmpty(true);
        this.txtCurrWrittenOffQtyTo.setValue(null);
        this.txtCurrWrittenOffAmount.setSupportedEmpty(true);
        this.txtCurrWrittenOffAmount.setValue(null);
        this.txtCurrWrittenOffAmountTo.setSupportedEmpty(true);
        this.txtCurrWrittenOffAmountTo.setValue(null);
        this.txtWirttenOffQty.setSupportedEmpty(true);
        this.txtWirttenOffQty.setValue(null);
        this.txtWirttenOffQtyTo.setSupportedEmpty(true);
        this.txtWirttenOffQtyTo.setValue(null);
        this.txtWrittenOffAmount.setSupportedEmpty(true);
        this.txtWrittenOffAmount.setValue(null);
        this.txtWrittenOffAmountTo.setSupportedEmpty(true);
        this.txtWrittenOffAmountTo.setValue(null);
        this.txtUnWirteOffQty.setSupportedEmpty(true);
        this.txtUnWirteOffQty.setValue(null);
        this.txtUnWirteOffQtyTo.setSupportedEmpty(true);
        this.txtUnWirteOffQtyTo.setValue(null);
        this.txtUnWriteOffAmount.setSupportedEmpty(true);
        this.txtUnWriteOffAmount.setValue(null);
        this.txtUnWriteOffAmountTo.setSupportedEmpty(true);
        this.txtUnWriteOffAmountTo.setValue(null);
        this.txtCurrWrittenOffQty.setDataType(5);
        this.txtCurrWrittenOffQtyTo.setDataType(5);
        this.txtCurrWrittenOffAmount.setDataType(5);
        this.txtCurrWrittenOffAmountTo.setDataType(5);
        this.txtWirttenOffQty.setDataType(5);
        this.txtWirttenOffQtyTo.setDataType(5);
        this.txtWrittenOffAmount.setDataType(5);
        this.txtWrittenOffAmountTo.setDataType(5);
        this.txtUnWirteOffQty.setDataType(5);
        this.txtUnWirteOffQtyTo.setDataType(5);
        this.txtUnWriteOffAmount.setDataType(5);
        this.txtUnWriteOffAmountTo.setDataType(5);
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.prmtFinanceOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtFinanceOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spinPeriodYear, this.spinPeriodYearTo, this.spinPeriodMonth, this.spinPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = this.getSubFilterInfo();
        EntityViewInfo entityVInfo = this.getEntityFilter(filter);
        this.handleEntryFilter(entityVInfo, filter);
        return filter;
    }

    private FilterInfo getSubFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        HashMap<String, Comparable<StringBuffer>> hm = new HashMap<String, Comparable<StringBuffer>>();
        hm.put("String", new StringBuffer());
        hm.put("Int", new Integer(0));
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
        if (cou == null || cou.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        this.setFilter(((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData()).getId().toString(), "companyOrgUnit.id", CompareType.EQUALS, items, hm);
        this.setFilter(this.bizWriteOffMan.getText(), "creator.name", CompareType.EQUALS, items, hm);
        this.setFilter(SCMUtils.getDayStartTime((Date)((Date)this.pkWriteOffDate.getValue())), "writeOffDate", CompareType.GREATER_EQUALS, items, hm);
        this.setFilter(SCMUtils.getDayEndTime((Date)((Date)this.pkWriteOffDateTo.getValue())), "writeOffDate", CompareType.LESS_EQUALS, items, hm);
        this.setFilter(this.txtMShortNameFrom.getText(), "material.shortname", CompareType.GREATER_EQUALS, items, hm);
        if (!this.ckBxWriteOff.isSelected()) {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT 1 FROM T_CL_WriteOffrecord r where r.fparentid= WRITEOFFGROUP.fid");
            sb.append(" group by fparentid having count(distinct fbilltypenumber) = 1");
            this.setFilter(sb.toString(), "id", CompareType.NOTEXISTS, items, hm);
        }
        StringBuffer sbFormula = (StringBuffer)hm.get("String");
        int i = (Integer)hm.get("Int");
        Integer yearf = (Integer)this.spinPeriodYear.getValue();
        Integer periodf = (Integer)this.spinPeriodMonth.getValue();
        if (yearf != null && periodf != null) {
            items.add(new FilterItemInfo("writeOffYear", (Object)yearf, CompareType.GREATER));
            sbFormula.append(" and (#" + i);
            items.add(new FilterItemInfo("writeOffYear", (Object)yearf, CompareType.EQUALS));
            sbFormula.append(" or (#" + ++i);
            items.add(new FilterItemInfo("writeOffPeriod", (Object)periodf, CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + ++i).append("))");
            ++i;
        }
        Integer yeart = (Integer)this.spinPeriodYearTo.getValue();
        Integer periodt = (Integer)this.spinPeriodMonthTo.getValue();
        if (yeart != null && periodt != null) {
            items.add(new FilterItemInfo("writeOffYear", (Object)yeart, CompareType.LESS));
            sbFormula.append(" and (#" + i);
            items.add(new FilterItemInfo("writeOffYear", (Object)yeart, CompareType.EQUALS));
            sbFormula.append(" or (#" + ++i);
            items.add(new FilterItemInfo("writeOffPeriod", (Object)periodt, CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + ++i).append("))");
            ++i;
        }
        if (this.txtMShortNameTo.getText() != null && this.txtMShortNameTo.getText().trim().length() > 0) {
            FilterItemInfo templateFilterItemInfo2 = new FilterItemInfo("material.shortname", (Object)this.txtMShortNameTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and (#" + i++);
            }
            FilterItemInfo templateFilterItemInfoOr = new FilterItemInfo("material.shortname", null, CompareType.IS);
            items.add(templateFilterItemInfoOr);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" or #" + i++ + ")");
            }
        }
        int calculateKind = !this.writeOffType.equals("PUR_WRITEOFF") ? 1 : 0;
        items.add(new FilterItemInfo("calculateKind", (Object)new Integer(calculateKind), CompareType.EQUALS));
        sbFormula.append(" and #" + i);
        hm.put("String", sbFormula);
        hm.put("Int", new Integer(i));
        if (((StringBuffer)hm.get("String")).toString().length() != 0) {
            filter.setMaskString(((StringBuffer)hm.get("String")).toString());
        }
        return filter;
    }

    private void setFilter(FilterInfo entry, Object obj, String fieldName, CompareType comparetype) {
        WriteOffBillTypeEnum billType;
        if (null == obj) {
            return;
        }
        if (obj instanceof String && !StringUtil.isEmpty((String)((String)obj))) {
            entry.getFilterItems().add(new FilterItemInfo(fieldName, obj, comparetype));
        } else if (obj instanceof BigDecimal) {
            BigDecimal temp = (BigDecimal)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)temp, comparetype));
        } else if (obj instanceof Date) {
            entry.getFilterItems().add(new FilterItemInfo(fieldName, obj, comparetype));
        } else if (obj instanceof MaterialInfo) {
            MaterialInfo material = (MaterialInfo)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)material.getNumber(), comparetype));
        } else if (obj instanceof SupplierInfo) {
            SupplierInfo supplier = (SupplierInfo)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)supplier.getNumber(), comparetype));
        } else if (obj instanceof CustomerInfo) {
            CustomerInfo customer = (CustomerInfo)obj;
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)customer.getNumber(), comparetype));
        } else if (obj instanceof WriteOffBillTypeEnum && !"-1".equals((billType = (WriteOffBillTypeEnum)((Object)obj)).getValue())) {
            entry.getFilterItems().add(new FilterItemInfo(fieldName, (Object)billType.getValue(), comparetype));
        }
    }

    private void setFilter(Object obj, String key, CompareType comparetype, FilterItemCollection items, HashMap hm) {
        boolean bln;
        StringBuffer sbFormula = (StringBuffer)hm.get("String");
        Integer i = (Integer)hm.get("Int");
        boolean bl = bln = i == 0;
        if (obj != null && (!(obj instanceof String) || obj instanceof String && ((String)obj).trim().length() > 0)) {
            FilterItemInfo templateFilterItemInfo = new FilterItemInfo(key, obj, comparetype);
            items.add(templateFilterItemInfo);
            sbFormula.append(bln ? "#" : " and #").append(i.toString());
            i = new Integer(i + 1);
        }
        hm.put("String", sbFormula);
        hm.put("Int", i);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            if (entityViewInfo == null || entityViewInfo.getFilter() == null) {
                return;
            }
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            this.pkWriteOffDate.setValue(null);
            this.pkWriteOffDateTo.setValue(null);
            this.bizWriteOffMan.setText(null);
            this.prmtFinanceOrgUnit.setText(null);
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (this.checkPropertyNameAndCompareType("companyOrgUnit.id", CompareType.EQUALS, filterItemInfo)) {
                    String obj = filterItemInfo.getCompareValue().toString();
                    ICompanyOrgUnit ic = CompanyOrgUnitFactory.getRemoteInstance();
                    CompanyOrgUnitInfo c = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(obj));
                    if (c != null) {
                        this.prmtFinanceOrgUnit.setValue((Object)c);
                        this.prmtFinanceOrgUnit.setText(c.getNumber());
                        this.prmtFinanceOrgUnit.setLabelText(c.getName());
                    }
                }
                this.getFilter("creator.name", CompareType.EQUALS, this.bizWriteOffMan, filterItemInfo);
                this.getFilter("writeOffDate", CompareType.GREATER_EQUALS, this.pkWriteOffDate, filterItemInfo);
                this.getFilter("writeOffDate", CompareType.LESS_EQUALS, this.pkWriteOffDateTo, filterItemInfo);
                this.getFilter("writeOffYear", CompareType.GREATER, this.spinPeriodYear, filterItemInfo);
                this.getFilter("writeOffYear", CompareType.LESS, this.spinPeriodYearTo, filterItemInfo);
                this.getFilter("writeOffPeriod", CompareType.GREATER_EQUALS, this.spinPeriodMonth, filterItemInfo);
                this.getFilter("writeOffPeriod", CompareType.LESS_EQUALS, this.spinPeriodMonthTo, filterItemInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void getFilter(String key, CompareType comparetype, KDSpinner box, FilterItemInfo filterItemInfo) {
        if (this.checkPropertyNameAndCompareType(key, comparetype, filterItemInfo)) {
            Object obj = filterItemInfo.getCompareValue();
            box.setValue(obj);
        }
    }

    private void getFilter(String key, CompareType comparetype, KDTextField box, FilterItemInfo filterItemInfo) {
        if (this.checkPropertyNameAndCompareType(key, comparetype, filterItemInfo)) {
            Object obj = filterItemInfo.getCompareValue();
            box.setText(obj.toString());
        }
    }

    private void getFilter(String key, CompareType comparetype, KDDatePicker box, FilterItemInfo filterItemInfo) {
        if (this.checkPropertyNameAndCompareType(key, comparetype, filterItemInfo)) {
            Object obj = filterItemInfo.getCompareValue();
            box.setValue(obj);
        }
    }

    private void getFilter(String key, CompareType comparetype, KDBizPromptBox box, FilterItemInfo filterItemInfo) {
        if (this.checkPropertyNameAndCompareType(key, comparetype, filterItemInfo)) {
            Object obj = filterItemInfo.getCompareValue();
            box.setValue(obj);
        }
    }

    private boolean checkPropertyNameAndCompareType(String key, CompareType comparetype, FilterItemInfo filterItemInfo) {
        return filterItemInfo.getPropertyName() != null && filterItemInfo.getPropertyName().equals(key) && filterItemInfo.getCompareType().getName().equals(comparetype.getName());
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        String CompanyOrgUnitID = "";
        String companyname = "";
        String creatorid = "";
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            companyname = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getName();
            if (((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId() != null) {
                CompanyOrgUnitID = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        if (this.bizWriteOffMan.getValue() != null) {
            UserInfo m = null;
            if (this.bizWriteOffMan.getValue() instanceof UserInfo[]) {
                m = ((UserInfo[])this.bizWriteOffMan.getValue())[0];
            } else if (this.bizWriteOffMan.getValue() instanceof UserInfo) {
                m = (UserInfo)this.bizWriteOffMan.getValue();
            }
            if (m != null && m.getId() != null) {
                creatorid = m.getId().toString();
            }
        }
        para.setString("COMPANY_ID", CompanyOrgUnitID);
        para.setString("COMPANY_NAME", companyname);
        para.setString("creator.name", creatorid);
        para.setString("writeOffDateFrom", this.pkWriteOffDate.getText());
        para.setString("writeOffDateTo", this.pkWriteOffDateTo.getText());
        para.setInt("YEAR_FROM", this.spinPeriodYear.getIntegerVlaue().intValue());
        para.setInt("PERIOD_FROM", this.spinPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("YEAR_TO", this.spinPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("PERIOD_TO", this.spinPeriodMonthTo.getIntegerVlaue().intValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        try {
            if (params.getString("COMPANY_ID") != null && params.getString("COMPANY_ID").length() != 0) {
                CompanyOrgUnitInfo cinfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(params.getString("COMPANY_ID")));
                this.prmtFinanceOrgUnit.setValue((Object)cinfo);
            }
            if (params.getString("creator.name") != null && params.getString("creator.name").length() != 0) {
                UserInfo mtoinfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(params.getString("creator.name")));
                this.bizWriteOffMan.setValue((Object)mtoinfo);
            }
            this.pkWriteOffDate.setValue((Object)params.getString("writeOffDateFrom"));
            this.pkWriteOffDateTo.setValue((Object)params.getString("writeOffDateTo"));
            this.spinPeriodYear.setValue((Object)new Integer(params.getInt("YEAR_FROM")));
            this.spinPeriodMonth.setValue((Object)new Integer(params.getInt("PERIOD_FROM")));
            this.spinPeriodYearTo.setValue((Object)new Integer(params.getInt("YEAR_TO")));
            this.spinPeriodMonthTo.setValue((Object)new Integer(params.getInt("PERIOD_TO")));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void dataChanged(DataChangeEvent e) {
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    public void stateChanged(ChangeEvent e) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        KDSpinner aSpinner = (KDSpinner)e.getSource();
        PeriodInfo periodInfo = null;
        try {
            periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if (periodInfo != null) {
                int startYear = periodInfo.getPeriodYear();
                int startMonth = periodInfo.getPeriodNumber();
                int minPeriod = PeriodUtils.getMinPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
                int maxPeriod = PeriodUtils.getMaxPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
                if (aSpinner.getName().toString().equals("spinPeriodYear")) {
                    if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                        minPeriod = startMonth;
                    }
                    this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonth, minPeriod, maxPeriod);
                    int curPeriod = Integer.parseInt(this.spinPeriodMonth.getValue().toString());
                    if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                        this.spinPeriodMonth.setValue((Object)new Integer(maxPeriod));
                    }
                } else {
                    if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                        minPeriod = startMonth;
                    }
                    this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonthTo, minPeriod, maxPeriod);
                    int curPeriod = Integer.parseInt(this.spinPeriodMonth.getValue().toString());
                    if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                        this.spinPeriodMonthTo.setValue((Object)new Integer(maxPeriod));
                    }
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void clear() {
        super.clear();
        this.pkWriteOffDate.setValue(null);
        this.pkWriteOffDateTo.setValue(null);
        this.bizWriteOffMan.setText(null);
        this.prmtFinanceOrgUnit.setText(null);
        this.comBillTypeNumber.setSelectedItem(null);
        this.txtBillNumber.setText(null);
        this.txtBillNumberTo.setText(null);
        this.txtOrderBillNumber.setText(null);
        this.txtOrderBillNumberTo.setText(null);
        this.pkBillDate.setValue(null);
        this.pkBillDateTo.setValue(null);
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtSupplier.setValue(null);
        this.prmtSupplierTo.setValue(null);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.ckBxMShortName.setSelected(false);
        this.ckBxWriteOff.setSelected(true);
        try {
            this.onInitFilter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        if (cou == null || cou.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        try {
            PeriodInfo periodInfo = null;
            if (this.periodMap.containsKey(cou.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(cou.getId().toString());
                periodInfo = info.getStartPeriodInfo();
            } else {
                periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            }
            if (periodInfo == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
                return false;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                FullOrgUnitCollection collection = CalculateUtil.getOrgUnitPermissionItem(null, this.getMainBizOrgType(), this.getViewPermission(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), null);
                this.mainOrgs = SCMGroupClientUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)this.getMainBizOrgType());
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtFinanceOrgUnit;
    }

    protected String getViewPermission() {
        if (this.writeOffType.equals("SALE_WRITEOFF")) {
            return "SaleWriteOffReportView";
        }
        if (this.writeOffType.equals("PUR_WRITEOFF")) {
            return "StockWriteOffReportView";
        }
        if (this.writeOffType.equals("INCOME_WRITEOFF")) {
            return "IncomeWriteOffReportView";
        }
        if (this.isDevolve) {
            return "DevolveWriteOffReportView";
        }
        return "PermissionTypeError";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public String getCompanyOrgUnitID() {
        return this.companyOrgUnitID;
    }

    protected void setBizMaterialF7(KDBizPromptBox bizMaterialBox, boolean isMulSelect, String queryInfo) {
        this.f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, null, isMulSelect);
        bizMaterialBox.setDisplayFormat("$name$");
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$");
    }

    private void handleEntryFilter(EntityViewInfo entityViewInfo, FilterInfo filter) {
        try {
            IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
            entityViewInfo = iw.processEntryFilter(new WriteOffGroupInfo().getBOSType(), entityViewInfo);
            FilterInfo filterEntryInfo = entityViewInfo.getFilter();
            filter.mergeFilter(filterEntryInfo, "AND");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private EntityViewInfo getEntityFilter(FilterInfo filter) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo entry = new FilterInfo(EntryFilterType.ENTRYANYWHERE);
        entry.setEntryName("entry");
        this.setFilter(entry, this.comBillTypeNumber.getSelectedItem(), "billTypeNumber", CompareType.EQUALS);
        this.setFilter(entry, this.txtBillNumber.getText(), "billNumber", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtBillNumberTo.getText(), "billNumber", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.txtOrderBillNumber.getText(), "orderBillNumber", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtOrderBillNumberTo.getText(), "orderBillNumber", CompareType.LESS_EQUALS);
        this.setFilter(entry, SCMUtils.getDayStartTime((Date)((Date)this.pkBillDate.getValue())), "billDate", CompareType.GREATER_EQUALS);
        this.setFilter(entry, SCMUtils.getDayStartTime((Date)((Date)this.pkBillDateTo.getValue())), "billDate", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.prmtMaterial.getValue(), "material.number", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.prmtMaterialTo.getValue(), "material.number", CompareType.LESS_EQUALS);
        if (this.ui.writeOffType.equals("PUR_WRITEOFF")) {
            this.setFilter(entry, this.prmtSupplier.getValue(), "supplier.number", CompareType.GREATER_EQUALS);
            this.setFilter(entry, this.prmtSupplierTo.getValue(), "supplier.number", CompareType.LESS_EQUALS);
        } else {
            this.setFilter(entry, this.prmtSupplier.getValue(), "customer.number", CompareType.GREATER_EQUALS);
            this.setFilter(entry, this.prmtSupplierTo.getValue(), "customer.number", CompareType.LESS_EQUALS);
        }
        this.setFilter(entry, this.txtCurrWrittenOffQty.getValue(), "currWrittenOffQty", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtCurrWrittenOffQtyTo.getValue(), "currWrittenOffQty", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.txtCurrWrittenOffAmount.getValue(), "currWrittenOffAmount", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtCurrWrittenOffAmountTo.getValue(), "currWrittenOffAmount", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.txtWirttenOffQty.getValue(), "wirttenOffQty", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtWirttenOffQtyTo.getValue(), "wirttenOffQty", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.txtWrittenOffAmount.getValue(), "writtenOffAmount", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtWrittenOffAmountTo.getValue(), "writtenOffAmount", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.txtUnWirteOffQty.getValue(), "unWirteOffQty", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtUnWirteOffQtyTo.getValue(), "unWirteOffQty", CompareType.LESS_EQUALS);
        this.setFilter(entry, this.txtUnWriteOffAmount.getValue(), "unWriteOffAmount", CompareType.GREATER_EQUALS);
        this.setFilter(entry, this.txtUnWriteOffAmountTo.getValue(), "unWriteOffAmount", CompareType.LESS_EQUALS);
        entityViewInfo.getEntryFilters().add(entry);
        return entityViewInfo;
    }

    public CustomerParams getCustomerParams() {
        MaterialInfo materialInfo;
        Object value;
        CustomerParams custParam = new CustomerParams();
        if (this.comBillTypeNumber.getSelectedItem() != null) {
            custParam.addCustomerParam("comBillTypeNumber", ((WriteOffBillTypeEnum)((Object)this.comBillTypeNumber.getSelectedItem())).getValue());
        }
        if (!StringUtil.isEmpty((String)this.txtBillNumber.getText())) {
            custParam.addCustomerParam("txtBillNumber", this.txtBillNumber.getText());
        }
        if (!StringUtil.isEmpty((String)this.txtBillNumberTo.getText())) {
            custParam.addCustomerParam("txtBillNumberTo", this.txtBillNumberTo.getText());
        }
        if (!StringUtil.isEmpty((String)this.txtOrderBillNumber.getText())) {
            custParam.addCustomerParam("txtOrderBillNumber", this.txtOrderBillNumber.getText());
        }
        if (!StringUtil.isEmpty((String)this.txtOrderBillNumberTo.getText())) {
            custParam.addCustomerParam("txtOrderBillNumberTo", this.txtOrderBillNumberTo.getText());
        }
        if (this.pkBillDate.getValue() != null) {
            custParam.putDate("pkBillDate", (Date)this.pkBillDate.getValue());
        }
        if (this.pkBillDateTo.getValue() != null) {
            custParam.putDate("pkBillDateTo", (Date)this.pkBillDateTo.getValue());
        }
        if (this.prmtMaterial.getValue() != null) {
            value = this.prmtMaterial.getValue();
            materialInfo = null;
            materialInfo = value instanceof Object[] ? (MaterialInfo)((Object[])value)[0] : (MaterialInfo)value;
            custParam.addCustomerParam("prmtMaterial", materialInfo.getId().toString());
        }
        if (this.prmtMaterialTo.getValue() != null) {
            value = this.prmtMaterialTo.getValue();
            materialInfo = null;
            materialInfo = value instanceof Object[] ? (MaterialInfo)((Object[])value)[0] : (MaterialInfo)value;
            custParam.addCustomerParam("prmtMaterialTo", materialInfo.getId().toString());
        }
        if ((this.writeOffType.equals("SALE_WRITEOFF") || this.writeOffType.equals("INCOME_WRITEOFF")) && this.txtMShortNameFrom.getText() != null && this.txtMShortNameFrom.getText().trim().length() > 0) {
            custParam.addCustomerParam("txtMShortNameFrom", this.txtMShortNameFrom.getText().trim());
        }
        if ((this.writeOffType.equals("SALE_WRITEOFF") || this.writeOffType.equals("INCOME_WRITEOFF")) && this.txtMShortNameTo.getText() != null && this.txtMShortNameTo.getText().trim().length() > 0) {
            custParam.addCustomerParam("txtMShortNameTo", this.txtMShortNameTo.getText().trim());
        }
        custParam.putBoolean("ckBxWriteOff", this.ckBxWriteOff.isSelected());
        if (this.writeOffType.equals("SALE_WRITEOFF") || this.writeOffType.equals("INCOME_WRITEOFF")) {
            custParam.putBoolean("ckBxMShortName", this.ckBxMShortName.isSelected());
        }
        if (this.prmtSupplier.getValue() != null) {
            if (this.ui.writeOffType.equals("SALE_WRITEOFF") || this.ui.writeOffType.equals("INCOME_WRITEOFF")) {
                custParam.addCustomerParam("prmtSupplier", ((CustomerInfo)this.prmtSupplier.getValue()).getId().toString());
            } else {
                custParam.addCustomerParam("prmtSupplier", ((SupplierInfo)this.prmtSupplier.getValue()).getId().toString());
            }
        }
        if (this.prmtSupplierTo.getValue() != null) {
            if (this.ui.writeOffType.equals("SALE_WRITEOFF") || this.ui.writeOffType.equals("INCOME_WRITEOFF")) {
                custParam.addCustomerParam("prmtSupplierTo", ((CustomerInfo)this.prmtSupplierTo.getValue()).getId().toString());
            } else {
                custParam.addCustomerParam("prmtSupplierTo", ((SupplierInfo)this.prmtSupplierTo.getValue()).getId().toString());
            }
        }
        if (this.txtCurrWrittenOffQty.getDoubleValue() != null) {
            custParam.putDouble("txtCurrWrittenOffQty", this.txtCurrWrittenOffQty.getDoubleValue().doubleValue());
        }
        if (this.txtCurrWrittenOffQtyTo.getDoubleValue() != null) {
            custParam.putDouble("txtCurrWrittenOffQtyTo", this.txtCurrWrittenOffQtyTo.getDoubleValue().doubleValue());
        }
        if (this.txtCurrWrittenOffAmount.getDoubleValue() != null) {
            custParam.putDouble("txtCurrWrittenOffAmount", this.txtCurrWrittenOffAmount.getDoubleValue().doubleValue());
        }
        if (this.txtCurrWrittenOffAmountTo.getDoubleValue() != null) {
            custParam.putDouble("txtCurrWrittenOffAmountTo", this.txtCurrWrittenOffAmountTo.getDoubleValue().doubleValue());
        }
        if (this.txtWirttenOffQty.getDoubleValue() != null) {
            custParam.putDouble("txtWirttenOffQty", this.txtWirttenOffQty.getDoubleValue().doubleValue());
        }
        if (this.txtWirttenOffQtyTo.getDoubleValue() != null) {
            custParam.putDouble("txtWirttenOffQtyTo", this.txtWirttenOffQtyTo.getDoubleValue().doubleValue());
        }
        if (this.txtWrittenOffAmount.getDoubleValue() != null) {
            custParam.putDouble("txtWrittenOffAmount", this.txtWrittenOffAmount.getDoubleValue().doubleValue());
        }
        if (this.txtWrittenOffAmountTo.getDoubleValue() != null) {
            custParam.putDouble("txtWrittenOffAmountTo", this.txtWrittenOffAmountTo.getDoubleValue().doubleValue());
        }
        if (this.txtUnWirteOffQty.getDoubleValue() != null) {
            custParam.putDouble("txtUnWirteOffQty", this.txtUnWirteOffQty.getDoubleValue().doubleValue());
        }
        if (this.txtUnWirteOffQtyTo.getDoubleValue() != null) {
            custParam.putDouble("txtUnWirteOffQtyTo", this.txtUnWirteOffQtyTo.getDoubleValue().doubleValue());
        }
        if (this.txtUnWriteOffAmount.getDoubleValue() != null) {
            custParam.putDouble("txtUnWriteOffAmount", this.txtUnWriteOffAmount.getDoubleValue().doubleValue());
        }
        if (this.txtUnWriteOffAmountTo.getDoubleValue() != null) {
            custParam.putDouble("txtUnWriteOffAmountTo", this.txtUnWriteOffAmountTo.getDoubleValue().doubleValue());
        }
        return custParam;
    }

    public void setCustomerParams(CustomerParams cp) {
        IMaterial iMaterial = null;
        ISupplier iSupplier = null;
        ICustomer iCustomer = null;
        this.clear();
        if (cp != null) {
            if (cp.getCustomerParam("comBillTypeNumber") != null) {
                this.handleSourceBilltype(this.comBillTypeNumber, cp.getCustomerParam("comBillTypeNumber"));
            }
            if (!StringUtil.isEmpty((String)cp.getCustomerParam("txtBillNumber"))) {
                this.txtBillNumber.setText(cp.getCustomerParam("txtBillNumber"));
            }
            if (!StringUtil.isEmpty((String)cp.getCustomerParam("txtBillNumberTo"))) {
                this.txtBillNumberTo.setText(cp.getCustomerParam("txtBillNumberTo"));
            }
            if (!StringUtil.isEmpty((String)cp.getCustomerParam("txtBillNumber"))) {
                this.txtOrderBillNumber.setText(cp.getCustomerParam("txtOrderBillNumber"));
            }
            if (!StringUtil.isEmpty((String)cp.getCustomerParam("txtOrderBillNumberTo"))) {
                this.txtOrderBillNumberTo.setText(cp.getCustomerParam("txtOrderBillNumberTo"));
            }
            if (cp.getCustomerParam("pkBillDate") != null) {
                this.pkBillDate.setValue((Object)SCMUtils.getDayStartTime((Date)cp.getDate("pkBillDate")));
            }
            if (cp.getCustomerParam("pkBillDateTo") != null) {
                this.pkBillDateTo.setValue((Object)SCMUtils.getDayStartTime((Date)cp.getDate("pkBillDateTo")));
            }
            try {
                if (!StringUtil.isEmpty((String)cp.getCustomerParam("prmtMaterial"))) {
                    if (iMaterial == null) {
                        iMaterial = MaterialFactory.getRemoteInstance();
                    }
                    this.setFilterObject(this.prmtMaterial, (IDataBaseD)iMaterial, cp.getCustomerParam("prmtMaterial"));
                }
                if (!StringUtil.isEmpty((String)cp.getCustomerParam("prmtMaterialTo"))) {
                    if (iMaterial == null) {
                        iMaterial = MaterialFactory.getRemoteInstance();
                    }
                    this.setFilterObject(this.prmtMaterialTo, (IDataBaseD)iMaterial, cp.getCustomerParam("prmtMaterialTo"));
                }
                if (!StringUtil.isEmpty((String)cp.getCustomerParam("ckBxWriteOff"))) {
                    this.ckBxWriteOff.setSelected(cp.getBoolean("ckBxWriteOff"));
                } else {
                    this.ckBxWriteOff.setSelected(false);
                }
                if ((this.writeOffType.equals("SALE_WRITEOFF") || this.writeOffType.equals("INCOME_WRITEOFF")) && !StringUtil.isEmpty((String)cp.getCustomerParam("ckBxMShortName"))) {
                    this.ckBxMShortName.setSelected(cp.getBoolean("ckBxMShortName"));
                    if (this.ckBxMShortName.isSelected()) {
                        if (!StringUtil.isEmpty((String)cp.getCustomerParam("txtMShortNameFrom"))) {
                            this.txtMShortNameFrom.setText(cp.getCustomerParam("txtMShortNameFrom"));
                        }
                        if (!StringUtil.isEmpty((String)cp.getCustomerParam("txtMShortNameTo"))) {
                            this.txtMShortNameTo.setText(cp.getCustomerParam("txtMShortNameTo"));
                        }
                    } else {
                        this.txtMShortNameFrom.setText(null);
                        this.txtMShortNameTo.setText(null);
                        this.txtMShortNameFrom.setEditable(false);
                        this.txtMShortNameTo.setEditable(false);
                    }
                }
                if (!StringUtil.isEmpty((String)cp.getCustomerParam("prmtSupplier"))) {
                    if (this.ui.writeOffType.equals("SALE_WRITEOFF") || this.ui.writeOffType.equals("INCOME_WRITEOFF")) {
                        if (iCustomer == null) {
                            iCustomer = CustomerFactory.getRemoteInstance();
                        }
                        this.setFilterObject(this.prmtSupplier, (IDataBaseD)iCustomer, cp.getCustomerParam("prmtSupplier"));
                    } else {
                        if (iSupplier == null) {
                            iSupplier = SupplierFactory.getRemoteInstance();
                        }
                        this.setFilterObject(this.prmtSupplier, (IDataBaseD)iSupplier, cp.getCustomerParam("prmtSupplier"));
                    }
                }
                if (!StringUtil.isEmpty((String)cp.getCustomerParam("prmtSupplierTo"))) {
                    if (this.ui.writeOffType.equals("SALE_WRITEOFF") || this.ui.writeOffType.equals("INCOME_WRITEOFF")) {
                        if (iCustomer == null) {
                            iCustomer = CustomerFactory.getRemoteInstance();
                        }
                        this.setFilterObject(this.prmtSupplierTo, (IDataBaseD)iCustomer, cp.getCustomerParam("prmtSupplierTo"));
                    } else {
                        if (iSupplier == null) {
                            iSupplier = SupplierFactory.getRemoteInstance();
                        }
                        this.setFilterObject(this.prmtSupplierTo, (IDataBaseD)iSupplier, cp.getCustomerParam("prmtSupplierTo"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cp.getCustomerParam("txtCurrWrittenOffQty") != null) {
                this.txtCurrWrittenOffQty.setValue((Object)new Double(cp.getDouble("txtCurrWrittenOffQty")));
            }
            if (cp.getCustomerParam("txtCurrWrittenOffQtyTo") != null) {
                this.txtCurrWrittenOffQtyTo.setValue((Object)new Double(cp.getDouble("txtCurrWrittenOffQtyTo")));
            }
            if (cp.getCustomerParam("txtCurrWrittenOffAmount") != null) {
                this.txtCurrWrittenOffAmount.setValue((Object)new Double(cp.getDouble("txtCurrWrittenOffAmount")));
            }
            if (cp.getCustomerParam("txtCurrWrittenOffAmountTo") != null) {
                this.txtCurrWrittenOffAmountTo.setValue((Object)new Double(cp.getDouble("txtCurrWrittenOffAmountTo")));
            }
            if (cp.getCustomerParam("txtWirttenOffQty") != null) {
                this.txtWirttenOffQty.setValue((Object)new Double(cp.getDouble("txtWirttenOffQty")));
            }
            if (cp.getCustomerParam("txtWirttenOffQtyTo") != null) {
                this.txtWirttenOffQtyTo.setValue((Object)new Double(cp.getDouble("txtWirttenOffQtyTo")));
            }
            if (cp.getCustomerParam("txtWrittenOffAmount") != null) {
                this.txtWrittenOffAmount.setValue((Object)new Double(cp.getDouble("txtWrittenOffAmount")));
            }
            if (cp.getCustomerParam("txtWrittenOffAmountTo") != null) {
                this.txtWrittenOffAmountTo.setValue((Object)new Double(cp.getDouble("txtWrittenOffAmountTo")));
            }
            if (cp.getCustomerParam("txtUnWirteOffQty") != null) {
                this.txtUnWirteOffQty.setValue((Object)new Double(cp.getDouble("txtUnWirteOffQty")));
            }
            if (cp.getCustomerParam("txtUnWirteOffQtyTo") != null) {
                this.txtUnWirteOffQtyTo.setValue((Object)new Double(cp.getDouble("txtUnWirteOffQtyTo")));
            }
            if (cp.getCustomerParam("txtUnWriteOffAmount") != null) {
                this.txtUnWriteOffAmount.setValue((Object)new Double(cp.getDouble("txtUnWriteOffAmount")));
            }
            if (cp.getCustomerParam("txtUnWriteOffAmountTo") != null) {
                this.txtUnWriteOffAmountTo.setValue((Object)new Double(cp.getDouble("txtUnWriteOffAmountTo")));
            }
        } else {
            this.ckBxWriteOff.setSelected(false);
        }
    }

    private void handleSourceBilltype(KDComboBox comBox, String billTypeNo) {
        if (billTypeNo != null) {
            if ("-1".equals(billTypeNo)) {
                comBox.setSelectedItem((Object)WriteOffBillTypeEnum.NULL);
            } else if ("103".equals(billTypeNo)) {
                comBox.setSelectedItem((Object)WriteOffBillTypeEnum.PURINWAREHS);
            } else if ("230".equals(billTypeNo)) {
                comBox.setSelectedItem((Object)WriteOffBillTypeEnum.APOTHERBILL);
            } else if ("410".equals(billTypeNo)) {
                comBox.setSelectedItem((Object)WriteOffBillTypeEnum.COSTADJUST);
            } else if ("330".equals(billTypeNo)) {
                comBox.setSelectedItem((Object)WriteOffBillTypeEnum.AROTHERBILL);
            } else if ("102".equals(billTypeNo)) {
                comBox.setSelectedItem((Object)WriteOffBillTypeEnum.SALEISSUE);
            }
        }
    }

    private void setFilterObject(KDBizPromptBox prmtCompnent, IDataBaseD dataBase, String id) {
        try {
            if (dataBase != null) {
                prmtCompnent.setValue((Object)dataBase.getValue((IObjectPK)new ObjectUuidPK(id)));
            }
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            CompanyOrgUnitInfo cou = SysContext.getSysContext().getCurrentFIUnit();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            request.setUserPK((IObjectPK)new ObjectUuidPK(user.getId()));
            request.put("_SCMMAINORGTYPE", (Object)OrgType.Company);
            request.put("INV_MAIN_COU", (Object)cou);
            request.put("_SCMPERMISSIONITEM", (Object)this.getViewPermission());
            request.setMainOrgType(OrgType.Company);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public RequestContext prepareSetFilterInfo(FilterInfo filterInfo) {
        return super.prepareSetFilterInfo(filterInfo);
    }

    public RequestContext prepareVerify() {
        super.prepareVerify();
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.cal.app.WriteOffReportFilterUIHandler");
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            request.setUserPK((IObjectPK)new ObjectUuidPK(user.getId()));
            request.put("_SCMPERMISSIONITEM", (Object)this.getViewPermission());
            request.put("_COMPANYID", (Object)((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString());
            request.put("_SCMMAINORGTYPE", (Object)OrgType.Company);
            FilterInfo filter = this.getSubFilterInfo();
            EntityViewInfo entityVInfo = this.getEntityFilter(filter);
            request.put("_SCM_FilterInfo", (Object)filter);
            request.put("_SCM_EntrtyFilterInfo", (Object)entityVInfo);
            if (this.ui != null) {
                request.setSelectNodeId(this.ui.getSelectedKeyForAll());
            }
        }
        return request;
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(true);
            this.txtMShortNameTo.setEditable(true);
        } else {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setEditable(false);
        }
    }
}

