/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.BizCLOSEACCOUNTException;
import com.kingdee.eas.scm.cal.invdep.DepChargeEntryInfo;
import com.kingdee.eas.scm.cal.invdep.DepChargeException;
import com.kingdee.eas.scm.cal.invdep.DepChargeFactory;
import com.kingdee.eas.scm.cal.invdep.DepChargeHelper;
import com.kingdee.eas.scm.cal.invdep.DepChargeInfo;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryEntryCollection;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryEntryFactory;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryInfo;
import com.kingdee.eas.scm.cal.invdep.client.AbstractDepChargeEditUI;
import com.kingdee.eas.scm.cal.invdep.client.DepChargeField;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.scm.common.util.SCMCommonDataProvider;
import com.kingdee.eas.scm.common.util.SCMSlaveCommonDataProvider;
import com.kingdee.eas.scm.framework.client.SCMPasteHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DepChargeEditUI
extends AbstractDepChargeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DepChargeEditUI.class);
    private DepChargeField field = null;
    private static final String resClassName = "com.kingdee.eas.scm.cal.invdep.InvdepResource";
    private static final String depChargeRes = "com.kingdee.eas.scm.cal.invdep.DepChargeResource";
    private PeriodInfo curPeriodInfo = null;
    protected CompanyOrgUnitInfo currentCompany;
    protected UserInfo userInfo = null;
    private boolean isChargeByMaterial = false;
    private PeriodInfo currentPeriod;
    protected DataChangeListener prmtEntryMaterialListener = null;
    protected DataChangeListener prmtCompanyListener;
    protected DataChangeListener prmtMaterialCategoryListener;
    public static final String DEPCHARGE_BILLTYPEID = "BNBrqgEeEADgAAAKfwAAAb1GBGM=";
    private SCMPasteHelper pasteHelper;
    protected ArrayList<MaterialInfo> materialInfoList;
    protected ArrayList<Integer> rowList;
    protected KDBizPromptBox bizMaterialBox;

    public void onLoad() throws Exception {
        try {
            if (this.getDefaultMainBizOrg() instanceof CompanyOrgUnitInfo) {
                this.currentCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.onLoad();
        this.prmtCompany.setEnabled(true);
        this.prmtCompany.setRequired(true);
        this.actionCopy.setVisible(false);
        this.txtNumber.setRequired(true);
        this.initPasteHelper();
    }

    private void setMaterialCategoryF7() {
        FilterInfo filter = new FilterInfo();
        if (this.currentCompany != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        }
        EntityViewInfo evi = this.prmtMaterialCategoryNum.getEntityViewInfo() == null ? new EntityViewInfo() : this.prmtMaterialCategoryNum.getEntityViewInfo();
        evi.setFilter(filter);
        this.prmtMaterialCategoryNum.setEntityViewInfo(evi);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.*"));
        return sic;
    }

    private void setColMaterial() throws EASBizException, BOSException {
        OrgUnitInfo orgInfo = null;
        this.bizMaterialBox = new KDBizPromptBox();
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        if (this.getMainOrgContext() != null) {
            orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType());
        }
        this.f7Manager.registerBizMaterialF7(bizMaterialBox, this.kdtEntrys.getColumn("materialNum"), null, orgInfo, true);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{bizMaterialBox});
        if (bizMaterialBox.getEntityViewInfo() != null) {
            EntityViewInfo view = bizMaterialBox.getEntityViewInfo();
            if (this.currentCompany != null) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.currentCompany.getId()));
            }
            view.getFilter().getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(2), CompareType.NOTEQUALS));
        }
        this.prmtEntryMaterialListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DepChargeEditUI.this.entryMaterialDataChanged(e);
                }
                catch (Exception ex) {
                    DepChargeEditUI.this.handUIException(ex);
                }
            }
        };
        bizMaterialBox.addDataChangeListener(this.prmtEntryMaterialListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entryMaterialDataChanged(DataChangeEvent e) {
        if (this.kdtEntrys.getSelectManager() == null || this.kdtEntrys.getSelectManager().get() == null) {
            return;
        }
        if (this.pasteHelper.isPasteing()) {
            Object[] objArray = (Object[])e.getNewValue();
            if (objArray != null && objArray[0] != null) {
                this.materialInfoList.add((MaterialInfo)objArray[0]);
            } else {
                this.rowList.add(this.pasteHelper.getPasteRow());
            }
            return;
        }
        try {
            this.bizMaterialBox.removeDataChangeListener(this.prmtEntryMaterialListener);
            this.isNeedAppendFootRow = false;
            int rowIdx = this.kdtEntrys.getSelectManager().get().getBeginRow();
            if (e.getNewValue() != null && e.getNewValue().getClass().isArray()) {
                Object[] objArray = (Object[])e.getNewValue();
                if (objArray.length > 0) {
                    MaterialInfo[] materialInfos = null;
                    if (objArray instanceof MaterialInfo[]) {
                        materialInfos = (MaterialInfo[])objArray;
                    }
                    if (objArray instanceof Object[]) {
                        materialInfos = new MaterialInfo[objArray.length];
                        int length = objArray.length;
                        for (int i = 0; i < length; ++i) {
                            if (!(objArray[i] instanceof MaterialInfo)) continue;
                            MaterialInfo materialInfo = (MaterialInfo)objArray[i];
                            for (int j = 0; j < this.kdtEntrys.getRowCount(); ++j) {
                                Object obj = this.kdtEntrys.getRow(j).getCell("materialNum").getValue();
                                if (!(obj instanceof MaterialInfo)) continue;
                                MaterialInfo aMaterial = (MaterialInfo)obj;
                                if (j == rowIdx || !aMaterial.getId().toString().equals(materialInfo.getId().toString())) continue;
                                KDTDefaultCellEditor editor = (KDTDefaultCellEditor)this.kdtEntrys.getColumn("materialNum").getEditor();
                                if (editor.getComponent() instanceof KDBizPromptBox) {
                                    KDBizPromptBox box = (KDBizPromptBox)editor.getComponent();
                                    box.setValue(null);
                                }
                                this.kdtEntrys.getRow(rowIdx).getCell("materialNum").setValue(null);
                                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)depChargeRes, (String)"dupMaterial"));
                                SysUtil.abort();
                            }
                        }
                        for (int seq = 0; seq < objArray.length; ++seq) {
                            if (!(objArray[seq] instanceof MaterialInfo)) continue;
                            materialInfos[seq] = (MaterialInfo)objArray[seq];
                        }
                    }
                    this.field.setEntryMeasureUnit((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), rowIdx, materialInfos);
                    if (this.isChargeByMaterial) {
                        try {
                            this.field.setUnNetRealizableRow(rowIdx, materialInfos);
                            this.field.setLastDepChargedRow(rowIdx, materialInfos);
                            this.field.caculateNetRealizableByMaterial(rowIdx, materialInfos);
                        }
                        catch (Exception ev) {
                            logger.error((Object)ev.getMessage());
                        }
                    }
                }
            } else if (e.getNewValue() == null && e.getOldValue() != null) {
                this.field.clearRow(rowIdx);
            }
            DepChargeHelper.setEntrySeq(this.kdtEntrys);
        }
        finally {
            this.bizMaterialBox.addDataChangeListener(this.prmtEntryMaterialListener);
            this.isNeedAppendFootRow = true;
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"FinanceOrgNotNull"));
        } else {
            this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
            if (this.curPeriodInfo != null && this.curPeriodInfo.getEndDate() != null) {
                this.pkBizDate.setValue((Object)new Date(this.curPeriodInfo.getEndDate().getTime()));
                this.editData.setBizDate(new Date(this.curPeriodInfo.getEndDate().getTime()));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"FinanceOrgUnit") + company.getName() + EASResource.getString((String)resClassName, (String)"PeriodNull")));
            }
        }
    }

    private void initUIProperties() {
        this.txtDescription.setMaxLength(255);
        int precision = 2;
        if (this.currentCompany.getBaseCurrency() != null) {
            precision = this.getCurrencyPrecision(this.currentCompany.getBaseCurrency().getId());
        }
        this.field.initDepChargeAmtColumn(precision);
        this.field.initDepChargeRatioColumn();
        this.field.initDepChargeMeasureUnitColumn();
    }

    private int getCurrencyPrecision(BOSUuid id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return info.getPrecision();
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        if (this.editData != null && this.editData.getCompany() != null) {
            this.currentCompany = this.editData.getCompany();
        }
        this.field = new DepChargeField(this.getDetailTable(), this.currentCompany);
        try {
            if (this.currentCompany == null) {
                throw new DepChargeException(DepChargeException.BLANK, new String[]{EASResource.getString((String)depChargeRes, (String)"NoFiPerm")});
            }
            this.initUIProperties();
            this.setColMaterial();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        try {
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                this.checkSysClose();
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (this.currentPeriod == null) {
            MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"FinanceOrgUnit") + this.currentCompany.getName() + EASResource.getString((String)resClassName, (String)"PeriodNull")));
        }
        super.loadFields();
        this.field.formatDepChargeAmtColumn();
        this.isChargeByMaterial = this.editData.getCompany() != null ? DepChargeHelper.isChargeByMaterial(this.editData.getCompany().getId().toString()) : DepChargeHelper.isChargeByMaterial(this.currentCompany.getId().toString());
        if (this.isChargeByMaterial) {
            this.prmtMaterialCategoryNum.setEnabled(false);
            this.field.setMaterialColsLock(false);
        } else {
            this.prmtMaterialCategoryNum.setEnabled(true);
            this.setMaterialCategoryF7();
            this.field.setMaterialColsLock(true);
        }
        if (this.editData.getMaterialCategory() != null) {
            this.prmtMaterialCategoryName.setValue((Object)this.editData.getMaterialCategory());
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.prmtMaterialCategoryNum.setAccessAuthority(0);
            this.prmtMaterialCategoryNum.setEnabled(false);
        }
        if (this.editData.isFivouchered()) {
            this.field.setChargeEditColsLock(true);
        }
        this.field.setTableColumnRequired();
        if (!this.isChargeByMaterial) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
        }
        this.actionUnAudit.setEnabled(BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus()));
        this.lazyAddListeners();
    }

    private void lazyAddListeners() {
        this.prmtCompanyListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DepChargeEditUI.this.prmtCompanyOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    DepChargeEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
        this.prmtMaterialCategoryListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DepChargeEditUI.this.prmtMaterialCategoryNum_dataChanged(e);
                }
                catch (Exception exc) {
                    DepChargeEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtMaterialCategoryNum.addDataChangeListener(this.prmtMaterialCategoryListener);
    }

    private void removeListeners() {
        this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
        this.prmtMaterialCategoryNum.removeDataChangeListener(this.prmtMaterialCategoryListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void prmtCompanyOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!(this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo)) {
            this.prmtCompany.requestFocus(true);
            if (this.prmtCompany.getValue() != null) return;
            throw new DepChargeException(DepChargeException.BLANK, new String[]{EASResource.getString((String)depChargeRes, (String)"checkPermFiOrg")});
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (this.currentPeriod != null && this.currentPeriod.getEndDate() != null) {
            this.pkBizDate.setValue((Object)new Date(this.currentPeriod.getEndDate().getTime()));
            this.editData.setBizDate(new Date(this.currentPeriod.getEndDate().getTime()));
            this.currentCompany = company;
            this.editData.setCompany(company);
            this.field.refreshCompany(company);
            this.isChargeByMaterial = DepChargeHelper.isChargeByMaterial(company.getId().toString());
            if (this.isChargeByMaterial) {
                this.prmtMaterialCategoryNum.setEnabled(false);
                this.field.setMaterialColsLock(false);
                this.actionAddLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
            } else {
                this.prmtMaterialCategoryNum.setEnabled(true);
                this.setMaterialCategoryF7();
                this.field.setMaterialColsLock(true);
                this.actionAddLine.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
            }
            this.kdtEntrys.removeRows();
            this.cleanEntry();
            this.prmtMaterialCategoryNum.setValue(null);
            this.prmtMaterialCategoryName.setValue(null);
            this.txtNumber.setText(null);
            this.setMaterialCategoryF7();
            if (company.getBaseCurrency() != null) {
                this.field.initDepChargeAmtColumn(this.getCurrencyPrecision(company.getBaseCurrency().getId()));
            }
            this.kdtEntrys.addRow();
            return;
        }
        this.prmtCompany.setValue(e.getOldValue());
        Object[] objectArray = new String[1];
        objectArray[0] = EASResource.getString((String)depChargeRes, (String)"curFiPeriodIsNull");
        throw new DepChargeException(DepChargeException.BLANK, objectArray);
    }

    private void checkSysClose() throws BizCLOSEACCOUNTException, EASBizException, BOSException {
        if (!SystemStatusCtrolUtils.isClose(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany)) {
            Object[] objectArray = new String[1];
            objectArray[0] = EASResource.getString((String)depChargeRes, (String)"sysCloseNoDepCharge");
            throw new DepChargeException(DepChargeException.BLANK, objectArray);
        }
    }

    protected void initNeedMainOrgF7s() {
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompany;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getEntryMaterialFieldName() {
        return "materialNum";
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, MaterialInfo> hm = new HashMap<String, MaterialInfo>();
        KDTSelectBlock selectBlock = this.kdtEntrys.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntrys.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell("materialNum");
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
        }
        return hm;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DepChargeFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        if (this.editData.getEntrys() != null && this.editData.getEntrys().size() > 0) {
            for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
                if (this.editData.getEntrys().get(i).getMaterial() != null) continue;
                this.editData.getEntrys().removeObject(i);
                --i;
            }
        }
        super.storeFields();
        this.editData.setSyncOldValue(true);
        if (this.currentPeriod != null) {
            this.editData.setPeriod(this.currentPeriod.getPeriodNumber());
            this.editData.setYear(this.currentPeriod.getPeriodYear());
        }
        this.editData.setSyncOldValue(false);
        if (BillBaseStatusEnum.SUBMITED.equals((Object)this.editData.getBaseStatus())) {
            this.initOldData((IObjectValue)this.editData);
        }
    }

    private void clearEntrys() {
        if (this.editData.getEntrys() != null && this.editData.getEntrys().size() > 0) {
            for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
                this.editData.getEntrys().removeObject(i);
                --i;
            }
        }
    }

    protected void prmtMaterialCategoryNum_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() instanceof MaterialCategoryInfo) {
            this.kdtEntrys.removeRows();
            this.clearEntrys();
            MaterialCategoryInfo mCategroyInfo = (MaterialCategoryInfo)e.getNewValue();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("head.id", (Object)mCategroyInfo.getId()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            MaterialCategoryEntryCollection mCateEntrys = MaterialCategoryEntryFactory.getRemoteInstance().getMaterialCategoryEntryCollection(evi);
            if (mCateEntrys != null && mCateEntrys.size() > 0) {
                HashSet<BOSUuid> materialIdSet = new HashSet<BOSUuid>();
                int size = mCateEntrys.size();
                for (int i = 0; i < size; ++i) {
                    if (mCateEntrys.get(i).getMaterial() == null) continue;
                    materialIdSet.add(mCateEntrys.get(i).getMaterial().getId());
                }
                FilterInfo materialFilter = new FilterInfo();
                materialFilter.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
                EntityViewInfo materialEvi = new EntityViewInfo();
                materialEvi.setFilter(materialFilter);
                MaterialCollection materialCol = MaterialFactory.getRemoteInstance().getMaterialCollection(materialEvi);
                int beginRow = 0;
                MaterialInfo[] materialArray = new MaterialInfo[materialCol.size()];
                int materialSize = materialArray.length;
                for (int materialIndex = 0; materialIndex < materialSize; ++materialIndex) {
                    materialArray[materialIndex] = materialCol.get(materialIndex);
                }
                this.field.setEntryMeasureUnit((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), beginRow, materialArray);
                this.field.setEntryRatio(mCategroyInfo, beginRow, materialCol.size());
                this.field.computeEntryRatioAmt(beginRow, materialCol.size());
                this.field.removeMaterialCostZero();
            }
            this.prmtMaterialCategoryName.setValue(e.getNewValue());
        }
        DepChargeHelper.setEntrySeq(this.kdtEntrys);
    }

    protected IObjectValue createNewData() {
        DepChargeInfo info = new DepChargeInfo();
        info.setCreator(this.userInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.getEntrys().add((DepChargeEntryInfo)this.createNewDetailData(null));
        try {
            BillTypeInfo billTypeInfo = BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)new ObjectUuidPK(DEPCHARGE_BILLTYPEID));
            info.setBillType(billTypeInfo);
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        try {
            if (this.getDefaultMainBizOrg() instanceof CompanyOrgUnitInfo) {
                info.setCompany((CompanyOrgUnitInfo)this.getDefaultMainBizOrg());
            }
            if (this.curPeriodInfo == null) {
                this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            }
            if (this.curPeriodInfo != null && this.curPeriodInfo.getEndDate() != null) {
                info.setBizDate(new Date(this.curPeriodInfo.getEndDate().getTime()));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"FinanceOrgUnit") + (info.getCompany() == null ? " " : info.getCompany().getName()) + EASResource.getString((String)resClassName, (String)"PeriodNull")));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        DepChargeEntryInfo entryInfo = new DepChargeEntryInfo();
        entryInfo.setSeq(1);
        return entryInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected void afterInsertMaterialInfo(int rowIndex) throws Exception {
    }

    protected void afterInsertMaterials(int rowIdx, MaterialInfo[] materialInfos, Map dataMap) throws Exception {
        super.afterInsertMaterials(rowIdx, materialInfos, dataMap);
    }

    protected void addLine(KDTable table) {
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        row = table.addRow();
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
        DepChargeHelper.setEntrySeq(table);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = DepChargeHelper.isTableColumnSelected(table) ? DepChargeHelper.addRow(table) : table.addRow(top);
        } else {
            row = DepChargeHelper.addRow(table);
        }
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
        DepChargeHelper.setEntrySeq(table);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        DepChargeHelper.setEntrySeq(this.kdtEntrys);
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        this.field.computeDepChargeEntry(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        DepChargeHelper.verifyEmpty((CoreUIObject)this, this.prmtCompany);
        super.actionRemove_actionPerformed(e);
    }

    protected void verifySubmitInput(ActionEvent e) throws DepChargeException {
        DepChargeHelper.verifyEmpty((CoreUIObject)this, this.prmtCompany);
        this.field.submitEntryCheck();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifySubmitInput(e);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.actionUnAudit.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.isChargeByMaterial = DepChargeHelper.isChargeByMaterial(this.editData.getCompany().getId().toString());
        if (this.isChargeByMaterial) {
            this.prmtMaterialCategoryNum.setEnabled(false);
            this.field.setMaterialColsLock(false);
        } else {
            this.prmtMaterialCategoryNum.setEnabled(true);
            this.setMaterialCategoryF7();
            this.field.setMaterialColsLock(true);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().getValue() == 0 || this.editData.getBaseStatus().getValue() == 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"BillNotPrint"));
            return;
        }
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().getValue() == 0 || this.editData.getBaseStatus().getValue() == 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"BillNotPrintPreView"));
            return;
        }
        this.invokePrintFunction(false);
    }

    protected void invokePrintFunction(boolean isPrint) {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        this.setCustomerDataProvider(data, idList);
        SCMCommonDataProvider mainQueryData = new SCMCommonDataProvider(idList, this.getTDQueryPK());
        mainQueryData.setFilter(this.getPrintFilter(idList));
        SCMSlaveCommonDataProvider multiApproveViewQueryData = new SCMSlaveCommonDataProvider(idList, this.getMultiApproveViewQuery(), "billId");
        data.put("MainQuery", (BOSQueryDelegate)mainQueryData);
        data.put("MultiApproveViewQuery", (BOSQueryDelegate)multiApproveViewQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.addKDNoteActionListener(new IPrintActionListener(){

            public void beforePrintOrPreview() {
            }

            public void beforePreview() {
            }

            public void beforePrint() {
                String operName = SCMClientUtils.getResource((String)"LOG_PRINT");
                IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)DepChargeEditUI.this.editData.getBOSType(), null, (String)operName);
                LogUtil.afterLog(null, (IObjectPK)pk);
            }

            public void closePreview() {
            }
        });
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected void setCustomerDataProvider(MultiDataSourceDataProviderProxy data, List idList) {
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.cal.invdep.app.DepChargePrintQuery");
    }

    protected String getTDFileName() {
        return "/FI/CAL/DepCharge";
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "depCharge_AddNew";
        }
        return null;
    }

    protected void setTableToSumField() {
        super.setTableToSumField();
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        return new String[]{"invAmount@%R_{0.##########}f", "entrys.amtReverse@%R_{0.##########}f", "entrys.qtyReverse@%R_{0.##########}f", "depCharged@%R_{0.##########}f", "curDepCharge@%R_{0.##########}f", "depToCharge@%R_{0.##########}f", "netRealizable@%R_{0.##########}f", "invQty@%R_{0.##########}f"};
    }

    private void initPasteHelper() {
        this.materialInfoList = new ArrayList();
        this.rowList = new ArrayList();
        this.pasteHelper = new SCMPasteHelper(this.getDetailTable()){

            public void insertRow(int row) {
                DepChargeEditUI.this.insertLine(row);
            }

            protected void pasteAfterProcess() {
                if (DepChargeEditUI.this.materialInfoList.size() > 0) {
                    int i;
                    int rowIdx = DepChargeEditUI.this.pasteHelper.getFirstPasteRow();
                    MaterialInfo[] materialInfos = new MaterialInfo[DepChargeEditUI.this.materialInfoList.size()];
                    materialInfos = DepChargeEditUI.this.materialInfoList.toArray(materialInfos);
                    DepChargeEditUI.this.field.setEntryMeasureUnit((IObjectPK)new ObjectUuidPK(DepChargeEditUI.this.currentCompany.getId()), rowIdx, materialInfos);
                    if (DepChargeEditUI.this.isChargeByMaterial) {
                        try {
                            DepChargeEditUI.this.field.setUnNetRealizableRow(rowIdx, materialInfos);
                            DepChargeEditUI.this.field.setLastDepChargedRow(rowIdx, materialInfos);
                            DepChargeEditUI.this.field.caculateNetRealizableByMaterial(rowIdx, materialInfos);
                        }
                        catch (Exception ev) {
                            logger.error((Object)ev.getMessage());
                        }
                    }
                    DepChargeHelper.setEntrySeq(DepChargeEditUI.this.kdtEntrys);
                    HashSet<String> set = new HashSet<String>();
                    Object materialNum = null;
                    boolean isRepeat = false;
                    String dupMaterialMsg = EASResource.getString((String)DepChargeEditUI.depChargeRes, (String)"dupMaterial");
                    String entryMsg = EASResource.getString((String)DepChargeEditUI.resClassName, (String)"Entry");
                    StringBuffer detailMsg = new StringBuffer();
                    int size = DepChargeEditUI.this.kdtEntrys.getRowCount();
                    for (i = 0; i < size; ++i) {
                        materialNum = DepChargeEditUI.this.kdtEntrys.getRow(i).getCell("materialNum").getValue();
                        if (materialNum != null && set.add(materialNum.toString())) continue;
                        detailMsg.append(entryMsg).append(i + 1).append(dupMaterialMsg).append("\n");
                        DepChargeEditUI.this.kdtEntrys.getRow(i).getCell("materialNum").setValue(null);
                        DepChargeEditUI.this.field.clearRow(i);
                        isRepeat = true;
                    }
                    if (DepChargeEditUI.this.rowList.size() > 0) {
                        int j = DepChargeEditUI.this.materialInfoList.size();
                        for (i = DepChargeEditUI.this.kdtEntrys.getRowCount(); i >= j; --i) {
                            DepChargeEditUI.this.kdtEntrys.removeRow(i);
                        }
                        size = DepChargeEditUI.this.rowList.size();
                        for (i = 0; i < size; ++i) {
                            DepChargeEditUI.this.insertLine(DepChargeEditUI.this.rowList.get(i));
                        }
                    }
                    DepChargeEditUI.this.materialInfoList.clear();
                    DepChargeEditUI.this.rowList.clear();
                    if (isRepeat) {
                        MsgBox.showConfirm3a((String)EASResource.getString((String)DepChargeEditUI.depChargeRes, (String)"dupMaterialMsg"), (String)detailMsg.toString());
                    }
                }
                DepChargeEditUI.this.addPropertyListener();
            }

            public void pastePreProcess(int row, int col) {
                DepChargeEditUI.this.removePropertyListener();
                super.pastePreProcess(row, col);
            }
        };
    }

    protected void appendFootRow(KDTable table, String columnKey) {
        if (this.pasteHelper.isPasteing() || !this.isNeedAppendFootRow) {
            return;
        }
        super.appendFootRow(table, columnKey);
    }

    protected void insertLine(int rowIndex) {
        KDTable table = this.getDetailTable();
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow(rowIndex);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
        DepChargeHelper.setEntrySeq(table);
    }
}

