/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.invdep.client.AbstractDepChargeReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class DepChargeReportFilterUI
extends AbstractDepChargeReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DepChargeReportFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.cal.invdep.InvdepResource";
    private static SCMRptMultiOrgsF7 f7;
    private RptParams rps = new RptParams();

    public RptParams getRps() {
        return this.rps;
    }

    public DepChargeReportFilterUI() throws Exception {
        this.isReport = true;
        f7 = new SCMRptMultiOrgsF7(this.prmtFinanceOrgUnits, OrgType.Company, EASResource.getString((String)resClassName, (String)"companyOrgUnitMutilF7"));
        f7.setPermItemName(this.getViewPermission());
        f7.setUseCache(true);
        f7.setNeedWait4UIOpen(false);
        this.onInit();
        this.prmtMaterialCodeFrom.setCommitParser(null);
        this.prmtMaterialCodeTo.setCommitParser(null);
        this.setBizMaterialF7(this.prmtMaterialCodeFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialCodeTo, false, null);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("FullFinanceOrgUnits", f7, this.prmtFinanceOrgUnits);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"FinanceOrgNotNull")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "FullFinanceOrgUnits");
        SingleFilterElement element = new SingleFilterElement("MaterialFrom", (Component)this.prmtMaterialCodeFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("MaterialTo", (Component)this.prmtMaterialCodeTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("MaterialCtgFrom", (Component)this.prmtMaterialCtgFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("MaterialCtgTo", (Component)this.prmtMaterialCtgTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("YearFrom", (Component)this.spYearFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        element.setDefaultValue(this.spYearFrom.getValue());
        elements.add((FilterElement)element);
        element = new SingleFilterElement("YearTo", (Component)this.spYearTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        element.setDefaultValue(this.spYearTo.getValue());
        elements.add((FilterElement)element);
        element = new SingleFilterElement("PeriodFrom", (Component)this.spMonthFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        element.setDefaultValue(this.spMonthFrom.getValue());
        elements.add((FilterElement)element);
        element = new SingleFilterElement("PeriodTo", (Component)this.spMonthTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        element.setDefaultValue(this.spMonthTo.getValue());
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialCodeFrom, this.prmtMaterialCodeTo});
    }

    public void afterMainOrgChanged(String ids) {
        EntityViewInfo entiryView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)ids, CompareType.INCLUDE));
        entiryView.setFilter(filterInfo);
        this.prmtMaterialCtgFrom.setEntityViewInfo(entiryView);
        this.prmtMaterialCtgTo.setEntityViewInfo(entiryView);
    }

    protected String getViewPermission() {
        return "depChargeRpt_view";
    }

    private void initF7Control() {
        try {
            this.prmtFinanceOrgUnits.setDisplayFormat("$number$");
            this.prmtFinanceOrgUnits.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private void setMaterialCategoryF7() {
    }

    private void setMaterialCodeF7() {
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtFinanceOrgUnits;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void onInit() throws Exception {
        Date date = new Date();
        if (date.getMonth() == 0) {
            this.spYearFrom.setValue((Object)new Integer(date.getYear() + 1899));
            this.spMonthFrom.setValue((Object)new Integer(12));
        } else {
            this.spYearFrom.setValue((Object)new Integer(date.getYear() + 1900));
            this.spMonthFrom.setValue((Object)new Integer(date.getMonth()));
        }
        this.spYearTo.setValue((Object)new Integer(date.getYear() + 1900));
        this.spMonthTo.setValue((Object)new Integer(date.getMonth() + 1));
    }

    private String[] getAllSelectedOrg(String financeOrgs) {
        if (!"".equals(financeOrgs)) {
            String[] strs = financeOrgs.split(";");
            return strs;
        }
        return null;
    }

    private String getAllSelectedOrg(String[] strs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.length - 1; ++i) {
            sb.append(strs[i]).append(";");
        }
        sb.append(strs[strs.length - 1]);
        return sb.toString();
    }

    public void setCustomCondition(RptParams params) {
        this.spYearFrom.setValue(params.getObject("YearFrom"));
        this.spYearTo.setValue(params.getObject("YearTo"));
        this.spMonthFrom.setValue(params.getObject("PeriodFrom"));
        this.spMonthTo.setValue(params.getObject("PeriodTo"));
        this.prmtMaterialCtgFrom.setValue(params.getObject("MaterialCtgFrom"));
        this.prmtMaterialCtgTo.setValue(params.getObject("MaterialCtgTo"));
        this.prmtMaterialCodeFrom.setValue(params.getObject("MaterialFrom"));
        this.prmtMaterialCodeTo.setValue(params.getObject("MaterialTo"));
    }

    public boolean verify() {
        try {
            int yearFrom = (Integer)this.spYearFrom.getValue();
            int yearTo = (Integer)this.spYearTo.getValue();
            int monthFrom = (Integer)this.spMonthFrom.getValue();
            int monthTo = (Integer)this.spMonthTo.getValue();
            if (yearFrom > yearTo) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"YearFromLTYearTo"));
                return false;
            }
            if (yearFrom == yearTo && monthFrom > monthTo) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"MonthFromLTMonthTo"));
                return false;
            }
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"225_DepChargeReportFilterUI"));
            return false;
        }
        Object[] companyOrgUnit = (Object[])f7.getFullData();
        if (!this.checkSameCurrency(companyOrgUnit)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"CurrencyNotMatch"));
            return false;
        }
        return true;
    }

    public boolean checkSameCurrency(Object[] infos) {
        CompanyOrgUnitInfo currCom = null;
        String firstCur = null;
        String firstOrg = null;
        int length = infos.length;
        for (int i = 0; i < length; ++i) {
            if (firstCur == null) {
                currCom = InvClientUtils.getCompanyInfo((String)((FullOrgUnitInfo)infos[i]).getId().toString());
                if (currCom == null) continue;
                firstCur = currCom.getBaseCurrency().getId().toString();
                firstOrg = ((FullOrgUnitInfo)infos[i]).getName();
                continue;
            }
            currCom = InvClientUtils.getCompanyInfo((String)((FullOrgUnitInfo)infos[i]).getId().toString());
            if (currCom == null || firstCur.equals(currCom.getBaseCurrency().getId().toString())) continue;
            return false;
        }
        return true;
    }
}

