/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.BizCLOSEACCOUNTException;
import com.kingdee.eas.scm.cal.invdep.DepChargeFactory;
import com.kingdee.eas.scm.cal.invdep.DepChargeInfo;
import com.kingdee.eas.scm.cal.invdep.DepReverseEntryCollection;
import com.kingdee.eas.scm.cal.invdep.DepReverseEntryInfo;
import com.kingdee.eas.scm.cal.invdep.DepReverseException;
import com.kingdee.eas.scm.cal.invdep.DepReverseFacadeFactory;
import com.kingdee.eas.scm.cal.invdep.DepReverseFactory;
import com.kingdee.eas.scm.cal.invdep.DepReverseInfo;
import com.kingdee.eas.scm.cal.invdep.IDepCharge;
import com.kingdee.eas.scm.cal.invdep.IDepReverse;
import com.kingdee.eas.scm.cal.invdep.IDepReverseFacade;
import com.kingdee.eas.scm.cal.invdep.client.AbstractDepReverseEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class DepReverseEditUI
extends AbstractDepReverseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DepReverseEditUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.cal.invdep.InvdepResource";
    private PeriodInfo curPeriodInfo = null;
    private IDepReverseFacade reverseFacade = null;
    private DataChangeListener companyChangeListener = null;
    protected CompanyOrgUnitInfo currentCompany;
    public static final String DEPREVERSE_BILLTYPEID = "0Vh8gAEdEADgAFFNwKgSQUY+1VI=";
    private boolean isAddNew = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCompany = this.isAddNew ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : this.editData.getCompany();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.checkSysClose();
        }
        this.actionInsertLine.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setEnabled(false);
        this.actionAddLine.setEnabled(false);
        this.actionCreateFrom.setVisible(true);
        this.actionCreateFrom.setEnabled(true);
        this.actionTraceDown.setVisible(true);
        this.actionTraceDown.setEnabled(true);
        this.actionTraceUp.setVisible(true);
        this.actionTraceUp.setEnabled(true);
        this.actionAudit.setBindWorkFlow(false);
        this.reverseFacade = DepReverseFacadeFactory.getRemoteInstance();
        IColumn col = this.kdtEntrys.getColumn("material");
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        col.setRenderer((IBasicRender)avr);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("entrys.material.*"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.*"));
        sic.add(new SelectorItemInfo("entrys.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("voucher.number"));
        return sic;
    }

    private void checkSysClose() throws BizCLOSEACCOUNTException, EASBizException, BOSException {
        if (this.currentCompany != null && this.currentCompany.getId() != null && SystemStatusCtrolUtils.isClose(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany)) {
            throw new DepReverseException(new NumericExceptionSubItem("001", EASResource.getString((String)resClassName, (String)"SysCloseNotReverse")));
        }
    }

    private void removeCompanyListener() {
        if (this.companyChangeListener != null) {
            this.prmtCompany.removeDataChangeListener(this.companyChangeListener);
        }
    }

    private void addCompanyListener() {
        this.companyChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DepReverseEditUI.this.prmtCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    DepReverseEditUI.this.prmtCompany.setValue(null);
                    DepReverseEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCompany.addDataChangeListener(this.companyChangeListener);
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"FinanceOrgNotNull"));
            return;
        }
        this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (this.curPeriodInfo != null && this.curPeriodInfo.getEndDate() != null) {
            this.pkBizDate.setValue((Object)new Date(this.curPeriodInfo.getEndDate().getTime()));
            this.editData.setBizDate(new Date(this.curPeriodInfo.getEndDate().getTime()));
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"FinanceOrgUnit") + company.getName() + EASResource.getString((String)resClassName, (String)"PeriodNull")));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (this.kdtEntrys.getRowCount() != 0) {
                this.prmtCompany.setEnabled(false);
            }
            this.filterData();
            this.setPrecision();
            this.setHorizonAlign();
            this.txtDescription.setMaxLength(255);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setHorizonAlign() {
        this.kdtEntrys.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntrys.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdtEntrys.getColumn(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdtEntrys.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdtEntrys.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompany;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DepReverseFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.cal.invdep.app.DepReversePrintQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/FI/CAL/DepReverse";
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new DepReverseEntryInfo();
    }

    protected void createDepReverseEditUI() throws Exception {
    }

    @Override
    protected IObjectValue createNewData() {
        DepReverseInfo objectValue = new DepReverseInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        try {
            BillTypeInfo billTypeInfo = BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)new ObjectUuidPK(DEPREVERSE_BILLTYPEID));
            objectValue.setBillType(billTypeInfo);
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        try {
            if (this.getDefaultMainBizOrg() instanceof CompanyOrgUnitInfo) {
                objectValue.setCompany((CompanyOrgUnitInfo)this.getDefaultMainBizOrg());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        try {
            if (this.curPeriodInfo == null) {
                this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)objectValue.getCompany());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.isAddNew = true;
        return objectValue;
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "depReverse_new";
        }
        return null;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.multiApproveIfInWF();
        IDepReverse iDepreverse = DepReverseFactory.getRemoteInstance();
        boolean isSuccess = false;
        try {
            this.setOprtState("AUDIT");
            iDepreverse.audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            isSuccess = true;
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
        }
        if (isSuccess) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"AuditSuccess"));
            this.setUnAuditStatus(true);
            this.setOprtState(OprtState.VIEW);
            this.refreshCurPage();
        }
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = this.editData.getCompany();
        BOSUuid billId = this.editData.getId();
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        IDepReverse iDepreverse = DepReverseFactory.getRemoteInstance();
        DepReverseInfo depReverseInfo = (DepReverseInfo)iDepreverse.getValue((IObjectPK)pk);
        int year = depReverseInfo.getYear();
        int period = depReverseInfo.getPeriod();
        if (this.curPeriodInfo == null) {
            this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        if (year != this.curPeriodInfo.getPeriodYear() || period != this.curPeriodInfo.getPeriodNumber()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"NotCurrentBill"));
            return;
        }
        super.actionUnAudit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid billId = this.editData.getId();
        if (billId != null && !this.reverseFacade.canSave(billId.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"BillCanNotSave"));
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"FinanceOrgNotNull"));
            return;
        }
        if (this.curPeriodInfo == null) {
            this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        if (this.curPeriodInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"FinanceOrgUnit") + company.getName() + EASResource.getString((String)resClassName, (String)"PeriodNull")));
            return;
        }
        try {
            BillTypeInfo billTypeInfo = BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)new ObjectUuidPK(DEPREVERSE_BILLTYPEID));
            this.editData.setBillType(billTypeInfo);
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        this.editData.setYear(this.curPeriodInfo.getPeriodYear());
        this.editData.setPeriod(this.curPeriodInfo.getPeriodNumber());
        super.actionSave_actionPerformed(e);
    }

    protected void filterData() throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null && this.editData.getCompany() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"FinanceOrgNotNull"));
            return;
        }
        this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (this.curPeriodInfo != null && this.curPeriodInfo.getEndDate() != null) {
            this.pkBizDate.setValue((Object)new Date(this.curPeriodInfo.getEndDate().getTime()));
            this.editData.setBizDate(new Date(this.curPeriodInfo.getEndDate().getTime()));
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"FinanceOrgUnit") + company.getName() + EASResource.getString((String)resClassName, (String)"PeriodNull")));
        }
        ObjectUuidPK pk = null;
        StringBuffer companyNotMatch = new StringBuffer();
        StringBuffer periodNotMatch = new StringBuffer();
        BigDecimal curOutQty = new BigDecimal("0.00");
        IDepCharge iDepCharge = DepChargeFactory.getRemoteInstance();
        DepChargeInfo depChargeInfo = null;
        IDepReverse iDepReverse = DepReverseFactory.getRemoteInstance();
        DepReverseEntryCollection entries = this.editData.getEntrys();
        if (entries == null || entries.size() == 0) {
            this.addLine(this.kdtEntrys);
            return;
        }
        this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (this.curPeriodInfo == null) {
            return;
        }
        DepReverseEntryInfo entry = null;
        int latestYear = this.curPeriodInfo.getPeriodYear();
        int latestPeriod = this.curPeriodInfo.getPeriodNumber();
        int[] lastChargePeriod = null;
        if (entries != null) {
            entry = entries.get(0);
            if (entry.getCurPeriodOutQty() == null && entry.getMaterial() != null) {
                this.kdtEntrys.setVisible(false);
                StringBuffer curMaterialIDs = new StringBuffer();
                curMaterialIDs.append(" ('");
                for (int i = 0; i < entries.size() - 1; ++i) {
                    entry = entries.get(i);
                    if (entry.getMaterial() == null) continue;
                    curMaterialIDs.append(entry.getMaterial().getId()).append("','");
                }
                entry = entries.get(entries.size() - 1);
                if (entry.getMaterial() != null) {
                    curMaterialIDs.append(entry.getMaterial().getId()).append("') ");
                } else {
                    curMaterialIDs.append("')");
                }
                Object[] obj = new Object[]{company.getId().toString(), new Integer(this.curPeriodInfo.getPeriodYear()), new Integer(this.curPeriodInfo.getPeriodNumber()), curMaterialIDs.toString()};
                if (this.reverseFacade == null) {
                    this.reverseFacade = DepReverseFacadeFactory.getRemoteInstance();
                }
                String[] strs = this.reverseFacade.checkMaterialReSubmit(obj);
                String existMaterialIDs = strs[0];
                String ids = strs[1];
                if (existMaterialIDs != null && !existMaterialIDs.equals("")) {
                    String[] idsStr = ids.split(",");
                    ArrayList<String> list = new ArrayList<String>();
                    for (int k = 0; k < idsStr.length; ++k) {
                        list.add(idsStr[k]);
                    }
                    for (int i = entries.size() - 1; i >= 0; --i) {
                        entry = entries.get(i);
                        if (!list.contains(entry.getMaterial().getId().toString())) continue;
                        this.kdtEntrys.removeRow(i);
                        this.editData.getEntrys().removeObject(i);
                    }
                    this.kdtEntrys.setVisible(true);
                    this.pkBizDate.setValue((Object)new Date(this.curPeriodInfo.getEndDate().getTime()));
                    MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"MaterisalExistAlready") + existMaterialIDs));
                }
                this.kdtEntrys.setVisible(true);
            } else {
                return;
            }
        }
        StringBuffer invQty_reverseQty = new StringBuffer("");
        StringBuffer curLowerZero = new StringBuffer("");
        lastChargePeriod = this.reverseFacade.getLastChargePeriod(company.getId().toString());
        if (lastChargePeriod != null) {
            latestYear = lastChargePeriod[0];
            latestPeriod = lastChargePeriod[1];
            if (this.curPeriodInfo.getPeriodYear() == latestYear && latestPeriod == this.curPeriodInfo.getPeriodNumber()) {
                for (int j = entries.size() - 1; j >= 0; --j) {
                    this.kdtEntrys.removeRow(j);
                    this.editData.getEntrys().removeObject(j);
                }
                this.addLine(this.kdtEntrys);
                this.kdtEntrys.setVisible(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"CurPeriodChargedNotReverse"));
                return;
            }
        }
        int length = entries.size();
        try {
            IMeasureUnit iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
            MeasureUnitInfo measureUnitInfo = null;
            for (int i = length - 1; i >= 0; --i) {
                entry = entries.get(i);
                if (entry.getCurPeriodOutQty() != null) {
                    return;
                }
                if (entry.getInvQty() == null) {
                    this.editData.getEntrys().removeObject(i);
                    this.kdtEntrys.removeRow(i);
                    continue;
                }
                if (entry.getInvQty().compareTo(entry.getDepReverseQty()) <= 0) {
                    invQty_reverseQty.append(entry.getMaterial().getNumber()).append(" ");
                    this.editData.getEntrys().removeObject(i);
                    this.kdtEntrys.removeRow(i);
                    continue;
                }
                String srcID = entry.getSourceBillId();
                pk = new ObjectUuidPK(srcID);
                depChargeInfo = (DepChargeInfo)iDepCharge.getValue((IObjectPK)pk);
                if (!company.getId().equals((Object)depChargeInfo.getCompany().getId())) {
                    companyNotMatch.append(entry.getSeq()).append(" ");
                    this.editData.getEntrys().removeObject(i);
                    this.kdtEntrys.removeRow(i);
                    continue;
                }
                if (latestYear != depChargeInfo.getYear() || latestPeriod != depChargeInfo.getPeriod()) {
                    this.editData.getEntrys().removeObject(i);
                    this.kdtEntrys.removeRow(i);
                    periodNotMatch.append(entry.getMaterial().getNumber().toString()).append(" ");
                    continue;
                }
                curOutQty = this.reverseFacade.calculateOutQty(company.getId().toString(), entry.getMaterial().getId().toString(), this.curPeriodInfo.getPeriodYear(), this.curPeriodInfo.getPeriodNumber());
                if (curOutQty != null && curOutQty.compareTo(new BigDecimal("0.00")) > 0) {
                    BigDecimal curDepReverseQty = new BigDecimal("0.00");
                    BigDecimal curDepReverseAmt = new BigDecimal("0.00");
                    entry.setCurPeriodOutQty(curOutQty);
                    this.kdtEntrys.getCell(i, 12).setValue((Object)curOutQty);
                    if (curOutQty.compareTo(entry.getInvQty().subtract(entry.getDepReverseQty())) <= 0) {
                        curDepReverseQty = curOutQty;
                        entry.setCurPeriodDrQty(curDepReverseQty);
                        this.kdtEntrys.getCell(i, 13).setValue((Object)curDepReverseQty);
                    } else {
                        curDepReverseQty = entry.getInvQty().subtract(entry.getDepReverseQty());
                        entry.setCurPeriodDrQty(curDepReverseQty);
                        this.kdtEntrys.getCell(i, 13).setValue((Object)curDepReverseQty);
                    }
                    if (curOutQty.compareTo(entry.getInvQty().subtract(entry.getDepReverseQty())) != 0) {
                        curDepReverseAmt = entry.getCurPeriodDrQty().multiply(entry.getInvPrice().subtract(entry.getUnNetRealizable()));
                        entry.setCurPeriodDrAmt(curDepReverseAmt);
                        this.kdtEntrys.getCell(i, 14).setValue((Object)curDepReverseAmt);
                    } else {
                        curDepReverseAmt = entry.getInvAmount().subtract(entry.getNetRealizable()).subtract(entry.getDepReverseAmt());
                        entry.setCurPeriodDrAmt(curDepReverseAmt);
                        this.kdtEntrys.getCell(i, 14).setValue((Object)curDepReverseAmt);
                    }
                } else {
                    curLowerZero.append(entry.getMaterial().getNumber()).append(" ");
                    this.editData.getEntrys().removeObject(i);
                    this.kdtEntrys.removeRow(i);
                    continue;
                }
                measureUnitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getBaseUnit().getId().toString()));
                this.kdtEntrys.getCell(i, 4).setValue((Object)measureUnitInfo);
                this.editData.getEntrys().set(i, entry);
            }
        }
        catch (ObjectNotFoundException s) {
            throw new ObjectNotFoundException((Throwable)s);
        }
        if (!companyNotMatch.toString().trim().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"CompanyNotMatch"));
        } else if (!periodNotMatch.toString().trim().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"276_DepReverseEditUI", (String[])new String[]{periodNotMatch.toString()}));
        } else if (!"".equals(curLowerZero.toString().trim())) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"277_DepReverseEditUI", (String[])new String[]{curLowerZero.toString()}));
        }
        if (!"".equals(invQty_reverseQty.toString().trim())) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"278_DepReverseEditUI", (String[])new String[]{invQty_reverseQty.toString()}));
        }
        if (this.editData.getEntrys() == null || this.editData.getEntrys().size() == 0) {
            this.pkBizDate.setValue((Object)new Date(this.curPeriodInfo.getEndDate().getTime()));
            this.addLine(this.kdtEntrys);
        }
        if (this.pkBizDate.getValue() != null) {
            this.editData.setYear(this.curPeriodInfo.getPeriodYear());
            this.editData.setPeriod(this.curPeriodInfo.getPeriodNumber());
            this.pkBizDate.setValue((Object)new Date(this.curPeriodInfo.getEndDate().getTime()));
        }
    }

    private void setPrecision() throws EASBizException, BOSException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"FinanceOrgNotNull"));
            return;
        }
        company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
        CurrencyInfo currency = null;
        MaterialInfo material = null;
        int currencyPrecision = 2;
        int pricePrecision = 2;
        int qtyPrecision = 2;
        String[] currencyPreCols = new String[]{"invAmount", "netRealizable", "depReverseAmt", "curPeriodDrAmt"};
        String[] pricePreCols = new String[]{"invPrice", "UnNetRealizable"};
        String[] qtyPreCols = new String[]{"invQty", "depReverseQty", "curPeriodOutQty", "curPeriodDrQty"};
        DepReverseEntryCollection entries = this.editData.getEntrys();
        DepReverseEntryInfo entry = null;
        int length = entries.size();
        if (entries == null || entries.get(0) == null || entries.get(0).getMaterial() == null) {
            return;
        }
        try {
            currencyPrecision = company == null || company.getBaseCurrency() == null ? 2 : ((currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()))) != null ? currency.getPrecision() : 2);
            SCMClientUtils.changeTableColPrecision((int)currencyPrecision, (KDTable)this.kdtEntrys, (String[])currencyPreCols);
            for (int i = length - 1; i >= 0; --i) {
                entry = entries.get(i);
                material = entry.getMaterial();
                pricePrecision = material == null ? 2 : material.getPricePrecision();
                SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.kdtEntrys, (String[])pricePreCols, (int)i);
            }
            int num = this.getDetailTable().getRowCount();
            MaterialInfo[] materialInfos = new MaterialInfo[num];
            MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[num];
            for (int i = 0; i < num; ++i) {
                measureBaseUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell("baseUnit").getValue();
                materialInfos[i] = (MaterialInfo)this.getDetailTable().getRow(i).getCell("material").getValue();
            }
            SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureBaseUnitInfos, (KDTable)this.getDetailTable(), (String[])qtyPreCols);
        }
        catch (EASBizException e) {
            throw new EASBizException(null, (Throwable)e, null);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception es) {
            this.handleException(es);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().getValue() == 0 || this.editData.getBaseStatus().getValue() == 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"BillNotPrint"));
            return;
        }
        this.invokePrintFunction(true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().getValue() == 0 || this.editData.getBaseStatus().getValue() == 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"BillNotPrintPreView"));
            return;
        }
        this.invokePrintFunction(false);
    }

    protected void setTableToSumField() {
        super.setTableToSumField();
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        return new String[]{"curPeriodDrAmt@%R_{0.##########}f", "curPeriodDrQty@%R_{0.##########}f", "curPeriodOutQty@%R_{0.##########}f", "depReverseAmt@%R_{0.##########}f", "depReverseQty@%R_{0.##########}f", "netRealizable@%R_{0.##########}f", "invAmount@%R_{0.##########}f", "invQty@%R_{0.##########}f"};
    }
}

