/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.OrgStructureUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.invdep.DepChargeHelper;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryEntryInfo;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryFactory;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryInfo;
import com.kingdee.eas.scm.cal.invdep.client.AbstractMaterialCategoryEditUI;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialCategoryEditUI
extends AbstractMaterialCategoryEditUI {
    private static final long serialVersionUID = 2625919833634820280L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialCategoryEditUI.class);
    protected DataChangeListener prmtEntryMaterialListener = null;
    protected DataChangeListener prmtCompanyListener;
    protected CompanyOrgUnitInfo currentCompany;
    protected UserInfo userInfo = null;
    private DepChargeHelper helper = new DepChargeHelper();
    protected F7ContextManager f7Manager = null;
    private KDBizPromptBox bizMaterialBox;
    private boolean isUsedCodingRule = false;
    private boolean isAddNewCodingRule = false;
    private boolean isAddNoBreakCodingRule = false;
    private String title = this.getUITitle();

    public MaterialCategoryEditUI() throws Exception {
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    }

    public void onLoad() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        OrgStructureUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCopy.setVisible(false);
        this.isUsedCodingRule = this.isMaterialBaseUsedCodingRule();
        super.onLoad();
    }

    private boolean isMaterialBaseUsedCodingRule() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)new MaterialCategoryInfo());
        MaterialCategoryInfo material = new MaterialCategoryInfo();
        this.isUsedCodingRule = iCodingRuleManager.isExist((IObjectValue)material, strCompanyID);
        if (this.isUsedCodingRule) {
            this.isAddNewCodingRule = iCodingRuleManager.isAddView((IObjectValue)material, strCompanyID);
            this.isAddNoBreakCodingRule = iCodingRuleManager.getRuleStatus((IObjectValue)material, strCompanyID).isAddNoBreak();
        }
        return this.isUsedCodingRule;
    }

    @Override
    public void loadFields() {
        this.txtName.setRequired(true);
        this.txtNumber.setRequired(true);
        this.txtInvDepRatio.setMinimumNumber((Number)BigDecimal.ZERO);
        this.txtInvDepRatio.setMaximumNumber((Number)BigDecimal.valueOf(99.9999));
        this.txtInvDepRatio.setPrecision(4);
        boolean flag = OprtState.VIEW.equals(this.getOprtState());
        this.actionAddMaterial.setEnabled(!flag);
        this.actionRemoveMaterial.setEnabled(!flag);
        MaterialClientTools.setupUITitle((CoreUIObject)this, (String)this.title);
        try {
            this.setColMaterial();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.setAcct();
        this.removeListener();
        super.loadFields();
        this.getNumberByRule((IObjectValue)this.editData);
        this.addListener();
    }

    private void setAcct() {
        EntityViewInfo view = this.helper.getAcctEvi(null, this.currentCompany.getAccountTable());
        this.prmtInvDepPreAcct.setEntityViewInfo(view);
        this.prmtAcct.setEntityViewInfo(view);
    }

    private void addListener() {
        this.prmtCompanyListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialCategoryEditUI.this.prmtCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    MaterialCategoryEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
    }

    private void removeListener() {
        this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
    }

    private void prmtCompany_dataChanged(DataChangeEvent e) {
    }

    private void setColMaterial() throws EASBizException, BOSException {
        OrgUnitInfo orgInfo = null;
        if (this.getMainOrgContext() != null) {
            orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType());
        }
        this.bizMaterialBox = new KDBizPromptBox();
        this.f7Manager.registerBizMaterialF7(this.bizMaterialBox, this.kdtEntries.getColumn("materialNumber"), null, orgInfo, true);
        if (this.bizMaterialBox.getEntityViewInfo() != null) {
            EntityViewInfo view = this.bizMaterialBox.getEntityViewInfo();
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.currentCompany.getId()));
            view.getFilter().getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(2), CompareType.NOTEQUALS));
        }
        this.prmtEntryMaterialListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialCategoryEditUI.this.entryMaterialDataChanged(e);
                }
                catch (Exception ex) {
                    MaterialCategoryEditUI.this.handUIException(ex);
                }
            }
        };
        this.bizMaterialBox.addDataChangeListener(this.prmtEntryMaterialListener);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompany;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("invDepAcct.*"));
        sic.add(new SelectorItemInfo("invDepPreAcct.*"));
        sic.add(new SelectorItemInfo("invDepRatio"));
        return sic;
    }

    private void entryMaterialDataChanged(DataChangeEvent e) throws Exception {
        Object[] objArray;
        int selected = this.kdtEntries.getSelectManager().get().getBeginRow();
        IRow row = this.kdtEntries.getRow(selected);
        if (e.getNewValue() != null && e.getNewValue().getClass().isArray() && (objArray = (Object[])e.getNewValue()).length > 0) {
            MaterialInfo materialInfo;
            int i;
            int length = objArray.length;
            for (i = 0; i < length; ++i) {
                if (!(objArray[i] instanceof MaterialInfo)) continue;
                materialInfo = (MaterialInfo)objArray[i];
                for (int rowIdx = 0; rowIdx < this.kdtEntries.getRowCount(); ++rowIdx) {
                    Object obj = this.kdtEntries.getRow(rowIdx).getCell("materialNumber").getValue();
                    if (!(obj instanceof MaterialInfo)) continue;
                    MaterialInfo aMaterial = (MaterialInfo)obj;
                    if (selected == rowIdx || !aMaterial.getId().toString().equals(materialInfo.getId().toString())) continue;
                    this.bizMaterialBox.setValue(null);
                    this.kdtEntries.getRow(selected).getCell("materialNumber").setValue(null);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"230_MaterialCategoryEditUI"));
                    SysUtil.abort();
                }
            }
            length = objArray.length;
            for (i = 0; i < length; ++i) {
                if (!(objArray[i] instanceof MaterialInfo)) continue;
                materialInfo = (MaterialInfo)objArray[i];
                if (i != 0) {
                    row = this.kdtEntries.addRow();
                }
                row.getCell("materialNumber").setValue((Object)materialInfo);
                row.getCell("materialName").setValue((Object)materialInfo.getName());
                row.getCell("materialModel").setValue((Object)materialInfo.getModel());
            }
        }
        if (e.getNewValue() == null) {
            row.getCell("materialName").setValue(null);
            row.getCell("materialModel").setValue(null);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialCategoryFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialCategoryInfo info = new MaterialCategoryInfo();
        info.setCreator(this.userInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCompany(this.currentCompany);
        info.getEntry().add(new MaterialCategoryEntryInfo());
        return info;
    }

    @Override
    public void actionAddMaterial_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddMaterial_actionPerformed(e);
        this.addLine(this.kdtEntries);
    }

    @Override
    public void actionRemoveMaterial_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveMaterial_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    private void addLine(KDTable kdtEntries) {
        kdtEntries.addRow();
    }

    @Override
    protected void btnAddMaterial_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddMaterial_actionPerformed(e);
    }

    @Override
    protected void btnRemoveMaterial_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveMaterial_actionPerformed(e);
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = this.kdtEntries.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.kdtEntries.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)this.kdtEntries.getRow(rowIndex).getUserObject();
                this.kdtEntries.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)this.kdtEntries.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (this.kdtEntries.getRow(0) != null) {
                this.kdtEntries.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    private void getNumberByRule(IObjectValue caller) {
        if (this.isUsedCodingRule) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
            if (this.isAddNewCodingRule) {
                this.getNumberByCodingRule(caller, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            } else if (this.isAddNoBreakCodingRule) {
                try {
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                    String number = iCodingRuleManager.readNumber(caller, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                    this.prepareNumber(caller, number);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        } else {
            this.setNumberTextEnabled();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isUsedCodingRule) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDMultiLangBox)this.txtName);
        super.actionSave_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        MaterialClientTools.setupUITitle((CoreUIObject)this, (String)this.title);
        this.actionAddMaterial.setEnabled(true);
        this.actionRemoveMaterial.setEnabled(true);
    }
}

