/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.onekey.client.AbstractMaterialCalcRankFilterUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialCalcRankFilterUI
extends AbstractMaterialCalcRankFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCalcRankFilterUI.class);
    private CompanyOrgUnitInfo curCompany = null;
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);

    public MaterialCalcRankFilterUI() throws Exception {
        this.kDBizPromptCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    MaterialCalcRankFilterUI.this.companyChange(e);
                }
                catch (Exception ex) {
                    MaterialCalcRankFilterUI.this.handUIException(ex);
                }
            }
        });
    }

    public void onInit(RptParams initParams) throws Exception {
        SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.kDBizPromptCompany, (OrgType)OrgType.Company, (String)"oneKeyCalcRank");
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.kDBizPromptCompany);
        CalculateClientUtil.setF7FilterUIProperties(this.kDBizPromptCompany, true);
        this.f7Manger.registerBizMaterialF7(this.kDBizPromptMatFrom, null, null, null, false);
        this.f7Manger.registerBizMaterialF7(this.kDBizPromptMatTo, null, null, null, false);
    }

    private void companyChange(ChangeEvent e) throws EASBizException, BOSException {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.kDBizPromptCompany.getData();
        if (cou != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (periodInfo == null) {
                this.kDBizPromptCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.kDBizPromptCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
            this.f7Manger.changeF7Context(cou.getId().toString());
        }
    }

    public void clear() {
        super.clear();
        this.kDBizPromptMatFrom.setValue(null);
        this.kDBizPromptMatTo.setValue(null);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.kDBizPromptCompany.setData((Object)this.curCompany);
            } else {
                this.kDBizPromptCompany.setData(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.chkIsAssembleCalc.setSelected(true);
        this.chkIsDevCalc.setSelected(true);
        this.chkIsMatChangeCalc.setSelected(true);
        this.chkIsDisAssembleCalc.setSelected(true);
        this.chkIsCostMove.setSelected(true);
        this.chkOther.setSelected(true);
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)"oneKeyCalcRank")) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.f7Manger.registerBizMaterialF7(this.kDBizPromptMatFrom, null, null, null, false);
        this.f7Manger.registerBizMaterialF7(this.kDBizPromptMatTo, null, null, null, false);
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setBoolean("isAssemble", this.chkIsAssembleCalc.isSelected());
        para.setBoolean("isDisMatAssemble", this.chkIsDisAssembleCalc.isSelected());
        para.setBoolean("isMatChange", this.chkIsMatChangeCalc.isSelected());
        para.setBoolean("isDevCalc", this.chkIsDevCalc.isSelected());
        para.setBoolean("isCostMove", this.chkIsCostMove.isSelected());
        para.setBoolean("isOther", this.chkOther.isSelected());
        para.setObject("matFrom", this.kDBizPromptMatFrom.getValue());
        para.setObject("matTo", this.kDBizPromptMatTo.getValue());
        para.setObject("company", this.kDBizPromptCompany.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.chkIsAssembleCalc.setSelected(params.getBoolean("isAssemble"));
        this.chkIsDisAssembleCalc.setSelected(params.getBoolean("isDisMatAssemble"));
        this.chkIsMatChangeCalc.setSelected(params.getBoolean("isMatChange"));
        this.chkIsDevCalc.setSelected(params.getBoolean("isDevCalc"));
        this.chkIsCostMove.setSelected(params.getBoolean("isCostMove"));
        this.chkOther.setSelected(params.getBoolean("isOther"));
        this.kDBizPromptCompany.setValue(params.getObject("company"));
        this.kDBizPromptMatFrom.setValue(params.getObject("matFrom"));
        this.kDBizPromptMatTo.setValue(params.getObject("matTo"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.kDBizPromptCompany;
    }

    public boolean verify() {
        if (this.getMainBizOrgF7().getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        return true;
    }
}

