/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.onekey.OneKeyComputeReportFacadeFactory;
import com.kingdee.eas.scm.cal.onekey.client.AbstractOneKeyComputeReportUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OneKeyComputeReportUI
extends AbstractOneKeyComputeReportUI {
    private static final Logger logger = CoreUIObject.getLogger(OneKeyComputeReportUI.class);
    private int currentPKIndex = -1;
    private List<String> materialIdList = new ArrayList<String>();
    private final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.CalCommonResource";
    private final String[] calModelStrArray = new String[]{EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"LOT"), EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ASSISTPROPERTY"), EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PROJECT"), EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"TRACKNUMBER")};
    private final int rowHeight = this.tblMain == null ? 20 : this.tblMain.getDefaultRowHeight();

    public OneKeyComputeReportUI() throws Exception {
        this.tblMain.setEditable(false);
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.initUIControl();
        this.initMaterialPKList(this.params);
        this.initMaterialFilterF7();
    }

    private void initMaterialFilterF7() {
        this.prmtMaterialFilter.setEditFormat("$number$");
        this.prmtMaterialFilter.setDisplayFormat("$name$");
        this.prmtMaterialFilter.setCommitFormat("$number$");
        this.prmtMaterialFilter.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.materialIdList != null && !this.materialIdList.isEmpty()) {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            HashSet<String> idSet = new HashSet<String>();
            idSet.addAll(this.materialIdList);
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"111111111111111111111111111="));
        }
        view.setFilter(filter);
        this.prmtMaterialFilter.setEntityViewInfo(view);
        this.prmtMaterialFilter.setHasCUDefaultFilter(false);
        this.prmtMaterialFilter.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                OneKeyComputeReportUI.this.materialFilterChange(e);
            }
        });
    }

    private void materialFilterChange(DataChangeEvent e) {
        MaterialInfo materialInfo;
        int index;
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue()) && (index = this.materialIdList.indexOf((materialInfo = (MaterialInfo)e.getNewValue()).getId().toString())) > -1 && this.currentPKIndex != index) {
            this.currentPKIndex = index;
            this.query();
        }
    }

    private void initUIControl() {
        this.prmtCompany.setValue(this.params.getObject("company"));
        PeriodInfo periodInfo = (PeriodInfo)this.params.getObject("period");
        this.txtPeriod.setText(periodInfo.toString());
        this.tblMain.getGroupManager().setGroup(true);
        if (this.tHelper != null) {
            this.tHelper.getDisabledTables().add(this.tblMain);
        }
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.menuFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.menuPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.menuNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.menuLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.tblMain.setDefaultRowHeight(this.rowHeight * 3);
        this.tblMain.getColumn("settleAccounts").getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("expense").getStyleAttributes().setWrapText(true);
    }

    public void getData(KDTDataRequestEvent e) {
        if (StringUtils.isEmpty((String)this.params.getString("materialId"))) {
            return;
        }
        RptParams createParams = this.buildCreateParams(this.params);
        try {
            RptParams result = this.getRemoteInstance().createTempTable(createParams);
            this.handleMaterialUIData(result);
            this.setTempTable(result.getString("tempTable"));
            result = this.getRemoteInstance().query(result);
            RptRowSet rs = (RptRowSet)result.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)0, (KDTable)this.tblMain);
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)i);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private RptParams buildCreateParams(RptParams params) {
        RptParams queryParam = new RptParams();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
        queryParam.setString("companyId", companyInfo.getId().toString());
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("period");
        queryParam.setInt("year", periodInfo.getPeriodYear());
        queryParam.setInt("period", periodInfo.getPeriodNumber());
        queryParam.setString("materialId", params.getString("materialId"));
        return queryParam;
    }

    protected void query() {
        this.setChangeRecordButtonStatus();
        String currenMaterialId = this.getCurrenMaterialId();
        if (!StringUtils.isEmpty((String)currenMaterialId)) {
            this.params.setString("materialId", this.getCurrenMaterialId());
            this.tblMain.removeRows();
        }
    }

    private void handleMaterialUIData(RptParams result) {
        int accountType = result.getInt("accountType");
        String calType = result.getString("calType");
        boolean isLot = result.getBoolean("isLot");
        boolean isAssistProp = result.getBoolean("isAssistProp");
        boolean isProject = result.getBoolean("isProject");
        boolean isTrackNumber = result.getBoolean("isTrackNumber");
        this.prmtMaterial.setValue(result.getObject("material"));
        this.txtAccountType.setText(AccountType.getEnum((int)result.getInt("accountType")).getAlias());
        this.txtBaseUnit.setText(result.getString("baseUnitName"));
        this.txtCalType.setText(MaterialCalTypeEnum.getEnum(result.getString("calType")).getAlias());
        this.tblMain.getColumn("lot").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("assistPropName").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("projectNumber").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("trackNumber").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("storageOrgName").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("warehouseName").getStyleAttributes().setHided(true);
        this.labContCalMode.setVisible(false);
        if (5 == accountType) {
            this.labContCalMode.setVisible(true);
            this.txtCalMode.setText(this.getCalMode(result));
            if (isLot) {
                this.tblMain.getColumn("lot").getStyleAttributes().setHided(false);
            }
            if (isAssistProp) {
                this.tblMain.getColumn("assistPropName").getStyleAttributes().setHided(false);
            }
            if (isProject) {
                this.tblMain.getColumn("projectNumber").getStyleAttributes().setHided(false);
            }
            if (isTrackNumber) {
                this.tblMain.getColumn("trackNumber").getStyleAttributes().setHided(false);
            }
        }
        if ("1".equals(calType)) {
            this.tblMain.getColumn("storageOrgName").getStyleAttributes().setHided(false);
        }
        if ("2".equals(calType)) {
            this.tblMain.getColumn("storageOrgName").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("warehouseName").getStyleAttributes().setHided(false);
        }
    }

    private String getCalMode(RptParams result) {
        StringBuilder calModeSb = new StringBuilder();
        if (5 == result.getInt("accountType")) {
            if (result.getBoolean("isLot")) {
                calModeSb.append(this.calModelStrArray[0]).append("+");
            }
            if (result.getBoolean("isAssistProp")) {
                calModeSb.append(this.calModelStrArray[1]).append("+");
            }
            if (result.getBoolean("isProject")) {
                calModeSb.append(this.calModelStrArray[2]).append("+");
            }
            if (result.getBoolean("isTrackNumber")) {
                calModeSb.append(this.calModelStrArray[3]).append("+");
            }
        }
        if (calModeSb.length() > 0) {
            return calModeSb.substring(0, calModeSb.length() - 1);
        }
        return "";
    }

    private void initMaterialPKList(RptParams params) throws BOSException {
        if (!StringUtils.isEmpty((String)params.getString("excptMaterialId"))) {
            this.materialIdList = new ArrayList<String>();
            this.materialIdList.add(params.getString("excptMaterialId"));
        } else if (this.currentPKIndex == -1) {
            RptParams queryParam = new RptParams();
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
            queryParam.setString("companyId", companyInfo.getId().toString());
            PeriodInfo periodInfo = (PeriodInfo)params.getObject("period");
            queryParam.setInt("year", periodInfo.getPeriodYear());
            queryParam.setInt("period", periodInfo.getPeriodNumber());
            this.materialIdList = OneKeyComputeReportFacadeFactory.getRemoteInstance().getMaterialIdList(queryParam);
        }
    }

    public boolean isAsynchronism() {
        return false;
    }

    private String getCurrenMaterialId() {
        String curMaterialId = null;
        if (this.materialIdList != null && !this.materialIdList.isEmpty()) {
            if (this.currentPKIndex == -1) {
                this.currentPKIndex = 0;
            }
            curMaterialId = this.materialIdList.get(this.currentPKIndex);
        }
        return curMaterialId;
    }

    private void setChangeRecordButtonStatus() {
        if (this.materialIdList == null || this.materialIdList.isEmpty()) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuFirst.setEnabled(false);
            this.menuPre.setEnabled(false);
            this.menuNext.setEnabled(false);
            this.menuLast.setEnabled(false);
        } else if (this.materialIdList.size() <= 1) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuFirst.setEnabled(false);
            this.menuPre.setEnabled(false);
            this.menuNext.setEnabled(false);
            this.menuLast.setEnabled(false);
        } else if (this.currentPKIndex <= 0) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.menuFirst.setEnabled(false);
            this.menuPre.setEnabled(false);
            this.menuNext.setEnabled(true);
            this.menuLast.setEnabled(true);
        } else if (this.currentPKIndex >= this.materialIdList.size() - 1) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuFirst.setEnabled(true);
            this.menuPre.setEnabled(true);
            this.menuNext.setEnabled(false);
            this.menuLast.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.menuFirst.setEnabled(true);
            this.menuPre.setEnabled(true);
            this.menuNext.setEnabled(true);
            this.menuLast.setEnabled(true);
        }
    }

    private void changeMaterialIndex(int changeAction) throws BOSException, EASBizException {
        switch (changeAction) {
            case 6: {
                this.currentPKIndex = 0;
                break;
            }
            case 7: {
                --this.currentPKIndex;
                break;
            }
            case 8: {
                ++this.currentPKIndex;
                break;
            }
            case 9: {
                if (this.materialIdList == null) {
                    return;
                }
                if (this.materialIdList.size() == 0) {
                    return;
                }
                this.currentPKIndex = this.materialIdList.size() - 1;
            }
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialIndex(6);
        this.query();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialIndex(7);
        this.query();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialIndex(8);
        this.query();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialIndex(9);
        this.query();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return OneKeyComputeReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        String res = "com.kingdee.eas.scm.cal.CalRptResource";
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)res, (String)"FICU")).append(":&[Company]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MATERIELCODE")).append(":&[MATERIELCODE]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"YEARPERIOD")).append(":&[YEARPERIOD]").append("&| &|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Company", this.prmtCompany.getValue());
        map.put("MATERIELCODE", this.prmtMaterial.getValue());
        map.put("YEARPERIOD", this.txtPeriod.getText());
        return map;
    }

    public boolean isUsePrintDefault() {
        return true;
    }
}

