/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.CalendarUtil;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.channel.AbstractNetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.INetOrderCollectionManagerFacade;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderCollectionManagerFacadeFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderManagerException;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderCollectionManagerUI;
import com.kingdee.eas.scm.sd.channel.client.ChannelCommonQueryProcessor;
import com.kingdee.eas.scm.sd.channel.client.NetOrderCollectionManagerFilterUI;
import com.kingdee.eas.scm.sd.channel.util.NetOrderHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class NetOrderCollectionManagerUI
extends AbstractNetOrderCollectionManagerUI {
    private static final Logger logger = CoreUIObject.getLogger(NetOrderCollectionManagerUI.class);
    public static final String CHANNEL_CLIENT_Resource = "com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource";
    CommonQueryDialog commonQueryDialog = null;
    ItemChangeEnvent itemChangeEnvent = new ItemChangeEnvent();
    NetOrderCollectionManagerFilterUI filterUI = null;
    ISCMBillBase iBiz = null;
    OrgUnitCollection authorizedMainOrgs = null;
    Set listSaleOrg = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.kDCheckInv.setSelected(false);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "entries.entryStatus").getValue();
        }
        this.initUI();
        this.initData();
        this.tbInvenInfo.refresh();
        this.tbManagerInfo.refresh();
    }

    protected String getEditUIName() {
        return "";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDContainer3.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 986, 279));
        this.kDContainer2.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 482, 279));
        this.kDContainer1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 500, 279));
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (OrgType.Sale.equals((Object)orgType)) {
            return "saleOrgUnit.id";
        }
        if (OrgType.Storage.equals((Object)orgType)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    private void initUI() {
        KDCheckBox tblMain_IsSelect_kdCheckBox = new KDCheckBox();
        KDTDefaultCellEditor tblMain_IsSelect_CellEditor = new KDTDefaultCellEditor((JCheckBox)tblMain_IsSelect_kdCheckBox);
        this.tblMain.getColumn("isSelect").setEditor((ICellEditor)tblMain_IsSelect_CellEditor);
        this.tblMain.checkParsed();
        this.tbManagerInfo.checkParsed();
        KDBizPromptBox tbManagerInfo_storage_PromptBox = new KDBizPromptBox();
        tbManagerInfo_storage_PromptBox.setQueryInfo("com.kingdee.eas.scm.im.inv.app.F7StorageOrgUnitQuery");
        tbManagerInfo_storage_PromptBox.setVisible(true);
        tbManagerInfo_storage_PromptBox.setEditable(true);
        tbManagerInfo_storage_PromptBox.setDisplayFormat("$number$");
        tbManagerInfo_storage_PromptBox.setEditFormat("$number$");
        tbManagerInfo_storage_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor tbManagerInfo_storage_CellEditor = new KDTDefaultCellEditor((IKDEditor)tbManagerInfo_storage_PromptBox);
        this.tbManagerInfo.getColumn("storageOrgUnit.number").setEditor((ICellEditor)tbManagerInfo_storage_CellEditor);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)tbManagerInfo_storage_PromptBox, (OrgType)OrgType.Storage, (String)"inventory");
        KDDatePicker sendDate_DatePicker = new KDDatePicker();
        this.tbManagerInfo.getColumn("sendDate").setEditor((ICellEditor)new KDTDefaultCellEditor(sendDate_DatePicker));
        this.tbManagerInfo.getColumn("sendDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tbManagerInfo.getColumn("bizDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tbManagerInfo.getColumn("entries.askArriveDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("entries.askArriveDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tbManagerInfo.getStyleAttributes().setLocked(true);
        this.tbManagerInfo.getColumn("warehouse").getStyleAttributes().setLocked(false);
        this.tbManagerInfo.getColumn("entries.approveQty").getStyleAttributes().setLocked(false);
        this.tbManagerInfo.getColumn("sendDate").getStyleAttributes().setLocked(false);
        this.tbManagerInfo.getColumn("storageOrgUnit.number").getStyleAttributes().setLocked(false);
        this.actionUnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnUnAudit.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.btnSubmit.setVisible(false);
        this.btnSubmit.setEnabled(false);
        this.btnCreateToSaleOrder.setVisible(true);
        this.btnCreateToSaleOrder.setEnabled(true);
        this.btnFightBack.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnFightBack.setVisible(true);
        this.btnFightBack.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void initData() {
        for (int i = 0; i < this.tblMain.getRowCount1(); ++i) {
            int weightUnitPrecision;
            this.tblMain.getCell(i, "isSelect").setValue((Object)Boolean.FALSE);
            if (this.tblMain.getCell(i, "entries.entryStatus").getValue() == null || !(this.tblMain.getCell(i, "entries.entryStatus").getValue() instanceof BizEnumValueDTO) || 8 != ((BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue()).getInt() && 5 != ((BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue()).getInt() && 10 != ((BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue()).getInt() && 11 != ((BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue()).getInt() && 12 != ((BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue()).getInt()) continue;
            BigDecimal qty = (BigDecimal)this.tblMain.getCell(i, "entries.qty").getValue();
            BigDecimal approveQty = (BigDecimal)this.tblMain.getCell(i, "entries.approveQty").getValue();
            BigDecimal weight = (BigDecimal)this.tblMain.getCell(i, "entries.weight").getValue();
            int n = weightUnitPrecision = this.tblMain.getCell(i, "entries.weightUnitPrecision").getValue() == null ? 8 : new Integer(this.tblMain.getCell(i, "entries.weightUnitPrecision").getValue().toString());
            if (weight == null || approveQty == null || qty == null || new BigDecimal("0").compareTo(qty) == 0) continue;
            this.tblMain.getCell(i, "entries.approveWeight").setValue((Object)approveQty.multiply(weight.divide(qty, weightUnitPrecision, 4)));
        }
        this.tbManagerInfo.getSelectManager().setSelectMode(2);
        this.tbInvenInfo.getSelectManager().setSelectMode(2);
        this.tbInvenInfo.setEditable(false);
        this.tbInvenInfo.checkParsed();
        this.tbManagerInfo.getColumn("entries.approveQty").getStyleAttributes().setLocked(false);
        this.tbManagerInfo.getColumn("warehouse").getStyleAttributes().setLocked(false);
        this.kDCheckInv.addItemListener((ItemListener)this.itemChangeEnvent);
        this.kDCheckWareHs.setEnabled(false);
        this.kDCheckLocation.setEnabled(false);
        this.kDCheckLot.setEnabled(false);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() == this.tblMain.getColumnIndex("isSelect")) {
            int colNum;
            int rowNum = e.getRowIndex();
            if (this.tblMain.getCell(rowNum, colNum = e.getColIndex()) == null) {
                return;
            }
            if (this.tblMain.getCell(rowNum, "entries.entryStatus").getValue() != null && this.tblMain.getCell(rowNum, "entries.entryStatus").getValue() instanceof BizEnumValueDTO) {
                BizEnumValueDTO entriesStatus = (BizEnumValueDTO)this.tblMain.getCell(rowNum, "entries.entryStatus").getValue();
                Boolean select = (Boolean)this.tblMain.getCell(rowNum, colNum).getValue();
                IRow iRow = null;
                if (select.booleanValue()) {
                    this.tblMain.getCell(rowNum, "isSelect").setValue((Object)Boolean.FALSE);
                    this.deleteRowFromTbManager(this.tblMain.getCell(rowNum, "entries.id").getValue().toString());
                    if (4 == entriesStatus.getInt()) {
                        this.tblMain.getCell(rowNum, "entries.approveQty").setValue(null);
                        this.tblMain.getCell(rowNum, "entries.approveAmount").setValue(null);
                        this.tblMain.getCell(rowNum, "entries.approveWeight").setValue(null);
                    }
                } else if (4 == entriesStatus.getInt() || 8 == entriesStatus.getInt()) {
                    this.tblMain.getCell(rowNum, "isSelect").setValue((Object)Boolean.TRUE);
                    iRow = this.tblMain.getRow(rowNum);
                    this.fullManagerTable(iRow);
                } else {
                    this.tblMain.getCell(rowNum, "isSelect").setValue((Object)Boolean.FALSE);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"35_NetOrderCollectionManagerMainUI"));
                }
            }
        }
    }

    private void fullSendDate(IRow managerRow, INetOrderCollectionManagerFacade iNetOrderFacade) throws EASBizException, BOSException {
        Date askArriveDate;
        Date sendDate = askArriveDate = (Date)managerRow.getCell("entries.askArriveDate").getValue();
        String channelId = (String)managerRow.getCell("channel.id").getValue();
        String saleOrgUnitId = (String)managerRow.getCell("saleOrgUnit.id").getValue();
        int transadvday = 0;
        if (!StringUtils.isEmpty((String)channelId) && !StringUtils.isEmpty((String)saleOrgUnitId)) {
            transadvday = iNetOrderFacade.getTransadvday(channelId, saleOrgUnitId);
        }
        if (transadvday > 0) {
            sendDate = CalendarUtil.changeDate((Date)askArriveDate, (int)(transadvday * -1));
        }
        managerRow.getCell("sendDate").setValue((Object)sendDate);
    }

    private void fullManagerTable(IRow iRow) throws BOSException, NetOrderManagerException, EASBizException {
        IRow managerRow = this.tbManagerInfo.addRow(this.tbManagerInfo.getRowCount());
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            managerRow.getCell(this.tblMain.getColumnKey(i)).setValue(iRow.getCell(i).getValue());
        }
        BizEnumValueDTO entriesStatus = (BizEnumValueDTO)iRow.getCell("entries.entryStatus").getValue();
        if (4 == entriesStatus.getInt()) {
            managerRow.getCell("entries.approveQty").setValue(iRow.getCell("entries.qty").getValue());
            iRow.getCell("entries.approveQty").setValue(iRow.getCell("entries.qty").getValue());
            managerRow.getCell("entries.approveAmount").setValue(iRow.getCell("entries.amount").getValue());
            iRow.getCell("entries.approveAmount").setValue(iRow.getCell("entries.amount").getValue());
            managerRow.getCell("entries.approveWeight").setValue(iRow.getCell("entries.weight").getValue());
            iRow.getCell("entries.approveWeight").setValue(iRow.getCell("entries.weight").getValue());
        }
        managerRow.getCell("parentSeq").setValue((Object)new Integer(iRow.getRowIndex()));
        if (managerRow.getCell("storageOrgUnit.id").getValue() != null) {
            INetOrderCollectionManagerFacade iNetOrderFacade = NetOrderCollectionManagerFacadeFactory.getRemoteInstance();
            WarehouseInfo wareHouseInfo = iNetOrderFacade.getWarehouseByStorage(managerRow.getCell("storageOrgUnit.id").getValue().toString());
            managerRow.getCell("warehouse").setValue((Object)wareHouseInfo);
            this.fullSendDate(managerRow, iNetOrderFacade);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", managerRow.getCell("storageOrgUnit.id").getValue(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("whState", (Object)"1", CompareType.EQUALS));
            ev.setFilter(filterInfo);
            managerRow.getCell("warehouse").getEditor();
            KDBizPromptBox tbManagerInfo_warehouse_PromptBox = new KDBizPromptBox();
            tbManagerInfo_warehouse_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7AllWarehouseQuery");
            tbManagerInfo_warehouse_PromptBox.setVisible(true);
            tbManagerInfo_warehouse_PromptBox.setEditable(true);
            tbManagerInfo_warehouse_PromptBox.setDisplayFormat("$name$");
            tbManagerInfo_warehouse_PromptBox.setEditFormat("$number$");
            tbManagerInfo_warehouse_PromptBox.setCommitFormat("$number$");
            tbManagerInfo_warehouse_PromptBox.setEntityViewInfo(ev);
            KDTDefaultCellEditor tbManagerInfo_warehouse_CellEditor = new KDTDefaultCellEditor((IKDEditor)tbManagerInfo_warehouse_PromptBox);
            managerRow.getCell("warehouse").setEditor((ICellEditor)tbManagerInfo_warehouse_CellEditor);
            int unitPrecision = 8;
            if (managerRow.getCell("entries.unitPrecision").getValue() != null) {
                unitPrecision = Integer.parseInt(managerRow.getCell("entries.unitPrecision").getValue().toString());
            }
            KDFormattedTextField tbManager_approveQty_TextField = new KDFormattedTextField();
            tbManager_approveQty_TextField.setName("kdtEntries_baseQty_TextField");
            tbManager_approveQty_TextField.setVisible(true);
            tbManager_approveQty_TextField.setEditable(true);
            tbManager_approveQty_TextField.setNegatived(false);
            tbManager_approveQty_TextField.setPrecision(unitPrecision);
            tbManager_approveQty_TextField.setHorizontalAlignment(2);
            tbManager_approveQty_TextField.setDataType(1);
            if (managerRow.getCell("entries.unitPrecision").getValue() != null) {
                tbManager_approveQty_TextField.setPrecision(Integer.parseInt(managerRow.getCell("entries.unitPrecision").getValue().toString()));
            } else {
                tbManager_approveQty_TextField.setPrecision(8);
            }
            KDTDefaultCellEditor kdtEntries_baseQty_CellEditor = new KDTDefaultCellEditor((JTextField)tbManager_approveQty_TextField);
            managerRow.getCell("entries.approveQty").setEditor((ICellEditor)kdtEntries_baseQty_CellEditor);
        }
    }

    @Override
    protected void tbManagerInfo_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            int rowNum = e.getRowIndex();
            this.queryInventory(rowNum);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            ev.setFilter(filterInfo);
            String saleOrgUnitId = this.tbManagerInfo.getCell(rowNum, "saleOrgUnit.id").getValue().toString();
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection collection = iOrgRelation.getFromUnit(saleOrgUnitId.toString(), 2, 4);
            StringBuffer orgIds = new StringBuffer();
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size() && collection.get(i) instanceof StorageOrgUnitInfo; ++i) {
                    orgIds.append(collection.get(i).getId().toString());
                    orgIds.append(",");
                }
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgIds.toString(), CompareType.INCLUDE));
            KDTDefaultCellEditor tbManagerInfo_storage_CellEditor = (KDTDefaultCellEditor)this.tbManagerInfo.getColumn("storageOrgUnit.number").getEditor();
            KDBizPromptBox tbManagerInfo_storage_PromptBox = (KDBizPromptBox)tbManagerInfo_storage_CellEditor.getComponent();
            tbManagerInfo_storage_PromptBox.setEntityViewInfo(ev);
        }
    }

    protected void queryInventory(int rowNum) throws BOSException, SQLException {
        this.tbInvenInfo.removeRows();
        if (this.kDCheckInv.isSelected()) {
            String materialId = this.tbManagerInfo.getCell(rowNum, "material.id").getValue().toString();
            IRowSet rs = NetOrderCollectionManagerFacadeFactory.getRemoteInstance().getInventoryInfo(materialId, this.getQueryType());
            this.fullTbInvenInfo(rs);
        }
    }

    private String getQueryType() {
        String queryType = null;
        if (this.kDCheckWareHs.isSelected()) {
            queryType = queryType + "a";
        }
        if (this.kDCheckLocation.isSelected()) {
            queryType = queryType + "b";
        }
        if (this.kDCheckLot.isSelected()) {
            queryType = queryType + "c";
        }
        return queryType;
    }

    private void fullTbInvenInfo(IRowSet rs) throws SQLException {
        int i = 0;
        IRow iRow = null;
        while (rs.next()) {
            iRow = this.tbInvenInfo.addRow();
            for (int j = 0; j < this.tbInvenInfo.getColumnCount(); ++j) {
                iRow.getCell(j).setValue((Object)rs.getString(this.tbInvenInfo.getColumnKey(j)));
            }
            ++i;
        }
    }

    private void deleteRowFromTbManager(String entryId) {
        for (int i = 0; i < this.tbManagerInfo.getRowCount(); ++i) {
            if (!entryId.equals(this.tbManagerInfo.getCell(i, "entries.id").getValue().toString())) continue;
            this.tbManagerInfo.removeRow(i);
            --i;
        }
    }

    private void kDCheckInv_StateChanged(ItemEvent arg0) {
        if (this.kDCheckInv.isSelected()) {
            this.kDCheckWareHs.setSelected(true);
            this.kDCheckWareHs.setEnabled(true);
            this.kDCheckLocation.setSelected(true);
            this.kDCheckLocation.setEnabled(true);
            this.kDCheckLot.setSelected(true);
            this.kDCheckLot.setEnabled(true);
            this.kDCheckWareHs.addItemListener((ItemListener)this.itemChangeEnvent);
            this.kDCheckLocation.addItemListener((ItemListener)this.itemChangeEnvent);
            this.kDCheckLot.addItemListener((ItemListener)this.itemChangeEnvent);
        } else {
            this.kDCheckWareHs.setSelected(false);
            this.kDCheckWareHs.setEnabled(false);
            this.kDCheckLocation.setSelected(false);
            this.kDCheckLocation.setEnabled(false);
            this.kDCheckLot.setSelected(false);
            this.kDCheckLot.setEnabled(false);
            this.kDCheckWareHs.removeItemListener((ItemListener)this.itemChangeEnvent);
            this.kDCheckLocation.removeItemListener((ItemListener)this.itemChangeEnvent);
            this.kDCheckLot.removeItemListener((ItemListener)this.itemChangeEnvent);
        }
    }

    private void kDCheckWareHs_StateChanged(ItemEvent arg0) {
        if (this.kDCheckWareHs.isSelected()) {
            this.kDCheckLocation.setEnabled(true);
        } else {
            this.kDCheckLocation.setSelected(false);
            this.kDCheckLocation.setEnabled(false);
        }
    }

    protected void checkBoxChangeToQueryInv() {
        int rowNum;
        if (this.tbManagerInfo.getSelectManager().get() != null && (rowNum = this.tbManagerInfo.getSelectManager().get().getBeginRow()) >= 0) {
            try {
                this.queryInventory(rowNum);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void tbManagerInfo_editStopped(KDTEditEvent e) throws Exception {
        if (!(e.getColIndex() != this.tbManagerInfo.getColumnIndex("entries.approveQty") || e.getOldValue() != null && e.getOldValue().equals(e.getValue()))) {
            int rowNum = e.getRowIndex();
            int parentSeq = Integer.parseInt(this.tbManagerInfo.getCell(rowNum, "parentSeq").getValue().toString());
            if (e.getValue() != null && ((BigDecimal)e.getValue()).compareTo(new BigDecimal("0")) < 0) {
                this.tbManagerInfo.getCell(rowNum, "entries.approveQty").setValue(e.getOldValue());
            } else {
                BigDecimal approveQtyTotal;
                BigDecimal weightAvg;
                int unitPrecision = this.tblMain.getCell(parentSeq, "entries.unitPrecision").getValue() != null ? Integer.parseInt(this.tblMain.getCell(parentSeq, "entries.unitPrecision").getValue().toString()) : 8;
                int currencyPrecision = this.tblMain.getCell(parentSeq, "currencyPrecision").getValue() != null ? Integer.parseInt(this.tblMain.getCell(parentSeq, "currencyPrecision").getValue().toString()) : 2;
                int weightUnitPrecision = this.tblMain.getCell(parentSeq, "entries.weightUnitPrecision").getValue() != null ? Integer.parseInt(this.tblMain.getCell(parentSeq, "entries.weightUnitPrecision").getValue().toString()) : 8;
                BigDecimal price = this.tbManagerInfo.getCell(rowNum, "entries.price").getValue() != null ? (BigDecimal)this.tbManagerInfo.getCell(rowNum, "entries.price").getValue() : new BigDecimal("0");
                if (this.tbManagerInfo.getCell(rowNum, "entries.weight").getValue() != null && this.tbManagerInfo.getCell(rowNum, "entries.qty").getValue() != null) {
                    BigDecimal weight = (BigDecimal)this.tbManagerInfo.getCell(rowNum, "entries.weight").getValue();
                    BigDecimal qty = (BigDecimal)this.tbManagerInfo.getCell(rowNum, "entries.qty").getValue();
                    weightAvg = weight.divide(qty, 8, 6);
                } else {
                    weightAvg = new BigDecimal("0");
                }
                BigDecimal approveQty = e.getValue() != null ? new BigDecimal(e.getValue().toString()) : new BigDecimal("0");
                BigDecimal approveWeight = approveQty.multiply(weightAvg);
                BigDecimal approveAmount = approveQty.multiply(price);
                this.tbManagerInfo.getCell(rowNum, "entries.approveAmount").setValue((Object)approveAmount.setScale(currencyPrecision, 4));
                this.tbManagerInfo.getCell(rowNum, "entries.approveWeight").setValue((Object)approveWeight.setScale(weightUnitPrecision, 4));
                if (this.tblMain.getCell(parentSeq, "entries.approveQty").getValue() != null) {
                    BigDecimal approveQty_tblMain = (BigDecimal)this.tblMain.getCell(parentSeq, "entries.approveQty").getValue();
                    BigDecimal approveQtyOld = new BigDecimal(e.getOldValue() == null ? "0" : e.getOldValue().toString());
                    approveQtyTotal = approveQty.subtract(approveQtyOld).add(approveQty_tblMain);
                } else {
                    approveQtyTotal = approveQty;
                }
                BigDecimal approveWeightTotal = approveQtyTotal.multiply(weightAvg);
                BigDecimal approveAmountTotal = approveQtyTotal.multiply(price);
                this.tblMain.getCell(parentSeq, "entries.approveQty").setValue((Object)approveQtyTotal.setScale(unitPrecision, 4));
                this.tblMain.getCell(parentSeq, "entries.approveAmount").setValue((Object)approveAmountTotal.setScale(currencyPrecision, 4));
                this.tblMain.getCell(parentSeq, "entries.approveWeight").setValue((Object)approveWeightTotal.setScale(weightUnitPrecision, 4));
            }
        } else if (!(e.getColIndex() != this.tbManagerInfo.getColumnIndex("storageOrgUnit.number") || e.getOldValue() != null && e.getOldValue().equals(e.getValue()))) {
            ((StorageOrgUnitInfo)e.getValue()).setDisplayFormat("$number$");
            String storageOrgUnitName = ((StorageOrgUnitInfo)e.getValue()).getName();
            this.tbManagerInfo.getCell(e.getRowIndex(), "storageOrgUnit.name").setValue((Object)storageOrgUnitName);
            this.tbManagerInfo.getCell(e.getRowIndex(), "warehouse").setValue(null);
            if (e.getValue() != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemInfo filterItemInfo = new FilterItemInfo("storageOrg.id", (Object)((StorageOrgUnitInfo)e.getValue()).getId());
                filterInfo.getFilterItems().add(new FilterItemInfo("whState", (Object)"1", CompareType.EQUALS));
                filterInfo.getFilterItems().add(filterItemInfo);
                view.setFilter(filterInfo);
                KDBizPromptBox warehouse = (KDBizPromptBox)this.tbManagerInfo.getCell(e.getRowIndex(), "warehouse").getEditor().getComponent();
                warehouse.setEntityViewInfo(view);
            }
        }
    }

    @Override
    protected void BtnSplitRow_mouseClicked(MouseEvent e) throws Exception {
        IRow newRow = null;
        IRow selectRow = this.tbManagerInfo.getRow(this.getTbManagerInfoSelectRow());
        newRow = (IRow)selectRow.clone();
        newRow.getCell("entries.approveQty").setValue((Object)new BigDecimal("0.0"));
        newRow.getCell("entries.approveAmount").setValue((Object)new BigDecimal("0.0"));
        newRow.getCell("entries.approveWeight").setValue((Object)new BigDecimal("0.0"));
        this.tbManagerInfo.addRow(this.getTbManagerInfoSelectRow() + 1, newRow);
    }

    private int getTbManagerInfoSelectRow() {
        int beginRow = -1;
        int endRow = -1;
        if (this.tbManagerInfo.getSelectManager().get() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"15_NetOrderCollectionManagerUI"));
            SysUtil.abort();
        }
        beginRow = this.tbManagerInfo.getSelectManager().get().getBeginRow();
        endRow = this.tbManagerInfo.getSelectManager().get().getEndRow();
        if (endRow - beginRow > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"16_NetOrderCollectionManagerUI"));
            SysUtil.abort();
        }
        return beginRow;
    }

    @Override
    public void createToSaleOrder_actionPerformed(ActionEvent e) throws Exception {
        this.checkCondition();
        this.createToSaleOrder();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"17_NetOrderCollectionManagerUI"));
        this.refreshList();
    }

    private void createToSaleOrder() throws EASBizException, BOSException {
        int rowCount = this.tbManagerInfo.getRowCount();
        NetOrderBillEntryInfo netOrderBillEntry = null;
        AbstractNetOrderBillEntryInfo oldOrderBillEntry = null;
        HashMap<String, String> alreadyCreate = new HashMap<String, String>();
        NetOrderBillEntryCollection netOrderBillEntryColl = new NetOrderBillEntryCollection();
        NetOrderBillEntryCollection splitNetOrderBillEntryColl = new NetOrderBillEntryCollection();
        String channelId = null;
        for (int j = 0; j < rowCount; ++j) {
            channelId = this.tbManagerInfo.getCell(j, "channel.id").getValue().toString();
            if (alreadyCreate.containsKey(channelId)) continue;
            netOrderBillEntryColl.clear();
            splitNetOrderBillEntryColl.clear();
            alreadyCreate.put(channelId, String.valueOf(j));
            String saleOrgId = null;
            for (int i = j; i < rowCount; ++i) {
                if (i != 0 && !this.tbManagerInfo.getCell(i, "channel.id").getValue().toString().equals(channelId)) continue;
                saleOrgId = this.tbManagerInfo.getCell(i, "saleOrgUnit.id").getValue().toString();
                netOrderBillEntry = this.createEntryInfo(i, new NetOrderBillEntryInfo());
                if (i != 0 && oldOrderBillEntry != null && oldOrderBillEntry.getId().toString().equals(netOrderBillEntry.getId().toString())) {
                    netOrderBillEntry.setSourceBillEntryId(oldOrderBillEntry.getId().toString());
                    splitNetOrderBillEntryColl.addObjectDirect((IObjectValue)netOrderBillEntry);
                } else {
                    netOrderBillEntryColl.add(netOrderBillEntry);
                }
                oldOrderBillEntry = netOrderBillEntry;
            }
            if (netOrderBillEntryColl == null) continue;
            try {
                ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                SCMClientUtils.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(saleOrgId), (String)"saleorder_addnew");
                INetOrderCollectionManagerFacade INetOrder = NetOrderCollectionManagerFacadeFactory.getRemoteInstance();
                CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
                INetOrder.dealNetOrderBill(netOrderBillEntryColl, cuInfo, splitNetOrderBillEntryColl);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"18_NetOrderCollectionManagerUI"));
                SysUtil.abort();
                continue;
            }
            catch (BOTPException e) {
                logger.error((Object)e);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"19_NetOrderCollectionManagerUI"));
                SysUtil.abort();
                continue;
            }
            catch (NetOrderManagerException e) {
                logger.error((Object)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
                continue;
            }
            catch (BTPException e) {
                logger.error((Object)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
                continue;
            }
            catch (PriceParamException e) {
                logger.error((Object)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
        }
    }

    private NetOrderBillEntryInfo createEntryInfo(int rowNum, NetOrderBillEntryInfo netOrderBillEntry) throws BOSException {
        netOrderBillEntry.setId(BOSUuid.read((String)this.tbManagerInfo.getCell(rowNum, "entries.id").getValue().toString()));
        netOrderBillEntry.setAddress(this.tbManagerInfo.getCell(rowNum, "id").getValue().toString());
        Date askArriveDate = (Date)this.tbManagerInfo.getCell(rowNum, "entries.askArriveDate").getValue();
        Date sendDate = (Date)this.tbManagerInfo.getCell(rowNum, "sendDate").getValue();
        netOrderBillEntry.setSendDate(sendDate);
        netOrderBillEntry.setAskArriveDate(askArriveDate);
        BigDecimal approveQty = new BigDecimal(this.tbManagerInfo.getCell(rowNum, "entries.approveQty").getValue().toString());
        netOrderBillEntry.setApproveQty(approveQty);
        WarehouseInfo warehouseInfo = (WarehouseInfo)this.tbManagerInfo.getCell(rowNum, "warehouse").getValue();
        netOrderBillEntry.setWarehouse(warehouseInfo);
        Object storeOrgValue = this.tbManagerInfo.getCell(rowNum, "storageOrgUnit.number").getValue();
        if (storeOrgValue instanceof StorageOrgUnitInfo) {
            netOrderBillEntry.setStorageOrgUnit((StorageOrgUnitInfo)storeOrgValue);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)storeOrgValue.toString(), CompareType.EQUALS));
            StorageOrgUnitCollection storageOrgUnitCollection = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
            netOrderBillEntry.setStorageOrgUnit(storageOrgUnitCollection.get(0));
        }
        return netOrderBillEntry;
    }

    private void checkCondition() throws BOSException, EASBizException {
        int result;
        if (this.tbManagerInfo.getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"22_NetOrderCollectionManagerUI"));
            SysUtil.abort();
        }
        int parentRow = -1;
        StringBuffer warningMessger = new StringBuffer();
        BigDecimal approveQty = new BigDecimal("0.0");
        BigDecimal qty = new BigDecimal("0.0");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer warningMessgerSendDate = new StringBuffer();
        StringBuffer warningMessgerApproveQty = new StringBuffer();
        for (int i = 0; i < this.tbManagerInfo.getRowCount(); ++i) {
            parentRow = Integer.parseInt(this.tbManagerInfo.getCell(i, "parentSeq").getValue().toString());
            approveQty = (BigDecimal)this.tblMain.getCell(parentRow, "entries.approveQty").getValue();
            qty = (BigDecimal)this.tblMain.getCell(parentRow, "entries.qty").getValue();
            if (approveQty == null || approveQty.compareTo(qty) == 1) {
                warningMessger.append(i + 1 + ",");
            }
            if (this.tbManagerInfo.getCell(i, "storageOrgUnit.number").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"25_NetOrderCollectionManagerUI"), new Integer(i + 1).toString()));
                SysUtil.abort();
            }
            if (this.tbManagerInfo.getCell(i, "entries.approveQty").getValue() != null) {
                BigDecimal approveQtyto = (BigDecimal)this.tbManagerInfo.getCell(i, "entries.approveQty").getValue();
                if (approveQtyto.compareTo(new BigDecimal("0.0")) == 0) {
                    warningMessgerApproveQty.append(i + 1 + ",");
                }
            } else {
                warningMessgerApproveQty.append(i + 1 + ",");
            }
            Date deliveryDate = (Date)this.tbManagerInfo.getCell(i, "entries.askArriveDate").getValue();
            Date sendDate = (Date)this.tbManagerInfo.getCell(i, "sendDate").getValue();
            if (deliveryDate == null || sendDate == null || sdf.format(deliveryDate).compareTo(sdf.format(sendDate)) >= 0) continue;
            warningMessgerSendDate.append(i + 1 + ",");
        }
        if (warningMessgerApproveQty.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"38_APPROVEQTYNOTZERO"), warningMessgerApproveQty.deleteCharAt(warningMessgerApproveQty.length() - 1)));
            SysUtil.abort();
        }
        if (warningMessgerSendDate.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"37_SENDDATECANNOTGTDELIVERYDATE"), warningMessgerSendDate.deleteCharAt(warningMessgerSendDate.length() - 1)));
            SysUtil.abort();
        }
        if (warningMessger.length() > 0 && (result = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"23_NetOrderCollectionManagerUI"), warningMessger.deleteCharAt(warningMessger.length() - 1)))) == 2) {
            SysUtil.abort();
        }
    }

    protected boolean hasCodingRule(IObjectValue caller, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(caller, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId();
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(caller, companyId);
        }
        catch (Exception err) {
            return false;
        }
    }

    protected String getNextCompanyId() throws Exception {
        CompanyOrgUnitInfo comInfo = null;
        OrgUnitInfo rootCU = NewOrgUnitHelper.getRootCU();
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        if (rootCU.isIsCompanyOrgUnit()) {
            comInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCU.getId()));
        }
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setHiddenTableCols(new String[]{"isFightBack", "fightBackReason"});
        this.commonQueryDialog.setProcessor((IProcessor)new ChannelCommonQueryProcessor());
        this.commonQueryDialog.setWidth(490);
        return this.commonQueryDialog;
    }

    @Override
    public void actionFightBack_actionPerformed(ActionEvent e) throws Exception {
        Object reasonCodeInfo;
        Set netorderIDSet = NetOrderHelper.getAvailableNetOrderIdSet(this.tblMain, "fightback");
        if (netorderIDSet.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"36_NetOrderCollectionManagerMainUI"));
            SysUtil.abort();
        }
        if ((reasonCodeInfo = NetOrderHelper.showReasonWindow(netorderIDSet, (ListUI)this)) == null) {
            SysUtil.abort();
        }
        NetOrderHelper.doFightBack(netorderIDSet, reasonCodeInfo, (ListUI)this);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return NetOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new NetOrderCollectionManagerFilterUI();
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private FilterInfo getPremissionFilterByMainOrg() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.listSaleOrg == null && this.iBiz == null) {
            try {
                this.listSaleOrg = new LinkedHashSet();
                this.iBiz = NetOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                this.authorizedMainOrgs = this.iBiz.getAuthOrgsByType(OrgType.Sale, this.mainQueryPK);
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    this.listSaleOrg.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        if (this.listSaleOrg == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHANNEL_CLIENT_Resource, (String)"0_ChannelInwarehsBillListUI"));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.listSaleOrg, CompareType.INCLUDE));
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilterInfo = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = this.getPremissionFilterByMainOrg();
        FilterInfo aFilterInfo = new FilterInfo();
        aFilterInfo.getFilterItems().add(new FilterItemInfo("entries.entryStatus", (Object)new Integer(4)));
        aFilterInfo.getFilterItems().add(new FilterItemInfo("entries.entryStatus", (Object)new Integer(8)));
        aFilterInfo.setMaskString("#0 OR #1");
        if (defaultFilterInfo != null) {
            try {
                defaultFilterInfo.mergeFilter(filterInfo, "and");
                defaultFilterInfo.mergeFilter(aFilterInfo, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            defaultFilterInfo = filterInfo;
            try {
                defaultFilterInfo.mergeFilter(aFilterInfo, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return defaultFilterInfo;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Boolean select = (Boolean)this.tblMain.getCell(i, "isSelect").getValue();
            if (select.booleanValue()) continue;
            this.tblMain.getCell(i, "isSelect").setValue((Object)Boolean.TRUE);
            this.fullManagerTable(this.tblMain.getRow(i));
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "isSelect").setValue((Object)Boolean.FALSE);
            this.deleteRowFromTbManager(this.tblMain.getCell(i, "entries.id").getValue().toString());
        }
    }

    private class ItemChangeEnvent
    implements ItemListener {
        private ItemChangeEnvent() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            Object source = arg0.getSource();
            NetOrderCollectionManagerUI.this.tbInvenInfo.refresh();
            try {
                if (source.equals(NetOrderCollectionManagerUI.this.kDCheckInv)) {
                    NetOrderCollectionManagerUI.this.kDCheckInv_StateChanged(arg0);
                } else if (source.equals(NetOrderCollectionManagerUI.this.kDCheckWareHs)) {
                    NetOrderCollectionManagerUI.this.kDCheckWareHs_StateChanged(arg0);
                }
            }
            catch (Exception ex) {
                NetOrderCollectionManagerUI.this.handUIException(ex);
            }
            if (NetOrderCollectionManagerUI.this.kDCheckInv.isSelected()) {
                NetOrderCollectionManagerUI.this.checkBoxChangeToQueryInv();
            }
        }
    }
}

