/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.client.MaterialSelectorFactory;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.IChannelBase;
import com.kingdee.eas.basedata.scm.sd.channel.util.CalendarUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.NetOrderBillCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillSimpleStatusEnum;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class NetOrderFilterUI
extends AbstractNetOrderFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(NetOrderFilterUI.class);
    private OrgUnitInfo[] authStorageOrgs = null;
    private Set listAuthStorageOrg = null;

    public void onLoad() throws Exception {
        this.initAuthStorageOrgs();
        super.onLoad();
        this.getContextObject();
        this.registListenter();
        this.mainOrgChanged();
    }

    private void initAuthStorageOrgs() {
        try {
            this.authStorageOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Storage, null);
            if (this.authStorageOrgs != null && this.authStorageOrgs.length > 0) {
                String ids = SCMGroupClientUtils.getKeyIdList((ObjectBaseInfo[])this.authStorageOrgs, (String)";");
                String[] idsArray = ids.split(";");
                this.listAuthStorageOrg = new LinkedHashSet(idsArray.length);
                for (int i = 0; i < idsArray.length; ++i) {
                    this.listAuthStorageOrg.add(idsArray[i]);
                }
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorage;
    }

    protected void setDefaultValue() {
        try {
            this.initOrgF7();
            this.initkDDate();
            this.initPrmtChannel();
            this.initMaterial();
            this.initPrmtNumberFrom();
            this.initPrmtNumberTo();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initOrgF7() {
        this.prmtStorage.setEnabledMultiSelection(true);
        this.setBizOrgF7ByType(this.prmtSale, OrgType.Sale, OrgType.Storage, true);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtSale});
    }

    private void initMaterial() {
        OrgUnitInfo mainOrg = null;
        if (this.getMainBizOrgs() != null) {
            mainOrg = this.getMainBizOrgs().get(0);
        }
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setDisplayFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$;$name$;$model$;$helpCode$");
        SCMGroupClientUtils.setBizMaterialF7((KDBizPromptBox)this.prmtMaterial, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (boolean)true, null);
        this.prmtMaterial.setEnabledMultiSelection(true);
        SelectorItemCollection selectors = this.prmtMaterial.getSelectorCollection();
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("baseUnit.id"));
        selectors.add(new SelectorItemInfo("baseUnit.number"));
        selectors.add(new SelectorItemInfo("baseUnit.name"));
        selectors.add(new SelectorItemInfo("assistUnit.id"));
        selectors.add(new SelectorItemInfo("assistUnit.number"));
        selectors.add(new SelectorItemInfo("assistUnit.name"));
        selectors.addObjectCollection((IObjectCollection)MaterialSelectorFactory.getSelectors());
        this.prmtMaterial.setSelectorCollection(selectors);
        SCMGroupClientUtils.setApproved4MaterialF7((KDBizPromptBox)this.prmtMaterial, (OrgType)this.getMainBizOrgType());
        if (mainOrg != null) {
            this.prmtMaterial.setCurrentMainBizOrgUnit(mainOrg, this.getMainBizOrgType());
        }
    }

    private void initkDDate() {
        Date date = new Date();
        this.kDDateFrom.setValue((Object)CalendarUtil.getRecentOneMonth((Date)date, (int)-1));
        this.kDDateTo.setValue((Object)date);
    }

    private Object[] getStorageObj() {
        Object[] storageObj = null;
        storageObj = this.prmtStorage.getData() instanceof StorageOrgUnitInfo ? new Object[]{this.prmtStorage.getData()} : (Object[])this.prmtStorage.getData();
        return storageObj;
    }

    private void prmtSale_willShow() throws Exception {
    }

    private void initPrmtSale() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorage.getData();
        OrgUnitCollection orgUnitCon = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)storage.getId());
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < orgUnitCon.size(); ++i) {
            idSet.add(orgUnitCon.get(i).getId().toString());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        this.prmtSale.setEntityViewInfo(ev);
    }

    private void prmtChannel_willShow() throws Exception {
        this.initPrmtChannel();
    }

    private void initPrmtChannel() throws EASBizException, BOSException {
        EntityViewInfo evChannel = new EntityViewInfo();
        FilterInfo filterChannel = new FilterInfo();
        if (this.getSaleIds() != null) {
            filterChannel.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
            evChannel.setFilter(filterChannel);
            this.prmtChannel.setEntityViewInfo(evChannel);
        } else {
            FilterItemInfo fiterSale;
            Object[] storageObj = this.getStorageObj();
            if (storageObj != null && storageObj.length > 0 && null != (fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id"))) {
                filterChannel.getFilterItems().add(fiterSale);
                evChannel.setFilter(filterChannel);
                this.prmtChannel.setEntityViewInfo(evChannel);
            }
        }
    }

    private void prmtNumberFrom_willShow() throws Exception {
        this.initPrmtNumberFrom();
    }

    private void initPrmtNumberFrom() throws EASBizException, BOSException {
        EntityViewInfo evNumber = new EntityViewInfo();
        FilterInfo filterNumber = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            Date startDate = (Date)this.kDDateFrom.getValue();
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SCMUtils.getDayStartTime((Date)startDate), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            Date endDate = CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1);
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SCMUtils.getDayEndTime((Date)endDate), CompareType.LESS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        }
        if (this.getSaleIds() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
            evNumber.setFilter(filterNumber);
            this.prmtNumberFrom.setEntityViewInfo(evNumber);
        } else {
            FilterItemInfo fiterSale;
            Object[] storageObj = this.getStorageObj();
            if (storageObj != null && storageObj.length > 0 && null != (fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id"))) {
                filterNumber.getFilterItems().add(fiterSale);
                evNumber.setFilter(filterNumber);
                this.prmtNumberFrom.setEntityViewInfo(evNumber);
            }
        }
    }

    private void prmtNumberTo_willShow() throws Exception {
        this.initPrmtNumberTo();
    }

    private void initPrmtNumberTo() throws EASBizException, BOSException {
        EntityViewInfo evNumber = new EntityViewInfo();
        FilterInfo filterNumber = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            Date startDate = (Date)this.kDDateFrom.getValue();
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SCMUtils.getDayStartTime((Date)startDate), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            Date endDate = CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1);
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SCMUtils.getDayEndTime((Date)endDate), CompareType.LESS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        }
        if (this.getSaleIds() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
            evNumber.setFilter(filterNumber);
            this.prmtNumberTo.setEntityViewInfo(evNumber);
        } else {
            FilterItemInfo fiterSale;
            Object[] storageObj = this.getStorageObj();
            if (storageObj != null && storageObj.length > 0 && null != (fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id"))) {
                filterNumber.getFilterItems().add(fiterSale);
                evNumber.setFilter(filterNumber);
                this.prmtNumberTo.setEntityViewInfo(evNumber);
            }
        }
    }

    private FilterItemInfo getViewWithSaleNotSeletcted(String selectColum) throws EASBizException, BOSException {
        Set idSet = this.getSaleIdsByStorage();
        if (idSet.size() > 0) {
            return new FilterItemInfo(selectColum, (Object)idSet, CompareType.INCLUDE);
        }
        return null;
    }

    private Set getSaleIdsByStorage() throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Object[] storageObj = this.getStorageObj();
        OrgUnitCollection orgUnitCon = new OrgUnitCollection();
        OrgUnitCollection tempOrgUnitCon = null;
        if (storageObj != null) {
            for (int i = 0; i < storageObj.length; ++i) {
                if (storageObj[i] != null) {
                    tempOrgUnitCon = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)((AbstractDataBaseInfo)storageObj[i]).getId());
                }
                if (null == tempOrgUnitCon || tempOrgUnitCon.size() <= 0) continue;
                orgUnitCon.addCollection(tempOrgUnitCon);
            }
        }
        for (int j = 0; j < orgUnitCon.size(); ++j) {
            idSet.add(orgUnitCon.get(j).getId().toString());
        }
        return idSet;
    }

    private void registListenter() {
        this.prmtStorage.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderFilterUI.this.prmtSale.setData(null);
                NetOrderFilterUI.this.prmtChannel.setData(null);
                NetOrderFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderFilterUI.this.prmtNumberTo.setData(null);
                try {
                    NetOrderFilterUI.this.prmtChannel_willShow();
                    NetOrderFilterUI.this.prmtNumberFrom_willShow();
                    NetOrderFilterUI.this.prmtNumberTo_willShow();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        });
        this.prmtSale.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderFilterUI.this.prmtChannel.setData(null);
                NetOrderFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderFilterUI.this.prmtNumberTo.setData(null);
                try {
                    NetOrderFilterUI.this.prmtChannel_willShow();
                    NetOrderFilterUI.this.prmtNumberFrom_willShow();
                    NetOrderFilterUI.this.prmtNumberTo_willShow();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        });
        this.kDDateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderFilterUI.this.prmtNumberTo.setData(null);
                try {
                    NetOrderFilterUI.this.prmtNumberFrom_willShow();
                    NetOrderFilterUI.this.prmtNumberTo_willShow();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        });
        this.kDDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderFilterUI.this.prmtNumberTo.setData(null);
                try {
                    NetOrderFilterUI.this.prmtNumberFrom_willShow();
                    NetOrderFilterUI.this.prmtNumberTo_willShow();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        });
    }

    public void clear() {
        this.setAuthorizedMainOrgs(null);
        super.clear();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        try {
            NetOrderBillCollection netOrderBillCollection = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = null;
            this.kDDateFrom.setValue(null);
            this.kDDateTo.setValue(null);
            this.prmtStorage.setData(null);
            this.prmtChannel.setData(null);
            this.prmtSale.setData(null);
            this.cbxBillStatus.setSelectedItem(null);
            this.prmtNumberFrom.setData(null);
            this.prmtNumberTo.setData(null);
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    this.kDDateFrom.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate") && filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) {
                    this.kDDateTo.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("storageOrgUnit.id") && filterItemInfo.getCompareValue() != null) {
                    this.prmtStorage.setValue((Object)this.getStorageDataByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("saleOrgUnit.id")) {
                    this.prmtSale.setData((Object)this.getSaleOrgUnitDataByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("channel.id") && filterItemInfo.getCompareValue() != null) {
                    this.prmtChannel.setValue((Object)this.getChannelByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("number") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString()));
                    ev.setFilter(filterInfo);
                    netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(ev);
                    this.prmtNumberFrom.setValue((Object)netOrderBillCollection.get(0));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("number") && filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString()));
                    ev.setFilter(filterInfo);
                    netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(ev);
                    this.prmtNumberTo.setValue((Object)netOrderBillCollection.get(0));
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equalsIgnoreCase("billStatus") || filterItemInfo.getCompareValue() == null) continue;
                this.cbxBillStatus.setSelectedItem((Object)NetOrderBillSimpleStatusEnum.getEnum(Integer.parseInt(filterItemInfo.getCompareValue().toString())));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Object[] getChannelByIds(String channelIds) {
        if (channelIds != null && (channelIds.indexOf("[") > 0 || channelIds.indexOf("]") > 0)) {
            channelIds = channelIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = channelIds.split(",");
        Object[] channelData = new Object[pks.length];
        IChannelBase iChannel = null;
        try {
            iChannel = ChannelBaseFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                channelData[i] = iChannel.getChannelBaseInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return channelData;
    }

    public FilterInfo getFilterInfo() {
        NetOrderBillSimpleStatusEnum billStatus;
        FilterInfo filterInfo = new FilterInfo();
        this.filterInfo.resetValue();
        if (this.kDDateFrom.getValue() != null) {
            Date startDate = (Date)this.kDDateFrom.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SCMUtils.getDayStartTime((Date)startDate), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            Date endDate = CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1);
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SCMUtils.getDayEndTime((Date)endDate), CompareType.LESS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        }
        if (this.getSaleIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
        }
        if (this.getChannelIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("channel.id", (Object)this.getChannelIds(), CompareType.INCLUDE));
        }
        if (this.getMaterialIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.material.id", (Object)this.getMaterialIds(), CompareType.INCLUDE));
        }
        if (this.prmtNumberFrom.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)((NetOrderBillInfo)this.prmtNumberFrom.getValue()).getNumber(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtNumberTo.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)((NetOrderBillInfo)this.prmtNumberTo.getValue()).getNumber(), CompareType.LESS_EQUALS));
        }
        if (this.cbxBillStatus.getSelectedItem() != null && this.cbxBillStatus.getSelectedItem() instanceof NetOrderBillSimpleStatusEnum && !(billStatus = (NetOrderBillSimpleStatusEnum)((Object)this.cbxBillStatus.getSelectedItem())).equals((Object)NetOrderBillSimpleStatusEnum.NULL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(billStatus.getValue())));
        }
        return filterInfo;
    }

    private String getSaleIds() {
        StringBuffer saleIds = new StringBuffer();
        Object[] sale = (Object[])this.prmtSale.getData();
        if (sale == null || sale.length < 1 || sale.length == 1 && sale[0] == null) {
            return null;
        }
        for (int i = 0; i < sale.length; ++i) {
            saleIds.append(((AbstractDataBaseInfo)sale[i]).getId());
            saleIds.append(",");
        }
        saleIds.deleteCharAt(saleIds.length() - 1);
        return saleIds.toString();
    }

    private String getMaterialIds() {
        StringBuffer materialIds = new StringBuffer();
        Object[] material = (Object[])this.prmtMaterial.getData();
        if (material == null || material.length < 1 || material.length == 1 && material[0] == null) {
            return null;
        }
        for (int i = 0; i < material.length; ++i) {
            materialIds.append(((AbstractDataBaseInfo)material[i]).getId());
            materialIds.append(",");
        }
        materialIds.deleteCharAt(materialIds.length() - 1);
        return materialIds.toString();
    }

    private String getChannelIds() {
        StringBuffer channelIds = new StringBuffer();
        Object[] channel = (Object[])this.prmtChannel.getData();
        if (channel == null || channel.length < 1 || channel.length == 1 && channel[0] == null) {
            return null;
        }
        for (int i = 0; i < channel.length; ++i) {
            channelIds.append(((AbstractDataBaseInfo)channel[i]).getId());
            channelIds.append(",");
        }
        channelIds.deleteCharAt(channelIds.length() - 1);
        return channelIds.toString();
    }

    private String getStorageId() {
        StringBuffer storageIds = new StringBuffer();
        Object[] storageObj = this.getStorageObj();
        if (storageObj == null || storageObj.length < 1 || storageObj.length == 1 && storageObj[0] == null) {
            return null;
        }
        for (int i = 0; i < storageObj.length; ++i) {
            storageIds.append(((AbstractDataBaseInfo)storageObj[i]).getId());
            storageIds.append(",");
        }
        storageIds.deleteCharAt(storageIds.length() - 1);
        return storageIds.toString();
    }

    public boolean verify() {
        if (this.getStorageId() == null || this.getStorageId().trim().length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"7_NetOrderCollectionManagerConditionPanelUI"));
            return false;
        }
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.kDDateFrom.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.kDDateTo.getValue()));
        if (dateFrom != null && dateTo != null && ((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.report.SDReportResource", (String)"END_LATE_NOW"));
            this.kDDateTo.requestFocus();
            return false;
        }
        return true;
    }

    private Object[] getStorageDataByIds(String storageIds) {
        if (storageIds != null && (storageIds.indexOf("[") > 0 || storageIds.indexOf("]") > 0)) {
            storageIds = storageIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = storageIds.split(",");
        Object[] storageData = new Object[pks.length];
        IStorageOrgUnit iStorageOrgUnit = null;
        try {
            iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                storageData[i] = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return storageData;
    }

    private Object[] getSaleOrgUnitDataByIds(String saleOrgIds) {
        if (saleOrgIds != null && (saleOrgIds.indexOf("[") > 0 || saleOrgIds.indexOf("]") > 0)) {
            saleOrgIds = saleOrgIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = saleOrgIds.split(",");
        Object[] saleOrgData = new Object[pks.length];
        ISaleOrgUnit iSaleOrgUnit = null;
        try {
            iSaleOrgUnit = SaleOrgUnitFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                saleOrgData[i] = iSaleOrgUnit.getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return saleOrgData;
    }

    protected String getViewPermission() {
        return "";
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

