/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.fi.arap.api.IArapBillEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.AP2SubOrderWriteBackHandler;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.scm.common.security.util.SCMSqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AP2PIWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.AP2PIWriteBackHandler");
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";
    protected HashMap paramKeyMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        block30: {
            String coreBillTypeID;
            IObjectCollection otherBillEntryCollection;
            IArApBillHeadInfo otherBillInfo;
            block29: {
                Statement pstmt;
                block28: {
                    if (destBillInfo == null) {
                        return;
                    }
                    if (destBillInfo.getInt("billType") == 203) {
                        return;
                    }
                    otherBillInfo = (IArApBillHeadInfo)destBillInfo;
                    otherBillEntryCollection = otherBillInfo.getEntries();
                    HashSet<String> headIDSet = new HashSet<String>();
                    HashSet<String> entryIDSet = new HashSet<String>();
                    HashSet<String> sourceEntryIDSet = new HashSet<String>();
                    boolean isWriteBackOrder = false;
                    coreBillTypeID = null;
                    int size = otherBillEntryCollection.size();
                    for (int i = 0; i < size; ++i) {
                        IArapBillEntryInfo entry = (IArapBillEntryInfo)otherBillEntryCollection.getObject(i);
                        headIDSet.add(entry.getCoreBillId());
                        entryIDSet.add(entry.getCoreBillEntryId());
                        sourceEntryIDSet.add(entry.getSourceBillEntryId());
                        coreBillTypeID = entry.getCoreBillTypeId();
                        isWriteBackOrder = "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeID) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(coreBillTypeID) || coreBillTypeID == null;
                    }
                    SCMServerUtil.addSQLLock((Context)ctx, sourceEntryIDSet);
                    if (bizAction != BizActionEnum.AUDIT) break block29;
                    boolean[] isWriteCore = new boolean[]{true, false, false, false, false};
                    if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                        this.paramKeyMap.put("PURSUP006", otherBillInfo.getCompany().getId());
                        this.paramKeyMap.put("AP_QTY_GT_PO", otherBillInfo.getCompany().getId());
                        this.paramKeyMap.put("AP_OTHERBILL_QtyOverSource", otherBillInfo.getCompany().getId());
                        this.paramKeyMap = AP2PIWriteBackHandler.getParamHashMap(ctx, this.paramKeyMap);
                    }
                    this.verifyCentralBalance(ctx, otherBillInfo.getId().toString(), this.getBooleanParamValue(ctx, "PURSUP006"));
                    this.writeBackPurInWarehsBill(ctx, otherBillInfo, this.getBooleanParamValue(ctx, "PURSUP006"));
                    PurOrderCollection poCollection = new PurOrderCollection();
                    PurOrderEntryCollection poeCollection = new PurOrderEntryCollection();
                    pstmt = null;
                    try {
                        if (isWriteBackOrder) {
                            EntityViewInfo headView = new EntityViewInfo();
                            headView.getSelector().add(new SelectorItemInfo("companyOrgUnit"));
                            headView.getSelector().add(new SelectorItemInfo("number"));
                            headView.getSelector().add(new SelectorItemInfo("isCentralBalance"));
                            FilterInfo headFilter = new FilterInfo();
                            headFilter.getFilterItems().add(new FilterItemInfo("id", headIDSet, CompareType.INCLUDE));
                            headView.setFilter(headFilter);
                            poCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(headView);
                            EntityViewInfo entryView = new EntityViewInfo();
                            entryView.getSelector().add(new SelectorItemInfo("*"));
                            FilterInfo entryFilter = new FilterInfo();
                            entryFilter.getFilterItems().add(new FilterItemInfo("id", entryIDSet, CompareType.INCLUDE));
                            entryView.setFilter(entryFilter);
                            poeCollection = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(entryView);
                            pstmt = this.con.prepareStatement("update t_sm_purOrderEntry set FTotalInvoicedQty =?, FTotalInvoicedAmount=?, FTotalInvoicedBaseQty=?,FAssociateQty=? where FID=?");
                        }
                        boolean fBatch = false;
                        int size2 = otherBillEntryCollection.size();
                        for (int i = 0; i < size2; ++i) {
                            IArapBillEntryInfo otherBillentryInfo = (IArapBillEntryInfo)otherBillEntryCollection.getObject(i);
                            if (otherBillentryInfo == null) continue;
                            coreBillTypeID = otherBillentryInfo.getCoreBillTypeId();
                            if (coreBillTypeID != null) {
                                if (coreBillTypeID.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                                    isWriteCore[2] = true;
                                } else if (coreBillTypeID.equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
                                    isWriteCore[3] = true;
                                } else if (!coreBillTypeID.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=") && coreBillTypeID.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                                    fBatch = this.writeBackOrder(ctx, this.con, (PreparedStatement)pstmt, otherBillentryInfo, otherBillInfo, poCollection, poeCollection) || fBatch;
                                }
                            } else {
                                boolean bl = fBatch = this.writeBackOrder(ctx, this.con, (PreparedStatement)pstmt, otherBillentryInfo, otherBillInfo, poCollection, poeCollection) || fBatch;
                            }
                            if (coreBillTypeID == null || !coreBillTypeID.equals("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=")) continue;
                            isWriteCore[4] = true;
                        }
                        if (pstmt != null && fBatch) {
                            pstmt.executeBatch();
                        }
                        if (isWriteCore[4]) {
                            this.writeBackSubOrder(ctx, bizAction, otherBillInfo);
                        }
                        if (isWriteCore[3]) {
                            this.writeBackPurReturns(bizAction, ctx, otherBillInfo.getId().toString());
                        }
                        Boolean flag = this.isCentralBalance(ctx, otherBillInfo.getId().toString());
                        if (!isWriteCore[2] || flag.booleanValue()) break block28;
                        SCMServerUtil.addSQLLock((Context)ctx, entryIDSet);
                        boolean isPurInvSysParam = this.getBooleanParamValue(ctx, "PURSUP006");
                        this.writeBackPurOrder(bizAction, ctx, otherBillInfo.getId().toString(), isPurInvSysParam);
                        boolean isApQtyGtPoSysParam = this.getBooleanParamValue(ctx, "AP_QTY_GT_PO");
                        this.verify(ctx, otherBillInfo.getId().toString(), isPurInvSysParam, isApQtyGtPoSysParam);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt);
                break block30;
            }
            if (bizAction == BizActionEnum.UNAUDIT) {
                boolean[] isWriteCore = new boolean[]{true, false, false, false, false};
                int size = otherBillEntryCollection.size();
                for (int i = 0; i < size; ++i) {
                    IArapBillEntryInfo otherBillentryInfo = (IArapBillEntryInfo)otherBillEntryCollection.getObject(i);
                    if (otherBillentryInfo == null) continue;
                    this.unAduitWriteBackPurInWarehsBill(ctx, otherBillentryInfo, otherBillInfo);
                    coreBillTypeID = otherBillentryInfo.getCoreBillTypeId();
                    if (coreBillTypeID != null) {
                        if (coreBillTypeID.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                            isWriteCore[1] = true;
                            continue;
                        }
                        if (coreBillTypeID.equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
                            isWriteCore[2] = true;
                            continue;
                        }
                        if (coreBillTypeID.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) continue;
                        if (coreBillTypeID.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                            isWriteCore[1] = true;
                            continue;
                        }
                        if (!coreBillTypeID.equals("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=")) continue;
                        isWriteCore[4] = true;
                        continue;
                    }
                    isWriteCore[1] = true;
                }
                String id = otherBillInfo.getId().toString();
                boolean isPurInvSysParam = WriteBackSQLHelper.getPurInvSysParam(ctx, otherBillInfo.getCompany());
                if (isWriteCore[1]) {
                    this.writeBackPurOrder(bizAction, ctx, id, isPurInvSysParam);
                }
                if (isWriteCore[2]) {
                    this.writeBackPurReturns(bizAction, ctx, id);
                }
                if (isWriteCore[3]) {
                    // empty if block
                }
                if (isWriteCore[4]) {
                    this.writeBackSubOrder(ctx, bizAction, otherBillInfo);
                }
            }
        }
    }

    private boolean isCentralBalance(Context ctx, String idList) throws SQLException, EASBizException, BOSException {
        StringBuffer selectQuerySQL = new StringBuffer();
        Boolean flag = false;
        selectQuerySQL.append("SELECT PUI.FNUMBER AS FWBNUMBER").append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ").append(" ON OTHERBILL.FID = OTHERBILLE.FPARENTID LEFT OUTER JOIN T_IM_PurInWarehsEntry PUIRE ON PUIRE.FID = OTHERBILLE.FSOURCEBILLENTRYID  ").append("INNER JOIN T_IM_PurInWarehsBill PUI ON PUI.FID=PUIRE.FParentID ").append(" WHERE OTHERBILL.FID = '").append(idList).append("'").append(" AND PUI.FisCentralBalance=1 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
        while (rowSet.next()) {
            flag = true;
        }
        return flag;
    }

    private void verifyCentralBalance(Context ctx, String idList, boolean isPurInvSysParam) throws SQLException, EASBizException, BOSException {
        if (isPurInvSysParam) {
            StringBuffer selectQuerySQL = new StringBuffer();
            selectQuerySQL.append("SELECT 2 as FErrType, OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PUI.FNUMBER AS FWBNUMBER,PUIRE.FSEQ AS FWBSEQ").append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ").append(" ON OTHERBILL.FID = OTHERBILLE.FPARENTID LEFT OUTER JOIN T_IM_PurInWarehsEntry PUIRE ON PUIRE.FID = OTHERBILLE.FSOURCEBILLENTRYID  ").append("INNER JOIN T_IM_PurInWarehsBill PUI ON PUI.FID=PUIRE.FParentID ").append(" WHERE OTHERBILL.FID = '").append(idList).append("'").append(" AND ISNULL(PUIRE.Fqty,0)-ISNULL(PUIRE.FdrewQty,0)-ISNULL(PUIRE.FreturnsQty,0)< OTHERBILLE.FQUANTITY  AND PUI.FisCentralBalance=1  order by PUIRE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2PIWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
    }

    private void verify(Context ctx, String idList, boolean isPurInvSysParam, boolean isApQtyGtPoSysParam) throws SQLException, EASBizException, BOSException {
        StringBuffer selectQuerySQL = new StringBuffer();
        if (isPurInvSysParam && isApQtyGtPoSysParam) {
            selectQuerySQL.append("SELECT 2 as FErrType,");
        } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
            selectQuerySQL.append("SELECT case when (ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
        } else {
            if (!isPurInvSysParam && isApQtyGtPoSysParam) {
                return;
            }
            if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 1 as FErrType,");
            }
        }
        selectQuerySQL.append("OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PURORDER.FNUMBER AS FWBNUMBER,PURORDERE.FSEQ AS FWBSEQ ");
        selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
        selectQuerySQL.append(" LEFT OUTER JOIN T_SM_PURORDERENTRY PURORDERE ON PURORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
        selectQuerySQL.append(" INNER JOIN T_SM_PURORDER PURORDER ON PURORDER.FID=PURORDERE.FParentID");
        selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(idList).append("'");
        if (isPurInvSysParam && isApQtyGtPoSysParam) {
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0");
        } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
            selectQuerySQL.append(" AND ((ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0) >= ISNULL(PURORDERE.FQTY,0) ");
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0)");
            selectQuerySQL.append(" OR (ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0) < ISNULL(PURORDERE.FQTY,0)");
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0) )");
        } else {
            if (!isPurInvSysParam && isApQtyGtPoSysParam) {
                return;
            }
            if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0");
            }
        }
        selectQuerySQL.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
        selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
        AP2PIWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
    }

    public static void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AP_PURORDERERRO", (Locale)ctx.getLocale())).append("\n");
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AP_PIORDERERROR", (Locale)ctx.getLocale())).append("\n");
                }
            }
            sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"APNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"PURINWAREHSBILL", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
            sql.append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static HashMap getParamHashMap(Context ctx, HashMap paramKeyMap) {
        HashMap value = null;
        try {
            value = ParamManager.getParamHashMap((Context)ctx, (HashMap)paramKeyMap);
            return value;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    protected boolean getBooleanParamValue(Context ctx, String paramKey) {
        String paramValue = null;
        boolean isParamValue = false;
        paramValue = (String)this.paramKeyMap.get(paramKey);
        if ("true".equalsIgnoreCase(paramValue) || "1".equalsIgnoreCase(paramValue)) {
            isParamValue = true;
        }
        return isParamValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackPurInWarehsBill(Context ctx, IArApBillHeadInfo ap, boolean calType) throws BOSException, EASBizException {
        Connection con = null;
        IRowSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            IArapBillEntryInfo apEntry = null;
            IObjectCollection otherBillEntryCollection = ap.getEntries();
            StringBuffer apEntryIds = new StringBuffer();
            StringBuffer purEntryIds = new StringBuffer();
            int size = otherBillEntryCollection.size();
            Boolean useTempTable = false;
            String[] apEntryIdsArray = null;
            String[] purEntryIdsArray = null;
            if (size > 1000) {
                useTempTable = true;
                apEntryIdsArray = new String[size];
                purEntryIdsArray = new String[size];
            }
            for (int i = 0; i < size; ++i) {
                if (otherBillEntryCollection.getObject(i) == null) continue;
                IArapBillEntryInfo entry = (IArapBillEntryInfo)otherBillEntryCollection.getObject(i);
                if (useTempTable.booleanValue()) {
                    apEntryIdsArray[i] = entry.getId().toString();
                    purEntryIdsArray[i] = entry.getSourceBillEntryId().toString();
                    continue;
                }
                apEntryIds.append("'").append(entry.getId()).append("',");
                purEntryIds.append("'").append(entry.getSourceBillEntryId()).append("',");
            }
            String apEntryIdTable = null;
            String purEntryIdTable = null;
            StringBuffer sql = new StringBuffer();
            HashMap<String, PurInWarehsEntryCollection> idsSrcObjsMap = new HashMap<String, PurInWarehsEntryCollection>();
            try {
                if (useTempTable.booleanValue()) {
                    apEntryIdTable = SCMSqlUtil.convertIdArrToTempTab(ctx, apEntryIdsArray);
                    purEntryIdTable = SCMSqlUtil.convertIdArrToTempTab(ctx, purEntryIdsArray);
                } else {
                    apEntryIds.setLength(apEntryIds.length() - 1);
                    purEntryIds.setLength(purEntryIds.length() - 1);
                }
                sql.append("SELECT APENTRY.FID AS DESTENTRYID,PURBILL.FNUMBER AS FNUMBER,PURBILL.FBIZDATE AS FBIZDATE, ");
                sql.append("PURENTRY.FID AS FID,PURENTRY.FBASEQTY AS FBASEQTY,PURENTRY.FQTY AS FQTY,PURENTRY.FMATERIALID AS FMATERIALID, ");
                sql.append("PURENTRY.FUNITID AS FUNITID,PURENTRY.FBASEUNITID AS FBASEUNITID,PURENTRY.FDREWQTY AS FDREWQTY, ");
                sql.append("PURENTRY.FDREWBASEQTY AS FDREWBASEQTY,PURENTRY.FASSOCIATEQTY AS FASSOCIATEQTY,PURENTRY.FREVERSEBASEQTY AS FREVERSEBASEQTY,");
                sql.append("PURENTRY.FSEQ AS FSEQ ");
                sql.append("FROM T_AP_OTHERBILLENTRY APENTRY ");
                sql.append("LEFT JOIN T_IM_PURINWAREHSENTRY PURENTRY ON APENTRY.FSOURCEBILLENTRYID = PURENTRY.FID ");
                sql.append("INNER JOIN T_IM_PURINWAREHSBILL PURBILL ON PURENTRY.FPARENTID = PURBILL.FID ");
                sql.append("LEFT JOIN T_BOT_RELATIONENTRY RELATIONENTRY ON RELATIONENTRY.FSRCENTRYID = PURENTRY.FID AND RELATIONENTRY.FDESTENTRYID = APENTRY.FID ");
                sql.append("WHERE PURENTRY.FID IN (");
                if (useTempTable.booleanValue()) {
                    sql.append("select FID from " + purEntryIdTable);
                } else {
                    sql.append(purEntryIds);
                }
                sql.append(") AND APENTRY.FID IN (");
                if (useTempTable.booleanValue()) {
                    sql.append("select FID from " + apEntryIdTable);
                } else {
                    sql.append(apEntryIds);
                }
                sql.append(")");
                String sqlStr = sql.toString();
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            }
            catch (Throwable throwable) {
                SCMSqlUtil.releasTempTable(ctx, purEntryIdTable);
                SCMSqlUtil.releasTempTable(ctx, apEntryIdTable);
                throw throwable;
            }
            SCMSqlUtil.releasTempTable(ctx, purEntryIdTable);
            SCMSqlUtil.releasTempTable(ctx, apEntryIdTable);
            String destEntryId = "";
            while (rs.next()) {
                PurInWarehsEntryCollection purEntryColl = new PurInWarehsEntryCollection();
                PurInWarehsEntryInfo entryInfo = new PurInWarehsEntryInfo();
                entryInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                entryInfo.setBaseQty(rs.getBigDecimal("FBaseQty"));
                entryInfo.setQty(rs.getBigDecimal("FQty"));
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
                entryInfo.setMaterial(material);
                MeasureUnitInfo unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                entryInfo.setUnit(unit);
                MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                baseUnit.setId(BOSUuid.read((String)rs.getString("FBaseUnitID")));
                entryInfo.setBaseUnit(baseUnit);
                entryInfo.setDrewQty(rs.getBigDecimal("FDrewQty"));
                entryInfo.setDrewBaseQty(rs.getBigDecimal("FDrewBaseQty"));
                entryInfo.setAssociateQty(rs.getBigDecimal("FAssociateQty"));
                entryInfo.setReverseBaseQty(rs.getBigDecimal("FReverseBaseQty"));
                entryInfo.setSeq(rs.getInt("FSeq"));
                entryInfo.put("parent.bizDate", (Object)rs.getDate("FBizDate"));
                entryInfo.put("parent.number", (Object)rs.getString("FNumber"));
                destEntryId = rs.getString("destEntryID");
                purEntryColl.clear();
                purEntryColl.add(entryInfo);
                if (idsSrcObjsMap.containsKey(destEntryId)) {
                    PurInWarehsEntryCollection temp = (PurInWarehsEntryCollection)idsSrcObjsMap.get(destEntryId);
                    purEntryColl.addCollection(temp);
                }
                idsSrcObjsMap.put(destEntryId, purEntryColl);
            }
            sql.setLength(0);
            sql.append("UPDATE T_IM_PURINWAREHSENTRY SET FDREWQTY = ? ,FDREWBASEQTY = ? ,FASSOCIATEQTY = ? ");
            sql.append("WHERE FID = ? ");
            String sqlStr3 = sql.toString();
            PreparedStatement prmt = con.prepareStatement(sqlStr3);
            try {
                boolean fBatch = false;
                for (int t = 0; t < otherBillEntryCollection.size(); ++t) {
                    BigDecimal baseQty_apEntry;
                    PurInWarehsEntryCollection piEntryColl = new PurInWarehsEntryCollection();
                    apEntry = (IArapBillEntryInfo)otherBillEntryCollection.getObject(t);
                    if (apEntry == null || (piEntryColl = (PurInWarehsEntryCollection)idsSrcObjsMap.get(apEntry.getId().toString())) == null || piEntryColl.size() == 0) continue;
                    BigDecimal unWrittenBaseQty = baseQty_apEntry = apEntry.getBaseQty();
                    for (int i = 0; i < piEntryColl.size(); ++i) {
                        BigDecimal baseQty_thisTime;
                        PurInWarehsEntryInfo piEntry = piEntryColl.get(i);
                        if (i == piEntryColl.size() - 1) {
                            baseQty_thisTime = unWrittenBaseQty;
                        } else {
                            BigDecimal tempB = piEntry.getDrewBaseQty().abs().add(piEntry.getReverseBaseQty().abs());
                            tempB = piEntry.getBaseQty().abs().subtract(tempB);
                            baseQty_thisTime = tempB.compareTo(unWrittenBaseQty.abs()) > 0 ? unWrittenBaseQty : piEntry.getBaseQty().subtract(piEntry.getDrewBaseQty()).subtract(piEntry.getReverseBaseQty());
                        }
                        BigDecimal qty_thisTime = piEntry.getBaseUnit() != null && piEntry.getUnit() != null && piEntry.getBaseUnit().getId().equals((Object)piEntry.getUnit().getId()) ? baseQty_thisTime : SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty_thisTime, (String)piEntry.getMaterial().getId().toString(), (String)piEntry.getBaseUnit().getId().toString(), (String)piEntry.getUnit().getId().toString());
                        BigDecimal drewQty = piEntry.getDrewQty();
                        BigDecimal drewBaseQty = piEntry.getDrewBaseQty();
                        BigDecimal drewQtyAfter = drewQty.add(qty_thisTime);
                        BigDecimal drewBaseQtyAfter = drewBaseQty.add(baseQty_thisTime);
                        BigDecimal associateQty = piEntry.getAssociateQty();
                        BigDecimal associateQtyAfter = associateQty.subtract(baseQty_thisTime);
                        piEntry.setDrewQty(drewQtyAfter);
                        piEntry.setDrewBaseQty(drewBaseQtyAfter);
                        piEntry.setAssociateQty(associateQtyAfter);
                        unWrittenBaseQty = unWrittenBaseQty.subtract(baseQty_thisTime);
                        prmt.setBigDecimal(1, drewQtyAfter);
                        prmt.setBigDecimal(2, drewBaseQtyAfter);
                        prmt.setBigDecimal(3, associateQtyAfter);
                        prmt.setString(4, piEntry.getId().toString());
                        prmt.addBatch();
                        fBatch = true;
                    }
                }
                if (fBatch) {
                    prmt.executeBatch();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)prmt);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackPurReturns(Context ctx, Connection con, IArapBillEntryInfo otherBillEntryInfo, IArApBillHeadInfo otherBillInfo) throws BOSException, EASBizException, SQLException {
        String coreBillEntryID = otherBillEntryInfo.getCoreBillEntryId();
        if (StringUtil.isEmpty((String)coreBillEntryID)) {
            return;
        }
        BigDecimal qty_ob = otherBillEntryInfo.getQuantity();
        BigDecimal amount_ob = otherBillEntryInfo.getRecievePayAmount();
        BigDecimal baseQty_ob = otherBillEntryInfo.getBaseQty();
        PreparedStatement pstmt = null;
        PreparedStatement pstmtOrder = null;
        ResultSet rs = null;
        String selectSql = "select FID,FMaterialID,FUnitID,FBaseUnitID,FQty,FBaseQty,FInvoicedQty,FUninvoicedQty,FInvoicedAmount,FInvoicedBaseQty,FUninvoicedBaseQty from t_sm_purReturnsEntry where FID=?";
        String updateSql = "update t_sm_purReturnsEntry set FInvoicedQty =? , FInvoicedAmount=? , FInvoicedBaseQty=? , FUninvoicedQty=? , FUninvoicedBaseQty=? where FID=?";
        try {
            pstmtOrder = con.prepareStatement(selectSql);
            pstmtOrder.setString(1, coreBillEntryID);
            rs = pstmtOrder.executeQuery();
            if (rs.next()) {
                String materialid = rs.getString("FMaterialID");
                String unitid = rs.getString("FUnitID");
                String baseUnitID = rs.getString("FBaseUnitID");
                BigDecimal qty = rs.getBigDecimal("FQty");
                BigDecimal baseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal invoicedQty = rs.getBigDecimal("FInvoicedQty");
                BigDecimal invoicedAmount = rs.getBigDecimal("FInvoicedAmount");
                BigDecimal invoicedBaseQty = rs.getBigDecimal("FInvoicedBaseQty");
                BigDecimal uninvoicedBaseQty = rs.getBigDecimal("FUninvoicedBaseQty");
                if (invoicedQty == null) {
                    invoicedQty = new BigDecimal("0.00");
                }
                if (invoicedAmount == null) {
                    invoicedAmount = new BigDecimal("0.00");
                }
                if (invoicedBaseQty == null) {
                    invoicedBaseQty = new BigDecimal("0.00");
                }
                if (uninvoicedBaseQty == null) {
                    uninvoicedBaseQty = new BigDecimal("0.00");
                }
                invoicedQty = otherBillEntryInfo.getMeasureUnit() != null && unitid.equals(otherBillEntryInfo.getMeasureUnit().getId().toString()) ? invoicedQty.abs().add(qty_ob.abs()) : invoicedQty.abs().add(SCMUtils.getExchangeQtyForServer(ctx, materialid, baseUnitID, baseQty_ob, unitid).abs());
                BigDecimal uninvoicedQty = qty.abs().subtract(invoicedQty.abs());
                invoicedBaseQty = invoicedBaseQty.abs().add(baseQty_ob.abs());
                uninvoicedBaseQty = baseQty.abs().subtract(invoicedBaseQty.abs());
                invoicedAmount = invoicedAmount.abs().add(amount_ob.abs());
                pstmt = con.prepareStatement(updateSql);
                pstmt.setBigDecimal(1, invoicedQty);
                pstmt.setBigDecimal(2, invoicedAmount);
                pstmt.setBigDecimal(3, invoicedBaseQty);
                pstmt.setBigDecimal(4, uninvoicedQty);
                pstmt.setBigDecimal(5, uninvoicedBaseQty);
                pstmt.setString(6, coreBillEntryID);
                pstmt.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)pstmtOrder);
            SQLUtils.cleanup(pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmtOrder);
        SQLUtils.cleanup(pstmt);
    }

    private boolean writeBackOrder(Context ctx, Connection con, PreparedStatement pstmt, IArapBillEntryInfo otherBillEntryInfo, IArApBillHeadInfo otherBillInfo, PurOrderCollection poCollection, PurOrderEntryCollection poeCollection) throws BOSException, EASBizException, SQLException {
        boolean fBatch = false;
        String otherBill_supplierID = otherBillInfo.getCompany() == null ? null : otherBillInfo.getCompany().getId().toString();
        String coreBillEntryID = otherBillEntryInfo.getCoreBillEntryId();
        String coreBillID = otherBillEntryInfo.getCoreBillId();
        BigDecimal qty_ob = otherBillEntryInfo.getQuantity();
        BigDecimal amount_ob = otherBillEntryInfo.getRecievePayAmount();
        BigDecimal baseQty_ob = otherBillEntryInfo.getBaseQty();
        boolean isApCouEqualsPoCou = true;
        boolean isCenterBalance = false;
        if (StringUtil.isEmpty((String)coreBillID) || StringUtil.isEmpty((String)coreBillEntryID)) {
            return false;
        }
        if (poCollection.containsKey((Object)BOSUuid.read((String)coreBillID))) {
            PurOrderInfo po = poCollection.get((Object)BOSUuid.read((String)coreBillID));
            String companyID = po.getCompanyOrgUnit() == null ? null : po.getCompanyOrgUnit().getId().toString();
            isCenterBalance = po.isIsCentralBalance();
            if (companyID == null || !companyID.equals(otherBill_supplierID)) {
                isApCouEqualsPoCou = false;
            }
        }
        if (poeCollection.containsKey((Object)BOSUuid.read((String)coreBillEntryID))) {
            String entryCompanyID;
            PurOrderEntryInfo poe = poeCollection.get((Object)BOSUuid.read((String)coreBillEntryID));
            boolean isApCouEqualsPoEntryCou = true;
            String materialid = poe.getMaterial() == null ? null : poe.getMaterial().getId().toString();
            String unitid = poe.getUnit() == null ? null : poe.getUnit().getId().toString();
            String baseUnitID = poe.getBaseUnit() == null ? null : poe.getBaseUnit().getId().toString();
            String string = entryCompanyID = poe.getCompanyOrgUnit() == null ? null : poe.getCompanyOrgUnit().getId().toString();
            if (entryCompanyID == null || !entryCompanyID.equals(otherBill_supplierID)) {
                isApCouEqualsPoEntryCou = false;
            }
            if (isCenterBalance && !isApCouEqualsPoCou || !isCenterBalance && !isApCouEqualsPoEntryCou) {
                return false;
            }
            BigDecimal totalInvoicedQty = poe.getTotalInvoicedQty();
            BigDecimal totalInvoicedAmount = poe.getTotalInvoicedAmount();
            BigDecimal totalInvoicedBaseQty = poe.getTotalInvoicedBaseQty();
            BigDecimal assistQty = poe.getAssociateQty();
            if (totalInvoicedQty == null) {
                totalInvoicedQty = new BigDecimal("0.00");
            }
            if (totalInvoicedAmount == null) {
                totalInvoicedAmount = new BigDecimal("0.00");
            }
            if (totalInvoicedBaseQty == null) {
                totalInvoicedBaseQty = new BigDecimal("0.00");
            }
            if (assistQty == null) {
                assistQty = new BigDecimal("0.00");
            }
            totalInvoicedQty = otherBillEntryInfo.getMeasureUnit() != null && otherBillEntryInfo.getMeasureUnit().getId().toString().equals(unitid) ? totalInvoicedQty.add(qty_ob) : totalInvoicedQty.add(SCMUtils.getExchangeQtyForServer(ctx, materialid, baseUnitID, baseQty_ob, unitid));
            totalInvoicedBaseQty = totalInvoicedBaseQty.add(baseQty_ob);
            totalInvoicedAmount = totalInvoicedAmount.add(amount_ob);
            assistQty = assistQty.subtract(baseQty_ob);
            if (pstmt != null) {
                poe.setTotalInvoicedQty(totalInvoicedQty);
                poe.setTotalInvoicedAmount(totalInvoicedAmount);
                poe.setTotalInvoicedBaseQty(totalInvoicedBaseQty);
                poe.setAssociateQty(assistQty);
                pstmt.setBigDecimal(1, totalInvoicedQty);
                pstmt.setBigDecimal(2, totalInvoicedAmount);
                pstmt.setBigDecimal(3, totalInvoicedBaseQty);
                pstmt.setBigDecimal(4, assistQty);
                pstmt.setString(5, coreBillEntryID);
                pstmt.addBatch();
                fBatch = true;
            }
        }
        return fBatch;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{true, false, false, false};
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            String coreBosType;
            BOSObjectType coreBosTypeObj;
            BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
            if (null == coreBosTypeObj || (coreBosType = coreBosTypeObj.toString()) == null) continue;
            if (coreBosType.equals("CC3E933B")) {
                isWriteCore[1] = true;
                continue;
            }
            if (coreBosType.equals("546F192F")) {
                isWriteCore[2] = true;
                continue;
            }
            if (!coreBosType.equals("2239F30A")) continue;
            isWriteCore[3] = true;
        }
    }

    private void unAduitWriteBackPurInWarehsBill(Context ctx, IArapBillEntryInfo apEntry, IArApBillHeadInfo ap) throws BOSException, EASBizException {
        IRowSet rs2 = null;
        StringBuffer sb = null;
        try {
            BigDecimal baseQty_apEntry;
            String entryID = apEntry.getSourceBillEntryId();
            if (entryID == null) {
                return;
            }
            IPurInWarehsEntry ipe = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
            sb = new StringBuffer();
            sb.append("select entry.FID,entry.FBaseQty,entry.FQty,entry.FMaterialID,entry.FUnitID,entry.FBaseUnitID,entry.FDrewQty,");
            sb.append("entry.FDrewBaseQty,entry.FAssociateQty,entry.FReverseBaseQty,parent.FBizDate ");
            sb.append("from T_IM_PurInWarehsBill parent ");
            sb.append("inner join T_IM_PurInWarehsEntry entry on parent.FID = entry.FParentID ");
            sb.append("where entry.FID = '").append(entryID).append("'");
            sb.append(" order by parent.FBizDate");
            String sqlStr2 = sb.toString();
            rs2 = DbUtil.executeQuery((Context)ctx, (String)sqlStr2);
            PurInWarehsEntryCollection piEntryColl = new PurInWarehsEntryCollection();
            while (rs2.next()) {
                PurInWarehsEntryInfo entryInfo = new PurInWarehsEntryInfo();
                entryInfo.setId(BOSUuid.read((String)rs2.getString("FID")));
                entryInfo.setBaseQty(rs2.getBigDecimal("FBaseQty"));
                entryInfo.setQty(rs2.getBigDecimal("FQty"));
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs2.getString("FMaterialID")));
                entryInfo.setMaterial(material);
                MeasureUnitInfo unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)rs2.getString("FUnitID")));
                entryInfo.setUnit(unit);
                MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                baseUnit.setId(BOSUuid.read((String)rs2.getString("FBaseUnitID")));
                entryInfo.setBaseUnit(baseUnit);
                entryInfo.setDrewQty(rs2.getBigDecimal("FDrewQty"));
                entryInfo.setDrewBaseQty(rs2.getBigDecimal("FDrewBaseQty"));
                entryInfo.setAssociateQty(rs2.getBigDecimal("FAssociateQty"));
                entryInfo.setReverseBaseQty(rs2.getBigDecimal("FReverseBaseQty"));
                entryInfo.put("parent.bizDate", (Object)rs2.getDate("FBizDate"));
                piEntryColl.add(entryInfo);
            }
            if (piEntryColl == null || piEntryColl.size() == 0) {
                SQLUtils.cleanup((ResultSet)rs2);
                return;
            }
            BigDecimal unWrittenBaseQty = baseQty_apEntry = apEntry.getBaseQty();
            for (int i = 0; i < piEntryColl.size(); ++i) {
                BigDecimal baseQty_thisTime;
                PurInWarehsEntryInfo piEntry = piEntryColl.get(i);
                if (i == piEntryColl.size() - 1) {
                    baseQty_thisTime = unWrittenBaseQty;
                } else {
                    BigDecimal tempB = piEntry.getDrewBaseQty().abs().add(piEntry.getReverseBaseQty().abs());
                    tempB = piEntry.getBaseQty().abs().subtract(tempB);
                    baseQty_thisTime = tempB.compareTo(new BigDecimal("0.00")) > 0 ? unWrittenBaseQty : piEntry.getBaseQty().subtract(piEntry.getReverseBaseQty());
                }
                BigDecimal qty_thisTime = piEntry.getBaseUnit() != null && piEntry.getUnit() != null && piEntry.getBaseUnit().getId().equals((Object)piEntry.getUnit().getId()) ? baseQty_thisTime : SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty_thisTime, (String)piEntry.getMaterial().getId().toString(), (String)piEntry.getBaseUnit().getId().toString(), (String)piEntry.getUnit().getId().toString());
                BigDecimal drewQty = piEntry.getDrewQty();
                BigDecimal drewBaseQty = piEntry.getDrewBaseQty();
                BigDecimal drewQtyAfter = drewQty.subtract(qty_thisTime);
                BigDecimal drewBaseQtyAfter = drewBaseQty.subtract(baseQty_thisTime);
                BigDecimal associateQty = piEntry.getAssociateQty();
                BigDecimal associateQtyAfter = associateQty.add(baseQty_thisTime.abs());
                piEntry.setDrewQty(drewQtyAfter);
                piEntry.setDrewBaseQty(drewBaseQtyAfter);
                piEntry.setAssociateQty(associateQtyAfter);
                ipe.update((IObjectPK)new ObjectUuidPK(piEntry.getId().toString()), (CoreBaseInfo)piEntry);
                unWrittenBaseQty = unWrittenBaseQty.subtract(baseQty_thisTime);
            }
            SQLUtils.cleanup((ResultSet)rs2);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs2);
        }
    }

    private void writeBackPurOrder(BizActionEnum bizAction, Context ctx, String id, boolean isPurInvSysParam) throws BOSException, SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_PO", WriteBackSQLHelper.createAP2POWriteSQLDialect(bizAction, ctx, isPurInvSysParam));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_PO_UnAduit", WriteBackSQLHelper.createAP2POWriteSQLDialect(bizAction, ctx, isPurInvSysParam));
        }
        this.executeUpdate(ps, new Object[]{id});
    }

    private void writeBackSubOrder(Context ctx, BizActionEnum bizAction, IArApBillHeadInfo otherBillInfo) throws EASBizException, BOSException, SQLException {
        new AP2SubOrderWriteBackHandler().handle(ctx, bizAction, (IObjectValue)otherBillInfo);
    }

    private void writeBackPurReturns(BizActionEnum bizAction, Context ctx, String id) throws BOSException, SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_PR", WriteBackSQLHelper.createAP2PurReturnWriteSQL(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_PR_UnAduit", WriteBackSQLHelper.createAP2PurReturnWriteSQL(bizAction, ctx));
        }
        this.executeUpdate(ps, new Object[]{id});
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }
}

