/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;

public class AP2POWriteBackHandler
extends AbstractWriteBackHandler {
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (destBillInfo == null) {
            return;
        }
        if (destBillInfo.getInt("billType") == 203) {
            return;
        }
        IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)destBillInfo;
        String id = otherBillInfo.getId().toString();
        boolean isPurInvSysParam = WriteBackSQLHelper.getPurInvSysParam(ctx, otherBillInfo.getCompany());
        boolean isApQtyGtPoSysParam = WriteBackSQLHelper.getApQtyGtPoSysParam(ctx, otherBillInfo.getCompany());
        String dbType = WriteBackSQLHelper.getDBType(ctx);
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT || bizAction == BizActionEnum.SUBMIT) {
            ps = this.createPreparedStatement("WB_PO", WriteBackSQLHelper.createAP2POWriteSQLDialect(BizActionEnum.AUDIT, ctx, isPurInvSysParam));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_PO_UnAduit", WriteBackSQLHelper.createAP2POWriteSQLDialect(bizAction, ctx, isPurInvSysParam));
        }
        this.executeUpdate(ps, new Object[]{id});
        if (bizAction == BizActionEnum.AUDIT) {
            boolean apQtyOverPIQty;
            boolean verifyPurInvQty = true;
            if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                verifyPurInvQty = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AP_025", true);
            }
            if (!(apQtyOverPIQty = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AP_OTHERBILL_QtyOverSource", false))) {
                this.verify(ctx, id, isPurInvSysParam, isApQtyGtPoSysParam, verifyPurInvQty);
            }
        }
    }

    private void verify(Context ctx, String idList, boolean isPurInvSysParam, boolean isApQtyGtPoSysParam, boolean verifyPurInvQty) throws SQLException, EASBizException, BOSException {
        IRowSet rowSet;
        StringBuffer selectQuerySQL = new StringBuffer();
        if (verifyPurInvQty) {
            if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 2 as FErrType,");
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT case when (ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
            } else if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 1 as FErrType,");
            }
        } else if (!isApQtyGtPoSysParam) {
            selectQuerySQL.append("SELECT 1 as FErrType,");
        }
        selectQuerySQL.append("OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PURORDER.FNUMBER AS FWBNUMBER,PURORDERE.FSEQ AS FWBSEQ");
        selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
        selectQuerySQL.append(" LEFT OUTER JOIN T_SM_PURORDERENTRY PURORDERE ON PURORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
        selectQuerySQL.append(" INNER JOIN T_SM_PURORDER PURORDER ON PURORDER.FID=PURORDERE.FParentID");
        selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(idList).append("'");
        selectQuerySQL.append(" AND PURORDER.FBIZTYPEID <> '").append("d8e80652-010b-1001-e000-04c5c0a812202407435C").append("'");
        if (verifyPurInvQty) {
            if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0");
                selectQuerySQL.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
                selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0) >= ISNULL(PURORDERE.FQTY,0) ");
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0)");
                selectQuerySQL.append(" OR (ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0) < ISNULL(PURORDERE.FQTY,0)");
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0) )");
                selectQuerySQL.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
                selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
            } else if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0");
                selectQuerySQL.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
                selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
            }
        } else if (!isApQtyGtPoSysParam) {
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0");
            selectQuerySQL.append(" AND OTHERBILLE.FQUANTITY >= 0 ");
            selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
        if (!isApQtyGtPoSysParam) {
            selectQuerySQL.setLength(0);
            selectQuerySQL.append("SELECT 1 as FErrType,OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PURORDER.FNUMBER AS FWBNUMBER,PURORDERE.FSEQ AS FWBSEQ");
            selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
            selectQuerySQL.append(" LEFT OUTER JOIN T_SM_PURORDERENTRY PURORDERE ON PURORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
            selectQuerySQL.append(" INNER JOIN T_SM_PURORDER PURORDER ON PURORDER.FID=PURORDERE.FParentID");
            selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(idList).append("'");
            selectQuerySQL.append(" AND PURORDER.FBIZTYPEID = '").append("d8e80652-010b-1001-e000-04c5c0a812202407435C").append("'");
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0) < 0");
            selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
    }

    public static void verifyQtyAtSubmit(Context ctx, String idList, boolean isPurInvSysParam, boolean isApQtyGtPoSysParam, boolean verifyPurInvQty, boolean verifyPiOrPoBill) throws SQLException, EASBizException, BOSException {
        IRowSet rowSet;
        StringBuffer sb = new StringBuffer();
        String companyId = null;
        sb.append("select FcompanyId from T_AP_OTHERBILL where Fid='").append(idList).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        while (rs.next()) {
            companyId = rs.getString("FcompanyId");
        }
        boolean purInvSysParam = WriteBackSQLHelper.isSysParamValue(ctx, companyId, "PURSUP006", false);
        AP2POWriteBackHandler.verifyCentralBalance(ctx, idList, purInvSysParam);
        StringBuffer selectQuerySQL = new StringBuffer();
        if (verifyPurInvQty || verifyPiOrPoBill) {
            if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 2 as FErrType,");
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT case when (ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
            } else if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append("SELECT 1 as FErrType,");
            }
        } else if (!(verifyPurInvQty || verifyPiOrPoBill || isApQtyGtPoSysParam)) {
            selectQuerySQL.append("SELECT 1 as FErrType,");
        }
        selectQuerySQL.append("OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PURORDER.FNUMBER AS FWBNUMBER,PURORDERE.FSEQ AS FWBSEQ");
        selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
        selectQuerySQL.append(" LEFT OUTER JOIN T_SM_PURORDERENTRY PURORDERE ON PURORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
        selectQuerySQL.append(" INNER JOIN T_SM_PURORDER PURORDER ON PURORDER.FID=PURORDERE.FParentID");
        selectQuerySQL.append(" INNER JOIN (");
        selectQuerySQL.append(" select OTHERBILLE.FCOREBILLENTRYId fid ,");
        selectQuerySQL.append(" case when (PURORDERE.FUnitID is NULL or OTHERBILLE.FMEASUREUNITID=PURORDERE.FUnitID) then sum(OTHERBILLE.FQUANTITY)");
        selectQuerySQL.append(" else sum(ROUND(DECIMAL(OTHERBILLE.Fbaseqty/ISNULL(mmu.FBaseConvsRate,1.00),21,8),mmu.FQtyPrecision)) end as fQUANTITY");
        selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
        selectQuerySQL.append(" LEFT OUTER JOIN T_SM_PURORDERENTRY PURORDERE ON PURORDERE.FID = OTHERBILLE.FCOREBILLENTRYID");
        selectQuerySQL.append(" INNER JOIN T_SM_PURORDER PURORDER ON PURORDER.FID=PURORDERE.FParentID");
        selectQuerySQL.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = OTHERBILLE.FMaterialID and mmu.FMeasureUnitID = PURORDERE.FUnitID");
        selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(idList).append("'");
        selectQuerySQL.append(" AND PURORDER.FBIZTYPEID <> '").append("d8e80652-010b-1001-e000-04c5c0a812202407435C").append("'");
        selectQuerySQL.append(" AND ((PURORDER.FIsCentralBalance = 1 AND PURORDER.FCompanyOrgUnitID = OTHERBILL.FCompanyID) OR (PURORDER.FIsCentralBalance = 0 AND PURORDERE.FCompanyOrgUnitID = OTHERBILL.FCompanyID))");
        selectQuerySQL.append(" GROUP BY OTHERBILLE.FCOREBILLENTRYId,OTHERBILLE.FMEASUREUNITID,PURORDERE.FUnitID");
        selectQuerySQL.append(" )as tempView on tempView.fid = PURORDERE.fid");
        selectQuerySQL.append(" where OTHERBILL.FID = '").append(idList).append("'");
        if (verifyPurInvQty || verifyPiOrPoBill) {
            if (isPurInvSysParam && isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0)-ABS(ISNULL(tempView.FQUANTITY,0)) < 0");
                selectQuerySQL.append(" AND tempView.FQUANTITY >= 0 ");
                selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
            } else if (isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ((ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0) >= ISNULL(PURORDERE.FQTY,0) ");
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0)-ABS(ISNULL(tempView.FQUANTITY,0)) < 0)");
                selectQuerySQL.append(" OR (ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0) < ISNULL(PURORDERE.FQTY,0)");
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FTOTALRECEIPTQTY,0)-ISNULL(PURORDERE.FTOTALCANCELLEDSTOCKQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0)-ABS(ISNULL(tempView.FQUANTITY,0)) < 0) )");
                selectQuerySQL.append(" AND tempView.FQUANTITY >= 0 ");
                selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
            } else if (!isPurInvSysParam && !isApQtyGtPoSysParam) {
                selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0)-ABS(ISNULL(tempView.FQUANTITY,0)) < 0");
                selectQuerySQL.append(" AND tempView.FQUANTITY >= 0 ");
                selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
            }
        } else if (!(verifyPurInvQty || verifyPiOrPoBill || isApQtyGtPoSysParam)) {
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0)-ABS(ISNULL(tempView.FQUANTITY,0)) < 0");
            selectQuerySQL.append(" AND tempView.FQUANTITY >= 0 ");
            selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
        if (!isApQtyGtPoSysParam) {
            selectQuerySQL.setLength(0);
            selectQuerySQL.append("SELECT 1 as FErrType,OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PURORDER.FNUMBER AS FWBNUMBER,PURORDERE.FSEQ AS FWBSEQ");
            selectQuerySQL.append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
            selectQuerySQL.append(" LEFT OUTER JOIN T_SM_PURORDERENTRY PURORDERE ON PURORDERE.FID = OTHERBILLE.FCOREBILLENTRYID ");
            selectQuerySQL.append(" INNER JOIN T_SM_PURORDER PURORDER ON PURORDER.FID=PURORDERE.FParentID");
            selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(idList).append("'");
            selectQuerySQL.append(" AND PURORDER.FBIZTYPEID = '").append("d8e80652-010b-1001-e000-04c5c0a812202407435C").append("'");
            selectQuerySQL.append(" AND ISNULL(PURORDERE.FQTY,0)-ISNULL(PURORDERE.FTOTALINVOICEDQTY,0)-ABS(ISNULL(OTHERBILLE.FQUANTITY,0)) < 0");
            selectQuerySQL.append(" order by PURORDERE.FSEQ ASC");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
    }

    public static void verifyCentralBalance(Context ctx, String idList, boolean isPurInvSysParam) throws SQLException, EASBizException, BOSException {
        if (isPurInvSysParam) {
            StringBuffer selectQuerySQL = new StringBuffer();
            selectQuerySQL.append("SELECT 2 as FErrType, OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER,PUI.FNUMBER AS FWBNUMBER,PUIRE.FSEQ AS FWBSEQ").append(" FROM T_AP_OTHERBILL OTHERBILL INNER JOIN T_AP_OTHERBILLENTRY OTHERBILLE ").append(" ON OTHERBILL.FID = OTHERBILLE.FPARENTID LEFT OUTER JOIN T_IM_PurInWarehsEntry PUIRE ON PUIRE.FID = OTHERBILLE.FSOURCEBILLENTRYID  ").append("INNER JOIN T_IM_PurInWarehsBill PUI ON PUI.FID=PUIRE.FParentID ").append(" WHERE OTHERBILL.FID = '").append(idList).append("'").append(" AND ISNULL(PUIRE.Fqty,0)-ISNULL(PUIRE.FdrewQty,0)-ISNULL(PUIRE.FreturnsQty,0)< OTHERBILLE.FQUANTITY  AND PUI.FisCentralBalance=1  order by PUIRE.FSEQ ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
            AP2POWriteBackHandler.verifyAPWriteBack(ctx, rowSet);
        }
    }

    public static void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AP_PURORDERERRO", (Locale)ctx.getLocale())).append("\n");
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"AP_PIORDERERROR", (Locale)ctx.getLocale())).append("\n");
                }
            }
            sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"APNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"PURORDER", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
            sql.append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }
}

