/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.fi.arap.api.IArapBillEntryInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;

public class AP2STWriteBackHandler
extends AbstractWriteBackHandler {
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)destBillInfo;
        if (destBillInfo == null) {
            return;
        }
        if (destBillInfo.getInt("billType") == 203) {
            return;
        }
        String billId = otherBillInfo.getId().toString();
        boolean coreBillIsMove = false;
        boolean sourceBillIsMove = false;
        IObjectCollection otherBillEntryCollection = otherBillInfo.getEntries();
        if (otherBillEntryCollection.size() == 0) {
            return;
        }
        IArapBillEntryInfo otherBillentryInfo = (IArapBillEntryInfo)otherBillEntryCollection.getObject(0);
        if (otherBillentryInfo != null) {
            String sourceBillID;
            String coreBillTypeID = otherBillentryInfo.getCoreBillTypeId();
            String string = sourceBillID = otherBillentryInfo.getSourceBillId() == null ? null : otherBillentryInfo.getSourceBillId().toString();
            if (coreBillTypeID != null && sourceBillID != null && coreBillTypeID.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                coreBillIsMove = true;
                BOSObjectType bosType = BOSUuid.read((String)sourceBillID).getType();
                if (bosType.equals((Object)new TransferOrderBillInfo().getBOSType())) {
                    sourceBillIsMove = true;
                }
            }
        }
        if (coreBillIsMove) {
            String dbType = WriteBackSQLHelper.getDBType(ctx);
            boolean isChecked = false;
            if (sourceBillIsMove) {
                Object[] objectArray;
                String sql = AP2STWriteBackHandler.createAP2STWriteAPBaseSQL(bizAction);
                PreparedStatement ps = null;
                if (bizAction == BizActionEnum.AUDIT) {
                    ps = this.createPreparedStatement("WB_AP2STAPBase", sql);
                } else if (bizAction == BizActionEnum.UNAUDIT) {
                    ps = this.createPreparedStatement("WB_AP2STAPBase_UnAduit", sql);
                } else {
                    throw new IllegalArgumentException("param bizAction must be AUDIT or UNAUDIT !");
                }
                if (!KsqlUtil.isSQLServer(ctx)) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = billId;
                    objectArray2[1] = billId;
                    objectArray2[2] = billId;
                    objectArray = objectArray2;
                    objectArray2[3] = billId;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = billId;
                    objectArray = objectArray3;
                    objectArray3[1] = billId;
                }
                this.executeUpdate(ps, objectArray);
                if (bizAction == BizActionEnum.AUDIT) {
                    this.verifyBaseQty(ctx, billId);
                }
                isChecked = true;
            }
            boolean isWrite = false;
            isWrite = this.isWrite23StockTransfer(billId);
            if (!isWrite) {
                isWrite = this.isWrite4StockTransfer(billId);
            }
            if (isWrite) {
                String sql = AP2STWriteBackHandler.createAP2STWriteSQL(bizAction, billId, isChecked);
                PreparedStatement ps = null;
                if (bizAction == BizActionEnum.AUDIT) {
                    ps = this.createPreparedStatement("WB_AP2ST", sql);
                } else if (bizAction == BizActionEnum.UNAUDIT) {
                    ps = this.createPreparedStatement("WB_AP2ST_UnAduit", sql);
                } else {
                    throw new IllegalArgumentException("param bizAction must be AUDIT or UNAUDIT !");
                }
                ps.execute();
                if (bizAction == BizActionEnum.AUDIT && !isChecked) {
                    this.verifyBaseQty(ctx, billId);
                }
            }
        }
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        if (billId == null) {
            return;
        }
        if (ids == null) {
            return;
        }
        String dbType = WriteBackSQLHelper.getDBType(ctx);
        Vector<BOSObjectType> vct = new Vector<BOSObjectType>(0);
        for (int i = 0; i < billId.length; ++i) {
            for (int j = 0; j < ids.length; ++j) {
                BOSObjectType bosType;
                if (ids[j][1] == null || !(bosType = BOSUuid.read((String)ids[j][1]).getType()).equals((Object)new TransferOrderBillInfo().getBOSType())) continue;
                boolean isChecked = false;
                if (ids[j][0].equals(ids[j][1])) {
                    Object[] objectArray;
                    String sql = AP2STWriteBackHandler.createAP2STWriteAPBaseSQL(bizAction);
                    PreparedStatement ps = null;
                    if (bizAction == BizActionEnum.AUDIT) {
                        ps = this.createPreparedStatement("WB_AP2STAPBase", sql);
                    } else if (bizAction == BizActionEnum.UNAUDIT) {
                        ps = this.createPreparedStatement("WB_AP2STAPBase_UnAduit", sql);
                    }
                    if (!KsqlUtil.isSQLServer(ctx)) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = billId[i];
                        objectArray2[1] = billId[i];
                        objectArray2[2] = billId[i];
                        objectArray = objectArray2;
                        objectArray2[3] = billId[i];
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = billId[i];
                        objectArray = objectArray3;
                        objectArray3[1] = billId[i];
                    }
                    this.executeUpdate(ps, objectArray);
                    if (bizAction == BizActionEnum.AUDIT) {
                        this.verifyBaseQty(ctx, billId[i]);
                    }
                    isChecked = true;
                }
                if (vct.contains(bosType)) continue;
                vct.add(bosType);
                boolean isWrite = false;
                isWrite = this.isWrite23StockTransfer(billId[i]);
                if (!isWrite) {
                    isWrite = this.isWrite4StockTransfer(billId[i]);
                }
                if (!isWrite) continue;
                String sql = AP2STWriteBackHandler.createAP2STWriteSQL(bizAction, billId[i], isChecked);
                PreparedStatement ps = null;
                if (bizAction == BizActionEnum.AUDIT) {
                    ps = this.createPreparedStatement("WB_AP2ST", sql);
                } else if (bizAction == BizActionEnum.UNAUDIT) {
                    ps = this.createPreparedStatement("WB_AP2ST_UnAduit", sql);
                } else {
                    throw new IllegalArgumentException("param bizAction must be AUDIT or UNAUDIT !");
                }
                ps.execute();
                if (bizAction != BizActionEnum.AUDIT || isChecked) continue;
                this.verifyBaseQty(ctx, billId[i]);
            }
        }
    }

    public static String createAP2STWriteAPBaseSQL(BizActionEnum bizAction) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_IM_TransferOrderBillEntry SET (Fid,FApAssociateBaseQty) = ");
        if (bizAction == BizActionEnum.AUDIT) {
            sb.append("(SELECT T_IM_TransferOrderBillEntry.Fid,T_IM_TransferOrderBillEntry.FApAssociateBaseQty - are.FBaseQty FROM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sb.append("(SELECT T_IM_TransferOrderBillEntry.Fid,T_IM_TransferOrderBillEntry.FApAssociateBaseQty + are.FBaseQty FROM ");
        }
        sb.append("(SELECT FParentID,FCoreBillEntryId,SUM(FBaseQty) AS FBaseQty FROM T_AP_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId) are ");
        sb.append("Where are.FCoreBillEntryId = T_IM_TransferOrderBillEntry.Fid AND are.FParentID=? )");
        return sb.toString();
    }

    public static String createAP2STWriteSQL(BizActionEnum bizAction, String parentid, boolean isChecked) {
        StringBuffer sb = new StringBuffer();
        if (!isChecked) {
            sb.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET (FPurInvoiceQty,FPurInvoiceBaseQty,FPurInvoiceAmount,FApAssociateBaseQty) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sb.append("(SELECT ste.FPurInvoiceQty + ROUND(DECIMAL(are.areBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) AS IQ , ste.FPurInvoiceBaseQty + are.areBaseQty AS IBQ ,ste.FPurInvoiceAmount + are.areFAmount AS IAmount ");
                sb.append(",ste.FApAssociateBaseQty - are.areBaseQty ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sb.append("(SELECT ste.FPurInvoiceQty - ROUND(DECIMAL(are.areBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) AS IQ , ste.FPurInvoiceBaseQty - are.areBaseQty AS IBQ ,ste.FPurInvoiceAmount - are.areFAmount AS IAmount ");
                sb.append(",ste.FApAssociateBaseQty + are.areBaseQty ");
            }
        } else {
            sb.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET (FPurInvoiceQty,FPurInvoiceBaseQty,FPurInvoiceAmount) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sb.append("(SELECT ste.FPurInvoiceQty + ROUND(DECIMAL(are.areBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) AS IQ , ste.FPurInvoiceBaseQty + are.areBaseQty AS IBQ ,ste.FPurInvoiceAmount + are.areFAmount AS IAmount ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sb.append("(SELECT ste.FPurInvoiceQty - ROUND(DECIMAL(are.areBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) AS IQ , ste.FPurInvoiceBaseQty - are.areBaseQty AS IBQ ,ste.FPurInvoiceAmount - are.areFAmount AS IAmount ");
            }
        }
        sb.append("FROM T_IM_TransferOrderBillEntry ste ");
        sb.append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ste.FMaterialID AND mmu.FMeasureUnitID=ste.FUnitID  ");
        sb.append("INNER JOIN (SELECT FParentID,FCoreBillEntryId,SUM(FQuantity) AS areFQty ,sum(FBaseQty) as areBaseQty ,SUM(FRecievePayAmount) AS areFAmount FROM T_AP_OtherBillEntry WHERE FParentID='");
        sb.append(parentid);
        sb.append("' GROUP BY FParentID,FCoreBillEntryId) are ");
        sb.append("ON are.FCoreBillEntryId = ste.Fid WHERE are.FParentID='");
        sb.append(parentid);
        sb.append("' AND T1.FID=ste.FID)");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isWrite23StockTransfer(String billID) throws SQLException {
        boolean isWrite = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_APE.Fid from T_AP_OtherBillEntry T_APE ");
        sb.append("INNER JOIN T_AP_OtherBill T_APH on T_APE.FParentID = T_APH.FID ");
        sb.append("INNER JOIN T_SCM_BizType BT on BT.FID = T_APH.FBizTypeID ");
        sb.append("INNER JOIN T_IM_TransferOrderBillEntry STB on STB.Fid = T_APE.FCoreBillEntryID ");
        sb.append(" WHERE T_APE.FParentID=? And (BT.FNumber in ( '310','370','311','371')) And T_APH.FCompanyID = STB.FReceiveCompanyOrgUnitID ");
        ResultSet rs = null;
        String sql = sb.toString();
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("isAPWrite23", sql);
            ps.setString(1, billID);
            rs = ps.executeQuery();
            if (rs.next()) {
                isWrite = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return isWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isWrite4StockTransfer(String billID) throws SQLException {
        boolean isWrite = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_APE.Fid from T_AP_OtherBillEntry T_APE ");
        sb.append("INNER JOIN T_AP_OtherBill T_APH on T_APE.FParentID = T_APH.FID ");
        sb.append("INNER JOIN T_SCM_BizType BT on BT.FID = T_APH.FBizTypeID ");
        sb.append("INNER JOIN T_IM_TransferOrderBill STBH on STBH.Fid = T_APE.FCoreBillID ");
        sb.append(" WHERE T_APE.FParentID=? And BT.FNumber in ('380','381') And T_APH.FCompanyID = STBH.FReceiptCompanyOrgUnitID ");
        ResultSet rs = null;
        String sql = sb.toString();
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("isAPWrite4", sql);
            ps.setString(1, billID);
            rs = ps.executeQuery();
            if (rs.next()) {
                isWrite = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return isWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyBaseQty(Context ctx, String billId) throws EASBizException, BOSException, SQLException {
        String verifySql = this.createAPWriteBackVerifySQL(billId);
        ResultSet rs = null;
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        PreparedStatement ps = null;
        boolean isError = false;
        StringBuffer sb = new StringBuffer();
        try {
            ps = this.createPreparedStatement("Verify_AP2STINV", verifySql);
            rs = ps.executeQuery();
            sb.append(ResourceBase.getString((String)WBRESOURCE, (String)"FApAssociateBaseQtyLessZero", (Locale)ctx.getLocale())).append("\n");
            while (rs.next()) {
                isError = true;
                sb.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"APNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"StockTransOrder", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
                sb.append("\n");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sb.toString()});
        }
    }

    protected String createAPWriteBackVerifySQL(String billId) throws EASBizException, BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ap.FNumber, ape.FSeq, st.FNumber as FWBNumber, ste.FSeq as FWBSeq ,ste.FApAssociateBaseQty as FApAssociateBaseQty ");
        sb.append("FROM T_IM_TransferOrderBillEntry ste ");
        sb.append("INNER JOIN T_IM_TransferOrderBill st ON st.FID=ste.FParentID ");
        sb.append("INNER JOIN T_AP_OtherBillEntry ape ON ape.FCoreBillEntryId=ste.FID ");
        sb.append("INNER JOIN T_AP_OtherBill ap ON ap.FID=ape.FParentID ");
        sb.append("WHERE ap.FID= '");
        sb.append(billId);
        sb.append("' AND ape.FCoreBillEntryId IN( ");
        sb.append("SELECT ape.FCoreBillEntryId ");
        sb.append("FROM (SELECT FParentID,FCoreBillEntryId,SUM(FBaseQty) AS FBaseQty FROM T_AP_OtherBillEntry WHERE FParentID='");
        sb.append(billId);
        sb.append("' GROUP BY FParentID,FCoreBillEntryId) ape ");
        sb.append("INNER JOIN T_IM_TransferOrderBillEntry ste ON ape.FCoreBillEntryId = ste.FID ");
        sb.append("WHERE ape.FParentID = '");
        sb.append(billId);
        sb.append("' AND ");
        sb.append("ste.FNotControlQty=0 and ABS(ste.FApAssociateBaseQty + ape.FBaseQty + ste.FBaseQty*FQtyOverRate/100) < ABS(ape.FBaseQty))");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTotalAPBaseQty(String billId) throws EASBizException, BOSException, SQLException {
        String verifySql = this.createVerifyTotalAPQtySQL(billId);
        ResultSet rs = null;
        PreparedStatement ps = null;
        boolean isError = false;
        StringBuffer sbEntry = new StringBuffer();
        StringBuffer sbHead = new StringBuffer();
        try {
            ps = this.createPreparedStatement("Verify_AR2ST", verifySql);
            rs = ps.executeQuery();
            sbHead.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.PurInvoiceBaseQtyLessBaseQty")).append("\n");
            while (rs.next()) {
                isError = true;
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.ARNO")).append("\t");
                sbEntry.append(rs.getString("FNumber")).append(",\t");
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append("\t");
                sbEntry.append(rs.getInt("FSeq")).append(";\t");
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.StockTransOrder"));
                sbEntry.append(":").append(rs.getString("FWBNumber")).append(",\t\t");
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.StockTransOrderEntry")).append("\t");
                sbEntry.append(rs.getInt("FWBSeq")).append(";\n");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sbHead.append(sbEntry).toString()});
        }
    }

    protected String createVerifyTotalAPQtySQL(String billId) throws EASBizException, BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ar.FNumber, are.FSeq, st.FNumber as FWBNumber, ste.FSeq as FWBSeq ");
        sb.append("FROM T_IM_TransferOrderBillEntry ste ");
        sb.append("INNER JOIN T_IM_TransferOrderBill st ON st.FID=ste.FParentID ");
        sb.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=ste.FID ");
        sb.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
        sb.append("WHERE ar.FID= '");
        sb.append(billId);
        sb.append("' AND are.FCoreBillEntryId IN( ");
        sb.append("SELECT are.FCoreBillEntryId ");
        sb.append("FROM T_AR_OtherBillEntry are ");
        sb.append("INNER JOIN T_IM_TransferOrderBillEntry ste ON are.FCoreBillEntryId = ste.FID ");
        sb.append("WHERE are.FParentID = '");
        sb.append(billId);
        sb.append("' AND ");
        sb.append("ABS(ste.FbaseQty)<ABS(ste.FPurInvoiceBaseQty))");
        return sb.toString();
    }
}

