/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.fi.arap.api.IArapBillEntryInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;

public class AR2STWriteBackHandler
extends AbstractWriteBackHandler {
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)destBillInfo;
        if (destBillInfo == null) {
            return;
        }
        if (destBillInfo.getInt("billType") == 203) {
            return;
        }
        String billId = otherBillInfo.getId().toString();
        boolean coreBillIsMove = false;
        boolean sourceBillIsMove = false;
        IObjectCollection otherBillEntryCollection = otherBillInfo.getEntries();
        if (otherBillEntryCollection.size() == 0) {
            return;
        }
        IArapBillEntryInfo otherBillentryInfo = (IArapBillEntryInfo)otherBillEntryCollection.getObject(0);
        if (otherBillentryInfo != null) {
            String sourceBillID;
            String coreBillTypeID = otherBillentryInfo.getCoreBillTypeId();
            String string = sourceBillID = otherBillentryInfo.getSourceBillId() == null ? null : otherBillentryInfo.getSourceBillId().toString();
            if (coreBillTypeID != null && sourceBillID != null && coreBillTypeID.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                coreBillIsMove = true;
                BOSObjectType bosType = BOSUuid.read((String)sourceBillID).getType();
                if (bosType.equals((Object)new TransferOrderBillInfo().getBOSType())) {
                    sourceBillIsMove = true;
                }
            }
        }
        if (coreBillIsMove) {
            boolean isChecked = false;
            if (sourceBillIsMove) {
                Object[] objectArray;
                String sql = AR2STWriteBackHandler.createAR2STWriteARBaseSQL(bizAction);
                PreparedStatement ps = null;
                if (bizAction == BizActionEnum.AUDIT) {
                    ps = this.createPreparedStatement("WB_AR2STARBase", sql);
                } else if (bizAction == BizActionEnum.UNAUDIT) {
                    ps = this.createPreparedStatement("WB_AR2STARBase_UnAduit", sql);
                }
                if (!KsqlUtil.isSQLServer(ctx)) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = billId;
                    objectArray2[1] = billId;
                    objectArray2[2] = billId;
                    objectArray = objectArray2;
                    objectArray2[3] = billId;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = billId;
                    objectArray = objectArray3;
                    objectArray3[1] = billId;
                }
                this.executeUpdate(ps, objectArray);
                if (bizAction == BizActionEnum.AUDIT) {
                    this.verifyBaseQty(ctx, billId);
                    isChecked = true;
                }
            }
            boolean isWrite = false;
            isWrite = this.isWrite2StockTransfer(billId);
            if (!isWrite) {
                isWrite = this.isWrite34StockTransfer(billId);
            }
            if (isWrite) {
                String sql = AR2STWriteBackHandler.createAR2STWriteSQL(bizAction, billId, isChecked);
                PreparedStatement ps = null;
                if (bizAction == BizActionEnum.AUDIT) {
                    ps = this.createPreparedStatement("WB_AR2ST", sql);
                } else if (bizAction == BizActionEnum.UNAUDIT) {
                    ps = this.createPreparedStatement("WB_AR2ST_UnAduit", sql);
                } else {
                    throw new IllegalArgumentException("param bizAction must be AUDIT or UNAUDIT !");
                }
                ps.execute();
                if (ps != null) {
                    ps.close();
                }
                if (bizAction == BizActionEnum.AUDIT && !isChecked) {
                    this.verifyBaseQty(ctx, billId);
                }
            }
        }
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        if (billId == null) {
            return;
        }
        if (ids == null) {
            return;
        }
        String dbType = WriteBackSQLHelper.getDBType(ctx);
        Vector<BOSObjectType> vct = new Vector<BOSObjectType>(0);
        for (int i = 0; i < billId.length; ++i) {
            boolean isWriteTransferOrderBill = false;
            for (int j = 0; j < ids.length; ++j) {
                BOSObjectType bosType;
                if (ids[j][1] == null || !(bosType = BOSUuid.read((String)ids[j][1]).getType()).equals((Object)new TransferOrderBillInfo().getBOSType()) || isWriteTransferOrderBill) continue;
                boolean isChecked = false;
                if (ids[j][0].equals(ids[j][1])) {
                    Object[] objectArray;
                    String sql = AR2STWriteBackHandler.createAR2STWriteARBaseSQL(bizAction);
                    PreparedStatement ps = null;
                    if (bizAction == BizActionEnum.AUDIT) {
                        ps = this.createPreparedStatement("WB_AR2STARBase", sql);
                    } else if (bizAction == BizActionEnum.UNAUDIT) {
                        ps = this.createPreparedStatement("WB_AR2STARBase_UnAduit", sql);
                    }
                    if (!KsqlUtil.isSQLServer(ctx)) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = billId[i];
                        objectArray2[1] = billId[i];
                        objectArray2[2] = billId[i];
                        objectArray = objectArray2;
                        objectArray2[3] = billId[i];
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = billId[i];
                        objectArray = objectArray3;
                        objectArray3[1] = billId[i];
                    }
                    this.executeUpdate(ps, objectArray);
                    if (bizAction == BizActionEnum.AUDIT) {
                        this.verifyBaseQty(ctx, billId[i]);
                    }
                    isChecked = true;
                }
                if (vct.contains(bosType)) continue;
                vct.add(bosType);
                boolean isWrite = false;
                isWrite = this.isWrite2StockTransfer(billId[i]);
                if (!isWrite) {
                    isWrite = this.isWrite34StockTransfer(billId[i]);
                }
                if (isWrite) {
                    String sql = AR2STWriteBackHandler.createAR2STWriteSQL(bizAction, billId[i], isChecked);
                    PreparedStatement ps = null;
                    if (bizAction == BizActionEnum.AUDIT) {
                        ps = this.createPreparedStatement("WB_AR2ST", sql);
                    } else if (bizAction == BizActionEnum.UNAUDIT) {
                        ps = this.createPreparedStatement("WB_AR2ST_UnAduit", sql);
                    } else {
                        throw new IllegalArgumentException("param bizAction must be AUDIT or UNAUDIT !");
                    }
                    ps.execute();
                    if (ps != null) {
                        ps.close();
                        String psKey = "WB_AR2STARBase";
                        if (bizAction == BizActionEnum.AUDIT) {
                            psKey = "WB_AR2STARBase";
                        } else if (bizAction == BizActionEnum.UNAUDIT) {
                            psKey = "WB_AR2STARBase_UnAduit";
                        }
                        this.psMap.remove(psKey);
                    }
                    if (bizAction == BizActionEnum.AUDIT && !isChecked) {
                        this.verifyBaseQty(ctx, billId[i]);
                    }
                }
                isWriteTransferOrderBill = true;
            }
        }
    }

    public static String createAR2STWriteARBaseSQL(BizActionEnum bizAction) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_IM_TransferOrderBillEntry SET (FID,FArAssociateBaseQty) = ");
        if (bizAction == BizActionEnum.AUDIT) {
            sb.append("(select T_IM_TransferOrderBillEntry.Fid,T_IM_TransferOrderBillEntry.FArAssociateBaseQty - are.FBaseQty FROM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sb.append("(select T_IM_TransferOrderBillEntry.Fid,T_IM_TransferOrderBillEntry.FArAssociateBaseQty + are.FBaseQty FROM ");
        }
        sb.append("(SELECT FParentID,FCoreBillEntryId  as FCoreBillEntryId ,SUM(FBaseQty) AS FBaseQty ");
        sb.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId ) are ");
        sb.append("WHERE are.FCoreBillEntryId = T_IM_TransferOrderBillEntry.Fid ");
        sb.append("AND are.FParentID=?  )");
        return sb.toString();
    }

    public static String createAR2STWriteSQL(BizActionEnum bizAction, String parentid, boolean isChecked) {
        StringBuffer sb = new StringBuffer();
        if (!isChecked) {
            sb.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET (FSaleInvoiceQty,FSaleInvoiceBaseQty,FSaleInvoiceAmount,FArAssociateBaseQty) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sb.append("(SELECT ste.FSaleInvoiceQty + are.areFQty AS IQ , ste.FSaleInvoiceBaseQty + are.areBaseQty AS IBQ ,ste.FSaleInvoiceAmount + are.areFAmount AS IAmount ");
                sb.append(",ste.FArAssociateBaseQty - are.areBaseQty ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sb.append("(SELECT ste.FSaleInvoiceQty - are.areFQty AS IQ , ste.FSaleInvoiceBaseQty - are.areBaseQty AS IBQ ,ste.FSaleInvoiceAmount - are.areFAmount AS IAmount ");
                sb.append(",ste.FArAssociateBaseQty + are.areBaseQty ");
            }
        } else {
            sb.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET (FSaleInvoiceQty,FSaleInvoiceBaseQty,FSaleInvoiceAmount) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sb.append("(SELECT ste.FSaleInvoiceQty + are.areFQty AS IQ , ste.FSaleInvoiceBaseQty + are.areBaseQty AS IBQ ,ste.FSaleInvoiceAmount + are.areFAmount AS IAmount ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sb.append("(SELECT ste.FSaleInvoiceQty - are.areFQty AS IQ , ste.FSaleInvoiceBaseQty - are.areBaseQty AS IBQ ,ste.FSaleInvoiceAmount - are.areFAmount AS IAmount ");
            }
        }
        sb.append("FROM T_IM_TransferOrderBillEntry ste ");
        sb.append("INNER JOIN (SELECT FParentID,FCoreBillEntryId ,sum(FQuantity) as areFQty,sum(FBaseQty) as areBaseQty ,sum(FRecievePayAmount) as areFAmount ");
        sb.append("FROM T_AR_OtherBillEntry WHERE FParentID='");
        sb.append(parentid);
        sb.append("' GROUP BY FParentID,FCoreBillEntryId) are ");
        sb.append("ON are.FCoreBillEntryId = ste.Fid WHERE are.FParentID='");
        sb.append(parentid);
        sb.append("' AND T1.FID=ste.FID)");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isWrite2StockTransfer(String billID) throws SQLException {
        boolean isWrite = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_ARE.Fid from T_AR_OtherBillEntry T_ARE ");
        sb.append("INNER JOIN T_AR_OtherBill T_ARH on T_ARE.FParentID = T_ARH.FID ");
        sb.append("INNER JOIN T_SCM_BizType BT on BT.FID = T_ARH.FBizTypeID ");
        sb.append("INNER JOIN T_IM_TransferOrderBillEntry STB on STB.Fid = T_ARE.FCoreBillEntryID ");
        sb.append(" WHERE T_ARE.FParentID=? And BT.FNumber in ('310','311') And T_ARH.FCompanyID = STB.FIssueCompanyOrgUnitID ");
        ResultSet rs = null;
        String sql = sb.toString();
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("isARWrite2", sql);
            ps.setString(1, billID);
            rs = ps.executeQuery();
            if (rs.next()) {
                isWrite = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return isWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isWrite34StockTransfer(String billID) throws SQLException {
        boolean isWrite = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_ARE.Fid from T_AR_OtherBillEntry T_ARE ");
        sb.append("INNER JOIN T_AR_OtherBill T_ARH on T_ARE.FParentID = T_ARH.FID ");
        sb.append("INNER JOIN T_SCM_BizType BT on BT.FID = T_ARH.FBizTypeID ");
        sb.append("INNER JOIN T_IM_TransferOrderBill STBH on STBH.Fid = T_ARE.FCoreBillID ");
        sb.append(" WHERE T_ARE.FParentID=? And (BT.FNumber in( '370','380','371','381')) And T_ARH.FCompanyID = STBH.FIssueCompanyOrgUnitID ");
        ResultSet rs = null;
        String sql = sb.toString();
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("isARWrite34", sql);
            ps.setString(1, billID);
            rs = ps.executeQuery();
            if (rs.next()) {
                isWrite = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return isWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyBaseQty(Context ctx, String billId) throws EASBizException, BOSException, SQLException {
        String verifySql = this.createARWriteBackVerifySQL(billId);
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("Verify_AR2ST", verifySql);
            rs = ps.executeQuery();
            String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
            StringBuffer sb = new StringBuffer();
            sb.append(ResourceBase.getString((String)WBRESOURCE, (String)"FArAssociateBaseQtyLessZero", (Locale)ctx.getLocale())).append("\n");
            boolean isError = false;
            while (rs.next()) {
                isError = true;
                sb.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"ARNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"StockTransOrder", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
                sb.append("\n");
            }
            if (isError) {
                throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sb.toString()});
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        this.psMap.remove("Verify_AR2ST");
    }

    protected String createARWriteBackVerifySQL(String billId) throws EASBizException, BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ar.FNumber, are.FSeq, st.FNumber as FWBNumber, ste.FSeq as FWBSeq,ste.FArAssociateBaseQty as FArAssociateBaseQty ");
        sb.append("FROM T_IM_TransferOrderBillEntry ste ");
        sb.append("INNER JOIN T_IM_TransferOrderBill st ON st.FID=ste.FParentID ");
        sb.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=ste.FID ");
        sb.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
        sb.append("WHERE ar.FID= '");
        sb.append(billId);
        sb.append("' AND are.FCoreBillEntryId IN( ");
        sb.append("SELECT are.FCoreBillEntryId ");
        sb.append("FROM (SELECT FParentID,FCoreBillEntryId,SUM(FBaseQty) AS FBaseQty FROM T_AR_OtherBillEntry WHERE FParentID='");
        sb.append(billId);
        sb.append("' GROUP BY FParentID,FCoreBillEntryId) are ");
        sb.append("INNER JOIN T_IM_TransferOrderBillEntry ste ON are.FCoreBillEntryId = ste.FID ");
        sb.append("WHERE are.FParentID = '");
        sb.append(billId);
        sb.append("' AND ");
        sb.append("ste.FNotControlQty=0 and ABS(ste.FArAssociateBaseQty + are.FBaseQty + ste.FBaseQty*FQtyOverRate/100) < ABS(are.FBaseQty))");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTotalARBaseQty(String billId) throws EASBizException, BOSException, SQLException {
        String verifySql = this.createVerifyTotalARQtySQL(billId);
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.createPreparedStatement("Verify_AR2STINV", verifySql);
            rs = ps.executeQuery();
            StringBuffer sbHead = new StringBuffer();
            sbHead.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SaleInvoiceBaseQtyLessBaseQty")).append("\n");
            boolean isError = false;
            StringBuffer sbEntry = new StringBuffer();
            while (rs.next()) {
                isError = true;
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.ARNO")).append("\t");
                sbEntry.append(rs.getString("FNumber")).append(",\t");
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append("\t");
                sbEntry.append(rs.getInt("FSeq")).append(";\t");
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.StockTransOrder"));
                sbEntry.append(":").append(rs.getString("FWBNumber")).append(",\t\t");
                sbEntry.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.StockTransOrderEntry")).append("\t");
                sbEntry.append(rs.getInt("FWBSeq")).append(";\n");
            }
            if (isError) {
                throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sbHead.append(sbEntry).toString()});
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    protected String createVerifyTotalARQtySQL(String billId) throws EASBizException, BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ar.FNumber, are.FSeq, st.FNumber as FWBNumber, ste.FSeq as FWBSeq ");
        sb.append("FROM T_IM_TransferOrderBillEntry ste ");
        sb.append("INNER JOIN T_IM_TransferOrderBill st ON st.FID=ste.FParentID ");
        sb.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=ste.FID ");
        sb.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
        sb.append("WHERE ar.FID= '");
        sb.append(billId);
        sb.append("' AND are.FCoreBillEntryId IN( ");
        sb.append("SELECT are.FCoreBillEntryId ");
        sb.append("FROM T_AR_OtherBillEntry are ");
        sb.append("INNER JOIN T_IM_TransferOrderBillEntry ste ON are.FCoreBillEntryId = ste.FID ");
        sb.append("WHERE are.FParentID = '");
        sb.append(billId);
        sb.append("' AND ");
        sb.append(" ABS(ste.FbaseQty)<ABS(ste.FSaleInvoiceBaseQty))");
        return sb.toString();
    }
}

