/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.fi.arap.api.IArapBillEntryInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IC2SIWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger(IC2SIWriteBackHandler.class);
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (destBillInfo == null) {
            logger.info((Object)"IC Writeback data is null");
            return;
        }
        LowTimer lt = new LowTimer();
        boolean[] isWriteCore = new boolean[]{true, false};
        IArApBillHeadInfo incomeConfimBillInfo = (IArApBillHeadInfo)destBillInfo;
        if (13 != incomeConfimBillInfo.getSourceBillType().getValue()) {
            return;
        }
        IObjectCollection incomeConfimEntryCollection = incomeConfimBillInfo.getEntries();
        int size = incomeConfimEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            IArapBillEntryInfo incomeConfimEntryInfo = (IArapBillEntryInfo)incomeConfimEntryCollection.getObject(i);
            if (incomeConfimEntryInfo == null) continue;
            String coreBillTypeID = incomeConfimEntryInfo.getCoreBillId();
            if (coreBillTypeID != null) {
                if (!coreBillTypeID.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) continue;
                isWriteCore[1] = true;
                continue;
            }
            isWriteCore[1] = true;
        }
        String id = incomeConfimBillInfo.getId().toString();
        this.writeBackSaleIssueBill(bizAction, ctx, id);
        if (isWriteCore[1]) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"IC Writeback Order");
            }
            this.writeBackOrder(bizAction, ctx, id);
        }
        if (bizAction == BizActionEnum.AUDIT) {
            boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, incomeConfimBillInfo.getCompany());
            if (isWriteCore[1]) {
                boolean isArQtyGtSiSysParam = true;
                if (incomeConfimBillInfo.getCompany() != null && incomeConfimBillInfo.getCompany().getId() != null) {
                    isArQtyGtSiSysParam = WriteBackSQLHelper.isSysParamValue(ctx, incomeConfimBillInfo.getCompany().getId().toString(), "AR_QTY_CANT_GT_SI", true);
                }
                String idList = WriteBackSQLHelper.getKeyIdList(new String[]{id});
                this.verify(ctx, idList, isArQtyGtSoSysParam, isArQtyGtSiSysParam);
            }
        }
        logger.info((Object)("IC Writeback Total " + incomeConfimEntryCollection.size() + " Entries: " + lt.msValue()));
    }

    private void writeBackSaleIssueBill(BizActionEnum bizAction, Context ctx, String id) throws SQLException, BOSException {
        Object[] objectArray;
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_IC2SI", WriteBackSQLHelper.createICSIWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_IC2SI_UnAduit", WriteBackSQLHelper.createICSIWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = id;
            objectArray = objectArray2;
            objectArray2[1] = id;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = id;
        }
        this.executeUpdate(ps, objectArray);
    }

    private void writeBackOrder(BizActionEnum bizAction, Context ctx, String id) throws SQLException {
        Object[] objectArray;
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_IC2SO", WriteBackSQLHelper.createIC2SOWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_IC2SO_UnAduit", WriteBackSQLHelper.createIC2SOWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = id;
            objectArray2[1] = id;
            objectArray = objectArray2;
            objectArray2[2] = id;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = id;
            objectArray = objectArray3;
            objectArray3[1] = id;
        }
        this.executeUpdate(ps, objectArray);
    }

    private void verify(Context ctx, String idList, boolean isArQtyGtSoSysParam, boolean isArQtyGtSiSysParam) throws SCMBillException, SQLException, BOSException {
        StringBuffer saleOrderQuery = new StringBuffer();
        if (isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
            return;
        }
        if (isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
            saleOrderQuery.append("SELECT 2 as FErrType,");
        }
        if (!isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
            saleOrderQuery.append("SELECT case when (ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
        }
        if (!isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
            saleOrderQuery.append("SELECT 1 as FErrType,");
        }
        saleOrderQuery.append(" ICBILLE.FSEQ AS FSEQ,ICBILL.FNUMBER AS FNUMBER,SALEORDER.FNUMBER AS FWBNUMBER,SALEORDERE.FSEQ AS FWBSEQ");
        saleOrderQuery.append(" FROM T_AR_INCOMECONFIMBILL ICBILL INNER JOIN T_AR_INCOMECONFIMENTRY ICBILLE ON ICBILL.FID = ICBILLE.FPARENTID");
        saleOrderQuery.append(" LEFT OUTER JOIN T_SD_SALEORDERENTRY SALEORDERE ON SALEORDERE.FID = ICBILLE.FCOREBILLENTRYID ");
        saleOrderQuery.append(" INNER JOIN T_SD_SaleOrder SALEORDER ON SALEORDER.FID=SALEORDERE.FParentID");
        saleOrderQuery.append(" WHERE ICBILL.FID = ").append(idList);
        if (isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
            saleOrderQuery.append(" AND ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0");
        }
        if (!isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
            saleOrderQuery.append(" AND ((ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0) > ISNULL(SALEORDERE.FQTY,0) ");
            saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0)");
            saleOrderQuery.append(" OR (ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0) <= ISNULL(SALEORDERE.FQTY,0)");
            saleOrderQuery.append(" AND ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0) )");
        }
        if (!isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
            saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0");
        }
        saleOrderQuery.append(" AND ICBILLE.FQUANTITY >= 0 ");
        saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
        this.verifyAPWriteBack(ctx, rowSet);
    }

    private void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"IC_SALEORDERERRO", (Locale)ctx.getLocale())).append("\n");
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"IC_SIORDERERROR", (Locale)ctx.getLocale())).append("\n");
                }
            }
            sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"ICNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"SALEORDER", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
            sql.append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    private void batchWriteBackSaleIssueBill(BizActionEnum bizAction, String idList, String tablename) throws SQLException, BOSException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("B_WB_SI", WriteBackSQLHelper.createIC2SIWriteSQL(idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("B_WB_SI_UnAduit", WriteBackSQLHelper.createIC2SIWriteSQL(idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackOrder(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("B_WB_SO", WriteBackSQLHelper.createIC2SOWriteSQL(bizAction, idList, tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("B_WB_SO_UnAduit", WriteBackSQLHelper.createIC2SOWriteSQL(bizAction, idList, tablename));
        }
        this.executeUpdate(ps, null);
    }

    private String createTempTableCore(Context ctx, String idList) throws SQLException, BOSException {
        String CR_TEMP = WriteBackSQLHelper.getIC2SOTempTableSQL("xxx");
        String tablename = KsqlUtil.createTempTable(ctx, CR_TEMP);
        PreparedStatement ps = null;
        String WB_TEMP = WriteBackSQLHelper.getIC2SOInsertTempSQL(idList, tablename);
        ps = this.createPreparedStatement("WB_IC2SO_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    private String createTempTableSource(Context ctx, BizActionEnum bizAction, String idList) throws SQLException, BOSException {
        String CR_TEMP_S = WriteBackSQLHelper.getIC2SITempTableSQL("xxx");
        String tablename = KsqlUtil.createTempTable(ctx, CR_TEMP_S);
        PreparedStatement ps = null;
        String WB_TEMP_S = WriteBackSQLHelper.getIC2SIInsertTempSQL(bizAction, idList, tablename);
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_IC2SI_TEMP_S", WB_TEMP_S);
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_IC2SI_TEMP_S_UnAduit", WB_TEMP_S);
        }
        this.executeUpdate(ps, null);
        return tablename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        String tablename_source;
        String tablename_core;
        String idList;
        LowTimer lt;
        block7: {
            lt = new LowTimer();
            boolean[] isWriteCore = new boolean[]{false, false};
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                String coreBosType;
                BOSObjectType coreBosTypeObj;
                BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
                if (coreBosTypeObj == null || !(coreBosType = coreBosTypeObj.toString()).equals("C48A423A")) continue;
                isWriteCore[1] = true;
            }
            idList = WriteBackSQLHelper.getKeyIdList(billId);
            tablename_core = null;
            tablename_source = null;
            try {
                tablename_core = this.createTempTableCore(ctx, idList);
                tablename_source = this.createTempTableSource(ctx, bizAction, idList);
                this.batchWriteBackSaleIssueBill(bizAction, idList, tablename_source);
                if (isWriteCore[1]) {
                    if (logger.isDebugEnabled()) {
                        logger.info((Object)"IC Writeback Order");
                    }
                    this.batchWriteBackOrder(bizAction, idList, tablename_core);
                }
                if (bizAction != BizActionEnum.AUDIT) break block7;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billId[0]), (SelectorItemCollection)sic);
                boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, otherBillInfo.getCompany());
                if (isWriteCore[1]) {
                    boolean isArQtyGtSiSysParam = true;
                    if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                        isArQtyGtSiSysParam = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AR_QTY_CANT_GT_SI", true);
                    }
                    this.verify(ctx, idList, isArQtyGtSoSysParam, isArQtyGtSiSysParam);
                }
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable(ctx, tablename_source);
                KsqlUtil.releaseTempTable(ctx, tablename_core);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable(ctx, tablename_source);
        KsqlUtil.releaseTempTable(ctx, tablename_core);
        logger.info((Object)("IC Writeback Total " + idList.length() + " Bills: " + lt.msValue()));
    }
}

