/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IC2SOWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger(IC2SOWriteBackHandler.class);
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        Object[] objectArray;
        if (destBillInfo == null) {
            logger.info((Object)"IC Writeback data is null");
            return;
        }
        IArApBillHeadInfo incomeConfimBillInfo = (IArApBillHeadInfo)destBillInfo;
        if (13 != incomeConfimBillInfo.getSourceBillType().getValue()) {
            return;
        }
        String id = incomeConfimBillInfo.getId().toString();
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_IC2SO", WriteBackSQLHelper.createIC2SOWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_IC2SO_UnAduit", WriteBackSQLHelper.createIC2SOWriteSQLDialect(bizAction, ctx));
        }
        if (!KsqlUtil.isSQLServer(ctx)) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = id;
            objectArray2[1] = id;
            objectArray = objectArray2;
            objectArray2[2] = id;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = id;
            objectArray = objectArray3;
            objectArray3[1] = id;
        }
        this.executeUpdate(ps, objectArray);
        if (bizAction == BizActionEnum.AUDIT) {
            boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, incomeConfimBillInfo.getCompany());
            boolean isArQtyGtSiSysParam = true;
            boolean verifyIssueQty = true;
            if (incomeConfimBillInfo.getCompany() != null && incomeConfimBillInfo.getCompany().getId() != null) {
                isArQtyGtSiSysParam = WriteBackSQLHelper.isSysParamValue(ctx, incomeConfimBillInfo.getCompany().getId().toString(), "AR_QTY_CANT_GT_SI", true);
                verifyIssueQty = WriteBackSQLHelper.isSysParamValue(ctx, incomeConfimBillInfo.getCompany().getId().toString(), "AR_033", true);
            }
            String idList = WriteBackSQLHelper.getKeyIdList(new String[]{id});
            this.verify(ctx, idList, isArQtyGtSoSysParam, isArQtyGtSiSysParam, verifyIssueQty);
        }
    }

    private void verify(String id, boolean isArQtyGtSoSysParam) throws SCMBillException, SQLException {
        if (!isArQtyGtSoSysParam) {
            ArrayList params = new ArrayList(3);
            boolean[] isWriteCore = new boolean[]{false, true, false, false};
            String VERIFY = WriteBackSQLHelper.createARWriteBackVerifySQL(id, isWriteCore, params, isArQtyGtSoSysParam, false);
            PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
            IRowSet rs = this.executeQuery(ps, params.toArray());
            WriteBackSQLHelper.verifyARWriteBack(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = "AR2SOWB_KSQL_0";
            tablename = KsqlUtil.createTempTable(ctx, WriteBackSQLHelper.getIC2SOTempTableSQL(tablename));
            String WB_TEMP = WriteBackSQLHelper.getIC2SOInsertTempSQL(idList, tablename);
            PreparedStatement pstmt = this.createPreparedStatement("WB_TEMP", WB_TEMP);
            this.executeUpdate(pstmt, null);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT || bizAction == BizActionEnum.SUBMIT) {
                ps = this.createPreparedStatement("B_WB_SO", WriteBackSQLHelper.createIC2SOWriteSQL(BizActionEnum.AUDIT, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("B_WB_SO_UnAduit", WriteBackSQLHelper.createIC2SOWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                BillBaseInfo otherBillInfo = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billId[0]), (SelectorItemCollection)sic);
                boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, otherBillInfo.getCompany());
                boolean isArQtyGtSiSysParam = true;
                boolean verifyIssueQty = true;
                if (otherBillInfo.getCompany() != null && otherBillInfo.getCompany().getId() != null) {
                    isArQtyGtSiSysParam = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AR_QTY_CANT_GT_SI", true);
                    verifyIssueQty = WriteBackSQLHelper.isSysParamValue(ctx, otherBillInfo.getCompany().getId().toString(), "AR_033", true);
                }
                this.verify(ctx, idList, isArQtyGtSoSysParam, isArQtyGtSiSysParam, verifyIssueQty);
            }
        }
        finally {
            if (tablename != null) {
                KsqlUtil.releaseTempTable(ctx, tablename);
            }
        }
    }

    private void verify(Context ctx, String idList, boolean isArQtyGtSoSysParam, boolean isArQtyGtSiSysParam, boolean verifyIssueQty) throws SCMBillException, SQLException, BOSException {
        IRowSet rowSet;
        StringBuffer saleOrderQuery = new StringBuffer();
        if (verifyIssueQty) {
            if (!isArQtyGtSiSysParam && !isArQtyGtSoSysParam) {
                saleOrderQuery.append("SELECT 1 as FErrType,");
            } else if (isArQtyGtSiSysParam && isArQtyGtSoSysParam) {
                saleOrderQuery.append("SELECT 2 as FErrType,");
            } else if (isArQtyGtSiSysParam && !isArQtyGtSoSysParam) {
                saleOrderQuery.append("SELECT case when (ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FQTY,0)) >= 0 then 1 else 2 end  as FErrType,");
            }
        } else {
            if (isArQtyGtSoSysParam) {
                return;
            }
            saleOrderQuery.append("SELECT 1 as FErrType,");
        }
        saleOrderQuery.append(" ICBILLE.FSEQ AS FSEQ,ICBILL.FNUMBER AS FNUMBER, SALEORDER.FNUMBER AS FWBNUMBER,SALEORDERE.FSEQ AS FWBSEQ");
        saleOrderQuery.append(" FROM T_AR_INCOMECONFIMBILL ICBILL INNER JOIN T_AR_INCOMECONFIMENTRY ICBILLE ON ICBILL.FID = ICBILLE.FPARENTID");
        saleOrderQuery.append(" LEFT OUTER JOIN T_SD_SALEORDERENTRY SALEORDERE ON SALEORDERE.FID = ICBILLE.FCOREBILLENTRYID ");
        saleOrderQuery.append(" INNER JOIN T_SD_SaleOrder SALEORDER ON SALEORDER.FID=SALEORDERE.FParentID");
        saleOrderQuery.append(" WHERE ICBILL.FID = ").append(idList);
        saleOrderQuery.append(" AND SALEORDER.FBIZTYPEID <> '").append("d8e80652-0111-1000-e000-04c5c0a812202407435C").append("'");
        if (verifyIssueQty) {
            if (isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0");
                saleOrderQuery.append(" AND ICBILLE.FQUANTITY >= 0 ");
                saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
                this.verifyAPWriteBack(ctx, rowSet);
            } else if (!isArQtyGtSoSysParam && isArQtyGtSiSysParam) {
                saleOrderQuery.append(" AND ((ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0) >= ISNULL(SALEORDERE.FQTY,0) ");
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0)");
                saleOrderQuery.append(" OR (ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0) < ISNULL(SALEORDERE.FQTY,0)");
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FTOTALISSUEQTY,0)-ISNULL(SALEORDERE.FTOTALCANCELLINGSTOCKQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0) )");
                saleOrderQuery.append(" AND ICBILLE.FQUANTITY >= 0 ");
                saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
                this.verifyAPWriteBack(ctx, rowSet);
            } else if (!isArQtyGtSoSysParam && !isArQtyGtSiSysParam) {
                saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0");
                saleOrderQuery.append(" AND ICBILLE.FQUANTITY >= 0 ");
                saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
                this.verifyAPWriteBack(ctx, rowSet);
            }
        } else if (!isArQtyGtSoSysParam) {
            saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0");
            saleOrderQuery.append(" AND ICBILLE.FQUANTITY >= 0 ");
            saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
            this.verifyAPWriteBack(ctx, rowSet);
        }
        if (!isArQtyGtSoSysParam) {
            saleOrderQuery.setLength(0);
            saleOrderQuery.append("SELECT 1 as FErrType,ICBILLE.FSEQ AS FSEQ,ICBILL.FNUMBER AS FNUMBER, SALEORDER.FNUMBER AS FWBNUMBER,SALEORDERE.FSEQ AS FWBSEQ");
            saleOrderQuery.append(" FROM T_AR_INCOMECONFIMBILL ICBILL INNER JOIN T_AR_INCOMECONFIMENTRY ICBILLE ON ICBILL.FID = ICBILLE.FPARENTID");
            saleOrderQuery.append(" LEFT OUTER JOIN T_SD_SALEORDERENTRY SALEORDERE ON SALEORDERE.FID = ICBILLE.FCOREBILLENTRYID ");
            saleOrderQuery.append(" INNER JOIN T_SD_SaleOrder SALEORDER ON SALEORDER.FID=SALEORDERE.FParentID");
            saleOrderQuery.append(" WHERE ICBILL.FID = ").append(idList);
            saleOrderQuery.append(" AND SALEORDER.FBIZTYPEID = '").append("d8e80652-0111-1000-e000-04c5c0a812202407435C").append("'");
            saleOrderQuery.append(" AND ISNULL(SALEORDERE.FQTY,0)-ISNULL(SALEORDERE.FTOTALINCOMECONFIRMQTY,0) < 0");
            saleOrderQuery.append(" order by SALEORDERE.FSEQ ASC");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)saleOrderQuery.toString());
            this.verifyAPWriteBack(ctx, rowSet);
        }
    }

    private void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        String errorMsg = ResourceBase.getString((String)WBRESOURCE, (String)"WriteBackQtyErrorMsg", (Locale)ctx.getLocale());
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"IC_SALEORDERERRO", (Locale)ctx.getLocale())).append("\n");
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"IC_SIORDERERROR", (Locale)ctx.getLocale())).append("\n");
                }
            }
            sql.append(MessageFormat.format(errorMsg, ResourceBase.getString((String)WBRESOURCE, (String)"ICNO", (Locale)ctx.getLocale()), rs.getString("FNumber"), rs.getInt("FSeq"), ResourceBase.getString((String)WBRESOURCE, (String)"SALEORDER", (Locale)ctx.getLocale()), rs.getString("FWBNumber"), rs.getInt("FWBSeq")));
            sql.append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }
}

