/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class MultiOrgsFetchDataCondition
extends SCMFetchDataCondition {
    private static final long serialVersionUID = -23823982323L;

    private String getTransferRuleMask(int size) {
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < size; i += 6) {
            for (int j = 0; j < 5; ++j) {
                maskString.append("#").append(i + j).append(" and ");
            }
            maskString.append("#").append(i + 5);
            if (i >= size - 6) continue;
            maskString.append(" or ");
        }
        return maskString.toString();
    }

    private String getSupplyRelationMask(int size) {
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < size; i += 4) {
            maskString.append("#").append(i).append(" and ").append("#").append(i + 1).append(" and ");
            maskString.append("#").append(i + 2).append(" and ").append("#").append(i + 3);
            if (i >= size - 4) continue;
            maskString.append(" or ");
        }
        return maskString.toString();
    }

    @Override
    public EntityViewInfo[] toEntiryView() {
        FilterInfo filter;
        HashSet issueSouIdSet = new HashSet();
        HashSet receiveSouIdSet = new HashSet();
        if (this.getIssueSouIds() != null) {
            issueSouIdSet.addAll(Arrays.asList((Object[])this.getIssueSouIds()));
        }
        if (this.getReceiveSouIds() != null) {
            receiveSouIdSet.addAll(Arrays.asList((Object[])this.getReceiveSouIds()));
        }
        EntityViewInfo[] view = super.toEntiryView();
        if (this.existFetchTransferRule() && this.getRequireSou() != null) {
            filter = new FilterInfo();
            for (String issueSouId : issueSouIdSet) {
                if (StringUtils.isEmpty((String)issueSouId)) continue;
                for (String receiveSouId : receiveSouIdSet) {
                    if (StringUtils.isEmpty((String)receiveSouId)) continue;
                    filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouId);
                    filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)receiveSouId);
                    filter.appendFilterItem("bizType", (Object)this.getBizTypeId());
                    filter.appendFilterItem("status", (Object)new Integer(1));
                    filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)this.getSou().getId().toString());
                    filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)this.getRequireSou().getId().toString());
                }
            }
            if (filter.getFilterItems().size() != 0) {
                filter.setMaskString(this.getTransferRuleMask(filter.getFilterItems().size()));
                view[view.length - 2] = new EntityViewInfo();
                view[view.length - 2].setFilter(filter);
                view[view.length - 2].getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(this.getBizTypeId()));
            }
        }
        if (this.existFetchSupplyRelation() && this.getRequireSou() != null) {
            filter = new FilterInfo();
            for (String issueSouId : issueSouIdSet) {
                if (StringUtils.isEmpty((String)issueSouId)) continue;
                for (String receiveSouId : receiveSouIdSet) {
                    if (StringUtils.isEmpty((String)receiveSouId)) continue;
                    filter.appendFilterItem("issueStorageOrgUnit", (Object)issueSouId);
                    filter.appendFilterItem("receiveStorageOrgUnit", (Object)receiveSouId);
                    filter.appendFilterItem("supplyStorageOrgUnit", (Object)this.getSou().getId().toString());
                    filter.appendFilterItem("requireStorageOrgUnit", (Object)this.getRequireSou().getId().toString());
                }
            }
            if (filter.getFilterItems().size() != 0) {
                filter.setMaskString(this.getSupplyRelationMask(filter.getFilterItems().size()));
                view[view.length - 1] = new EntityViewInfo();
                view[view.length - 1].setFilter(filter);
                view[view.length - 1].getSelector().addObjectCollection((IObjectCollection)this.getSupplyRelationSelector());
            }
        }
        return view;
    }

    @Override
    public int getViewCount() {
        return super.getViewCount() + 2;
    }

    protected String getMatOrgMaskString(int size) {
        StringBuffer maskString = new StringBuffer();
        int length = size;
        for (int i = 0; i < length; i += 2) {
            maskString.append("#").append(i).append(" and ").append("#").append(i + 1);
            if (i >= length - 2) continue;
            maskString.append(" or ");
        }
        return maskString.toString();
    }

    @Override
    protected FilterInfo getDefaultStockerFilter() {
        return null;
    }

    protected Set convertArrayToSet(String[] array) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; array != null && i < array.length; ++i) {
            if (array[i] == null) continue;
            result.add(array[i]);
        }
        return result;
    }

    @Override
    protected FilterInfo getMatComFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial", (Object)this.convertArrayToSet(this.getMaterialPKs()), CompareType.INCLUDE));
        Set couSet = this.convertArrayToSet(this.getIssueCouIds());
        if (couSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)couSet, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    protected FilterInfo getMatSouFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)this.convertArrayToSet(this.getMaterialPKs()), CompareType.INCLUDE));
        Set issueCouSet = this.convertArrayToSet(this.getIssueCouIds());
        Set receiveCouSet = this.convertArrayToSet(this.getReceiveSouIds());
        issueCouSet.addAll(receiveCouSet);
        if (this.getSou() != null) {
            issueCouSet.add(this.getSou().getId().toString());
        }
        if (issueCouSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)issueCouSet, CompareType.INCLUDE));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("materialId", (Object)"nonexistedstorageorgunits"));
        }
        return filter;
    }

    @Override
    protected FilterInfo getDefaultLocationFilter() {
        return null;
    }

    private SelectorItemCollection getTransferRuleSelector(String bizTypeId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("supplyRelation.supplyStorageOrgUnit.id");
        sic.add("supplyRelation.supplyStorageOrgUnit.name");
        sic.add("supplyRelation.supplyStorageOrgUnit.number");
        sic.add("supplyRelation.requireStorageOrgUnit.id");
        sic.add("supplyRelation.requireStorageOrgUnit.name");
        sic.add("supplyRelation.requireStorageOrgUnit.number");
        sic.add("supplyRelation.issueStorageOrgUnit.id");
        sic.add("supplyRelation.issueStorageOrgUnit.name");
        sic.add("supplyRelation.issueStorageOrgUnit.number");
        sic.add("supplyRelation.receiveStorageOrgUnit.id");
        sic.add("supplyRelation.receiveStorageOrgUnit.name");
        sic.add("supplyRelation.receiveStorageOrgUnit.number");
        sic.add("supplyRelation.id");
        sic.add("issueSaleOrgUnit.id");
        sic.add("issueSaleOrgUnit.name");
        sic.add("issueSaleOrgUnit.number");
        sic.add("bizType.id");
        sic.add("bizType.name");
        sic.add("bizType.number");
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            sic.add("supplySaleOrgUnit.id");
            sic.add("supplySaleOrgUnit.name");
            sic.add("supplySaleOrgUnit.number");
            if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                sic.add("requireSaleOrgUnit.id");
                sic.add("requireSaleOrgUnit.name");
                sic.add("requireSaleOrgUnit.number");
            }
        }
        return sic;
    }

    private SelectorItemCollection getSupplyRelationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("supplyStorageOrgUnit.id");
        sic.add("supplyStorageOrgUnit.name");
        sic.add("supplyStorageOrgUnit.number");
        sic.add("requireStorageOrgUnit.id");
        sic.add("requireStorageOrgUnit.name");
        sic.add("requireStorageOrgUnit.number");
        sic.add("issueStorageOrgUnit.id");
        sic.add("issueStorageOrgUnit.name");
        sic.add("issueStorageOrgUnit.number");
        sic.add("receiveStorageOrgUnit.id");
        sic.add("receiveStorageOrgUnit.name");
        sic.add("receiveStorageOrgUnit.number");
        sic.add("supplyCompanyOrgUnit.id");
        sic.add("supplyCompanyOrgUnit.name");
        sic.add("supplyCompanyOrgUnit.number");
        sic.add("requireCompanyOrgUnit.id");
        sic.add("requireCompanyOrgUnit.name");
        sic.add("requireCompanyOrgUnit.number");
        sic.add("issueCompanyOrgUnit.id");
        sic.add("issueCompanyOrgUnit.name");
        sic.add("issueCompanyOrgUnit.number");
        sic.add("receiveCompanyOrgUnit.id");
        sic.add("receiveCompanyOrgUnit.name");
        sic.add("receiveCompanyOrgUnit.number");
        return sic;
    }
}

