/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRelationCollection;
import com.kingdee.eas.basedata.scm.common.SettlementRelationFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRelationInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRuleEntryForPCInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRuleForPCFactory;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WareHouseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.sd.sale.PromotionStrategyEnum;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SCMFetchData
implements Serializable {
    private static final long serialVersionUID = -2434986053239437982L;
    private Map mapMaterial = new HashMap(0);
    private Map mapMaterialCompany = new HashMap(0);
    private Map mapMaterialInventory = new HashMap(0);
    private Map mapMaterialSales = new HashMap(0);
    private Map mapMaterialPurchasing = new HashMap(0);
    private Map mapMaterialCost = new HashMap(0);
    private Map mapWarehouse = new HashMap(0);
    private Map mapStocker = new HashMap(0);
    private Map mapUnitPrecision = new HashMap(0);
    private Map mapUnitbaseConvsRate = new HashMap(0);
    private Map mapDefaultLocation = new HashMap(0);
    private Map mapDurability = new HashMap(0);
    private Map mapCurrency = new HashMap(0);
    private Map mapSupplierPurchase = new HashMap(0);
    private StorageOrgUnitInfo sou;
    private CompanyOrgUnitInfo cou;
    private Map mapSupplyRelation = new HashMap(0);
    private Map mapTransferRule = new HashMap(0);
    private Map mapParamValue = new HashMap(0);
    private List lotFrameList = null;
    private Map lotFrameMap = null;
    private Map codingRuleData = new HashMap();
    private ExchangeRateInfo exchangeRateInfo;
    private Map orgUnitColl = new HashMap();
    private Map cusotmerCollByCompany = new HashMap();
    private BOTRelationCollection botRelationColl = null;
    private MaterialSalesCollection materialSalesCollection = null;
    private CustomerSaleInfoInfo customerSaleInfo = null;
    private Map positionMemberCollectionMap = new HashMap();
    private Map entryDataVOMap = new HashMap();
    private Map assistUnitCollMap = new HashMap();
    private Map mapMaterialPlan = new HashMap(0);
    private Map mapUseWarehsRelation = new HashMap(0);
    private Map mapSettlementRelation = new HashMap(0);
    private Map mapSettlementRuleEntryForPC = new HashMap(0);
    private Map<String, PromotionStrategyEnum> promotionParamMap = new HashMap<String, PromotionStrategyEnum>();
    private Map mapSpecialParam = new HashMap(0);
    private String adminUnitId = null;
    private PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
    private OrgUnitCollection purchaseOrgUnitList = null;
    private OrgUnitCollection purOrgListbyCom = null;
    private CompanyOrgUnitInfo companyOrgbyPur = null;
    private SaleOrgUnitInfo saleOrgUnitInfo;
    private CompanyOrgUnitInfo companyOrgBySale;
    private OrgUnitCollection saleOrgUnitInfos;
    private OrgUnitCollection saleOrgsByCou;
    private Map mapLotNumber = new HashMap(0);
    private Map fetchAuthOrg = null;
    private Map fetchRptConditionData = null;

    public Map getLotFrameMap() {
        return this.lotFrameMap;
    }

    public void setLotFrameMap(Map lotFrameMap) {
        this.lotFrameMap = lotFrameMap;
    }

    public List getLotFrameList() {
        return this.lotFrameList;
    }

    public void setLotFrameList(List lotFrameList) {
        this.lotFrameList = lotFrameList;
    }

    public Map getCodingRuleData() {
        return this.codingRuleData;
    }

    public void setCodingRuleData(Map map) {
        this.codingRuleData.putAll(map);
    }

    public Map getPositionMemberCollectionMap() {
        return this.positionMemberCollectionMap;
    }

    public void setPositionMemberCollectionMap(Map positionMemberCollectionMap) {
        this.positionMemberCollectionMap = positionMemberCollectionMap;
    }

    public Map getMapMaterialPlan() {
        return this.mapMaterialPlan;
    }

    public void setMapMaterialPlan(Map mapMaterialPlan) {
        this.mapMaterialPlan = mapMaterialPlan;
    }

    public void addMapMaterialPlan(Map mapMaterialPlan) {
        this.mapMaterialPlan.putAll(mapMaterialPlan);
    }

    public void putMaterialPlan(String materialID, String souID, MaterialPlanInfo materialPlan) {
        if (materialID == null || souID == null) {
            return;
        }
        this.getMapMaterialPlan().put(materialID + souID, materialPlan);
    }

    public Map<String, PromotionStrategyEnum> getPromotionParamMap() {
        return this.promotionParamMap;
    }

    public void setPromotionParamMap(Map<String, PromotionStrategyEnum> promotionParamMap) {
        this.promotionParamMap = promotionParamMap;
    }

    public MaterialPlanInfo getMaterialPlan(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMapMaterialPlan() == null) {
            this.mapMaterialPlan = new HashMap(0);
        }
        if (!this.getMapMaterialPlan().containsKey(materialID + souID)) {
            this.putMaterialPlan(materialID, souID, MaterialPlanFactory.getRemoteInstance().getPlanInfo(materialID, souID));
        }
        return (MaterialPlanInfo)this.getMapMaterialPlan().get(materialID + souID);
    }

    public Map getMapUseWarehsRelation() {
        return this.mapUseWarehsRelation;
    }

    public void setMapUseWarehsRelation(Map mapUseWarehsRelation) {
        this.mapUseWarehsRelation = mapUseWarehsRelation;
    }

    public void addMapUseWarehsRelation(Map mapUseWarehsRelation) {
        this.mapUseWarehsRelation.putAll(mapUseWarehsRelation);
    }

    public void putUseWarehsRelation(String souID, boolean isUseWarehsRelation) {
        if (souID == null) {
            return;
        }
        this.getMapUseWarehsRelation().put(souID, isUseWarehsRelation);
    }

    public MaterialPlanInfo getMaterialPlanByCache(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMapMaterialPlan() == null) {
            this.mapMaterialPlan = new HashMap(0);
        }
        return (MaterialPlanInfo)this.getMapMaterialPlan().get(materialID + souID);
    }

    public ExchangeRateInfo getExchangeRateInfo() {
        return this.exchangeRateInfo;
    }

    public void setExchangeRateInfo(ExchangeRateInfo exchangeRateInfo) {
        this.exchangeRateInfo = exchangeRateInfo;
    }

    public Map getMapSpecialParam() {
        return this.mapSpecialParam;
    }

    public void setMapSpecialParam(Map mapSpecialParam) {
        this.mapSpecialParam = mapSpecialParam;
    }

    public void setAdminUnitId(String adminUnitId) {
        this.adminUnitId = adminUnitId;
    }

    public String getAdminUnitId() {
        return this.adminUnitId;
    }

    public PurchaseOrgUnitInfo getPurchaseOrgUnitInfo() {
        return this.purchaseOrgUnitInfo;
    }

    public void setPurchaseOrgUnitInfo(PurchaseOrgUnitInfo purchaseOrgUnitInfo) {
        this.purchaseOrgUnitInfo = purchaseOrgUnitInfo;
    }

    public OrgUnitCollection getPurchaseOrgUnitList() {
        return this.purchaseOrgUnitList;
    }

    public void setPurchaseOrgUnitList(OrgUnitCollection purchaseOrgUnitList) {
        this.purchaseOrgUnitList = purchaseOrgUnitList;
    }

    public OrgUnitCollection getPurOrgListbyCom() {
        return this.purOrgListbyCom;
    }

    public void setPurOrgListbyCom(OrgUnitCollection purOrgListbyCom) {
        this.purOrgListbyCom = purOrgListbyCom;
    }

    public CompanyOrgUnitInfo getCompanyOrgbyPur() {
        return this.companyOrgbyPur;
    }

    public void setCompanyOrgbyPur(CompanyOrgUnitInfo companyOrgbyPur) {
        this.companyOrgbyPur = companyOrgbyPur;
    }

    public void addMapParamValue(Map map) {
        if (this.mapParamValue == null) {
            this.mapParamValue = new HashMap(map.size());
        }
        this.mapParamValue.putAll(map);
    }

    public void addParamValue(String companyId, String paramName, String value) {
        if (this.mapParamValue == null) {
            this.mapParamValue = new HashMap();
        }
        this.mapParamValue.put(companyId + paramName, value);
    }

    public void addMapSupplyRelation(Map map) {
        if (this.mapSupplyRelation == null) {
            this.mapSupplyRelation = new HashMap(map.size());
        }
        this.mapSupplyRelation.putAll(map);
    }

    public void addMapTransferRule(Map map) {
        if (this.mapTransferRule == null) {
            this.mapTransferRule = new HashMap(map.size());
        }
        this.mapTransferRule.putAll(map);
    }

    public void putTransferRule(String bizTypeId, String supplySouId, String reqSouId, String issueSouId, String recSouId, TransferRuleInfo tranRule) {
        if (this.mapTransferRule == null) {
            this.mapTransferRule = new HashMap();
        }
        this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId + issueSouId + recSouId, tranRule);
    }

    private void putTransferRule(String bizTypeId, String supplySouId, String reqSouId, TransferRuleInfo tranRule) {
        if (this.mapTransferRule == null) {
            this.mapTransferRule = new HashMap();
        }
        this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId, tranRule);
    }

    public void putTransferRuleByBotpBill(String bizTypeId, String supplySouId, String reqSouId, String recSouId, TransferRuleInfo tranRule) {
        if (this.mapTransferRule == null) {
            this.mapTransferRule = new HashMap();
        }
        this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId + recSouId, tranRule);
    }

    public void putTransferRule(TransferRuleInfo[] trInfos) {
        for (TransferRuleInfo trInfo : trInfos) {
            if (trInfo == null) continue;
            this.putTransferRule(trInfo.getBizType().getId().toString(), trInfo.getSupplyRelation().getSupplyStorageOrgUnit().getId().toString(), trInfo.getSupplyRelation().getRequireStorageOrgUnit().getId().toString(), trInfo.getSupplyRelation().getIssueStorageOrgUnit().getId().toString(), trInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString(), trInfo);
        }
    }

    public String getParamValue(String companyId, String param) throws EASBizException, BOSException {
        if (!this.mapParamValue.containsKey(companyId + param)) {
            this.mapParamValue.put(companyId + param, ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)new ObjectUuidPK(companyId), param));
        }
        return (String)this.mapParamValue.get(companyId + param);
    }

    public TransferRuleInfo getTransferRule(String bizTypeId, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null) {
            return null;
        }
        if (!this.mapTransferRule.containsKey(bizTypeId + supplySouId + reqSouId + issueSouId + recSouId)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
            filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouId);
            filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouId);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
            String bizCategoryId = null;
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeId)) {
                bizCategoryId = "88a7587a-e019-497b-9f86-b8f00ab2fe72A9389020";
            } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
                bizCategoryId = "eQQgnQESEADgAAAAwKgS/ak4kCA=";
            } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
                bizCategoryId = "eQQgnQESEADgAAABwKgS/ak4kCA=";
            }
            TransferRuleCollection col = this.getTransferRuleByBizCategory(bizCategoryId).getTransferRuleCollection(view);
            this.putTransferRule(bizTypeId, supplySouId, reqSouId, issueSouId, recSouId, col.size() > 0 ? col.get(0) : null);
        }
        return (TransferRuleInfo)this.mapTransferRule.get(bizTypeId + supplySouId + reqSouId + issueSouId + recSouId);
    }

    public TransferRuleInfo getTransferRule(String bizTypeId, String supplySouId, String reqSouId, Context ctx) throws BOSException {
        if (bizTypeId == null || supplySouId == null) {
            return null;
        }
        if (!this.mapTransferRule.containsKey(bizTypeId + supplySouId + reqSouId)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
            TransferRuleCollection col = this.getTransferRuleBizByType(bizTypeId, ctx).getTransferRuleCollection(view);
            this.putTransferRule(bizTypeId, supplySouId, reqSouId, col.size() > 0 ? col.get(0) : null);
        }
        return (TransferRuleInfo)this.mapTransferRule.get(bizTypeId + supplySouId + reqSouId);
    }

    public TransferRuleInfo getTransferRuleByBotpBill(String bizTypeId, String supplySouId, String reqSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null || reqSouId == null || recSouId == null) {
            return null;
        }
        if (!this.mapTransferRule.containsKey(bizTypeId + supplySouId + reqSouId + recSouId)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
            filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouId);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = this.getTransferRuleSelector(bizTypeId);
            sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.id"));
            sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.name"));
            sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.number"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BizTypeInfo bizInfo = this.getBizType(bizTypeId);
            TransferRuleCollection col = this.getTransferRuleByBizCategory(bizInfo.getBizCategory().getId().toString()).getTransferRuleCollection(view);
            this.putTransferRuleByBotpBill(bizTypeId, supplySouId, reqSouId, recSouId, col.size() > 0 ? col.get(0) : null);
        }
        return (TransferRuleInfo)this.mapTransferRule.get(bizTypeId + supplySouId + reqSouId + recSouId);
    }

    private BizTypeInfo getBizType(String bizTypeId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizCategory.id"));
        BizTypeInfo bizTypeInfo = BizTypeFactory.getRemoteInstance().getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeId), sic);
        return bizTypeInfo;
    }

    private String getTransferRuleMask(int size) {
        int i;
        StringBuffer maskString = new StringBuffer();
        maskString.append(" ( ");
        int length = size - 4;
        for (i = 0; i < length; i += 2) {
            maskString.append(" #").append(i).append(" and ").append("#").append(i + 1);
            if (i >= length - 2) continue;
            maskString.append(" or ");
        }
        maskString.append(" ) ");
        for (i = 4; i > 0; --i) {
            maskString.append(" and #").append(size - i);
        }
        return maskString.toString();
    }

    public void preGetTransferRule(String bizTypeId, String supplySouId, String reqSouId, String[] issueSouIds, String[] recSouIds) throws EASBizException, BOSException {
        int i;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int length = issueSouIds.length;
        for (i = 0; i < length; ++i) {
            if (issueSouIds[i] == null || recSouIds[i] == null) continue;
            filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouIds[i]);
            filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouIds[i]);
        }
        if (filter.getFilterItems().size() != 0) {
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
            filter.setMaskString(this.getTransferRuleMask(filter.getFilterItems().size()));
        } else {
            filter.appendFilterItem("bizType.number", (Object)"nonexistedtransferrulebiztypeid");
        }
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
        length = issueSouIds.length;
        for (i = 0; i < length; ++i) {
            if (issueSouIds[i] == null || recSouIds[i] == null) continue;
            this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId + issueSouIds[i] + recSouIds[i], null);
        }
        BizTypeInfo bizInfo = this.getBizType(bizTypeId);
        TransferRuleCollection col = this.getTransferRuleByBizCategory(bizInfo.getBizCategory().getId().toString()).getTransferRuleCollection(view);
        int size = col.size();
        for (int i2 = 0; i2 < size; ++i2) {
            TransferRuleInfo trInfo = col.get(i2);
            this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId + trInfo.getSupplyRelation().getIssueStorageOrgUnit().getId().toString() + trInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString(), trInfo);
        }
    }

    public void preGetTransferRule(BizTypeInfo bizTypeInfo, String supplySouId, String reqSouId, String[] issueSouIds, String[] recSouIds) throws EASBizException, BOSException {
        int i;
        String bizTypeId = bizTypeInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int length = issueSouIds.length;
        for (i = 0; i < length; ++i) {
            if (issueSouIds[i] == null || recSouIds[i] == null) continue;
            filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouIds[i]);
            filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouIds[i]);
        }
        if (filter.getFilterItems().size() != 0) {
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
            filter.setMaskString(this.getTransferRuleMask(filter.getFilterItems().size()));
        } else {
            filter.appendFilterItem("bizType.number", (Object)"nonexistedtransferrulebiztypeid");
        }
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
        length = issueSouIds.length;
        for (i = 0; i < length; ++i) {
            if (issueSouIds[i] == null || recSouIds[i] == null) continue;
            this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId + issueSouIds[i] + recSouIds[i], null);
        }
        TransferRuleCollection col = this.getTransferRuleByBizCategory(bizTypeInfo.getBizCategory().getId().toString()).getTransferRuleCollection(view);
        int size = col.size();
        for (int i2 = 0; i2 < size; ++i2) {
            TransferRuleInfo trInfo = col.get(i2);
            this.mapTransferRule.put(bizTypeId + supplySouId + reqSouId + trInfo.getSupplyRelation().getIssueStorageOrgUnit().getId().toString() + trInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString(), trInfo);
        }
    }

    public void getTransferRuleByBotpBill(String bizTypeId, String supplySouId, String reqSouId, String[] recSouIds) throws EASBizException, BOSException {
        if (supplySouId == null || recSouIds == null || bizTypeId == null || reqSouId == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> recSouSet = new HashSet<String>();
        int length = recSouIds.length;
        for (int i = 0; i < length; ++i) {
            if (recSouIds[i] == null) continue;
            recSouSet.add(recSouIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", recSouSet, CompareType.INCLUDE));
        if (filter.getFilterItems().size() != 0) {
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
        } else {
            filter.appendFilterItem("bizType.number", (Object)"nonexistedtransferrulebiztypeid");
        }
        view.setFilter(filter);
        SelectorItemCollection sic = this.getTransferRuleSelector(bizTypeId);
        sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.number"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BizTypeInfo bizInfo = this.getBizType(bizTypeId);
        TransferRuleCollection col = this.getTransferRuleByBizCategory(bizInfo.getBizCategory().getId().toString()).getTransferRuleCollection(view);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            TransferRuleInfo trInfo = col.get(i);
            if (trInfo == null || trInfo.getSupplyRelation() == null || trInfo.getSupplyRelation().getRequireStorageOrgUnit() == null || trInfo.getSupplyRelation().getReceiveStorageOrgUnit() == null || this.mapTransferRule.containsKey(bizTypeId + supplySouId + trInfo.getSupplyRelation().getRequireStorageOrgUnit().getId().toString() + trInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString())) continue;
            this.mapTransferRule.put(bizTypeId + supplySouId + trInfo.getSupplyRelation().getRequireStorageOrgUnit().getId().toString() + trInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString(), trInfo);
        }
    }

    private SelectorItemCollection getTransferRuleSelector(String bizTypeId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("supplyRelation.supplyStorageOrgUnit.id");
        sic.add("supplyRelation.supplyStorageOrgUnit.name");
        sic.add("supplyRelation.supplyStorageOrgUnit.number");
        sic.add("supplyRelation.requireStorageOrgUnit.id");
        sic.add("supplyRelation.requireStorageOrgUnit.name");
        sic.add("supplyRelation.requireStorageOrgUnit.number");
        sic.add("supplyRelation.issueStorageOrgUnit.id");
        sic.add("supplyRelation.issueStorageOrgUnit.name");
        sic.add("supplyRelation.issueStorageOrgUnit.number");
        sic.add("supplyRelation.receiveStorageOrgUnit.id");
        sic.add("supplyRelation.receiveStorageOrgUnit.name");
        sic.add("supplyRelation.receiveStorageOrgUnit.number");
        sic.add("supplyRelation.id");
        sic.add("issueSaleOrgUnit.id");
        sic.add("issueSaleOrgUnit.name");
        sic.add("issueSaleOrgUnit.number");
        sic.add("bizType.id");
        sic.add("bizType.name");
        sic.add("bizType.number");
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            sic.add("supplySaleOrgUnit.id");
            sic.add("supplySaleOrgUnit.name");
            sic.add("supplySaleOrgUnit.number");
            if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                sic.add("requireSaleOrgUnit.id");
                sic.add("requireSaleOrgUnit.name");
                sic.add("requireSaleOrgUnit.number");
            }
        }
        return sic;
    }

    public void putSupplyRelation(String supplySouId, String reqSouId, String issueSouId, String recSouId, SupplyRelationInfo supplyRelation) {
        if (this.mapSupplyRelation == null) {
            this.mapSupplyRelation = new HashMap();
        }
        this.mapSupplyRelation.put(supplySouId + reqSouId + issueSouId + recSouId, supplyRelation);
    }

    public SupplyRelationInfo getSupplyRelation(String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (!this.mapSupplyRelation.containsKey(supplySouId + reqSouId + issueSouId + recSouId)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("requireStorageOrgUnit", (Object)reqSouId);
            filter.appendFilterItem("issueStorageOrgUnit", (Object)issueSouId);
            filter.appendFilterItem("receiveStorageOrgUnit", (Object)recSouId);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getSupplyRelationSelector());
            ISupplyRelation isr = SupplyRelationFactory.getRemoteInstance();
            SupplyRelationCollection col = isr.getSupplyRelationCollection(view);
            this.putSupplyRelation(supplySouId, reqSouId, issueSouId, recSouId, col.size() > 0 ? col.get(0) : null);
        }
        return (SupplyRelationInfo)this.mapSupplyRelation.get(supplySouId + reqSouId + issueSouId + recSouId);
    }

    public void put(SCMFetchData otherFetchData) {
        Map otherMap;
        Map thisMap;
        if (otherFetchData == null) {
            return;
        }
        if (otherFetchData.getMapCurrency() != null) {
            thisMap = this.getMapCurrency();
            otherMap = otherFetchData.getMapCurrency();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterial() != null) {
            thisMap = this.getMapMaterial();
            otherMap = otherFetchData.getMapMaterial();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterialCompany() != null) {
            thisMap = this.getMapMaterialCompany();
            otherMap = otherFetchData.getMapMaterialCompany();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterialInventory() != null) {
            thisMap = this.getMapMaterialInventory();
            otherMap = otherFetchData.getMapMaterialInventory();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterialSales() != null) {
            thisMap = this.getMapMaterialSales();
            otherMap = otherFetchData.getMapMaterialSales();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterialPurchasing() != null) {
            thisMap = this.getMapMaterialPurchasing();
            otherMap = otherFetchData.getMapMaterialPurchasing();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterialCost() != null) {
            thisMap = this.getMapMaterialCost();
            otherMap = otherFetchData.getMapMaterialCost();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapWarehouse() != null) {
            thisMap = this.getMapWarehouse();
            otherMap = otherFetchData.getMapWarehouse();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapStocker() != null) {
            thisMap = this.getMapStocker();
            otherMap = otherFetchData.getMapStocker();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapUnitPrecision() != null) {
            thisMap = this.getMapUnitPrecision();
            otherMap = otherFetchData.getMapUnitPrecision();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapUnitbaseConvsRate() != null) {
            thisMap = this.getMapUnitbaseConvsRate();
            otherMap = otherFetchData.getMapUnitbaseConvsRate();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapDefaultLocation() != null) {
            thisMap = this.getMapDefaultLocation();
            otherMap = otherFetchData.getMapDefaultLocation();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapSupplyRelation() != null) {
            thisMap = this.getMapSupplyRelation();
            otherMap = otherFetchData.getMapSupplyRelation();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapTransferRule() != null) {
            thisMap = this.getMapTransferRule();
            otherMap = otherFetchData.getMapTransferRule();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapDurability() != null) {
            thisMap = this.getMapDurability();
            otherMap = otherFetchData.getMapDurability();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapParamValue() != null) {
            thisMap = this.getMapParamValue();
            otherMap = otherFetchData.getMapParamValue();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapLotNumber() != null) {
            thisMap = this.getMapLotNumber();
            otherMap = otherFetchData.getMapLotNumber();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapMaterialPlan() != null) {
            thisMap = this.getMapMaterialPlan();
            otherMap = otherFetchData.getMapMaterialPlan();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getMapUseWarehsRelation() != null) {
            thisMap = this.getMapUseWarehsRelation();
            otherMap = otherFetchData.getMapUseWarehsRelation();
            thisMap.putAll(otherMap);
        }
        this.cou = otherFetchData.getCou();
        if (otherFetchData.getMapSpecialParam() != null) {
            thisMap = this.getMapSpecialParam();
            otherMap = otherFetchData.getMapSpecialParam();
            thisMap.putAll(otherMap);
        }
        if (otherFetchData.getFetchAuthorg() != null) {
            thisMap = this.getFetchAuthorg();
            otherMap = otherFetchData.getFetchAuthorg();
            thisMap.putAll(otherMap);
        }
        this.adminUnitId = otherFetchData.getAdminUnitId();
        this.saleOrgUnitInfo = otherFetchData.getSaleOrgUnitInfo();
        this.companyOrgBySale = otherFetchData.getCompanyOrgBySale();
        this.saleOrgUnitInfos = otherFetchData.getSaleOrgUnitInfos();
        this.saleOrgsByCou = otherFetchData.getSaleOrgsByCou();
        this.lotFrameList = otherFetchData.getLotFrameList();
        this.purchaseOrgUnitInfo = otherFetchData.getPurchaseOrgUnitInfo();
        this.purchaseOrgUnitList = otherFetchData.getPurchaseOrgUnitList();
        this.purOrgListbyCom = otherFetchData.getPurOrgListbyCom();
        this.exchangeRateInfo = otherFetchData.getExchangeRateInfo();
        this.lotFrameMap = otherFetchData.getLotFrameMap();
    }

    public LocationInfo getDefaultLocation(String materialId, String warehsId, String souID) throws EASBizException, BOSException {
        LocationInfo location;
        if (materialId == null || warehsId == null || souID == null) {
            return null;
        }
        if (this.getMapDefaultLocation() == null) {
            this.mapDefaultLocation = new HashMap(0);
        }
        if ((location = (LocationInfo)this.getMapDefaultLocation().get(materialId + warehsId + souID)) == null && !this.getMapDefaultLocation().containsKey(materialId + warehsId + souID)) {
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getRemoteInstance();
            StringBuffer oql = new StringBuffer();
            oql.append("select id,material.id,storageOrg.id,warehouse.id,location.id,location.name,location.number,location.State ").append("where storageOrg = '").append(souID).append("' and ").append("material  = '").append(materialId).append("' and ").append("warehouse = '").append(warehsId).append("' and ").append("ISDEFAULTLOCATION = 1 ");
            MaterialStorageAssignCollection msaCol = imsa.getMaterialStorageAssignCollection(oql.toString());
            if (msaCol.size() > 0) {
                MaterialStorageAssignInfo info = msaCol.get(0);
                location = info.getLocation();
                this.putDefaultLocation(materialId, warehsId, souID, location);
            } else {
                location = null;
                this.putDefaultLocation(materialId, warehsId, souID, location);
            }
        }
        if (location != null && WHStateEnum.ACTIVE.equals((Object)location.getState())) {
            return location;
        }
        return null;
    }

    public LocationInfo getDefaultGroupLocation(String materialGroupId, String warehsId, String souID) throws EASBizException, BOSException {
        LocationInfo location;
        if (materialGroupId == null || warehsId == null || souID == null) {
            return null;
        }
        if (this.getMapDefaultLocation() == null) {
            this.mapDefaultLocation = new HashMap(0);
        }
        if ((location = (LocationInfo)this.getMapDefaultLocation().get(materialGroupId + warehsId + souID)) == null && !this.getMapDefaultLocation().containsKey(materialGroupId + warehsId + souID)) {
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getRemoteInstance();
            StringBuffer oql = new StringBuffer();
            oql.append("select id,material.id,storageOrg.id,warehouse.id,location.id,location.name,location.number ").append("where storageOrg = '").append(souID).append("' and ").append("materialGroup  = '").append(materialGroupId).append("' and ").append("warehouse = '").append(warehsId).append("' and ").append("ISDEFAULTLOCATION = 1 ");
            MaterialStorageAssignCollection msaCol = imsa.getMaterialStorageAssignCollection(oql.toString());
            if (msaCol.size() > 0) {
                MaterialStorageAssignInfo info = msaCol.get(0);
                location = info.getLocation();
                this.putDefaultLocation(materialGroupId, warehsId, souID, location);
            } else {
                location = null;
                this.putDefaultLocation(materialGroupId, warehsId, souID, location);
            }
        }
        return location;
    }

    public void putDefaultLocation(String materialId, String warehsId, String souID, LocationInfo locInfo) {
        if (materialId == null || warehsId == null) {
            return;
        }
        this.getMapDefaultLocation().put(materialId + warehsId + souID, locInfo);
    }

    public MaterialInfo getMaterial(String materialID) throws EASBizException, BOSException {
        if (this.getMapMaterial() == null) {
            this.mapMaterial = new HashMap(0);
        }
        if (!this.getMapMaterial().containsKey(materialID)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            sic.add(new SelectorItemInfo("baseUnit.number"));
            sic.add(new SelectorItemInfo("assistUnit.id"));
            sic.add(new SelectorItemInfo("assistUnit.name"));
            sic.add(new SelectorItemInfo("assistUnit.number"));
            sic.add(new SelectorItemInfo("seqUnit.number"));
            sic.add(new SelectorItemInfo("seqUnit.name"));
            sic.add(new SelectorItemInfo("seqUnit.id"));
            sic.add(new SelectorItemInfo("materialGroup.id"));
            sic.add(new SelectorItemInfo("materialGroup.name"));
            sic.add(new SelectorItemInfo("materialGroup.number"));
            sic.add(new SelectorItemInfo("materialGroup.isLeaf"));
            sic.add(new SelectorItemInfo("materialGroup.level"));
            sic.add(new SelectorItemInfo("materialGroup.longNumber"));
            sic.add(new SelectorItemInfo("materialGroup.displayName"));
            this.putMaterial(materialID, MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic));
        }
        return (MaterialInfo)this.getMapMaterial().get(materialID);
    }

    public void putMaterial(String materialID, MaterialInfo material) {
        if (materialID == null) {
            return;
        }
        this.getMapMaterial().put(materialID, material);
    }

    public String getNumber(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return null;
        }
        return this.getMaterial(materialID).getNumber();
    }

    public void putNumber(String materialID, String number) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setNumber(number);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setNumber(number);
        }
    }

    public String getName(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return null;
        }
        return this.getMaterial(materialID).getName();
    }

    public void putName(String materialID, String name) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setName(name);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setName(name);
        }
    }

    public String getModel(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return null;
        }
        return this.getMaterial(materialID).getModel();
    }

    public void putModel(String materialID, String model) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setModel(model);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setModel(model);
        }
    }

    public MeasureUnitInfo getBaseUnit(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return null;
        }
        return this.getMaterial(materialID).getBaseUnit();
    }

    public void putBaseUnit(String materialID, MeasureUnitInfo baseUnit) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setBaseUnit(baseUnit);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setBaseUnit(baseUnit);
        }
    }

    public MeasureUnitInfo getAssistUnit(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return null;
        }
        return this.getMaterial(materialID).getAssistUnit();
    }

    public void putAssistUnit(String materialID, MeasureUnitInfo assistUnit) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setAssistUnit(assistUnit);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setAssistUnit(assistUnit);
        }
    }

    public int getPricePrecision(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return -1;
        }
        return this.getMaterial(materialID).getPricePrecision();
    }

    public void putPricePrecision(String materialID, int precision) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setPricePrecision(precision);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setPricePrecision(precision);
        }
    }

    public AsstAttrTypeInfo getAsstAttrType(String materialID) throws EASBizException, BOSException {
        if (this.getMaterial(materialID) == null) {
            return null;
        }
        return this.getMaterial(materialID).getAssistAttr();
    }

    public void putAsstAttrType(String materialID, AsstAttrTypeInfo asstAttrType) throws EASBizException, BOSException, UuidException {
        if (materialID == null) {
            return;
        }
        if (this.getMaterial(materialID) == null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            material.setAssistAttr(asstAttrType);
            this.getMapMaterial().put(materialID, material);
        } else {
            this.getMaterial(materialID).setAssistAttr(asstAttrType);
        }
    }

    public MaterialCompanyInfoInfo getMaterialCompany(String materialID, String couID) throws BOSException {
        if (this.getMapMaterialCompany() == null) {
            this.mapMaterialCompany = new HashMap(0);
        }
        if (!this.getMapMaterialCompany().containsKey(materialID + couID) || this.getMapMaterialCompany().get(materialID + couID) == null) {
            this.putMaterialCompany(materialID, couID, this.getMaterialCompanyInfo(null, materialID, couID));
        }
        return (MaterialCompanyInfoInfo)this.getMapMaterialCompany().get(materialID + couID);
    }

    public MaterialCompanyInfoInfo getMaterialCompany(Context ctx, String materialID, String couID) throws BOSException {
        if (this.getMapMaterialCompany() == null) {
            this.mapMaterialCompany = new HashMap(0);
        }
        if (!this.getMapMaterialCompany().containsKey(materialID + couID) || this.getMapMaterialCompany().get(materialID + couID) == null) {
            this.putMaterialCompany(materialID, couID, this.getMaterialCompanyInfo(ctx, materialID, couID));
        }
        return (MaterialCompanyInfoInfo)this.getMapMaterialCompany().get(materialID + couID);
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, String materialID, String couID) throws BOSException {
        IMaterialCompanyInfo imaterialCompany = null;
        imaterialCompany = ctx == null ? MaterialCompanyInfoFactory.getRemoteInstance() : MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)couID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        ev.setSelector(SCMFetchData.getMaterialSelector());
        ev.setFilter(filter);
        MaterialCompanyInfoCollection coll = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(ev);
        return coll.get(0);
    }

    private static SelectorItemCollection getMaterialSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("KAClass.id"));
        sic.add(new SelectorItemInfo("KAClass.name"));
        sic.add(new SelectorItemInfo("KAClass.number"));
        sic.add(new SelectorItemInfo("standardCost"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("calculateType"));
        sic.add(new SelectorItemInfo("materialId"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("mateial.longNumber"));
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        sic.add(new SelectorItemInfo("mateial.shortName"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isLot"));
        sic.add(new SelectorItemInfo("isAssistProperty"));
        sic.add(new SelectorItemInfo("isProject"));
        sic.add(new SelectorItemInfo("isTrackNumber"));
        return sic;
    }

    public void putMaterialCompany(String materialID, String couID, MaterialCompanyInfoInfo materialCompany) {
        if (materialID == null || couID == null) {
            return;
        }
        this.getMapMaterialCompany().put(materialID + couID, materialCompany);
    }

    public CompanyOrgUnitInfo getCompany(String materialID, String couID) throws BOSException {
        if (this.getMaterialCompany(materialID, couID) == null) {
            return null;
        }
        return this.getMaterialCompany(materialID, couID).getCompany();
    }

    public void putCompany(String materialID, String couID, CompanyOrgUnitInfo company) throws BOSException, UuidException {
        if (materialID == null || couID == null) {
            return;
        }
        if (this.getMaterialCompany(materialID, couID) == null) {
            MaterialCompanyInfoInfo materialCompany = new MaterialCompanyInfoInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materialID));
            materialCompany.setMateial(materialInfo);
            materialCompany.setCompany(company);
            this.getMapMaterialCompany().put(materialID + couID, materialCompany);
        } else {
            this.getMaterialCompany(materialID, couID).setCompany(company);
        }
    }

    public AccountType getAccountType(String materialID, String couID) throws BOSException {
        if (this.getMaterialCompany(materialID, couID) == null) {
            return null;
        }
        return this.getMaterialCompany(materialID, couID).getAccountType();
    }

    public void putAccountType(String materialID, String couID, AccountType accountType) throws BOSException, UuidException {
        if (materialID == null || couID == null) {
            return;
        }
        if (this.getMaterialCompany(materialID, couID) == null) {
            MaterialCompanyInfoInfo materialCompany = new MaterialCompanyInfoInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materialID));
            materialCompany.setMateial(materialInfo);
            materialCompany.setAccountType(accountType);
            this.getMapMaterialCompany().put(materialID + couID, materialCompany);
        } else {
            this.getMaterialCompany(materialID, couID).setAccountType(accountType);
        }
    }

    public BigDecimal getStandardCost(String materialID, String couID) throws BOSException {
        if (this.getMaterialCompany(materialID, couID) == null) {
            return null;
        }
        return this.getMaterialCompany(materialID, couID).getStandardCost();
    }

    public void putStandardCost(String materialID, String couID, BigDecimal standardCost) throws BOSException, UuidException {
        if (materialID == null || couID == null) {
            return;
        }
        if (this.getMaterialCompany(materialID, couID) == null) {
            MaterialCompanyInfoInfo materialCompany = new MaterialCompanyInfoInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materialID));
            materialCompany.setMateial(materialInfo);
            materialCompany.setStandardCost(standardCost);
            this.getMapMaterialCompany().put(materialID + couID, materialCompany);
        } else {
            this.getMaterialCompany(materialID, couID).setStandardCost(standardCost);
        }
    }

    public MaterialInventoryInfo getMaterialInventory(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMapMaterialInventory() == null) {
            this.mapMaterialInventory = new HashMap(0);
        }
        if (!this.getMapMaterialInventory().containsKey(materialID + souID)) {
            this.putMaterialInventory(materialID, souID, MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialID, souID));
        }
        return (MaterialInventoryInfo)this.getMapMaterialInventory().get(materialID + souID);
    }

    public MaterialInventoryInfo getMaterialInventoryByCache(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMapMaterialInventory() == null) {
            this.mapMaterialInventory = new HashMap(0);
        }
        return (MaterialInventoryInfo)this.getMapMaterialInventory().get(materialID + souID);
    }

    public MaterialInventoryInfo getMaterialInventoryLocal(String materialID, String souID, Context ctx) throws EASBizException, BOSException {
        MaterialInventoryInfo materialInventory;
        if (this.getMapMaterialInventory() == null) {
            this.mapMaterialInventory = new HashMap(0);
        }
        if (!this.getMapMaterialInventory().containsKey(materialID + souID) && (materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialID, souID)) != null) {
            this.putMaterialInventory(materialID, souID, materialInventory);
        }
        return (MaterialInventoryInfo)this.getMapMaterialInventory().get(materialID + souID);
    }

    public void putMaterialInventory(String materialID, String souID, MaterialInventoryInfo materialInventory) {
        if (materialID == null || souID == null) {
            return;
        }
        this.getMapMaterialInventory().put(materialID + souID, materialInventory);
    }

    public String getLotNumber(String materialID, String storageOrgID, IssuePriorityEnum issueEnum, String assistPropertyID) throws EASBizException, BOSException {
        if (this.getMapLotNumber() == null) {
            this.mapLotNumber = new HashMap(0);
        }
        if (materialID != null && storageOrgID != null && issueEnum != null) {
            if (assistPropertyID == null) {
                assistPropertyID = "";
            }
            if (!this.getMapLotNumber().containsKey(materialID + storageOrgID + assistPropertyID)) {
                String lotNumber = DateOfMinDurabilityFactory.getRemoteInstance().getLot(materialID, storageOrgID, issueEnum, assistPropertyID);
                this.putLotNumber(materialID, storageOrgID, assistPropertyID, lotNumber);
            }
        }
        return (String)this.getMapLotNumber().get(materialID + storageOrgID + assistPropertyID);
    }

    public void putLotNumber(String materialID, String storageOrgID, String assistPropertyID, String lotNumber) {
        if (materialID == null || storageOrgID == null) {
            return;
        }
        this.getMapLotNumber().put(materialID + storageOrgID + assistPropertyID, lotNumber);
    }

    public boolean getIsLotNumber(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return false;
        }
        return this.getMaterialInventory(materialID, souID).isIsLotNumber();
    }

    public void putIsLotNumber(String materialID, String souID, boolean isLotNumber) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setIsLotNumber(isLotNumber);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setIsLotNumber(isLotNumber);
        }
    }

    public boolean getIsSequenceNo(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return false;
        }
        return this.getMaterialInventory(materialID, souID).isIsSequenceNo();
    }

    public void putIsSequenceNo(String materialID, String souID, boolean isSequenceNo) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setIsSequenceNo(isSequenceNo);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setIsSequenceNo(isSequenceNo);
        }
    }

    public boolean getIsPeriodValid(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return false;
        }
        return this.getMaterialInventory(materialID, souID).isIsPeriodValid();
    }

    public void putIsPeriodValid(String materialID, String souID, boolean isPeriodValid) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setIsPeriodValid(isPeriodValid);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setIsPeriodValid(isPeriodValid);
        }
    }

    public int getPeriodValid(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return -1;
        }
        return this.getMaterialInventory(materialID, souID).getPeriodValid();
    }

    public void putPeriodValid(String materialID, String souID, int periodValid) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setPeriodValid(periodValid);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setPeriodValid(periodValid);
        }
    }

    public TimeUnitEnum getPeriodValueUnit(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return null;
        }
        return this.getMaterialInventory(materialID, souID).getPeriodValidUnit();
    }

    public void putPeriodValidUnit(String materialID, String souID, TimeUnitEnum periodValidUnit) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setPeriodValidUnit(periodValidUnit);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setPeriodValidUnit(periodValidUnit);
        }
    }

    public boolean getIsNegative(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return false;
        }
        return this.getMaterialInventory(materialID, souID).isIsNegative();
    }

    public void putIsNegative(String materialID, String souID, boolean isNegative) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setIsNegative(isNegative);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setIsNegative(isNegative);
        }
    }

    public MeasureUnitInfo getInventoryUnit(String materialID, String souID) throws EASBizException, BOSException {
        if (this.getMaterialInventory(materialID, souID) == null) {
            return null;
        }
        return this.getMaterialInventory(materialID, souID).getUnit();
    }

    public void putInventoryUnit(String materialID, String souID, MeasureUnitInfo unit) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setUnit(unit);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setUnit(unit);
        }
    }

    public MaterialSalesInfo getMaterialSales(String materialID, String saleouID) throws EASBizException, BOSException {
        if (this.getMapMaterialSales() == null) {
            this.mapMaterialSales = new HashMap(0);
        }
        if (!this.getMapMaterialSales().containsKey(materialID + saleouID)) {
            this.putMaterialSales(materialID, saleouID, MaterialSalesFactory.getRemoteInstance().getSalesInfo(materialID, saleouID));
        }
        return (MaterialSalesInfo)this.getMapMaterialSales().get(materialID + saleouID);
    }

    public void putMaterialSales(String materialID, String saleouID, MaterialSalesInfo materialSales) {
        if (materialID == null || saleouID == null) {
            return;
        }
        this.getMapMaterialSales().put(materialID + saleouID, materialSales);
    }

    public MaterialPurchasingInfo getMaterialPurchasing(String materialID, String pouID) throws EASBizException, BOSException {
        if (this.getMapMaterialPurchasing() == null) {
            this.mapMaterialPurchasing = new HashMap(0);
        }
        if (!this.getMapMaterialPurchasing().containsKey(materialID + pouID)) {
            this.putMaterialPurchasing(materialID, pouID, MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(materialID, pouID));
        }
        return (MaterialPurchasingInfo)this.getMapMaterialPurchasing().get(materialID + pouID);
    }

    public void putMaterialPurchasing(String materialID, String pouID, MaterialPurchasingInfo materialPurchasing) {
        if (materialID == null || pouID == null) {
            return;
        }
        this.getMapMaterialPurchasing().put(materialID + pouID, materialPurchasing);
    }

    public MaterialCostInfo getMaterialCost(String materialID, String costCenterID) {
        MaterialCostInfo materialCost;
        if (this.getMapMaterialCost() == null) {
            this.mapMaterialCost = new HashMap();
        }
        if ((materialCost = (MaterialCostInfo)this.getMapMaterialCost().get(materialID)) == null) {
            this.putMaterialCost(materialID, costCenterID, materialCost);
        }
        return materialCost;
    }

    public void putMaterialCost(String materialID, String costCenterID, MaterialCostInfo materialCost) {
        if (materialID == null || costCenterID == null) {
            return;
        }
        this.getMapMaterialCost().put(materialID + costCenterID, materialCost);
    }

    public WarehouseInfo getDefaultWarehouse(String materialID, String souID) throws EASBizException, BOSException {
        if (!this.getMapWarehouse().containsKey(materialID + souID)) {
            if (this.getMaterialInventory(materialID, souID) == null) {
                this.getMapWarehouse().put(materialID + souID, null);
                return null;
            }
            WarehouseInfo warehouseInfo = this.getMaterialInventory(materialID, souID).getDefaultWarehouse();
            if (warehouseInfo != null && WHStateEnum.ACTIVE.equals((Object)warehouseInfo.getWhState())) {
                SOAccreditWHInfo sowhInfo;
                StringBuffer oql = new StringBuffer();
                oql.append("select status where warehouse = '").append(warehouseInfo.getId().toString()).append("'");
                oql.append(" and storageOrg = '").append(souID).append("'");
                SOAccreditWHCollection coll = SOAccreditWHFactory.getRemoteInstance().getSOAccreditWHCollection(oql.toString());
                if (coll.size() > 0 && (sowhInfo = coll.get(0)) != null && sowhInfo.getStatus().equals((Object)WareHouseStatusEnum.ENABLED)) {
                    this.getMapWarehouse().put(materialID + souID, warehouseInfo);
                    return warehouseInfo;
                }
            }
            this.getMapWarehouse().put(materialID + souID, null);
            return null;
        }
        return (WarehouseInfo)this.getMapWarehouse().get(materialID + souID);
    }

    public void putDefaultWarehouse(String materialID, String souID, WarehouseInfo warehouse) throws EASBizException, BOSException, UuidException {
        if (materialID == null || souID == null) {
            return;
        }
        if (this.getMaterialInventory(materialID, souID) == null) {
            MaterialInventoryInfo materialInventory = new MaterialInventoryInfo();
            materialInventory.setId(BOSUuid.read((String)materialID));
            materialInventory.setDefaultWarehouse(warehouse);
            this.getMapMaterialInventory().put(materialID + souID, materialInventory);
        } else {
            this.getMaterialInventory(materialID, souID).setDefaultWarehouse(warehouse);
        }
    }

    public PersonInfo getDefaultStocker(String warehouseID) throws EASBizException, BOSException {
        if (this.getMapStocker() == null) {
            this.mapStocker = new HashMap(0);
        }
        PersonInfo stocker = (PersonInfo)this.getMapStocker().get(warehouseID);
        if (!this.getMapStocker().containsKey(warehouseID)) {
            String oql = "select id,hasLocation,whman.id, whman.number, whman.name where id = '" + warehouseID + "'";
            WarehouseInfo wh = WarehouseFactory.getRemoteInstance().getWarehouseInfo(oql);
            if (wh != null) {
                stocker = wh.getWhman();
            }
            this.getMapStocker().put(warehouseID, stocker);
        }
        return stocker;
    }

    public CurrencyInfo getCurrency(String currencyID) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo;
        if (this.getMapCurrency() == null) {
            this.mapCurrency = new HashMap(0);
        }
        if ((currencyInfo = (CurrencyInfo)this.getMapCurrency().get(currencyID)) == null) {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
            this.getMapCurrency().put(currencyID, currencyInfo);
        }
        return currencyInfo;
    }

    public void putDefaultStocker(String warehouseID, PersonInfo stocker) {
        if (warehouseID == null) {
            return;
        }
        this.getMapStocker().put(warehouseID, stocker);
    }

    public Integer getUnitPrecision(String materialID, String unitID) throws EASBizException, BOSException {
        if (this.getMapUnitPrecision() == null) {
            this.mapUnitPrecision = new HashMap(0);
        }
        if (!this.getMapUnitPrecision().containsKey(materialID + unitID)) {
            MultiMeasureUnitInfo mmu = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialID, unitID);
            if (mmu != null) {
                this.getMapUnitPrecision().put(materialID + unitID, new Integer(mmu.getQtyPrecision()));
            } else {
                this.getMapUnitPrecision().put(materialID + unitID, new Integer(8));
            }
        }
        return (Integer)this.getMapUnitPrecision().get(materialID + unitID);
    }

    public void putUnitPrecision(String materialID, String unitID, int precision) {
        if (materialID == null || unitID == null) {
            return;
        }
        this.getMapUnitPrecision().put(materialID + unitID, new Integer(precision));
    }

    public BigDecimal getUnitbaseConvsRate(String materialID, String unitID) throws EASBizException, BOSException {
        if (this.getMapUnitPrecision() == null) {
            this.mapUnitPrecision = new HashMap(0);
        }
        if (!this.getMapUnitbaseConvsRate().containsKey(materialID + unitID)) {
            MultiMeasureUnitInfo mmu = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialID, unitID);
            if (mmu != null) {
                this.getMapUnitbaseConvsRate().put(materialID + unitID, mmu.getBaseConvsRate());
            } else {
                this.getMapUnitbaseConvsRate().put(materialID + unitID, null);
            }
        }
        return (BigDecimal)this.getMapUnitbaseConvsRate().get(materialID + unitID);
    }

    public void putUnitbaseConvsRate(String materialID, String unitID, BigDecimal baseConvsRate) {
        if (materialID == null || unitID == null) {
            return;
        }
        this.getMapUnitbaseConvsRate().put(materialID + unitID, baseConvsRate);
    }

    public DateOfMinDurabilityInfo getDurability(String materialID, String souID, String lot) throws EASBizException, BOSException {
        if (materialID == null || souID == null || lot == null) {
            return null;
        }
        if (this.getMapDurability() == null) {
            this.mapDurability = new HashMap(0);
        }
        if (!this.getMapDurability().containsKey(materialID + souID + lot) || this.getMapDurability().get(materialID + souID + lot) == null) {
            StringBuffer oql = new StringBuffer();
            oql.append("select id,material,storageOrgUnit,lot,mfg,exp where ").append("storageOrgUnit = '").append(souID).append("' and ").append("material =  '").append(materialID).append("' and ").append("lot = '").append(lot).append("'");
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(oql.toString());
            if (doc.size() > 0) {
                this.putDurability(materialID, souID, lot, doc.get(0));
            }
        }
        return (DateOfMinDurabilityInfo)this.getMapDurability().get(materialID + souID + lot);
    }

    public void putDurability(String materialID, String souID, String lot, DateOfMinDurabilityInfo dod) {
        if (materialID == null || souID == null || lot == null) {
            return;
        }
        this.getMapDurability().put(materialID + souID + lot, dod);
    }

    private SelectorItemCollection getSupplyRelationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("supplyStorageOrgUnit.id");
        sic.add("supplyStorageOrgUnit.name");
        sic.add("supplyStorageOrgUnit.number");
        sic.add("requireStorageOrgUnit.id");
        sic.add("requireStorageOrgUnit.name");
        sic.add("requireStorageOrgUnit.number");
        sic.add("issueStorageOrgUnit.id");
        sic.add("issueStorageOrgUnit.name");
        sic.add("issueStorageOrgUnit.number");
        sic.add("receiveStorageOrgUnit.id");
        sic.add("receiveStorageOrgUnit.name");
        sic.add("receiveStorageOrgUnit.number");
        sic.add("supplyCompanyOrgUnit.id");
        sic.add("supplyCompanyOrgUnit.name");
        sic.add("supplyCompanyOrgUnit.number");
        sic.add("requireCompanyOrgUnit.id");
        sic.add("requireCompanyOrgUnit.name");
        sic.add("requireCompanyOrgUnit.number");
        sic.add("issueCompanyOrgUnit.id");
        sic.add("issueCompanyOrgUnit.name");
        sic.add("issueCompanyOrgUnit.number");
        sic.add("receiveCompanyOrgUnit.id");
        sic.add("receiveCompanyOrgUnit.name");
        sic.add("receiveCompanyOrgUnit.number");
        return sic;
    }

    private ITransferRule getTransferRuleByBizCategory(String bizCategoryId) throws BOSException {
        if ("88a7587a-e019-497b-9f86-b8f00ab2fe72A9389020".equals(bizCategoryId)) {
            return TransferRule2Factory.getRemoteInstance();
        }
        if ("eQQgnQESEADgAAAAwKgS/ak4kCA=".equals(bizCategoryId)) {
            return TransferRule3Factory.getRemoteInstance();
        }
        if ("eQQgnQESEADgAAABwKgS/ak4kCA=".equals(bizCategoryId)) {
            return TransferRule4Factory.getRemoteInstance();
        }
        return null;
    }

    private ITransferRule getTransferRuleBizByType(String bizTypeId, Context ctx) throws BOSException {
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeId)) {
            return TransferRule2Factory.getLocalInstance((Context)ctx);
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
            return TransferRule3Factory.getLocalInstance((Context)ctx);
        }
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
            return TransferRule4Factory.getLocalInstance((Context)ctx);
        }
        return null;
    }

    public Map getMapMaterial() {
        return this.mapMaterial;
    }

    public void setMapMaterial(Map mapMaterial) {
        this.mapMaterial = mapMaterial;
    }

    public void addMapMaterial(Map mapMaterial) {
        this.mapMaterial.putAll(mapMaterial);
    }

    public Map getMapMaterialCompany() {
        return this.mapMaterialCompany;
    }

    public void setMapMaterialCompany(Map mapMaterialCompany) {
        this.mapMaterialCompany = mapMaterialCompany;
    }

    public void addMapMaterialCompany(Map mapMaterialCompany) {
        this.mapMaterialCompany.putAll(mapMaterialCompany);
    }

    public Map getMapMaterialCost() {
        return this.mapMaterialCost;
    }

    public void setMapMaterialCost(Map mapMaterialCost) {
        this.mapMaterialCost = mapMaterialCost;
    }

    public void addMapMaterialCost(Map mapMaterialCost) {
        this.mapMaterialCost.putAll(mapMaterialCost);
    }

    public Map getMapMaterialInventory() {
        return this.mapMaterialInventory;
    }

    public void setMapMaterialInventory(Map mapMaterialInventory) {
        this.mapMaterialInventory = mapMaterialInventory;
    }

    public void addMapMaterialInventory(Map mapMaterialInventory) {
        this.mapMaterialInventory.putAll(mapMaterialInventory);
    }

    public Map getMapMaterialPurchasing() {
        return this.mapMaterialPurchasing;
    }

    public void setMapMaterialPurchasing(Map mapMaterialPurchasing) {
        this.mapMaterialPurchasing = mapMaterialPurchasing;
    }

    public void addMapMaterialPurchasing(Map mapMaterialPurchasing) {
        this.mapMaterialPurchasing.putAll(mapMaterialPurchasing);
    }

    public Map getMapMaterialSales() {
        return this.mapMaterialSales;
    }

    public void setMapMaterialSales(Map mapMaterialSales) {
        this.mapMaterialSales = mapMaterialSales;
    }

    public void addMapMaterialSales(Map mapMaterialSales) {
        this.mapMaterialSales.putAll(mapMaterialSales);
    }

    public Map getMapStocker() {
        return this.mapStocker;
    }

    public void setMapStocker(Map mapStocker) {
        this.mapStocker = mapStocker;
    }

    public void addMapStocker(Map mapStocker) {
        this.mapStocker.putAll(mapStocker);
    }

    public Map getMapUnitPrecision() {
        return this.mapUnitPrecision;
    }

    public void setMapUnitPrecision(Map mapUnitPrecision) {
        this.mapUnitPrecision = mapUnitPrecision;
    }

    public void addMapUnitPrecision(Map mapUnitPrecision) {
        this.mapUnitPrecision.putAll(mapUnitPrecision);
    }

    public Map getMapUnitbaseConvsRate() {
        return this.mapUnitbaseConvsRate;
    }

    public void setMapUnitbaseConvsRate(Map mapUnitbaseConvsRate) {
        this.mapUnitbaseConvsRate = mapUnitbaseConvsRate;
    }

    public void addMapUnitbaseConvsRate(Map mapUnitbaseConvsRate) {
        this.mapUnitbaseConvsRate.putAll(mapUnitbaseConvsRate);
    }

    public Map getMapWarehouse() {
        return this.mapWarehouse;
    }

    public void setMapWarehouse(Map mapWarehouse) {
        this.mapWarehouse = mapWarehouse;
    }

    public void addMapWarehouse(Map mapWarehouse) {
        this.mapWarehouse.putAll(mapWarehouse);
    }

    public Map getMapDefaultLocation() {
        return this.mapDefaultLocation;
    }

    public void setMapDefaultLocation(Map mapDefaultLocation) {
        this.mapDefaultLocation = mapDefaultLocation;
    }

    public Map getMapDurability() {
        return this.mapDurability;
    }

    public void setMapDurability(Map mapDurability) {
        this.mapDurability = mapDurability;
    }

    public void addMapDurability(Map mapDurability) {
        this.mapDurability.putAll(mapDurability);
    }

    public void addMapDefualtLocation(Map mapDefaultLocation) {
        this.mapDefaultLocation.putAll(mapDefaultLocation);
    }

    public Map getMapSupplyRelation() {
        return this.mapSupplyRelation;
    }

    public void setMapSupplyRelation(Map mapSupplyRelation) {
        this.mapSupplyRelation = mapSupplyRelation;
    }

    public Map getMapTransferRule() {
        return this.mapTransferRule;
    }

    public void setMapTransferRule(Map mapTransferRule) {
        this.mapTransferRule = mapTransferRule;
    }

    public CompanyOrgUnitInfo getCou() {
        return this.cou;
    }

    public void setCou(CompanyOrgUnitInfo cou) {
        this.cou = cou;
    }

    public StorageOrgUnitInfo getSou() {
        return this.sou;
    }

    public void setSou(StorageOrgUnitInfo sou) {
        this.sou = sou;
    }

    public Map getMapCurrency() {
        return this.mapCurrency;
    }

    public void setMapCurrency(Map mapCurrency) {
        this.mapCurrency = mapCurrency;
    }

    public Map getMapParamValue() {
        return this.mapParamValue;
    }

    public void setMapParamValue(Map mapParamValue) {
        this.mapParamValue = mapParamValue;
    }

    public SaleOrgUnitInfo getSaleOrgUnitInfo() {
        return this.saleOrgUnitInfo;
    }

    public void setSaleOrgUnitInfo(SaleOrgUnitInfo saleOrgUnitInfo) {
        this.saleOrgUnitInfo = saleOrgUnitInfo;
    }

    public CompanyOrgUnitInfo getCompanyOrgBySale() {
        return this.companyOrgBySale;
    }

    public void setCompanyOrgBySale(CompanyOrgUnitInfo companyOrgBySale) {
        this.companyOrgBySale = companyOrgBySale;
    }

    public OrgUnitCollection getSaleOrgUnitInfos() {
        return this.saleOrgUnitInfos;
    }

    public void setSaleOrgUnitInfos(OrgUnitCollection saleOrgUnitInfos) {
        this.saleOrgUnitInfos = saleOrgUnitInfos;
    }

    public OrgUnitCollection getSaleOrgsByCou() {
        return this.saleOrgsByCou;
    }

    public void setSaleOrgsByCou(OrgUnitCollection saleOrgsByCou) {
        this.saleOrgsByCou = saleOrgsByCou;
    }

    public Map getMapLotNumber() {
        return this.mapLotNumber;
    }

    public void setMapLotNumber(Map mapLotNumber) {
        this.mapLotNumber = mapLotNumber;
    }

    public void addMapLotNumber(Map mapLotNumber) {
        this.mapLotNumber.putAll(mapLotNumber);
    }

    public Map getOrgUnitColl() {
        return this.orgUnitColl;
    }

    public void setOrgUnitColl(Map orgUnitColl) {
        this.orgUnitColl = orgUnitColl;
    }

    public Map getCusotmerCollByCompany() {
        return this.cusotmerCollByCompany;
    }

    public void setCusotmerCollByCompany(Map cusotmerCollByCompany) {
        this.cusotmerCollByCompany = cusotmerCollByCompany;
    }

    public BOTRelationCollection getBotRelationColl() {
        return this.botRelationColl;
    }

    public void setBotRelationColl(BOTRelationCollection botRelationColl) {
        this.botRelationColl = botRelationColl;
    }

    public MaterialSalesCollection getMaterialSalesCollection() {
        return this.materialSalesCollection;
    }

    public void setMaterialSalesCollection(MaterialSalesCollection materialSalesCollection) {
        this.materialSalesCollection = materialSalesCollection;
    }

    public CustomerSaleInfoInfo getCustomerSaleInfo() {
        return this.customerSaleInfo;
    }

    public void setCustomerSaleInfo(CustomerSaleInfoInfo customerSaleInfo) {
        this.customerSaleInfo = customerSaleInfo;
    }

    public Map getEntryDataVOMap() {
        return this.entryDataVOMap;
    }

    public Map getAssistUnitCollMap() {
        return this.assistUnitCollMap;
    }

    public void setFetchAuthOrg(Map map) {
        if (this.fetchAuthOrg == null) {
            this.fetchAuthOrg = new HashMap();
        }
        this.fetchAuthOrg.putAll(map);
    }

    public Map getFetchAuthorg() {
        if (this.fetchAuthOrg == null) {
            this.fetchAuthOrg = new HashMap();
        }
        return this.fetchAuthOrg;
    }

    public void setFetchRptConditionData(Map map) {
        if (this.fetchRptConditionData == null) {
            this.fetchRptConditionData = new HashMap();
        }
        this.fetchRptConditionData.putAll(map);
    }

    public Map getFetchRptConditionData() {
        if (this.fetchRptConditionData == null) {
            this.fetchRptConditionData = new HashMap();
        }
        return this.fetchRptConditionData;
    }

    public LocationInfo getLocationFromCache(String materialId, String warehsId, String souID) throws EASBizException, BOSException {
        if (materialId == null || warehsId == null || souID == null) {
            return null;
        }
        if (this.getMapDefaultLocation() == null) {
            this.mapDefaultLocation = new HashMap(0);
        }
        return (LocationInfo)this.getMapDefaultLocation().get(materialId + warehsId + souID);
    }

    public void getLocalLocations(Context ctx, List<String> materialId, List<String> warehsId, String souID) throws EASBizException, BOSException {
        if (materialId.size() <= 0 || warehsId.size() <= 0 || StringUtils.isEmpty((String)souID)) {
            return;
        }
        if (this.getMapDefaultLocation() == null) {
            this.mapDefaultLocation = new HashMap(0);
        }
        StringBuffer materialIdIn = new StringBuffer();
        StringBuffer warehsIdIn = new StringBuffer();
        for (int j = 0; j < (materialId.size() > warehsId.size() ? materialId.size() : warehsId.size()); ++j) {
            if (j < materialId.size() && !StringUtils.isEmpty((String)materialId.get(j))) {
                materialIdIn.append("'").append(materialId.get(j)).append("',");
            }
            if (j >= warehsId.size() || StringUtils.isEmpty((String)warehsId.get(j))) continue;
            warehsIdIn.append("'").append(warehsId.get(j)).append("',");
        }
        if (materialIdIn.length() <= 3) {
            return;
        }
        materialIdIn.setLength(materialIdIn.length() - 1);
        if (warehsIdIn.length() <= 3) {
            return;
        }
        warehsIdIn.setLength(warehsIdIn.length() - 1);
        IMaterialStorageAssign imsa = ctx == null ? MaterialStorageAssignFactory.getRemoteInstance() : MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select id,material.id,storageOrg.id,warehouse.id,location.id,location.name,location.number ").append("where storageOrg = '").append(souID).append("' and ").append("material in (").append(materialIdIn.toString()).append(") and ").append("warehouse in (").append(warehsIdIn.toString()).append(") and ").append("ISDEFAULTLOCATION = 1 ");
        MaterialStorageAssignCollection msaCol = imsa.getMaterialStorageAssignCollection(oql.toString());
        for (int i = 0; i < msaCol.size(); ++i) {
            MaterialStorageAssignInfo info = msaCol.get(i);
            this.putDefaultLocation(info.getMaterial().getId().toString(), info.getWarehouse().getId().toString(), info.getStorageOrg().getId().toString(), info.getLocation());
        }
    }

    public MaterialPurchasingInfo getMaterialPurchasingFromCache(String materialID, String pouID) throws EASBizException, BOSException {
        if (this.getMapMaterialPurchasing() == null) {
            this.mapMaterialPurchasing = new HashMap(0);
        }
        return (MaterialPurchasingInfo)this.getMapMaterialPurchasing().get(materialID + pouID);
    }

    public void setMapSupplierPurchase(Map mapSupplierPurchase) {
        this.mapSupplierPurchase = mapSupplierPurchase;
    }

    public void addMapSupplierPurchase(Map mapSupplierPurchase) {
        this.mapSupplierPurchase.putAll(mapSupplierPurchase);
    }

    public void putMapSupplierPurchase(String supplierId, String purOrgId, SupplierPurchaseInfoInfo info) {
        if (supplierId == null || purOrgId == null) {
            return;
        }
        this.mapSupplierPurchase.put(supplierId + purOrgId, info);
    }

    public SupplierPurchaseInfoInfo getSupplierPurchaseInfo(String supplierId, String purOrgId) throws BOSException {
        if (supplierId == null || purOrgId == null) {
            return null;
        }
        String key = supplierId + purOrgId;
        SupplierPurchaseInfoInfo info = (SupplierPurchaseInfoInfo)this.mapSupplierPurchase.get(key);
        if (info == null) {
            ISupplierPurchaseInfo isupplierPurchaseInfo = SupplierPurchaseInfoFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("supplier.id", (Object)supplierId);
            filter.appendFilterItem("purchaseOrgUnit.id", (Object)purOrgId);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("purchaseGroup.id"));
            selectorItemCollection.add(new SelectorItemInfo("purchaseGroup.name"));
            selectorItemCollection.add(new SelectorItemInfo("purchaseGroup.number"));
            selectorItemCollection.add(new SelectorItemInfo("defaultPurchaser.id"));
            selectorItemCollection.add(new SelectorItemInfo("defaultPurchaser.name"));
            selectorItemCollection.add(new SelectorItemInfo("defaultPurchaser.number"));
            viewInfo.setFilter(filter);
            viewInfo.setSelector(selectorItemCollection);
            SupplierPurchaseInfoCollection col = isupplierPurchaseInfo.getSupplierPurchaseInfoCollection(viewInfo);
            if (!col.isEmpty()) {
                info = col.get(0);
            }
            this.putMapSupplierPurchase(supplierId, purOrgId, info);
        }
        return info;
    }

    public SettlementRelationInfo getSettlementRelationInfo(String supplyCouId, String reqCouId, String bizTypeId) throws EASBizException, BOSException {
        if (!this.mapSettlementRelation.containsKey(supplyCouId + reqCouId + bizTypeId)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("supCompanyOrg.id", (Object)supplyCouId);
            filter.appendFilterItem("reqCompanyOrg.id", (Object)reqCouId);
            filter.appendFilterItem("bizType.id", (Object)bizTypeId);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SettlementRelationCollection col = SettlementRelationFactory.getRemoteInstance().getSettlementRelationCollection(view);
            if (this.mapSettlementRelation == null) {
                this.mapSettlementRelation = new HashMap();
            }
            this.mapSettlementRelation.put(supplyCouId + reqCouId + bizTypeId, col.size() > 0 ? col.get(0) : null);
        }
        return (SettlementRelationInfo)this.mapSettlementRelation.get(supplyCouId + reqCouId + bizTypeId);
    }

    public SettlementRuleEntryForPCInfo getSettlementRuleEntryForPC(MaterialInfo materialInfo, ProfitCenterOrgUnitInfo issueProfitCenter, ProfitCenterOrgUnitInfo receiptProfitCenter) throws EASBizException, BOSException {
        if (!this.mapSettlementRuleEntryForPC.containsKey(materialInfo.getId().toString() + issueProfitCenter.getId().toString() + receiptProfitCenter.getId().toString())) {
            SettlementRuleEntryForPCInfo srEntry = (SettlementRuleEntryForPCInfo)SettlementRuleForPCFactory.getRemoteInstance().getSettlementRuleEntryForPCInfo(materialInfo, issueProfitCenter, receiptProfitCenter);
            this.mapSettlementRuleEntryForPC.put(materialInfo.getId().toString() + issueProfitCenter.getId().toString() + receiptProfitCenter.getId().toString(), srEntry);
        }
        return (SettlementRuleEntryForPCInfo)this.mapSettlementRuleEntryForPC.get(materialInfo.getId().toString() + issueProfitCenter.getId().toString() + receiptProfitCenter.getId().toString());
    }
}

