/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.im.inv.StockReqEntryFactory;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SO2SRWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{false, false, true};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_SO_Audit", WriteBackSQLHelper.createSO2SRWriteSQL(bizAction, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_SO_UnAduit", WriteBackSQLHelper.createSO2SRWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            this.writeBackToMaterialReq(ctx, billId, bizAction);
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.SO2SRWriteBackHandler");
        String CR_TEMP = WriteBackSQLHelper.getSO2SRTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBackSQLHelper.getSO2SRInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBackSQLHelper.createSRWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBackSQLHelper.verifySRWriteBack(rs);
    }

    private void autoCloseSourceBill(List srcEntryIDList, Context ctx, BizActionEnum enums) throws EASBizException, BOSException {
        boolean isAudit = true;
        if (enums.equals((Object)BizActionEnum.UNAUDIT)) {
            isAudit = false;
        }
        if (srcEntryIDList == null || srcEntryIDList.size() == 0) {
            return;
        }
        if (isAudit) {
            StockReqEntryFactory.getLocalInstance((Context)ctx).autoClose(srcEntryIDList);
        } else {
            StockReqEntryFactory.getLocalInstance((Context)ctx).autoUnClose(srcEntryIDList);
        }
    }

    private void writeBackToMaterialReq(Context ctx, String[] pks, BizActionEnum enums) throws BOSException, EASBizException {
        int length = pks.length;
        StringBuffer currentIds = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                currentIds.append("'").append(pks[i].toString()).append("'");
                continue;
            }
            currentIds.append("'").append(pks[i].toString()).append("'").append(",");
        }
        String ids = ArrayUtil.getInStringFromArray((String[])pks);
        try {
            StringBuffer sqlbuffer = new StringBuffer();
            sqlbuffer.append(" select FSourceBillId, FSourceBillEntryID").append(" from t_sd_saleorderentry ").append(" where fparentid in ").append(ids).append(" and FSourceBillTypeId = '").append("MmEE6VBsR0KaUDQmebwhP0Y+1VI=").append("' ").append(" group by FSourceBillId, FSourceBillEntryID ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbuffer.toString());
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> srcEntryIDList = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString("FSourceBillId"));
                srcEntryIDList.add(rs.getString("FSourceBillEntryID"));
            }
            if (list.size() > 0) {
                this.autoCloseSourceBill(srcEntryIDList, ctx, enums);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }
}

