/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.action.ITableSelectionHelper;
import java.util.ArrayList;

public abstract class AbstractTableSelectionHelper
implements ITableSelectionHelper {
    protected KDTable tblMain;
    protected String entryIdColName;
    protected String entrySeqColName;
    protected String entryName;
    protected ISupportBatchAction iSupportBatchAction;

    @Override
    public abstract void refresh(BatchActionEnum var1, BatchSelectionEntries var2, int var3) throws Exception;

    protected abstract BatchSelectionEntries getSelectedAllIDs(Context var1, ActionLevelEnum var2, int[] var3) throws BOSException;

    protected abstract BatchSelectionEntry getSelectionEntry(IRow var1, ActionLevelEnum var2) throws BOSException;

    protected abstract BatchSelectionEntries getSelectedMultiIDs(Context var1, ActionLevelEnum var2, int[] var3) throws BOSException;

    protected BatchSelectionEntries getSelectedMultiIDs4SwitchView(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        return null;
    }

    @Override
    public boolean hasSelectedRows(ActionLevelEnum actionLevel) {
        return this.tblMain.getRowCount() > 0 && this.tblMain.getSelectManager().size() > 0;
    }

    @Override
    public BatchSelectionEntries getSelectedIDs(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return null;
        }
        if (mainOrgContext.get((Object)"IS_SWITCHVIEW") != null && Boolean.TRUE.equals(mainOrgContext.get((Object)"IS_SWITCHVIEW"))) {
            return this.getSelectedMultiIDs4SwitchView(mainOrgContext, actionLevel, selectRows);
        }
        if (size == 1 && selectRows.length == 1) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            IRow row = this.tblMain.getRow(rowNum);
            return this.getSelectedOneID(row, actionLevel);
        }
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (mode == 8) {
            return this.getSelectedAllIDs(mainOrgContext, actionLevel, selectRows);
        }
        return this.getSelectedMultiIDs(mainOrgContext, actionLevel, selectRows);
    }

    protected BatchSelectionEntries getSelectedOneID(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, 1);
        results.add(this.getSelectionEntry(row, actionLevel));
        return results;
    }

    protected final Object getCellValue(ICell cell) throws BOSException {
        if (cell == null) {
            throw new IllegalArgumentException("TableSelectionHelper.setTableProperty: the column name in parameters is incorrect.");
        }
        return cell.getValue();
    }
}

