/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public abstract class KDTableUtils {
    public static String getFieldName(KDTable table, int columnIndex) {
        String fieldName = null;
        if (table != null && columnIndex > -1) {
            fieldName = table.getColumnKey(columnIndex);
        }
        return fieldName;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, String fieldName) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, int columnIndex) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static List getFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, fieldNames[i]));
            }
        }
        return values;
    }

    public static List getFieldValues(KDTable table, int rowIndex, int[] columnIndexes) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, columnIndexes[i]));
            }
        }
        return values;
    }

    public static void setFieldValues(KDTable table, int rowIndex, String[] fieldNames, Object[] values) {
        if (fieldNames != null) {
            int vSize = values.length;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], null);
            }
        }
    }

    public static void setFieldValues(KDTable table, int rowIndex, int[] columnIndexes, Object[] values) {
        if (columnIndexes != null) {
            int vSize = values.length;
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], null);
            }
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, String fieldName, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, int columnIndex, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static ICell getCell(KDTable table, int rowIndex, String fieldName) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && fieldName != null && fieldName.trim().length() != 0) {
            cell = table.getRow(rowIndex).getCell(fieldName);
        }
        return cell;
    }

    public static ICell getCell(KDTable table, int rowIndex, int columnIndex) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && columnIndex > -1) {
            cell = table.getRow(rowIndex).getCell(columnIndex);
        }
        return cell;
    }

    public static IColumn getColumn(KDTable table, String fieldName) {
        IColumn column = null;
        if (table != null && fieldName != null && fieldName.trim().length() != 0) {
            column = table.getColumn(fieldName);
        }
        return column;
    }

    public static IColumn getColumn(KDTable table, int rowIndex, int columnIndex) {
        IColumn column = null;
        if (table != null && columnIndex > -1) {
            column = table.getColumn(columnIndex);
        }
        return column;
    }

    public static void setHideFields(KDTable table, String[] fieldNames, boolean isHide) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setHided(isHide);
            }
        }
    }

    public static void setLockFields(KDTable table, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setLockFieldsForRow(KDTable table, String[] fieldNames, boolean isLock, int rowIndex) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                if (table.getRow(rowIndex) == null) continue;
                table.getRow(rowIndex).getCell(fieldNames[i]).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setLockFieldsForRow(KDTable table, int[] fieldNames, boolean isLock, int rowIndex) {
        if (fieldNames != null) {
            IRow row = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                row = table.getRow(rowIndex);
                if (row == null) continue;
                row.getCell(fieldNames[i]).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(KDTableUtils.getCell(table, rowIndex, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision)));
            column.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString(precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision) {
        if (cell != null) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision)));
            cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString(precision));
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        return colTxtField;
    }

    public static void changeScrollBar(KDTable table) {
        table.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        table.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
    }
}

