/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ISalePerson;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class SCMClientHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.client.SCMClientHelper");
    private SCMBillEditUI scmBillEditUI;
    private CoreUIObject currentUI;
    private HashMap tableMap = new HashMap();
    public static final String VALIDQTYCELL_GREATERTHAN_ZERO = ">";
    public static final String VALIDQTYCELL_GREATERTHANOREQUAL_ZERO = ">=";
    public static final String VALIDQTYCELL_LESSTHAN_ZERO = "<";
    private String[][] RequiredCols = null;
    private static final int MaxCheckedField = 5;
    private DataChangeListener startDateDataChangeListener = null;
    private DataChangeListener endDateDataChangeListener = null;
    public static final String TOTAL = "TOTAL";
    public static final String COL_SEQ = "seq";
    private static String[] TotalCols = null;
    public static final Color KDTABLE_TOTAL_BG_COLOR = new Color(0xF6F6B6);
    public static final BigDecimal ZERO = new BigDecimal("0");
    private HashMap componentEnabledMap = new HashMap();
    private HashMap tableColLockedMap = new HashMap();
    private boolean hasInitComponentEnabledStatus;
    private boolean hasInitTableColEnabledStatus;
    private KDDatePicker startDate;
    private KDDatePicker endDate;
    private Timestamp currentEndDate;
    private Timestamp currentStartDate;

    public SCMClientHelper(SCMBillEditUI ui) {
        this.scmBillEditUI = ui;
    }

    public SCMClientHelper(CoreUIObject ui) {
        this.currentUI = ui;
    }

    public void initSalePersonDisplay(KDBizPromptBox bizprmt) {
        SalePersonInfo salePersonInfo;
        if (bizprmt.getValue() != null && !bizprmt.getValue().getClass().getName().equals("com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo")) {
            return;
        }
        SalePersonInfo salePersonInfo2 = salePersonInfo = bizprmt.getValue() == null ? null : (SalePersonInfo)bizprmt.getValue();
        if (salePersonInfo == null) {
            return;
        }
        try {
            salePersonInfo = this.getSalePersonInfo(salePersonInfo.getId());
            bizprmt.setData((Object)salePersonInfo.getPerson());
            bizprmt.setUserData((Object)salePersonInfo.getSaleGroup());
        }
        catch (Exception e) {
            this.scmBillEditUI.handUIException((Throwable)((Object)new SCMBillException(SCMBillException.SALEPERSONISNOTEXIST)));
        }
    }

    public void setSalePersonDisplay(KDBizPromptBox bizprmt) {
        bizprmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                SCMClientHelper.this.initSalePersonDisplay((KDBizPromptBox)e.getSource());
            }
        });
    }

    private SalePersonInfo getSalePersonInfo(BOSUuid pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("saleGroup.number"));
        sic.add(new SelectorItemInfo("saleGroup.saleOrg.id"));
        ISalePerson iSalePerson = SalePersonFactory.getRemoteInstance();
        return iSalePerson.getSalePersonInfo((IObjectPK)new ObjectUuidPK(pk), sic);
    }

    public void initPurPersonDisplay(KDBizPromptBox bizprmt) {
        bizprmt.setHistoryRecordEnabled(false);
        try {
            PurchasePersonInfo purPersonInfo;
            if (bizprmt.getValue() != null && !bizprmt.getValue().getClass().getName().equals("com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo")) {
                return;
            }
            PurchasePersonInfo purchasePersonInfo = purPersonInfo = bizprmt.getValue() == null ? null : (PurchasePersonInfo)bizprmt.getValue();
            if (purPersonInfo == null) {
                return;
            }
            purPersonInfo = this.getPurPersonInfo(purPersonInfo.getId());
            bizprmt.setData((Object)purPersonInfo.getPerson());
            bizprmt.setUserData((Object)purPersonInfo.getPurGroup());
        }
        catch (Exception exc) {
            this.scmBillEditUI.handUIException((Throwable)((Object)new SCMBillException(SCMBillException.PURPERSONISNOTEXIST)));
        }
    }

    public void setPurPersonDisplay(KDBizPromptBox bizprmt) {
        bizprmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                SCMClientHelper.this.initPurPersonDisplay((KDBizPromptBox)e.getSource());
            }
        });
    }

    private PurchasePersonInfo getPurPersonInfo(BOSUuid pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("purGroup.id"));
        sic.add(new SelectorItemInfo("purGroup.name"));
        sic.add(new SelectorItemInfo("purGroup.number"));
        IPurchasePerson iPurPerson = PurchasePersonFactory.getRemoteInstance();
        return iPurPerson.getPurchasePersonInfo((IObjectPK)new ObjectUuidPK(pk), sic);
    }

    public void validQtyCell(KDTable table1, String[][] qtyFieldName) {
        KDTPropertyChangeListener listener;
        TableBindContent tableBindContent = new TableBindContent();
        tableBindContent.notNegativeFieldName = qtyFieldName;
        tableBindContent.tableListener = listener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                KDTable table = (KDTable)evt.getSource();
                if ("cellValue".equals(evt.getPropertyName())) {
                    int rowIndex = evt.getRowIndex();
                    int colIndex = evt.getColIndex();
                    String fieldName = table.getColumnKey(colIndex);
                    if (SCMClientHelper.this.tableMap.get(table) == null) {
                        return;
                    }
                    String[][] validFieldNames = ((TableBindContent)((SCMClientHelper)SCMClientHelper.this).tableMap.get((Object)table)).notNegativeFieldName;
                    if (validFieldNames == null) {
                        return;
                    }
                    int num = validFieldNames.length;
                    for (int i = 0; i < num; ++i) {
                        String newObj;
                        if (!validFieldNames[i][0].equalsIgnoreCase(fieldName)) continue;
                        BigDecimal oldValue = null;
                        if (evt.getOldValue() != null && StringUtil.isNumber(evt.getOldValue().toString())) {
                            oldValue = new BigDecimal(evt.getOldValue().toString());
                        }
                        String string = newObj = evt.getNewValue() == null ? null : evt.getNewValue().toString();
                        if (newObj == null) break;
                        NumberFormat nf = BOSLocaleUtil.getNumberFormat((Locale)SysContext.getSysContext().getLocale());
                        try {
                            newObj = String.valueOf(nf.parse(newObj).doubleValue());
                        }
                        catch (ParseException e) {
                            logger.error((Object)e);
                        }
                        boolean valid = true;
                        if (StringUtil.isNumber(newObj)) {
                            if (validFieldNames[i].length == 1 || StringUtils.isEmpty((String)validFieldNames[i][1]) || validFieldNames[i][1].equalsIgnoreCase(SCMClientHelper.VALIDQTYCELL_GREATERTHANOREQUAL_ZERO)) {
                                if (!(Double.parseDouble(newObj) >= 0.0)) {
                                    valid = false;
                                }
                            } else if (validFieldNames[i][1].equalsIgnoreCase(SCMClientHelper.VALIDQTYCELL_GREATERTHAN_ZERO)) {
                                if (!(Double.parseDouble(newObj) > 0.0)) {
                                    valid = false;
                                }
                            } else if (validFieldNames[i][1].equalsIgnoreCase(SCMClientHelper.VALIDQTYCELL_LESSTHAN_ZERO) && !(Double.parseDouble(newObj) < 0.0)) {
                                valid = false;
                            }
                        } else {
                            valid = false;
                        }
                        if (valid) break;
                        table.removeKDTPropertyChangeListener((KDTPropertyChangeListener)this);
                        if (table.getRowCount() > 0) {
                            table.getCell(rowIndex, colIndex).setValue((Object)oldValue);
                        }
                        table.addKDTPropertyChangeListener((KDTPropertyChangeListener)this);
                        break;
                    }
                }
            }
        };
        this.tableMap.put(table1, tableBindContent);
        table1.addKDTPropertyChangeListener(listener);
    }

    public void unValidTableCell(KDTable table) {
        TableBindContent tableBindContent = (TableBindContent)this.tableMap.get(table);
        if (tableBindContent != null && tableBindContent.tableListener != null) {
            table.removeKDTPropertyChangeListener(tableBindContent.tableListener);
            this.tableMap.remove(table);
        }
    }

    public void validQtyCell(KDTable table1, String[] qtyFieldName) {
        String[][] newQtyFieldName = new String[qtyFieldName.length][2];
        for (String newQtyFieldName[i][0] : qtyFieldName) {
        }
        this.validQtyCell(table1, newQtyFieldName);
    }

    public void initComponentUnEnabledStatus(Component[] components, Component[] unEnabledComponents, HashMap unEnabledTableCole) {
        Container container = null;
        Object cnComponents = null;
        KDTable table = null;
        int componentNum = components.length;
        block0: for (int i = 0; i < componentNum; ++i) {
            if (components[i] instanceof KDFormattedTextField || components[i] instanceof KDDatePicker || components[i] instanceof KDBizPromptBox || components[i] instanceof KDTextField || components[i] instanceof KDComboBox || components[i] instanceof KDCheckBox) {
                if (!this.componentEnabledMap.containsKey(components[i].getName())) {
                    this.componentEnabledMap.put(components[i].getName(), new Boolean(components[i].isEnabled()));
                }
                if (unEnabledComponents == null) continue;
                int num = unEnabledComponents.length;
                for (int j = 0; j < num; ++j) {
                    if (unEnabledComponents[j] != components[i]) continue;
                    components[i].setEnabled(false);
                    continue block0;
                }
                continue;
            }
            if (components[i] instanceof KDPanel || components[i] instanceof KDScrollPane || components[i] instanceof KDSplitPane || components[i] instanceof KDTabbedPane || components[i] instanceof KDLabelContainer || components[i] instanceof KDContainer) {
                container = (Container)components[i];
                this.initComponentUnEnabledStatus(container.getComponents(), unEnabledComponents, unEnabledTableCole);
                this.hasInitComponentEnabledStatus = false;
                continue;
            }
            if (!(components[i] instanceof KDTable)) continue;
            this.hasInitTableColEnabledStatus = false;
            table = (KDTable)components[i];
            this.initTableColUnEnabledStatus(table, unEnabledTableCole);
        }
        this.hasInitComponentEnabledStatus = true;
    }

    public void initTableColUnEnabledStatus(KDTable table, HashMap unEnabledTableCole) {
        String[] tabColNames = (String[])unEnabledTableCole.get(table);
        String curFieldName = null;
        if (tabColNames != null) {
            int colNum = table.getColumnCount();
            block0: for (int i = 0; i < colNum; ++i) {
                curFieldName = table.getColumnKey(i);
                if (!this.tableColLockedMap.containsKey(table)) {
                    this.tableColLockedMap.put(table, new HashMap());
                }
                if (!((HashMap)this.tableColLockedMap.get(table)).containsKey(curFieldName)) {
                    ((HashMap)this.tableColLockedMap.get(table)).put(curFieldName, new Boolean(table.getColumn(i).getStyleAttributes().isLocked()));
                }
                int num = tabColNames.length;
                for (int j = 0; j < num; ++j) {
                    if (!tabColNames[j].equalsIgnoreCase(curFieldName)) continue;
                    table.getColumn(i).getStyleAttributes().setLocked(true);
                    continue block0;
                }
            }
        }
        this.hasInitTableColEnabledStatus = true;
    }

    public void initComponentEnabledStatus(Component[] components, Component[] enabledComponents, HashMap enabledTableCole) {
        boolean unEnabled = true;
        Container container = null;
        Object cnComponents = null;
        KDTable table = null;
        int componentNum = components.length;
        for (int i = 0; i < componentNum; ++i) {
            unEnabled = true;
            if (components[i] instanceof KDFormattedTextField || components[i] instanceof KDDatePicker || components[i] instanceof KDBizPromptBox || components[i] instanceof KDTextField || components[i] instanceof KDComboBox || components[i] instanceof KDCheckBox) {
                if (!this.componentEnabledMap.containsKey(components[i].getName())) {
                    this.componentEnabledMap.put(components[i].getName(), new Boolean(components[i].isEnabled()));
                }
                if (enabledComponents != null) {
                    int num = enabledComponents.length;
                    for (int j = 0; j < num; ++j) {
                        if (enabledComponents[j] != components[i]) continue;
                        unEnabled = false;
                        break;
                    }
                    if (!unEnabled) continue;
                    components[i].setEnabled(false);
                    continue;
                }
                components[i].setEnabled(false);
                continue;
            }
            if (components[i] instanceof KDPanel || components[i] instanceof KDScrollPane || components[i] instanceof KDSplitPane || components[i] instanceof KDTabbedPane || components[i] instanceof KDLabelContainer || components[i] instanceof KDContainer) {
                container = (Container)components[i];
                this.initComponentEnabledStatus(container.getComponents(), enabledComponents, enabledTableCole);
                this.hasInitComponentEnabledStatus = false;
                continue;
            }
            if (!(components[i] instanceof KDTable)) continue;
            this.hasInitTableColEnabledStatus = false;
            table = (KDTable)components[i];
            this.initTableColEnabledStatus(table, enabledTableCole);
        }
        this.hasInitComponentEnabledStatus = true;
    }

    public void initTableColEnabledStatus(KDTable table, HashMap enabledTableCole) {
        boolean unEnabled = true;
        String[] tabColNames = (String[])enabledTableCole.get(table);
        String curFieldName = null;
        if (tabColNames != null) {
            int colNum = table.getColumnCount();
            for (int i = 0; i < colNum; ++i) {
                unEnabled = true;
                curFieldName = table.getColumnKey(i);
                if (!this.tableColLockedMap.containsKey(table)) {
                    this.tableColLockedMap.put(table, new HashMap());
                }
                if (!((HashMap)this.tableColLockedMap.get(table)).containsKey(curFieldName)) {
                    ((HashMap)this.tableColLockedMap.get(table)).put(curFieldName, new Boolean(table.getColumn(i).getStyleAttributes().isLocked()));
                }
                int num = tabColNames.length;
                for (int j = 0; j < num; ++j) {
                    if (!tabColNames[j].equalsIgnoreCase(curFieldName)) continue;
                    unEnabled = false;
                    break;
                }
                if (!unEnabled || table.getColumn(i).getStyleAttributes().isLocked()) continue;
                table.getColumn(i).getStyleAttributes().setLocked(true);
            }
        } else {
            int colNum = table.getColumnCount();
            for (int i = 0; i < colNum; ++i) {
                curFieldName = table.getColumnKey(i);
                if (!this.tableColLockedMap.containsKey(table)) {
                    this.tableColLockedMap.put(table, new HashMap());
                }
                if (!((HashMap)this.tableColLockedMap.get(table)).containsKey(curFieldName)) {
                    ((HashMap)this.tableColLockedMap.get(table)).put(curFieldName, new Boolean(table.getColumn(i).getStyleAttributes().isLocked()));
                }
                if (table.getColumn(i).getStyleAttributes().isLocked()) continue;
                table.getColumn(i).getStyleAttributes().setLocked(true);
            }
        }
        this.hasInitTableColEnabledStatus = true;
    }

    public void renewComponentEnabledStatus(Component[] components) {
        if (!this.hasInitComponentEnabledStatus) {
            return;
        }
        boolean enabledStatus = true;
        Container container = null;
        Object cnComponents = null;
        KDTable table = null;
        int componentNum = components.length;
        for (int i = 0; i < componentNum; ++i) {
            if (components[i] instanceof KDFormattedTextField || components[i] instanceof KDDatePicker || components[i] instanceof KDBizPromptBox || components[i] instanceof KDTextField || components[i] instanceof KDComboBox || components[i] instanceof KDCheckBox) {
                if (!this.componentEnabledMap.containsKey(components[i].getName())) continue;
                enabledStatus = (Boolean)this.componentEnabledMap.get(components[i].getName());
                components[i].setEnabled(enabledStatus);
                continue;
            }
            if (components[i] instanceof KDPanel || components[i] instanceof KDScrollPane || components[i] instanceof KDSplitPane || components[i] instanceof KDTabbedPane || components[i] instanceof KDLabelContainer || components[i] instanceof KDContainer) {
                container = (Container)components[i];
                this.renewComponentEnabledStatus(container.getComponents());
                this.hasInitComponentEnabledStatus = true;
                continue;
            }
            if (!(components[i] instanceof KDTable)) continue;
            this.hasInitTableColEnabledStatus = true;
            table = (KDTable)components[i];
            this.renewTableColEnabledStatus(table);
        }
        this.hasInitComponentEnabledStatus = false;
    }

    public void renewTableColEnabledStatus(KDTable table) {
        if (!this.hasInitTableColEnabledStatus) {
            return;
        }
        boolean enabledStatus = true;
        String columnKey = null;
        if (table != null && this.tableColLockedMap.containsKey(table)) {
            int colNum = table.getColumnCount();
            for (int i = 0; i < colNum; ++i) {
                enabledStatus = true;
                columnKey = table.getColumnKey(i);
                Object obj = ((HashMap)this.tableColLockedMap.get(table)).get(table.getColumnKey(i));
                if (obj == null) continue;
                enabledStatus = (Boolean)((HashMap)this.tableColLockedMap.get(table)).get(table.getColumnKey(i));
                table.getColumn(i).getStyleAttributes().setLocked(enabledStatus);
            }
        }
        this.hasInitTableColEnabledStatus = false;
    }

    public void registerRequireColumns(String[] cols) {
        String[][] newRequiredCols = new String[cols.length][2];
        for (String newRequiredCols[i][0] : cols) {
        }
        this.registerRequireColumns(newRequiredCols);
    }

    public void registerRequireColumns(String[][] cols) {
        this.RequiredCols = cols;
    }

    public void checkEntryRquiredColumns() {
        if (this.RequiredCols != null && this.RequiredCols.length > 0) {
            StringBuffer msg = new StringBuffer();
            LinkedHashMap alertMap = new LinkedHashMap();
            ArrayList<String> alertCols = null;
            int alertCount = 0;
            boolean isFirstCol = true;
            int firstAlertRow = 0;
            int firstAlertCol = 0;
            KDTable table = this.scmBillEditUI.getDetailTable();
            IRow row = null;
            Method validMethod = null;
            boolean invalid = false;
            int num = table.getRowCount();
            for (int i = 0; i < num; ++i) {
                row = table.getRow(i);
                alertCols = new ArrayList<String>();
                for (int j = 0; j < this.RequiredCols.length; ++j) {
                    invalid = false;
                    if (this.RequiredCols[j].length == 1 || StringUtils.isEmpty((String)this.RequiredCols[j][1])) {
                        if (row.getCell(this.RequiredCols[j][0]).getValue() == null) {
                            invalid = true;
                        }
                    } else {
                        try {
                            validMethod = SCMClientUtils.findMethod(this.scmBillEditUI, this.RequiredCols[j][1], new Class[]{Integer.TYPE});
                            if (validMethod != null && !((Boolean)validMethod.invoke((Object)this.scmBillEditUI, Integer.valueOf("" + i))).booleanValue()) {
                                invalid = true;
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                    if (!invalid) continue;
                    if (isFirstCol) {
                        firstAlertRow = i;
                        firstAlertCol = j;
                        isFirstCol = false;
                    }
                    alertCols.add(this.RequiredCols[j][0]);
                    if (++alertCount == 5) break;
                }
                if (alertCols.size() > 0) {
                    alertMap.put(String.valueOf(i + 1), alertCols);
                }
                if (alertCount == 5) break;
            }
            Iterator iter = alertMap.keySet().iterator();
            String symbol = ResourceUtils.getMessage("com.kingdee.eas.scm.common.SCMResource", "SCMResource103");
            while (iter.hasNext()) {
                String rowNum = (String)iter.next();
                msg.append(ResourceUtils.getMessage("com.kingdee.eas.scm.common.SCMResource", "SCMResource101", new String[]{rowNum}));
                ArrayList cols = (ArrayList)alertMap.get(rowNum);
                if (cols.size() > 0) {
                    msg.append(table.getHeadRow(0).getCell((String)cols.get(0)).getValue().toString());
                    int num2 = cols.size();
                    for (int i = 1; i < num2; ++i) {
                        msg.append(symbol).append(table.getHeadRow(0).getCell((String)cols.get(i)).getValue().toString());
                    }
                }
                msg.append(symbol);
            }
            String message = msg.toString();
            if (message.endsWith(symbol)) {
                message = message.substring(0, message.length() - 1);
            }
            message = ResourceUtils.getMessage("com.kingdee.eas.scm.common.SCMResource", "SCMResource_99", new String[]{message});
            if (alertCount > 0) {
                String colName = this.RequiredCols[firstAlertCol][0];
                int firstTableCol = table.getColumnIndex(colName);
                table.getEditManager().editCellAt(firstAlertRow, firstTableCol);
                MsgBox.showInfo((String)message.toString());
                SysUtil.abort();
            }
        }
    }

    public void registerFilterUIDateCompare(KDDatePicker startDate, KDDatePicker endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.currentEndDate = endDate.getTimestamp();
        this.currentStartDate = startDate.getTimestamp();
        if (this.startDateDataChangeListener != null) {
            startDate.removeDataChangeListener(this.startDateDataChangeListener);
        }
        this.startDateDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    SCMClientHelper.this.compareStartDateValue(eventObj);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
            }
        };
        startDate.addDataChangeListener(this.startDateDataChangeListener);
        if (this.endDateDataChangeListener != null) {
            endDate.removeDataChangeListener(this.endDateDataChangeListener);
        }
        this.endDateDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    SCMClientHelper.this.compareEndDateValue(eventObj);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
            }
        };
        endDate.addDataChangeListener(this.endDateDataChangeListener);
    }

    private void compareStartDateValue(DataChangeEvent eventObj) {
        Date startTempDate = new Date(this.startDate.getTimestamp().getYear(), this.startDate.getTimestamp().getMonth(), this.startDate.getTimestamp().getDate());
        Date endTempDate = new Date(this.endDate.getTimestamp().getYear(), this.endDate.getTimestamp().getMonth(), this.endDate.getTimestamp().getDate());
        if (endTempDate.before(startTempDate)) {
            MsgBox.showInfo((Component)this.currentUI, (String)SCMClientUtils.getResource("CompareDate"));
            this.startDate.setValue((Object)this.currentStartDate);
            this.startDate.requestFocus();
            SysUtil.abort();
        } else {
            this.currentStartDate = this.startDate.getTimestamp();
            this.currentEndDate = this.endDate.getTimestamp();
        }
    }

    private void compareEndDateValue(DataChangeEvent e) throws Exception {
        Date startTempDate = new Date(this.startDate.getTimestamp().getYear(), this.startDate.getTimestamp().getMonth(), this.startDate.getTimestamp().getDate());
        Date endTempDate = new Date(this.endDate.getTimestamp().getYear(), this.endDate.getTimestamp().getMonth(), this.endDate.getTimestamp().getDate());
        if (endTempDate.before(startTempDate)) {
            MsgBox.showInfo((Component)this.currentUI, (String)SCMClientUtils.getResource("CompareDate"));
            this.endDate.setValue((Object)this.currentEndDate);
            this.endDate.requestFocus();
            SysUtil.abort();
        } else {
            this.currentStartDate = this.startDate.getTimestamp();
            this.currentEndDate = this.endDate.getTimestamp();
        }
    }

    public static void registerTotalColumns(String[] cols) {
        TotalCols = cols;
    }

    public static void fillTotalRow(KDTable kdtEntries) {
    }

    public static void clearTotalRow(KDTable kdtEntries) {
    }

    public static void calRowTotal(KDTable kdtEntries) {
    }

    public static void calColTotal(KDTable kdtEntries, IRow totalRow, int colIndex) {
    }

    public static boolean checkIsTotalLine(IRow row) {
        if (row == null) {
            return false;
        }
        if (row.getCell(COL_SEQ) == null) {
            return false;
        }
        if (row.getCell(COL_SEQ).getValue() == null) {
            return false;
        }
        Object value = row.getCell(COL_SEQ).getUserObject();
        if (value == null) {
            return false;
        }
        return TOTAL.equals(value.toString());
    }

    public static void setEntrySeq(KDTable table) {
        if (table == null || TotalCols == null) {
            return;
        }
        IRow row = null;
        int seq = 1;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getCell(COL_SEQ) == null || SCMClientHelper.checkIsTotalLine(row)) continue;
            row.getCell(COL_SEQ).setValue((Object)new Integer(seq++));
        }
    }

    public static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static IRow addRow(KDTable table) {
        IRow row = null;
        row = table.getRowCount() > 0 && SCMClientHelper.checkIsTotalLine(table.getRow(table.getRowCount() - 1)) ? table.addRow(table.getRowCount() - 1) : table.addRow();
        return row;
    }

    public static IRow copyLine(KDTable tblMain) {
        IRow row = null;
        IRow oldRow = null;
        if (tblMain.getSelectManager().size() > 0) {
            int top = tblMain.getSelectManager().get().getTop();
            oldRow = tblMain.getRow(top);
            if (SCMClientHelper.checkIsTotalLine(oldRow)) {
                return null;
            }
            row = SCMClientHelper.checkIsTotalLine(tblMain.getRow(tblMain.getRowCount() - 1)) ? tblMain.addRow(tblMain.getRowCount() - 1) : tblMain.addRow();
        } else {
            return null;
        }
        int size = tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            if ("id".equalsIgnoreCase(tblMain.getColumn(i).getFieldName())) continue;
            row.getCell(i).setValue(oldRow.getCell(i).getValue());
        }
        return row;
    }

    public static void registerContractNumberF7(PurchaseOrgUnitInfo purchaseOrgUnitInfo, KDTable table, String contractNumberCol) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        KDBizPromptBox bizContractNumberBox = new KDBizPromptBox();
        bizContractNumberBox.setEditFormat("$number$");
        bizContractNumberBox.setDisplayFormat("$number$");
        bizContractNumberBox.setCommitFormat("$number$");
        bizContractNumberBox.setEditable(true);
        bizContractNumberBox.setQueryInfo("com.kingdee.eas.scm.sm.pur.app.F7PurContractQuery");
        table.getColumn(contractNumberCol).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizContractNumberBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        table.getColumn(contractNumberCol).setRenderer((IBasicRender)avr);
        ICellEditor cellEditor = table.getColumn(contractNumberCol).getEditor();
        if (cellEditor != null) {
            KDBizPromptBox contractNumberBox = (KDBizPromptBox)cellEditor.getComponent();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (status != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
            }
            List<String> myOrgUnitRangeList = SCMClientHelper.getMyOrgUnitRangeList();
            HashSet<String> set = new HashSet<String>(myOrgUnitRangeList);
            if (myOrgUnitRangeList.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("purOrgUnit.id", set, CompareType.INCLUDE));
            }
            viewInfo.setFilter(filterInfo);
            contractNumberBox.setEntityViewInfo(viewInfo);
            contractNumberBox.getQueryAgent().resetRuntimeEntityView();
        }
    }

    private static List<String> getMyOrgUnitRangeList() {
        ArrayList<String> myOrgUnitRangeList = null;
        try {
            myOrgUnitRangeList = new ArrayList<String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection selectors = new SelectorItemCollection();
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(10), CompareType.EQUALS));
            view.setFilter(filter);
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("org.id"));
            selectors.add(new SelectorItemInfo("org.number"));
            selectors.add(new SelectorItemInfo("org.name"));
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.permission.app.OrgRangeIncludeSubOrgQuery"));
            exec.setObjectView(view);
            IRowSet rowSet = exec.executeQuery();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String id = rowSet.getString("org.id");
                if (id == null || id.length() <= 0) continue;
                myOrgUnitRangeList.add(id);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return myOrgUnitRangeList;
    }

    public static void addCtrlMenu(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){
            private static final long serialVersionUID = 1L;

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.fm.common.client.FMIsqlUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static void addIndexCheckMenu(CoreUIObject uiObject, KDMenu menu) {
    }

    public static void addBizChainListMenu(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift alt B"){
            private static final long serialVersionUID = 1L;

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.dynbusiness.adv.chain.client.BusinessProcessChainListUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static void addBizChainProcessListMenu(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift alt N"){
            private static final long serialVersionUID = 1L;

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.dynbusiness.adv.chain.client.BusinessProcessorListUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    private class TableBindContent {
        String[][] notNegativeFieldName = null;
        KDTPropertyChangeListener tableListener = null;

        private TableBindContent() {
        }
    }
}

