/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.common.client.AbstractSCMSqlLogPraseUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SCMSqlLogPraseUI
extends AbstractSCMSqlLogPraseUI {
    private static final Logger logger = CoreUIObject.getLogger(SCMSqlLogPraseUI.class);

    @Override
    public void actionPrase_actionPerformed(ActionEvent e) throws Exception {
        String sql = this.txtSql.getText();
        String param = this.txtparam.getText();
        if (StringUtils.isEmpty((String)sql)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"sqlIsNull"));
            return;
        }
        if (StringUtils.isEmpty((String)param)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"paramIsNull"));
            return;
        }
        if (!sql.contains("?")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"paramError"));
            return;
        }
        Pattern pat = Pattern.compile("\\?");
        Matcher matcher = pat.matcher(sql);
        int i = 0;
        while (matcher.find()) {
            ++i;
        }
        if (i != param.split(",").length) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"paramNumError", (Object[])new Object[]{i, param.split(",").length}));
            return;
        }
        String result = this.praseSql(sql, param);
        this.txtResult.setText(result);
        super.actionPrase_actionPerformed(e);
    }

    private String praseSql(String sql, String param) {
        if (param.charAt(0) == '[') {
            param = param.substring(1);
        }
        if (param.charAt(param.length() - 1) == ']') {
            param = param.substring(0, param.length() - 1);
        }
        sql = sql.replace("%s", "^&$");
        sql = sql.replace("?", "%s");
        Object[] paramArr = this.buildParam(param);
        sql = String.format(sql, paramArr);
        sql = sql.replace("^&$", "%s");
        return sql;
    }

    private String[] buildParam(String param) {
        String[] paramArr = param.split(",");
        String paramStr = null;
        SimpleDateFormat df = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        for (int i = 0; i < paramArr.length; ++i) {
            paramStr = paramArr[i].trim();
            try {
                new BigDecimal(paramStr);
                continue;
            }
            catch (Exception exception) {
                try {
                    df.parse(paramStr);
                    paramArr[i] = "to_date('" + paramStr + "')";
                    continue;
                }
                catch (ParseException parseException) {
                    if (paramStr.equals("null")) continue;
                    paramArr[i] = "'" + paramStr + "'";
                }
            }
        }
        return paramArr;
    }
}

