/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.client.PriceParamControlHelper;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.UiHandlingHelper;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;

public class InvUiHandlingHelper
extends UiHandlingHelper {
    private int billType = 0;
    private IActualCostState clearLockActualCostState = new ClearLockActualCostState();
    private IStandardCostState loadBdStandardCostState = new LoadBdStandardCostState();
    private IActualCostState loadBdOrUnLockActualCostState = new LoadBdOrUnLockActualCostState();
    private IActualCostState loadBdAndUnLockActualCostState = new LoadBdAndUnLockActualCostState();
    private BillCostState costComputer;
    private BillCostState presnetState;
    private TransactionTypeInfo tti = null;
    private BillCostState generalState;
    public Map priceParamControlHelperMap = new HashMap();
    private Map priceParamInfoMap = new HashMap();

    private void initCostState() {
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(this.getBillTypeId()) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(this.getBillTypeId()) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(this.getBillTypeId()) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.getBillTypeId())) {
            this.presnetState = new BillCostState(this.loadBdStandardCostState, this.clearLockActualCostState);
            this.generalState = new BillCostState(this.loadBdStandardCostState, this.loadBdAndUnLockActualCostState);
            this.billType = 2;
        } else if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(this.getBillTypeId()) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(this.getBillTypeId()) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(this.getBillTypeId()) || "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.getBillTypeId())) {
            this.presnetState = new BillCostState(this.loadBdStandardCostState, this.loadBdOrUnLockActualCostState);
            this.generalState = new BillCostState(this.loadBdStandardCostState, this.loadBdOrUnLockActualCostState);
            this.billType = 1;
        }
    }

    public InvUiHandlingHelper(OrgType mainOrgType, SCMBillEditUI editUi) {
        super(mainOrgType, editUi);
    }

    public void changeUnitQtyColProps(KDTable detailTable, int row, MaterialInfo materialInfo, MaterialInventoryInfo materialInventoryInfo, SCMFetchData fetchData, boolean isOnload, String[] fieldsUnit, String[][] fieldsQty) throws EASBizException, BOSException {
        this.changeUnitQtyColProps(detailTable, row, materialInfo, materialInventoryInfo, fetchData, isOnload, fieldsUnit, fieldsQty, true);
    }

    @Override
    public void afterMainOrgChanged(String arg0, String arg1, SCMBizDataVO vo) {
        super.afterMainOrgChanged(arg0, arg1, vo);
    }

    public void initPriceParam(int rowIndex) {
        EventListener[] listeners;
        SaleOrgUnitInfo saleOrgUnitInfo = null;
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (row != null && row.getCell("saleOrgUnit") != null) {
            saleOrgUnitInfo = (SaleOrgUnitInfo)row.getCell("saleOrgUnit").getValue();
        }
        if (null == saleOrgUnitInfo) {
            return;
        }
        PriceParamControlHelper priceParamControlHelper = (PriceParamControlHelper)this.priceParamControlHelperMap.get(saleOrgUnitInfo.getId().toString());
        PriceParamInfo priceParamInfo = (PriceParamInfo)this.priceParamInfoMap.get(saleOrgUnitInfo.getId().toString());
        if (null == priceParamInfo) {
            try {
                IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
                priceParamInfo = iPriceParam.getParameter(saleOrgUnitInfo.getId().toString());
                this.priceParamInfoMap.put(saleOrgUnitInfo.getId().toString(), priceParamInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((listeners = this.getDetailTable().getListeners(KDTEditListener.class)).length > 0) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (listeners[i].getClass().getName().indexOf("com.kingdee.eas.scm.common.client.PriceParamControlHelper") <= -1) continue;
                this.getDetailTable().removeKDTEditListener((KDTEditListener)listeners[i]);
            }
        }
        if (priceParamControlHelper == null) {
            priceParamControlHelper = new PriceParamControlHelper(this.editUi, saleOrgUnitInfo.getId().toString(), priceParamInfo);
        }
        this.priceParamControlHelperMap.put(saleOrgUnitInfo.getId().toString(), priceParamControlHelper);
    }

    public boolean checkByLimitPriceParam(int rowIndex, int selectCol) throws Exception {
        BigDecimal comparePrice = ZERO;
        SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)this.getDetailTable().getRow(rowIndex).getCell("saleOrgUnit").getValue();
        if (null == saleOrgUnitInfo) {
            return true;
        }
        PriceParamControlHelper priceParamControlHelper = (PriceParamControlHelper)this.priceParamControlHelperMap.get(saleOrgUnitInfo.getId().toString());
        PriceParamInfo priceParamInfo = (PriceParamInfo)this.priceParamInfoMap.get(saleOrgUnitInfo.getId().toString());
        comparePrice = priceParamInfo == null || !priceParamInfo.isContainTax() ? this.convertNullToZero((BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue()) : this.convertNullToZero((BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getValue());
        BigDecimal priceMin = PricePolicyCache.getInstance().getPriceMin(this.getPriceCondition(rowIndex));
        if (priceMin == null || priceMin.compareTo(ZERO) <= 0) {
            return true;
        }
        return priceParamControlHelper.checkByLimitPriceParam(comparePrice, priceMin);
    }

    private PriceCondition getPriceCondition(int rowIndex) {
        SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)this.getDetailTable().getRow(rowIndex).getCell("saleOrgUnit").getValue();
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIAL).getValue();
        CustomerInfo customerInfo = (CustomerInfo)this.prmtOrderCustomer.getData();
        BigDecimal orderQty = this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue() == null ? ZERO : (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        Date curDate = this.getDate(saleOrgUnitInfo);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        AsstAttrValueInfo assistantAttr = this.getDetailTable().getRow(rowIndex).getCell("assistProperty").getValue() == null ? null : (AsstAttrValueInfo)this.getDetailTable().getRow(rowIndex).getCell("assistProperty").getValue();
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNIT).getValue();
        PriceCondition priceCondition = new PriceCondition();
        priceCondition.setMaterialInfo(materialInfo);
        priceCondition.setCustomerInfo(customerInfo);
        priceCondition.setOrderQty(orderQty);
        priceCondition.setCurDate(curDate);
        if (measureUnitInfo != null) {
            priceCondition.setMeasureUnit(measureUnitInfo.getId().toString());
        }
        priceCondition.setCurrencyInfo(currencyInfo);
        priceCondition.setSaleOrg(saleOrgUnitInfo);
        priceCondition.setAssiProperty(assistantAttr);
        priceCondition.setFetchMode(1);
        return priceCondition;
    }

    private Date getDate(SaleOrgUnitInfo saleOrgUnitInfo) {
        Date result = null;
        Date curDate = Calendar.getInstance().getTime();
        try {
            curDate = SCMBillCommonFacadeFactory.getRemoteInstance().getServerDate();
            ObjectUuidPK pk = new ObjectUuidPK(saleOrgUnitInfo.getId());
            String isUseSysDate = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, "PricePa022");
            boolean isGetPriceBySysDate = Boolean.valueOf(isUseSysDate);
            result = isGetPriceBySysDate ? curDate : (Date)this.pkBizDate.getValue();
        }
        catch (Exception e) {
            result = curDate;
        }
        if (result == null) {
            result = curDate;
        }
        return result;
    }

    protected int getPricePrecision(int rowIndex) {
        return this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
    }

    protected DiscountModeEnum getDiscountType(int rowIndex) {
        return (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell("discountType").getValue();
    }

    protected int getAmountPrecision() {
        if (this.editUi != null && this.editUi.getMetaDataPK().getFullName().startsWith("com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI")) {
            return ((SaleIssueBillEditUI)this.editUi).amtPrecision;
        }
        return 2;
    }

    public BigDecimal convertNullToZero(BigDecimal number) {
        if (null == number) {
            return ZERO;
        }
        return number;
    }

    public void changeUnitQtyColProps(KDTable detailTable, int row, MaterialInfo materialInfo, SCMFetchData fetchData, boolean isOnload, String[] fieldsUnit, String[][] fieldsQty) throws EASBizException, BOSException {
        this.changeUnitQtyColProps(detailTable, row, materialInfo, fetchData, isOnload, fieldsUnit, fieldsQty, true);
    }

    public void changeUnitQtyColProps(KDTable detailTable, int row, MaterialInfo materialInfo, SCMFetchData fetchData, boolean isOnload, String[] fieldsUnit, String[][] fieldsQty, boolean filterUnit) throws EASBizException, BOSException {
        MeasureUnitInfo mu = null;
        MeasureUnitInfo muBase = null;
        MeasureUnitInfo muAssist = null;
        IRow curRow = detailTable.getRow(row);
        int precision = 2;
        if (isOnload) {
            mu = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).getValue();
            muBase = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[1])).getValue();
            muAssist = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).getValue();
        } else {
            if (materialInfo != null && curRow.getCell(fieldsUnit[0]).getValue() == null) {
                mu = materialInfo.getBaseUnit();
                curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).setValue((Object)mu);
            } else {
                mu = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).getValue();
            }
            if (materialInfo != null) {
                muBase = materialInfo.getBaseUnit();
                curRow.getCell(detailTable.getColumnIndex(fieldsUnit[1])).setValue((Object)muBase);
                curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).setValue((Object)materialInfo.getAssistUnit());
                muAssist = materialInfo.getAssistUnit();
            }
        }
        if (filterUnit) {
            this.setMaterialUnitF7(detailTable, row, materialInfo, fieldsUnit[0]);
        }
        if (mu != null) {
            precision = fetchData.getUnitPrecision(materialInfo.getId().toString(), mu.getId().toString());
        }
        SCMClientUtils.changeTableColPrecision(precision, detailTable, fieldsQty[0], row);
        if (muBase != null) {
            precision = fetchData.getUnitPrecision(materialInfo.getId().toString(), muBase.getId().toString());
        }
        SCMClientUtils.changeTableColPrecision(precision, detailTable, fieldsQty[1], row);
        if (muAssist != null) {
            Integer muAssistPrecisionInteger = fetchData.getUnitPrecision(materialInfo.getId().toString(), muAssist.getId().toString());
            precision = muAssistPrecisionInteger != null ? muAssistPrecisionInteger : 2;
            curRow.getCell(detailTable.getColumnIndex(fieldsQty[2][0])).getStyleAttributes().setLocked(false);
        } else {
            curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).setValue(null);
            curRow.getCell(detailTable.getColumnIndex(fieldsQty[2][0])).setValue(null);
            curRow.getCell(detailTable.getColumnIndex(fieldsQty[2][0])).getStyleAttributes().setLocked(true);
        }
        SCMClientUtils.changeTableColPrecision(precision, detailTable, fieldsQty[2], row);
    }

    public void setMaterialUnitF7(KDTable detailTable, int rowIndex, MaterialInfo mi, String unitColName) {
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        this.setMaterialUnitF7(detailTable, rowIndex, mi, unitColName, bizUnitBox);
    }

    protected boolean isPresent(int rowIndex, TransactionTypeInfo ttInfo) {
        if (this.getDetailTable().getCell(rowIndex, this.TB_ISPRESENT) == null) {
            return false;
        }
        Boolean isPresent = (Boolean)this.getDetailTable().getCell(rowIndex, this.TB_ISPRESENT).getValue();
        return isPresent != null && isPresent != false;
    }

    protected boolean isUpdateGeneral(int rowIndex, TransactionTypeInfo ttInfo) {
        if (this.getDetailTable().getCell(rowIndex, this.TB_ISPRESENT) == null) {
            return false;
        }
        Boolean isPresent = (Boolean)this.getDetailTable().getCell(rowIndex, this.TB_ISPRESENT).getValue();
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        if (null != this.getDetailTable().getCell(rowIndex, "invUpdateType")) {
            invUpdateTypeInfo = (InvUpdateTypeInfo)this.getDetailTable().getCell(rowIndex, "invUpdateType").getValue();
        }
        return SCMUtils.isPresentStoreType(invUpdateTypeInfo, this.billType) && isPresent != null && isPresent != false;
    }

    private void switchCostState(int rowIndex, TransactionTypeInfo ttInfo) {
        this.costComputer = this.isPresent(rowIndex, ttInfo) ? this.presnetState : this.generalState;
    }

    public MaterialCompanyInfoInfo getMaterialCompanyInfo(SCMFetchData fetchedData, int rowIndex) throws BOSException {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        MaterialInfo materialInfo = null;
        if (curRow.getCell(this.TB_MATERIAL) == null || !(curRow.getCell(this.TB_MATERIAL).getValue() instanceof MaterialInfo)) {
            return null;
        }
        materialInfo = (MaterialInfo)curRow.getCell(this.TB_MATERIAL).getValue();
        if (fetchedData.getCou() == null || materialInfo == null) {
            return null;
        }
        String materialId = materialInfo.getId().toString();
        return fetchedData.getMaterialCompany(materialId, fetchedData.getCou().getId().toString());
    }

    public void calEntryUnitStandardCostByBd(SCMFetchData fetchedData, int rowIndex) throws EASBizException, BOSException {
        BigDecimal unitStandardCost = this.getUnitStandardCostFromBd(fetchedData, rowIndex);
        this.getDetailTable().getCell(rowIndex, this.TB_UNITSTANDARDCOST).setValue((Object)unitStandardCost);
        if (this.tti == null || this.tti.getBillType() == null) {
            return;
        }
        String billTypeId = this.tti.getBillType().getId().toString();
        if (!("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId))) {
            return;
        }
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getCell(rowIndex, this.TB_MATERIAL).getValue();
        if (fetchedData.getCou() == null || materialInfo == null) {
            return;
        }
        String materialId = materialInfo.getId().toString();
        MaterialCompanyInfoInfo mcInfo = fetchedData.getMaterialCompany(materialId, fetchedData.getCou().getId().toString());
        if (AccountType.STANDARDCOST.equals((Object)mcInfo.getAccountType())) {
            this.getDetailTable().getCell(rowIndex, this.TB_UNITACTUALCOST).setValue((Object)unitStandardCost);
        }
    }

    private BigDecimal getUnitStandardCostFromBd(SCMFetchData fetchedData, int rowIndex) throws EASBizException, BOSException {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(this.TB_MATERIAL).getValue();
        if (fetchedData.getCou() == null || materialInfo == null) {
            return ZERO;
        }
        String materialId = materialInfo.getId().toString();
        MaterialCompanyInfoInfo mcInfo = fetchedData.getMaterialCompany(materialId, fetchedData.getCou().getId().toString());
        BigDecimal baseUnitStandCost = mcInfo == null ? ZERO : mcInfo.getStandardCost();
        MeasureUnitInfo muInfo = (MeasureUnitInfo)curRow.getCell(this.TB_UNIT).getValue();
        return SCMClientUtils.getUnitPrice(muInfo, materialInfo, baseUnitStandCost, fetchedData);
    }

    private BigDecimal getBigDecimalValueOfCell(int rowIndex, String colName) {
        BigDecimal result = ZERO;
        Object value = this.getDetailTable().getCell(rowIndex, colName).getValue();
        if (value != null && StringUtil.isNumber(value.toString())) {
            result = new BigDecimal(value.toString());
        }
        return result;
    }

    public void calEntryStandardCostByUnitCost(int rowIndex, int amtPrecision) {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        BigDecimal unitStandardCost = this.getBigDecimalValueOfCell(rowIndex, this.TB_UNITSTANDARDCOST);
        BigDecimal standardCost = unitStandardCost.multiply(this.getBigDecimalValueOfCell(rowIndex, this.TB_QTY));
        standardCost = standardCost.setScale(amtPrecision, 4);
        curRow.getCell(this.TB_STANDARDCOST).setValue((Object)standardCost);
    }

    public void calEntryUnitActualCostByTotal(int rowIndex) {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(this.TB_MATERIAL).getValue();
        if (null == materialInfo) {
            return;
        }
        BigDecimal actualCost = this.getBigDecimalValueOfCell(rowIndex, this.TB_ACTUALCOST);
        BigDecimal qty = this.getBigDecimalValueOfCell(rowIndex, this.TB_QTY);
        BigDecimal unitActualCost = qty.compareTo(ZERO) == 0 ? ZERO : actualCost.divide(qty, materialInfo.getPricePrecision(), 4);
        curRow.getCell(this.TB_UNITACTUALCOST).setValue((Object)unitActualCost);
    }

    public void calEntryActualCostByUnitCost(int rowIndex, int amtPrecision) {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        BigDecimal unitActualCost = this.getBigDecimalValueOfCell(rowIndex, this.TB_UNITACTUALCOST);
        BigDecimal qty = this.getBigDecimalValueOfCell(rowIndex, this.TB_QTY);
        BigDecimal actualCost = unitActualCost.multiply(qty).setScale(amtPrecision, 4);
        curRow.getCell(this.TB_ACTUALCOST).setValue((Object)actualCost);
    }

    public void calEntryQtyByBaseQty(SCMFetchData fetchedData, int rowIndex) throws EASBizException, BOSException {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        BigDecimal baseQty = this.getBigDecimalValueOfCell(rowIndex, this.TB_BASEQTY);
        MeasureUnitInfo muInfo = (MeasureUnitInfo)curRow.getCell(this.TB_UNIT).getValue();
        MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(this.TB_MATERIAL).getValue();
        BigDecimal unitQty = SCMClientUtils.getUnitQty(muInfo, materialInfo, baseQty, fetchedData);
        curRow.getCell(this.TB_QTY).setValue((Object)unitQty);
    }

    private void calEntry2ActualCostByBd(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        MaterialCompanyInfoInfo mcInfo = this.getMaterialCompanyInfo(fetchedData, rowIndex);
        if (mcInfo != null && AccountType.STANDARDCOST.equals((Object)mcInfo.getAccountType())) {
            if (curRow.getCell(this.TB_UNITACTUALCOST) != null && (curRow.getCell(this.TB_UNITACTUALCOST).getValue() == null || ((BigDecimal)curRow.getCell(this.TB_UNITACTUALCOST).getValue()).compareTo(ZERO) == 0 || curRow.getCell(this.TB_ACTUALCOST).getValue() == null || ((BigDecimal)curRow.getCell(this.TB_ACTUALCOST).getValue()).compareTo(ZERO) == 0)) {
                BigDecimal unitStandardCost = this.getBigDecimalValueOfCell(rowIndex, this.TB_UNITSTANDARDCOST);
                if (unitStandardCost == null || unitStandardCost.compareTo(ZERO) == 0) {
                    unitStandardCost = this.getUnitStandardCostFromBd(fetchedData, rowIndex);
                }
                curRow.getCell(this.TB_UNITACTUALCOST).setValue((Object)unitStandardCost);
            }
            this.calEntryActualCostByUnitCost(rowIndex, amtPrecision);
        } else {
            this.calEntryUnitActualCostByTotal(rowIndex);
        }
    }

    public void calEntriesCost4TransactionChanged(int amtPrecision, TransactionTypeInfo ttInfo, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            this.switchCostState(i, ttInfo);
            this.costComputer.calEntryCost4Init(i, amtPrecision, fetchedData, isIsReversed);
        }
    }

    public void calEntryCost4IsPresentChanged(int rowIndex, int amtPrecision, TransactionTypeInfo ttInfo, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
        this.switchCostState(rowIndex, ttInfo);
        this.costComputer.calEntryCost4Init(rowIndex, amtPrecision, fetchedData, isIsReversed);
    }

    public void calEntryCost4MaterialChanged(int rowIndex, int amtPrecision, TransactionTypeInfo ttInfo, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
        this.switchCostState(rowIndex, ttInfo);
        this.costComputer.calEntryCost4Init(rowIndex, amtPrecision, fetchedData, isIsReversed);
    }

    public void calEntryStdCost4MaterialChanged(int rowIndex, int amtPrecision, TransactionTypeInfo ttInfo, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
        this.switchCostState(rowIndex, ttInfo);
        this.costComputer.calEntryStdCost4Init(rowIndex, amtPrecision, fetchedData, isIsReversed);
    }

    public void calEntryCost4QtyChanged(int rowIndex, int amtPrecision, TransactionTypeInfo ttInfo, SCMFetchData fetchedData) throws EASBizException, BOSException {
        this.switchCostState(rowIndex, ttInfo);
        this.tti = ttInfo;
        this.costComputer.calEntryCost4QtyChanged(rowIndex, amtPrecision, fetchedData);
    }

    public void calEntryCost4UnitChanged(int rowIndex, int amtPrecision, TransactionTypeInfo ttInfo, SCMFetchData fetchedData) throws EASBizException, BOSException {
        this.switchCostState(rowIndex, ttInfo);
        this.costComputer.calEntryCost4UnitChanged(rowIndex, amtPrecision, fetchedData);
    }

    public void lockOrUnLockEntryCostCell4Init(int rowIndex, TransactionTypeInfo ttInfo, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
        this.switchCostState(rowIndex, ttInfo);
        this.costComputer.lockOrUnLockEntryCostCell4Init(rowIndex, fetchedData, isIsReversed);
    }

    public void calEntryActualCostByStadardCost(int rowIndex, SCMFetchData fetchedData) throws BOSException {
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getCell(rowIndex, this.TB_MATERIAL).getValue();
        if (fetchedData.getCou() == null || materialInfo == null) {
            return;
        }
        String materialId = materialInfo.getId().toString();
        MaterialCompanyInfoInfo mcInfo = fetchedData.getMaterialCompany(materialId, fetchedData.getCou().getId().toString());
        IRow row = this.getDetailTable().getRow(rowIndex);
        BigDecimal unitActualCost = this.getBigDecimalValueOfCell(rowIndex, this.TB_UNITACTUALCOST);
        BigDecimal actualCost = this.getBigDecimalValueOfCell(rowIndex, this.TB_ACTUALCOST);
        if (AccountType.STANDARDCOST.equals((Object)mcInfo.getAccountType()) && (unitActualCost.compareTo(ZERO) == 0 || actualCost.compareTo(ZERO) == 0)) {
            Object unitStadardCost = row.getCell(this.TB_UNITSTANDARDCOST).getValue();
            Object stadardCost = row.getCell(this.TB_STANDARDCOST).getValue();
            row.getCell(this.TB_UNITACTUALCOST).setValue(unitStadardCost);
            row.getCell(this.TB_ACTUALCOST).setValue(stadardCost);
        }
    }

    @Override
    public void setBillTypeId(String billTypeId) {
        super.setBillTypeId(billTypeId);
        if (this.billType == 0) {
            this.initCostState();
        }
    }

    @Override
    public boolean isDiscountCanNegative() {
        return "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.getBillTypeId());
    }

    public void changeUnitQtyColProps(KDTable detailTable, int row, MaterialInfo materialInfo, MaterialInventoryInfo materialInventoryInfo, SCMFetchData fetchData, boolean isOnload, String[] fieldsUnit, String[][] fieldsQty, boolean isHandleUnitFilter) throws EASBizException, BOSException {
        MeasureUnitInfo mu = null;
        MeasureUnitInfo muBase = null;
        MeasureUnitInfo muAssist = null;
        IRow curRow = detailTable.getRow(row);
        int precision = 2;
        if (isOnload) {
            mu = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).getValue();
            muBase = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[1])).getValue();
            muAssist = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).getValue();
        } else {
            if (materialInventoryInfo != null && curRow.getCell(fieldsUnit[0]).getValue() == null) {
                mu = materialInventoryInfo.getUnit();
                curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).setValue((Object)mu);
            } else {
                mu = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).getValue();
            }
            muBase = materialInfo.getBaseUnit();
            curRow.getCell(detailTable.getColumnIndex(fieldsUnit[1])).setValue((Object)muBase);
            curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).setValue((Object)materialInfo.getAssistUnit());
            muAssist = materialInfo.getAssistUnit();
        }
        if (isHandleUnitFilter) {
            this.setMaterialUnitF7(detailTable, row, materialInfo, fieldsUnit[0]);
        }
        if (mu != null) {
            precision = fetchData.getUnitPrecision(materialInfo.getId().toString(), mu.getId().toString());
        }
        SCMClientUtils.changeTableColPrecision(precision, detailTable, fieldsQty[0], row);
        if (muBase != null) {
            precision = fetchData.getUnitPrecision(materialInfo.getId().toString(), muBase.getId().toString());
        }
        SCMClientUtils.changeTableColPrecision(precision, detailTable, fieldsQty[1], row);
        if (muAssist != null) {
            Integer muAssistPrecisionInteger = fetchData.getUnitPrecision(materialInfo.getId().toString(), muAssist.getId().toString());
            precision = muAssistPrecisionInteger != null ? muAssistPrecisionInteger : 2;
            curRow.getCell(detailTable.getColumnIndex(fieldsQty[2][0])).getStyleAttributes().setLocked(false);
        } else {
            curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).setValue(null);
            curRow.getCell(detailTable.getColumnIndex(fieldsQty[2][0])).setValue(null);
            curRow.getCell(detailTable.getColumnIndex(fieldsQty[2][0])).getStyleAttributes().setLocked(true);
        }
        SCMClientUtils.changeTableColPrecision(precision, detailTable, fieldsQty[2], row);
    }

    public void setMaterialUnitF7(KDTable detailTable, int rowIndex, MaterialInfo mi, String unitColName, KDBizPromptBox bizUnitBox) {
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        SCMClientUtils.setF7MeasureUnit(bizUnitBox, mi.getId().toString());
        IRow curRow = detailTable.getRow(rowIndex);
        curRow.getCell(unitColName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        curRow.getCell(unitColName).getStyleAttributes().setLocked(false);
    }

    private class BillCostState {
        private IStandardCostState standardCostState;
        private IActualCostState actualCostState;

        public BillCostState(IStandardCostState standardCostState, IActualCostState actualCostState) {
            this.standardCostState = standardCostState;
            this.actualCostState = actualCostState;
        }

        public void calEntryCost4Init(int rowIndex, int amtPrecision, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
            if (this.standardCostState != null) {
                this.standardCostState.calEntry2Cost(rowIndex, amtPrecision, fetchedData);
                this.standardCostState.lock2CostCell(rowIndex);
            }
            if (this.actualCostState != null) {
                this.actualCostState.calEntry2Cost(rowIndex, amtPrecision, fetchedData);
                this.actualCostState.lockOrUnLock2CostCell(rowIndex, fetchedData, isIsReversed);
            }
        }

        public void calEntryStdCost4Init(int rowIndex, int amtPrecision, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
            if (this.standardCostState != null) {
                this.standardCostState.calEntry2Cost(rowIndex, amtPrecision, fetchedData);
                this.standardCostState.lock2CostCell(rowIndex);
            }
            if (this.actualCostState != null) {
                this.actualCostState.lockOrUnLock2CostCell(rowIndex, fetchedData, isIsReversed);
            }
        }

        public void lockOrUnLockEntryCostCell4Init(int rowIndex, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
            if (this.standardCostState != null) {
                this.standardCostState.lock2CostCell(rowIndex);
            }
            if (this.actualCostState != null) {
                this.actualCostState.lockOrUnLock2CostCell(rowIndex, fetchedData, isIsReversed);
            }
        }

        public void calEntryCost4QtyChanged(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            if (this.standardCostState != null) {
                this.standardCostState.calEntry2Cost(rowIndex, amtPrecision, fetchedData);
            }
            InvUiHandlingHelper.this.calEntryActualCostByUnitCost(rowIndex, amtPrecision);
            InvUiHandlingHelper.this.calEntryActualCostByStadardCost(rowIndex, fetchedData);
        }

        public void calEntryCost4UnitChanged(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            if (this.standardCostState != null) {
                this.standardCostState.calEntry2Cost(rowIndex, amtPrecision, fetchedData);
            }
            if (this.actualCostState != null) {
                this.actualCostState.calEntryCostByBdOrTotal(rowIndex, amtPrecision, fetchedData);
            }
            InvUiHandlingHelper.this.calEntryActualCostByStadardCost(rowIndex, fetchedData);
        }
    }

    private class LoadBdAndUnLockActualCostState
    implements IActualCostState {
        private LoadBdAndUnLockActualCostState() {
        }

        @Override
        public void calEntry2Cost(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            InvUiHandlingHelper.this.calEntry2ActualCostByBd(rowIndex, amtPrecision, fetchedData);
        }

        @Override
        public void lockOrUnLock2CostCell(int rowIndex, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
            if (!isIsReversed) {
                SCMClientUtils.lockCells(InvUiHandlingHelper.this.getDetailTable().getRow(rowIndex), new String[]{InvUiHandlingHelper.this.TB_UNITACTUALCOST, InvUiHandlingHelper.this.TB_ACTUALCOST}, false);
            }
        }

        @Override
        public void calEntryCostByBdOrTotal(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            InvUiHandlingHelper.this.calEntryUnitActualCostByTotal(rowIndex);
        }
    }

    private class LoadBdOrUnLockActualCostState
    implements IActualCostState {
        private LoadBdOrUnLockActualCostState() {
        }

        @Override
        public void calEntry2Cost(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            InvUiHandlingHelper.this.calEntry2ActualCostByBd(rowIndex, amtPrecision, fetchedData);
        }

        @Override
        public void lockOrUnLock2CostCell(int rowIndex, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
            MaterialCompanyInfoInfo mcInfo = InvUiHandlingHelper.this.getMaterialCompanyInfo(fetchedData, rowIndex);
            if (mcInfo != null && AccountType.STANDARDCOST.equals((Object)mcInfo.getAccountType())) {
                SCMClientUtils.lockCells(InvUiHandlingHelper.this.getDetailTable().getRow(rowIndex), new String[]{InvUiHandlingHelper.this.TB_UNITACTUALCOST, InvUiHandlingHelper.this.TB_ACTUALCOST}, true);
            } else {
                SCMClientUtils.lockCells(InvUiHandlingHelper.this.getDetailTable().getRow(rowIndex), new String[]{InvUiHandlingHelper.this.TB_UNITACTUALCOST, InvUiHandlingHelper.this.TB_ACTUALCOST}, false);
            }
        }

        @Override
        public void calEntryCostByBdOrTotal(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            InvUiHandlingHelper.this.calEntry2ActualCostByBd(rowIndex, amtPrecision, fetchedData);
        }
    }

    private class ClearLockActualCostState
    implements IActualCostState {
        private ClearLockActualCostState() {
        }

        @Override
        public void calEntry2Cost(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            SCMClientUtils.fillCellsZero(InvUiHandlingHelper.this.getDetailTable().getRow(rowIndex), new String[]{InvUiHandlingHelper.this.TB_UNITACTUALCOST, InvUiHandlingHelper.this.TB_ACTUALCOST});
        }

        @Override
        public void lockOrUnLock2CostCell(int rowIndex, SCMFetchData fetchedData, boolean isIsReversed) throws EASBizException, BOSException {
            SCMClientUtils.lockCells(InvUiHandlingHelper.this.getDetailTable().getRow(rowIndex), new String[]{InvUiHandlingHelper.this.TB_UNITACTUALCOST, InvUiHandlingHelper.this.TB_ACTUALCOST}, true);
        }

        @Override
        public void calEntryCostByBdOrTotal(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
        }
    }

    private static interface IActualCostState {
        public void calEntry2Cost(int var1, int var2, SCMFetchData var3) throws EASBizException, BOSException;

        public void lockOrUnLock2CostCell(int var1, SCMFetchData var2, boolean var3) throws EASBizException, BOSException;

        public void calEntryCostByBdOrTotal(int var1, int var2, SCMFetchData var3) throws EASBizException, BOSException;
    }

    private class LoadBdStandardCostState
    implements IStandardCostState {
        private LoadBdStandardCostState() {
        }

        @Override
        public void calEntry2Cost(int rowIndex, int amtPrecision, SCMFetchData fetchedData) throws EASBizException, BOSException {
            InvUiHandlingHelper.this.calEntryUnitStandardCostByBd(fetchedData, rowIndex);
            InvUiHandlingHelper.this.calEntryStandardCostByUnitCost(rowIndex, amtPrecision);
        }

        @Override
        public void lock2CostCell(int rowIndex) {
            SCMClientUtils.lockCells(InvUiHandlingHelper.this.getDetailTable().getRow(rowIndex), new String[]{InvUiHandlingHelper.this.TB_UNITSTANDARDCOST, InvUiHandlingHelper.this.TB_STANDARDCOST}, true);
        }
    }

    private static interface IStandardCostState {
        public void calEntry2Cost(int var1, int var2, SCMFetchData var3) throws EASBizException, BOSException;

        public void lock2CostCell(int var1);
    }
}

