/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.KDTableUtils;
import com.kingdee.eas.scm.common.client.PriceParamControlHelper;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.UiHandlingHelper;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sd.sale.PriceTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.SupplyModeEnum;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SaleUiHandlingHelper
extends UiHandlingHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.client.helper.SaleUiHandlingHelper");
    private PriceParamInfo priceParamInfo = null;
    private PriceParamControlHelper priceParamControlHelper;
    private Map voMap = new HashMap();
    private Object oldValue = null;
    private ExchangeRateInfo exchangeRateinfo = null;
    private static final String TB_PROSTORAGEORGUNIT = "proStorageOrgUnit";
    private static final String TB_SUPPLYMODE = "supplyMode";
    private boolean isClearPriceSourceColumn = true;
    private Boolean[] canGetPriceForBotp = null;
    protected SCMFetchData fetchData = new SCMFetchData();
    private static final String STATUS_ALERT = "ALERT";

    @Override
    public void afterMainOrgChanged(String arg0, String arg1, SCMBizDataVO vo) {
        super.afterMainOrgChanged(arg0, arg1, vo);
        this.priceParamInfo = vo.getSalePriceParamInfo();
        if (this.EDITCTRLTAB != null && arg1 != null) {
            if (this.priceParamControlHelper != null) {
                this.priceParamControlHelper.unRegisterCtrlTableCol(this.kdtEntries, this.EDITCTRLTAB);
            }
            this.priceParamControlHelper = new PriceParamControlHelper(this.editUi, arg1, this.priceParamInfo);
            this.priceParamControlHelper.registerCtrlTableCol(this.kdtEntries, this.EDITCTRLTAB);
            this.priceParamControlHelper.initUI();
        }
    }

    @Override
    public void calByEntryTaxPriceChange(int rowIndex, int colIndex) {
        super.calByEntryTaxPriceChange(rowIndex, colIndex);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
    }

    @Override
    public boolean isDiscountCanNegative() {
        return true;
    }

    public SaleUiHandlingHelper(OrgType mainOrgType, SCMBillEditUI editUi) {
        super(mainOrgType, editUi);
    }

    @Override
    public void changedByMaterials(int rowIdx, MaterialInfo[] materialInfos, Map dataMap, int changeLevel, EventObject e, boolean allowAddEntry) throws Exception {
        Object getPrice;
        if (materialInfos == null || materialInfos.length == 0) {
            return;
        }
        if (dataMap.get("canGetPriceForBotp") != null) {
            this.canGetPriceForBotp = (Boolean[])dataMap.get("canGetPriceForBotp");
        }
        this.exchangeRateinfo = (ExchangeRateInfo)dataMap.get("exChangeRateInfo");
        if (changeLevel == 4 && this.priceParamInfo != null && !this.priceParamInfo.isStartPriceDiscountM()) {
            return;
        }
        SaleOrderDataVO resultVO = null;
        SaleOrderDataVO vo = this.getVoForGettingServerData(materialInfos, rowIdx, changeLevel, e, dataMap);
        if (changeLevel == 0 || changeLevel == 2) {
            resultVO = SCMGroupFacadeFactory.getRemoteInstance().loadSalesEntryData(vo, changeLevel);
            if (null != resultVO) {
                this.voMap.put("resultVO", resultVO);
            }
            this.handleEntries(rowIdx, materialInfos, changeLevel, dataMap, resultVO, allowAddEntry);
            this.handleMeasureunits(rowIdx, materialInfos, changeLevel, resultVO, dataMap);
            if (changeLevel == 0) {
                this.checkStorageOrgUnitMutilCol(rowIdx, resultVO);
                if (resultVO != null && resultVO.getMmuPrecisions() != null) {
                    dataMap.put("muPrecisionsMap", resultVO.getMmuPrecisions());
                }
            }
        }
        if ((getPrice = dataMap.get("getPrice")) != null && !((Boolean)getPrice).booleanValue()) {
            int idxOfMaterial = 0;
            int rowIndex = rowIdx;
            while (idxOfMaterial < materialInfos.length) {
                boolean isPresent = (Boolean)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISPRESENT).getValue();
                if (!isPresent && materialInfos[idxOfMaterial] != null) {
                    this.handleCaseWhenPriceTOIsNull(rowIndex, changeLevel, materialInfos[idxOfMaterial], resultVO, e);
                }
                ++idxOfMaterial;
                ++rowIndex;
            }
            return;
        }
        this.handlePrice2(rowIdx, materialInfos, changeLevel, vo, resultVO, e);
    }

    private SaleOrderDataVO getVoForGettingServerData(MaterialInfo[] materialInfos, int rowIdx, int changeLevel, EventObject e, Map dataMap) {
        SaleOrderDataVO vo = new SaleOrderDataVO();
        if (this.editData == null || this.editData.getBOSType() == null) {
            return vo;
        }
        vo.setBOSType(this.editData.getBOSType().toString());
        vo.setMainOrgType(this.getMainBizOrgType());
        vo.setMainOrg(this.getMainOrgInfo());
        vo.setCustomerInfo((CustomerInfo)this.prmtOrderCustomer.getData());
        vo.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getValue());
        vo.setMaterialInfos(materialInfos);
        vo.setExchangeRate(this.txtExchangeRate.getBigDecimalValue());
        vo.setBizDate((Date)this.pkBizDate.getValue());
        MeasureUnitInfo[] units = new MeasureUnitInfo[materialInfos.length];
        BigDecimal[] quantities = new BigDecimal[materialInfos.length];
        StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[materialInfos.length];
        AsstAttrValueInfo[] asstAttrValues = new AsstAttrValueInfo[materialInfos.length];
        if (this.prmtCompanyOrgUnit != null && this.prmtCompanyOrgUnit.getValue() != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            CurrencyInfo baseCurrencyInfo = companyOrgUnitInfo.getBaseCurrency();
            vo.setBaseCurrencyInfo(baseCurrencyInfo);
            vo.setCompanyOrgUnitInfo(companyOrgUnitInfo);
        }
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            if (changeLevel != 0 || this.isInventoryAddNew(dataMap)) {
                units[idxOfMaterial] = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getValue();
            }
            storageOrgUnitInfos[idxOfMaterial] = (StorageOrgUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_STORAGEORGUNIT).getValue();
            Object qty = null;
            qty = changeLevel == 2 ? (dataMap.get("curQtyByEditUnitAfter") != null ? (BigDecimal)dataMap.get("curQtyByEditUnitAfter") : ZERO) : (this.kdtEntries.getRow(rowIndex).getCell(this.TB_QTY).getValue() == null ? ZERO : this.kdtEntries.getRow(rowIndex).getCell(this.TB_QTY).getValue());
            quantities[idxOfMaterial] = qty;
            asstAttrValues[idxOfMaterial] = (AsstAttrValueInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getValue();
            ++idxOfMaterial;
            ++rowIndex;
        }
        vo.setMeasureUnitInfos(units);
        if (changeLevel == 2) {
            vo.setOldMeasureUnitInfos(new MeasureUnitInfo[]{(MeasureUnitInfo)((KDTEditEvent)e).getOldValue()});
        }
        vo.setQuantities(quantities);
        vo.setStorageOrgUnitInfos(storageOrgUnitInfos);
        vo.setAsstProperties(asstAttrValues);
        vo.setModifyMaterial(true);
        vo.setMaterialInfos(materialInfos);
        if (this.isInventoryAddNew(dataMap)) {
            vo.setInventoryAdd(true);
        }
        return vo;
    }

    private PriceCondition[] getPriceConditionArray(SaleOrderDataVO vo) throws BOSException {
        PriceCondition[] priceConditionArray = new PriceCondition[vo.getMaterialInfos().length];
        PriceCondition priceCondition = null;
        int conditionSize = 0;
        String bostype = vo.getBOSType();
        boolean isQtyRequirement = false;
        if (bostype == null) {
            isQtyRequirement = false;
        } else if (bostype.equals(SCMConstant.BOSTYPE_QUOTATION)) {
            isQtyRequirement = false;
        } else if (bostype.equals(SCMConstant.BOSTYPE_SALECONTRACT)) {
            isQtyRequirement = false;
        } else if (bostype.equals(SCMConstant.BOSTYPE_SALEORDER)) {
            isQtyRequirement = true;
        } else if (bostype.equals(SCMConstant.BOSTYPE_SALERETURNS)) {
            isQtyRequirement = true;
        }
        int size = vo.getMaterialInfos().length;
        for (int idxOfMaterial = 0; idxOfMaterial < size; ++idxOfMaterial) {
            BigDecimal qty = vo.getQuantities()[idxOfMaterial] != null ? vo.getQuantities()[idxOfMaterial] : ZERO;
            priceCondition = new PriceCondition();
            priceCondition.setCurDate(vo.getBizDate());
            priceCondition.setSaleOrg((SaleOrgUnitInfo)vo.getMainOrg());
            priceCondition.setCustomerInfo(vo.getCustomerInfo());
            priceCondition.setCurrencyInfo(vo.getCurrencyInfo());
            priceCondition.setMaterialInfo(vo.getMaterialInfos()[idxOfMaterial]);
            if (this.txtExchangeRate.getBigDecimalValue() != null) {
                priceCondition.setExchangeRate(this.txtExchangeRate.getBigDecimalValue());
            } else {
                priceCondition.setExchangeRate(null);
            }
            if (vo.getMeasureUnitInfos()[idxOfMaterial] != null) {
                priceCondition.setMeasureUnit(vo.getMeasureUnitInfos()[idxOfMaterial].getId().toString());
            }
            if (vo.getAsstProperties() != null) {
                priceCondition.setAssiProperty(vo.getAsstProperties()[idxOfMaterial]);
            }
            priceCondition.setOrderQty(qty);
            priceCondition.setFetchMode(vo.getCacheMode());
            priceCondition.setQtyRequirement(isQtyRequirement);
            priceConditionArray[idxOfMaterial] = priceCondition;
            ++conditionSize;
        }
        if (conditionSize > 0) {
            return priceConditionArray;
        }
        return null;
    }

    private void handleMaterialSaleInformation(int rowIndex, MaterialInfo materialInfo, SaleOrderDataVO resultVO) throws EASBizException, BOSException {
        MaterialSalesInfo materialSalesInfo = (MaterialSalesInfo)resultVO.getMaterialSalesInfos().get(materialInfo.getId().toString());
        if (materialSalesInfo == null) {
            return;
        }
        if (!(this.isFetchTaxRateFromCustomer() || "C48A423A".equals(resultVO.getBOSType()) && this.kdtEntries.getRow(rowIndex).getCell("materialGroup") != null && this.kdtEntries.getRow(rowIndex).getCell("materialGroup").getValue() != null)) {
            if (materialSalesInfo.getTaxRate() != null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXRATE).setValue((Object)materialSalesInfo.getTaxRate());
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXRATE).setValue((Object)com.kingdee.eas.scm.util.constant.SCMConstant.DefaultTaxRate);
            }
        }
        if ("C48A423A".equals(resultVO.getBOSType()) && this.isBotpBill("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=") && !this.isFetchTaxRateFromCustomer()) {
            if (materialSalesInfo.getTaxRate() != null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXRATE).setValue((Object)materialSalesInfo.getTaxRate());
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXRATE).setValue((Object)com.kingdee.eas.scm.util.constant.SCMConstant.DefaultTaxRate);
            }
        }
        if (this.TB_ISBYSALEORDER != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISBYSALEORDER).setValue((Object)materialSalesInfo.isIsPurBySale());
        }
    }

    public boolean isFetchTaxRateFromCustomer() throws EASBizException, BOSException {
        return this.isSaleParam(null, "SALEBILL001", false);
    }

    public boolean isSaleParam(String companyInfoID, String key, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        String strPurParam = this.getCacheParameter(key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    private void handleWidgetLock(int rowIndex, MaterialInfo materialInfo) {
        int num = this.MATERIALUNITTAB.length;
        for (int i = 0; i < num; ++i) {
            StorageOrgUnitInfo storageOrgUnitInfo;
            if (this.getOprtState().equals(STATUS_ALERT)) continue;
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALPRICE) != null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getStyleAttributes().setLocked(true);
            }
            if ((storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_STORAGEORGUNIT).getValue()) != null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_WAREHOUSE).getStyleAttributes().setLocked(false);
                continue;
            }
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_WAREHOUSE).getStyleAttributes().setLocked(true);
        }
    }

    private void handleEntries(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, Map dataMap, SaleOrderDataVO resultVO, boolean allowAddEntry) throws Exception {
        boolean isFromQuotation = this.isBotpBill("510b6503-0105-1000-e000-9113c0a812fd463ED552");
        MaterialSalesInfo materialSalesInfo = null;
        MaterialInfo materialInfo = null;
        Map materialPlanMap = (Map)dataMap.get("materialPlanMap");
        materialPlanMap = resultVO.getMaterialPlanInfos();
        boolean ismaterialPlanMap = materialPlanMap != null;
        Map mapUseWarehsRelation = (Map)dataMap.get("mapUseWarehsRelation");
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            if (materialInfos[idxOfMaterial] != null) {
                if (isFromQuotation) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_STORAGEORGUNIT).getStyleAttributes().setLocked(false);
                }
                materialInfo = materialInfos[idxOfMaterial];
                if (changeLevel == 0) {
                    this.carryEntryDataFromMaterial(materialInfo, rowIndex);
                    this.handleWidgetLock(rowIndex, materialInfo);
                    this.setEntryAssistProperty(rowIndex, materialInfo, allowAddEntry);
                    SCMClientUtils.changeTableColPrecision(materialInfos[idxOfMaterial].getPricePrecision(), this.kdtEntries, this.PRICEPRECISIONTAB, rowIndex);
                    materialSalesInfo = (MaterialSalesInfo)resultVO.getMaterialSalesInfos().get(materialInfo.getId().toString());
                    this.handleMaterialSaleInformation(rowIndex, materialInfo, resultVO);
                    this.calEntryDeliveryDate(rowIndex, 0, resultVO.getServerDate());
                    if (ismaterialPlanMap) {
                        MaterialPlanInfo matPlanInfo;
                        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_STORAGEORGUNIT).getValue();
                        if (materialInfo != null && storageOrgUnitInfo != null) {
                            matPlanInfo = (MaterialPlanInfo)materialPlanMap.get(materialInfo.getId().toString() + storageOrgUnitInfo.getId().toString());
                            if (!StringUtils.isEmpty((String)this.TB_PROJECTNUM) && !StringUtils.isEmpty((String)this.TB_TRACKNUM)) {
                                SCMClientUtils.setProjectTrackEditable(this.kdtEntries, false, true, rowIndex, matPlanInfo, this.TB_PROJECTNUM, this.TB_TRACKNUM);
                            }
                            Map materialPlanMapCache = (Map)dataMap.get("materialPlanMap");
                            if (matPlanInfo != null && materialPlanMapCache != null && !materialPlanMapCache.containsKey(materialInfo.getId().toString() + storageOrgUnitInfo.getId().toString())) {
                                materialPlanMapCache.put(materialInfo.getId().toString() + storageOrgUnitInfo.getId().toString(), matPlanInfo);
                            }
                            if (matPlanInfo != null && this.TB_ISMRPCAL != null && matPlanInfo.getStatus() == UsedStatusEnum.APPROVED && matPlanInfo.getManufactureStrategy() != null && (matPlanInfo.getManufactureStrategy().getId().toString().equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAYfaBzUrmLgQKjAYj0f3dg0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("NUnM+gEcEADgAA3gwKgL09g0uEU="))) {
                                SupplyModeEnum supplyMode;
                                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).setValue((Object)true);
                                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).getStyleAttributes().setLocked(false);
                                SupplyModeEnum supplyModeEnum = supplyMode = this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLYMODE) != null && this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLYMODE).getValue() != null ? (SupplyModeEnum)this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLYMODE).getValue() : null;
                                if (supplyMode != null && supplyMode.getValue() != 0) {
                                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).setValue((Object)false);
                                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).getStyleAttributes().setLocked(true);
                                }
                            } else if (this.TB_ISMRPCAL != null) {
                                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).setValue((Object)false);
                                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).getStyleAttributes().setLocked(true);
                            }
                        } else {
                            matPlanInfo = null;
                            SCMClientUtils.setProjectTrackEditable(this.kdtEntries, false, true, rowIndex, matPlanInfo, this.TB_PROJECTNUM, this.TB_TRACKNUM);
                            if (this.TB_ISMRPCAL != null) {
                                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).setValue((Object)false);
                                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISMRPCAL).getStyleAttributes().setLocked(true);
                            }
                        }
                        boolean isUseWarehsRelation = false;
                        if (storageOrgUnitInfo != null) {
                            isUseWarehsRelation = this.getHsUseWarehsRelation(mapUseWarehsRelation, storageOrgUnitInfo.getId().toString());
                            if (isUseWarehsRelation) {
                                InvClientUtils.setWarehouseFitlerByMSRelation((StorageOrgUnitInfo)storageOrgUnitInfo, (MaterialInfo)materialInfo, (KDTable)this.kdtEntries, (int)rowIndex, (String)this.TB_WAREHOUSE, (int)-1);
                            } else {
                                InvClientUtils.setWarehouseFitler((StorageOrgUnitInfo)storageOrgUnitInfo, (KDTable)this.kdtEntries, (int)rowIndex, (String)this.TB_WAREHOUSE, (int)-1);
                            }
                        }
                    }
                    if (this.editData.getBaseStatus() == null || this.editData.getBaseStatus().getValue() == 0 || this.editData.getBaseStatus().getValue() == 1 || this.editData.getBaseStatus().getValue() == 2) {
                        this.entryQtyUnCtrl(rowIndex, KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_QUANTITYUNCTRL), materialSalesInfo);
                        this.entryTimeUnCtrl(rowIndex, KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_TIMEUNCTRL), materialSalesInfo);
                    }
                }
            }
            ++idxOfMaterial;
            ++rowIndex;
        }
    }

    private List storePriceInCacheAndGetPriceFrom(SaleOrderDataVO resultVO) {
        List list = PricePolicyCache.getInstance().putInCache(resultVO);
        if (list == null) {
            return null;
        }
        return list;
    }

    private SalePriceTO getPriceTOBy2(int rowIndex, int idxOfMaterial, List priceList) {
        if (priceList == null) {
            return null;
        }
        return (SalePriceTO)priceList.get(0);
    }

    private SalePriceTO getPriceTOBy(int changeLevel, int rowIndex, int idxOfMaterial, List priceList) {
        IPriceProvider iPriceProvider = null;
        try {
            iPriceProvider = PriceProviderFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        SalePriceTO priceTO = null;
        if (changeLevel <= 4) {
            BigDecimal qtyTo;
            priceTO = (SalePriceTO)priceList.get(idxOfMaterial);
            BigDecimal qty = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_QTY).getValue();
            qty = qty == null ? ZERO : qty;
            BigDecimal qtyFrom = priceTO != null ? priceTO.qtyFrom : null;
            BigDecimal bigDecimal = qtyTo = priceTO != null ? priceTO.qtyTo : null;
            if (qtyFrom != null && qtyFrom.compareTo(qty) > 0 || qtyTo != null && qtyTo.compareTo(qty) < 0) {
                priceTO = null;
            }
            if (priceTO == null) {
                PriceCondition condition = this.getPriceCondition(rowIndex);
                condition.setPriceType("basePrice");
                try {
                    List basePrice = iPriceProvider.fetchPrices(condition);
                    if (null != basePrice && basePrice.size() > 0) {
                        priceTO = (SalePriceTO)basePrice.get(0);
                    }
                }
                catch (PricePolicyException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        return priceTO;
    }

    private void handleCaseWhenPriceTOIsNull(int rowIndex, int changeLevel, MaterialInfo materialInfo, SaleOrderDataVO resultVO, EventObject e) {
        try {
            IRow row = this.kdtEntries.getRow(rowIndex);
            if (changeLevel == 0 && row.getCell(this.TB_DISCOUNT) != null) {
                row.getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
                row.getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
            }
            if (row.getCell(this.TB_DISCOUNTTYPE) != null) {
                row.getCell(this.TB_DISCOUNTTYPE).getStyleAttributes().setLocked(false);
            }
            if (!(changeLevel != 0 || row.getCell(this.TB_TAXAMOUNT) == null || "C48A423A".equals(resultVO.getBOSType()) && this.kdtEntries.getRow(rowIndex).getCell("materialGroup") != null && this.kdtEntries.getRow(rowIndex).getCell("materialGroup").getValue() != null)) {
                row.getCell(this.TB_PRICE).setValue(null);
                row.getCell(this.TB_TAXPRICE).setValue(null);
                row.getCell(this.TB_TAXAMOUNT).setValue(null);
                this.calEntryPriceChange(rowIndex, 0);
                this.calPriceRelatedCols(rowIndex);
            }
            if (changeLevel == 0) {
                this.calTotalAmount();
                this.calTotalTax();
                this.calTotalTaxAmount();
            }
            if (changeLevel == 2) {
                this.entryUnitChange(rowIndex, materialInfo, (MeasureUnitInfo)((KDTEditEvent)e).getOldValue(), (MeasureUnitInfo)row.getCell(this.TB_UNIT).getValue(), resultVO, false, false);
            }
        }
        catch (Exception ex) {
            this.editUi.handUIException(ex);
        }
    }

    public void handSalePrice(int rowIndex, MaterialInfo materialInfo, int changeLevel) throws EASBizException, BOSException {
        SaleOrderDataVO resultVO = null;
        if (this.voMap.size() > 0) {
            resultVO = (SaleOrderDataVO)this.voMap.get("resultVO");
        }
        MaterialSalesInfo materialSalesInfo = null;
        if (null != resultVO && null != resultVO.getMaterialSalesInfos()) {
            materialSalesInfo = (MaterialSalesInfo)resultVO.getMaterialSalesInfos().get(materialInfo.getId().toString());
        }
        if (materialSalesInfo == null) {
            return;
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
        CurrencyInfo baseCurrencyInfo = companyOrgUnitInfo.getBaseCurrency();
        baseCurrencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()));
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        if (materialSalesInfo.getPrice() != null && materialSalesInfo.getPrice().compareTo(ZERO) > 0) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue(null);
            BigDecimal price = materialSalesInfo.getPrice();
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getValue();
            if (unitInfo != null && !unitInfo.getId().toString().equals(materialSalesInfo.getUnit().getId().toString())) {
                price = SCMUtils.getExchangePriceForClient(materialInfo.getId().toString(), materialSalesInfo.getUnit(), unitInfo, price);
            }
            if (resultVO.getCurrencyInfo() != null && baseCurrencyInfo != null && resultVO.getCurrencyInfo().getId().toString().equals(baseCurrencyInfo.getId().toString())) {
                if (this.priceParamInfo != null && this.priceParamInfo.isContainTax()) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)price);
                    this.calEntryTaxPriceChange(rowIndex, 0);
                } else {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)price);
                    this.calEntryPriceChange(rowIndex, 0);
                }
            } else if (changeLevel == 0 && this.priceParamInfo != null && this.priceParamInfo.isCurrencyConvert() || changeLevel != 0) {
                if (this.priceParamInfo != null && this.priceParamInfo.isContainTax()) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)price);
                    SCMClientUtils.calPriceByCurrencyChange(companyOrgUnitInfo, currencyInfo, baseCurrencyInfo, this.kdtEntries, this.TB_TAXPRICE, rowIndex);
                    this.calEntryTaxPriceChange(rowIndex, 0);
                } else {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)price);
                    SCMClientUtils.calPriceByCurrencyChange(companyOrgUnitInfo, currencyInfo, baseCurrencyInfo, this.kdtEntries, this.TB_PRICE, rowIndex);
                    this.calEntryPriceChange(rowIndex, 0);
                }
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)ZERO);
                this.calEntryTaxPriceChange(rowIndex, 0);
            }
        }
        this.calPriceRelatedCols(rowIndex);
    }

    public BigDecimal transitionCurrency(BigDecimal price, int precision, CurrencyInfo baseCurrencyInfo, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        if (price == null || baseCurrencyInfo == null || currencyInfo == null) {
            return null;
        }
        BigDecimal desPrice = ZERO;
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
        ObjectUuidPK targetpk = new ObjectUuidPK(baseCurrencyInfo.getId().toString());
        ObjectUuidPK sourcepk = new ObjectUuidPK(currencyInfo.getId().toString());
        ExchangeRateInfo tempexrateinfo = SCMClientUtils.getExchangeRate(companyOrgUnitInfo, (IObjectPK)sourcepk, (IObjectPK)targetpk);
        BigDecimal rate = tempexrateinfo.getConvertRate();
        if (rate == null) {
            return null;
        }
        int convertMode = this.editData.getInt("convertMode");
        desPrice = convertMode == 0 ? price.multiply(rate) : price.divide(rate, precision, 4);
        return desPrice;
    }

    private void handlePriceTO_discountType_and_discountValue(SalePriceTO priceTO, int rowIndex) {
        if (priceTO.priceType != null && priceTO.priceType.equals("pricePolicy")) {
            if (priceTO.discountMode == null || priceTO.discountMode == -1) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).setValue((Object)DiscountModeEnum.PERCENT);
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).setValue((Object)DiscountModeEnum.getEnum((int)priceTO.discountMode));
            }
            if (priceTO.discountValue == null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)priceTO.discountValue);
            }
            this.setDiscountPrecision(rowIndex);
        }
        if (priceTO.priceType != null && (priceTO.priceType.equals("basePrice") || priceTO.priceType.equals("materialSaleInfo"))) {
            if (priceTO.discountValue == null || priceTO.discountValue.compareTo(ZERO) <= 0) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
            }
            this.setDiscountPrecision(rowIndex);
            DiscountModeEnum discountModeEnum = (DiscountModeEnum)this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
            BigDecimal discount = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
            BigDecimal bigDecimal = discount = discount == null ? ZERO : discount;
            if (discountModeEnum.compareTo((Object)DiscountModeEnum.PERUNIT) == 0 && priceTO.price != null && priceTO.price.compareTo(discount) < 0) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)ZERO);
            }
        }
    }

    private void handlePriceTO_priceCondition(SalePriceTO priceTO, int rowIndex) {
        ICell cell = this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTCOND);
        if (cell == null) {
            return;
        }
        if (priceTO.discountCondition == null || priceTO.discountCondition == -1) {
            cell.setValue(null);
        } else {
            cell.setValue((Object)DiscountConditionEnum.getEnum((int)priceTO.discountCondition));
        }
    }

    private void handleCaseWhenPriceTOisNotNull(int rowIndex, int changeLevel, SaleOrderDataVO resultVO, SalePriceTO priceTO) {
        BigDecimal basePrice = priceTO.price;
        if (basePrice == null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue(null);
            return;
        }
        String bostype = resultVO.getBOSType();
        if (bostype != null && !bostype.equals(new SaleReturnsInfo().getBOSType().toString())) {
            this.handlePriceTO_discountType_and_discountValue(priceTO, rowIndex);
        }
        this.handlePriceAndTaxPrice(this.priceParamInfo, rowIndex, basePrice);
        this.handlePriceTO_priceCondition(priceTO, rowIndex);
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
        }
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getStyleAttributes().setLocked(false);
        }
        if (changeLevel == 0) {
            this.calTotalAmount();
            this.calTotalTax();
            this.calTotalTaxAmount();
        } else {
            this.calPriceRelatedCols(rowIndex);
        }
    }

    public void handlePrice2(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, SaleOrderDataVO vo, SaleOrderDataVO resultVO, EventObject e) throws EASBizException, BOSException {
        List[] priceArray = null;
        SalePriceTO priceTO = null;
        if (resultVO != null) {
            priceArray = resultVO.getPriceArray();
        } else {
            resultVO = (SaleOrderDataVO)this.voMap.get("resultVO");
            if (resultVO == null) {
                resultVO = new SaleOrderDataVO();
            }
            PriceCondition[] priceConditionArray = this.getPriceConditionArray(vo);
            if (changeLevel == 5) {
                String priceParam;
                SaleOrgUnitInfo info = (SaleOrgUnitInfo)this.getMainOrgInfo();
                if (info != null && "true".equals(priceParam = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)"PricePa001"))) {
                    priceArray = PricePolicyCache.getInstance().getPrices(priceConditionArray);
                }
            } else {
                priceArray = PricePolicyCache.getInstance().getPrices(priceConditionArray);
            }
        }
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            boolean isPresent = (Boolean)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISPRESENT).getValue();
            if (!isPresent && materialInfos[idxOfMaterial] != null && (this.canGetPriceForBotp == null || this.canGetPriceForBotp.length <= 0 || this.canGetPriceForBotp[idxOfMaterial] == null || this.canGetPriceForBotp[idxOfMaterial].booleanValue())) {
                List priceList = null;
                if (priceArray == null || priceArray.length <= 0) {
                    this.handleCaseWhenPriceTOIsNull(rowIndex, changeLevel, materialInfos[idxOfMaterial], resultVO, e);
                    this.handlePriceSourceColumn(rowIndex, null);
                } else {
                    priceList = priceArray[idxOfMaterial];
                    priceTO = this.getPriceTOBy2(rowIndex, idxOfMaterial, priceList);
                    resultVO.setBOSType(this.editData != null && this.editData.getBOSType() != null ? this.editData.getBOSType().toString() : "");
                    if (priceTO == null) {
                        this.handleCaseWhenPriceTOIsNull(rowIndex, changeLevel, materialInfos[idxOfMaterial], resultVO, e);
                        this.handlePriceSourceColumn(rowIndex, null);
                    } else {
                        this.handleCaseWhenPriceTOisNotNull(rowIndex, changeLevel, resultVO, priceTO);
                        this.handlePriceSourceColumn(rowIndex, priceTO);
                    }
                }
            }
            ++idxOfMaterial;
            ++rowIndex;
        }
    }

    private void handlePriceSourceColumn(int rowIndex, SalePriceTO priceTO) {
        if (priceTO == null) {
            if (this.getIsClearPriceSourceColumn()) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCETYPE).setValue((Object)PriceTypeEnum.NULL);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEID).setValue(null);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCENUMBER).setValue(null);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEENTRYID).setValue(null);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_SOURCEPRICE).setValue(null);
            }
            return;
        }
        if ("pricePolicy".equals(priceTO.priceType)) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCETYPE).setValue((Object)PriceTypeEnum.PRICEPOLICY);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEID).setValue((Object)priceTO.priceHeadId);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCENUMBER).setValue((Object)priceTO.priceNumber);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEENTRYID).setValue((Object)priceTO.priceId);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_SOURCEPRICE).setValue((Object)priceTO.price);
        }
        if ("basePrice".equals(priceTO.priceType)) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCETYPE).setValue((Object)PriceTypeEnum.BASEPRICE);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEID).setValue((Object)priceTO.priceId);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCENUMBER).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEENTRYID).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_SOURCEPRICE).setValue((Object)priceTO.price);
        }
        if ("materialSaleInfo".equals(priceTO.priceType)) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCETYPE).setValue((Object)PriceTypeEnum.SALEPRICE);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEID).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCENUMBER).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICESOURCEENTRYID).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_SOURCEPRICE).setValue((Object)priceTO.price);
        }
    }

    @Override
    public void handlePrice(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, SaleOrderDataVO resultVO, EventObject e) throws EASBizException, BOSException {
        IPriceProvider iPriceProvider = PriceProviderFactory.getRemoteInstance();
        List priceList = null;
        SalePriceTO priceTO = null;
        if (resultVO != null && (priceList = PricePolicyCache.getInstance().putInCache(resultVO)) == null) {
            return;
        }
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            boolean isPresent = (Boolean)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISPRESENT).getValue();
            if (!isPresent && materialInfos[idxOfMaterial] != null) {
                priceTO = this.getPriceTOBy(changeLevel, rowIndex, idxOfMaterial, priceList);
                if (priceTO != null && (priceTO.priceComposition == 5 || priceTO.priceComposition == 6) && priceTO.discountValue.compareTo(ZERO) != 0 && priceTO.price.compareTo(ZERO) == 0) {
                    SalePriceTO basePriceTO;
                    PriceCondition condition = this.getPriceCondition(rowIndex);
                    condition.setPriceType("basePrice");
                    List basePrice = iPriceProvider.fetchPrices(condition);
                    if (basePrice != null && basePrice.size() > 0 && (basePriceTO = (SalePriceTO)basePrice.get(0)) != null) {
                        priceTO.price = basePriceTO.price;
                    }
                }
                if (priceTO == null) {
                    this.handleCaseWhenPriceTOIsNull(rowIndex, changeLevel, materialInfos[idxOfMaterial], resultVO, e);
                } else {
                    this.handleCaseWhenPriceTOisNotNull(rowIndex, changeLevel, resultVO, priceTO);
                }
            }
            ++idxOfMaterial;
            ++rowIndex;
        }
    }

    private void handlePriceAndTaxPrice(PriceParamInfo priceParamInfo, int rowIndex, BigDecimal price) {
        if (price == null || price != null && price.compareTo(ZERO) < 0 || priceParamInfo == null) {
            return;
        }
        int scale = this.getPresicionFromTableCell(this.TB_TAXPRICE, rowIndex);
        price = price.setScale(scale, 4);
        if (priceParamInfo.isContainTax()) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)price);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)price);
        }
        this.calEntryPriceChange4PricePolicy(priceParamInfo, rowIndex, 0);
    }

    private void calPriceRelatedCols(int rowIndex) {
        this.calEntryUnOrderQty(rowIndex, 0);
        this.calEntryPrepayment(rowIndex, 0);
        this.calEntryUnPreReceived(rowIndex, 0);
    }

    private void checkStorageOrgUnitMutilCol(int rowIdx, SaleOrderDataVO resultVO) {
        boolean isNotMaintertain = false;
        ArrayList<Integer> errors = new ArrayList<Integer>();
        if (resultVO.getMaterialInventoryInfos() != null) {
            int count = resultVO.getMaterialInfos().length + rowIdx;
            for (int rowIndex = rowIdx; rowIndex < count; ++rowIndex) {
                StorageOrgUnitInfo storageOrgUnitInfo;
                MaterialInfo materialInfo;
                if (this.kdtEntries.getCell(rowIndex, this.TB_MATERIAL) == null || (materialInfo = (MaterialInfo)this.kdtEntries.getCell(rowIndex, this.TB_MATERIAL).getValue()) == null || (storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_STORAGEORGUNIT).getValue()) == null) continue;
                MaterialInventoryInfo info = (MaterialInventoryInfo)resultVO.getMaterialInventoryInfos().get(materialInfo.getId().toString() + storageOrgUnitInfo.getId().toString());
                boolean bl = isNotMaintertain = info == null || info.getStatus().getValue() != 1;
                if (!isNotMaintertain) continue;
                errors.add(new Integer(rowIndex));
            }
        }
        if (errors.size() > 0) {
            StringBuilder msg = new StringBuilder(256);
            int row = 0;
            for (int i = 0; i < errors.size(); ++i) {
                SupplyModeEnum supplyMode;
                row = (Integer)errors.get(i);
                this.kdtEntries.getRow(row).getCell(this.TB_STORAGEORGUNIT).setValue(null);
                SupplyModeEnum supplyModeEnum = supplyMode = this.kdtEntries.getRow(row).getCell(TB_SUPPLYMODE) != null && this.kdtEntries.getRow(row).getCell(TB_SUPPLYMODE).getValue() != null ? (SupplyModeEnum)this.kdtEntries.getRow(row).getCell(TB_SUPPLYMODE).getValue() : null;
                if ((supplyMode == null || supplyMode.getValue() == 0) && this.kdtEntries.getRow(row).getCell(TB_PROSTORAGEORGUNIT) != null) {
                    this.kdtEntries.getRow(row).getCell(TB_PROSTORAGEORGUNIT).setValue(null);
                }
                if (this.TB_ISMRPCAL != null) {
                    this.kdtEntries.getRow(row).getCell(this.TB_ISMRPCAL).setValue((Object)false);
                    this.kdtEntries.getRow(row).getCell(this.TB_ISMRPCAL).getStyleAttributes().setLocked(true);
                }
                if (i < errors.size() - 1) {
                    msg.append(ResourceUtils.getMessage("com.kingdee.eas.scm.sm.pur.PurUIResource", "ORDERENTRYS_STORAGEORGNOTINMATERIAL", new String[]{String.valueOf(row + 1)}) + "\r\n");
                    continue;
                }
                msg.append(ResourceUtils.getMessage("com.kingdee.eas.scm.sm.pur.PurUIResource", "ORDERENTRYS_STORAGEORGNOTINMATERIAL", new String[]{String.valueOf(row + 1)}));
            }
            MsgBox.showInfo((String)msg.toString());
        }
    }

    private void handleUnitLock(int rowIndex, MaterialInfo materialInfo, int changeLevel) {
        if (changeLevel != 0 || this.getOprtState().equals(STATUS_ALERT)) {
            return;
        }
        int num = this.MATERIALUNITTAB.length;
        for (int i = 0; i < num; ++i) {
            if (materialInfo == null || !this.MATERIALUNITTAB[i].equalsIgnoreCase(this.TB_UNIT)) {
                this.kdtEntries.getRow(rowIndex).getCell(this.MATERIALUNITTAB[i]).getStyleAttributes().setLocked(true);
                continue;
            }
            this.kdtEntries.getRow(rowIndex).getCell(this.MATERIALUNITTAB[i]).getStyleAttributes().setLocked(false);
        }
    }

    private void handleUnitValue(int rowIndex, MeasureUnitInfo[] units, int changeLevel, Map dataMap) {
        MeasureUnitInfo baseUnitInfo = units[0];
        MeasureUnitInfo unitInfo = units[1];
        MeasureUnitInfo assistUnitInfo = units[2];
        if (changeLevel == 0) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_BASEUNIT).setValue((Object)baseUnitInfo);
            if (assistUnitInfo != null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTUNIT).setValue((Object)assistUnitInfo);
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTUNIT).setValue(null);
            }
        }
        if (!this.isInventoryAddNew(dataMap)) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).setValue((Object)unitInfo);
        }
    }

    private boolean isInventoryAddNew(Map dataMap) {
        boolean isInventoryAddLine = false;
        if (dataMap != null && dataMap.get("isInventoryAddLine") != null && dataMap.get("isInventoryAddLine").toString().equals("isInventoryAddLine")) {
            isInventoryAddLine = true;
        }
        return isInventoryAddLine;
    }

    private void handleQtyWidgetLock(int rowIndex, MeasureUnitInfo[] units, int changeLevel) {
        MeasureUnitInfo assistUnitInfo = units[2];
        if (changeLevel != 0) {
            return;
        }
        if (assistUnitInfo != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTQTY).getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTQTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTQTY).setValue(null);
        }
    }

    private void handleQtyWidgetPrecision(int rowIndex, MeasureUnitInfo[] units, MaterialInfo materialInfo, SaleOrderDataVO resultVO, int changeLevel) {
        MeasureUnitInfo baseUnitInfo = units[0];
        MeasureUnitInfo unitInfo = units[1];
        MeasureUnitInfo assistUnitInfo = units[2];
        if (changeLevel == 0) {
            SCMClientUtils.changeTableColPrecision(resultVO.getMmuPrecisions(), materialInfo, baseUnitInfo, this.kdtEntries, this.QTYPRECISIONFROMBASEUNITTAB, rowIndex);
            SCMClientUtils.changeTableColPrecision(resultVO.getMmuPrecisions(), materialInfo, assistUnitInfo, this.kdtEntries, this.QTYPRECISIONFROMASSISTUNITTAB, rowIndex);
        }
        SCMClientUtils.changeTableColPrecision(resultVO.getMmuPrecisions(), materialInfo, unitInfo, this.kdtEntries, this.QTYPRECISIONFROMUNITTAB, rowIndex);
    }

    private void handleMeasureunits(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, SaleOrderDataVO resultVO, Map dataMap) throws EASBizException, BOSException {
        MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[3];
        MaterialInfo materialInfo = null;
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            materialInfo = materialInfos[idxOfMaterial];
            if (resultVO.getBaseMeasureUnitInfos() != null) {
                unitInfos[0] = resultVO.getBaseMeasureUnitInfos()[idxOfMaterial];
            }
            if (resultVO.getMeasureUnitInfos() != null) {
                unitInfos[1] = resultVO.getMeasureUnitInfos()[idxOfMaterial];
            }
            if (resultVO.getAssistMeasureUnitInfos() != null) {
                unitInfos[2] = resultVO.getAssistMeasureUnitInfos()[idxOfMaterial];
            }
            this.handleUnitLock(rowIndex, materialInfos[idxOfMaterial], changeLevel);
            this.handleUnitValue(rowIndex, unitInfos, changeLevel, dataMap);
            this.handleQtyWidgetLock(rowIndex, unitInfos, changeLevel);
            BigDecimal qty = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getValue();
            BigDecimal baseQty = ZERO;
            if (this.getDetailTable().getCell(rowIndex, this.TB_BASEQTY).getValue() != null) {
                baseQty = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_BASEQTY).getValue();
            }
            this.handleQtyWidgetPrecision(rowIndex, unitInfos, materialInfo, resultVO, changeLevel);
            if (changeLevel == 2 && baseQty != null && baseQty.compareTo(ZERO) > 0) {
                if (materialInfo != null && (dataMap.get("curUnitOldValue") instanceof MeasureUnitInfo || dataMap.get("curUnitOldValue") == null)) {
                    MeasureUnitInfo curBaseUnitValue = (MeasureUnitInfo)this.getDetailTable().getCell(rowIndex, this.TB_BASEUNIT).getValue();
                    qty = SCMClientUtils.getBaseUnitQtyFromData(unitInfos[1], curBaseUnitValue, materialInfo, baseQty);
                    int qtyScale = this.getPresicionFromTableCell(this.TB_QTY, rowIndex);
                    this.getDetailTable().getCell(rowIndex, this.TB_QTY).setValue((Object)qty.setScale(qtyScale, 4));
                }
            } else {
                this.calEntryBaseQty(rowIndex, 0);
                if (!this.isInventoryAddNew(dataMap) && this.getDetailTable().getCell(rowIndex, this.TB_ASSISTUNIT).getValue() != null) {
                    this.calEntryAssistQty(rowIndex, 0);
                }
            }
            ++idxOfMaterial;
            ++rowIndex;
        }
    }

    private void carryEntryDataFromMaterial(MaterialInfo materialInfo, int rowIndex) {
        if (materialInfo != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIALNAME).setValue((Object)materialInfo.getName());
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIALSIZE).setValue((Object)materialInfo.getModel());
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIALNAME).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIALSIZE).setValue(null);
        }
    }

    @Override
    public void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo, boolean allowAddEntry) throws EASBizException, BOSException {
        if (this.TB_ASSISTPROPERTY == null) {
            return;
        }
        ICell cell = this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY);
        if (materialInfo == null || materialInfo.getAssistAttr() == null) {
            cell.setValue(null);
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setBackground(Color.WHITE);
        } else {
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            this.kdtEntries.getColumn(this.TB_ASSISTPROPERTY).setRenderer((IBasicRender)avr);
            cell.getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            boolean isAssistPropertyNotNecess = this.isPurParamPUR("SALEORDER100", false);
            if (isAssistPropertyNotNecess) {
                cell.getStyleAttributes().setLocked(false);
                cell.getStyleAttributes().setBackground(Color.WHITE);
            } else if (!this.isBotpBill() || cell.getValue() == null) {
                cell.getStyleAttributes().setLocked(false);
            }
        }
    }

    private void entryQtyUnCtrl(int rowIndex, Object o, MaterialSalesInfo materialSalesInfo) throws Exception {
        if (o != null && o instanceof Boolean) {
            boolean isUnCtrlQty = (Boolean)o;
            if (rowIndex >= 0) {
                this.kdtEntries.getCell(rowIndex, this.TB_SENDOVERRATE).getStyleAttributes().setLocked(isUnCtrlQty);
                this.kdtEntries.getCell(rowIndex, this.TB_SENDOWINGRATE).getStyleAttributes().setLocked(isUnCtrlQty);
                if (isUnCtrlQty) {
                    this.kdtEntries.getCell(rowIndex, this.TB_SENDOVERRATE).setValue(null);
                    this.kdtEntries.getCell(rowIndex, this.TB_SENDOWINGRATE).setValue(null);
                }
                this.getMaterialSaleInfo(rowIndex, isUnCtrlQty, 0, materialSalesInfo);
            }
        }
        this.setSENDRATEMaxValue(rowIndex);
    }

    private void getMaterialSaleInfo(int rowIndex, boolean isUnCtrl, int ctrlType, MaterialSalesInfo materialSalesInfo) throws Exception {
        if (materialSalesInfo != null) {
            if (!isUnCtrl && ctrlType == 1) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDADVANCEDAY).setValue((Object)BigDecimal.valueOf(materialSalesInfo.getDaydAhead()));
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDDEFERRALDAY).setValue((Object)BigDecimal.valueOf(materialSalesInfo.getDaysDelay()));
            }
            if (!isUnCtrl && ctrlType == 0) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDOVERRATE).setValue((Object)BigDecimal.valueOf(materialSalesInfo.getIssueTopRatio()));
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDOWINGRATE).setValue((Object)BigDecimal.valueOf(materialSalesInfo.getIssueBottomRatio()));
            }
        }
    }

    private void entryTimeUnCtrl(int rowIndex, Object o, MaterialSalesInfo materialSalesInfo) throws Exception {
        if (o != null && o instanceof Boolean) {
            boolean isUnCtrlTime = (Boolean)o;
            if (rowIndex >= 0) {
                this.kdtEntries.getCell(rowIndex, this.TB_SENDADVANCEDAY).getStyleAttributes().setLocked(isUnCtrlTime);
                this.kdtEntries.getCell(rowIndex, this.TB_SENDDEFERRALDAY).getStyleAttributes().setLocked(isUnCtrlTime);
                if (isUnCtrlTime) {
                    this.kdtEntries.getCell(rowIndex, this.TB_SENDADVANCEDAY).setValue(null);
                    this.kdtEntries.getCell(rowIndex, this.TB_SENDDEFERRALDAY).setValue(null);
                }
                this.getMaterialSaleInfo(rowIndex, isUnCtrlTime, 1, materialSalesInfo);
            }
        }
    }

    @Override
    protected boolean checkByLimitPriceParam(int rowIndex, String colName) throws Exception {
        DiscountModeEnum discounMode;
        if (this.EDITCTRLTAB == null) {
            return true;
        }
        BigDecimal price = null;
        int scale = 2;
        if (this.priceParamInfo == null || !this.priceParamInfo.isContainTax()) {
            BigDecimal tPrice;
            BigDecimal qty;
            if (this.cbIsInTax.isSelected()) {
                BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
                BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
                int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
                if (colName.equalsIgnoreCase(this.TB_TAXAMOUNT)) {
                    DiscountModeEnum discounMode2 = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                    BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
                    qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
                    BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
                    scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
                    taxPrice = null;
                    if (qty != null && qty.compareTo(ZERO) > 0) {
                        if (discounMode2 == null || discounMode2.getValue() == 0) {
                            if (discount == null) {
                                discount = ZERO;
                            }
                            discount = ONE.subtract(discount.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4));
                            if (taxAmount != null && qty != null) {
                                taxPrice = taxAmount.divide(qty, 10, 4);
                                taxPrice = discount.compareTo(ZERO) == 0 ? taxPrice : taxPrice.divide(discount, scale, 4);
                            }
                        } else {
                            if (taxAmount != null) {
                                taxPrice = taxAmount.divide(qty, scale, 4);
                            }
                            if (discount != null) {
                                taxPrice = taxPrice == null ? ZERO : taxPrice.add(discount);
                            }
                        }
                    }
                }
                price = CalculateUtils.calPrice(taxPrice, taxRate, scale);
            } else {
                price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
                if (colName.equalsIgnoreCase(this.TB_AMOUNT)) {
                    BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
                    BigDecimal qty2 = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
                    BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
                    scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
                    DiscountModeEnum discounMode3 = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                    if (discounMode3 == null || discounMode3.getValue() == 0) {
                        price = CalculateUtils.calPrice(amount, qty2, discount, scale);
                    }
                }
            }
            discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
            BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
            if (colName.equalsIgnoreCase(this.TB_ACTUALTAXPRICE)) {
                discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                BigDecimal actualTaxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getValue();
                tPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
                int n2 = scale = this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor().getComponent()).getPrecision();
                if (discounMode == null || discounMode.getValue() == 0) {
                    if (actualTaxPrice != null && tPrice != null && tPrice.compareTo(ZERO) > 0) {
                        actualTaxPrice = tPrice.subtract(actualTaxPrice);
                        discount = actualTaxPrice.divide(tPrice, 10, 4);
                        discount = discount.multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED);
                        discount = discount.setScale(scale, 4);
                    }
                } else if (actualTaxPrice != null && tPrice != null) {
                    discount = tPrice.subtract(actualTaxPrice);
                }
            }
            if (colName.equalsIgnoreCase(this.TB_ACTUALPRICE)) {
                discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
                tPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
                int n3 = scale = this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor().getComponent()).getPrecision();
                if (discounMode == null || discounMode.getValue() == 0) {
                    if (actualPrice != null && tPrice != null && tPrice.compareTo(ZERO) > 0) {
                        actualPrice = tPrice.subtract(actualPrice);
                        discount = actualPrice.divide(tPrice, 10, 4);
                        discount = discount.multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED);
                        discount = discount.setScale(scale, 4);
                    }
                } else if (actualPrice != null && tPrice != null) {
                    discount = tPrice.subtract(actualPrice);
                }
            }
            if (colName.equalsIgnoreCase(this.TB_DISCOUNTAMOUNT)) {
                BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
                qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
                scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor().getComponent()).getPrecision();
                discount = discounMode == null || discounMode.getValue() == 0 ? CalculateUtils.calDiscountByPercent(discountAmount, qty, price, scale) : CalculateUtils.calDiscountByPerunit(discountAmount, qty, taxRate, scale, this.cbIsInTax.isSelected());
            }
            price = CalculateUtils.calActualPrice(discounMode, discount, price, taxRate, scale);
        } else {
            BigDecimal tPrice;
            BigDecimal qty;
            BigDecimal discount;
            if (this.cbIsInTax.isSelected()) {
                price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
                if (colName.equalsIgnoreCase(this.TB_TAXAMOUNT)) {
                    discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                    discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
                    qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
                    BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
                    scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
                    BigDecimal taxPrice = null;
                    if (qty != null && qty.compareTo(ZERO) > 0) {
                        if (discounMode == null || discounMode.getValue() == 0) {
                            if (discount == null) {
                                discount = ZERO;
                            }
                            if (discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) == 0) {
                                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(null);
                                taxPrice = taxAmount.divide(qty, scale, 4);
                            } else {
                                discount = ONE.subtract(discount.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4));
                                if (taxAmount != null && qty != null) {
                                    taxPrice = taxAmount.divide(qty, 10, 4);
                                    taxPrice = taxPrice.divide(discount, scale, 4);
                                }
                            }
                        } else {
                            if (taxAmount != null) {
                                taxPrice = taxAmount.divide(qty, scale, 4);
                            }
                            if (discount != null) {
                                taxPrice = taxPrice == null ? ZERO : taxPrice.add(discount);
                            }
                        }
                    }
                    price = taxPrice;
                }
            } else {
                price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
                BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
                scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
                price = CalculateUtils.calTaxPrice(price, taxRate, scale);
                if (colName.equalsIgnoreCase(this.TB_AMOUNT)) {
                    BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
                    qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
                    BigDecimal discount2 = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
                    scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
                    price = CalculateUtils.calPrice(amount, qty, discount2, scale);
                    taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
                    scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
                    price = CalculateUtils.calTaxPrice(price, taxRate, scale);
                }
            }
            discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
            discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
            int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
            if (colName.equalsIgnoreCase(this.TB_DISCOUNTAMOUNT)) {
                BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
                BigDecimal qty3 = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
                int n4 = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor().getComponent()).getPrecision();
                if (discounMode == null || discounMode.getValue() == 0) {
                    discount = CalculateUtils.calDiscountByPercent(discountAmount, qty3, price, scale);
                } else {
                    BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
                    discount = CalculateUtils.calDiscountByPerunit(discountAmount, qty3, taxRate, scale, this.cbIsInTax.isSelected());
                }
            }
            if (colName.equalsIgnoreCase(this.TB_ACTUALTAXPRICE)) {
                discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                BigDecimal actualTaxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getValue();
                tPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
                int n5 = scale = this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor().getComponent()).getPrecision();
                if (discounMode == null || discounMode.getValue() == 0) {
                    if (actualTaxPrice != null && tPrice != null && tPrice.compareTo(ZERO) > 0) {
                        actualTaxPrice = tPrice.subtract(actualTaxPrice);
                        discount = actualTaxPrice.divide(tPrice, 10, 4);
                        discount = discount.multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED);
                        discount = discount.setScale(scale, 4);
                    }
                } else if (actualTaxPrice != null && tPrice != null) {
                    discount = tPrice.subtract(actualTaxPrice);
                }
            }
            if (colName.equalsIgnoreCase(this.TB_ACTUALPRICE)) {
                discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
                BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
                tPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
                int n6 = scale = this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_DISCOUNTAMOUNT).getEditor().getComponent()).getPrecision();
                if (discounMode == null || discounMode.getValue() == 0) {
                    if (actualPrice != null && tPrice != null && tPrice.compareTo(ZERO) > 0) {
                        actualPrice = tPrice.subtract(actualPrice);
                        discount = actualPrice.divide(tPrice, 10, 4);
                        discount = discount.multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED);
                        discount = discount.setScale(scale, 4);
                    }
                } else if (actualPrice != null && tPrice != null) {
                    discount = tPrice.subtract(actualPrice);
                }
            }
            price = CalculateUtils.calActualTaxPrice(discounMode, price, discount, scale);
        }
        BigDecimal priceMin = PricePolicyCache.getInstance().getPriceMin(this.getPriceCondition(rowIndex));
        if (priceMin == null || priceMin.compareTo(ZERO) <= 0) {
            return true;
        }
        return this.priceParamControlHelper.checkByLimitPriceParam(price, priceMin);
    }

    public boolean checkByLimitPriceParam(int rowIndex, SaleOrgUnitInfo saleOrgUnitInfo) throws Exception {
        BigDecimal comparePrice = ZERO;
        if (null == saleOrgUnitInfo) {
            return true;
        }
        PriceParamInfo priceParamInfo = null;
        IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
        priceParamInfo = iPriceParam.getParameter(saleOrgUnitInfo.getId().toString());
        comparePrice = priceParamInfo == null || !priceParamInfo.isContainTax() ? this.convertNullToZero((BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue()) : this.convertNullToZero((BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue());
        BigDecimal priceMin = PricePolicyCache.getInstance().getPriceMin(this.getPriceCondition(rowIndex));
        if (priceMin == null || priceMin.compareTo(ZERO) <= 0) {
            return true;
        }
        return this.priceParamControlHelper.checkByLimitPriceParam(comparePrice, priceMin);
    }

    public BigDecimal convertNullToZero(BigDecimal number) {
        if (null == number) {
            return ZERO;
        }
        return number;
    }

    private PriceCondition getPriceCondition(int rowIndex) {
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIAL).getValue();
        CustomerInfo customerInfo = (CustomerInfo)this.prmtOrderCustomer.getData();
        BigDecimal orderQty = this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue() == null ? ZERO : SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue());
        Date curDate = this.getDate();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        AsstAttrValueInfo assistantAttr = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getValue() == null ? null : (AsstAttrValueInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getValue();
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNIT).getValue();
        PriceCondition priceCondition = new PriceCondition();
        priceCondition.setMaterialInfo(materialInfo);
        priceCondition.setCustomerInfo(customerInfo);
        priceCondition.setOrderQty(orderQty);
        priceCondition.setCurDate(curDate);
        if (measureUnitInfo != null) {
            priceCondition.setMeasureUnit(measureUnitInfo.getId().toString());
        }
        priceCondition.setCurrencyInfo(currencyInfo);
        if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
            priceCondition.setSaleOrg((SaleOrgUnitInfo)this.getMainOrgInfo());
        }
        priceCondition.setAssiProperty(assistantAttr);
        priceCondition.setFetchMode(1);
        return priceCondition;
    }

    private Date getDate() {
        Date result = null;
        Date curDate = Calendar.getInstance().getTime();
        try {
            curDate = SCMBillCommonFacadeFactory.getRemoteInstance().getServerDate();
            ObjectUuidPK pk = new ObjectUuidPK(this.getMainOrgInfo().getId());
            String isUseSysDate = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, "PricePa022");
            boolean isGetPriceBySysDate = Boolean.valueOf(isUseSysDate);
            result = isGetPriceBySysDate ? curDate : (Date)this.pkBizDate.getValue();
        }
        catch (Exception e) {
            result = curDate;
        }
        if (result == null) {
            result = curDate;
        }
        return result;
    }

    @Override
    public void tableChange_Cal(KDTEditEvent e, ExchangeRateInfo exchangeRateinfo) throws Exception {
        if (this.editUi != null && !this.editUi.getMetaDataPK().getFullName().startsWith("com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI") && !this.editUi.getMetaDataPK().getFullName().startsWith("com.kingdee.eas.scm.sd.sale.client.SaleContractEditUI")) {
            super.tableChange_Cal(e, exchangeRateinfo);
            return;
        }
        this.exchangeRateinfo = exchangeRateinfo;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        ICell cell = this.getDetailTable().getRow(rowIndex).getCell(colIndex);
        if (this.TB_QTY != null && this.TB_QTY.equalsIgnoreCase(fieldName)) {
            this.calByEntryQtyChange(rowIndex, colIndex);
            this.dealWithBaseQtyAndBaseUnitWhenNotProduce(rowIndex);
        } else if (this.TB_PRICE != null && this.TB_PRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_PRICE)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryPriceChange(rowIndex, colIndex);
            this.setDiscountPrecision(rowIndex);
        } else if (this.TB_TAXPRICE != null && this.TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_TAXPRICE)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryTaxPriceChange(rowIndex, colIndex);
            this.setDiscountPrecision(rowIndex);
        } else if (this.TB_TAXRATE != null && this.TB_TAXRATE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_TAXRATE)) {
                cell.setValue(e.getOldValue());
                return;
            }
            if (cell.getValue() != null && cell.getValue() instanceof BigDecimal && SCMConstant.BIGDECIMAL_ONEHUNDRED.compareTo((BigDecimal)cell.getValue()) != 1) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryTaxRateChange(rowIndex, colIndex);
        } else if (this.TB_AMOUNT != null && this.TB_AMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_AMOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryAmountChange(rowIndex);
        } else if (this.TB_TAXAMOUNT != null && this.TB_TAXAMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_TAXAMOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryTaxAmountChange(rowIndex, colIndex);
        } else if (this.TB_TAX != null && this.TB_TAX.equalsIgnoreCase(fieldName)) {
            this.calEntryTaxChange(rowIndex);
        } else if (this.TB_DISCOUNTTYPE != null && this.TB_DISCOUNTTYPE.equalsIgnoreCase(fieldName)) {
            this.calEntryDiscountTypeChange(rowIndex, fieldName);
        } else if (this.TB_DISCOUNT != null && this.TB_DISCOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_DISCOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.oldValue = e.getOldValue();
            this.calEntryDiscountTypeChange(rowIndex, fieldName);
        } else if (this.TB_DISCOUNTAMOUNT != null && this.TB_DISCOUNTAMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale) && !this.checkByLimitPriceParam(rowIndex, this.TB_DISCOUNTAMOUNT)) {
                cell.setValue(e.getOldValue());
                return;
            }
            if (this.checkDiscount(rowIndex, 0)) {
                cell.setValue(e.getOldValue());
                return;
            }
            this.calEntryDiscountAmountChange(rowIndex);
        } else if (this.TB_ACTUALPRICE != null && this.TB_ACTUALPRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
                if (!this.checkByLimitPriceParam(rowIndex, this.TB_ACTUALPRICE)) {
                    cell.setValue(e.getOldValue());
                    return;
                }
            } else {
                this.preCheckActualPrice(e);
            }
            this.calEntryActualPriceChange(rowIndex);
        } else if (this.TB_ACTUALTAXPRICE != null && this.TB_ACTUALTAXPRICE.equalsIgnoreCase(fieldName)) {
            if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
                if (!this.checkByLimitPriceParam(rowIndex, this.TB_ACTUALTAXPRICE)) {
                    cell.setValue(e.getOldValue());
                    return;
                }
            } else {
                this.preCheckActualTaxPrice(e);
            }
            this.calEntryActualTaxPriceChange(rowIndex);
        }
    }

    @Override
    public void calByEntryQtyChange(int rowIndex, int colIndex) throws EASBizException, BOSException {
        if (this.cbIsInTax.isSelected()) {
            this.calEntryDiscountAmount(rowIndex, colIndex);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryAmount(rowIndex, colIndex);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryActualPrice(rowIndex, colIndex);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
        } else {
            this.calEntryAmount(rowIndex, colIndex);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryDiscountAmount(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
            this.calEntryActualPrice(rowIndex, colIndex);
        }
    }

    public void calEntryPriceChange(int rowIndex, int colIndex) {
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryTaxPricebyPrice(rowIndex, colIndex);
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryTotalTaxAmount(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
    }

    public void calEntryPriceChange4PricePolicy(PriceParamInfo priceParamInfo, int rowIndex, int colIndex) {
        if (priceParamInfo.isContainTax() && this.cbIsInTax.isSelected()) {
            this.calEntryTaxPriceChange(rowIndex, colIndex);
        } else if (!priceParamInfo.isContainTax() && !this.cbIsInTax.isSelected()) {
            this.calEntryPriceChange(rowIndex, colIndex);
        } else if (priceParamInfo.isContainTax() && !this.cbIsInTax.isSelected()) {
            this.calEntryPriceByTaxPrice(rowIndex, colIndex);
            this.calEntryAmount(rowIndex, colIndex);
            this.calEntryDiscountAmount(rowIndex, colIndex);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
            this.calEntryActualPrice(rowIndex, colIndex);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        } else if (!priceParamInfo.isContainTax() && this.cbIsInTax.isSelected()) {
            this.calEntryTaxPricebyPrice(rowIndex, colIndex);
            this.calEntryDiscountAmount(rowIndex, colIndex);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryAmount(rowIndex, colIndex);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryActualPrice(rowIndex, colIndex);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
        }
    }

    public void calEntryTaxPriceChange(int rowIndex, int colIndex) {
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calEntryTotalTaxAmount(rowIndex, colIndex);
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryPriceByTaxPrice(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
    }

    private void calEntryActualPriceChange(int rowIndex) {
        this.calEntryDiscountByActualPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calEntryAmount(rowIndex, 0);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryTax(rowIndex, 0);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryTotalTaxAmount(rowIndex, 0);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryTaxPrice(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
    }

    private void calEntryDiscountTypeChange(int rowIndex, String fieldName) {
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        discount = SCMUtils.effectualNumeric(discount);
        int scale = this.getDiscountRate();
        discount = discount.setScale(scale, 4);
        if (discounMode == null || discounMode.getValue() == -1 || discounMode.getValue() == 0) {
            if (discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)SCMConstant.BIGDECIMAL_ONEHUNDRED.setScale(scale, 4));
            }
            if (discount.compareTo(ZERO) < 0 && !this.isDiscountCanNegative()) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(this.oldValue);
            }
        } else if (discounMode.getValue() == 1) {
            if (this.cbIsInTax.isSelected()) {
                BigDecimal taxPrice = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_TAXPRICE);
                if ((taxPrice = SCMUtils.effectualNumeric(taxPrice)).compareTo(discount) < 0) {
                    if (this.TB_DISCOUNTTYPE.equals(fieldName)) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(this.oldValue);
                    }
                }
            } else {
                BigDecimal price = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_PRICE);
                if ((price = SCMUtils.effectualNumeric(price)).compareTo(discount) < 0) {
                    if (this.TB_DISCOUNTTYPE.equals(fieldName)) {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                    } else {
                        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(this.oldValue);
                    }
                }
            }
        }
        this.setDiscountAmountMaxValue(rowIndex);
        this.setDiscountPrecision(rowIndex);
        if (this.cbIsInTax.isSelected()) {
            this.calEntryDiscountAmount(rowIndex, 0);
            this.calEntryTotalTaxAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryAmount(rowIndex, 0);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        } else {
            this.calEntryAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryTotalTaxAmount(rowIndex, 0);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryDiscountAmount(rowIndex, 0);
        }
        this.calEntryActualPrice(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
    }

    private void calEntryActualTaxPriceChange(int rowIndex) {
        this.calEntryDiscountByActualTaxPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calEntryTotalTaxAmount(rowIndex, 0);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryTax(rowIndex, 0);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryAmount(rowIndex, 0);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryActualPrice(rowIndex, 0);
    }

    private void calEntryTaxRateChange(int rowIndex, int colIndex) {
        if (this.cbIsInTax.isSelected()) {
            this.calEntryPriceByTaxPrice(rowIndex, colIndex);
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryAmount(rowIndex, colIndex);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryActualPrice(rowIndex, colIndex);
        } else {
            this.calEntryTax(rowIndex, colIndex);
            this.calEntryTaxPrice(rowIndex, colIndex);
            this.calEntryDiscountAmount(rowIndex, colIndex);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryTotalTaxAmount(rowIndex, colIndex);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
        }
    }

    private void calEntryAmountChange(int rowIndex) {
        this.calEntryPriceByAmount(rowIndex, 0);
        this.calEntryTaxPrice(rowIndex, 0);
        this.calEntryDiscountAmount(rowIndex, 0);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryTax(rowIndex, 0);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryTotalTaxAmount(rowIndex, 0);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryActualPrice(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
    }

    private void calEntryTaxAmountChange(int rowIndex, int colIndex) {
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
        this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        this.calEntryTaxPrice(rowIndex, colIndex);
        this.calEntryPriceByTaxPrice(rowIndex, colIndex);
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
    }

    private void calEntryDiscountAmountChange(int rowIndex) {
        this.calEntryDiscountByDiscountAmount(rowIndex, 0);
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        discount = SCMUtils.effectualNumeric(discount);
        int tempscale = this.getDiscountRate();
        if (discounMode == null || discounMode.getValue() == -1 || discounMode.getValue() == 0) {
            if (discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)SCMConstant.BIGDECIMAL_ONEHUNDRED.setScale(tempscale, 4));
            }
        } else if (discounMode.getValue() == 1) {
            if (this.cbIsInTax.isSelected()) {
                BigDecimal taxPrice = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_TAXPRICE);
                if ((taxPrice = SCMUtils.effectualNumeric(taxPrice)).compareTo(discount) < 0) {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                }
            } else {
                BigDecimal price = SCMClientUtils.castToBigDecimalForCell(this.getDetailTable(), rowIndex, this.TB_PRICE);
                if ((price = SCMUtils.effectualNumeric(price)).compareTo(discount) < 0) {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
                }
            }
        }
        this.setDiscountAmountMaxValue(rowIndex);
        this.setDiscountPrecision(rowIndex);
        if (this.cbIsInTax.isSelected()) {
            this.calEntryTaxAmountByDiscountAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryAmount(rowIndex, 0);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
        } else {
            this.calEntryAmount(rowIndex, 0);
            this.calEntryLocalAmount(rowIndex, this.exchangeRateinfo);
            this.calEntryTax(rowIndex, 0);
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            this.calEntryTotalTaxAmount(rowIndex, 0);
            this.calEntryLocalTaxAmount(rowIndex, this.exchangeRateinfo);
        }
        this.calEntryActualPrice(rowIndex, 0);
        this.calEntryActualTaxPrice(rowIndex, 0);
    }

    private void calEntryTaxChange(int rowIndex) {
        int scale;
        int n = scale = this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        if (!this.cbIsInTax.isSelected()) {
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            BigDecimal amount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue());
            BigDecimal tax = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue());
            if (amount != null && tax != null) {
                amount = amount.add(tax);
                amount = amount.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)amount);
            BigDecimal localAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALAMOUNT).getValue();
            BigDecimal localTax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
            if (localAmount != null && localTax != null) {
                localAmount = localAmount.add(localTax);
                localAmount = localAmount.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)localAmount);
        } else {
            this.calEntryLocalTax(rowIndex, this.exchangeRateinfo);
            BigDecimal amount = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue());
            BigDecimal tax = SCMClientUtils.handleSpcialString(this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue());
            if (amount != null && tax != null) {
                amount = amount.subtract(tax);
                amount = amount.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
            BigDecimal localTaxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue();
            BigDecimal localTax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
            if (localTaxAmount != null && localTax != null) {
                localTaxAmount = localTaxAmount.subtract(localTax);
                localTaxAmount = localTaxAmount.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALAMOUNT).setValue((Object)localTaxAmount);
        }
    }

    @Override
    public void calEntryDiscountByDiscountAmount(int rowIndex, int colIndex) {
        DiscountModeEnum discounMode = null;
        discounMode = this.TB_DISCOUNTTYPE == null ? DiscountModeEnum.PERCENT : (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
        if (discountAmount == null) {
            discountAmount = BigDecimal.ZERO;
        }
        BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        int scale = 2;
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor() != null) {
            scale = ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getEditor().getComponent()).getPrecision();
        }
        if (this.cbIsInTax.isSelected()) {
            if (discounMode == null || discounMode.getValue() == 0) {
                BigDecimal discount = CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
            } else {
                BigDecimal discount = CalculateUtils.calDiscountByPerunit(discountAmount, qty, taxRate, scale, this.cbIsInTax.isSelected());
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
            }
        } else if (discounMode == null || discounMode.getValue() == 0) {
            BigDecimal discount = CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)discount);
        } else {
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            BigDecimal tempRate = taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
            BigDecimal discount = null;
            if (qty != null && qty.compareTo(new BigDecimal("0.00")) != 0) {
                discount = discountAmount.divide(qty.multiply(SCMConstant.BIGDECIMAL_ONE.add(tempRate)), scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue(discount);
        }
    }

    private void calEntryUnOrderQty(int rowIndex, int colIndex) {
        ICell cell = this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNORDEREDQTY);
        if (cell == null) {
            return;
        }
        BigDecimal unOrderQty = SysConstant.BIGZERO;
        Object qty = KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_QTY);
        qty = qty == null ? SysConstant.BIGZERO : qty;
        Object orderQty = KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_ORDEREDQTY);
        Object object = orderQty = orderQty == null ? SysConstant.BIGZERO : orderQty;
        if (qty instanceof BigDecimal && orderQty instanceof BigDecimal) {
            unOrderQty = SCMUtils.effectualNumeric((BigDecimal)qty).subtract(SCMUtils.effectualNumeric((BigDecimal)orderQty));
        }
        cell.setValue((Object)unOrderQty);
    }

    public void calEntryPrepayment(int rowIndex, int colIndex) {
        if (this.TB_PREPAYMENTRATE == null) {
            return;
        }
        Object taxAmount = this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
        taxAmount = taxAmount == null ? SysConstant.BIGZERO : taxAmount;
        Object prepaymentRate = this.kdtEntries.getRow(rowIndex).getCell(this.TB_PREPAYMENTRATE).getValue();
        prepaymentRate = prepaymentRate == null ? SysConstant.BIGZERO : prepaymentRate;
        int scale = 2;
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        BigDecimal prePayment = SysConstant.BIGZERO;
        if (taxAmount instanceof BigDecimal && prepaymentRate instanceof BigDecimal) {
            prePayment = CalculateUtils.calPrepayment((BigDecimal)taxAmount, (BigDecimal)prepaymentRate, scale);
        }
        this.kdtEntries.getRow(rowIndex).getCell(this.TB_PREPAYMENT).setValue((Object)prePayment);
    }

    public void calEntryUnPreReceived(int rowIndex, int colIndex) {
        if (this.TB_UNPRERECEIVEDAMOUNT == null) {
            return;
        }
        BigDecimal unPreReceived = SysConstant.BIGZERO;
        Object prePayment = KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_PREPAYMENT);
        prePayment = prePayment == null ? SysConstant.BIGZERO : prePayment;
        Object preReceived = KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_PRERECEIVED);
        Object object = preReceived = preReceived == null ? SysConstant.BIGZERO : preReceived;
        if (prePayment instanceof BigDecimal && preReceived instanceof BigDecimal) {
            unPreReceived = SCMUtils.effectualNumeric((BigDecimal)prePayment).subtract(SCMUtils.effectualNumeric((BigDecimal)preReceived));
        }
        this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNPRERECEIVEDAMOUNT).setValue((Object)unPreReceived);
    }

    private void calEntryDeliveryDate(int rowIndex, int colIndex, Date serverDate) {
        if (this.prmtDeliveryType == null || this.prmtDeliveryType.getValue() == null) {
            return;
        }
        DeliveryTypeInfo deliveryTypeInfo = (DeliveryTypeInfo)this.prmtDeliveryType.getValue();
        if (!"SEND".equalsIgnoreCase(deliveryTypeInfo.getNumber())) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_DELIVERYDATE).setValue(this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDDATE).getValue());
            return;
        }
        Calendar curDate = Calendar.getInstance();
        int leadTime = this.getHeadWidgetValue(this.txtTransLeadTime);
        if (this.isBotpBill("510b6503-0105-1000-e000-9113c0a812fd463ED552")) {
            int deliveryDayCount = this.getCellIntValue("deliveryDateQty", rowIndex);
            curDate.add(5, deliveryDayCount);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_DELIVERYDATE).setValue((Object)curDate.getTime());
            curDate.add(5, -leadTime);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDDATE).setValue((Object)curDate.getTime());
        } else {
            Date deliveryDate = serverDate != null ? serverDate : SCMClientUtils.getServerDate2();
            curDate.setTime(this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDDATE).getValue() == null ? deliveryDate : (Date)this.kdtEntries.getRow(rowIndex).getCell(this.TB_SENDDATE).getValue());
            curDate.add(5, leadTime);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_DELIVERYDATE).setValue((Object)curDate.getTime());
        }
    }

    @Override
    public void calEntryAssistQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        BigDecimal assistUnitQty;
        BigDecimal baseQty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).getValue();
        MaterialInfo material = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIAL).getValue();
        if (material != null && baseQty != null && material.getAssistUnit() != null && (assistUnitQty = InvClientUtils.getConvsAssQty((BigDecimal)baseQty, (BigDecimal)this.fetchData.getUnitbaseConvsRate(material.getId().toString(), material.getAssistUnit().getId().toString()), (int)this.fetchData.getUnitPrecision(material.getId().toString(), material.getAssistUnit().getId().toString()))) != null) {
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).getEditor().getComponent()).getPrecision();
            assistUnitQty = assistUnitQty.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).setValue((Object)assistUnitQty);
        }
    }

    private int getCellIntValue(String fieldName, int rowIndex) {
        Integer value = null;
        value = null != this.kdtEntries.getRow(rowIndex).getCell(fieldName) && null != this.kdtEntries.getRow(rowIndex).getCell(fieldName).getValue() ? new Integer(this.kdtEntries.getRow(rowIndex).getCell(fieldName).getValue().toString()) : new Integer(0);
        return value;
    }

    private int getHeadWidgetValue(KDFormattedTextField txtField) {
        Integer value = null;
        value = txtField.getIntegerValue() == null ? new Integer(0) : txtField.getIntegerValue();
        return value;
    }

    public void entryUnitChange2(int rowIndex, MaterialInfo materialInfo, MeasureUnitInfo curUnitOldValue, MeasureUnitInfo measureUnitInfo, SaleOrderDataVO resultVO, boolean isPrice, boolean isQtyTrans) {
        if (measureUnitInfo != null && materialInfo != null && curUnitOldValue != null) {
            try {
                IRow changeRow = this.getDetailTable().getRow(rowIndex);
                BigDecimal price = null;
                if (changeRow.getCell(this.TB_PRICE).getValue() != null) {
                    price = (BigDecimal)changeRow.getCell(this.TB_PRICE).getValue();
                }
                BigDecimal qty = (BigDecimal)changeRow.getCell(this.TB_QTY).getValue();
                if (curUnitOldValue != null && !curUnitOldValue.equals((Object)measureUnitInfo)) {
                    int qtyScale;
                    int discountScale = this.getDetailTable().getColumn(this.TB_DISCOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getColumn(this.TB_DISCOUNT).getEditor().getComponent()).getPrecision();
                    DiscountModeEnum discounMode = (DiscountModeEnum)changeRow.getCell(this.TB_DISCOUNTTYPE).getValue();
                    BigDecimal discount = ZERO;
                    if (changeRow.getCell(this.TB_DISCOUNT).getValue() != null) {
                        discount = (BigDecimal)changeRow.getCell(this.TB_DISCOUNT).getValue();
                    }
                    if (!isPrice && discounMode != null && discounMode.getValue() == 1) {
                        discount = discount.setScale(discountScale, 4);
                        BigDecimal newDiscount = this.getResultForUnitChanged(materialInfo.getId().toString(), curUnitOldValue, measureUnitInfo, discount, resultVO.getMmuConvsRate());
                        if (newDiscount != null) {
                            newDiscount = newDiscount.setScale(discountScale, 4);
                            changeRow.getCell(this.TB_DISCOUNT).setValue((Object)newDiscount);
                        }
                    }
                    int scale = this.getDetailTable().getColumn(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, this.TB_PRICE).getEditor().getComponent()).getPrecision();
                    int n = qtyScale = this.getDetailTable().getColumn(this.TB_QTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getEditor().getComponent()).getPrecision();
                    if (!isQtyTrans && price != null && !isPrice) {
                        if (this.cbIsInTax.isSelected()) {
                            BigDecimal taxPrice = (BigDecimal)changeRow.getCell(this.TB_TAXPRICE).getValue();
                            BigDecimal baseUnitPrice = this.getResultForUnitChanged(materialInfo.getId().toString(), curUnitOldValue, measureUnitInfo, taxPrice, resultVO.getMmuConvsRate());
                            if (baseUnitPrice != null) {
                                baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                                changeRow.getCell(this.TB_TAXPRICE).setValue((Object)baseUnitPrice);
                            }
                            this.calByEntryTaxPriceChange(rowIndex, 0);
                        } else {
                            BigDecimal baseUnitPrice = this.getResultForUnitChanged(materialInfo.getId().toString(), curUnitOldValue, measureUnitInfo, price, resultVO.getMmuConvsRate());
                            if (baseUnitPrice != null) {
                                baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                                changeRow.getCell(this.TB_PRICE).setValue((Object)baseUnitPrice);
                            }
                            this.calByEntryPriceChange(rowIndex, 0);
                        }
                        isPrice = false;
                    }
                    if (isQtyTrans && qty != null) {
                        qty = qty.setScale(10, 4);
                        BigDecimal newQtyFrom = this.getResultForUnitChanged(materialInfo.getId().toString(), measureUnitInfo, curUnitOldValue, qty, resultVO.getMmuConvsRate());
                        if (newQtyFrom != null) {
                            newQtyFrom = newQtyFrom.setScale(qtyScale, 4);
                            changeRow.getCell(this.TB_QTY).setValue((Object)newQtyFrom);
                        }
                        this.calByEntryQtyChange(rowIndex, 0);
                    }
                }
            }
            catch (Exception ex) {
                this.editUi.handUIException(ex);
            }
        }
    }

    public void entryUnitChange(int rowIndex, MaterialInfo materialInfo, MeasureUnitInfo curUnitOldValue, MeasureUnitInfo measureUnitInfo, SaleOrderDataVO resultVO, boolean isPrice, boolean isQtyTrans) throws EASBizException, BOSException {
        if (measureUnitInfo == null || materialInfo == null || curUnitOldValue == null || curUnitOldValue != null && curUnitOldValue.equals((Object)measureUnitInfo)) {
            return;
        }
        this.calDiscountAmount(rowIndex, isPrice, curUnitOldValue, measureUnitInfo, materialInfo, resultVO);
        this.calPriceAndTaxPrice(rowIndex, isPrice, isQtyTrans, curUnitOldValue, measureUnitInfo, materialInfo, resultVO);
        this.calWhenQtyChange(rowIndex, isQtyTrans, curUnitOldValue, measureUnitInfo, materialInfo, resultVO);
    }

    private void calWhenQtyChange(int rowIndex, boolean isQtyTrans, MeasureUnitInfo curUnitOldValue, MeasureUnitInfo measureUnitInfo, MaterialInfo materialInfo, SaleOrderDataVO resultVO) throws EASBizException, BOSException {
        IRow changeRow = this.getDetailTable().getRow(rowIndex);
        int qtyScale = this.getPresicionFromTableCell(this.TB_QTY, rowIndex);
        BigDecimal qty = (BigDecimal)changeRow.getCell(this.TB_QTY).getValue();
        if (isQtyTrans && qty != null) {
            qty = qty.setScale(10, 4);
            BigDecimal newQtyFrom = this.getResultForUnitChanged(materialInfo.getId().toString(), measureUnitInfo, curUnitOldValue, qty, resultVO.getMmuConvsRate());
            if (newQtyFrom != null) {
                newQtyFrom = newQtyFrom.setScale(qtyScale, 4);
                changeRow.getCell(this.TB_QTY).setValue((Object)newQtyFrom);
            }
            this.calByEntryQtyChange(rowIndex, 0);
        }
    }

    private void calPriceAndTaxPrice(int rowIndex, boolean isPrice, boolean isQtyTrans, MeasureUnitInfo curUnitOldValue, MeasureUnitInfo measureUnitInfo, MaterialInfo materialInfo, SaleOrderDataVO resultVO) throws EASBizException, BOSException {
        IRow changeRow = this.getDetailTable().getRow(rowIndex);
        int scale = this.getPresicionFromTableCell(this.TB_PRICE, rowIndex);
        BigDecimal price = (BigDecimal)changeRow.getCell(this.TB_PRICE).getValue();
        if (isQtyTrans || price == null || isPrice) {
            return;
        }
        BigDecimal qty = (BigDecimal)changeRow.getCell(this.TB_QTY).getValue();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal taxPrice = (BigDecimal)changeRow.getCell(this.TB_TAXPRICE).getValue();
            BigDecimal taxAmount = (BigDecimal)changeRow.getCell(this.TB_TAXAMOUNT).getValue();
            if (qty != null && qty.compareTo(ZERO) > 0 && taxAmount != null) {
                this.calEntryTaxPrice(rowIndex, 0);
            } else {
                BigDecimal baseUnitPrice = this.getResultForUnitChanged(materialInfo.getId().toString(), curUnitOldValue, measureUnitInfo, taxPrice, resultVO.getMmuConvsRate());
                if (baseUnitPrice != null) {
                    baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                    changeRow.getCell(this.TB_TAXPRICE).setValue((Object)baseUnitPrice);
                }
            }
            this.calByEntryTaxPriceChange(rowIndex, 0);
        } else {
            BigDecimal amount = (BigDecimal)changeRow.getCell(this.TB_AMOUNT).getValue();
            if (qty != null && qty.compareTo(ZERO) > 0 && amount != null) {
                this.calEntryPriceByAmount(rowIndex, 0);
            } else {
                BigDecimal baseUnitPrice = this.getResultForUnitChanged(materialInfo.getId().toString(), curUnitOldValue, measureUnitInfo, price, resultVO.getMmuConvsRate());
                if (baseUnitPrice != null) {
                    baseUnitPrice = baseUnitPrice.setScale(scale, 4);
                    changeRow.getCell(this.TB_PRICE).setValue((Object)baseUnitPrice);
                }
            }
            this.calByEntryPriceChange(rowIndex, 0);
        }
    }

    private void calDiscountAmount(int rowIndex, boolean isPrice, MeasureUnitInfo curUnitOldValue, MeasureUnitInfo measureUnitInfo, MaterialInfo materialInfo, SaleOrderDataVO resultVO) throws EASBizException, BOSException {
        int discountScale = this.getPresicionFromTableCell(this.TB_DISCOUNT, rowIndex);
        DiscountModeEnum discounMode = (DiscountModeEnum)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getValue();
        BigDecimal discount = ZERO;
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue() != null) {
            discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        }
        if (!isPrice && discounMode != null && discounMode.getValue() == 1) {
            discount = discount.setScale(discountScale, 4);
            BigDecimal newDiscount = this.getResultForUnitChanged(materialInfo.getId().toString(), curUnitOldValue, measureUnitInfo, discount, resultVO.getMmuConvsRate());
            if (newDiscount != null) {
                newDiscount = newDiscount.setScale(discountScale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).setValue((Object)newDiscount);
            }
        }
    }

    private int getPresicionFromTableCell(String cellName, int rowIndex) {
        int precision = 2;
        if (this.getDetailTable().getColumn(cellName).getEditor() != null && this.getDetailTable().getCell(rowIndex, cellName).getEditor() != null) {
            precision = ((KDFormattedTextField)this.getDetailTable().getCell(rowIndex, cellName).getEditor().getComponent()).getPrecision();
        }
        return precision;
    }

    @Override
    public void setSENDRATEMaxValue(int rowIndex) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(4);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)ZERO);
        colTxtField.setMaximumValue((Comparable)SCMConstant.BIGDECIMAL_ONEHUNDRED);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setDataVerifierType(12);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        String colPrecision = PrecisionUtil.getFormatString(4);
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (row.getCell(this.TB_SENDOVERRATE) == null || row.getCell(this.TB_SENDOVERRATE) == null) {
            return;
        }
        if (this.TB_SENDOVERRATE != null) {
            row.getCell(this.TB_SENDOVERRATE).setEditor((ICellEditor)col_CellEditor);
            row.getCell(this.TB_SENDOVERRATE).getStyleAttributes().setNumberFormat(colPrecision);
            row.getCell(this.TB_SENDOVERRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell(this.TB_SENDOVERRATE).setEditor((ICellEditor)col_CellEditor);
        }
        row.getCell(this.TB_SENDOWINGRATE).setEditor((ICellEditor)col_CellEditor);
        row.getCell(this.TB_SENDOWINGRATE).getStyleAttributes().setNumberFormat(colPrecision);
        row.getCell(this.TB_SENDOWINGRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected SCMEntryDataVO loadComplexData(SCMEntryDataVO inDataVO, boolean hasMaterial) throws EASBizException, BOSException {
        return SCMGroupFacadeFactory.getRemoteInstance().loadSaleComplexData((SaleOrderDataVO)inDataVO);
    }

    @Override
    public SCMEntryDataVO initInLoadFields(SCMEntryDataVO inDataVO) {
        SaleOrderDataVO saleOrderDataVO = (SaleOrderDataVO)super.initInLoadFields(inDataVO);
        try {
            if (saleOrderDataVO != null && saleOrderDataVO.isLoadingSalePrice()) {
                this.handlePriceControlFromBotp(0, saleOrderDataVO.getMaterialInfos(), 0, saleOrderDataVO, null);
            }
        }
        catch (EASBizException e) {
            this.editUi.handUIException(e);
        }
        catch (BOSException e) {
            this.editUi.handUIException(e);
        }
        return saleOrderDataVO;
    }

    @Override
    protected boolean initSCMEntryDataVO(SCMEntryDataVO vo) {
        if (!super.initSCMEntryDataVO(vo)) {
            return false;
        }
        SaleOrderDataVO saleOrderDataVO = (SaleOrderDataVO)vo;
        if (saleOrderDataVO != null && saleOrderDataVO.isLoadingSalePrice()) {
            BigDecimal[] quantities = new BigDecimal[vo.getMaterialInfos().length];
            int idxOfMaterial = 0;
            int rowIndex = 0;
            while (idxOfMaterial < vo.getMaterialInfos().length) {
                quantities[idxOfMaterial] = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_QTY).getValue();
                ++idxOfMaterial;
                ++rowIndex;
            }
            saleOrderDataVO.setQuantities(quantities);
        }
        return true;
    }

    private void handlePriceControlFromBotp(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, SaleOrderDataVO resultVO, EventObject e) throws EASBizException, BOSException {
        if (resultVO == null) {
            return;
        }
        SalePriceTO priceTO = null;
        List priceList = this.storePriceInCacheAndGetPriceFrom(resultVO);
        if (priceList == null) {
            return;
        }
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            boolean isPresent = (Boolean)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISPRESENT).getValue();
            if (!isPresent && materialInfos[idxOfMaterial] != null) {
                priceTO = this.getPriceTOBy(changeLevel, rowIndex, idxOfMaterial, priceList);
                if (priceTO == null) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getStyleAttributes().setLocked(false);
                } else {
                    BigDecimal basePrice = priceTO.price;
                    if (basePrice == null) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue(null);
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue(null);
                        return;
                    }
                    if (priceTO.discountMode != null && priceTO.discountMode != -1) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
                    }
                    this.setDiscountPrecision(rowIndex);
                    if (priceTO.priceType == null) {
                        return;
                    }
                    if (priceTO.priceType.equals("basePrice")) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getStyleAttributes().setLocked(false);
                    }
                    if (priceTO.priceType.equals("pricePolicy")) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(true);
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNTTYPE).getStyleAttributes().setLocked(true);
                    }
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_DISCOUNT).getStyleAttributes().setLocked(false);
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getStyleAttributes().setLocked(false);
                }
            }
            ++idxOfMaterial;
            ++rowIndex;
        }
    }

    public Map getMaterialPlanMap() throws BOSException {
        StringBuffer storageId = new StringBuffer();
        StringBuffer materialId = new StringBuffer();
        HashMap<String, MaterialPlanInfo> materialPlanMap = new HashMap<String, MaterialPlanInfo>();
        String[] storage = new String[this.kdtEntries.getRowCount()];
        MaterialPlanCollection materialPlanCollection = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_STORAGEORGUNIT).getValue();
            if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
                storage[i] = storageOrgUnitInfo.getId().toString();
                storageId.append("'").append(storageOrgUnitInfo.getId().toString()).append("',");
            }
            MaterialInfo materialInfo = null;
            materialInfo = this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue() instanceof MaterialInfo[] ? ((MaterialInfo[])this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue())[0] : (MaterialInfo)this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue();
            if (materialInfo == null || materialInfo.getId() == null) continue;
            materialId.append("'").append(materialInfo.getId().toString()).append("',");
        }
        if (storageId != null && storageId.length() > 0) {
            storageId.setLength(storageId.length() - 1);
        }
        if (materialId != null && materialId.length() > 0) {
            materialId.setLength(materialId.length() - 1);
        }
        IMaterialPlan iMaterialPlan = MaterialPlanFactory.getRemoteInstance();
        if (materialId != null && materialId.length() > 0 && storageId != null && storageId.length() > 0) {
            materialPlanCollection = iMaterialPlan.getMaterialPlanCollection(" select id,material.id,orgUnit.id,manufactureStrategy.id,manufactureStrategy.number,isolatedRule,status  where material.id in ( " + materialId.toString() + " ) and orgUnit.id in ( " + storageId.toString() + ")");
        }
        if (materialPlanCollection != null) {
            for (int i = 0; i < materialPlanCollection.size(); ++i) {
                MaterialPlanInfo info = materialPlanCollection.get(i);
                if (info == null || info.getMaterial() == null || info.getMaterial().getId() == null || info.getOrgUnit() == null || info.getOrgUnit().getId() == null) continue;
                materialPlanMap.put(info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString(), info);
            }
        }
        return materialPlanMap;
    }

    public MaterialPlanInfo getMaterialPlan(Map materialPlanMap, String materialID, String orgUnitID) throws EASBizException, BOSException {
        if (materialPlanMap == null) {
            materialPlanMap = new HashMap<String, MaterialPlanInfo>(0);
        }
        if (!materialPlanMap.containsKey(materialID + orgUnitID) && materialID != null && materialID.length() > 0 && orgUnitID != null && orgUnitID.length() > 0) {
            try {
                materialPlanMap.put(materialID + orgUnitID, MaterialPlanFactory.getRemoteInstance().getMaterialPlanInfo("select manufactureStrategy.id,manufactureStrategy.number,status,isolatedRule,material.id,orgUnit.id where material.id='" + materialID + "' and orgUnit.id='" + orgUnitID + "'"));
            }
            catch (ObjectNotFoundException exc) {
                logger.error((Object)exc);
            }
        }
        return (MaterialPlanInfo)materialPlanMap.get(materialID + orgUnitID);
    }

    public Map getMaterialPlansMap(Set materialIDSet, Set orgUnitIDSet) throws EASBizException, BOSException {
        if (materialIDSet.size() == 0 || orgUnitIDSet.size() == 0) {
            return null;
        }
        HashMap<String, MaterialPlanInfo> materialPlanMap = new HashMap<String, MaterialPlanInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("manufactureStrategy.id"));
        view.getSelector().add(new SelectorItemInfo("manufactureStrategy.number"));
        view.getSelector().add(new SelectorItemInfo("status"));
        view.getSelector().add(new SelectorItemInfo("isolatedRule"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        view.getSelector().add("planningMode");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        MaterialPlanCollection mpColl = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        String materialID = null;
        String orgUnitID = null;
        int size = mpColl.size();
        for (int i = 0; i < size; ++i) {
            materialID = mpColl.get(i).getMaterial().getId().toString();
            orgUnitID = mpColl.get(i).getOrgUnit().getId().toString();
            if (materialID == null || materialID.length() <= 0 || orgUnitID == null || orgUnitID.length() <= 0 || materialPlanMap.containsKey(materialID + orgUnitID)) continue;
            materialPlanMap.put(materialID + orgUnitID, mpColl.get(i));
        }
        return materialPlanMap;
    }

    public boolean getHsUseWarehsRelation(Map hsUseWarehsRelation, String orgUnitID) {
        if (hsUseWarehsRelation == null) {
            hsUseWarehsRelation = new HashMap<String, Boolean>(0);
        }
        if (!hsUseWarehsRelation.containsKey(orgUnitID) && orgUnitID != null && orgUnitID.length() > 0) {
            boolean isUseWarehsRelation = false;
            try {
                isUseWarehsRelation = InvClientUtils.isUseWarehsRelation((String)orgUnitID);
            }
            catch (Exception exc) {
                logger.error((Object)exc);
            }
            hsUseWarehsRelation.put(orgUnitID, isUseWarehsRelation);
        }
        if (hsUseWarehsRelation.containsKey(orgUnitID)) {
            return (Boolean)hsUseWarehsRelation.get(orgUnitID);
        }
        return false;
    }

    public PriceParamInfo getPriceParamInfo() {
        return this.priceParamInfo;
    }

    public boolean getIsClearPriceSourceColumn() {
        return this.isClearPriceSourceColumn;
    }

    public void setClearPriceSourceColumn(boolean isChange) {
        this.isClearPriceSourceColumn = isChange;
    }
}

