/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.scm.common.rptformula.CalGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SCMGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalBatchCalculater
extends SCMBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.CalBatchCalculater");
    private String bizType = " ";
    private String sumfield = "";
    private String[] canNullCapitalProperties = new String[]{"CompanyNumber", "MainBizOrgNumber", "MaterialGroupStdNumber", "MaterialGroupNumber", "MaterialNumber", "WarehouseNumber", "CostObjectNumber", "CostCenterNumber"};
    private String[] canNullPropertiesSplit = new String[]{";", ";", ";", ";", ";", ";", ";", ";"};

    public CalBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block10: {
            CostCenterOrgUnitCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        ctx = this.contextProvider.getServerContext();
                                        ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                                        if (index != 0) break block9;
                                        CompanyOrgUnitCollection ouc2 = SCMReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                                        if (ouc2 == null || ouc2.size() <= 0) break block10;
                                        int n = ouc2.size();
                                        for (int i = 0; i < n; ++i) {
                                            CompanyOrgUnitInfo info = ouc2.get(i);
                                            String number = info.getNumber();
                                            String id = info.getId().toString();
                                            map.put(number, id);
                                        }
                                        break block10;
                                    }
                                    if (index != 1) break block11;
                                    StorageOrgUnitCollection ouc3 = SCMReportBatchUtils.getStorageOrgUnitCollection(ctx, ev);
                                    if (ouc3 == null || ouc3.size() <= 0) break block10;
                                    int n = ouc3.size();
                                    for (int i = 0; i < n; ++i) {
                                        StorageOrgUnitInfo info = ouc3.get(i);
                                        String number = info.getNumber();
                                        String id = info.getId().toString();
                                        map.put(number, id);
                                    }
                                    break block10;
                                }
                                if (index != 2) break block12;
                                MaterialGroupStandardCollection ouc4 = SCMReportBatchUtils.getMaterialGroupStdCollection(ctx, ev);
                                if (ouc4 == null || ouc4.size() <= 0) break block10;
                                int n = ouc4.size();
                                for (int i = 0; i < n; ++i) {
                                    MaterialGroupStandardInfo info = ouc4.get(i);
                                    String number = info.getNumber();
                                    String id = info.getId().toString();
                                    map.put(number, id);
                                }
                                break block10;
                            }
                            if (index != 3) break block13;
                            MaterialGroupCollection ouc5 = SCMReportBatchUtils.getMaterialGroupCollection(ctx, ev);
                            if (ouc5 == null || ouc5.size() <= 0) break block10;
                            int n = ouc5.size();
                            for (int i = 0; i < n; ++i) {
                                MaterialGroupInfo info = ouc5.get(i);
                                String number = info.getNumber();
                                String id = info.getId().toString();
                                map.put(number, id);
                            }
                            break block10;
                        }
                        if (index != 4) break block14;
                        MaterialCollection ouc6 = SCMReportBatchUtils.getMaterialCollection(ctx, ev);
                        if (ouc6 == null || ouc6.size() <= 0) break block10;
                        int n = ouc6.size();
                        for (int i = 0; i < n; ++i) {
                            MaterialInfo info = ouc6.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block10;
                    }
                    if (index != 5) break block15;
                    WarehouseCollection ouc7 = SCMReportBatchUtils.getWarehouseCollection(ctx, ev);
                    if (ouc7 == null || ouc7.size() <= 0) break block10;
                    int n = ouc7.size();
                    for (int i = 0; i < n; ++i) {
                        WarehouseInfo info = ouc7.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block10;
                }
                if (index != 6) break block16;
                CostObjectCollection ouc8 = SCMReportBatchUtils.getCostObjectCollection(ctx, ev);
                if (ouc8 == null || ouc8.size() <= 0) break block10;
                int n = ouc8.size();
                for (int i = 0; i < n; ++i) {
                    CostObjectInfo info = ouc8.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block10;
            }
            if (index == 7 && (ouc = SCMReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    CostCenterOrgUnitInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        int queryIndex = 0;
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        while (queryIndex < querySize) {
            this.params.clear();
            int lastQueryIndex = queryIndex;
            int i = 0;
            while (i < 3000 && queryIndex < querySize) {
                Parameter param = paramArray.getParameter(queryIndex);
                CalGetParamBean formulaParam = new CalGetParamBean(param);
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                this.SetSumField("ENTRY.FAmount");
                String sheetName = param.getSheetName();
                try {
                    SCMReportBatchUtils.reviseInvParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    i += this.addParam(formulaParam);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
                }
                ++queryIndex;
            }
            try {
                this.innerExecute();
            }
            catch (Exception e) {
                logger.error((Object)e);
                for (int i2 = lastQueryIndex; i2 < queryIndex; ++i2) {
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(i2), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String getSql(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" BILL");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" ENTRY on ENTRY.fparentid = BILL.fid ");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" left join T_ORG_Company company on company.fid = ENTRY.FCompanyOrgUnitID");
        sql.append(" left join T_BD_Currency currency on currency.fid = company.FBaseCurrencyID");
        sql.append(" left join T_BD_Material material on material.fid = ENTRY.FMaterialID");
        sql.append(" left join T_BD_MaterialGroup materialGroup on materialGroup.fid = material.FMaterialGroupID ");
        sql.append(" left join T_BD_MaterialGroupStandard materialGroupStd on materialGroupStd.fid = materialGroup.FGroupStandard ");
        sql.append(" where (BILL.FBizDate>=? and BILL.FBizDate<=?) and BILL.FBaseStatus=4 ");
        sql.append(this.getCompanyCondSqlByID(group));
        sql.append(this.getMainOrgCondSqlByID(group));
        sql.append(this.getBizType(group));
        sql.append(this.getMaterialGroupStdCondSqlByID(group));
        sql.append(this.getMaterialGroupCondSqlByID(group));
        sql.append(this.getMaterialCondSqlByID(group));
        sql.append(this.getWarehouseCondSqlByID(group));
        sql.append(this.getCurrencyCondSqlByID(group));
        return sql.toString();
    }

    @Override
    String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" BILL");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" ENTRY on ENTRY.fparentid = BILL.fid ");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" left join T_ORG_Company company on company.fid = ENTRY.FCompanyOrgUnitID");
        sql.append(" left join T_BD_Currency currency on currency.fid = company.FBaseCurrencyID");
        sql.append(" where (BILL.FBizDate>=? and BILL.FBizDate<=?) and BILL.FBaseStatus=4 ");
        sql.append(this.getCompanyCondSqlByID(group));
        sql.append(this.getMainOrgCondSqlByID(group));
        sql.append(this.getBizType(group));
        sql.append(" and ENTRY.FMaterialID in ( ");
        sql.append(" select material.fid from T_BD_Material material ");
        sql.append(" inner join T_BD_MaterialGroupDetial materialGroupDetail on materialGroupDetail.FMaterialid = material.fid ");
        sql.append(" inner join T_BD_MaterialGroupStandard materialGroupStd on materialGroupStd.fid = materialGroupDetail.FMaterialGroupStandardID ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup1 on materialGroup1.fid = materialGroupDetail.FMaterialGroupID ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup on charindex(materialGroup.flongnumber,materialGroup1.flongnumber) = 1 ");
        sql.append(" where 1 = 1 ");
        sql.append(this.getMaterialGroupStdCondSqlByID(group));
        sql.append(this.getMaterialGroupCondSqlByID(group));
        sql.append(" )");
        sql.append(this.getMaterialCondSqlByID(group));
        sql.append(this.getWarehouseCondSqlByID(group));
        return sql.toString();
    }

    private String getBizType(int group) {
        return this.bizType;
    }

    private void setBizType(String bizType) {
        this.bizType = bizType;
    }

    protected String getDetailTableName() {
        return "T_CL_CostAdjustBillEntry";
    }

    protected String getHeadTableName() {
        return "T_CL_CostAdjustBill";
    }

    protected String getMainOrgTableName() {
        return "T_ORG_Storage";
    }

    protected String getMainOrgField() {
        return "BILL.FStorageOrgUnitID";
    }

    protected String getCompanyCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 0)) {
            return " and (ENTRY.FCompanyOrgUnitID = ?)";
        }
        return "";
    }

    protected String getMainOrgCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 1)) {
            return " and (BILL.FStorageOrgUnitID = ?)";
        }
        return "";
    }

    protected String getMaterialGroupStdCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 2)) {
            return " and (materialGroupStd.FID = ?)";
        }
        return "";
    }

    protected String getMaterialGroupStdCondSql(int group) {
        if (CalBatchCalculater.checkBit(group, 5)) {
            return " and (materialGroupStd.FNumber = ?)";
        }
        return "";
    }

    protected String getMaterialGroupCondSql(int group) {
        if (CalBatchCalculater.checkBit(group, 6)) {
            return " and (materialGroup.FNumber = ?)";
        }
        return "";
    }

    protected String getMaterialGroupCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 3)) {
            return " and (materialGroup.fnumber = ?)";
        }
        return "";
    }

    protected String getMaterialCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 4)) {
            return " and (ENTRY.FMaterialID = ?)";
        }
        return "";
    }

    protected String getMaterialCondSql(int group) {
        if (CalBatchCalculater.checkBit(group, 7)) {
            return " and (material.FNumber = ?)";
        }
        return "";
    }

    protected String getWarehouseCondSql(int group) {
        if (CalBatchCalculater.checkBit(group, 8)) {
            return " and (warehouse.FNumber = ?)";
        }
        return "";
    }

    protected String getWarehouseCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 5)) {
            return " and (ENTRY.FWarehouseID = ?)";
        }
        return "";
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return this.canNullCapitalProperties;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return this.canNullPropertiesSplit;
    }

    private void SetSumField(String sumField) {
        this.sumfield = sumField;
    }

    private String getSumField() {
        return this.sumfield;
    }

    @Override
    protected String getReturnField() {
        return "FAmount";
    }

    protected String getCurrencyCondSqlByID(int group) {
        if (CalBatchCalculater.checkBit(group, 9)) {
            return " and (company.FBaseCurrencyID = ?)";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerExecute() throws Exception {
        String sql = null;
        this.groupByParam();
        this.loadNumberIDCacheData();
        int count = this.groupedParams.length;
        for (int i = 0; i < count; ++i) {
            PreparedStatement pstmt = null;
            try {
                ArrayList paramList = this.groupedParams[i];
                if (paramList == null || paramList.size() <= 0) continue;
                List[] lists = this.groupByBizType(paramList);
                for (int k = 0; k < lists.length; ++k) {
                    List newParamList = lists[k];
                    if (newParamList == null || newParamList.size() <= 0) continue;
                    CalGetParamBean formulaParam = (CalGetParamBean)newParamList.get(0);
                    this.setBizType(formulaParam);
                    sql = this.getSqlByID(i);
                    pstmt = this.conn.prepareStatement(sql);
                    int m = newParamList.size();
                    for (int j = 0; j < m; ++j) {
                        ResultSet rs = null;
                        try {
                            SCMGetParamBean paramBean = (SCMGetParamBean)newParamList.get(j);
                            this.setSqlParamsByID(pstmt, paramBean, i);
                            rs = pstmt.executeQuery();
                            BigDecimal value = SCMBatchCalculater.ZERO;
                            while (rs.next()) {
                                BigDecimal tmp = rs.getBigDecimal(this.getReturnField());
                                if (tmp == null) continue;
                                value = value.add(tmp);
                            }
                            paramBean.getBackFiller().setValue((Object)value);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs);
                            throw throwable;
                        }
                        SQLUtils.cleanup((ResultSet)rs);
                    }
                }
                continue;
            }
            finally {
                SQLUtils.cleanup(pstmt);
            }
        }
    }

    private void setBizType(CalGetParamBean formulaParam) {
        if ("0".equals(formulaParam.getBizType())) {
            this.setBizType(" AND BILL.FCalculateKind = 0 ");
        } else if ("1".equals(formulaParam.getBizType())) {
            this.setBizType(" AND BILL.FCalculateKind = 1 ");
        } else {
            this.setBizType(" ");
        }
    }

    private List[] groupByBizType(ArrayList paramList) {
        List[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < paramList.size(); ++i) {
            CalGetParamBean formulaParam = (CalGetParamBean)paramList.get(i);
            if ("0".equals(formulaParam.getBizType())) {
                lists[0].add(formulaParam);
                continue;
            }
            if ("1".equals(formulaParam.getBizType())) {
                lists[1].add(formulaParam);
                continue;
            }
            lists[2].add(formulaParam);
        }
        return lists;
    }

    @Override
    protected void setBizTypeByParam(SCMGetParamBean paramBean) {
        String bizType = (String)this.invokeGetterMethod(paramBean, "BizType");
        if ("0".equals(bizType)) {
            this.setBizType(" AND BILL.FCalculateKind = 0 ");
        } else if ("1".equals(bizType)) {
            this.setBizType(" AND BILL.FCalculateKind = 1 ");
        } else {
            this.setBizType(" ");
        }
    }
}

