/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.scm.common.rptformula.InvBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvMoveIssueParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import java.util.HashMap;
import java.util.Set;

public class MoveIssueBatchCalculater
extends InvBatchCalculater {
    protected String[] canNullCapitalProperties = new String[]{"CompanyNumber", "MainBizOrgNumber", "TransactionTypeNumber", "MaterialGroupStdNumber", "MaterialGroupNumber", "MaterialNumber", "WarehouseNumber", "CostCenterOrgUnitNumber"};
    protected String[] canNullPropertiesSplit = new String[]{";", ";", ";", ";", ";", ";", ";", ";"};

    public MoveIssueBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String getDetailTableName() {
        return "T_IM_MoveIssueBillEntry";
    }

    @Override
    protected String getHeadTableName() {
        return "T_IM_MoveIssueBill";
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return this.canNullCapitalProperties;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return this.canNullPropertiesSplit;
    }

    @Override
    String getSqlByID(int group) {
        return super.getSqlByID(group) + this.getCostCenterCondSqlByID(group);
    }

    @Override
    protected String getCostCenterCondSqlByID(int group) {
        if (MoveIssueBatchCalculater.checkBit(group, 7)) {
            return " and (h.FCostCenterOrgUnitID = ?)";
        }
        return "";
    }

    @Override
    public InvGetParamBean getInvGetParamBean(Parameter param) {
        return new InvMoveIssueParamBean(param);
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        CostCenterOrgUnitCollection ouc;
        super.innerLoadNumberID(index, map, numberSet);
        Context ctx = this.contextProvider.getServerContext();
        EntityViewInfo ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
        if (index == 7 && (ouc = SCMReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev)) != null && ouc.size() > 0) {
            int n = ouc.size();
            for (int i = 0; i < n; ++i) {
                CostCenterOrgUnitInfo info = ouc.get(i);
                String number = info.getNumber();
                String id = info.getId().toString();
                map.put(number, id);
            }
        }
    }
}

