/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodFillParameter;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.FormulaMoverFactoryForOther;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.BizFormulaMover;
import com.kingdee.eas.scm.common.rptformula.CalBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.MaterialReqBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.MoveInBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.MoveIssueBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.OtherInBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.OtherIssueBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PostRequisitionAmountBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PostRequisitionBaseQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PostRequisitionQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.ProductInBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PurContractAmountBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PurContractBaseQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PurOrderAmountBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.PurchaseInBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SCMBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleContractAmountBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleContractBaseQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleContractQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleOrderAmountBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleOrderBaseQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleOrderQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleOutBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleReturnsAmountBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleReturnsBaseQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SaleReturnsQtyBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.purOrderBaseQtyBatchCalculater;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

public class SCMReportBatchCalculatorImpl
implements IMethodBatchQuery,
INeedSheetInfo,
IMethodFillParameter,
ICalculator {
    private static final String _BAD_FUNCTION_ = "#BAD FUNCTION: ";
    private String sheetName = null;
    private ICalculateContextProvider contextProvider = null;

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void initCalculateContext(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public boolean batchQuery(Map methodMap) {
        for (Map.Entry entry : methodMap.entrySet()) {
            String methodName = (String)entry.getKey();
            SortedParameterArray methodParams = (SortedParameterArray)entry.getValue();
            this.batchMethodQuery(this.contextProvider, methodName, methodParams);
        }
        return true;
    }

    public boolean batchMethodQuery(ICalculateContextProvider contextProvider, String methodName, SortedParameterArray methodParams) {
        SCMBatchCalculater batcher = null;
        if (methodName.equalsIgnoreCase("SaleContractQty")) {
            batcher = new SaleContractQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleContractBaseQty")) {
            batcher = new SaleContractBaseQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleContractAmount")) {
            batcher = new SaleContractAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleOrderQty")) {
            batcher = new SaleOrderQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleOrderBaseQty")) {
            batcher = new SaleOrderBaseQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleOrderAmount")) {
            batcher = new SaleOrderAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PostRequisitionQty")) {
            batcher = new PostRequisitionQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PostRequisitionBaseQty")) {
            batcher = new PostRequisitionBaseQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PostRequisitionAmount")) {
            batcher = new PostRequisitionAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleReturnsQty")) {
            batcher = new SaleReturnsQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleReturnsBaseQty")) {
            batcher = new SaleReturnsBaseQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleReturnsAmount")) {
            batcher = new SaleReturnsAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("ProductIn")) {
            batcher = new ProductInBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("OtherIn")) {
            batcher = new OtherInBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("MoveIn")) {
            batcher = new MoveInBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("MaterialReq")) {
            batcher = new MaterialReqBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("OtherIssue")) {
            batcher = new OtherIssueBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("MoveIssue")) {
            batcher = new MoveIssueBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("SaleOut")) {
            batcher = new SaleOutBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PurchaseIn")) {
            batcher = new PurchaseInBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("CostAdjust")) {
            batcher = new CalBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PurOrderBaseQty")) {
            batcher = new purOrderBaseQtyBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PurOrderAmount")) {
            batcher = new PurOrderAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PurContractAmount")) {
            batcher = new PurContractAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("PurContractBaseQty")) {
            batcher = new PurContractBaseQtyBatchCalculater(contextProvider);
        }
        boolean isFound = false;
        if (batcher != null) {
            isFound = true;
            batcher.initResource();
            batcher.execute(methodParams);
            batcher.clearResource();
        } else {
            String value = _BAD_FUNCTION_ + methodName;
            for (int i = 0; i < methodParams.size(); ++i) {
                methodParams.getParameter(i).setValue((Object)value);
            }
        }
        return isFound;
    }

    public boolean getTrendParameters(Map info) {
        String methodName = (String)info.get("Method_Name");
        Object[] methodParameters = (Object[])info.get("Parameters");
        if (methodName != null && methodParameters != null) {
            CellBlock fromCellBlock = (CellBlock)info.get("Block_From");
            CellBlock toCellBlock = (CellBlock)info.get("Block_To");
            int dragDirection = this.getDragDirection(fromCellBlock, toCellBlock);
            BizFormulaMover bizFormulaMover = FormulaMoverFactoryForOther.getFormulaMover((Map)info);
            Object[] newParameters = null;
            if (methodParameters[0] != null) {
                int len = ((Object[])methodParameters[0]).length;
                newParameters = new Object[len];
                System.arraycopy((Object[])methodParameters[0], 0, newParameters, 0, len);
            } else {
                newParameters = new Object[]{};
            }
            int[] hasChangedParas = bizFormulaMover.getModifiedParasIndexs();
            int n = methodParameters.length;
            for (int i = 0; i < n; ++i) {
                bizFormulaMover.move(dragDirection, methodName, Arrays.asList(newParameters));
                int index = 0;
                index = dragDirection == 4 || dragDirection == 1 ? n - 1 - i : i;
                int m = hasChangedParas.length;
                for (int j = 0; j < m; ++j) {
                    ((Object[])methodParameters[index])[hasChangedParas[j]] = new Variant(newParameters[hasChangedParas[j]], 11);
                }
            }
            return true;
        }
        return false;
    }

    protected int getDragDirection(CellBlock fromCellBlock, CellBlock toCellBlock) {
        if (fromCellBlock != null && toCellBlock != null) {
            int fromCol1 = fromCellBlock.getCol();
            int fromCol2 = fromCellBlock.getCol2();
            int fromRow1 = fromCellBlock.getRow();
            int fromRow2 = fromCellBlock.getRow2();
            int toCol1 = toCellBlock.getCol();
            int toCol2 = toCellBlock.getCol2();
            int toRow1 = toCellBlock.getRow();
            int toRow2 = toCellBlock.getRow2();
            if (fromRow1 > toRow1) {
                return 1;
            }
            if (fromRow2 < toRow2) {
                return 3;
            }
            if (fromCol1 > toCol1) {
                return 4;
            }
            if (fromCol2 < toCol2) {
                return 2;
            }
        }
        return 0;
    }

    public BigDecimal SaleContractQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleContractBaseQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleContractAmount(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String currencyNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleOrderQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleOrderBaseQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleOrderAmount(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String currencyNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PostRequisitionQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PostRequisitionBaseQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PostRequisitionAmount(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String currencyNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleReturnsQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleReturnsBaseQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleReturnsAmount(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String currencyNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal ProductIn(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String transactionTypeNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType, String costCenterNumber, String adminOrgUnit) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal OtherIn(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String transactionTypeNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal MoveIn(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String transactionTypeNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal MaterialReq(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String transactionTypeNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType, String costCenterNumber, String adminOrgUnit, String costObjectNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal OtherIssue(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String transactionTypeNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType, String costCenter) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal MoveIssue(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String transactionTypeNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType, String costCenter) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal SaleOut(String companyNumber, String mainBizOrgNumber, String saleOrgUnit, Date startTime, Date endTime, String transactionTypeNumber, String csspGroupStdNumber, String csspGroupNumber, String csspNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType, String costCenter) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PurchaseIn(String companyNumber, String mainBizOrgNumber, String saleOrgUnit, Date startTime, Date endTime, String transactionTypeNumber, String csspGroupStdNumber, String csspGroupNumber, String csspNumber, String materialGroupStdNumber, String materialGroupNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchDataType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal CostAdjust(String companyNumber, String mainBizOrgNumber, Date startTime, Date endTime, String bizType, String materialGroupStdNumber, String materialGroupNumber, String costObjectNumber, String costCenterNumber, String materialNumber, String warehouseNumber, String currencyNumber, String fetchType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PurOrderBaseQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PurOrderAmount(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String currencyNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PurContractAmount(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String currencyNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal PurContractBaseQty(String companyNumber, int startYear, int startPeriod, int endYear, int endPeriod, String mainBizOrgNumber, String materialNumber) throws BOSException, EASBizException {
        return null;
    }
}

