/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.service.IPermissionService;
import com.kingdee.eas.scm.common.service.IService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SCMPermissionService
extends AbstractBOSObject
implements IPermissionService {
    static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"SCMPERMSERVICE");
    protected static final String PERMISSION_ITEMS = "PERMISSION_ITEMS";
    Context objContext;

    @Override
    public Map execute() throws BOSException {
        List orgList = (List)this.objContext.get((Object)"PERM_ORGID");
        IMetaDataPK uiMedataPK = (IMetaDataPK)this.objContext.get((Object)"PERM_FUNCTIONPK");
        IMetaDataPK actionPK = (IMetaDataPK)this.objContext.get((Object)"PERM_OPERATIONPK");
        IObjectPK userPK = (IObjectPK)this.objContext.get((Object)"PERM_USERID");
        return this.checkFunctionPermission(userPK, orgList, uiMedataPK, actionPK);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public SCMPermissionService() {
        this.registerInterface(IService.class, this);
    }

    public SCMPermissionService(Context ctx) {
        super(ctx);
        this.objContext = ctx;
        this.registerInterface(IService.class, this);
    }

    @Override
    public Map checkFunctionPermission(IObjectPK userPK, List orgPKs, IMetaDataPK uiMedataPK, IMetaDataPK actionPK) throws BOSException {
        HashMap<String, Exception> result = new HashMap<String, Exception>();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.getContext());
        int size = orgPKs.size();
        for (int i = 0; i < size; ++i) {
            String orgId = (String)orgPKs.get(i);
            try {
                iPermission.checkFunctionPermission(userPK, (IObjectPK)new ObjectUuidPK(orgId), uiMedataPK, actionPK);
                continue;
            }
            catch (Exception e) {
                result.put(orgId, e);
            }
        }
        return result;
    }

    @Override
    public OrgUnitInfo[] getAuthorizedBizOrgUnits(IObjectPK userPK, OrgType orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection bizOrgs = SCMGroupServerUtils.getAuthorizedBizOrgUnitCollection((Context)this.getContext(), (OrgType)orgType, (String)permissionItem);
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    @Override
    public OrgUnitInfo[] getAuthorizedBizOrgUnit(IObjectPK userPK, OrgType orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)this.getContext(), (OrgType)orgType, (String)permissionItem);
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = collection.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }
}

