/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.trace;

import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import java.lang.reflect.Method;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class RPCInvokeStatckTrace
extends InvokeMonitor {
    private static Logger logger = Logger.getLogger(RPCInvokeStatckTrace.class);

    public static void init() {
    }

    protected RPCInvokeStatckTrace(boolean client, boolean server) {
        super(client, server);
    }

    public void invokePerformed(InvokeRecord rec) {
        if (logger.getLevel() == null || !logger.getLevel().equals((Object)Level.DEBUG)) {
            return;
        }
        if (rec.command == 0) {
            String remoteInterface = ((InvokeRecord.MethodInvoke)rec.detail).method.getDeclaringClass().getName();
            Method method = ((InvokeRecord.MethodInvoke)rec.detail).method;
            StringBuffer sb = new StringBuffer();
            sb.append(method.getName());
            sb.append("(");
            Class<?>[] params = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i].getName());
                if (i >= params.length - 1) continue;
                sb.append(", ");
            }
            sb.append(") ");
            sb.append(method.getReturnType().getName());
            this.logRPC(remoteInterface, sb.toString());
        }
    }

    private void logRPC(String remoteInterface, String method) {
        if (logger.getLevel() == null || !logger.getLevel().equals((Object)Level.DEBUG)) {
            return;
        }
        if (remoteInterface.endsWith("IMessageCenter") && method.startsWith("receiveTempMsg")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(remoteInterface).append(".").append(method).append("\r\n");
        sb.append("................................................................................\r\n");
        StackTraceElement[] elements = new Throwable().getStackTrace();
        boolean isStart = false;
        if (elements != null) {
            int size = elements.length;
            for (int i = 0; i < size; ++i) {
                if (!isStart) {
                    isStart = elements[i].toString().startsWith("rpc_generate");
                    continue;
                }
                sb.append(elements[i]).append("\r\n");
            }
        }
        logger.debug((Object)sb.toString());
    }

    static {
        if (logger.getLevel() != null && logger.getLevel().equals((Object)Level.DEBUG)) {
            RPCInvokeStatckTrace monitor = new RPCInvokeStatckTrace(true, false);
            RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
        }
    }
}

