/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.math.BigDecimal;
import java.util.Date;

public abstract class CurrencyExchangeRateUtils {
    public static final BigDecimal EXCHANGERATE_DEFAULT = SCMUtils.BIGDECIMAL_ONE;
    public static final SelectorItemCollection exchangeRateSelectors;
    private static ExchangeRateInfo baseExchangeRateInfo;

    public static final ExchangeRateInfo baseExchangeRateInfo() {
        return baseExchangeRateInfo;
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo company, CurrencyInfo currency) throws EASBizException, BOSException {
        return CurrencyExchangeRateUtils.getExchangeRate(null, company, currency, new Date());
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo currency, Date date) throws EASBizException, BOSException {
        if (company == null) {
            return CurrencyExchangeRateUtils.baseExchangeRateInfo();
        }
        ExchangeRateInfo exchangeRate = CurrencyExchangeRateUtils.baseExchangeRateInfo();
        if (currency != null && currency.getId() != null) {
            BOSUuid bc;
            if ((company = OrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, (OrgUnitInfo)company)).getBaseExchangeTable() != null && company.getBaseCurrency() != null) {
                BOSUuid bt = company.getBaseExchangeTable().getId();
                BOSUuid bc2 = company.getBaseCurrency().getId();
                if (bt != null && bc2 != null && !currency.getId().toString().equals(bc2.toString())) {
                    IExchangeRate ie = null;
                    ie = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
                    exchangeRate = ie.getExchangeRate((IObjectPK)new ObjectUuidPK(bt), (IObjectPK)new ObjectUuidPK(currency.getId()), (IObjectPK)new ObjectUuidPK(bc2), date);
                }
            } else if (company.getBaseExchangeTable() != null || company.getBaseCurrency() == null || (bc = company.getBaseCurrency().getId()) == null || !currency.getId().toString().equals(bc.toString())) {
                // empty if block
            }
        }
        return exchangeRate;
    }

    public static ExchangeRateInfo fullExchangeRateInfo(Context ctx, ExchangeRateInfo rate) throws EASBizException, BOSException {
        if (rate == null || rate.getId() == null) {
            return rate;
        }
        IExchangeRate ie = null;
        ie = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
        return ie.getExchangeRateInfo((IObjectPK)new ObjectStringPK(rate.getId().toString()), exchangeRateSelectors);
    }

    public static boolean isBaseExchangeRate(ExchangeRateInfo rate) {
        BigDecimal convertRate;
        boolean isTrue = false;
        if (rate != null && !SCMUtils.equalsZero(convertRate = rate.getConvertRate())) {
            isTrue = CurrencyExchangeRateUtils.baseExchangeRateInfo().getConvertRate().compareTo(convertRate) == 0;
        }
        return isTrue;
    }

    public static boolean isBaseCurrency(CompanyOrgUnitInfo company, CurrencyInfo currency) {
        CurrencyInfo baseCurrency;
        boolean isTrue = false;
        if (company != null && currency != null && (baseCurrency = company.getBaseCurrency()) != null && baseCurrency.getId() != null && currency.getId() != null) {
            isTrue = baseCurrency.getId().toString().equals(currency.getId().toString());
        }
        return isTrue;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return CurrencyExchangeRateUtils.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static BigDecimal visitExchangeRate(ExchangeRateInfo info) {
        return info == null ? SCMUtils.effectualExchangeRate(null) : SCMUtils.effectualExchangeRate(info.getConvertRate());
    }

    public static int visitCovertMode(ExchangeRateInfo info) {
        return info == null ? 0 : info.getConvertMode().getValue();
    }

    public static int visitExchangeRatePrecision(ExchangeRateInfo info) {
        return info == null ? 2 : SCMUtils.effectualPrecision(info.getPrecision());
    }

    static {
        baseExchangeRateInfo = null;
        exchangeRateSelectors = new SelectorItemCollection();
        exchangeRateSelectors.add(new SelectorItemInfo("id"));
        exchangeRateSelectors.add(new SelectorItemInfo("number"));
        exchangeRateSelectors.add(new SelectorItemInfo("name"));
        exchangeRateSelectors.add(new SelectorItemInfo("convertRate"));
        exchangeRateSelectors.add(new SelectorItemInfo("exchangeAux.convertMode"));
        exchangeRateSelectors.add(new SelectorItemInfo("exchangeAux.precision"));
        baseExchangeRateInfo = new ExchangeRateInfo();
        baseExchangeRateInfo.setConvertRate(SCMUtils.BIGDECIMAL_ONE);
        ExchangeAuxInfo exchangeAux = new ExchangeAuxInfo();
        exchangeAux.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        exchangeAux.setPrecision(2);
        baseExchangeRateInfo.setExchangeAux(exchangeAux);
    }
}

