/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OrgUnitUtils {
    public static final String ORG_DELEGATE_SALE_FI = "00000000-0000-0000-0000-0000000000050FE9F8B5";
    public static final String ORG_DELEGATE_PURCHARSE_FI = "00000000-0000-0000-0000-0000000000030FE9F8B5";
    public static final String ORG_DELEGATE_STORAGE_FI = "00000000-0000-0000-0000-0000000000070FE9F8B5";
    public static final String ORG_DELEGATE_ADMIN_FI = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    public static final String ORG_DELEGATE_HR_FI = "00000000-0000-0000-0000-0000000000130FE9F8B5";
    public static final int ORG_OU_BIZUNIT = 1;
    public static final int ORG_OU_VIRTUAL = 2;
    public static final int ORG_OU_ALL = 3;
    public static final int ORG_OU_UP = 1;
    public static final int ORG_OU_DOWN = 2;
    public static Map<OrgType, String> orgTableMap = new HashMap<OrgType, String>();

    public static final CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return OrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit, false);
    }

    public static final CompanyOrgUnitInfo readFullCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return OrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit, true);
    }

    public static CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit, boolean isFull) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (orgUnit != null) {
            if (orgUnit instanceof CompanyOrgUnitInfo && orgUnit.getId() != null) {
                company = (CompanyOrgUnitInfo)orgUnit;
                if (isFull && (company.getBaseCurrency() == null || company.getBaseCurrency().getName() == null || !company.getBaseCurrency().containsKey("precision") || company.getBaseExchangeTable() == null)) {
                    company = OrgUnitUtils.fullCompanyOrgUnitInfo(ctx, company.getId().toString());
                }
            } else {
                OrgUnitInfo ou = null;
                ou = ctx != null ? OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUint(OrgUnitUtils.getOrgRelationTypeByOU(orgUnit), orgUnit) : OrgUnitRelationFactory.getRemoteInstance().getToUint(OrgUnitUtils.getOrgRelationTypeByOU(orgUnit), orgUnit);
                if (ou != null && ou.getId() != null) {
                    if (isFull) {
                        company = OrgUnitUtils.fullCompanyOrgUnitInfo(ctx, ou.getId().toString());
                    } else {
                        company = new CompanyOrgUnitInfo();
                        company.setId(ou.getId());
                    }
                }
            }
        }
        return company;
    }

    public static CompanyOrgUnitInfo fullCompanyOrgUnitInfo(Context ctx, String Id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("baseCurrency.id"));
        selectors.add(new SelectorItemInfo("baseCurrency.name"));
        selectors.add(new SelectorItemInfo("baseCurrency.precision"));
        selectors.add(new SelectorItemInfo("baseExchangeTable.id"));
        ICompanyOrgUnit ie = null;
        ie = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(Id), selectors);
    }

    public static CompanyOrgUnitInfo getCurrentCompanyOrgUnitInfo(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String id = (String)ctx.get((Object)"CurCompanyId");
        if (id != null && id.trim().length() != 0) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(id));
        }
        return company;
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 1);
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 1);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 2);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 2);
    }

    public static CompanyOrgUnitCollection getThreadCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType, int upOrDown) throws EASBizException, BOSException {
        if (ctx == null || companyId == null || companyId.trim().length() == 0) {
            return null;
        }
        String sp = " \r\n";
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT b.FID, b.FNumber, b.FName").append(locale).append(" As FCompanyName, b.FLongNumber, b.FBaseExgTableID, ").append(sp);
        strSQL.append("  b.FBaseCurrencyID, c.FName").append(locale).append(" As FCurrencyName, c.FPrecision").append(sp);
        strSQL.append("FROM T_ORG_Company a, T_ORG_Company b, T_BD_Currency c").append(sp);
        strSQL.append("WHERE a.FID = ? And b.FBaseCurrencyID = c.FID ").append(sp);
        if (isContainSelf) {
            if (2 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            } else if (1 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            }
        } else if (2 == upOrDown) {
            strSQL.append("  And (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) ").append(sp);
        } else if (1 == upOrDown) {
            strSQL.append("  And (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ").append(sp);
        }
        if (isBizUnit == 1) {
            strSQL.append("  And b.FIsBizUnit = 1").append(sp);
        } else if (isBizUnit == 2) {
            strSQL.append("  And b.FIsBizUnit = 0").append(sp);
        }
        if (sortType == null || sortType != null && SortType.ASCEND.getName().equalsIgnoreCase(sortType.getName())) {
            strSQL.append("Order By b.FLongNumber ASC");
        } else {
            strSQL.append("Order By b.FLongNumber DESC");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyId});
        CompanyOrgUnitCollection companys = new CompanyOrgUnitCollection();
        if (rs != null) {
            try {
                CompanyOrgUnitInfo company = null;
                while (rs.next()) {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("FID")));
                    company.setNumber(rs.getString("FNumber"));
                    company.setName(rs.getString("FCompanyName"));
                    company.setLongNumber(rs.getString("FLongNumber"));
                    if (rs.getString("FBaseExgTableID") != null) {
                        ExchangeTableInfo exchangeTable = new ExchangeTableInfo();
                        exchangeTable.setId(BOSUuid.read((String)rs.getString("FBaseExgTableID")));
                        company.setBaseExchangeTable(exchangeTable);
                    }
                    CurrencyInfo baseCurrency = new CurrencyInfo();
                    baseCurrency.setId(BOSUuid.read((String)rs.getString("FBaseCurrencyID")));
                    baseCurrency.setName(rs.getString("FCurrencyName"));
                    baseCurrency.setPrecision(rs.getInt("FPrecision"));
                    company.setBaseCurrency(baseCurrency);
                    companys.add(company);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return companys;
    }

    private static OrgTypeRelationInfo getOrgRelationTypeByOU(OrgUnitInfo orgUnit) {
        OrgTypeRelationInfo ri = null;
        if (orgUnit != null) {
            ri = new OrgTypeRelationInfo();
            if (orgUnit != null) {
                if (orgUnit instanceof PurchaseOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_PURCHARSE_FI));
                } else if (orgUnit instanceof SaleOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_SALE_FI));
                } else if (orgUnit instanceof StorageOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_STORAGE_FI));
                } else if (orgUnit instanceof AdminOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_ADMIN_FI));
                } else if (orgUnit instanceof HROrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_HR_FI));
                }
            }
        }
        return ri;
    }

    public static OrgUnitInfo getOrgUnitInfoByNum(Context ctx, String orgNum) throws Exception {
        if (orgNum == null || orgNum.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        IFullOrgUnit orgCtrl = null;
        orgCtrl = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNum));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        CoreBaseCollection col = orgCtrl.getCollection(ev);
        if (col.size() >= 1) {
            return (OrgUnitInfo)col.get(0);
        }
        return null;
    }

    public static OrgUnitCollection getBizOrgUnitInfosByType(OrgUnitCollection orgs, OrgType orgType) {
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgType.equals((Object)OrgType.Company)) {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                if (!((CompanyOrgUnitInfo)orgs.get(i)).isIsBizUnit()) continue;
                results.add(orgs.get(i));
            }
        } else if (orgType.equals((Object)OrgType.Sale)) {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                if (!((SaleOrgUnitInfo)orgs.get(i)).isIsBizUnit()) continue;
                results.add(orgs.get(i));
            }
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                if (!((PurchaseOrgUnitInfo)orgs.get(i)).isIsBizUnit()) continue;
                results.add(orgs.get(i));
            }
        } else if (orgType.equals((Object)OrgType.Storage)) {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                if (!((StorageOrgUnitInfo)orgs.get(i)).isIsBizUnit()) continue;
                results.add(orgs.get(i));
            }
        } else {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                results.add(orgs.get(i));
            }
        }
        return results;
    }

    public static OrgUnitCollection getChildrenOrgCollection(Context ctx, String orgId, int isBizUnit, boolean isContainSelf, SortType sortType, OrgType orgType, String filter) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadOrgCollection(ctx, orgId, isBizUnit, isContainSelf, sortType, 2, orgType, filter);
    }

    public static OrgUnitCollection getSuperiorOrgCollection(Context ctx, String orgId, int isBizUnit, boolean isContainSelf, SortType sortType, OrgType orgType, String filter) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadOrgCollection(ctx, orgId, isBizUnit, isContainSelf, sortType, 1, orgType, filter);
    }

    public static OrgUnitCollection getThreadOrgCollection(Context ctx, String orgId, int isBizUnit, boolean isContainSelf, SortType sortType, int upOrDown, OrgType orgType, String filter) throws EASBizException, BOSException {
        if (ctx == null || orgId == null || orgId.trim().length() == 0) {
            return null;
        }
        OrgUnitCollection orgs = new OrgUnitCollection();
        String sp = " \r\n";
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer strSQL = new StringBuffer();
        String orgTable = orgTableMap.get(orgType);
        String filterStr = filter.toString();
        if (orgTable == null) {
            return orgs;
        }
        strSQL.append("SELECT b.FID, b.FNumber, b.FName").append(locale).append(" As FName, b.FLongNumber ").append(sp);
        strSQL.append("FROM ").append(orgTable).append(" as a ,").append(orgTable).append(" as b").append(sp);
        strSQL.append("WHERE a.FID = ? ").append(sp);
        if (isContainSelf) {
            if (2 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            } else if (1 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            }
        } else if (2 == upOrDown) {
            strSQL.append("  And (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) ").append(sp);
        } else if (1 == upOrDown) {
            strSQL.append("  And (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ").append(sp);
        }
        if (isBizUnit == 1) {
            strSQL.append("  And b.FIsBizUnit = 1").append(sp);
        } else if (isBizUnit == 2) {
            strSQL.append("  And b.FIsBizUnit = 0").append(sp);
        }
        if (filter != null) {
            strSQL.append(" and b.fid in ").append(filter).append(sp);
        }
        if (sortType == null || sortType != null && SortType.ASCEND.getName().equalsIgnoreCase(sortType.getName())) {
            strSQL.append("Order By b.FLongNumber ASC");
        } else {
            strSQL.append("Order By b.FLongNumber DESC");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{orgId});
        if (rs != null) {
            try {
                OrgUnitInfo orgInfo = null;
                while (rs.next()) {
                    orgInfo = new OrgUnitInfo();
                    orgInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    orgInfo.setNumber(rs.getString("FNumber"));
                    orgInfo.setName(rs.getString("FName"));
                    orgInfo.setLongNumber(rs.getString("FLongNumber"));
                    orgs.add(orgInfo);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return orgs;
    }

    public static OrgUnitInfo getDefaultMainBizOrg(Context ctx, OrgType orgType, OrgUnitInfo[] mainOrgs) throws BOSException, EASBizException {
        OrgUnitInfo currentMainOrg = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static OrgUnitInfo[] getMainBizOrgList(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs = null;
        mainOrgs = SCMServiceFactory.getLocalInstance(ctx).getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), orgType, permissionItem);
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        ArrayList<OrgUnitInfo> tempOrgArray = new ArrayList<OrgUnitInfo>();
        boolean isSealUp = false;
        for (int i = 0; i < mainOrgs.length; ++i) {
            if (mainOrgs[i].get("isSealup") != null) {
                isSealUp = Boolean.valueOf(String.valueOf(mainOrgs[i].get("isSealup")));
            }
            if (!mainOrgs[i].isIsOUSealUp() && !isSealUp) {
                tempOrgArray.add(mainOrgs[i]);
            }
            isSealUp = false;
        }
        mainOrgs = tempOrgArray.toArray(new OrgUnitInfo[tempOrgArray.size()]);
        if (mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
        }
        return mainOrgs;
    }

    public static Object[] getPermissionOrg(Context ctx, Object[] purChaseOrg, String permissionName) throws BOSException {
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)permissionName);
        if (null == purChaseOrg || purChaseOrg.length == 0 || null == cuUnitSets) {
            purChaseOrg = new Object[]{};
        } else {
            Set havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)cuUnitSets, (Object[])purChaseOrg);
            purChaseOrg = havePermOrgUnitSet.toArray();
        }
        return purChaseOrg;
    }

    static {
        orgTableMap.put(OrgType.Company, "T_ORG_COMPANY");
        orgTableMap.put(OrgType.Admin, "T_ORG_Admin");
        orgTableMap.put(OrgType.Purchase, "T_ORG_Purchase");
        orgTableMap.put(OrgType.Storage, "T_ORG_Storage");
        orgTableMap.put(OrgType.Sale, "T_ORG_Sale");
    }
}

