/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.util.SortUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class OrgUtils {
    public static OrgUnitCollection getToOrgUnitColl(Context ctx, String orgId, OrgType formOrgType, OrgType toOrgType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitCollection = null;
        orgUnitCollection = iOrgUnitRelation.getToUnit(orgId, formOrgType.getValue(), toOrgType.getValue());
        orgUnitCollection = OrgUtils.getOrgCollect(orgUnitCollection, toOrgType);
        return orgUnitCollection;
    }

    public static OrgUnitCollection getFromOrgUnitColl(Context ctx, String orgId, OrgType toOrgType, OrgType formOrgType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitCollection = null;
        orgUnitCollection = iOrgUnitRelation.getFromUnit(orgId, toOrgType.getValue(), formOrgType.getValue());
        orgUnitCollection = OrgUtils.getOrgCollect(orgUnitCollection, formOrgType);
        return orgUnitCollection;
    }

    public static String getOrgFilterStr(Context ctx, OrgUnitCollection orgCollection) throws BOSException, EASBizException {
        if (orgCollection == null || orgCollection.size() == 0) {
            return "('xxxxxxxx')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < orgCollection.size(); ++i) {
            sb.append("'").append(orgCollection.get(i).getId().toString()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private static OrgUnitCollection getOrgCollect(OrgUnitCollection orgUnitCollection, OrgType orgType) {
        OrgUnitCollection orgColl = new OrgUnitCollection();
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            OrgUnitInfo orgUnitInfo = null;
            int size = orgUnitCollection.size();
            for (int i = 0; i < size; ++i) {
                orgUnitInfo = orgUnitCollection.get(i);
                if (orgType.equals((Object)OrgType.Storage) && orgUnitInfo.isIsStorageOrgUnit()) {
                    StorageOrgUnitInfo storageOrgInfo = null;
                    storageOrgInfo = (StorageOrgUnitInfo)orgUnitInfo;
                    if (storageOrgInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (orgType.equals((Object)OrgType.Admin) && orgUnitInfo.isIsAdminOrgUnit()) {
                    AdminOrgUnitInfo adminOrgInfo = null;
                    adminOrgInfo = (AdminOrgUnitInfo)orgUnitInfo;
                    if (adminOrgInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (orgType.equals((Object)OrgType.Purchase) && orgUnitInfo.isIsPurchaseOrgUnit()) {
                    PurchaseOrgUnitInfo purchaseOrgInfo = null;
                    purchaseOrgInfo = (PurchaseOrgUnitInfo)orgUnitInfo;
                    if (purchaseOrgInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (orgType.equals((Object)OrgType.Company) && orgUnitInfo.isIsCompanyOrgUnit()) {
                    CompanyOrgUnitInfo companyOrgInfo = null;
                    companyOrgInfo = (CompanyOrgUnitInfo)orgUnitInfo;
                    if (companyOrgInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (orgType.equals((Object)OrgType.Sale) && orgUnitInfo.isIsSaleOrgUnit()) {
                    SaleOrgUnitInfo saleOrgUnitInfo = null;
                    saleOrgUnitInfo = (SaleOrgUnitInfo)orgUnitInfo;
                    if (saleOrgUnitInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (orgType.equals((Object)OrgType.ProfitCenter) && orgUnitInfo.isIsProfitOrgUnit()) {
                    PurchaseOrgUnitInfo profitOrgUnitInfo = null;
                    profitOrgUnitInfo = (PurchaseOrgUnitInfo)orgUnitInfo;
                    if (profitOrgUnitInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (!orgType.equals((Object)OrgType.ControlUnit) || !orgUnitInfo.isIsCU()) continue;
                CompanyOrgUnitInfo controlOrgUnitInfo = null;
                controlOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitInfo;
                if (controlOrgUnitInfo.isIsSealUp()) continue;
                orgColl.add(orgUnitInfo);
            }
        }
        return orgColl;
    }

    public static Map getFromOrgUnits(Set orgSet) throws EASBizException, BOSException {
        HashMap<String, String> storageOrgUnitsMap = new HashMap<String, String>();
        StringBuffer idstring = new StringBuffer();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgCol = null;
        String orgid = null;
        Object[] orgSets = orgSet.toArray();
        int length = orgSets.length;
        for (int j = 0; j < length; ++j) {
            orgid = (String)orgSets[j];
            orgCol = iUnitRel.getFromUnit(orgid, 3, 4);
            idstring.setLength(0);
            idstring.append("'");
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                idstring.append(orgCol.get(i).get("id")).append("','");
            }
            idstring.append("'");
            storageOrgUnitsMap.put(orgid, idstring.toString());
        }
        return storageOrgUnitsMap;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnits(String orgid) throws EASBizException, BOSException {
        CompanyOrgUnitInfo coi = new CompanyOrgUnitInfo();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgCol = null;
        orgCol = iUnitRel.getToUnit(orgid, 3, 1);
        if (orgCol.size() > 0) {
            coi = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return coi;
    }

    public static OrgUnitInfo getSortDataByNumber(OrgUnitCollection orgCol) {
        if (null != orgCol && orgCol.size() == 0) {
            return null;
        }
        OrgUnitInfo[] purOrgUnits = new OrgUnitInfo[orgCol.size()];
        for (int i = 0; i < orgCol.size(); ++i) {
            OrgUnitInfo tempOrgUnit;
            purOrgUnits[i] = tempOrgUnit = orgCol.get(i);
        }
        if (purOrgUnits.length > 0) {
            purOrgUnits = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])purOrgUnits, true);
        }
        if (purOrgUnits.length > 0) {
            return purOrgUnits[0];
        }
        return null;
    }

    public static void getSortData(OrgUnitCollection orgCol) {
        int i;
        if (null != orgCol && orgCol.size() == 0) {
            return;
        }
        OrgUnitInfo[] purOrgUnits = new OrgUnitInfo[orgCol.size()];
        for (i = 0; i < orgCol.size(); ++i) {
            OrgUnitInfo tempOrgUnit;
            purOrgUnits[i] = tempOrgUnit = orgCol.get(i);
        }
        if (purOrgUnits.length > 0) {
            purOrgUnits = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])purOrgUnits, true);
        }
        orgCol.clear();
        for (i = 0; i < purOrgUnits.length; ++i) {
            orgCol.add(purOrgUnits[i]);
        }
    }
}

