/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillParamValue;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamValueCollection;
import com.kingdee.eas.scm.common.SCMBillParamValueFactory;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.QuotationInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.entity.EntityObjectInfoHelp;
import com.kingdee.eas.scm.util.numeric.CurrencyExchangeRateUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SCMUtil {
    public static Map<BOSObjectType, EntityObjectInfo> entityObjectCache = new HashMap<BOSObjectType, EntityObjectInfo>();
    public static final BigDecimal BIGDECIMAL_ONE;
    public static final BigDecimal EXCHANGERATE_DEFAULT;
    public static final int PRECISION_DEFAUL = 2;
    public static final int PRECISION_DEFAUL_DB = 10;
    public static final String PARAM_NUMBER_THRESHOLD = "EntryNumToJobThresHold";
    public static final String ACTION_RESOURCE = "com.kingdee.eas.scm.common.ActionResource";

    public static String getBillTypeNOFormBillTypeID(BillTypeInfo billType) {
        if (billType == null || billType.getId() == null) {
            return null;
        }
        return SCMUtil.getBillTypeNOFormBillTypeID(billType.getId());
    }

    public static String getBillTypeNOFormBillTypeID(BOSUuid id) {
        if (id == null) {
            return null;
        }
        return SCMUtil.getBillTypeNOFormBillTypeID(id.toString());
    }

    public static String getBillTypeNOFormBillTypeID(String billTypeID) {
        if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            return "110";
        }
        if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return "101";
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            return "102";
        }
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            return "103";
        }
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
            return "104";
        }
        if ("XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeID)) {
            return "160";
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
            return "105";
        }
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
            return "106";
        }
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
            return "107";
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            return "108";
        }
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            return "109";
        }
        if ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            return "100";
        }
        if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeID)) {
            return "410";
        }
        if ("3a3b5446-0106-1000-e000-01c3c0a812e6463ED552".equals(billTypeID)) {
            return "420";
        }
        if ("510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(billTypeID)) {
            return "230";
        }
        if ("510b6503-0105-1000-e000-0117c0a812fd463ED552".equals(billTypeID)) {
            return "330";
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(billTypeID)) {
            return "210";
        }
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billTypeID)) {
            return "220";
        }
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(billTypeID)) {
            return "310";
        }
        if ("510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(billTypeID)) {
            return "320";
        }
        if ("50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID)) {
            return "120";
        }
        if ("50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billTypeID)) {
            return "130";
        }
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
            return "140";
        }
        if ("50957179-0105-1000-e004-4152c0a812fd463ED552".equals(billTypeID)) {
            return "150";
        }
        if ("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=".equals(billTypeID)) {
            return "901";
        }
        if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(billTypeID)) {
            return "250";
        }
        if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(billTypeID)) {
            return "350";
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(billTypeID)) {
            return "141";
        }
        return null;
    }

    public static MultiMeasureUnitInfo getSaleMultiUnit(String meterialID, String saleOrgID) throws BOSException, EASBizException {
        MultiMeasureUnitInfo measureUnitInfo = null;
        IMaterialSales iMaterialSales = MaterialSalesFactory.getRemoteInstance();
        MaterialSalesInfo materialSaleOrgInfo = iMaterialSales.getSalesInfo(meterialID, saleOrgID);
        MeasureUnitInfo saleUnitInfo = materialSaleOrgInfo.getUnit();
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        measureUnitInfo = multiUnit.getMultiUnit(meterialID, saleUnitInfo.getId().toString());
        return measureUnitInfo;
    }

    public static MultiMeasureUnitInfo getPurMultiUnit(String meterialID, String purOrgID) throws BOSException, EASBizException {
        MultiMeasureUnitInfo measureUnitInfo = null;
        IMaterialPurchasing iMaterialPurchasing = MaterialPurchasingFactory.getRemoteInstance();
        MaterialPurchasingInfo materialPurInfo = iMaterialPurchasing.getPurchasingInfo(meterialID, purOrgID);
        MeasureUnitInfo saleUnitInfo = materialPurInfo.getUnit();
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        measureUnitInfo = multiUnit.getMultiUnit(meterialID, saleUnitInfo.getId().toString());
        return measureUnitInfo;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(ctx, materialID, unitInfo, otherUnitInfo, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("basePrecision")) {
            scale = Integer.parseInt((String)map.get("basePrecision"));
        }
        targetQty = NumericUtil.setScale((BigDecimal)targetQty, (int)scale);
        return targetQty;
    }

    public static BigDecimal getExchangePrecisionQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(ctx, materialID, unitInfo, otherUnitInfo, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("otherPrecision")) {
            scale = Integer.parseInt((String)map.get("otherPrecision"));
        }
        targetQty = NumericUtil.setScale((BigDecimal)targetQty, (int)scale);
        return targetQty;
    }

    private static Map getBaseQtyAndPrecision(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        return SCMUtil.getBaseQtyAndPrecision(ctx, materialID, unitInfo.getId().toString(), otherUnitInfo.getId().toString(), qty);
    }

    private static Map getBaseQtyAndPrecision(Context ctx, String materialID, String unitInfoID, String otherUnitInfoID, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal targetQty = null;
        BigDecimal baseQty = null;
        IMultiMeasureUnit multiUnit = null;
        multiUnit = null == ctx ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfoID);
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfoID);
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = NumericUtil.BIGDECIMAL_ONE;
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = NumericUtil.BIGDECIMAL_ONE;
            }
            baseQty = qty.multiply(baseExchangeRate1);
            targetQty = NumericUtil.divideBigDecimal((BigDecimal)baseQty, (BigDecimal)baseExchangeRate2, (int)(baseQty.scale() + qty.scale() + othermultiUnifInfo.getQtyPrecision()));
            map.put("targetQty", targetQty);
            map.put("otherPrecision", String.valueOf(othermultiUnifInfo.getQtyPrecision()));
            map.put("basePrecision", String.valueOf(baseQty.scale() + qty.scale()));
        }
        return map;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(null, materialID, unitInfo, otherUnitInfo, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("basePrecision")) {
            scale = Integer.parseInt((String)map.get("basePrecision"));
        }
        targetQty = NumericUtil.setScale((BigDecimal)targetQty, (int)scale);
        return targetQty;
    }

    public static final Map getMultiMeasureUnitMap(Set materialIdSet, Set unitIdSet) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> hm = new HashMap<String, MultiMeasureUnitInfo>();
        if (materialIdSet.size() > 0 && unitIdSet.size() > 0) {
            EntityViewInfo entityViewInfo = SCMUtil.getMultiMeasureUnitEntityViewInfo(materialIdSet, unitIdSet);
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                MultiMeasureUnitInfo mmuInfo = null;
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    mmuInfo = collection.get(i);
                    String key = mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString();
                    hm.put(key, mmuInfo);
                }
            }
        }
        return hm;
    }

    public static final EntityViewInfo getMultiMeasureUnitEntityViewInfo(Set materialIdSet, Set unitIdSet) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitIdSet, CompareType.INCLUDE));
        filterInfo.setMaskString("#0 and #1");
        SelectorItemCollection sic = entityViewInfo.getSelector();
        sic.add("*");
        sic.add("material.id");
        sic.add("measureUnit.id");
        return entityViewInfo;
    }

    public static BigDecimal getExchangePriceForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal price) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetPrice = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = NumericUtil.effectualExchangeRate((BigDecimal)multiUnifInfo.getBaseConvsRate());
            BigDecimal baseExchangeRate2 = NumericUtil.effectualExchangeRate((BigDecimal)othermultiUnifInfo.getBaseConvsRate());
            int scale = 28;
            BigDecimal basePrice = NumericUtil.divideBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)price), (BigDecimal)baseExchangeRate1, (int)scale);
            if (basePrice != null && price != null) {
                scale = basePrice.scale() + price.scale();
            }
            targetPrice = NumericUtil.multiplyBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)basePrice), (BigDecimal)NumericUtil.effectualExchangeRate((BigDecimal)baseExchangeRate2), (int)scale);
        }
        return targetPrice;
    }

    public static BigDecimal getExchangePricesionQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(null, materialID, unitInfo, otherUnitInfo, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("otherPrecision")) {
            scale = Integer.parseInt((String)map.get("otherPrecision"));
        }
        targetQty = NumericUtil.setScale((BigDecimal)targetQty, (int)scale);
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal baseQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        if (multiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = NumericUtil.BIGDECIMAL_ONE;
            }
            baseQty = qty.multiply(baseExchangeRate1);
        }
        return baseQty;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, String materialID, String unitInfoID, BigDecimal qty, String otherUnitInfoID) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(null, materialID, unitInfoID, otherUnitInfoID, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("otherPrecision")) {
            scale = Integer.parseInt((String)map.get("otherPrecision"));
        }
        targetQty = NumericUtil.setScale((BigDecimal)targetQty, (int)scale);
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(MultiMeasureUnitInfo multiUnifInfo, MultiMeasureUnitInfo othermultiUnifInfo, BigDecimal qty) {
        BigDecimal targetQty = qty;
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = NumericUtil.BIGDECIMAL_ONE;
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = NumericUtil.BIGDECIMAL_ONE;
            }
            BigDecimal baseQty = NumericUtil.multiplyBigDecimal((BigDecimal)qty, (BigDecimal)baseExchangeRate1, (int)16);
            targetQty = NumericUtil.divideBigDecimal((BigDecimal)baseQty, (BigDecimal)baseExchangeRate2, (int)(baseQty.scale() + qty.scale()));
        }
        return targetQty;
    }

    public static BigDecimal getExchangeRateQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo mulUnit;
        BigDecimal baseExchangeRate = NumericUtil.BIGDECIMAL_ONE;
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (material != null && unit != null && (mulUnit = immu.getMultiUnit(material.getId().toString(), unit.getId().toString())) != null) {
            baseExchangeRate = mulUnit.getBaseConvsRate();
        }
        return baseExchangeRate;
    }

    public static void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public static BigDecimal calculateLocalAmount(BigDecimal amount, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal localAmount = NumericUtil.BIGDECIMAL_ZERO;
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                localAmount = amount.multiply(exchangeRateinfo.getConvertRate());
            } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                int scale = amount.scale() + exchangeRateinfo.getConvertRate().scale();
                localAmount = NumericUtil.divideBigDecimal((BigDecimal)amount, (BigDecimal)exchangeRateinfo.getConvertRate(), (int)scale);
            }
        } else {
            localAmount = amount;
        }
        return localAmount;
    }

    public static BigDecimal calculateOriginAmount(BigDecimal baseamount, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal amount = NumericUtil.BIGDECIMAL_ZERO;
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                int scale = baseamount.scale() + exchangeRateinfo.getConvertRate().scale();
                amount = NumericUtil.divideBigDecimal((BigDecimal)baseamount, (BigDecimal)exchangeRateinfo.getConvertRate(), (int)scale);
            } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                amount = baseamount.multiply(exchangeRateinfo.getConvertRate());
            }
        } else {
            amount = baseamount;
        }
        return amount;
    }

    public static BigDecimal getExchangeRateAmount(Context ctx, CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        BigDecimal exchangeRate = NumericUtil.BIGDECIMAL_ONE;
        if (currencyInfo != null) {
            ObjectUuidPK sourceCurrPK = new ObjectUuidPK(SCMUtil.getCompanyBaseCurrency(ctx, ficompanyOrgInfo).getId().toString());
            ObjectUuidPK destCurrPK = new ObjectUuidPK(currencyInfo.getId());
            ObjectUuidPK excTablepk = null;
            ExchangeTableInfo exchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (exchangeTableInfo != null) {
                excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
                IExchangeRate iexchangRate = null;
                iexchangRate = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
                ExchangeRateInfo exchangeRateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
                if (exchangeRateinfo != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("exchangeAux.*"));
                    exchangeRateinfo = iexchangRate.getExchangeRateInfo((IObjectPK)new ObjectUuidPK(exchangeRateinfo.getId()), sic);
                }
                if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                        exchangeRate = exchangeRate.divide(exchangeRateinfo.getConvertRate(), 4);
                    } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        exchangeRate = exchangeRateinfo.getConvertRate();
                    }
                }
            }
        }
        return exchangeRate;
    }

    public static CurrencyInfo getCompanyBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency();
            return currency;
        }
        ICompanyOrgUnit corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static void releaseMutex(Uuid id) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseMutex(id);
    }

    public static boolean requestMutex(MutexParameter param) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        return mutexService.requestMutex(param);
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutextName, MutexLockType lockType) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(mutextName);
        param.setMutexLockType(lockType);
        return param;
    }

    public static String toParamString(Iterator itor, List params) {
        int count = 0;
        Object o = null;
        if (params == null) {
            params = new ArrayList<String>();
        }
        StringBuffer paramString = new StringBuffer("(");
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null) continue;
            if (count > 0) {
                paramString.append(",");
            }
            paramString.append(" ? ");
            params.add(o.toString());
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            paramString.append(")");
        }
        return paramString.toString();
    }

    public static BigDecimal calculateNumericForMulExchangeRate(BigDecimal numeric, ExchangeRateInfo rate, ExchangeRateInfo oldRate, int scale) {
        BigDecimal localNumeric = SCMUtil.convertAmountByExchangeRate(numeric, oldRate, 10);
        BigDecimal result = NumericUtil.effectualNumeric((BigDecimal)numeric);
        if (rate != null) {
            ConvertModeEnum mode = rate.getConvertMode();
            if (mode != null) {
                if (mode.getValue() == 0) {
                    result = NumericUtil.divideBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)localNumeric), (BigDecimal)NumericUtil.effectualNumeric((BigDecimal)rate.getConvertRate()), (int)NumericUtil.effectualPrecision((int)scale));
                } else if (mode.getValue() == 1) {
                    result = NumericUtil.multiplyBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)localNumeric), (BigDecimal)NumericUtil.effectualNumeric((BigDecimal)rate.getConvertRate()), (int)NumericUtil.effectualPrecision((int)scale));
                }
            } else {
                result = NumericUtil.divideBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)localNumeric), (BigDecimal)NumericUtil.effectualNumeric((BigDecimal)rate.getConvertRate()), (int)NumericUtil.effectualPrecision((int)scale));
            }
        }
        return result;
    }

    public static BigDecimal convertAmountByCompany(Context ctx, BigDecimal amount, CompanyOrgUnitInfo company, CurrencyInfo currency, BigDecimal exchangeRate) throws BOSException, EASBizException {
        if (NumericUtil.isEqualsZero((BigDecimal)amount) || currency == null || currency.getId() == null || company == null || company.getBaseCurrency() == null || company.getBaseCurrency().getId() == null || currency.getId().toString().equals(company.getBaseCurrency().getId().toString())) {
            return amount;
        }
        ExchangeRateInfo rateInfo = CurrencyExchangeRateUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, null);
        if (!NumericUtil.isEqualsZero((BigDecimal)exchangeRate)) {
            rateInfo.setConvertRate(NumericUtil.effectualExchangeRate((BigDecimal)exchangeRate));
        }
        BigDecimal result = amount;
        result = SCMUtil.convertAmountByExchangeRate(result, rateInfo, PrecisionUtil.getCurrencyPrecisionByCompany((CompanyOrgUnitInfo)company));
        return result;
    }

    public static BigDecimal convertAmountByCompany(Context ctx, BigDecimal amount, CompanyOrgUnitInfo company, CurrencyInfo currency) throws BOSException, EASBizException {
        return SCMUtil.convertAmountByCompany(ctx, amount, company, currency, null);
    }

    public static BigDecimal convertAmountByExchangeRate(BigDecimal amount, ExchangeRateInfo exchangeRate, int scale) {
        BigDecimal result = NumericUtil.effectualNumeric((BigDecimal)amount);
        if (exchangeRate != null) {
            ConvertModeEnum mode = exchangeRate.getConvertMode();
            if (mode != null) {
                if (mode.getValue() == 0) {
                    result = NumericUtil.multiplyBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)amount), (BigDecimal)NumericUtil.effectualNumeric((BigDecimal)exchangeRate.getConvertRate()), (int)NumericUtil.effectualPrecision((int)scale));
                } else if (mode.getValue() == 1) {
                    result = NumericUtil.divideBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)amount), (BigDecimal)NumericUtil.effectualNumeric((BigDecimal)exchangeRate.getConvertRate()), (int)NumericUtil.effectualPrecision((int)scale));
                }
            } else {
                result = NumericUtil.multiplyBigDecimal((BigDecimal)NumericUtil.effectualNumeric((BigDecimal)amount), (BigDecimal)NumericUtil.effectualNumeric((BigDecimal)exchangeRate.getConvertRate()), (int)NumericUtil.effectualPrecision((int)scale));
            }
        }
        return result;
    }

    public static boolean equalsID(ObjectBaseInfo val1, ObjectBaseInfo val2) {
        return val1 == null ? val2 == null : (val2 == null ? false : val1.getId().equals((Object)val2.getId()));
    }

    public static String getSqlFromHashSet(Set set) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (set != null && set.size() > 0) {
            Object[] keys = set.toArray(new String[set.size()]);
            sqlBuffer.append(ArrayUtil.getStringFromArr((Object[])keys));
        }
        return sqlBuffer.toString();
    }

    public static CostCenterOrgUnitInfo getCostCenterByAdminOrgInfo(Context ctx, String adminOrgUnitInfoID) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = null;
        if (adminOrgUnitInfoID == null) {
            return null;
        }
        iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrgUnitInfoID, 0, 5);
        CostCenterOrgUnitInfo ret = null;
        ret = (CostCenterOrgUnitInfo)orgCol.get(0);
        return ret;
    }

    public static Set getCostCenterByCompanyOrgInfo(Context ctx, String companyOrgUnitInfoID) throws BOSException, EASBizException {
        OrgUnitCollection orgCol;
        HashSet<String> ids = new HashSet<String>();
        IOrgUnitRelation iUnitRel = null;
        if (companyOrgUnitInfoID != null && (orgCol = (iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getFromUnit(companyOrgUnitInfoID, 1, 5)) != null && orgCol.size() > 0) {
            OrgUnitInfo orgInfo = null;
            int n = orgCol.size();
            for (int i = 0; i < n; ++i) {
                orgInfo = orgCol.get(i);
                ids.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", ids, CompareType.INCLUDE);
        FilterItemInfo filterItemIsBiz = new FilterItemInfo("isBizUnit", (Object)"1", CompareType.EQUALS);
        FilterItemInfo filterItemIsSealUp = new FilterItemInfo("isSealUp", (Object)"0", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.getFilterItems().add(filterItemIsBiz);
        filterInfo.getFilterItems().add(filterItemIsSealUp);
        viewInfo.setFilter(filterInfo);
        ICostCenterOrgUnit iCostCenterOrgUnit = null;
        iCostCenterOrgUnit = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance() : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        CostCenterOrgUnitCollection col = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(viewInfo);
        ids.clear();
        CostCenterOrgUnitInfo info = null;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            info = col.get(i);
            ids.add(info.getId().toString());
        }
        return ids;
    }

    public static Set getCostCenterByCompanyOrgInfo(Context ctx, Set companyOrgUnitInfoIDs) throws BOSException, EASBizException {
        HashSet ids = new HashSet();
        if (companyOrgUnitInfoIDs != null && companyOrgUnitInfoIDs.size() > 0) {
            String companyOrgUnitInfoID = null;
            Iterator iterator = companyOrgUnitInfoIDs.iterator();
            while (iterator.hasNext()) {
                companyOrgUnitInfoID = iterator.next().toString();
                Set tempSet = SCMUtil.getCostCenterByCompanyOrgInfo(ctx, companyOrgUnitInfoID);
                ids.addAll(tempSet);
            }
        }
        return ids;
    }

    public static CostCenterOrgUnitInfo getCostCenterByOrgInfo(Context ctx, String companyOrgUnitInfoID, String adminOrgUnitInfoID) throws BOSException, EASBizException {
        String id;
        if (adminOrgUnitInfoID == null || companyOrgUnitInfoID == null) {
            return null;
        }
        CostCenterOrgUnitInfo costCenter = SCMUtil.getCostCenterByAdminOrgInfo(ctx, adminOrgUnitInfoID);
        Set ids = SCMUtil.getCostCenterByCompanyOrgInfo(ctx, companyOrgUnitInfoID);
        if (costCenter != null && ids.contains(id = costCenter.getId().toString())) {
            return costCenter;
        }
        return null;
    }

    public static boolean validateProperty(HashMap infoMap, String prop) {
        if (infoMap == null || prop == null) {
            return false;
        }
        return infoMap.get(prop) != null && !((String)infoMap.get(prop)).trim().equals("");
    }

    public static int getDiscountRatePrecision(Context ctx) throws BOSException, EASBizException {
        int discountRatePrecision = 4;
        IParamControl ipc = null == ctx ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        String paramvalue = ipc.getParamValue(null, "DISCOUNTRATEPRECISION");
        discountRatePrecision = Integer.valueOf(paramvalue);
        return discountRatePrecision;
    }

    public static Map getMaterialInventoryCollection(Context ctx, Set materialIDS, Set orgIDs) throws BOSException {
        if (materialIDS == null || materialIDS.size() == 0 || orgIDs == null || orgIDs.size() == 0) {
            return new HashMap();
        }
        HashMap<String, MaterialInventoryInfo> matInventory = new HashMap<String, MaterialInventoryInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IMaterialInventory iMaterialInventory = ctx == null ? MaterialInventoryFactory.getRemoteInstance() : MaterialInventoryFactory.getLocalInstance((Context)ctx);
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIDS, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("unit"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("isPeriodValid"));
        view.getSelector().add(new SelectorItemInfo("isLotNumber"));
        view.getSelector().add(new SelectorItemInfo("defaultWarehouse.id"));
        view.getSelector().add(new SelectorItemInfo("defaultWarehouse.number"));
        view.getSelector().add(new SelectorItemInfo("defaultWarehouse.name"));
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(view);
        MaterialInventoryInfo materialInventoryInfo = null;
        String key = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            materialInventoryInfo = col.get(i);
            key = materialInventoryInfo.getMaterial().getId().toString() + materialInventoryInfo.getOrgUnit().getId().toString();
            matInventory.put(key, materialInventoryInfo);
        }
        return matInventory;
    }

    public static boolean isInInvBillTable(String billTable) {
        return "T_IM_PurInWarehsBill".equalsIgnoreCase(billTable) || "T_IM_PurReceivalBill".equalsIgnoreCase(billTable) || "T_IM_ManufactureRecBill".equalsIgnoreCase(billTable) || "T_IM_MoveInWarehsBill".equalsIgnoreCase(billTable) || "T_IM_OtherInWarehsBill".equalsIgnoreCase(billTable);
    }

    public static boolean isOutInvBillTable(String billTable) {
        return "T_IM_OtherIssueBill".equalsIgnoreCase(billTable) || "T_IM_SaleIssueBill".equalsIgnoreCase(billTable) || "T_IM_MaterialReqBill".equalsIgnoreCase(billTable) || "T_IM_MoveIssueBill".equalsIgnoreCase(billTable);
    }

    public static String getInvParamValue(Context ctx, String orgUnitID, String paramName) throws BOSException, EASBizException {
        IParamControl ipc = null == ctx ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        return ipc.getParamValue((IObjectPK)new ObjectUuidPK(orgUnitID), paramName);
    }

    public static boolean isEntryCountOverThreshold(int entryCount) {
        int threshold = 0;
        try {
            String value = ParamManager.getParamValue(null, null, (String)PARAM_NUMBER_THRESHOLD);
            if (value != null && value.length() > 0) {
                threshold = Integer.valueOf(value);
            }
            if (threshold > 0 && entryCount >= threshold) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String getActionResource(String key) {
        return EASResource.getString((String)ACTION_RESOURCE, (String)key);
    }

    public static Boolean getDtTempParamValue(Context ctx, String key) throws BOSException {
        Boolean result = false;
        IRowSet rs = null;
        String sql = "select FValue from t_dt_dttempparam where FKey = '" + key + "'";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && "1".equals(rs.getString("FValue"))) {
                result = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        return result;
    }

    public static OrgUnitInfo getBIllMainOrgColumn(OrgType orgType, SCMBillBaseInfo info) throws BOSException, EASBizException {
        String orgColumn = null;
        if (orgType.equals((Object)OrgType.Purchase)) {
            orgColumn = "purchaseOrgUnit";
        } else if (orgType.equals((Object)OrgType.Company)) {
            orgColumn = "companyOrgUnit";
        } else if (orgType.equals((Object)OrgType.Sale)) {
            orgColumn = "saleOrgUnit";
        } else if (orgType.equals((Object)OrgType.Storage)) {
            orgColumn = "storageOrgUnit";
        }
        if (info instanceof PurContractInfo) {
            orgColumn = "purOrgUnit";
        }
        if (null == orgColumn) {
            return null;
        }
        try {
            OrgUnitInfo orgUnit = (OrgUnitInfo)info.get(orgColumn);
            return orgUnit;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getBotpBillAllowAddEntry(Context ctx, SCMBillBaseInfo info, OrgType orgType, BOSUuid orgId) throws BOSException, EASBizException {
        boolean botpBillAllowAddEntry = false;
        SCMUtil.setBillType(ctx, info);
        if (null == info.getBillType() || null == info.getBillType().getId()) {
            return false;
        }
        BOSUuid billTypeId = info.getBillType().getId();
        ISCMBillParamValue scmParamValue = SCMBillParamValueFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("param.number", (Object)"botpBillAddEntry"));
        filter.getFilterItems().add(new FilterItemInfo("orgType", (Object)orgType.getValue()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)orgId.toString()));
        filter.getFilterItems().add(new FilterItemInfo("param.billType", (Object)billTypeId));
        view.setFilter(filter);
        SCMBillParamValueCollection collection = scmParamValue.getSCMBillParamValueCollection(view);
        if (null != collection && collection.size() > 0 && "1".equals(collection.get(0).getParamValue())) {
            botpBillAllowAddEntry = true;
        }
        return botpBillAllowAddEntry;
    }

    public static void setBillType(Context ctx, SCMBillBaseInfo info) throws BOSException, EASBizException {
        BillTypeInfo billTypeInfo;
        IBillType iBillType = null;
        iBillType = null == ctx ? BillTypeFactory.getRemoteInstance() : BillTypeFactory.getLocalInstance((Context)ctx);
        if (info instanceof SaleOrderInfo && info.getBillType() == null) {
            billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof SaleContractInfo && info.getBillType() == null) {
            billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"DEZBNUYZRM6ieHZ5GGlRc0Y+1VI="));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof SaleReturnsInfo && info.getBillType() == null) {
            billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e008-8152c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PostRequisitionInfo && info.getBillType() == null) {
            billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-011bc0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof QuotationInfo && info.getBillType() == null) {
            billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-9113c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PurOrderInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PurReturnsInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("50957179-0105-1000-e006-6152c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PurContractInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0a813fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PurRequestInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-0107c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PurQuotationInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0a814fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof PurPriceRelationsInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0b814fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof SaleBackProfitBillInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("528d806a-0106-1000-e111-0194c0a812e6463ED552"));
            info.setBillType(billTypeInfo);
        }
        if (info instanceof SubContractOrderInfo && info.getBillType() == null) {
            billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("kvQieV/4TJ+1ipJVFBlPx0Y+1VI="));
            info.setBillType(billTypeInfo);
        }
    }

    public static String getKeyList(Object[] col, String fieldName) {
        if (col == null || col.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < col.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(((IObjectValue)col[i]).getString(fieldName)).append("'");
        }
        return sb.toString();
    }

    public static String getKeys(Object[] col, String fieldName, String mark) {
        if (col == null || col.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < col.length; ++i) {
            if (i > 0) {
                sb.append(mark);
            }
            sb.append(((IObjectValue)col[i]).getString(fieldName));
        }
        return sb.toString();
    }

    public static String[] getF7Numbers(Object f7Value, Boolean hasMarks, String mark) {
        if (f7Value == null) {
            return null;
        }
        String[] numberArray = new String[2];
        String number = null;
        String numbers = null;
        if (f7Value instanceof Object[]) {
            Object[] col = (Object[])f7Value;
            if (col.length == 1) {
                if (col[0] != null) {
                    number = ((IObjectValue)col[0]).getString("number");
                }
            } else {
                numbers = hasMarks.booleanValue() ? SCMUtil.getKeyList(col, "number") : SCMUtil.getKeys(col, "number", mark);
            }
        } else if (f7Value instanceof IObjectValue) {
            number = ((IObjectValue)f7Value).getString("number");
        } else if (!StringUtil.isEmpty(f7Value.toString())) {
            number = f7Value.toString();
        }
        numberArray[0] = number;
        numberArray[1] = numbers;
        return numberArray;
    }

    public static String[] getF7Numbers(Object f7Value) {
        return SCMUtil.getF7Numbers(f7Value, true, null);
    }

    public static EntityObjectInfo getEntityObjectByBosType(BOSObjectType bosType) throws Exception {
        EntityObjectInfo billEntryEntity = null;
        if (entityObjectCache.get(bosType) == null) {
            billEntryEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)bosType);
            entityObjectCache.put(bosType, billEntryEntity);
        } else {
            billEntryEntity = entityObjectCache.get(bosType);
        }
        return billEntryEntity;
    }

    static {
        EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE = new BigDecimal("1.0");
    }
}

