/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class WriteBackSQLHelper {
    private static final String WBRESOURCE = "com.kingdee.eas.scm.common.WBResource";

    public static String createARWriteBackVerifySQL(String id, boolean[] isWriteCore, List params, boolean isArQtyGtSoSysParam, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, ar.FNumber, are.FSeq, si.FNumber as FWBNumber, sie.FSeq as FWBSeq ");
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_IM_SaleIssueBill si ON si.FID=sie.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID=? ");
            if (isBefore) {
                sql.append("AND ABS(are.FbaseQty)-ABS(sie.FbaseQty)+ABS(sie.FDrewBaseQty) > 0 ");
            } else {
                sql.append("AND ABS(sie.FbaseQty)<ABS(sie.FDrewBaseQty) ");
            }
            params.add(id);
        }
        if (isWriteCore[1]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 2 as FErrType, ar.FNumber, are.FSeq, so.FNumber as FWBNumber, soe.FSeq as FWBSeq FROM T_SD_SaleOrderEntry soe ");
            sql.append("INNER JOIN T_SD_SaleOrder so ON so.FID=soe.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=soe.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID= ? ");
            sql.append("AND are.FCoreBillEntryId IN( ");
            sql.append("SELECT are.FCoreBillEntryId ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("INNER JOIN T_SD_SaleOrderEntry soe ON are.FCoreBillEntryId = soe.FID ");
            sql.append("WHERE are.FParentID = ? ");
            if (isBefore) {
                if (isArQtyGtSoSysParam) {
                    sql.append("AND (1=0) ");
                } else {
                    sql.append("GROUP BY are.FCoreBillEntryId, soe.FTotalIssueBaseQty, soe.FTolInvoidBaseQty ,soe.FBaseQty ");
                    sql.append("HAVING ");
                    sql.append("((ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) >= ABS(soe.FTotalIssueBaseQty) AND ABS(SUM(are.FbaseQty)) >ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) - ABS(soe.FTolInvoidBaseQty)) ");
                    sql.append("OR ");
                    sql.append("(ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) < ABS(soe.FTotalIssueBaseQty) AND ABS(SUM(are.FbaseQty)) > ABS(soe.FTotalIssueBaseQty) - ABS(soe.FTolInvoidBaseQty))) ");
                    sql.append(" ) ");
                }
            } else if (isArQtyGtSoSysParam) {
                sql.append("AND (1=0) ");
            } else {
                sql.append("AND ");
                sql.append("((ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) >= ABS(soe.FTotalIssueBaseQty) AND ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) < ABS(soe.FTolInvoidBaseQty)) ");
                sql.append("OR ");
                sql.append("(ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) < ABS(soe.FTotalIssueBaseQty) AND ABS(soe.FTotalIssueBaseQty) < ABS(soe.FTolInvoidBaseQty))) ");
                sql.append(" ) ");
            }
            params.add(id);
            params.add(id);
        }
        if (isWriteCore[2]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 3 as FErrType, ar.FNumber, are.FSeq, sr.FNumber as FWBNumber, sre.FSeq as FWBSeq ");
            sql.append("FROM T_SD_SaleReturnsEntry sre ");
            sql.append("INNER JOIN T_SD_SaleReturns sr ON sr.FID=sre.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=sre.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID=? ");
            sql.append("AND are.FCoreBillEntryId IN( ");
            sql.append("SELECT are.FCoreBillEntryId ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("INNER JOIN T_SD_SaleReturnsEntry sre ON are.FCoreBillEntryId = sre.FID ");
            sql.append("WHERE are.FParentID = ? ");
            if (isBefore) {
                sql.append("GROUP BY are.FCoreBillEntryId, sre.FInvoicedBaseQty,sre.FBaseQty ");
                sql.append("HAVING ");
                sql.append("ABS(SUM(are.FbaseQty))>ABS(sre.FbaseQty)-ABS(sre.FInvoicedBaseQty) )");
            } else {
                sql.append("AND ");
                sql.append("ABS(sre.FbaseQty)<ABS(sre.FInvoicedBaseQty) )");
            }
            params.add(id);
            params.add(id);
        }
        if (isWriteCore[3]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 4 as FErrType, ar.FNumber, are.FSeq, st.FNumber as FWBNumber, ste.FSeq as FWBSeq ");
            sql.append("FROM T_IM_StockTransferBillEntry ste ");
            sql.append("INNER JOIN T_IM_StockTransferBill st ON st.FID=ste.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=ste.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID=? ");
            sql.append("AND are.FCoreBillEntryId IN( ");
            sql.append("SELECT are.FCoreBillEntryId ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("INNER JOIN T_IM_StockTransferBillEntry ste ON are.FCoreBillEntryId = ste.FID ");
            sql.append("WHERE are.FParentID = ? ");
            if (isBefore) {
                sql.append("GROUP BY are.FCoreBillEntryId, ste.FbaseQty, ste.FPurInvoiceBaseQty ");
                sql.append("HAVING ");
                sql.append("ABS(SUM(are.FbaseQty))>ABS(ste.FbaseQty)-ABS(ste.FPurInvoiceBaseQty))");
            } else {
                sql.append("AND ");
                sql.append("ABS(ste.FbaseQty)<ABS(ste.FPurInvoiceBaseQty))");
            }
            params.add(id);
            params.add(id);
        }
        return sql.toString();
    }

    public static void verifyARWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.APAR_WBERROR")).append("\n");
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.ARNO")).append(":");
            sql.append(rs.getString("FNumber"));
            sql.append(";");
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("FSeq")).append(";");
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.WBNO")).append("-->");
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SALEISSUE"));
                    break;
                }
                case 2: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SALEORDER"));
                    break;
                }
                case 3: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SALERETURN"));
                    break;
                }
                case 4: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.TRANSFERORDER"));
                }
            }
            sql.append(":").append(rs.getString("FWBNumber")).append(";");
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("FWBSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String createAR2SIWriteSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_SaleIssueEntry AS T1 SET (FDrewBaseQty,FDrewQty,FAssociateQty)= ");
        sql.append("(SELECT sie.FDrewBaseQty+are.FBaseQty AS IBQ,");
        sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty+are.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
        sql.append("sie.FAssociateQty-are.FBaseQty AS UIQ ");
        sql.append("FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=sie.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
        sql.append("WHERE are.FParentID= ?");
        sql.append(" AND T1.FID=sie.FID)");
        return sql.toString();
    }

    public static String createAR2SIWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_SaleIssueEntry upd SET (FDrewBaseQty,FDrewQty,FAssociateQty)= ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty+are.FQuantity ");
                sql.append("ELSE ROUND((sie.FDrewBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty-are.FBaseQty AS UIQ ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty-are.FQuantity ");
                sql.append("ELSE ROUND((sie.FDrewBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty+are.FBaseQty AS UIQ ");
            }
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
            sql.append("WHERE are.FParentID= ? ");
            sql.append("AND upd.FID=sie.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are WHERE are.FSourceBillEntryId=upd.FID ");
            sql.append("AND are.FParentID= ? ) ");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_SaleIssueEntry upd SET (FDrewBaseQty,FDrewQty,FAssociateQty)= ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty+are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty-are.FBaseQty AS UIQ ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty-are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty+are.FBaseQty AS UIQ ");
            }
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
            sql.append("WHERE are.FParentID= ? ");
            sql.append("AND upd.FID=sie.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are WHERE are.FSourceBillEntryId=upd.FID ");
            sql.append("AND are.FParentID= ? ) ");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_IM_SaleIssueEntry SET FDrewBaseQty = sie.FDrewBaseQty + are.FBaseQty,");
            sql.append("FDrewQty = CASE  WHEN sie.FUnitID = are.FMeasureUnitID THEN (sie.FDrewQty + are.FQuantity) ");
            sql.append("ELSE ROUND(((sie.FDrewBaseQty + are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END,");
            sql.append("FAssociateQty = sie.FAssociateQty - are.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_IM_SaleIssueEntry SET FDrewBaseQty = sie.FDrewBaseQty - are.FBaseQty,");
            sql.append("FDrewQty = CASE  WHEN sie.FUnitID = are.FMeasureUnitID THEN (sie.FDrewQty - are.FQuantity) ");
            sql.append("ELSE ROUND(((sie.FDrewBaseQty - are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END,");
            sql.append("FAssociateQty = sie.FAssociateQty + are.FBaseQty ");
        }
        sql.append("FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId = sie.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = sie.FMaterialID AND mmu.FMeasureUnitID = sie.FUnitID) ");
        sql.append("WHERE (are.FParentID = ? AND T_IM_SaleIssueEntry.FID = sie.FID) ");
        return sql.toString();
    }

    public static String createAR2IC2SIWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_SaleIssueEntry upd SET (FDrewBaseQty,FDrewQty,FAssociateQty)= ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty+are.FQuantity ");
                sql.append("ELSE ROUND((sie.FDrewBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty-are.FBaseQty AS UIQ ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty-are.FQuantity ");
                sql.append("ELSE ROUND((sie.FDrewBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty+are.FBaseQty AS UIQ ");
            }
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=arice.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
            sql.append("WHERE are.FParentID= ? ");
            sql.append("AND upd.FID=sie.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are WHERE are.FSourceBillEntryId=upd.FID ");
            sql.append("AND are.FParentID= ? ) ");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_SaleIssueEntry upd SET (FDrewBaseQty,FDrewQty,FAssociateQty)= ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty+are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty-are.FBaseQty AS UIQ ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT sie.FDrewBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty-are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("sie.FAssociateQty+are.FBaseQty AS UIQ ");
            }
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=arice.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
            sql.append("WHERE are.FParentID= ? ");
            sql.append("AND upd.FID=sie.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are WHERE are.FSourceBillEntryId=upd.FID ");
            sql.append("AND are.FParentID= ? ) ");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_IM_SaleIssueEntry SET FDrewBaseQty = sie.FDrewBaseQty + are.FBaseQty,");
            sql.append("FDrewQty = CASE  WHEN sie.FUnitID = are.FMeasureUnitID THEN (sie.FDrewQty + are.FQuantity) ");
            sql.append("ELSE ROUND(((sie.FDrewBaseQty + are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END,");
            sql.append("FAssociateQty = sie.FAssociateQty - are.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_IM_SaleIssueEntry SET FDrewBaseQty = sie.FDrewBaseQty - are.FBaseQty,");
            sql.append("FDrewQty = CASE  WHEN sie.FUnitID = are.FMeasureUnitID THEN (sie.FDrewQty - are.FQuantity) ");
            sql.append("ELSE ROUND(((sie.FDrewBaseQty - are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END,");
            sql.append("FAssociateQty = sie.FAssociateQty + are.FBaseQty ");
        }
        sql.append("FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
        sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=arice.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = sie.FMaterialID AND mmu.FMeasureUnitID = sie.FUnitID) ");
        sql.append("WHERE (are.FParentID = ? AND T_IM_SaleIssueEntry.FID = sie.FID) ");
        return sql.toString();
    }

    public static String createAR2SOWriteSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FTolInvoidBaseQty,FTotalInvoicedQty,FAssociateQty,FTotalArAmount)=");
        sql.append("(SELECT soe.FTolInvoidBaseQty+are.FBaseQty AS IBQ,");
        sql.append("CASE WHEN soe.FUnitID=are.FMeasureUnitID THEN soe.FTotalInvoicedQty+are.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL((soe.FTolInvoidBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
        sql.append("soe.FAssociateQty-are.FBaseQty AS UIQ,");
        sql.append("soe.FTotalArAmount+are.FRecievePayAmount AS INM ");
        sql.append("FROM T_SD_SaleOrderEntry soe ");
        sql.append("INNER JOIN ");
        sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
        sql.append("are ON are.FCoreBillEntryId=soe.FID ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
        sql.append("WHERE are.FParentID=?");
        sql.append(" AND T1.FID=soe.FID)");
        return sql.toString();
    }

    public static String createAR2SOArClosedStatusWriteSQL(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SD_SaleOrderEntry as upd ");
        sql.append(" set (FArClosedStatus) = ");
        sql.append(" (select max(case when soe.FTotalInvoicedQty>=soe.FQty then 1 else 0 end) as FArClosedStatus ");
        sql.append(" from T_SD_SaleOrderEntry soe ");
        sql.append(" inner join(select FID,FParentID,FCoreBillEntryID FROM T_AR_OtherBillEntry WHERE FParentID = ?) as are on are.FCoreBillEntryID = soe.FID ");
        sql.append(" where are.FParentID = ? and soe.FID=upd.FID) ");
        return sql.toString();
    }

    public static String createAR2SOArClosedStatusWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SD_SaleOrderEntry as upd set FArClosedStatus = ");
        sql.append(" (case when upd.FQty > upd.FTotalIssueQty and upd.FTotalInvoicedQty >= upd.FQty then 1");
        sql.append(" when upd.FQty <= upd.FTotalIssueQty and upd.FTotalInvoicedQty >= upd.FTotalIssueQty then 1 else 0 end)");
        sql.append(" where upd.FID in (select FCoreBillEntryId from ").append(temptable).append(")");
        return sql.toString();
    }

    public static String createAR2SOWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_SD_SaleOrderEntry upd SET ");
            sql.append("(FTolInvoidBaseQty,FTotalInvoicedQty,FAssociateQty,FTotalArAmount)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT soe.FTolInvoidBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN soe.FUnitID=are.FMeasureUnitID THEN soe.FTotalInvoicedQty+are.FQuantity ");
                sql.append("ELSE ROUND((soe.FTolInvoidBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FAssociateQty-are.FBaseQty AS UIQ,");
                sql.append("soe.FTotalArAmount+are.FRecievePayAmount AS INM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT soe.FTolInvoidBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN soe.FUnitID=are.FMeasureUnitID THEN soe.FTotalInvoicedQty-are.FQuantity ");
                sql.append("ELSE ROUND((soe.FTolInvoidBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FAssociateQty+are.FBaseQty AS UIQ,");
                sql.append("soe.FTotalArAmount-are.FRecievePayAmount AS INM ");
            }
            sql.append("FROM T_SD_SaleOrderEntry soe ");
            sql.append(" INNER JOIN T_SD_SaleOrder so ON so.FId=soe.FParentId ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
            sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("are ON are.FCoreBillEntryId=soe.FID ");
            sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
            sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentId=ar.FID ");
            sql.append("WHERE are.FParentID=? ");
            sql.append("AND upd.FID=soe.FID AND ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("WHERE upd.FID=are.FCoreBillEntryId ");
            sql.append("AND are.FParentID=? )");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_SD_SaleOrderEntry upd SET ");
            sql.append("(FTolInvoidBaseQty,FTotalInvoicedQty,FAssociateQty,FTotalArAmount)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT soe.FTolInvoidBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN soe.FUnitID=are.FMeasureUnitID THEN soe.FTotalInvoicedQty+are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((soe.FTolInvoidBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FAssociateQty-are.FBaseQty AS UIQ,");
                sql.append("soe.FTotalArAmount+are.FRecievePayAmount AS INM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT soe.FTolInvoidBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN soe.FUnitID=are.FMeasureUnitID THEN soe.FTotalInvoicedQty-are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((soe.FTolInvoidBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FAssociateQty+are.FBaseQty AS UIQ,");
                sql.append("soe.FTotalArAmount-are.FRecievePayAmount AS INM ");
            }
            sql.append("FROM T_SD_SaleOrderEntry soe ");
            sql.append(" INNER JOIN T_SD_SaleOrder so ON so.FId=soe.FParentId ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
            sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("are ON are.FCoreBillEntryId=soe.FID ");
            sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
            sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentId=ar.FID ");
            sql.append("WHERE are.FParentID=? ");
            sql.append("AND upd.FID=soe.FID AND ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("WHERE upd.FID=are.FCoreBillEntryId ");
            sql.append("AND are.FParentID=? )");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_SD_SaleOrderEntry SET FTolInvoidBaseQty = soe.FTolInvoidBaseQty + are.FBaseQty, ");
            sql.append("FTotalInvoicedQty = CASE  WHEN soe.FUnitID = are.FMeasureUnitID THEN (soe.FTotalInvoicedQty + are.FQuantity) ");
            sql.append("ELSE ROUND(((soe.FTolInvoidBaseQty + are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END, ");
            sql.append("FAssociateQty = soe.FAssociateQty-are.FBaseQty,");
            sql.append("FTotalArAmount = soe.FTotalArAmount + are.FRecievePayAmount ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_SD_SaleOrderEntry SET FTolInvoidBaseQty = soe.FTolInvoidBaseQty - are.FBaseQty, ");
            sql.append("FTotalInvoicedQty = CASE  WHEN soe.FUnitID = are.FMeasureUnitID THEN (soe.FTotalInvoicedQty - are.FQuantity) ");
            sql.append("ELSE ROUND(((soe.FTolInvoidBaseQty - are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END, ");
            sql.append("FAssociateQty = soe.FAssociateQty+are.FBaseQty,");
            sql.append("FTotalArAmount = soe.FTotalArAmount - are.FRecievePayAmount ");
        }
        sql.append("FROM T_SD_SaleOrderEntry soe ");
        sql.append(" INNER JOIN T_SD_SaleOrder so ON so.FId=soe.FParentId ");
        sql.append("INNER JOIN (SELECT FParentID, FCoreBillEntryId, FMeasureUnitID, SUM(FBaseQty) FBASEQTY, ");
        sql.append("SUM(FQuantity) FQUANTITY, SUM(FRecievePayAmount) FRECIEVEPAYAMOUNT ");
        sql.append("FROM T_AR_OtherBillEntry WHERE FParentID = ? ");
        sql.append("GROUP BY FParentID, FCoreBillEntryId, FMeasureUnitID) ");
        sql.append("are ON are.FCoreBillEntryId = soe.FID ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = soe.FMaterialID AND mmu.FMeasureUnitID = soe.FUnitID) ");
        sql.append("WHERE (are.FParentID = ? AND T_SD_SaleOrderEntry.FID = soe.FID AND ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ) ");
        return sql.toString();
    }

    public static String createAR2CIWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_CHA_CHANNELSALEISSUEENTRY CSC SET ");
        sql.append("(FConfirmQty,FConfirmBaseQty,FConfirmDate)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT CSC.FCONFIRMQTY+CIC.FQTY,CSC.FConfirmBaseQty+CIC.FBASEQTY,CIC.FAUDITTIME ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT CSC.FCONFIRMQTY-CIC.FQTY,CSC.FConfirmBaseQty-CIC.FBASEQTY,CIC.FAUDITTIME ");
        }
        sql.append(" FROM T_CHA_CHANNELINWAREHSBILLENTRY CIC ");
        sql.append(" INNER JOIN T_CHA_CHANNELINWAREHSBILL CIP ON CIC.FPARENTID = CIP.FID ");
        sql.append(" WHERE CSC.FPARENTID = CIC.FSOURCEBILLID AND CSC.FID = CIC.FSOURCEBILLENTRYID) ");
        sql.append(" WHERE CSC.FPARENTID = ? ");
        return sql.toString();
    }

    public static String createAR2SRWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_SD_SaleReturnsEntry upd SET (FInvoicedBaseQty,FInvoicedQty,FInvoicePrice)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT CASE WHEN ar.FIsReverseBill = 1 THEN ");
                sql.append("   ABS(sre.FInvoicedBaseQty)-are.FBaseQty ");
                sql.append(" ELSE ");
                sql.append("   ABS(sre.FInvoicedBaseQty)+ABS(are.FBaseQty) END AS IBQ,");
                sql.append(" CASE WHEN  ar.FIsReverseBill = 1 THEN ");
                sql.append("    CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)-are.FQuantity ");
                sql.append("    ELSE ROUND((ABS(sre.FInvoicedBaseQty)-are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
                sql.append(" ELSE ");
                sql.append("    CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)+ABS(are.FQuantity) ");
                sql.append("    ELSE ROUND((ABS(sre.FInvoicedBaseQty)+ABS(are.FBaseQty))/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
                sql.append(" END AS QTY,");
                sql.append(" CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicePrice)-are.FRecievePayAmount ");
                sql.append(" ELSE  ABS(sre.FInvoicePrice)+ABS(are.FRecievePayAmount) END AS INM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT CASE WHEN ar.FIsReverseBill = 1 THEN ");
                sql.append("   ABS(sre.FInvoicedBaseQty)+are.FBaseQty ");
                sql.append(" ELSE ");
                sql.append("   ABS(sre.FInvoicedBaseQty)-ABS(are.FBaseQty) END AS IBQ,");
                sql.append(" CASE WHEN  ar.FIsReverseBill = 1 THEN ");
                sql.append("    CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)+are.FQuantity ");
                sql.append("    ELSE ROUND((ABS(sre.FInvoicedBaseQty)+are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
                sql.append(" ELSE ");
                sql.append("    CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)-ABS(are.FQuantity) ");
                sql.append("    ELSE ROUND((ABS(sre.FInvoicedBaseQty)-ABS(are.FBaseQty))/mmu.FBaseConvsRate,mmu.FQtyPrecision) END ");
                sql.append(" END AS QTY,");
                sql.append(" CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicePrice)+are.FRecievePayAmount ");
                sql.append(" ELSE ABS(sre.FInvoicePrice)-ABS(are.FRecievePayAmount) END AS INM ");
            }
            sql.append("FROM T_SD_SaleReturnsEntry sre ");
            sql.append(" INNER JOIN T_SD_SaleReturns sr ON sr.FId=sre.FParentId ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
            sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("are ON are.FCoreBillEntryId=sre.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
            sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentId=ar.FID ");
            sql.append("WHERE are.FParentID=?");
            sql.append(" AND upd.FID=sre.FID and ((sr.FIsCentralBalance = 1 and ar.FCompanyId = sr.FCompanyOrgUnitID) or (sr.FIsCentralBalance = 0 and ar.FCompanyId = sre.FCompanyOrgUnitID)) ) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("WHERE are.FCoreBillEntryId=upd.FID ");
            sql.append("AND are.FParentID=?)");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_SD_SaleReturnsEntry upd SET (FInvoicedBaseQty,FInvoicedQty,FInvoicePrice)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT CASE WHEN ar.FIsReverseBill = 1 THEN ");
                sql.append("   ABS(sre.FInvoicedBaseQty)-are.FBaseQty ");
                sql.append(" ELSE ABS(sre.FInvoicedBaseQty)+ABS(are.FBaseQty) END AS IBQ,");
                sql.append(" CASE WHEN ar.FIsReverseBill = 1 THEN ");
                sql.append("    CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)-are.FQuantity ");
                sql.append("    ELSE ROUND(DECIMAL((ABS(sre.FInvoicedBaseQty)-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END ");
                sql.append(" ELSE ");
                sql.append("    CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)+ABS(are.FQuantity) ");
                sql.append("    ELSE ROUND(DECIMAL((ABS(sre.FInvoicedBaseQty)+ABS(are.FBaseQty))/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END ");
                sql.append(" END AS QTY,");
                sql.append(" CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicePrice)-are.FRecievePayAmount ");
                sql.append(" ELSE ABS(sre.FInvoicePrice)+ABS(are.FRecievePayAmount) END AS INM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicedBaseQty)+are.FBaseQty");
                sql.append(" ELSE ABS(sre.FInvoicedBaseQty)-ABS(are.FBaseQty) END AS IBQ,");
                sql.append(" CASE WHEN ar.FIsReverseBill = 1 THEN ");
                sql.append("   CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)+are.FQuantity ");
                sql.append("   ELSE ROUND(DECIMAL((ABS(sre.FInvoicedBaseQty)+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END ");
                sql.append(" ELSE ");
                sql.append("   CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(sre.FInvoicedQty)-ABS(are.FQuantity) ");
                sql.append("   ELSE ROUND(DECIMAL((ABS(sre.FInvoicedBaseQty)-ABS(are.FBaseQty))/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END ");
                sql.append(" END AS QTY,");
                sql.append(" CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicePrice)+are.FRecievePayAmount ");
                sql.append(" ELSE ABS(sre.FInvoicePrice)-ABS(are.FRecievePayAmount) END AS INM ");
            }
            sql.append("FROM T_SD_SaleReturnsEntry sre ");
            sql.append(" INNER JOIN T_SD_SaleReturns sr ON sr.FId=sre.FParentId ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
            sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("are ON are.FCoreBillEntryId=sre.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
            sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentId=ar.FID ");
            sql.append("WHERE are.FParentID=?");
            sql.append(" AND upd.FID=sre.FID and ((sr.FIsCentralBalance = 1 and ar.FCompanyId = sr.FCompanyOrgUnitID) or (sr.FIsCentralBalance = 0 and ar.FCompanyId = sre.FCompanyOrgUnitID)) ) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("WHERE are.FCoreBillEntryId=upd.FID ");
            sql.append("AND are.FParentID=?)");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_SD_SaleReturnsEntry SET ");
            sql.append(" FInvoicedBaseQty = CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicedBaseQty) - are.FBaseQty ");
            sql.append(" ELSE ABS(sre.FInvoicedBaseQty) + ABS(are.FBaseQty) END, ");
            sql.append(" FInvoicedQty = CASE WHEN ar.FIsReverseBill = 1 THEN ");
            sql.append("   CASE  WHEN sre.FUnitID = are.FMeasureUnitID THEN (ABS(sre.FInvoicedQty) - are.FQuantity) ");
            sql.append("   ELSE ROUND(((ABS(sre.FInvoicedBaseQty) - are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END ");
            sql.append(" ELSE ");
            sql.append("   CASE  WHEN sre.FUnitID = are.FMeasureUnitID THEN (ABS(sre.FInvoicedQty) + ABS(are.FQuantity)) ");
            sql.append("   ELSE ROUND(((ABS(sre.FInvoicedBaseQty) + ABS(are.FBaseQty)) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END END,");
            sql.append(" FInvoicePrice = CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicePrice) - are.FRecievePayAmount ELSE ");
            sql.append(" ABS(sre.FInvoicePrice) + ABS(are.FRecievePayAmount) END ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_SD_SaleReturnsEntry SET ");
            sql.append("FInvoicedBaseQty = CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicedBaseQty) + are.FBaseQty ");
            sql.append(" ELSE ABS(sre.FInvoicedBaseQty) - ABS(are.FBaseQty) END, ");
            sql.append("FInvoicedQty = CASE WHEN ar.FIsReverseBill = 1 THEN ");
            sql.append("   CASE  WHEN sre.FUnitID = are.FMeasureUnitID THEN (ABS(sre.FInvoicedQty) + are.FQuantity) ");
            sql.append("   ELSE ROUND(((ABS(sre.FInvoicedBaseQty) + are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END ");
            sql.append(" ELSE ");
            sql.append("   CASE  WHEN sre.FUnitID = are.FMeasureUnitID THEN (ABS(sre.FInvoicedQty) - ABS(are.FQuantity)) ");
            sql.append("   ELSE ROUND(((ABS(sre.FInvoicedBaseQty) - ABS(are.FBaseQty)) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END END,");
            sql.append("FInvoicePrice = CASE WHEN ar.FIsReverseBill = 1 THEN ABS(sre.FInvoicePrice) + are.FRecievePayAmount ELSE ");
            sql.append(" ABS(sre.FInvoicePrice) - ABS(are.FRecievePayAmount) END ");
        }
        sql.append("FROM T_SD_SaleReturnsEntry sre ");
        sql.append(" INNER JOIN T_SD_SaleReturns sr ON sr.FId=sre.FParentId ");
        sql.append("INNER JOIN (SELECT FParentID, FCoreBillEntryId, FMeasureUnitID, SUM(FBaseQty) FBASEQTY,");
        sql.append("SUM(FQuantity) FQUANTITY, SUM(FRecievePayAmount) FRECIEVEPAYAMOUNT ");
        sql.append("FROM T_AR_OtherBillEntry WHERE FParentID = ? ");
        sql.append("GROUP BY FParentID, FCoreBillEntryId, FMeasureUnitID) ");
        sql.append("are ON are.FCoreBillEntryId = sre.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = sre.FMaterialID AND mmu.FMeasureUnitID = sre.FUnitID) ");
        sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentId=ar.FID ");
        sql.append("WHERE (are.FParentID = ? AND T_SD_SaleReturnsEntry.FID = sre.FID and ((sr.FIsCentralBalance = 1 and ar.FCompanyId = sr.FCompanyOrgUnitID) or (sr.FIsCentralBalance = 0 and ar.FCompanyId = sre.FCompanyOrgUnitID)) )");
        return sql.toString();
    }

    public static String createAR2STWriteSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockTransferBillEntry SET (FSaleInvoiceBaseQty,FSaleInvoiceQty,FSaleInvoiceAmount)=");
        sql.append("(SELECT ste.FSaleInvoiceBaseQty+are.FBaseQty AS IBQ,");
        sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty+are.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL((ste.FSaleInvoiceBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
        sql.append("ste.FSaleInvoiceAmount+are.FRecievePayAmount AS INM ");
        sql.append("FROM T_IM_StockTransferBillEntry ste ");
        sql.append("INNER JOIN ");
        sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
        sql.append("are ON are.FCoreBillEntryId=ste.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ste.FMaterialID AND mmu.FMeasureUnitID=ste.FUnitID ");
        sql.append("WHERE are.FParentID=?");
        sql.append(" AND T_IM_StockTransferBillEntry.FID=ste.FID)");
        return sql.toString();
    }

    public static String createAR2STWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_StockTransferBillEntry upd SET (FSaleInvoiceBaseQty,FSaleInvoiceQty,FSaleInvoiceAmount)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT ste.FSaleInvoiceBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty+are.FQuantity ");
                sql.append("ELSE ROUND((ste.FSaleInvoiceBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("ste.FSaleInvoiceAmount+are.FRecievePayAmount AS INM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT ste.FSaleInvoiceBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty-are.FQuantity ");
                sql.append("ELSE ROUND((ste.FSaleInvoiceBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("ste.FSaleInvoiceAmount-are.FRecievePayAmount AS INM ");
            }
            sql.append("FROM T_IM_StockTransferBillEntry ste ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
            sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("are ON are.FCoreBillEntryId=ste.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ste.FMaterialID AND mmu.FMeasureUnitID=ste.FUnitID ");
            sql.append("WHERE are.FParentID=? ");
            sql.append("AND upd.FID=ste.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("WHERE are.FCoreBillEntryId=upd.FID ");
            sql.append("AND are.FParentID=? )");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_StockTransferBillEntry upd SET (FSaleInvoiceBaseQty,FSaleInvoiceQty,FSaleInvoiceAmount)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT ste.FSaleInvoiceBaseQty+are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty+are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((ste.FSaleInvoiceBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("ste.FSaleInvoiceAmount+are.FRecievePayAmount AS INM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT ste.FSaleInvoiceBaseQty-are.FBaseQty AS IBQ,");
                sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty-are.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((ste.FSaleInvoiceBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("ste.FSaleInvoiceAmount-are.FRecievePayAmount AS INM ");
            }
            sql.append("FROM T_IM_StockTransferBillEntry ste ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
            sql.append("FROM T_AR_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("are ON are.FCoreBillEntryId=ste.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ste.FMaterialID AND mmu.FMeasureUnitID=ste.FUnitID ");
            sql.append("WHERE are.FParentID=? ");
            sql.append("AND upd.FID=ste.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_OtherBillEntry are ");
            sql.append("WHERE are.FCoreBillEntryId=upd.FID ");
            sql.append("AND are.FParentID=? )");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_SD_SaleReturnsEntry SET FInvoicedBaseQty = sre.FInvoicedBaseQty + are.FBaseQty, ");
            sql.append("FInvoicedQty = CASE  WHEN sre.FUnitID = are.FMeasureUnitID THEN (sre.FInvoicedQty + are.FQuantity) ");
            sql.append("ELSE ROUND(((sre.FInvoicedBaseQty + are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END,");
            sql.append("FInvoicePrice = sre.FInvoicePrice + are.FRecievePayAmount ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_SD_SaleReturnsEntry SET FInvoicedBaseQty = sre.FInvoicedBaseQty - are.FBaseQty, ");
            sql.append("FInvoicedQty = CASE  WHEN sre.FUnitID = are.FMeasureUnitID THEN (sre.FInvoicedQty - are.FQuantity) ");
            sql.append("ELSE ROUND(((sre.FInvoicedBaseQty - are.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END,");
            sql.append("FInvoicePrice = sre.FInvoicePrice - are.FRecievePayAmount ");
        }
        sql.append("FROM T_SD_SaleReturnsEntry sre ");
        sql.append("INNER JOIN (SELECT FParentID, FCoreBillEntryId, FMeasureUnitID, SUM(FBaseQty) FBASEQTY,");
        sql.append("SUM(FQuantity) FQUANTITY, SUM(FRecievePayAmount) FRECIEVEPAYAMOUNT ");
        sql.append("FROM T_AR_OtherBillEntry WHERE FParentID = ? ");
        sql.append("GROUP BY FParentID, FCoreBillEntryId, FMeasureUnitID) ");
        sql.append("are ON are.FCoreBillEntryId = sre.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = sre.FMaterialID AND mmu.FMeasureUnitID = sre.FUnitID) ");
        sql.append("WHERE (are.FParentID = ? AND T_SD_SaleReturnsEntry.FID = sre.FID)");
        return sql.toString();
    }

    public static String createAPWriteBackVerifySQL(String id, boolean[] isWriteCore, List params, boolean isPurInvSysParam, boolean isApQtyGtPoSysParam, boolean isBefore) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            // empty if block
        }
        if (isWriteCore[1]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 2 as FErrType, ap.FNumber, ape.FSeq, po.FNumber AS FWBNumber, poe.FSeq AS FWBSeq ");
            sql.append("FROM T_SM_PurOrderEntry poe ");
            sql.append("INNER JOIN T_SM_PurOrder po ON po.FID=poe.FParentID ");
            sql.append("INNER JOIN T_AP_OtherBillEntry ape ON ape.FCoreBillEntryId=poe.FID ");
            sql.append("INNER JOIN T_AP_OtherBill ap ON ap.FID=ape.FParentID ");
            sql.append("WHERE ap.FID=? ");
            sql.append("AND ape.FCoreBillEntryId IN( ");
            sql.append("SELECT ape.FCoreBillEntryId ");
            sql.append("FROM T_AP_OtherBillEntry ape ");
            sql.append("INNER JOIN T_SM_PurOrderEntry poe ON ape.FCoreBillEntryId=poe.FID ");
            sql.append("WHERE ape.FParentID = ? ");
            if (isBefore) {
                if (isPurInvSysParam) {
                    sql.append("GROUP BY ape.FCoreBillEntryId,poe.FTotalReceiptBaseQty,poe.FTotalInvoicedBaseQty,poe.FBaseQty ");
                    sql.append("HAVING ");
                    sql.append("SUM(ape.FbaseQty) > poe.FTotalReceiptBaseQty - poe.FTotalInvoicedBaseQty ");
                } else if (!isApQtyGtPoSysParam) {
                    sql.append("GROUP BY ape.FCoreBillEntryId,poe.FTotalReceiptBaseQty,poe.FTotalInvoicedBaseQty,poe.FBaseQty ");
                    sql.append("HAVING ");
                    sql.append("((poe.FTotalReceiptBaseQty > poe.FBaseQty AND SUM(ape.FbaseQty) > poe.FTotalReceiptBaseQty - poe.FTotalInvoicedBaseQty) ");
                    sql.append("OR ");
                    sql.append("(poe.FTotalReceiptBaseQty <= poe.FBaseQty AND SUM(ape.FbaseQty) > poe.FBaseQty - poe.FTotalInvoicedBaseQty))");
                } else {
                    sql.append(" AND (1=0) ");
                }
            } else if (isPurInvSysParam) {
                sql.append("AND ");
                sql.append("poe.FTotalReceiptBaseQty < poe.FTotalInvoicedBaseQty");
            } else if (!isApQtyGtPoSysParam) {
                sql.append("AND ");
                sql.append("((poe.FBaseQty >= poe.FTotalReceiptBaseQty AND poe.FBaseQty < poe.FTotalInvoicedBaseQty) ");
                sql.append("OR ");
                sql.append("(poe.FBaseQty < poe.FTotalReceiptBaseQty AND poe.FTotalReceiptBaseQty < poe.FTotalInvoicedBaseQty))");
            } else {
                sql.append(" AND (1=0) ");
            }
            sql.append(")");
            params.add(id);
            params.add(id);
        }
        if (isWriteCore[2]) {
            // empty if block
        }
        if (isWriteCore[3]) {
            // empty if block
        }
        if (isWriteCore.length >= 5 && isWriteCore[4]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 5 as FErrType, ap.FNumber, ape.FSeq, sco.FNumber AS FWBNumber, scoe.FSeq AS FWBSeq ");
            sql.append("FROM T_SM_SubContractOrderEntry scoe ");
            sql.append("INNER JOIN T_SM_SubContractOrder sco ON sco.FID=scoe.FParentID ");
            sql.append("INNER JOIN T_AP_OtherBillEntry ape ON ape.FCoreBillEntryId=scoe.FID ");
            sql.append("INNER JOIN T_AP_OtherBill ap ON ap.FID=ape.FParentID ");
            sql.append("WHERE ap.FID=? ");
            sql.append("AND ape.FCoreBillEntryId IN( ");
            sql.append("SELECT ape.FCoreBillEntryId ");
            sql.append("FROM T_AP_OtherBillEntry ape ");
            sql.append("INNER JOIN T_SM_SubContractOrderEntry scoe ON ape.FCoreBillEntryId=scoe.FID ");
            sql.append("WHERE ape.FParentID = ? ");
            if (isBefore) {
                if (isPurInvSysParam) {
                    sql.append("GROUP BY ape.FCoreBillEntryId,scoe.FTotalReceiptBaseQty,scoe.FTotalApBaseQty,scoe.FBaseQty ");
                    sql.append("HAVING ");
                    sql.append("SUM(ape.FbaseQty) > scoe.FTotalReceiptBaseQty - scoe.FTotalApBaseQty ");
                } else if (!isApQtyGtPoSysParam) {
                    sql.append("GROUP BY ape.FCoreBillEntryId,scoe.FTotalReceiptBaseQty,scoe.FTotalApBaseQty,scoe.FBaseQty ");
                    sql.append("HAVING ");
                    sql.append("((scoe.FTotalReceiptBaseQty > scoe.FBaseQty AND SUM(ape.FbaseQty) > scoe.FTotalReceiptBaseQty - scoe.FTotalApBaseQty) ");
                    sql.append("OR ");
                    sql.append("(scoe.FTotalReceiptBaseQty <= scoe.FBaseQty AND SUM(ape.FbaseQty) > scoe.FBaseQty - scoe.FTotalApBaseQty))");
                } else {
                    sql.append(" AND (1=0) ");
                }
            } else if (isPurInvSysParam) {
                sql.append("AND ");
                sql.append("scoe.FTotalReceiptBaseQty < scoe.FTotalApBaseQty ");
            } else if (!isApQtyGtPoSysParam) {
                sql.append("AND ");
                sql.append("((scoe.FBaseQty >= scoe.FTotalReceiptBaseQty AND scoe.FBaseQty < scoe.FTotalApBaseQty) ");
                sql.append("OR ");
                sql.append("(scoe.FBaseQty < scoe.FTotalReceiptBaseQty AND scoe.FTotalReceiptBaseQty < scoe.FTotalApBaseQty))");
            } else {
                sql.append(" AND (1=0) ");
            }
            sql.append(")");
            params.add(id);
            params.add(id);
        }
        return sql.toString();
    }

    public static boolean getPurInvSysParam(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String strCompanyID = null;
        if (company != null && company instanceof CompanyOrgUnitInfo && company.getId() != null) {
            strCompanyID = company.getId().toString();
        }
        return WriteBackSQLHelper.isSysParamValue(ctx, strCompanyID, "PURSUP006", false);
    }

    public static boolean getApQtyGtPoSysParam(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String strCompanyID = null;
        if (company != null && company instanceof CompanyOrgUnitInfo && company.getId() != null) {
            strCompanyID = company.getId().toString();
        }
        return WriteBackSQLHelper.isSysParamValue(ctx, strCompanyID, "AP_QTY_GT_PO", false);
    }

    public static boolean getArQtyGtSoSysParam(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String strCompanyID = null;
        if (company != null && company instanceof CompanyOrgUnitInfo && company.getId() != null) {
            strCompanyID = company.getId().toString();
        }
        return WriteBackSQLHelper.isSysParamValue(ctx, strCompanyID, "AR_QTY_GT_SO", true);
    }

    public static boolean isSysParamValue(Context ctx, String mainOrgUnitID, String paramNumber, boolean defaultValue) throws EASBizException, BOSException {
        IParamControl ipc;
        String strSysParamValue;
        boolean isSysParamValue = defaultValue;
        ObjectUuidPK mainOrgUnitPK = null;
        if (mainOrgUnitID != null) {
            mainOrgUnitPK = new ObjectUuidPK(mainOrgUnitID);
        }
        if ("true".equalsIgnoreCase(strSysParamValue = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)mainOrgUnitPK, paramNumber))) {
            isSysParamValue = true;
        } else if ("false".equalsIgnoreCase(strSysParamValue)) {
            isSysParamValue = false;
        }
        return isSysParamValue;
    }

    public static void verifyAPWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"APAR_WBERROR", (Locale)ctx.getLocale())).append("\n");
        sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"APNO", (Locale)ctx.getLocale())).append("\t");
        sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"SEQNO", (Locale)ctx.getLocale())).append("\t");
        sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"WBResource.WBNO", (Locale)ctx.getLocale())).append("\t\t");
        sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"SEQNO", (Locale)ctx.getLocale())).append("\n");
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            sql.append(rs.getString("FNumber")).append("\t");
            sql.append(rs.getInt("FSeq")).append("\t");
            switch (rs.getInt("FErrType")) {
                case 1: {
                    break;
                }
                case 2: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"PURORDER", (Locale)ctx.getLocale()));
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    sql.append(ResourceBase.getString((String)WBRESOURCE, (String)"TRANSFERORDER", (Locale)ctx.getLocale()));
                }
            }
            sql.append(":").append(rs.getString("FWBNumber")).append("\t\t");
            sql.append(rs.getInt("FWBSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String createAP2POWriteSQL(BizActionEnum bizAction, boolean isPurInvSysParam) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SM_PurOrderEntry AS T1 SET (FTtalInvoicedBaseQty,FTotalInvoicedQty,FAssociateQty,FTotalInvoicedAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT poe.FTotalInvoicedBaseQty+ape.FBaseQty AS IBQ,");
            sql.append("CASE WHEN poe.FUnitID=ape.FMeasureUnitID THEN poe.FTotalInvoicedQty+ape.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((poe.FTotalInvoicedBaseQty+DECIMAL(ape.FBaseQty,21,8))/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
            if (isPurInvSysParam) {
                sql.append("poe.FTotalReceiptBaseQty - (poe.FTotalInvoicedBaseQty + ape.FBaseQty) AS UIQ,");
            } else {
                sql.append("poe.FAssociateQty - ape.FBaseQty AS UIQ,");
            }
            sql.append("poe.FTotalInvoicedAmount+ape.FRecievePayAmount AS INM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT poe.FTotalInvoicedBaseQty-ape.FBaseQty AS IBQ,");
            sql.append("CASE WHEN poe.FUnitID=ape.FMeasureUnitID THEN poe.FTotalInvoicedQty-ape.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((poe.FTotalInvoicedBaseQty-DECIMAL(ape.FBaseQty,21,8))/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
            sql.append("poe.FAssociateQty + ape.FBaseQty AS UIQ,");
            sql.append("poe.FTotalInvoicedAmount-ape.FRecievePayAmount AS INM ");
        }
        sql.append("FROM T_SM_PurOrderEntry poe ");
        sql.append("INNER JOIN (SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AP_OtherBillEntry WHERE FParentID=? ");
        sql.append("GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
        sql.append("ape ON ape.FCoreBillEntryId=poe.FID ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=poe.FMaterialID AND mmu.FMeasureUnitID=poe.FUnitID ");
        sql.append("WHERE ape.FParentID=? ");
        sql.append("AND T1.FID=poe.FID)");
        return sql.toString();
    }

    public static String createAP2POWriteSQLDialect(BizActionEnum bizAction, Context ctx, boolean isPurInvSysParam) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SM_PurOrderEntry upd SET (FTotalInvoicedBaseQty,FTotalInvoicedQty,FAssociateQty,FTotalInvoicedAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT isnull(upd.FTotalInvoicedBaseQty,0)+tmp.FBaseQty AS IBQ,");
            sql.append("isnull(upd.FTotalInvoicedQty,0)+tmp.FQuantity AS QTY,");
            sql.append("isnull(upd.FAssociateQty,0) - tmp.FBaseQty AS UIQ,");
            sql.append("isnull(upd.FTotalInvoicedAmount,0)+tmp.FRecievePayAmount AS INM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT isnull(upd.FTotalInvoicedBaseQty,0)-tmp.FBaseQty AS IBQ,");
            sql.append("isnull(upd.FTotalInvoicedQty,0)-tmp.FQuantity AS QTY,");
            sql.append("isnull(upd.FAssociateQty,0) + tmp.FBaseQty AS UIQ,");
            sql.append("isnull(upd.FTotalInvoicedAmount,0)-tmp.FRecievePayAmount AS INM ");
        }
        sql.append("from (select FID,sum(FBaseQty) as FBaseQty,sum(FQuantity) as FQuantity,sum(FRecievePayAmount) as FRecievePayAmount ");
        sql.append("from (SELECT poe.FID AS FID,ape.FBaseQty AS FBaseQty,");
        sql.append("CASE WHEN poe.FUnitID=ape.FMeasureUnitID THEN ape.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL(ape.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS FQuantity,");
        sql.append("ape.FRecievePayAmount AS FRecievePayAmount ");
        sql.append("FROM T_SM_PurOrderEntry poe ");
        sql.append("INNER JOIN (SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AP_OtherBillEntry WHERE FParentID=? ");
        sql.append("GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
        sql.append("ape ON ape.FCoreBillEntryId=poe.FID ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=poe.FMaterialID AND mmu.FMeasureUnitID=poe.FUnitID ");
        sql.append(" INNER JOIN T_SM_PurOrder po on po.FID = poe.FParentID ");
        sql.append(" INNER JOIN T_AP_OtherBill ap on ap.FID = ape.FParentID ");
        sql.append("WHERE ((po.FIsCentralBalance = 1 and ap.FCompanyId = po.FCompanyOrgUnitID) or (po.FIsCentralBalance = 0 and ap.FCompanyId = poe.FCompanyOrgUnitID)) )t ");
        sql.append("group by FID)tmp where upd.FID = tmp.FID)");
        return sql.toString();
    }

    public static String createAP2SubOrderWriteSQLDialect(BizActionEnum bizAction, Context ctx, boolean isPurInvSysParam) {
        StringBuffer sql = new StringBuffer();
        char add = '+';
        char diff = '-';
        if (bizAction == BizActionEnum.UNAUDIT) {
            add = '-';
            diff = '+';
        }
        sql.append("UPDATE T_SM_SubContractOrderEntry upd SET (FTotalApBaseQty,FTotalApQty,FUnApBaseQty,FUnApQty,FAssociateQty,FTotalApAmount)=");
        sql.append("(SELECT ISNULL(upd.FTotalApBaseQty").append(add).append("tmp.FBaseQty,0) AS IBQ,");
        sql.append("upd.FTotalApQty").append(add).append("tmp.FQuantity as QTY,");
        if (isPurInvSysParam) {
            sql.append("upd.FTotalReceiptBaseQty - (upd.FTotalApBaseQty ").append(add).append(" tmp.FBaseQty) AS UIBQ,");
            sql.append("upd.FTotalReceiptQty - (upd.FTotalApQty ").append(add).append(" tmp.FQuantity) as  UIQ,");
            sql.append("upd.FTotalReceiptBaseQty - (upd.FTotalApBaseQty ").append(add).append(" tmp.FBaseQty) AS UIBQ2,");
        } else {
            sql.append("upd.FUnApBaseQty ").append(diff).append(" tmp.FBaseQty AS UIBQ,");
            sql.append("upd.FUnApQty ").append(add).append(" tmp.FQuantity as UIQ,");
            sql.append("upd.FAssociateQty ").append(diff).append(" tmp.FBaseQty AS UIBQ2,");
        }
        sql.append("upd.FTotalApAmount").append(add).append("tmp.FRecievePayAmount AS INM ");
        sql.append("from (select FID,sum(FBaseQty) as FBaseQty,sum(FQuantity) as FQuantity,sum(FRecievePayAmount) as FRecievePayAmount ");
        sql.append("from (SELECT poe.FID AS FID,ape.FBaseQty AS FBaseQty,");
        sql.append("CASE WHEN poe.FUnitID=ape.FMeasureUnitID THEN ape.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL(ape.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS FQuantity,");
        sql.append("ape.FRecievePayAmount AS FRecievePayAmount ");
        sql.append("FROM T_SM_SubContractOrderEntry poe ");
        sql.append("INNER JOIN (SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AP_OtherBillEntry WHERE FParentID=? ");
        sql.append("GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
        sql.append("ape ON ape.FCoreBillEntryId=poe.FID ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=poe.FMaterialID AND mmu.FMeasureUnitID=poe.FUnitID ");
        sql.append(" INNER JOIN T_SM_SubContractOrder po on po.FID = poe.FParentID ");
        sql.append(" INNER JOIN T_AP_OtherBill ap on ap.FID = ape.FParentID ");
        sql.append("WHERE ap.FCompanyId = po.FCompanyOrgUnitID)t ");
        sql.append("group by FID)tmp where upd.FID = tmp.FID) ");
        return sql.toString();
    }

    public static String createAP2PurReturnWriteSQL(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SM_PurReturnsEntry upd SET (FInvoicedBaseQty,FInvoicedQty,FInvoicedAmount,FUninvoicedQty,FUninvoicedBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ABS(upd.FInvoicedBaseQty)+tmp.FBaseQty AS IBQ,");
            sql.append("ABS(upd.FInvoicedQty)+tmp.FQuantity as QTY,");
            sql.append("ABS(upd.FInvoicedAmount)+tmp.FRecievePayAmount AS INM,");
            sql.append("ABS(upd.FUninvoicedQty) - tmp.FQuantity as UnInvQTY,");
            sql.append("ABS(upd.FUninvoicedBaseQty) - tmp.FBaseQty AS UnInvBaseQTY ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ABS(upd.FInvoicedBaseQty)-tmp.FBaseQty AS IBQ,");
            sql.append("ABS(upd.FInvoicedQty)-tmp.FQuantity as QTY,");
            sql.append("ABS(upd.FInvoicedAmount)-tmp.FRecievePayAmount AS INM,");
            sql.append("ABS(upd.FUninvoicedQty) + tmp.FQuantity as UnInvQTY,");
            sql.append("ABS(upd.FUninvoicedBaseQty) + tmp.FBaseQty AS UnInvBaseQTY ");
        }
        sql.append("from(select FID,sum(FBaseQty) as FBaseQty,sum(FQuantity) as FQuantity,sum(FRecievePayAmount) as FRecievePayAmount ");
        sql.append("from(SELECT sre.FID AS FID, ABS(are.FBaseQty) AS FBaseQty,");
        sql.append("CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(are.FQuantity) ");
        sql.append("ELSE ROUND(DECIMAL(ABS(are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS FQuantity,");
        sql.append("ABS(are.FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_SM_PurReturnsEntry sre ");
        sql.append("INNER JOIN ");
        sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AP_OtherBillEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
        sql.append("are ON are.FCoreBillEntryId=sre.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID )t ");
        sql.append(" group by FID )tmp where upd.FID = tmp.FID)");
        return sql.toString();
    }

    public static String createAP2PurInWriteSQL(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        return sql.toString();
    }

    public static String getDBType(Context ctx) {
        return (String)ctx.get((Object)"dbType");
    }

    public static String createAR2SIWriteSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_SaleIssueEntry SET (FDrewBaseQty,FDrewQty,FAssociateQty)= ");
        sql.append("(SELECT are.FBaseQty,");
        sql.append("are.FQuantity, ");
        sql.append("are.FAssociateQty ");
        sql.append("FROM ");
        sql.append(temptable);
        sql.append(" are WHERE T_IM_SaleIssueEntry.FID=are.FSourceBillEntryId)");
        return sql.toString();
    }

    public static String createIC2SIWriteSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_SaleIssueEntry SET (FTotalIncomeConfirmBaseQty,FTotalIncomeConfirmQty)= ");
        sql.append("(SELECT arice.FBaseQty,");
        sql.append("arice.FQuantity ");
        sql.append("FROM ");
        sql.append(temptable);
        sql.append(" arice WHERE T_IM_SaleIssueEntry.FID=arice.FSourceBillEntryId)");
        return sql.toString();
    }

    public static String createAR2SOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FTolInvoidBaseQty,FTotalInvoicedQty,FAssociateQty,FTotalArAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(select T1.FTolInvoidBaseQty+tmp.FBaseQty as IBQ,");
            sql.append(" T1.FTotalInvoicedQty+tmp.FQuantity as QTY,");
            sql.append("T1.FAssociateQty-tmp.FBaseQty as UIQ, ");
            sql.append("T1.FTotalArAmount+tmp.FRecievePayAmount AS INM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(select T1.FTolInvoidBaseQty-tmp.FBaseQty as IBQ,");
            sql.append(" T1.FTotalInvoicedQty-tmp.FQuantity as QTY, ");
            sql.append("T1.FAssociateQty+tmp.FBaseQty as UIQ,");
            sql.append("T1.FTotalArAmount-tmp.FRecievePayAmount AS INM ");
        }
        sql.append("from ");
        sql.append("(select FID,sum(FBaseQty) as FBaseQty,sum(FQuantity) as FQuantity,sum(FRecievePayAmount) as FRecievePayAmount from");
        sql.append("(SELECT soe.FID as FID, are.FBaseQty,");
        sql.append("CASE WHEN soe.FUnitID=are.FMeasureUnitID THEN are.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL(are.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS FQuantity,");
        sql.append("are.FRecievePayAmount FROM T_SD_SaleOrderEntry soe INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FCoreBillEntryId=soe.FID ");
        sql.append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
        sql.append(" INNER JOIN T_SD_SaleOrder so on so.FID  = soe.FParentID ");
        sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentID=ar.FID ");
        sql.append("WHERE ");
        sql.append(" ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID))  ");
        sql.append(" )t group by FID)tmp ");
        sql.append(" where ");
        sql.append("T1.FID=tmp.FID)");
        return sql.toString();
    }

    public static String createIC2SOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FTotalIncomeConfirmBaseQty,FTotalIncomeConfirmQty,FTotalIncomeConfirmAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(select T1.FTotalIncomeConfirmBaseQty+tmp.FBaseQty as IBQ,");
            sql.append(" T1.FTotalIncomeConfirmQty+tmp.FQuantity as QTY,");
            sql.append("T1.FTotalIncomeConfirmAmount+tmp.FIncomeConfimAmount AS INM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(select T1.FTotalIncomeConfirmBaseQty-tmp.FBaseQty as IBQ,");
            sql.append(" T1.FTotalIncomeConfirmQty-tmp.FQuantity as QTY, ");
            sql.append("T1.FTotalIncomeConfirmAmount-tmp.FIncomeConfimAmount AS INM ");
        }
        sql.append("from ");
        sql.append("(select FID,sum(FBaseQty) as FBaseQty,sum(FQuantity) as FQuantity,sum(FIncomeConfimAmount) as FIncomeConfimAmount from");
        sql.append("(SELECT soe.FID as FID, arice.FBaseQty,");
        sql.append("CASE WHEN soe.FUnitID=arice.FMeasureUnitID THEN arice.FQuantity ");
        sql.append("ELSE ROUND(DECIMAL(arice.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS FQuantity,");
        sql.append("arice.FIncomeConfimAmount FROM T_SD_SaleOrderEntry soe INNER JOIN ");
        sql.append(temptable);
        sql.append(" arice ON arice.FCoreBillEntryId=soe.FID ");
        sql.append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
        sql.append(" INNER JOIN T_SD_SaleOrder so on so.FID  = soe.FParentID ");
        sql.append(" INNER JOIN T_AR_INCOMECONFIMBILL ar ON arice.FParentID=ar.FID ");
        sql.append("WHERE ");
        sql.append(" ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID))  ");
        sql.append(" )t group by FID)tmp ");
        sql.append(" where ");
        sql.append("T1.FID=tmp.FID)");
        return sql.toString();
    }

    public static String createAR2CIWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_CHA_CHANNELSALEISSUEENTRY AS CSC SET ");
        sql.append("(FConfirmQty,FConfirmBaseQty,FConfirmDate)=");
        sql.append(" (SELECT FCONFIRMQTY, FCONFIRMBASEQTY,FCONFIRMDATE FROM ");
        sql.append(temptable);
        sql.append(" tmp WHERE tmp.FENTRYID = CSC.FID) ");
        return sql.toString();
    }

    public static String createAR2SRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleReturnsEntry AS T1 SET (FInvoicedBaseQty,FInvoicedQty,FInvoicePrice)=(");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("SELECT CASE WHEN tt.FIsReverseBill = 1 THEN ABS(T1.FInvoicedBaseQty) - tt.FBaseQty else ABS(T1.FInvoicedBaseQty) + tt.FBaseQty end as FInvoicedBaseQty,");
            sql.append("CASE WHEN tt.FIsReverseBill = 1 THEN ABS(T1.FInvoicedQty) - tt.FQuantity else ABS(T1.FInvoicedQty) + tt.FQuantity end as FInvoicedQty, ");
            sql.append("CASE WHEN tt.FIsReverseBill = 1 THEN ABS(T1.FInvoicePrice) - tt.FRecievePayAmount else ABS(T1.FInvoicePrice) + tt.FRecievePayAmount end as FInvoicePrice ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("SELECT CASE WHEN tt.FIsReverseBill = 1 THEN ABS(T1.FInvoicedBaseQty) + tt.FBaseQty else ABS(T1.FInvoicedBaseQty) - tt.FBaseQty end as FInvoicedBaseQty,");
            sql.append("CASE WHEN tt.FIsReverseBill = 1 THEN ABS(T1.FInvoicedQty) + tt.FQuantity else ABS(T1.FInvoicedQty) - tt.FQuantity end as FInvoicedQty, ");
            sql.append("CASE WHEN tt.FIsReverseBill = 1 THEN ABS(T1.FInvoicePrice) + tt.FRecievePayAmount else ABS(T1.FInvoicePrice) - tt.FRecievePayAmount end  as FInvoicePrice ");
        }
        sql.append("from (select FIsReverseBill, FID, sum(FBaseQty) as FBaseQty,sum(FQuantity) as FQuantity,sum(FRecievePayAmount) as FRecievePayAmount ");
        sql.append("from(");
        sql.append(" (SELECT ar.FIsReverseBill AS FIsReverseBill, sre.FID AS FID, ABS(are.FBaseQty) AS FBaseQty,");
        sql.append("CASE WHEN sre.FUnitID=are.FMeasureUnitID THEN ABS(are.FQuantity) ");
        sql.append("ELSE ROUND(DECIMAL(ABS(are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS FQuantity,");
        sql.append("ABS(are.FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_SD_SaleReturnsEntry sre ");
        sql.append(" INNER JOIN T_SD_SaleReturns sr ON sr.FId=sre.FParentId ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FCoreBillEntryId=sre.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append(" INNER JOIN T_AR_OtherBill ar ON are.FParentId=ar.FID ");
        sql.append(" WHERE ((sr.FIsCentralBalance = 1 and ar.FCompanyId = sr.FCompanyOrgUnitID) or (sr.FIsCentralBalance = 0 and ar.FCompanyId = sre.FCompanyOrgUnitID))");
        sql.append(" )");
        sql.append(") t GROUP BY FIsReverseBill, FID ) tt WHERE tt.fid = T1.fid )");
        return sql.toString();
    }

    public static String createAR2STWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockTransferBillEntry SET (FSaleInvoiceBaseQty,FSaleInvoiceQty,FSaleInvoiceAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ste.FSaleInvoiceBaseQty+are.FBaseQty AS IBQ,");
            sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty+are.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((ste.FSaleInvoiceBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
            sql.append("ste.FSaleInvoiceAmount+are.FRecievePayAmount AS INM ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ste.FSaleInvoiceBaseQty-are.FBaseQty AS IBQ,");
            sql.append("CASE WHEN ste.FUnitID=are.FMeasureUnitID THEN ste.FSaleInvoiceQty-are.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((ste.FSaleInvoiceBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
            sql.append("ste.FSaleInvoiceAmount-are.FRecievePayAmount AS INM ");
        }
        sql.append("FROM T_IM_StockTransferBillEntry ste ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FCoreBillEntryId=ste.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ste.FMaterialID AND mmu.FMeasureUnitID=ste.FUnitID ");
        sql.append("WHERE ");
        sql.append("T_IM_StockTransferBillEntry.FID=ste.FID)");
        return sql.toString();
    }

    public static String getAR2SOTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryId VARCHAR(44),");
        sql.append("FMeasureUnitID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQuantity DECIMAL(21,8),");
        sql.append("FRecievePayAmount DECIMAL(17,4))");
        return sql.toString();
    }

    public static String getAR2CITempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FID VARCHAR(44),");
        sql.append("FEntryId VARCHAR(44),");
        sql.append("FConfirmQty DECIMAL(21,8),");
        sql.append("FConfirmBaseQty DECIMAL(21,8),");
        sql.append("FConfirmDate DATETIME)");
        return sql.toString();
    }

    public static String getAR2SOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AR_OtherBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID,FBaseUnitID ");
        return sql.toString();
    }

    public static String getAR2CIInsertTempSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append(" SELECT CIC.FSOURCEBILLID, CIC.FSOURCEBILLENTRYID, CIC.FQTY, CIC.FBASEQTY,CIP.FAUDITTIME ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append(" SELECT CIC.FSOURCEBILLID, CIC.FSOURCEBILLENTRYID, CSC.FCONFIRMQTY-CIC.FQTY AS FQTY, CSC.FCONFIRMBASEQTY-CIC.FBASEQTY AS FBASEQTY,CIP.FAUDITTIME ");
        }
        sql.append(" FROM T_CHA_CHANNELINWAREHSBILLENTRY CIC INNER JOIN T_CHA_CHANNELINWAREHSBILL CIP ");
        sql.append(" ON CIC.FPARENTID = CIP.FID ");
        sql.append(" INNER JOIN T_CHA_CHANNELSALEISSUEENTRY CSC ");
        sql.append(" ON CSC.FID = CIC.FSOURCEBILLENTRYID AND CSC.FPARENTID = CIC.FSOURCEBILLID ");
        sql.append(" WHERE CIC.FPARENTID IN (");
        sql.append(idList);
        sql.append(")");
        return sql.toString();
    }

    public static String getAR2SITempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryId VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQuantity DECIMAL(21,8),");
        sql.append("FAssociateQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getAR2SIInsertTempSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append(" SELECT are.FParentID,are.FSourceBillEntryId,sie.FDrewBaseQty+sum(are.FBaseQty) AS IBQ,");
            sql.append("sie.FDrewQty+sum(CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN are.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END) AS QTY,");
            sql.append("sie.FAssociateQty-sum(are.FBaseQty) AS UIQ ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append(" SELECT are.FParentID,are.FSourceBillEntryId,sie.FDrewBaseQty-sum(are.FBaseQty) AS IBQ,");
            sql.append("sie.FDrewQty-sum(CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN are.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END) AS QTY,");
            sql.append("sie.FAssociateQty+sum(are.FBaseQty) AS UIQ ");
        }
        sql.append("FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=sie.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
        sql.append("WHERE are.FParentID IN (");
        sql.append(idList);
        sql.append(") group by are.FParentID,are.FSourceBillEntryId,sie.FDrewBaseQty,sie.FDrewQty,sie.FAssociateQty");
        return sql.toString();
    }

    public static String getAR2IC2SIInsertTempSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append(" SELECT are.FParentID,arice.FSourceBillEntryId,sie.FDrewBaseQty+are.FBaseQty AS IBQ,");
            sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty+are.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
            sql.append("sie.FAssociateQty-are.FBaseQty AS UIQ ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append(" SELECT are.FParentID,arice.FSourceBillEntryId,sie.FDrewBaseQty-are.FBaseQty AS IBQ,");
            sql.append("CASE WHEN sie.FUnitID=are.FMeasureUnitID THEN sie.FDrewQty-are.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((sie.FDrewBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
            sql.append("sie.FAssociateQty+are.FBaseQty AS UIQ ");
        }
        sql.append("FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
        sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=arice.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
        sql.append("WHERE are.FParentID IN (");
        sql.append(idList);
        sql.append(") ");
        return sql.toString();
    }

    public static String createARWriteBackVerifySQL(String idList, boolean[] isWriteCore, String temptable, boolean isArQtyGtSoSysParam, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, ar.FNumber, are.FSeq, si.FNumber as FWBNumber, sie.FSeq as FWBSeq ");
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_IM_SaleIssueBill si ON si.FID=sie.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND ABS(are.FbaseQty)-ABS(sie.FbaseQty)+ABS(sie.FDrewBaseQty) > 0 ");
            } else {
                sql.append("AND ABS(sie.FbaseQty)<ABS(sie.FDrewBaseQty) ");
            }
        }
        if (isWriteCore[1]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 2 as FErrType, ar.FNumber, are.FSeq, so.FNumber as FWBNumber, soe.FSeq as FWBSeq FROM T_SD_SaleOrderEntry soe ");
            sql.append("INNER JOIN T_SD_SaleOrder so ON so.FID=soe.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=soe.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                if (isArQtyGtSoSysParam) {
                    sql.append("AND (1=0) ");
                } else {
                    sql.append("AND are.FCoreBillEntryId IN( ");
                    sql.append("SELECT are.FCoreBillEntryId ");
                    sql.append("FROM ");
                    sql.append(temptable);
                    sql.append(" are ");
                    sql.append("INNER JOIN T_SD_SaleOrderEntry soe ON are.FCoreBillEntryId = soe.FID ");
                    sql.append("WHERE ");
                    sql.append("(ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) >= ABS(soe.FTotalIssueBaseQty) AND ABS(are.FbaseQty) >ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) - ABS(soe.FTolInvoidBaseQty)) ");
                    sql.append(" ) ");
                }
            } else if (isArQtyGtSoSysParam) {
                sql.append("AND (1=0) ");
            } else {
                sql.append("AND ");
                sql.append("(ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) >= ABS(soe.FTotalIssueBaseQty) AND ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) < ABS(soe.FTolInvoidBaseQty)) ");
            }
            sql.append("UNION ALL ");
            sql.append("SELECT 2 as FErrType, ar.FNumber, are.FSeq, so.FNumber as FWBNumber, soe.FSeq as FWBSeq FROM T_SD_SaleOrderEntry soe ");
            sql.append("INNER JOIN T_SD_SaleOrder so ON so.FID=soe.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=soe.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                if (isArQtyGtSoSysParam) {
                    sql.append("AND (1=0) ");
                } else {
                    sql.append("AND are.FCoreBillEntryId IN( ");
                    sql.append("SELECT are.FCoreBillEntryId ");
                    sql.append("FROM ");
                    sql.append(temptable);
                    sql.append(" are ");
                    sql.append("INNER JOIN T_SD_SaleOrderEntry soe ON are.FCoreBillEntryId = soe.FID ");
                    sql.append("WHERE ");
                    sql.append("(ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) < ABS(soe.FTotalIssueBaseQty) AND ABS(are.FbaseQty) > ABS(soe.FTotalIssueBaseQty) - ABS(soe.FTolInvoidBaseQty)) ");
                    sql.append(" ) ");
                }
            } else if (isArQtyGtSoSysParam) {
                sql.append("AND (1=0) ");
            } else {
                sql.append("AND ");
                sql.append("(ABS(soe.FBaseQty) - ABS(soe.FTotalReversedBaseQty) < ABS(soe.FTotalIssueBaseQty) AND ABS(soe.FTotalIssueBaseQty) < ABS(soe.FTolInvoidBaseQty)) ");
            }
        }
        if (isWriteCore[2]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 3 as FErrType, ar.FNumber, are.FSeq, sr.FNumber as FWBNumber, sre.FSeq as FWBSeq ");
            sql.append("FROM T_SD_SaleReturnsEntry sre ");
            sql.append("INNER JOIN T_SD_SaleReturns sr ON sr.FID=sre.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=sre.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID IN (");
            sql.append(idList);
            sql.append(") ");
            sql.append(" AND sre.FQuantityUnCtrl = 0 ");
            if (isBefore) {
                sql.append("AND are.FCoreBillEntryId IN( ");
                sql.append("SELECT are.FCoreBillEntryId ");
                sql.append("FROM  ");
                sql.append(temptable);
                sql.append(" are ");
                sql.append("INNER JOIN T_SD_SaleReturnsEntry sre ON are.FCoreBillEntryId = sre.FID ");
                sql.append("WHERE ");
                sql.append("ABS(are.FbaseQty)>ABS(sre.FbaseQty)-ABS(sre.FInvoicedBaseQty) )");
            } else {
                sql.append("AND ");
                sql.append("ABS(sre.FbaseQty)<ABS(sre.FInvoicedBaseQty)");
            }
        }
        if (isWriteCore[3]) {
            if (sql.length() > 0) {
                sql.append("UNION ALL ");
            }
            sql.append("SELECT 4 as FErrType, ar.FNumber, are.FSeq, st.FNumber as FWBNumber, ste.FSeq as FWBSeq ");
            sql.append("FROM T_IM_StockTransferBillEntry ste ");
            sql.append("INNER JOIN T_IM_StockTransferBill st ON st.FID=ste.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillEntry are ON are.FCoreBillEntryId=ste.FID ");
            sql.append("INNER JOIN T_AR_OtherBill ar ON ar.FID=are.FParentID ");
            sql.append("WHERE ar.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND are.FCoreBillEntryId IN( ");
                sql.append("SELECT are.FCoreBillEntryId ");
                sql.append("FROM   ");
                sql.append(temptable);
                sql.append(" are ");
                sql.append("INNER JOIN T_IM_StockTransferBillEntry ste ON are.FCoreBillEntryId = ste.FID ");
                sql.append("WHERE ");
                sql.append("ABS(are.FbaseQty)>ABS(ste.FbaseQty)-ABS(ste.FPurInvoiceBaseQty))");
            } else {
                sql.append("AND ");
                sql.append("ABS(ste.FbaseQty)<ABS(ste.FPurInvoiceBaseQty)");
            }
        }
        return sql.toString();
    }

    public static String getKeyIdList(String[] ids) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("'").append(ids[i]).append("'");
        }
        return sql.toString();
    }

    public static String getSR2SRTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FAuditBaseQty DECIMAL(21,8),");
        sql.append("FAuditQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getSR2SRInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,SUM(FAuditBaseQty) AS FAuditBaseQty, SUM(FAuditQty) AS FAuditQty ");
        sql.append("FROM T_IM_StockReqEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID ");
        return sql.toString();
    }

    public static String createSR2SRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockReqEntry AS T1 SET ");
        sql.append("(FTotalStockBaseQty, FTotalStockQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty+are.FAuditBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty+are.FAuditQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty+are.FAuditBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty-are.FAuditBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty-are.FAuditBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty-are.FAuditQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty-are.FAuditBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty+are.FAuditBaseQty ");
        }
        sql.append("FROM T_IM_StockReqEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=sre.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }

    public static String createTOWriteBackVerifySQL(String idList, boolean[] isWriteCore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT distinct 1 as FErrType,so.FNumber as soNumber,soEntry.FSeq as soSeq,tob.FNumber as toNumber,toEntry.FSeq as toSeq,");
            sql.append("round(ABS(soEntry.FTotalUnIssueBaseQty + round(DECIMAL(soEntry.FBaseQty * FSendOverRate / 100,21,8),mmu.FQtyPrecision))/cmmu.FBaseConvsRate,cmmu.FQtyPrecision) as overQty ");
            sql.append("FROM T_SD_SaleOrderEntry soEntry ");
            sql.append("INNER JOIN T_SD_SaleOrder so ON so.FID = soEntry.FParentID ");
            sql.append("INNER JOIN T_IM_TransferOrderBillEntry toEntry ON toEntry.FSaleOrderEntryID = soEntry.FID ");
            sql.append("INNER JOIN T_IM_TransferOrderBill tob ON tob.FID = toEntry.FParentID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMeasureUnitID = soEntry.FBaseUnitId and soEntry.FMaterialId = mmu.FMaterialId ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit cmmu ON cmmu.FMeasureUnitID = toEntry.FUnitId and toEntry.FMaterialId = cmmu.FMaterialId ");
            sql.append("WHERE toEntry.FSaleOrderEntryID is not null AND toEntry.FSupplyType = ");
            sql.append(4).append(" ");
            sql.append("AND soEntry.FQuantityUnCtrl = 0 ");
            sql.append("AND (soEntry.FTotalUnIssueBaseQty + round(DECIMAL(soEntry.FBaseQty * FSendOverRate / 100,21,8),mmu.FQtyPrecision))< 0 ");
            sql.append("AND tob.FID IN(");
            sql.append(idList);
            sql.append(")");
        }
        return sql.toString();
    }

    public static String createSRWriteBackVerifySQL(String idList, boolean[] isWriteCore, String temptable, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_StockReqEntry srcEntry ");
            sql.append("INNER JOIN T_IM_StockReq src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_StockReqEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_StockReq dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND ABS(srcEntry.FTotalStockBaseQty)-ABS(srcEntry.FAuditBaseQty) >= 0 ");
            } else {
                sql.append("AND ABS(srcEntry.FTotalStockBaseQty)-ABS(srcEntry.FAuditBaseQty)-ABS(destEntry.FAuditBaseQty) >= 0 ");
            }
        } else if (isWriteCore[1]) {
            sql.append("SELECT 2 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_StockReqEntry srcEntry ");
            sql.append("INNER JOIN T_IM_StockReq src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_SM_PurOrderEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_SM_PurOrder dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND ABS(srcEntry.FTotalStockBaseQty)-ABS(srcEntry.FAuditBaseQty) >= 0 ");
            } else {
                sql.append("AND ABS(srcEntry.FTotalStockBaseQty)-ABS(srcEntry.FAuditBaseQty)-ABS(destEntry.FBaseQty) >= 0 ");
            }
        } else if (isWriteCore[2]) {
            sql.append("SELECT 3 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_StockReqEntry srcEntry ");
            sql.append("INNER JOIN T_IM_StockReq src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_SD_SaleOrderEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_SD_SaleOrder dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND ABS(srcEntry.FTotalStockBaseQty)-ABS(srcEntry.FAuditBaseQty) >= 0 ");
            } else {
                sql.append("AND ABS(srcEntry.FTotalStockBaseQty)-ABS(srcEntry.FAuditBaseQty)-ABS(destEntry.FBaseQty) >= 0 ");
            }
        }
        return sql.toString();
    }

    public static void verifyTOWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        if (rs.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String tab = "        ";
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.TRANSFERORDER2SALEORDER_ERROR")).append("\n");
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.TRANSFERORDERNO")).append(tab);
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(tab);
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.WBNO")).append(tab + tab);
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(tab);
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.OVERQTY")).append("\n");
            while (rs.next()) {
                sql.append(rs.getString("toNumber")).append(tab);
                sql.append(rs.getInt("toSeq")).append(tab);
                switch (rs.getInt("FErrType")) {
                    case 1: {
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SALEORDERNO"));
                    }
                }
                sql.append(":").append(rs.getString("soNumber")).append(tab);
                sql.append(rs.getInt("soSeq")).append(tab);
                sql.append(rs.getBigDecimal("overQty").setScale(6, 4)).append("\n");
            }
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static void verifySRWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.STOCKREQ_WBERROR")).append("\n");
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.STOCKREQNO")).append("\t").append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append("\t").append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.WBNO")).append("\t\t").append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append("\n");
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            sql.append(rs.getString("destNumber"));
            sql.append("\t");
            sql.append(rs.getInt("destSeq")).append("\t");
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.STOCKREQ"));
                    break;
                }
                case 2: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.PURORDER"));
                    break;
                }
                case 3: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SALEORDER"));
                }
            }
            sql.append(":").append(rs.getString("srcNumber")).append("\t\t");
            sql.append(rs.getInt("srcSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String getPO2SRTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getPO2SRInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQty) AS FQty ");
        sql.append("FROM T_SM_PurOrderEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID ");
        return sql.toString();
    }

    public static String createPO2SRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockReqEntry AS T1 SET ");
        sql.append("(FTotalStockBaseQty, FTotalStockQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty+are.FBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty+are.FQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty-are.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty-are.FBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty-are.FQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty+are.FBaseQty ");
        }
        sql.append("FROM T_IM_StockReqEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=sre.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }

    public static String getSO2SRTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getSO2SRInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQty) AS FQty ");
        sql.append("FROM T_SD_SaleOrderEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID ");
        return sql.toString();
    }

    public static String createSO2SRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockReqEntry AS T1 SET ");
        sql.append("(FTotalStockBaseQty, FTotalStockQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty+are.FBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty+are.FQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty-are.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty-are.FBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty-are.FQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty+are.FBaseQty ");
        }
        sql.append("FROM T_IM_StockReqEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=sre.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }

    public static String getTO2SRTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getTO2SRInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQty) AS FQty ");
        sql.append("FROM T_IM_TransferOrderBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID ");
        return sql.toString();
    }

    public static String createTO2SRWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockReqEntry AS T1 SET ");
        sql.append("(FTotalStockBaseQty, FTotalStockQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty+are.FBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty+are.FQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty-are.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT sre.FTotalStockBaseQty-are.FBaseQty,");
            sql.append("CASE WHEN sre.FUnitID=are.FUnitID THEN sre.FTotalStockQty-are.FQty ");
            sql.append("ELSE ROUND(DECIMAL((sre.FTotalStockBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("sre.FAssociateQty+are.FBaseQty ");
        }
        sql.append("FROM T_IM_StockReqEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=sre.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }

    public static String getSR2PLOTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE KSQL_TEMP_0 ");
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getSR2PLOTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tempTable);
        sql.append(" (FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getSR2PLOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,SUM(FAuditBaseQty) AS FBaseQty, SUM(FAuditQty) AS FQty ");
        sql.append("FROM T_IM_StockReqEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID ");
        return sql.toString();
    }

    public static String createSR2PLOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strConvertDate = df.format(new Date());
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_PlanOrderEntry AS T1 SET ");
        sql.append("(FTotalReqBaseQty, FTotalReqQty, FAssociateQty, FConvertDate, FBaseStatus)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append(" (SELECT ploe.FTotalReqBaseQty+are.FBaseQty,");
            sql.append(" CASE WHEN ploe.FUnitID=are.FUnitID THEN ploe.FTotalReqQty+are.FQty ");
            sql.append(" ELSE ROUND(DECIMAL((ploe.FTotalReqBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append(" ploe.FAssociateQty-are.FBaseQty, ");
            sql.append(" TO_DATE('").append(strConvertDate).append("'),");
            sql.append("CASE WHEN ploe.FAssociateQty <= are.FBaseQty THEN ").append(7);
            sql.append(" ELSE ").append(5).append(" END");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append(" (SELECT ploe.FTotalReqBaseQty-are.FBaseQty,");
            sql.append(" CASE WHEN ploe.FUnitID=are.FUnitID THEN ploe.FTotalReqQty-are.FQty ");
            sql.append(" ELSE ROUND(DECIMAL((ploe.FTotalReqBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append("ploe.FAssociateQty+are.FBaseQty, ");
            sql.append(" null,");
            sql.append(5);
        }
        sql.append(" FROM T_IM_PlanOrderEntry ploe ");
        sql.append(" INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=ploe.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ploe.FMaterialID AND mmu.FMeasureUnitID=ploe.FUnitID ");
        sql.append(" WHERE ");
        sql.append(" T1.FID=ploe.FID)");
        return sql.toString();
    }

    public static String createPLOWriteBackVerifySQL(String idList, boolean[] isWriteCore, String temptable, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_PlanOrderEntry srcEntry ");
            sql.append("INNER JOIN T_IM_PlanOrder src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_StockReqEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_StockReq dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND srcEntry.FAssociateQty-destEntry.FBaseQty < 0 ");
            } else {
                sql.append("AND srcEntry.FAssociateQty < 0 ");
            }
        } else if (isWriteCore[1]) {
            sql.append("SELECT 2 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_IM_PlanOrderEntry srcEntry ");
            sql.append("INNER JOIN T_IM_PlanOrder src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_SM_PurRequestEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_SM_PurRequest dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append("AND srcEntry.FAssociateQty-destEntry.FBaseQty < 0 ");
            } else {
                sql.append("AND srcEntry.FAssociateQty < 0 ");
            }
        }
        return sql.toString();
    }

    public static void verifyPLOWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        StringBuffer sql = new StringBuffer();
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.scm.common.WBResource.PLANORDER_WBERROR", (Locale)ctx.getOriginLocale())).append("\n");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.scm.common.WBResource.PLANORDERNO", (Locale)ctx.getOriginLocale())).append("\t\b\b\b\b");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO", (Locale)ctx.getOriginLocale())).append("\n");
        boolean isError = false;
        while (rs.next()) {
            isError = true;
            sql.append(rs.getString("srcNumber")).append("\t\b\b\b\b");
            sql.append(rs.getInt("srcSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String getPR2PLOTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE KSQL_TEMP_0 ");
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getPR2PLOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQty) AS FQty ");
        sql.append("FROM T_SM_PurRequestEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID ");
        return sql.toString();
    }

    public static String createPR2PLOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strConvertDate = df.format(new Date());
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_PlanOrderEntry AS T1 SET ");
        sql.append("(FTotalReqBaseQty, FTotalReqQty, FAssociateQty, FConvertDate, FBaseStatus)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append(" (SELECT ploe.FTotalReqBaseQty+are.FBaseQty,");
            sql.append(" CASE WHEN ploe.FUnitID=are.FUnitID THEN ploe.FTotalReqQty+are.FQty ");
            sql.append(" ELSE ROUND(DECIMAL((ploe.FTotalReqBaseQty+are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append(" ploe.FAssociateQty-are.FBaseQty, ");
            sql.append(" TO_DATE('").append(strConvertDate).append("'),");
            sql.append("CASE WHEN ploe.FAssociateQty <= are.FBaseQty THEN ").append(7);
            sql.append(" ELSE ").append(5).append(" END");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append(" (SELECT ploe.FTotalReqBaseQty-are.FBaseQty,");
            sql.append(" CASE WHEN ploe.FUnitID=are.FUnitID THEN ploe.FTotalReqQty-are.FQty ");
            sql.append(" ELSE ROUND(DECIMAL((ploe.FTotalReqBaseQty-are.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END, ");
            sql.append(" ploe.FAssociateQty+are.FBaseQty, ");
            sql.append(" ploe.FConvertDate,");
            sql.append(5);
        }
        sql.append(" FROM T_IM_PlanOrderEntry ploe ");
        sql.append(" INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=ploe.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=ploe.FMaterialID AND mmu.FMeasureUnitID=ploe.FUnitID ");
        sql.append(" WHERE ");
        sql.append(" T1.FID=ploe.FID)");
        return sql.toString();
    }

    public static String createICSIWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_SaleIssueEntry upd SET (FTotalIncomeConfirmBaseQty,FTotalIncomeConfirmQty)= ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT sie.FTotalIncomeConfirmBaseQty+arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN sie.FUnitID=arice.FMeasureUnitID THEN sie.FTotalIncomeConfirmQty+arice.FQuantity ");
                sql.append("ELSE ROUND((sie.FTotalIncomeConfirmBaseQty+arice.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT sie.FTotalIncomeConfirmBaseQty-arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN sie.FUnitID=arice.FMeasureUnitID THEN sie.FTotalIncomeConfirmQty-arice.FQuantity ");
                sql.append("ELSE ROUND((sie.FTotalIncomeConfirmBaseQty-arice.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY ");
            }
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
            sql.append("WHERE arice.FParentID= ? ");
            sql.append("AND upd.FID=sie.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_IncomeConfimEntry arice WHERE arice.FSourceBillEntryId=upd.FID ");
            sql.append("AND arice.FParentID= ? ) ");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_IM_SaleIssueEntry upd SET (FTotalIncomeConfirmBaseQty,FTotalIncomeConfirmQty)= ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT sie.FTotalIncomeConfirmBaseQty+arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN sie.FUnitID=arice.FMeasureUnitID THEN sie.FTotalIncomeConfirmQty+arice.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((sie.FTotalIncomeConfirmBaseQty+arice.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT sie.FTotalIncomeConfirmBaseQty-arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN sie.FUnitID=arice.FMeasureUnitID THEN sie.FTotalIncomeConfirmQty-arice.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((sie.FTotalIncomeConfirmBaseQty-arice.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY");
            }
            sql.append("FROM T_IM_SaleIssueEntry sie ");
            sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
            sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
            sql.append("WHERE arice.FParentID= ? ");
            sql.append("AND upd.FID=sie.FID) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_IncomeConfimEntry arice WHERE arice.FSourceBillEntryId=upd.FID ");
            sql.append("AND arice.FParentID= ? ) ");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_IM_SaleIssueEntry SET FTotalIncomeConfirmBaseQty = sie.FTotalIncomeConfirmBaseQty + arice.FBaseQty,");
            sql.append("FTotalIncomeConfirmQty = CASE  WHEN sie.FUnitID = arice.FMeasureUnitID THEN (sie.FTotalIncomeConfirmQty + arice.FQuantity) ");
            sql.append("ELSE ROUND(((sie.FTotalIncomeConfirmBaseQty + arice.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_IM_SaleIssueEntry SET FTotalIncomeConfirmBaseQty = sie.FTotalIncomeConfirmBaseQty - arice.FBaseQty,");
            sql.append("FTotalIncomeConfirmQty = CASE  WHEN sie.FUnitID = arice.FMeasureUnitID THEN (sie.FTotalIncomeConfirmQty - arice.FQuantity) ");
            sql.append("ELSE ROUND(((sie.FTotalIncomeConfirmBaseQty - arice.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END");
        }
        sql.append("FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId = sie.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = sie.FMaterialID AND mmu.FMeasureUnitID = sie.FUnitID) ");
        sql.append("WHERE (arice.FParentID = ? AND T_IM_SaleIssueEntry.FID = sie.FID) ");
        return sql.toString();
    }

    public static String createIC2SOWriteSQLDialect(BizActionEnum bizAction, Context ctx) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isOracle(ctx) || KsqlUtil.isDM(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_SD_SaleOrderEntry upd SET ");
            sql.append("(FTotalIncomeConfirmBaseQty,FTotalIncomeConfirmQty,FTotalIncomeConfirmAmount)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT soe.FTotalIncomeConfirmBaseQty+arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN soe.FUnitID=arice.FMeasureUnitID THEN soe.FTotalIncomeConfirmQty+arice.FQuantity ");
                sql.append("ELSE ROUND((soe.FTotalIncomeConfirmBaseQty+arice.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FTotalIncomeConfirmAmount+arice.FIncomeConfimAmount AS ICM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT soe.FTotalIncomeConfirmBaseQty-arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN soe.FUnitID=arice.FMeasureUnitID THEN soe.FTotalIncomeConfirmQty-arice.FQuantity ");
                sql.append("ELSE ROUND((soe.FTotalIncomeConfirmBaseQty-arice.FBaseQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FTotalIncomeConfirmAmount-arice.FIncomeConfimAmount AS ICM ");
            }
            sql.append("FROM T_SD_SaleOrderEntry soe ");
            sql.append(" INNER JOIN T_SD_SaleOrder so ON so.FId=soe.FParentId ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FIncomeConfimAmount) AS FIncomeConfimAmount ");
            sql.append("FROM T_AR_IncomeConfimEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("arice ON arice.FCoreBillEntryId=soe.FID ");
            sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
            sql.append(" INNER JOIN T_AR_IncomeConfimBill ar ON arice.FParentId=ar.FID ");
            sql.append("WHERE arice.FParentID=? ");
            sql.append("AND upd.FID=soe.FID AND ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_IncomeConfimEntry arice ");
            sql.append("WHERE upd.FID=arice.FCoreBillEntryId ");
            sql.append("AND arice.FParentID=? )");
            return sql.toString();
        }
        if (KsqlUtil.isDB2(ctx)) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE T_SD_SaleOrderEntry upd SET ");
            sql.append("(FTotalIncomeConfirmBaseQty,FTotalIncomeConfirmQty,FAssociateQty,FTotalIncomeConfirmAmount)=");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append("(SELECT soe.FTotalIncomeConfirmBaseQty+arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN soe.FUnitID=arice.FMeasureUnitID THEN soe.FTotalIncomeConfirmQty+arice.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((soe.FTotalIncomeConfirmBaseQty+arice.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FTotalIncomeConfirmAmount+arice.FIncomeConfimAmount AS ICM ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append("(SELECT soe.FTotalIncomeConfirmBaseQty-arice.FBaseQty AS BQTY,");
                sql.append("CASE WHEN soe.FUnitID=arice.FMeasureUnitID THEN soe.FTotalIncomeConfirmQty-arice.FQuantity ");
                sql.append("ELSE ROUND(DECIMAL((soe.FTotalIncomeConfirmBaseQty-arice.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY,");
                sql.append("soe.FTotalIncomeConfirmAmount-arice.FIncomeConfimAmount AS ICM ");
            }
            sql.append("FROM T_SD_SaleOrderEntry soe ");
            sql.append(" INNER JOIN T_SD_SaleOrder so ON so.FId=soe.FParentId ");
            sql.append("INNER JOIN ");
            sql.append("(SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
            sql.append("SUM(FIncomeConfimAmount) AS FIncomeConfimAmount ");
            sql.append("FROM T_AR_IncomeConfimEntry WHERE FParentID=? GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID) ");
            sql.append("arice ON arice.FCoreBillEntryId=soe.FID ");
            sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=soe.FMaterialID AND mmu.FMeasureUnitID=soe.FUnitID ");
            sql.append(" INNER JOIN T_AR_IncomeConfimBill ar ON arice.FParentId=ar.FID ");
            sql.append("WHERE arice.FParentID=? ");
            sql.append("AND upd.FID=soe.FID AND ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ) ");
            sql.append("WHERE EXISTS(SELECT 0 ");
            sql.append("FROM T_AR_IncomeConfimEntry arice ");
            sql.append("WHERE upd.FID=arice.FCoreBillEntryId ");
            sql.append("AND arice.FParentID=? )");
            return sql.toString();
        }
        sql.append("/*dialect*/ ");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("UPDATE T_SD_SaleOrderEntry SET FTotalIncomeConfirmBaseQty = soe.FTotalIncomeConfirmBaseQty + arice.FBaseQty, ");
            sql.append("FTotalIncomeConfirmQty = CASE  WHEN soe.FUnitID = arice.FMeasureUnitID THEN (soe.FTotalIncomeConfirmQty + arice.FQuantity) ");
            sql.append("ELSE ROUND(((soe.FTotalIncomeConfirmBaseQty + arice.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END, ");
            sql.append("FTotalIncomeConfirmAmount = soe.FTotalIncomeConfirmAmount + arice.FIncomeConfimAmount ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("UPDATE T_SD_SaleOrderEntry SET FTotalIncomeConfirmBaseQty = soe.FTotalIncomeConfirmBaseQty - arice.FBaseQty, ");
            sql.append("FTotalIncomeConfirmQty = CASE  WHEN soe.FUnitID = arice.FMeasureUnitID THEN (soe.FTotalIncomeConfirmQty - arice.FQuantity) ");
            sql.append("ELSE ROUND(((soe.FTotalIncomeConfirmBaseQty - arice.FBaseQty) / mmu.FBaseConvsRate), mmu.FQtyPrecision) END, ");
            sql.append("FTotalIncomeConfirmAmount = soe.FTotalIncomeConfirmAmount - arice.FIncomeConfimAmount ");
        }
        sql.append("FROM T_SD_SaleOrderEntry soe ");
        sql.append(" INNER JOIN T_SD_SaleOrder so ON so.FId=soe.FParentId ");
        sql.append("INNER JOIN (SELECT FParentID, FCoreBillEntryId, FMeasureUnitID, SUM(FBaseQty) FBASEQTY, ");
        sql.append("SUM(FQuantity) FQUANTITY, SUM(FIncomeConfimAmount) FRECIEVEPAYAMOUNT ");
        sql.append("FROM T_AR_IncomeConfimEntry WHERE FParentID = ? ");
        sql.append("GROUP BY FParentID, FCoreBillEntryId, FMeasureUnitID) ");
        sql.append("arice ON arice.FCoreBillEntryId = soe.FID ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON (mmu.FMaterialID = soe.FMaterialID AND mmu.FMeasureUnitID = soe.FUnitID) ");
        sql.append("WHERE (arice.FParentID = ? AND T_SD_SaleOrderEntry.FID = soe.FID AND ((so.FIsCentralBalance = 1 and ar.FCompanyId = so.FCompanyOrgUnitID) or (so.FIsCentralBalance = 0 and ar.FCompanyId = soe.FCompanyOrgUnitID)) ) ");
        return sql.toString();
    }

    public static String getIC2SOTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryId VARCHAR(44),");
        sql.append("FMeasureUnitID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQuantity DECIMAL(21,8),");
        sql.append("FIncomeConfimAmount DECIMAL(17,4))");
        return sql.toString();
    }

    public static String getIC2SOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryId,FMeasureUnitID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQuantity,");
        sql.append("SUM(FIncomeConfimAmount) AS FIncomeConfimAmount ");
        sql.append("FROM T_AR_INCOMECONFIMENTRY WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryId,FMeasureUnitID,FBaseUnitID ");
        return sql.toString();
    }

    public static String getIC2SITempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryId VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQuantity DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getIC2SIInsertTempSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append(" SELECT arice.FParentID,arice.FSourceBillEntryId,sie.FTotalIncomeConfirmBaseQty+arice.FBaseQty AS BQTY,");
            sql.append("CASE WHEN sie.FUnitID=arice.FMeasureUnitID THEN sie.FTotalIncomeConfirmQty+arice.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((sie.FTotalIncomeConfirmBaseQty+arice.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append(" SELECT arice.FParentID,arice.FSourceBillEntryId,sie.FTotalIncomeConfirmBaseQty-arice.FBaseQty AS BQTY,");
            sql.append("CASE WHEN sie.FUnitID=arice.FMeasureUnitID THEN sie.FTotalIncomeConfirmQty-arice.FQuantity ");
            sql.append("ELSE ROUND(DECIMAL((sie.FTotalIncomeConfirmBaseQty-arice.FBaseQty)/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END AS QTY");
        }
        sql.append(" FROM T_IM_SaleIssueEntry sie ");
        sql.append("INNER JOIN T_AR_IncomeConfimEntry arice ON arice.FSourceBillEntryId=sie.FID ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sie.FMaterialID AND mmu.FMeasureUnitID=sie.FUnitID ");
        sql.append("WHERE arice.FParentID IN (");
        sql.append(idList);
        sql.append(") ");
        return sql.toString();
    }
}

