/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.verify;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.scm.common.util.StringListMap;
import com.kingdee.eas.scm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.scm.common.verify.BatchVerifyItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableVerifyItem
extends AbstractVerifyItem {
    private List batchVerifyItems = new ArrayList();
    private Map columns = new HashMap();

    public TableVerifyItem(Component component) {
        super(component);
    }

    @Override
    protected boolean doVerify() throws Exception {
        return true;
    }

    @Override
    public boolean verify() throws Exception {
        Map materialMap = this.getMaterialMap();
        for (int i = 0; i < this.batchVerifyItems.size(); ++i) {
            BatchVerifyItem item = (BatchVerifyItem)this.batchVerifyItems.get(i);
            item.setMaterialMap(materialMap);
            item.setColumns(this.columns);
            if (item.verify()) continue;
            return false;
        }
        return super.verify();
    }

    public void addBatchVerifyItem(BatchVerifyItem item) {
        this.batchVerifyItems.add(item);
    }

    private Map getMaterialMap() {
        StringListMap materialMap = null;
        String colMaterial = (String)this.columns.get("MATERIAL");
        if (this.component instanceof KDTable && colMaterial != null) {
            KDTable table = (KDTable)this.component;
            materialMap = new StringListMap();
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow arow = table.getRow(i);
                MaterialInfo materialInfo = (MaterialInfo)arow.getCell(colMaterial).getValue();
                if (materialInfo == null) continue;
                materialMap.put(materialInfo.getId().toString(), new Integer(i + 1));
            }
        }
        return materialMap;
    }

    public void addColumnName(String column, String name) {
        this.columns.put(column, name);
    }

    public String getColumnName(String column) {
        return (String)this.columns.get(column);
    }
}

