/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.framework.validator.beanvalidation.DefaultPropertyValidationErrors;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationErrors;
import com.kingdee.util.StringUtils;
import java.util.List;

public class BeanPropertyValidationRule
implements IVRule {
    private String entryName;
    private List<IPropertyValidatorDescription> headerValidatorList;
    private List<IPropertyValidatorDescription> entryValidatorList;
    private String entry1Name;
    private String parent1Name;
    private List<IPropertyValidatorDescription> entry1ValidatorList;
    private Context ctx;

    public BeanPropertyValidationRule() {
        this(null);
    }

    public BeanPropertyValidationRule(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public void setInjectData(IDataCache injectData) {
    }

    @Override
    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        DefaultPropertyValidationErrors errors = new DefaultPropertyValidationErrors(this.ctx);
        this.doBillValidation(bean, errors);
        if (!StringUtils.isEmpty((String)this.entryName)) {
            this.doEntryValidation(bean, errors);
        }
        if (errors.hasErrors()) {
            throw errors.getErrorException();
        }
    }

    private void doBillValidation(IObjectValue bean, PropertyValidationErrors errors) {
        if (null == this.headerValidatorList || this.headerValidatorList.size() == 0) {
            return;
        }
        for (IPropertyValidatorDescription desc : this.headerValidatorList) {
            IPropertyValidator iVRule = desc.validator();
            PropertyValidationError error = iVRule.validate(bean, desc);
            if (null == error) continue;
            errors.addValidationError(error);
        }
    }

    private void doEntryValidation(IObjectValue bean, PropertyValidationErrors errors) {
        IObjectCollection entryCol = (IObjectCollection)bean.get(this.entryName);
        if (entryCol == null || entryCol.size() == 0) {
            return;
        }
        if (this.entryValidatorList == null || this.entryValidatorList.size() == 0) {
            return;
        }
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue entry = entryCol.getObject(i);
            if (null != entry) {
                entry.put("parent", (Object)bean);
            }
            for (IPropertyValidatorDescription desc : this.entryValidatorList) {
                IPropertyValidator iVRule = desc.validator();
                PropertyValidationError error = iVRule.validate(entry, desc);
                if (null == error) continue;
                error.setEntrySeq(i + 1);
                errors.addValidationError(error);
            }
            if (StringUtils.isEmpty((String)this.entry1Name)) continue;
            this.doEntry1Validation(entry, errors);
        }
    }

    private void doEntry1Validation(IObjectValue bean, PropertyValidationErrors errors) {
        IObjectCollection entryCol = (IObjectCollection)bean.get(this.entry1Name);
        if (entryCol == null || entryCol.size() == 0) {
            return;
        }
        if (this.entry1ValidatorList == null || this.entry1ValidatorList.size() == 0) {
            return;
        }
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue entry = entryCol.getObject(i);
            if (null != entry && !StringUtils.isEmpty((String)this.parent1Name)) {
                entry.put(this.parent1Name, (Object)bean);
            }
            for (IPropertyValidatorDescription desc : this.entry1ValidatorList) {
                IPropertyValidator iVRule = desc.validator();
                PropertyValidationError error = iVRule.validate(entry, desc);
                if (null == error) continue;
                error.setEntrySeq(i + 1);
                error.setParentSeq((Integer)bean.get("seq"));
                errors.addValidationError(error);
            }
        }
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public List<IPropertyValidatorDescription> getHeaderValidatorList() {
        return this.headerValidatorList;
    }

    public void setHeaderValidatorList(List<IPropertyValidatorDescription> headerValidatorList) {
        this.headerValidatorList = headerValidatorList;
    }

    public List<IPropertyValidatorDescription> getEntryValidatorList() {
        return this.entryValidatorList;
    }

    public void setEntryValidatorList(List<IPropertyValidatorDescription> entryValidatorList) {
        this.entryValidatorList = entryValidatorList;
    }

    public void setEntry1Name(String entry1Name) {
        this.entry1Name = entry1Name;
    }

    public String getEntry1Name() {
        return this.entry1Name;
    }

    public void setEntry1ValidatorList(List<IPropertyValidatorDescription> entry1ValidatorList) {
        this.entry1ValidatorList = entry1ValidatorList;
    }

    public List<IPropertyValidatorDescription> getEntry1ValidatorList() {
        return this.entry1ValidatorList;
    }

    public void setParent1Name(String parent1Name) {
        this.parent1Name = parent1Name;
    }

    public String getParent1Name() {
        return this.parent1Name;
    }
}

