/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.expression.LogicExpressions;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractPropertyValidator
implements IPropertyValidator {
    protected static final Logger logger = Logger.getLogger(AbstractPropertyValidator.class);

    protected Object getPropertyValue(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        assert (bean != null);
        assert (propertyDesc != null && propertyDesc.propertyName() != null && propertyDesc.propertyName().length() > 0);
        return bean.get(propertyDesc.propertyName().trim());
    }

    @Override
    public final PropertyValidationError validate(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        assert (bean != null);
        assert (propertyDesc != null);
        if (!this.when(bean, propertyDesc)) {
            return null;
        }
        return this.doValidation(bean, propertyDesc);
    }

    protected abstract PropertyValidationError doValidation(IObjectValue var1, IPropertyValidatorDescription var2);

    protected boolean when(IObjectValue bean, IPropertyValidatorDescription desc) {
        String when = desc.when();
        if (StringUtils.isEmpty((String)when)) {
            return true;
        }
        try {
            LogicExpressions parser = new LogicExpressions(when);
            return parser.getResult(bean);
        }
        catch (BOSException e) {
            logger.error((Object)"\u6267\u884c\u8868\u8fbe\u5f0f\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
    }

    protected PropertyValidationError getErrorInfo(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        PropertyValidationError result = new PropertyValidationError();
        result.setErrorType(this.errorType());
        result.setProperty(propertyDesc.propertyName());
        result.setErrResource(propertyDesc.errorResource());
        result.setBosType(bean.getBOSType());
        return result;
    }

    protected abstract PropertyValidationError.ERRORTYPE errorType();
}

