/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation.impl;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.DecimalNotEqualsValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.AbstractPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.ObjectTypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalNotEqualsValidator
extends AbstractPropertyValidator {
    @Override
    protected PropertyValidationError doValidation(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        DecimalNotEqualsValidatorDesc desc;
        Object fieldValue = this.getPropertyValue(bean, propertyDesc);
        if (null == fieldValue) {
            PropertyValidationError error = this.getErrorInfo(bean, propertyDesc);
            error.setErrorType(PropertyValidationError.ERRORTYPE.ISNULL);
            return error;
        }
        BigDecimal bigDecimal = null;
        if (ObjectTypeUtils.isBigDecimal(fieldValue)) {
            bigDecimal = (BigDecimal)fieldValue;
        } else if (ObjectTypeUtils.isBigInteger(fieldValue)) {
            bigDecimal = new BigDecimal((BigInteger)fieldValue);
        } else if (ObjectTypeUtils.isString(fieldValue)) {
            bigDecimal = new BigDecimal((String)fieldValue);
        } else if (ObjectTypeUtils.isByte(fieldValue)) {
            bigDecimal = new BigDecimal(((Byte)fieldValue).byteValue());
        } else if (ObjectTypeUtils.isShort(fieldValue)) {
            bigDecimal = new BigDecimal(((Short)fieldValue).shortValue());
        } else if (ObjectTypeUtils.isInteger(fieldValue)) {
            bigDecimal = new BigDecimal((Integer)fieldValue);
        } else if (ObjectTypeUtils.isLong(fieldValue)) {
            bigDecimal = new BigDecimal((Long)fieldValue);
        }
        if (bigDecimal != null && bigDecimal.compareTo((desc = (DecimalNotEqualsValidatorDesc)propertyDesc).getValue()) == 0) {
            PropertyValidationError error = this.getErrorInfo(bean, desc);
            error.setReplaceParam(new Object[]{fieldValue});
            return error;
        }
        return null;
    }

    @Override
    protected PropertyValidationError.ERRORTYPE errorType() {
        return PropertyValidationError.ERRORTYPE.DECIMALCANNTEQUALS;
    }
}

