/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation.impl;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.PatternValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.AbstractPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.ObjectTypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternValidator
extends AbstractPropertyValidator
implements IPropertyValidator {
    @Override
    protected PropertyValidationError doValidation(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        Object fieldValue = this.getPropertyValue(bean, propertyDesc);
        if (null == fieldValue) {
            PropertyValidationError error = this.getErrorInfo(bean, propertyDesc);
            error.setErrorType(PropertyValidationError.ERRORTYPE.ISNULL);
            return error;
        }
        if (ObjectTypeUtils.isString(fieldValue)) {
            String s = (String)fieldValue;
            PatternValidatorDesc desc = (PatternValidatorDesc)propertyDesc;
            Pattern p = Pattern.compile(desc.getRegexp(), desc.getFlags());
            Matcher matcher = p.matcher(s);
            if (!matcher.matches()) {
                return this.getErrorInfo(bean, desc);
            }
        }
        return null;
    }

    @Override
    protected PropertyValidationError.ERRORTYPE errorType() {
        return PropertyValidationError.ERRORTYPE.NOTPATTERN;
    }
}

